/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1;

public interface AllocationPolicyOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1.AllocationPolicy)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.LocationPolicy location = 1;</code>
   *
   * @return Whether the location field is set.
   */
  boolean hasLocation();

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.LocationPolicy location = 1;</code>
   *
   * @return The location.
   */
  com.google.cloud.batch.v1.AllocationPolicy.LocationPolicy getLocation();

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.LocationPolicy location = 1;</code>
   */
  com.google.cloud.batch.v1.AllocationPolicy.LocationPolicyOrBuilder getLocationOrBuilder();

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  java.util.List<com.google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate>
      getInstancesList();

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  com.google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate getInstances(int index);

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  int getInstancesCount();

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  java.util.List<
          ? extends com.google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>
      getInstancesOrBuilderList();

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  com.google.cloud.batch.v1.AllocationPolicy.InstancePolicyOrTemplateOrBuilder
      getInstancesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ServiceAccount service_account = 9;</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  boolean hasServiceAccount();

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ServiceAccount service_account = 9;</code>
   *
   * @return The serviceAccount.
   */
  com.google.cloud.batch.v1.ServiceAccount getServiceAccount();

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1.ServiceAccount service_account = 9;</code>
   */
  com.google.cloud.batch.v1.ServiceAccountOrBuilder getServiceAccountOrBuilder();

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.NetworkPolicy network = 7;</code>
   *
   * @return Whether the network field is set.
   */
  boolean hasNetwork();

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.NetworkPolicy network = 7;</code>
   *
   * @return The network.
   */
  com.google.cloud.batch.v1.AllocationPolicy.NetworkPolicy getNetwork();

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.NetworkPolicy network = 7;</code>
   */
  com.google.cloud.batch.v1.AllocationPolicy.NetworkPolicyOrBuilder getNetworkOrBuilder();

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.PlacementPolicy placement = 10;</code>
   *
   * @return Whether the placement field is set.
   */
  boolean hasPlacement();

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.PlacementPolicy placement = 10;</code>
   *
   * @return The placement.
   */
  com.google.cloud.batch.v1.AllocationPolicy.PlacementPolicy getPlacement();

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1.AllocationPolicy.PlacementPolicy placement = 10;</code>
   */
  com.google.cloud.batch.v1.AllocationPolicy.PlacementPolicyOrBuilder getPlacementOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the tags.
   */
  java.util.List<java.lang.String> getTagsList();

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of tags.
   */
  int getTagsCount();

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  java.lang.String getTags(int index);

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  com.google.protobuf.ByteString getTagsBytes(int index);
}
