/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * A Job's resource allocation policy describes when, where, and how compute
 * resources should be allocated for the Job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy}
 */
public final class AllocationPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy)
    AllocationPolicyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AllocationPolicy.newBuilder() to construct.
  private AllocationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AllocationPolicy() {
    instances_ = java.util.Collections.emptyList();
    instanceTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
    provisioningModels_ = java.util.Collections.emptyList();
    serviceAccountEmail_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AllocationPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.AllocationPolicy.class,
            com.google.cloud.batch.v1alpha.AllocationPolicy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Compute Engine VM instance provisioning model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel}
   */
  public enum ProvisioningModel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PROVISIONING_MODEL_UNSPECIFIED = 0;</code>
     */
    PROVISIONING_MODEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Standard VM.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    STANDARD(1),
    /**
     *
     *
     * <pre>
     * SPOT VM.
     * </pre>
     *
     * <code>SPOT = 2;</code>
     */
    SPOT(2),
    /**
     *
     *
     * <pre>
     * Preemptible VM (PVM).
     *
     * Above SPOT VM is the preferable model for preemptible VM instances: the
     * old preemptible VM model (indicated by this field) is the older model,
     * and has been migrated to use the SPOT model as the underlying technology.
     * This old model will still be supported.
     * </pre>
     *
     * <code>PREEMPTIBLE = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    PREEMPTIBLE(3),
    /**
     *
     *
     * <pre>
     * Bound to the lifecycle of the reservation in which it is provisioned.
     * </pre>
     *
     * <code>RESERVATION_BOUND = 4;</code>
     */
    RESERVATION_BOUND(4),
    /**
     *
     *
     * <pre>
     * Instance is provisioned with DWS Flex Start and has limited max run
     * duration.
     * </pre>
     *
     * <code>FLEX_START = 5;</code>
     */
    FLEX_START(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PROVISIONING_MODEL_UNSPECIFIED = 0;</code>
     */
    public static final int PROVISIONING_MODEL_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Standard VM.
     * </pre>
     *
     * <code>STANDARD = 1;</code>
     */
    public static final int STANDARD_VALUE = 1;

    /**
     *
     *
     * <pre>
     * SPOT VM.
     * </pre>
     *
     * <code>SPOT = 2;</code>
     */
    public static final int SPOT_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Preemptible VM (PVM).
     *
     * Above SPOT VM is the preferable model for preemptible VM instances: the
     * old preemptible VM model (indicated by this field) is the older model,
     * and has been migrated to use the SPOT model as the underlying technology.
     * This old model will still be supported.
     * </pre>
     *
     * <code>PREEMPTIBLE = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int PREEMPTIBLE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Bound to the lifecycle of the reservation in which it is provisioned.
     * </pre>
     *
     * <code>RESERVATION_BOUND = 4;</code>
     */
    public static final int RESERVATION_BOUND_VALUE = 4;

    /**
     *
     *
     * <pre>
     * Instance is provisioned with DWS Flex Start and has limited max run
     * duration.
     * </pre>
     *
     * <code>FLEX_START = 5;</code>
     */
    public static final int FLEX_START_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProvisioningModel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProvisioningModel forNumber(int value) {
      switch (value) {
        case 0:
          return PROVISIONING_MODEL_UNSPECIFIED;
        case 1:
          return STANDARD;
        case 2:
          return SPOT;
        case 3:
          return PREEMPTIBLE;
        case 4:
          return RESERVATION_BOUND;
        case 5:
          return FLEX_START;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProvisioningModel>() {
              public ProvisioningModel findValueByNumber(int number) {
                return ProvisioningModel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.AllocationPolicy.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProvisioningModel[] VALUES = values();

    public static ProvisioningModel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProvisioningModel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel)
  }

  public interface LocationPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @return A list containing the allowedLocations.
     */
    java.util.List<java.lang.String> getAllowedLocationsList();

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @return The count of allowedLocations.
     */
    int getAllowedLocationsCount();

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedLocations at the given index.
     */
    java.lang.String getAllowedLocations(int index);

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedLocations at the given index.
     */
    com.google.protobuf.ByteString getAllowedLocationsBytes(int index);

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @return A list containing the deniedLocations.
     */
    java.util.List<java.lang.String> getDeniedLocationsList();

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @return The count of deniedLocations.
     */
    int getDeniedLocationsCount();

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The deniedLocations at the given index.
     */
    java.lang.String getDeniedLocations(int index);

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the deniedLocations at the given index.
     */
    com.google.protobuf.ByteString getDeniedLocationsBytes(int index);
  }

  /** Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy} */
  public static final class LocationPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)
      LocationPolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use LocationPolicy.newBuilder() to construct.
    private LocationPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LocationPolicy() {
      allowedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      deniedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LocationPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LocationPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LocationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder.class);
    }

    public static final int ALLOWED_LOCATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowedLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @return A list containing the allowedLocations.
     */
    public com.google.protobuf.ProtocolStringList getAllowedLocationsList() {
      return allowedLocations_;
    }

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @return The count of allowedLocations.
     */
    public int getAllowedLocationsCount() {
      return allowedLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedLocations at the given index.
     */
    public java.lang.String getAllowedLocations(int index) {
      return allowedLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of allowed location names represented by internal URLs.
     *
     * Each location can be a region or a zone.
     * Only one region or multiple zones in one region is supported now.
     * For example,
     * ["regions/us-central1"] allow VMs in any zones in region us-central1.
     * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
     * in zones us-central1-a and us-central1-c.
     *
     * Mixing locations from different regions would cause errors.
     * For example,
     * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
     * "zones/us-west1-a"] contains locations from two distinct regions:
     * us-central1 and us-west1. This combination will trigger an error.
     * </pre>
     *
     * <code>repeated string allowed_locations = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedLocations at the given index.
     */
    public com.google.protobuf.ByteString getAllowedLocationsBytes(int index) {
      return allowedLocations_.getByteString(index);
    }

    public static final int DENIED_LOCATIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList deniedLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @return A list containing the deniedLocations.
     */
    public com.google.protobuf.ProtocolStringList getDeniedLocationsList() {
      return deniedLocations_;
    }

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @return The count of deniedLocations.
     */
    public int getDeniedLocationsCount() {
      return deniedLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The deniedLocations at the given index.
     */
    public java.lang.String getDeniedLocations(int index) {
      return deniedLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of denied location names.
     *
     * Not yet implemented.
     * </pre>
     *
     * <code>repeated string denied_locations = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the deniedLocations at the given index.
     */
    public com.google.protobuf.ByteString getDeniedLocationsBytes(int index) {
      return deniedLocations_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < allowedLocations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowedLocations_.getRaw(i));
      }
      for (int i = 0; i < deniedLocations_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deniedLocations_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allowedLocations_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedLocationsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < deniedLocations_.size(); i++) {
          dataSize += computeStringSizeNoTag(deniedLocations_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDeniedLocationsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy) obj;

      if (!getAllowedLocationsList().equals(other.getAllowedLocationsList())) return false;
      if (!getDeniedLocationsList().equals(other.getDeniedLocationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllowedLocationsCount() > 0) {
        hash = (37 * hash) + ALLOWED_LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedLocationsList().hashCode();
      }
      if (getDeniedLocationsCount() > 0) {
        hash = (37 * hash) + DENIED_LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDeniedLocationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /** Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LocationPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LocationPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allowedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        deniedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LocationPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allowedLocations_.makeImmutable();
          result.allowedLocations_ = allowedLocations_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          deniedLocations_.makeImmutable();
          result.deniedLocations_ = deniedLocations_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance())
          return this;
        if (!other.allowedLocations_.isEmpty()) {
          if (allowedLocations_.isEmpty()) {
            allowedLocations_ = other.allowedLocations_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllowedLocationsIsMutable();
            allowedLocations_.addAll(other.allowedLocations_);
          }
          onChanged();
        }
        if (!other.deniedLocations_.isEmpty()) {
          if (deniedLocations_.isEmpty()) {
            deniedLocations_ = other.deniedLocations_;
            bitField0_ |= 0x00000002;
          } else {
            ensureDeniedLocationsIsMutable();
            deniedLocations_.addAll(other.deniedLocations_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowedLocationsIsMutable();
                  allowedLocations_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDeniedLocationsIsMutable();
                  deniedLocations_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allowedLocations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowedLocationsIsMutable() {
        if (!allowedLocations_.isModifiable()) {
          allowedLocations_ = new com.google.protobuf.LazyStringArrayList(allowedLocations_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @return A list containing the allowedLocations.
       */
      public com.google.protobuf.ProtocolStringList getAllowedLocationsList() {
        allowedLocations_.makeImmutable();
        return allowedLocations_;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @return The count of allowedLocations.
       */
      public int getAllowedLocationsCount() {
        return allowedLocations_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedLocations at the given index.
       */
      public java.lang.String getAllowedLocations(int index) {
        return allowedLocations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedLocations at the given index.
       */
      public com.google.protobuf.ByteString getAllowedLocationsBytes(int index) {
        return allowedLocations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedLocations to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedLocations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedLocationsIsMutable();
        allowedLocations_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param value The allowedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedLocations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedLocationsIsMutable();
        allowedLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param values The allowedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedLocations(java.lang.Iterable<java.lang.String> values) {
        ensureAllowedLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedLocations_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedLocations() {
        allowedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed location names represented by internal URLs.
       *
       * Each location can be a region or a zone.
       * Only one region or multiple zones in one region is supported now.
       * For example,
       * ["regions/us-central1"] allow VMs in any zones in region us-central1.
       * ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs
       * in zones us-central1-a and us-central1-c.
       *
       * Mixing locations from different regions would cause errors.
       * For example,
       * ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b",
       * "zones/us-west1-a"] contains locations from two distinct regions:
       * us-central1 and us-west1. This combination will trigger an error.
       * </pre>
       *
       * <code>repeated string allowed_locations = 1;</code>
       *
       * @param value The bytes of the allowedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedLocationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowedLocationsIsMutable();
        allowedLocations_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList deniedLocations_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDeniedLocationsIsMutable() {
        if (!deniedLocations_.isModifiable()) {
          deniedLocations_ = new com.google.protobuf.LazyStringArrayList(deniedLocations_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @return A list containing the deniedLocations.
       */
      public com.google.protobuf.ProtocolStringList getDeniedLocationsList() {
        deniedLocations_.makeImmutable();
        return deniedLocations_;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @return The count of deniedLocations.
       */
      public int getDeniedLocationsCount() {
        return deniedLocations_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The deniedLocations at the given index.
       */
      public java.lang.String getDeniedLocations(int index) {
        return deniedLocations_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the deniedLocations at the given index.
       */
      public com.google.protobuf.ByteString getDeniedLocationsBytes(int index) {
        return deniedLocations_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The deniedLocations to set.
       * @return This builder for chaining.
       */
      public Builder setDeniedLocations(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedLocationsIsMutable();
        deniedLocations_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param value The deniedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDeniedLocations(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeniedLocationsIsMutable();
        deniedLocations_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param values The deniedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addAllDeniedLocations(java.lang.Iterable<java.lang.String> values) {
        ensureDeniedLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deniedLocations_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeniedLocations() {
        deniedLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of denied location names.
       *
       * Not yet implemented.
       * </pre>
       *
       * <code>repeated string denied_locations = 2;</code>
       *
       * @param value The bytes of the deniedLocations to add.
       * @return This builder for chaining.
       */
      public Builder addDeniedLocationsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDeniedLocationsIsMutable();
        deniedLocations_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LocationPolicy> PARSER =
        new com.google.protobuf.AbstractParser<LocationPolicy>() {
          @java.lang.Override
          public LocationPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LocationPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LocationPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DiskOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.Disk)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return Whether the image field is set.
     */
    boolean hasImage();

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return The image.
     */
    java.lang.String getImage();

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return The bytes for image.
     */
    com.google.protobuf.ByteString getImageBytes();

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return Whether the snapshot field is set.
     */
    boolean hasSnapshot();

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return The snapshot.
     */
    java.lang.String getSnapshot();

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return The bytes for snapshot.
     */
    com.google.protobuf.ByteString getSnapshotBytes();

    /**
     *
     *
     * <pre>
     * Disk type as shown in `gcloud compute disk-types list`.
     * For example, local SSD uses type "local-ssd".
     * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
     * or "pd-standard". If not specified, "pd-standard" will be used as the
     * default type for non-boot disks, "pd-balanced" will be used as the
     * default type for boot disks.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    java.lang.String getType();

    /**
     *
     *
     * <pre>
     * Disk type as shown in `gcloud compute disk-types list`.
     * For example, local SSD uses type "local-ssd".
     * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
     * or "pd-standard". If not specified, "pd-standard" will be used as the
     * default type for non-boot disks, "pd-balanced" will be used as the
     * default type for boot disks.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Disk size in GB.
     *
     * **Non-Boot Disk**:
     * If the `type` specifies a persistent disk, this field
     * is ignored if `data_source` is set as `image` or `snapshot`.
     * If the `type` specifies a local SSD, this field should be a multiple of
     * 375 GB, otherwise, the final size will be the next greater multiple of
     * 375 GB.
     *
     * **Boot Disk**:
     * Batch will calculate the boot disk size based on source
     * image and task requirements if you do not speicify the size.
     * If both this field and the `boot_disk_mib` field in task spec's
     * `compute_resource` are defined, Batch will only honor this field.
     * Also, this field should be no smaller than the source disk's
     * size when the `data_source` is set as `snapshot` or `image`.
     * For example, if you set an image as the `data_source` field and the
     * image's default disk size 30 GB, you can only use this field to make the
     * disk larger or equal to 30 GB.
     * </pre>
     *
     * <code>int64 size_gb = 2;</code>
     *
     * @return The sizeGb.
     */
    long getSizeGb();

    /**
     *
     *
     * <pre>
     * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
     * If not indicated, "NVMe" will be the default one for local ssds.
     * This field is ignored for persistent disks as the interface is chosen
     * automatically. See
     * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
     * </pre>
     *
     * <code>string disk_interface = 6;</code>
     *
     * @return The diskInterface.
     */
    java.lang.String getDiskInterface();

    /**
     *
     *
     * <pre>
     * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
     * If not indicated, "NVMe" will be the default one for local ssds.
     * This field is ignored for persistent disks as the interface is chosen
     * automatically. See
     * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
     * </pre>
     *
     * <code>string disk_interface = 6;</code>
     *
     * @return The bytes for diskInterface.
     */
    com.google.protobuf.ByteString getDiskInterfaceBytes();

    com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.DataSourceCase getDataSourceCase();
  }

  /**
   *
   *
   * <pre>
   * A new persistent disk or a local ssd.
   * A VM can only have one local SSD setting but multiple local SSD partitions.
   * See https://cloud.google.com/compute/docs/disks#pdspecs and
   * https://cloud.google.com/compute/docs/disks#localssds.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.Disk}
   */
  public static final class Disk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.Disk)
      DiskOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Disk.newBuilder() to construct.
    private Disk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Disk() {
      type_ = "";
      diskInterface_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Disk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Disk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Disk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder.class);
    }

    private int dataSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object dataSource_;

    public enum DataSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      IMAGE(4),
      SNAPSHOT(5),
      DATASOURCE_NOT_SET(0);
      private final int value;

      private DataSourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataSourceCase forNumber(int value) {
        switch (value) {
          case 4:
            return IMAGE;
          case 5:
            return SNAPSHOT;
          case 0:
            return DATASOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    public static final int IMAGE_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return Whether the image field is set.
     */
    public boolean hasImage() {
      return dataSourceCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return The image.
     */
    public java.lang.String getImage() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 4) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataSourceCase_ == 4) {
          dataSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * URL for a VM image to use as the data source for this disk.
     * For example, the following are all valid URLs:
     *
     * * Specify the image by its family name:
     * projects/{project}/global/images/family/{image_family}
     * * Specify the image version:
     * projects/{project}/global/images/{image_version}
     *
     * You can also use Batch customized image in short names.
     * The following image values are supported for a boot disk:
     *
     * * `batch-debian`: use Batch Debian images.
     * * `batch-cos`: use Batch Container-Optimized images.
     * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
     * </pre>
     *
     * <code>string image = 4;</code>
     *
     * @return The bytes for image.
     */
    public com.google.protobuf.ByteString getImageBytes() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 4) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataSourceCase_ == 4) {
          dataSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SNAPSHOT_FIELD_NUMBER = 5;

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return Whether the snapshot field is set.
     */
    public boolean hasSnapshot() {
      return dataSourceCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return The snapshot.
     */
    public java.lang.String getSnapshot() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 5) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (dataSourceCase_ == 5) {
          dataSource_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of a snapshot used as the data source.
     * Snapshot is not supported as boot disk now.
     * </pre>
     *
     * <code>string snapshot = 5;</code>
     *
     * @return The bytes for snapshot.
     */
    public com.google.protobuf.ByteString getSnapshotBytes() {
      java.lang.Object ref = "";
      if (dataSourceCase_ == 5) {
        ref = dataSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (dataSourceCase_ == 5) {
          dataSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * Disk type as shown in `gcloud compute disk-types list`.
     * For example, local SSD uses type "local-ssd".
     * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
     * or "pd-standard". If not specified, "pd-standard" will be used as the
     * default type for non-boot disks, "pd-balanced" will be used as the
     * default type for boot disks.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Disk type as shown in `gcloud compute disk-types list`.
     * For example, local SSD uses type "local-ssd".
     * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
     * or "pd-standard". If not specified, "pd-standard" will be used as the
     * default type for non-boot disks, "pd-balanced" will be used as the
     * default type for boot disks.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIZE_GB_FIELD_NUMBER = 2;
    private long sizeGb_ = 0L;

    /**
     *
     *
     * <pre>
     * Disk size in GB.
     *
     * **Non-Boot Disk**:
     * If the `type` specifies a persistent disk, this field
     * is ignored if `data_source` is set as `image` or `snapshot`.
     * If the `type` specifies a local SSD, this field should be a multiple of
     * 375 GB, otherwise, the final size will be the next greater multiple of
     * 375 GB.
     *
     * **Boot Disk**:
     * Batch will calculate the boot disk size based on source
     * image and task requirements if you do not speicify the size.
     * If both this field and the `boot_disk_mib` field in task spec's
     * `compute_resource` are defined, Batch will only honor this field.
     * Also, this field should be no smaller than the source disk's
     * size when the `data_source` is set as `snapshot` or `image`.
     * For example, if you set an image as the `data_source` field and the
     * image's default disk size 30 GB, you can only use this field to make the
     * disk larger or equal to 30 GB.
     * </pre>
     *
     * <code>int64 size_gb = 2;</code>
     *
     * @return The sizeGb.
     */
    @java.lang.Override
    public long getSizeGb() {
      return sizeGb_;
    }

    public static final int DISK_INTERFACE_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object diskInterface_ = "";

    /**
     *
     *
     * <pre>
     * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
     * If not indicated, "NVMe" will be the default one for local ssds.
     * This field is ignored for persistent disks as the interface is chosen
     * automatically. See
     * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
     * </pre>
     *
     * <code>string disk_interface = 6;</code>
     *
     * @return The diskInterface.
     */
    @java.lang.Override
    public java.lang.String getDiskInterface() {
      java.lang.Object ref = diskInterface_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskInterface_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
     * If not indicated, "NVMe" will be the default one for local ssds.
     * This field is ignored for persistent disks as the interface is chosen
     * automatically. See
     * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
     * </pre>
     *
     * <code>string disk_interface = 6;</code>
     *
     * @return The bytes for diskInterface.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDiskInterfaceBytes() {
      java.lang.Object ref = diskInterface_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskInterface_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (sizeGb_ != 0L) {
        output.writeInt64(2, sizeGb_);
      }
      if (dataSourceCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, dataSource_);
      }
      if (dataSourceCase_ == 5) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, dataSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskInterface_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, diskInterface_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (sizeGb_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, sizeGb_);
      }
      if (dataSourceCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, dataSource_);
      }
      if (dataSourceCase_ == 5) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, dataSource_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskInterface_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, diskInterface_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.Disk)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.Disk other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) obj;

      if (!getType().equals(other.getType())) return false;
      if (getSizeGb() != other.getSizeGb()) return false;
      if (!getDiskInterface().equals(other.getDiskInterface())) return false;
      if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
      switch (dataSourceCase_) {
        case 4:
          if (!getImage().equals(other.getImage())) return false;
          break;
        case 5:
          if (!getSnapshot().equals(other.getSnapshot())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (37 * hash) + SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSizeGb());
      hash = (37 * hash) + DISK_INTERFACE_FIELD_NUMBER;
      hash = (53 * hash) + getDiskInterface().hashCode();
      switch (dataSourceCase_) {
        case 4:
          hash = (37 * hash) + IMAGE_FIELD_NUMBER;
          hash = (53 * hash) + getImage().hashCode();
          break;
        case 5:
          hash = (37 * hash) + SNAPSHOT_FIELD_NUMBER;
          hash = (53 * hash) + getSnapshot().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.Disk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A new persistent disk or a local ssd.
     * A VM can only have one local SSD setting but multiple local SSD partitions.
     * See https://cloud.google.com/compute/docs/disks#pdspecs and
     * https://cloud.google.com/compute/docs/disks#localssds.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.Disk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.Disk)
        com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Disk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Disk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = "";
        sizeGb_ = 0L;
        diskInterface_ = "";
        dataSourceCase_ = 0;
        dataSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Disk_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.Disk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.Disk result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.Disk(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.sizeGb_ = sizeGb_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.diskInterface_ = diskInterface_;
        }
      }

      private void buildPartialOneofs(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk result) {
        result.dataSourceCase_ = dataSourceCase_;
        result.dataSource_ = this.dataSource_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk other) {
        if (other == com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance())
          return this;
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getSizeGb() != 0L) {
          setSizeGb(other.getSizeGb());
        }
        if (!other.getDiskInterface().isEmpty()) {
          diskInterface_ = other.diskInterface_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        switch (other.getDataSourceCase()) {
          case IMAGE:
            {
              dataSourceCase_ = 4;
              dataSource_ = other.dataSource_;
              onChanged();
              break;
            }
          case SNAPSHOT:
            {
              dataSourceCase_ = 5;
              dataSource_ = other.dataSource_;
              onChanged();
              break;
            }
          case DATASOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 10
              case 16:
                {
                  sizeGb_ = input.readInt64();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 16
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  dataSourceCase_ = 4;
                  dataSource_ = s;
                  break;
                } // case 34
              case 42:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  dataSourceCase_ = 5;
                  dataSource_ = s;
                  break;
                } // case 42
              case 50:
                {
                  diskInterface_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataSourceCase_ = 0;
      private java.lang.Object dataSource_;

      public DataSourceCase getDataSourceCase() {
        return DataSourceCase.forNumber(dataSourceCase_);
      }

      public Builder clearDataSource() {
        dataSourceCase_ = 0;
        dataSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @return Whether the image field is set.
       */
      @java.lang.Override
      public boolean hasImage() {
        return dataSourceCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @return The image.
       */
      @java.lang.Override
      public java.lang.String getImage() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 4) {
          ref = dataSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (dataSourceCase_ == 4) {
            dataSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @return The bytes for image.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getImageBytes() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 4) {
          ref = dataSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (dataSourceCase_ == 4) {
            dataSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @param value The image to set.
       * @return This builder for chaining.
       */
      public Builder setImage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSourceCase_ = 4;
        dataSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImage() {
        if (dataSourceCase_ == 4) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * URL for a VM image to use as the data source for this disk.
       * For example, the following are all valid URLs:
       *
       * * Specify the image by its family name:
       * projects/{project}/global/images/family/{image_family}
       * * Specify the image version:
       * projects/{project}/global/images/{image_version}
       *
       * You can also use Batch customized image in short names.
       * The following image values are supported for a boot disk:
       *
       * * `batch-debian`: use Batch Debian images.
       * * `batch-cos`: use Batch Container-Optimized images.
       * * `batch-hpc-rocky`: use Batch HPC Rocky Linux images.
       * </pre>
       *
       * <code>string image = 4;</code>
       *
       * @param value The bytes for image to set.
       * @return This builder for chaining.
       */
      public Builder setImageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataSourceCase_ = 4;
        dataSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @return Whether the snapshot field is set.
       */
      @java.lang.Override
      public boolean hasSnapshot() {
        return dataSourceCase_ == 5;
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @return The snapshot.
       */
      @java.lang.Override
      public java.lang.String getSnapshot() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 5) {
          ref = dataSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (dataSourceCase_ == 5) {
            dataSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @return The bytes for snapshot.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSnapshotBytes() {
        java.lang.Object ref = "";
        if (dataSourceCase_ == 5) {
          ref = dataSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (dataSourceCase_ == 5) {
            dataSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @param value The snapshot to set.
       * @return This builder for chaining.
       */
      public Builder setSnapshot(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSourceCase_ = 5;
        dataSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSnapshot() {
        if (dataSourceCase_ == 5) {
          dataSourceCase_ = 0;
          dataSource_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of a snapshot used as the data source.
       * Snapshot is not supported as boot disk now.
       * </pre>
       *
       * <code>string snapshot = 5;</code>
       *
       * @param value The bytes for snapshot to set.
       * @return This builder for chaining.
       */
      public Builder setSnapshotBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataSourceCase_ = 5;
        dataSource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";

      /**
       *
       *
       * <pre>
       * Disk type as shown in `gcloud compute disk-types list`.
       * For example, local SSD uses type "local-ssd".
       * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
       * or "pd-standard". If not specified, "pd-standard" will be used as the
       * default type for non-boot disks, "pd-balanced" will be used as the
       * default type for boot disks.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Disk type as shown in `gcloud compute disk-types list`.
       * For example, local SSD uses type "local-ssd".
       * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
       * or "pd-standard". If not specified, "pd-standard" will be used as the
       * default type for non-boot disks, "pd-balanced" will be used as the
       * default type for boot disks.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Disk type as shown in `gcloud compute disk-types list`.
       * For example, local SSD uses type "local-ssd".
       * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
       * or "pd-standard". If not specified, "pd-standard" will be used as the
       * default type for non-boot disks, "pd-balanced" will be used as the
       * default type for boot disks.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Disk type as shown in `gcloud compute disk-types list`.
       * For example, local SSD uses type "local-ssd".
       * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
       * or "pd-standard". If not specified, "pd-standard" will be used as the
       * default type for non-boot disks, "pd-balanced" will be used as the
       * default type for boot disks.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Disk type as shown in `gcloud compute disk-types list`.
       * For example, local SSD uses type "local-ssd".
       * Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd"
       * or "pd-standard". If not specified, "pd-standard" will be used as the
       * default type for non-boot disks, "pd-balanced" will be used as the
       * default type for boot disks.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private long sizeGb_;

      /**
       *
       *
       * <pre>
       * Disk size in GB.
       *
       * **Non-Boot Disk**:
       * If the `type` specifies a persistent disk, this field
       * is ignored if `data_source` is set as `image` or `snapshot`.
       * If the `type` specifies a local SSD, this field should be a multiple of
       * 375 GB, otherwise, the final size will be the next greater multiple of
       * 375 GB.
       *
       * **Boot Disk**:
       * Batch will calculate the boot disk size based on source
       * image and task requirements if you do not speicify the size.
       * If both this field and the `boot_disk_mib` field in task spec's
       * `compute_resource` are defined, Batch will only honor this field.
       * Also, this field should be no smaller than the source disk's
       * size when the `data_source` is set as `snapshot` or `image`.
       * For example, if you set an image as the `data_source` field and the
       * image's default disk size 30 GB, you can only use this field to make the
       * disk larger or equal to 30 GB.
       * </pre>
       *
       * <code>int64 size_gb = 2;</code>
       *
       * @return The sizeGb.
       */
      @java.lang.Override
      public long getSizeGb() {
        return sizeGb_;
      }

      /**
       *
       *
       * <pre>
       * Disk size in GB.
       *
       * **Non-Boot Disk**:
       * If the `type` specifies a persistent disk, this field
       * is ignored if `data_source` is set as `image` or `snapshot`.
       * If the `type` specifies a local SSD, this field should be a multiple of
       * 375 GB, otherwise, the final size will be the next greater multiple of
       * 375 GB.
       *
       * **Boot Disk**:
       * Batch will calculate the boot disk size based on source
       * image and task requirements if you do not speicify the size.
       * If both this field and the `boot_disk_mib` field in task spec's
       * `compute_resource` are defined, Batch will only honor this field.
       * Also, this field should be no smaller than the source disk's
       * size when the `data_source` is set as `snapshot` or `image`.
       * For example, if you set an image as the `data_source` field and the
       * image's default disk size 30 GB, you can only use this field to make the
       * disk larger or equal to 30 GB.
       * </pre>
       *
       * <code>int64 size_gb = 2;</code>
       *
       * @param value The sizeGb to set.
       * @return This builder for chaining.
       */
      public Builder setSizeGb(long value) {

        sizeGb_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Disk size in GB.
       *
       * **Non-Boot Disk**:
       * If the `type` specifies a persistent disk, this field
       * is ignored if `data_source` is set as `image` or `snapshot`.
       * If the `type` specifies a local SSD, this field should be a multiple of
       * 375 GB, otherwise, the final size will be the next greater multiple of
       * 375 GB.
       *
       * **Boot Disk**:
       * Batch will calculate the boot disk size based on source
       * image and task requirements if you do not speicify the size.
       * If both this field and the `boot_disk_mib` field in task spec's
       * `compute_resource` are defined, Batch will only honor this field.
       * Also, this field should be no smaller than the source disk's
       * size when the `data_source` is set as `snapshot` or `image`.
       * For example, if you set an image as the `data_source` field and the
       * image's default disk size 30 GB, you can only use this field to make the
       * disk larger or equal to 30 GB.
       * </pre>
       *
       * <code>int64 size_gb = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSizeGb() {
        bitField0_ = (bitField0_ & ~0x00000008);
        sizeGb_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object diskInterface_ = "";

      /**
       *
       *
       * <pre>
       * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
       * If not indicated, "NVMe" will be the default one for local ssds.
       * This field is ignored for persistent disks as the interface is chosen
       * automatically. See
       * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
       * </pre>
       *
       * <code>string disk_interface = 6;</code>
       *
       * @return The diskInterface.
       */
      public java.lang.String getDiskInterface() {
        java.lang.Object ref = diskInterface_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          diskInterface_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
       * If not indicated, "NVMe" will be the default one for local ssds.
       * This field is ignored for persistent disks as the interface is chosen
       * automatically. See
       * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
       * </pre>
       *
       * <code>string disk_interface = 6;</code>
       *
       * @return The bytes for diskInterface.
       */
      public com.google.protobuf.ByteString getDiskInterfaceBytes() {
        java.lang.Object ref = diskInterface_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          diskInterface_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
       * If not indicated, "NVMe" will be the default one for local ssds.
       * This field is ignored for persistent disks as the interface is chosen
       * automatically. See
       * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
       * </pre>
       *
       * <code>string disk_interface = 6;</code>
       *
       * @param value The diskInterface to set.
       * @return This builder for chaining.
       */
      public Builder setDiskInterface(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        diskInterface_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
       * If not indicated, "NVMe" will be the default one for local ssds.
       * This field is ignored for persistent disks as the interface is chosen
       * automatically. See
       * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
       * </pre>
       *
       * <code>string disk_interface = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDiskInterface() {
        diskInterface_ = getDefaultInstance().getDiskInterface();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Local SSDs are available through both "SCSI" and "NVMe" interfaces.
       * If not indicated, "NVMe" will be the default one for local ssds.
       * This field is ignored for persistent disks as the interface is chosen
       * automatically. See
       * https://cloud.google.com/compute/docs/disks/persistent-disks#choose_an_interface.
       * </pre>
       *
       * <code>string disk_interface = 6;</code>
       *
       * @param value The bytes for diskInterface to set.
       * @return This builder for chaining.
       */
      public Builder setDiskInterfaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        diskInterface_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.Disk)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.Disk)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.Disk DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.Disk();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Disk> PARSER =
        new com.google.protobuf.AbstractParser<Disk>() {
          @java.lang.Override
          public Disk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Disk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Disk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AttachedDiskOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
     *
     * @return Whether the newDisk field is set.
     */
    boolean hasNewDisk();

    /**
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
     *
     * @return The newDisk.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getNewDisk();

    /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
    com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getNewDiskOrBuilder();

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return Whether the existingDisk field is set.
     */
    boolean hasExistingDisk();

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return The existingDisk.
     */
    java.lang.String getExistingDisk();

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return The bytes for existingDisk.
     */
    com.google.protobuf.ByteString getExistingDiskBytes();

    /**
     *
     *
     * <pre>
     * Device name that the guest operating system will see.
     * It is used by Runnable.volumes field to mount disks. So please specify
     * the device_name if you want Batch to help mount the disk, and it should
     * match the device_name field in volumes.
     * </pre>
     *
     * <code>string device_name = 3;</code>
     *
     * @return The deviceName.
     */
    java.lang.String getDeviceName();

    /**
     *
     *
     * <pre>
     * Device name that the guest operating system will see.
     * It is used by Runnable.volumes field to mount disks. So please specify
     * the device_name if you want Batch to help mount the disk, and it should
     * match the device_name field in volumes.
     * </pre>
     *
     * <code>string device_name = 3;</code>
     *
     * @return The bytes for deviceName.
     */
    com.google.protobuf.ByteString getDeviceNameBytes();

    com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.AttachedCase getAttachedCase();
  }

  /**
   *
   *
   * <pre>
   * A new or an existing persistent disk (PD) or a local ssd attached to a VM
   * instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk}
   */
  public static final class AttachedDisk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)
      AttachedDiskOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AttachedDisk.newBuilder() to construct.
    private AttachedDisk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AttachedDisk() {
      deviceName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AttachedDisk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_AttachedDisk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_AttachedDisk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder.class);
    }

    private int attachedCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object attached_;

    public enum AttachedCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      NEW_DISK(1),
      EXISTING_DISK(2),
      ATTACHED_NOT_SET(0);
      private final int value;

      private AttachedCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AttachedCase valueOf(int value) {
        return forNumber(value);
      }

      public static AttachedCase forNumber(int value) {
        switch (value) {
          case 1:
            return NEW_DISK;
          case 2:
            return EXISTING_DISK;
          case 0:
            return ATTACHED_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AttachedCase getAttachedCase() {
      return AttachedCase.forNumber(attachedCase_);
    }

    public static final int NEW_DISK_FIELD_NUMBER = 1;

    /**
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
     *
     * @return Whether the newDisk field is set.
     */
    @java.lang.Override
    public boolean hasNewDisk() {
      return attachedCase_ == 1;
    }

    /**
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
     *
     * @return The newDisk.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getNewDisk() {
      if (attachedCase_ == 1) {
        return (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_;
      }
      return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
    }

    /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getNewDiskOrBuilder() {
      if (attachedCase_ == 1) {
        return (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_;
      }
      return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
    }

    public static final int EXISTING_DISK_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return Whether the existingDisk field is set.
     */
    public boolean hasExistingDisk() {
      return attachedCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return The existingDisk.
     */
    public java.lang.String getExistingDisk() {
      java.lang.Object ref = "";
      if (attachedCase_ == 2) {
        ref = attached_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (attachedCase_ == 2) {
          attached_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of an existing PD.
     * </pre>
     *
     * <code>string existing_disk = 2;</code>
     *
     * @return The bytes for existingDisk.
     */
    public com.google.protobuf.ByteString getExistingDiskBytes() {
      java.lang.Object ref = "";
      if (attachedCase_ == 2) {
        ref = attached_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (attachedCase_ == 2) {
          attached_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEVICE_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object deviceName_ = "";

    /**
     *
     *
     * <pre>
     * Device name that the guest operating system will see.
     * It is used by Runnable.volumes field to mount disks. So please specify
     * the device_name if you want Batch to help mount the disk, and it should
     * match the device_name field in volumes.
     * </pre>
     *
     * <code>string device_name = 3;</code>
     *
     * @return The deviceName.
     */
    @java.lang.Override
    public java.lang.String getDeviceName() {
      java.lang.Object ref = deviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deviceName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Device name that the guest operating system will see.
     * It is used by Runnable.volumes field to mount disks. So please specify
     * the device_name if you want Batch to help mount the disk, and it should
     * match the device_name field in volumes.
     * </pre>
     *
     * <code>string device_name = 3;</code>
     *
     * @return The bytes for deviceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDeviceNameBytes() {
      java.lang.Object ref = deviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (attachedCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_);
      }
      if (attachedCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, attached_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deviceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, deviceName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (attachedCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_);
      }
      if (attachedCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, attached_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deviceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, deviceName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk) obj;

      if (!getDeviceName().equals(other.getDeviceName())) return false;
      if (!getAttachedCase().equals(other.getAttachedCase())) return false;
      switch (attachedCase_) {
        case 1:
          if (!getNewDisk().equals(other.getNewDisk())) return false;
          break;
        case 2:
          if (!getExistingDisk().equals(other.getExistingDisk())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DEVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDeviceName().hashCode();
      switch (attachedCase_) {
        case 1:
          hash = (37 * hash) + NEW_DISK_FIELD_NUMBER;
          hash = (53 * hash) + getNewDisk().hashCode();
          break;
        case 2:
          hash = (37 * hash) + EXISTING_DISK_FIELD_NUMBER;
          hash = (53 * hash) + getExistingDisk().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A new or an existing persistent disk (PD) or a local ssd attached to a VM
     * instance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)
        com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_AttachedDisk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_AttachedDisk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (newDiskBuilder_ != null) {
          newDiskBuilder_.clear();
        }
        deviceName_ = "";
        attachedCase_ = 0;
        attached_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_AttachedDisk_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.deviceName_ = deviceName_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk result) {
        result.attachedCase_ = attachedCase_;
        result.attached_ = this.attached_;
        if (attachedCase_ == 1 && newDiskBuilder_ != null) {
          result.attached_ = newDiskBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.getDefaultInstance())
          return this;
        if (!other.getDeviceName().isEmpty()) {
          deviceName_ = other.deviceName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        switch (other.getAttachedCase()) {
          case NEW_DISK:
            {
              mergeNewDisk(other.getNewDisk());
              break;
            }
          case EXISTING_DISK:
            {
              attachedCase_ = 2;
              attached_ = other.attached_;
              onChanged();
              break;
            }
          case ATTACHED_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getNewDiskFieldBuilder().getBuilder(), extensionRegistry);
                  attachedCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  attachedCase_ = 2;
                  attached_ = s;
                  break;
                } // case 18
              case 26:
                {
                  deviceName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int attachedCase_ = 0;
      private java.lang.Object attached_;

      public AttachedCase getAttachedCase() {
        return AttachedCase.forNumber(attachedCase_);
      }

      public Builder clearAttached() {
        attachedCase_ = 0;
        attached_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          newDiskBuilder_;

      /**
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
       *
       * @return Whether the newDisk field is set.
       */
      @java.lang.Override
      public boolean hasNewDisk() {
        return attachedCase_ == 1;
      }

      /**
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code>
       *
       * @return The newDisk.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getNewDisk() {
        if (newDiskBuilder_ == null) {
          if (attachedCase_ == 1) {
            return (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_;
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
        } else {
          if (attachedCase_ == 1) {
            return newDiskBuilder_.getMessage();
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
        }
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      public Builder setNewDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (newDiskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          attached_ = value;
          onChanged();
        } else {
          newDiskBuilder_.setMessage(value);
        }
        attachedCase_ = 1;
        return this;
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      public Builder setNewDisk(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder builderForValue) {
        if (newDiskBuilder_ == null) {
          attached_ = builderForValue.build();
          onChanged();
        } else {
          newDiskBuilder_.setMessage(builderForValue.build());
        }
        attachedCase_ = 1;
        return this;
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      public Builder mergeNewDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (newDiskBuilder_ == null) {
          if (attachedCase_ == 1
              && attached_
                  != com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()) {
            attached_ =
                com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.newBuilder(
                        (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            attached_ = value;
          }
          onChanged();
        } else {
          if (attachedCase_ == 1) {
            newDiskBuilder_.mergeFrom(value);
          } else {
            newDiskBuilder_.setMessage(value);
          }
        }
        attachedCase_ = 1;
        return this;
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      public Builder clearNewDisk() {
        if (newDiskBuilder_ == null) {
          if (attachedCase_ == 1) {
            attachedCase_ = 0;
            attached_ = null;
            onChanged();
          }
        } else {
          if (attachedCase_ == 1) {
            attachedCase_ = 0;
            attached_ = null;
          }
          newDiskBuilder_.clear();
        }
        return this;
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder getNewDiskBuilder() {
        return getNewDiskFieldBuilder().getBuilder();
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getNewDiskOrBuilder() {
        if ((attachedCase_ == 1) && (newDiskBuilder_ != null)) {
          return newDiskBuilder_.getMessageOrBuilder();
        } else {
          if (attachedCase_ == 1) {
            return (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_;
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
        }
      }

      /** <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk new_disk = 1;</code> */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          getNewDiskFieldBuilder() {
        if (newDiskBuilder_ == null) {
          if (!(attachedCase_ == 1)) {
            attached_ = com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance();
          }
          newDiskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>(
                  (com.google.cloud.batch.v1alpha.AllocationPolicy.Disk) attached_,
                  getParentForChildren(),
                  isClean());
          attached_ = null;
        }
        attachedCase_ = 1;
        onChanged();
        return newDiskBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @return Whether the existingDisk field is set.
       */
      @java.lang.Override
      public boolean hasExistingDisk() {
        return attachedCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @return The existingDisk.
       */
      @java.lang.Override
      public java.lang.String getExistingDisk() {
        java.lang.Object ref = "";
        if (attachedCase_ == 2) {
          ref = attached_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (attachedCase_ == 2) {
            attached_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @return The bytes for existingDisk.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getExistingDiskBytes() {
        java.lang.Object ref = "";
        if (attachedCase_ == 2) {
          ref = attached_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (attachedCase_ == 2) {
            attached_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @param value The existingDisk to set.
       * @return This builder for chaining.
       */
      public Builder setExistingDisk(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        attachedCase_ = 2;
        attached_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExistingDisk() {
        if (attachedCase_ == 2) {
          attachedCase_ = 0;
          attached_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of an existing PD.
       * </pre>
       *
       * <code>string existing_disk = 2;</code>
       *
       * @param value The bytes for existingDisk to set.
       * @return This builder for chaining.
       */
      public Builder setExistingDiskBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        attachedCase_ = 2;
        attached_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object deviceName_ = "";

      /**
       *
       *
       * <pre>
       * Device name that the guest operating system will see.
       * It is used by Runnable.volumes field to mount disks. So please specify
       * the device_name if you want Batch to help mount the disk, and it should
       * match the device_name field in volumes.
       * </pre>
       *
       * <code>string device_name = 3;</code>
       *
       * @return The deviceName.
       */
      public java.lang.String getDeviceName() {
        java.lang.Object ref = deviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Device name that the guest operating system will see.
       * It is used by Runnable.volumes field to mount disks. So please specify
       * the device_name if you want Batch to help mount the disk, and it should
       * match the device_name field in volumes.
       * </pre>
       *
       * <code>string device_name = 3;</code>
       *
       * @return The bytes for deviceName.
       */
      public com.google.protobuf.ByteString getDeviceNameBytes() {
        java.lang.Object ref = deviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          deviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Device name that the guest operating system will see.
       * It is used by Runnable.volumes field to mount disks. So please specify
       * the device_name if you want Batch to help mount the disk, and it should
       * match the device_name field in volumes.
       * </pre>
       *
       * <code>string device_name = 3;</code>
       *
       * @param value The deviceName to set.
       * @return This builder for chaining.
       */
      public Builder setDeviceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        deviceName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Device name that the guest operating system will see.
       * It is used by Runnable.volumes field to mount disks. So please specify
       * the device_name if you want Batch to help mount the disk, and it should
       * match the device_name field in volumes.
       * </pre>
       *
       * <code>string device_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeviceName() {
        deviceName_ = getDefaultInstance().getDeviceName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Device name that the guest operating system will see.
       * It is used by Runnable.volumes field to mount disks. So please specify
       * the device_name if you want Batch to help mount the disk, and it should
       * match the device_name field in volumes.
       * </pre>
       *
       * <code>string device_name = 3;</code>
       *
       * @param value The bytes for deviceName to set.
       * @return This builder for chaining.
       */
      public Builder setDeviceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        deviceName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AttachedDisk> PARSER =
        new com.google.protobuf.AbstractParser<AttachedDisk>() {
          @java.lang.Override
          public AttachedDisk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AttachedDisk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AttachedDisk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AcceleratorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The accelerator type. For example, "nvidia-tesla-t4".
     * See `gcloud compute accelerator-types list`.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    java.lang.String getType();

    /**
     *
     *
     * <pre>
     * The accelerator type. For example, "nvidia-tesla-t4".
     * See `gcloud compute accelerator-types list`.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * The number of accelerators of this type.
     * </pre>
     *
     * <code>int64 count = 2;</code>
     *
     * @return The count.
     */
    long getCount();

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].install_gpu_drivers instead.
     * </pre>
     *
     * <code>bool install_gpu_drivers = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.install_gpu_drivers is
     *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=450
     * @return The installGpuDrivers.
     */
    @java.lang.Deprecated
    boolean getInstallGpuDrivers();

    /**
     *
     *
     * <pre>
     * Optional. The NVIDIA GPU driver version that should be installed for this
     * type.
     *
     * You can define the specific driver version such as "470.103.01",
     * following the driver version requirements in
     * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
     * Batch will install the specific accelerator driver if qualified.
     * </pre>
     *
     * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The driverVersion.
     */
    java.lang.String getDriverVersion();

    /**
     *
     *
     * <pre>
     * Optional. The NVIDIA GPU driver version that should be installed for this
     * type.
     *
     * You can define the specific driver version such as "470.103.01",
     * following the driver version requirements in
     * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
     * Batch will install the specific accelerator driver if qualified.
     * </pre>
     *
     * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for driverVersion.
     */
    com.google.protobuf.ByteString getDriverVersionBytes();
  }

  /**
   *
   *
   * <pre>
   * Accelerator describes Compute Engine accelerators to be attached to the VM.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.Accelerator}
   */
  public static final class Accelerator extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)
      AcceleratorOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Accelerator.newBuilder() to construct.
    private Accelerator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Accelerator() {
      type_ = "";
      driverVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Accelerator();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Accelerator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Accelerator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";

    /**
     *
     *
     * <pre>
     * The accelerator type. For example, "nvidia-tesla-t4".
     * See `gcloud compute accelerator-types list`.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The accelerator type. For example, "nvidia-tesla-t4".
     * See `gcloud compute accelerator-types list`.
     * </pre>
     *
     * <code>string type = 1;</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COUNT_FIELD_NUMBER = 2;
    private long count_ = 0L;

    /**
     *
     *
     * <pre>
     * The number of accelerators of this type.
     * </pre>
     *
     * <code>int64 count = 2;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public long getCount() {
      return count_;
    }

    public static final int INSTALL_GPU_DRIVERS_FIELD_NUMBER = 3;
    private boolean installGpuDrivers_ = false;

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].install_gpu_drivers instead.
     * </pre>
     *
     * <code>bool install_gpu_drivers = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.install_gpu_drivers is
     *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=450
     * @return The installGpuDrivers.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getInstallGpuDrivers() {
      return installGpuDrivers_;
    }

    public static final int DRIVER_VERSION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object driverVersion_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The NVIDIA GPU driver version that should be installed for this
     * type.
     *
     * You can define the specific driver version such as "470.103.01",
     * following the driver version requirements in
     * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
     * Batch will install the specific accelerator driver if qualified.
     * </pre>
     *
     * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The driverVersion.
     */
    @java.lang.Override
    public java.lang.String getDriverVersion() {
      java.lang.Object ref = driverVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        driverVersion_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The NVIDIA GPU driver version that should be installed for this
     * type.
     *
     * You can define the specific driver version such as "470.103.01",
     * following the driver version requirements in
     * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
     * Batch will install the specific accelerator driver if qualified.
     * </pre>
     *
     * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for driverVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDriverVersionBytes() {
      java.lang.Object ref = driverVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        driverVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (count_ != 0L) {
        output.writeInt64(2, count_);
      }
      if (installGpuDrivers_ != false) {
        output.writeBool(3, installGpuDrivers_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, driverVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, count_);
      }
      if (installGpuDrivers_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, installGpuDrivers_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, driverVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator) obj;

      if (!getType().equals(other.getType())) return false;
      if (getCount() != other.getCount()) return false;
      if (getInstallGpuDrivers() != other.getInstallGpuDrivers()) return false;
      if (!getDriverVersion().equals(other.getDriverVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
      hash = (37 * hash) + INSTALL_GPU_DRIVERS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInstallGpuDrivers());
      hash = (37 * hash) + DRIVER_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getDriverVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Accelerator describes Compute Engine accelerators to be attached to the VM.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.Accelerator}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)
        com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Accelerator_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Accelerator_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = "";
        count_ = 0L;
        installGpuDrivers_ = false;
        driverVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_Accelerator_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.count_ = count_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.installGpuDrivers_ = installGpuDrivers_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.driverVersion_ = driverVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.getDefaultInstance())
          return this;
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        if (other.getInstallGpuDrivers() != false) {
          setInstallGpuDrivers(other.getInstallGpuDrivers());
        }
        if (!other.getDriverVersion().isEmpty()) {
          driverVersion_ = other.driverVersion_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  count_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  installGpuDrivers_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  driverVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";

      /**
       *
       *
       * <pre>
       * The accelerator type. For example, "nvidia-tesla-t4".
       * See `gcloud compute accelerator-types list`.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerator type. For example, "nvidia-tesla-t4".
       * See `gcloud compute accelerator-types list`.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerator type. For example, "nvidia-tesla-t4".
       * See `gcloud compute accelerator-types list`.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerator type. For example, "nvidia-tesla-t4".
       * See `gcloud compute accelerator-types list`.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerator type. For example, "nvidia-tesla-t4".
       * See `gcloud compute accelerator-types list`.
       * </pre>
       *
       * <code>string type = 1;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long count_;

      /**
       *
       *
       * <pre>
       * The number of accelerators of this type.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      /**
       *
       *
       * <pre>
       * The number of accelerators of this type.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @param value The count to set.
       * @return This builder for chaining.
       */
      public Builder setCount(long value) {

        count_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The number of accelerators of this type.
       * </pre>
       *
       * <code>int64 count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        count_ = 0L;
        onChanged();
        return this;
      }

      private boolean installGpuDrivers_;

      /**
       *
       *
       * <pre>
       * Deprecated: please use instances[0].install_gpu_drivers instead.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.install_gpu_drivers is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=450
       * @return The installGpuDrivers.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean getInstallGpuDrivers() {
        return installGpuDrivers_;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use instances[0].install_gpu_drivers instead.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.install_gpu_drivers is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=450
       * @param value The installGpuDrivers to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setInstallGpuDrivers(boolean value) {

        installGpuDrivers_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use instances[0].install_gpu_drivers instead.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.install_gpu_drivers is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=450
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearInstallGpuDrivers() {
        bitField0_ = (bitField0_ & ~0x00000004);
        installGpuDrivers_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object driverVersion_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The NVIDIA GPU driver version that should be installed for this
       * type.
       *
       * You can define the specific driver version such as "470.103.01",
       * following the driver version requirements in
       * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
       * Batch will install the specific accelerator driver if qualified.
       * </pre>
       *
       * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The driverVersion.
       */
      public java.lang.String getDriverVersion() {
        java.lang.Object ref = driverVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          driverVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The NVIDIA GPU driver version that should be installed for this
       * type.
       *
       * You can define the specific driver version such as "470.103.01",
       * following the driver version requirements in
       * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
       * Batch will install the specific accelerator driver if qualified.
       * </pre>
       *
       * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for driverVersion.
       */
      public com.google.protobuf.ByteString getDriverVersionBytes() {
        java.lang.Object ref = driverVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          driverVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The NVIDIA GPU driver version that should be installed for this
       * type.
       *
       * You can define the specific driver version such as "470.103.01",
       * following the driver version requirements in
       * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
       * Batch will install the specific accelerator driver if qualified.
       * </pre>
       *
       * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The driverVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDriverVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        driverVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The NVIDIA GPU driver version that should be installed for this
       * type.
       *
       * You can define the specific driver version such as "470.103.01",
       * following the driver version requirements in
       * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
       * Batch will install the specific accelerator driver if qualified.
       * </pre>
       *
       * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDriverVersion() {
        driverVersion_ = getDefaultInstance().getDriverVersion();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The NVIDIA GPU driver version that should be installed for this
       * type.
       *
       * You can define the specific driver version such as "470.103.01",
       * following the driver version requirements in
       * https://cloud.google.com/compute/docs/gpus/install-drivers-gpu#minimum-driver.
       * Batch will install the specific accelerator driver if qualified.
       * </pre>
       *
       * <code>string driver_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for driverVersion to set.
       * @return This builder for chaining.
       */
      public Builder setDriverVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        driverVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.Accelerator)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Accelerator> PARSER =
        new com.google.protobuf.AbstractParser<Accelerator>() {
          @java.lang.Override
          public Accelerator parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Accelerator> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Accelerator> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstancePolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @return A list containing the allowedMachineTypes.
     */
    @java.lang.Deprecated
    java.util.List<java.lang.String> getAllowedMachineTypesList();

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @return The count of allowedMachineTypes.
     */
    @java.lang.Deprecated
    int getAllowedMachineTypesCount();

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @param index The index of the element to return.
     * @return The allowedMachineTypes at the given index.
     */
    @java.lang.Deprecated
    java.lang.String getAllowedMachineTypes(int index);

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @param index The index of the value to return.
     * @return The bytes of the allowedMachineTypes at the given index.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getAllowedMachineTypesBytes(int index);

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * The minimum CPU platform.
     * See
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string min_cpu_platform = 3;</code>
     *
     * @return The minCpuPlatform.
     */
    java.lang.String getMinCpuPlatform();

    /**
     *
     *
     * <pre>
     * The minimum CPU platform.
     * See
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string min_cpu_platform = 3;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    com.google.protobuf.ByteString getMinCpuPlatformBytes();

    /**
     *
     *
     * <pre>
     * The provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for provisioningModel.
     */
    int getProvisioningModelValue();

    /**
     *
     *
     * <pre>
     * The provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
     * </code>
     *
     * @return The provisioningModel.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel getProvisioningModel();

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
        getAcceleratorsList();

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator getAccelerators(int index);

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    int getAcceleratorsCount();

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    java.util.List<? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>
        getAcceleratorsOrBuilderList();

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder getAcceleratorsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     *
     * @return Whether the bootDisk field is set.
     */
    boolean hasBootDisk();

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     *
     * @return The bootDisk.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk();

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder();

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk> getDisksList();

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk getDisks(int index);

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    int getDisksCount();

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    java.util.List<? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>
        getDisksOrBuilderList();

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder getDisksOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Optional. If not specified (default), VMs will consume any applicable
     * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
     * reservation. Otherwise, if specified, VMs will consume only the specified
     * reservation.
     * </pre>
     *
     * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The reservation.
     */
    java.lang.String getReservation();

    /**
     *
     *
     * <pre>
     * Optional. If not specified (default), VMs will consume any applicable
     * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
     * reservation. Otherwise, if specified, VMs will consume only the specified
     * reservation.
     * </pre>
     *
     * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for reservation.
     */
    com.google.protobuf.ByteString getReservationBytes();
  }

  /**
   *
   *
   * <pre>
   * InstancePolicy describes an instance type and resources attached to each VM
   * created by this InstancePolicy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy}
   */
  public static final class InstancePolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
      InstancePolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InstancePolicy.newBuilder() to construct.
    private InstancePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstancePolicy() {
      allowedMachineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      machineType_ = "";
      minCpuPlatform_ = "";
      provisioningModel_ = 0;
      accelerators_ = java.util.Collections.emptyList();
      disks_ = java.util.Collections.emptyList();
      reservation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstancePolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder.class);
    }

    private int bitField0_;
    public static final int ALLOWED_MACHINE_TYPES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowedMachineTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @return A list containing the allowedMachineTypes.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getAllowedMachineTypesList() {
      return allowedMachineTypes_;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @return The count of allowedMachineTypes.
     */
    @java.lang.Deprecated
    public int getAllowedMachineTypesCount() {
      return allowedMachineTypes_.size();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @param index The index of the element to return.
     * @return The allowedMachineTypes at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getAllowedMachineTypes(int index) {
      return allowedMachineTypes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use machine_type instead.
     * </pre>
     *
     * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types
     *     is deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
     * @param index The index of the value to return.
     * @return The bytes of the allowedMachineTypes at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getAllowedMachineTypesBytes(int index) {
      return allowedMachineTypes_.getByteString(index);
    }

    public static final int MACHINE_TYPE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object machineType_ = "";

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 2;</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object minCpuPlatform_ = "";

    /**
     *
     *
     * <pre>
     * The minimum CPU platform.
     * See
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string min_cpu_platform = 3;</code>
     *
     * @return The minCpuPlatform.
     */
    @java.lang.Override
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The minimum CPU platform.
     * See
     * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
     * </pre>
     *
     * <code>string min_cpu_platform = 3;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROVISIONING_MODEL_FIELD_NUMBER = 4;
    private int provisioningModel_ = 0;

    /**
     *
     *
     * <pre>
     * The provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for provisioningModel.
     */
    @java.lang.Override
    public int getProvisioningModelValue() {
      return provisioningModel_;
    }

    /**
     *
     *
     * <pre>
     * The provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
     * </code>
     *
     * @return The provisioningModel.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
        getProvisioningModel() {
      com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel result =
          com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.forNumber(
              provisioningModel_);
      return result == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.UNRECOGNIZED
          : result;
    }

    public static final int ACCELERATORS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
        accelerators_;

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
        getAcceleratorsList() {
      return accelerators_;
    }

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>
        getAcceleratorsOrBuilderList() {
      return accelerators_;
    }

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    @java.lang.Override
    public int getAcceleratorsCount() {
      return accelerators_.size();
    }

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator getAccelerators(int index) {
      return accelerators_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The accelerators attached to each VM instance.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder
        getAcceleratorsOrBuilder(int index) {
      return accelerators_.get(index);
    }

    public static final int BOOT_DISK_FIELD_NUMBER = 8;
    private com.google.cloud.batch.v1alpha.AllocationPolicy.Disk bootDisk_;

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     *
     * @return Whether the bootDisk field is set.
     */
    @java.lang.Override
    public boolean hasBootDisk() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     *
     * @return The bootDisk.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk() {
      return bootDisk_ == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
          : bootDisk_;
    }

    /**
     *
     *
     * <pre>
     * Boot disk to be created and attached to each VM by this InstancePolicy.
     * Boot disk will be deleted when the VM is deleted.
     * Batch API now only supports booting from image.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder() {
      return bootDisk_ == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
          : bootDisk_;
    }

    public static final int DISKS_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk> disks_;

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk>
        getDisksList() {
      return disks_;
    }

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>
        getDisksOrBuilderList() {
      return disks_;
    }

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    @java.lang.Override
    public int getDisksCount() {
      return disks_.size();
    }

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk getDisks(int index) {
      return disks_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Non-boot disks to be attached for each VM created by this InstancePolicy.
     * New disks will be deleted when the VM is deleted.
     * A non-boot disk is a disk that can be of a device with a
     * file system or a raw storage drive that is not ready for data
     * storage and accessing.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder getDisksOrBuilder(
        int index) {
      return disks_.get(index);
    }

    public static final int RESERVATION_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object reservation_ = "";

    /**
     *
     *
     * <pre>
     * Optional. If not specified (default), VMs will consume any applicable
     * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
     * reservation. Otherwise, if specified, VMs will consume only the specified
     * reservation.
     * </pre>
     *
     * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The reservation.
     */
    @java.lang.Override
    public java.lang.String getReservation() {
      java.lang.Object ref = reservation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservation_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If not specified (default), VMs will consume any applicable
     * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
     * reservation. Otherwise, if specified, VMs will consume only the specified
     * reservation.
     * </pre>
     *
     * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for reservation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getReservationBytes() {
      java.lang.Object ref = reservation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < allowedMachineTypes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 1, allowedMachineTypes_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, machineType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, minCpuPlatform_);
      }
      if (provisioningModel_
          != com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
              .PROVISIONING_MODEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, provisioningModel_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        output.writeMessage(5, accelerators_.get(i));
      }
      for (int i = 0; i < disks_.size(); i++) {
        output.writeMessage(6, disks_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, reservation_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(8, getBootDisk());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < allowedMachineTypes_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedMachineTypes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedMachineTypesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, machineType_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(minCpuPlatform_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, minCpuPlatform_);
      }
      if (provisioningModel_
          != com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
              .PROVISIONING_MODEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, provisioningModel_);
      }
      for (int i = 0; i < accelerators_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, accelerators_.get(i));
      }
      for (int i = 0; i < disks_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, disks_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, reservation_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getBootDisk());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) obj;

      if (!getAllowedMachineTypesList().equals(other.getAllowedMachineTypesList())) return false;
      if (!getMachineType().equals(other.getMachineType())) return false;
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
      if (provisioningModel_ != other.provisioningModel_) return false;
      if (!getAcceleratorsList().equals(other.getAcceleratorsList())) return false;
      if (hasBootDisk() != other.hasBootDisk()) return false;
      if (hasBootDisk()) {
        if (!getBootDisk().equals(other.getBootDisk())) return false;
      }
      if (!getDisksList().equals(other.getDisksList())) return false;
      if (!getReservation().equals(other.getReservation())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAllowedMachineTypesCount() > 0) {
        hash = (37 * hash) + ALLOWED_MACHINE_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedMachineTypesList().hashCode();
      }
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
      hash = (37 * hash) + PROVISIONING_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + provisioningModel_;
      if (getAcceleratorsCount() > 0) {
        hash = (37 * hash) + ACCELERATORS_FIELD_NUMBER;
        hash = (53 * hash) + getAcceleratorsList().hashCode();
      }
      if (hasBootDisk()) {
        hash = (37 * hash) + BOOT_DISK_FIELD_NUMBER;
        hash = (53 * hash) + getBootDisk().hashCode();
      }
      if (getDisksCount() > 0) {
        hash = (37 * hash) + DISKS_FIELD_NUMBER;
        hash = (53 * hash) + getDisksList().hashCode();
      }
      hash = (37 * hash) + RESERVATION_FIELD_NUMBER;
      hash = (53 * hash) + getReservation().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * InstancePolicy describes an instance type and resources attached to each VM
     * created by this InstancePolicy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAcceleratorsFieldBuilder();
          getBootDiskFieldBuilder();
          getDisksFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        allowedMachineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        machineType_ = "";
        minCpuPlatform_ = "";
        provisioningModel_ = 0;
        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
        } else {
          accelerators_ = null;
          acceleratorsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        bootDisk_ = null;
        if (bootDiskBuilder_ != null) {
          bootDiskBuilder_.dispose();
          bootDiskBuilder_ = null;
        }
        if (disksBuilder_ == null) {
          disks_ = java.util.Collections.emptyList();
        } else {
          disks_ = null;
          disksBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        reservation_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy result) {
        if (acceleratorsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            accelerators_ = java.util.Collections.unmodifiableList(accelerators_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.accelerators_ = accelerators_;
        } else {
          result.accelerators_ = acceleratorsBuilder_.build();
        }
        if (disksBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            disks_ = java.util.Collections.unmodifiableList(disks_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.disks_ = disks_;
        } else {
          result.disks_ = disksBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          allowedMachineTypes_.makeImmutable();
          result.allowedMachineTypes_ = allowedMachineTypes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.machineType_ = machineType_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.minCpuPlatform_ = minCpuPlatform_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.provisioningModel_ = provisioningModel_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.bootDisk_ = bootDiskBuilder_ == null ? bootDisk_ : bootDiskBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.reservation_ = reservation_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance())
          return this;
        if (!other.allowedMachineTypes_.isEmpty()) {
          if (allowedMachineTypes_.isEmpty()) {
            allowedMachineTypes_ = other.allowedMachineTypes_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAllowedMachineTypesIsMutable();
            allowedMachineTypes_.addAll(other.allowedMachineTypes_);
          }
          onChanged();
        }
        if (!other.getMachineType().isEmpty()) {
          machineType_ = other.machineType_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getMinCpuPlatform().isEmpty()) {
          minCpuPlatform_ = other.minCpuPlatform_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.provisioningModel_ != 0) {
          setProvisioningModelValue(other.getProvisioningModelValue());
        }
        if (acceleratorsBuilder_ == null) {
          if (!other.accelerators_.isEmpty()) {
            if (accelerators_.isEmpty()) {
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureAcceleratorsIsMutable();
              accelerators_.addAll(other.accelerators_);
            }
            onChanged();
          }
        } else {
          if (!other.accelerators_.isEmpty()) {
            if (acceleratorsBuilder_.isEmpty()) {
              acceleratorsBuilder_.dispose();
              acceleratorsBuilder_ = null;
              accelerators_ = other.accelerators_;
              bitField0_ = (bitField0_ & ~0x00000010);
              acceleratorsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAcceleratorsFieldBuilder()
                      : null;
            } else {
              acceleratorsBuilder_.addAllMessages(other.accelerators_);
            }
          }
        }
        if (other.hasBootDisk()) {
          mergeBootDisk(other.getBootDisk());
        }
        if (disksBuilder_ == null) {
          if (!other.disks_.isEmpty()) {
            if (disks_.isEmpty()) {
              disks_ = other.disks_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureDisksIsMutable();
              disks_.addAll(other.disks_);
            }
            onChanged();
          }
        } else {
          if (!other.disks_.isEmpty()) {
            if (disksBuilder_.isEmpty()) {
              disksBuilder_.dispose();
              disksBuilder_ = null;
              disks_ = other.disks_;
              bitField0_ = (bitField0_ & ~0x00000040);
              disksBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDisksFieldBuilder()
                      : null;
            } else {
              disksBuilder_.addAllMessages(other.disks_);
            }
          }
        }
        if (!other.getReservation().isEmpty()) {
          reservation_ = other.reservation_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowedMachineTypesIsMutable();
                  allowedMachineTypes_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  machineType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  minCpuPlatform_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  provisioningModel_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator m =
                      input.readMessage(
                          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.parser(),
                          extensionRegistry);
                  if (acceleratorsBuilder_ == null) {
                    ensureAcceleratorsIsMutable();
                    accelerators_.add(m);
                  } else {
                    acceleratorsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              case 50:
                {
                  com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk m =
                      input.readMessage(
                          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.parser(),
                          extensionRegistry);
                  if (disksBuilder_ == null) {
                    ensureDisksIsMutable();
                    disks_.add(m);
                  } else {
                    disksBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 58:
                {
                  reservation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getBootDiskFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList allowedMachineTypes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowedMachineTypesIsMutable() {
        if (!allowedMachineTypes_.isModifiable()) {
          allowedMachineTypes_ = new com.google.protobuf.LazyStringArrayList(allowedMachineTypes_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @return A list containing the allowedMachineTypes.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ProtocolStringList getAllowedMachineTypesList() {
        allowedMachineTypes_.makeImmutable();
        return allowedMachineTypes_;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @return The count of allowedMachineTypes.
       */
      @java.lang.Deprecated
      public int getAllowedMachineTypesCount() {
        return allowedMachineTypes_.size();
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param index The index of the element to return.
       * @return The allowedMachineTypes at the given index.
       */
      @java.lang.Deprecated
      public java.lang.String getAllowedMachineTypes(int index) {
        return allowedMachineTypes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param index The index of the value to return.
       * @return The bytes of the allowedMachineTypes at the given index.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getAllowedMachineTypesBytes(int index) {
        return allowedMachineTypes_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param index The index to set the value at.
       * @param value The allowedMachineTypes to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setAllowedMachineTypes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMachineTypesIsMutable();
        allowedMachineTypes_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param value The allowedMachineTypes to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllowedMachineTypes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMachineTypesIsMutable();
        allowedMachineTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param values The allowedMachineTypes to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllAllowedMachineTypes(java.lang.Iterable<java.lang.String> values) {
        ensureAllowedMachineTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedMachineTypes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearAllowedMachineTypes() {
        allowedMachineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Deprecated: please use machine_type instead.
       * </pre>
       *
       * <code>repeated string allowed_machine_types = 1 [deprecated = true];</code>
       *
       * @deprecated
       *     google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.allowed_machine_types is
       *     deprecated. See google/cloud/batch/v1alpha/job.proto;l=466
       * @param value The bytes of the allowedMachineTypes to add.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder addAllowedMachineTypesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowedMachineTypesIsMutable();
        allowedMachineTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object machineType_ = "";

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 2;</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 2;</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 2;</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {
        machineType_ = getDefaultInstance().getMachineType();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 2;</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        machineType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object minCpuPlatform_ = "";

      /**
       *
       *
       * <pre>
       * The minimum CPU platform.
       * See
       * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
       * </pre>
       *
       * <code>string min_cpu_platform = 3;</code>
       *
       * @return The minCpuPlatform.
       */
      public java.lang.String getMinCpuPlatform() {
        java.lang.Object ref = minCpuPlatform_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          minCpuPlatform_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The minimum CPU platform.
       * See
       * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
       * </pre>
       *
       * <code>string min_cpu_platform = 3;</code>
       *
       * @return The bytes for minCpuPlatform.
       */
      public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
        java.lang.Object ref = minCpuPlatform_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          minCpuPlatform_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The minimum CPU platform.
       * See
       * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
       * </pre>
       *
       * <code>string min_cpu_platform = 3;</code>
       *
       * @param value The minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatform(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        minCpuPlatform_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The minimum CPU platform.
       * See
       * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
       * </pre>
       *
       * <code>string min_cpu_platform = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinCpuPlatform() {
        minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The minimum CPU platform.
       * See
       * https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform.
       * </pre>
       *
       * <code>string min_cpu_platform = 3;</code>
       *
       * @param value The bytes for minCpuPlatform to set.
       * @return This builder for chaining.
       */
      public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        minCpuPlatform_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private int provisioningModel_ = 0;

      /**
       *
       *
       * <pre>
       * The provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for provisioningModel.
       */
      @java.lang.Override
      public int getProvisioningModelValue() {
        return provisioningModel_;
      }

      /**
       *
       *
       * <pre>
       * The provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for provisioningModel to set.
       * @return This builder for chaining.
       */
      public Builder setProvisioningModelValue(int value) {
        provisioningModel_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
       * </code>
       *
       * @return The provisioningModel.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
          getProvisioningModel() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel result =
            com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.forNumber(
                provisioningModel_);
        return result == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
       * </code>
       *
       * @param value The provisioningModel to set.
       * @return This builder for chaining.
       */
      public Builder setProvisioningModel(
          com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        provisioningModel_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProvisioningModel() {
        bitField0_ = (bitField0_ & ~0x00000008);
        provisioningModel_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
          accelerators_ = java.util.Collections.emptyList();

      private void ensureAcceleratorsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          accelerators_ =
              new java.util.ArrayList<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>(
                  accelerators_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>
          acceleratorsBuilder_;

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
          getAcceleratorsList() {
        if (acceleratorsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(accelerators_);
        } else {
          return acceleratorsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public int getAcceleratorsCount() {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.size();
        } else {
          return acceleratorsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator getAccelerators(
          int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder setAccelerators(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder setAccelerators(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.set(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder addAccelerators(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator value) {
        if (acceleratorsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, value);
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder addAccelerators(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder addAccelerators(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder builderForValue) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.add(index, builderForValue.build());
          onChanged();
        } else {
          acceleratorsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder addAllAccelerators(
          java.lang.Iterable<? extends com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator>
              values) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, accelerators_);
          onChanged();
        } else {
          acceleratorsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder clearAccelerators() {
        if (acceleratorsBuilder_ == null) {
          accelerators_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          acceleratorsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public Builder removeAccelerators(int index) {
        if (acceleratorsBuilder_ == null) {
          ensureAcceleratorsIsMutable();
          accelerators_.remove(index);
          onChanged();
        } else {
          acceleratorsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder
          getAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder
          getAcceleratorsOrBuilder(int index) {
        if (acceleratorsBuilder_ == null) {
          return accelerators_.get(index);
        } else {
          return acceleratorsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>
          getAcceleratorsOrBuilderList() {
        if (acceleratorsBuilder_ != null) {
          return acceleratorsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(accelerators_);
        }
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder
          addAcceleratorsBuilder() {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder
          addAcceleratorsBuilder(int index) {
        return getAcceleratorsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * The accelerators attached to each VM instance.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.Accelerator accelerators = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder>
          getAcceleratorsBuilderList() {
        return getAcceleratorsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>
          getAcceleratorsFieldBuilder() {
        if (acceleratorsBuilder_ == null) {
          acceleratorsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Accelerator.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.AcceleratorOrBuilder>(
                  accelerators_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          accelerators_ = null;
        }
        return acceleratorsBuilder_;
      }

      private com.google.cloud.batch.v1alpha.AllocationPolicy.Disk bootDisk_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          bootDiskBuilder_;

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       *
       * @return Whether the bootDisk field is set.
       */
      public boolean hasBootDisk() {
        return ((bitField0_ & 0x00000020) != 0);
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       *
       * @return The bootDisk.
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk() {
        if (bootDiskBuilder_ == null) {
          return bootDisk_ == null
              ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
              : bootDisk_;
        } else {
          return bootDiskBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public Builder setBootDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (bootDiskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          bootDisk_ = value;
        } else {
          bootDiskBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public Builder setBootDisk(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder builderForValue) {
        if (bootDiskBuilder_ == null) {
          bootDisk_ = builderForValue.build();
        } else {
          bootDiskBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public Builder mergeBootDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (bootDiskBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && bootDisk_ != null
              && bootDisk_
                  != com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()) {
            getBootDiskBuilder().mergeFrom(value);
          } else {
            bootDisk_ = value;
          }
        } else {
          bootDiskBuilder_.mergeFrom(value);
        }
        if (bootDisk_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public Builder clearBootDisk() {
        bitField0_ = (bitField0_ & ~0x00000020);
        bootDisk_ = null;
        if (bootDiskBuilder_ != null) {
          bootDiskBuilder_.dispose();
          bootDiskBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder getBootDiskBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getBootDiskFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder() {
        if (bootDiskBuilder_ != null) {
          return bootDiskBuilder_.getMessageOrBuilder();
        } else {
          return bootDisk_ == null
              ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
              : bootDisk_;
        }
      }

      /**
       *
       *
       * <pre>
       * Boot disk to be created and attached to each VM by this InstancePolicy.
       * Boot disk will be deleted when the VM is deleted.
       * Batch API now only supports booting from image.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          getBootDiskFieldBuilder() {
        if (bootDiskBuilder_ == null) {
          bootDiskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>(
                  getBootDisk(), getParentForChildren(), isClean());
          bootDisk_ = null;
        }
        return bootDiskBuilder_;
      }

      private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk> disks_ =
          java.util.Collections.emptyList();

      private void ensureDisksIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          disks_ =
              new java.util.ArrayList<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk>(
                  disks_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>
          disksBuilder_;

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk>
          getDisksList() {
        if (disksBuilder_ == null) {
          return java.util.Collections.unmodifiableList(disks_);
        } else {
          return disksBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public int getDisksCount() {
        if (disksBuilder_ == null) {
          return disks_.size();
        } else {
          return disksBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk getDisks(int index) {
        if (disksBuilder_ == null) {
          return disks_.get(index);
        } else {
          return disksBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder setDisks(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk value) {
        if (disksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDisksIsMutable();
          disks_.set(index, value);
          onChanged();
        } else {
          disksBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder setDisks(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder builderForValue) {
        if (disksBuilder_ == null) {
          ensureDisksIsMutable();
          disks_.set(index, builderForValue.build());
          onChanged();
        } else {
          disksBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder addDisks(com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk value) {
        if (disksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDisksIsMutable();
          disks_.add(value);
          onChanged();
        } else {
          disksBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder addDisks(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk value) {
        if (disksBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDisksIsMutable();
          disks_.add(index, value);
          onChanged();
        } else {
          disksBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder addDisks(
          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder builderForValue) {
        if (disksBuilder_ == null) {
          ensureDisksIsMutable();
          disks_.add(builderForValue.build());
          onChanged();
        } else {
          disksBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder addDisks(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder builderForValue) {
        if (disksBuilder_ == null) {
          ensureDisksIsMutable();
          disks_.add(index, builderForValue.build());
          onChanged();
        } else {
          disksBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder addAllDisks(
          java.lang.Iterable<? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk>
              values) {
        if (disksBuilder_ == null) {
          ensureDisksIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
          onChanged();
        } else {
          disksBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder clearDisks() {
        if (disksBuilder_ == null) {
          disks_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          disksBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public Builder removeDisks(int index) {
        if (disksBuilder_ == null) {
          ensureDisksIsMutable();
          disks_.remove(index);
          onChanged();
        } else {
          disksBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder getDisksBuilder(
          int index) {
        return getDisksFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder
          getDisksOrBuilder(int index) {
        if (disksBuilder_ == null) {
          return disks_.get(index);
        } else {
          return disksBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>
          getDisksOrBuilderList() {
        if (disksBuilder_ != null) {
          return disksBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(disks_);
        }
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder
          addDisksBuilder() {
        return getDisksFieldBuilder()
            .addBuilder(
                com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder addDisksBuilder(
          int index) {
        return getDisksFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Non-boot disks to be attached for each VM created by this InstancePolicy.
       * New disks will be deleted when the VM is deleted.
       * A non-boot disk is a disk that can be of a device with a
       * file system or a raw storage drive that is not ready for data
       * storage and accessing.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk disks = 6;</code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder>
          getDisksBuilderList() {
        return getDisksFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>
          getDisksFieldBuilder() {
        if (disksBuilder_ == null) {
          disksBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDisk.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.AttachedDiskOrBuilder>(
                  disks_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
          disks_ = null;
        }
        return disksBuilder_;
      }

      private java.lang.Object reservation_ = "";

      /**
       *
       *
       * <pre>
       * Optional. If not specified (default), VMs will consume any applicable
       * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
       * reservation. Otherwise, if specified, VMs will consume only the specified
       * reservation.
       * </pre>
       *
       * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The reservation.
       */
      public java.lang.String getReservation() {
        java.lang.Object ref = reservation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          reservation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If not specified (default), VMs will consume any applicable
       * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
       * reservation. Otherwise, if specified, VMs will consume only the specified
       * reservation.
       * </pre>
       *
       * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for reservation.
       */
      public com.google.protobuf.ByteString getReservationBytes() {
        java.lang.Object ref = reservation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reservation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. If not specified (default), VMs will consume any applicable
       * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
       * reservation. Otherwise, if specified, VMs will consume only the specified
       * reservation.
       * </pre>
       *
       * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The reservation to set.
       * @return This builder for chaining.
       */
      public Builder setReservation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservation_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If not specified (default), VMs will consume any applicable
       * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
       * reservation. Otherwise, if specified, VMs will consume only the specified
       * reservation.
       * </pre>
       *
       * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReservation() {
        reservation_ = getDefaultInstance().getReservation();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If not specified (default), VMs will consume any applicable
       * reservation. If "NO_RESERVATION" is specified, VMs will not consume any
       * reservation. Otherwise, if specified, VMs will consume only the specified
       * reservation.
       * </pre>
       *
       * <code>string reservation = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for reservation to set.
       * @return This builder for chaining.
       */
      public Builder setReservationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        reservation_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstancePolicy> PARSER =
        new com.google.protobuf.AbstractParser<InstancePolicy>() {
          @java.lang.Override
          public InstancePolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstancePolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstancePolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstancePolicyOrTemplateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     *
     * @return Whether the policy field is set.
     */
    boolean hasPolicy();

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     *
     * @return The policy.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy getPolicy();

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder getPolicyOrBuilder();

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return Whether the instanceTemplate field is set.
     */
    boolean hasInstanceTemplate();

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return The instanceTemplate.
     */
    java.lang.String getInstanceTemplate();

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return The bytes for instanceTemplate.
     */
    com.google.protobuf.ByteString getInstanceTemplateBytes();

    /**
     *
     *
     * <pre>
     * Set this field true if you want Batch to help fetch drivers from a third
     * party location and install them for GPUs specified in
     * `policy.accelerators` or `instance_template` on your behalf. Default is
     * false.
     *
     * For Container-Optimized Image cases, Batch will install the
     * accelerator driver following milestones of
     * https://cloud.google.com/container-optimized-os/docs/release-notes. For
     * non Container-Optimized Image cases, following
     * https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
     * </pre>
     *
     * <code>bool install_gpu_drivers = 3;</code>
     *
     * @return The installGpuDrivers.
     */
    boolean getInstallGpuDrivers();

    /**
     *
     *
     * <pre>
     * Optional. Set this field true if you want Batch to install Ops Agent on
     * your behalf. Default is false.
     * </pre>
     *
     * <code>bool install_ops_agent = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The installOpsAgent.
     */
    boolean getInstallOpsAgent();

    /**
     *
     *
     * <pre>
     * Optional. Set this field to `true` if you want Batch to block
     * project-level SSH keys from accessing this job's VMs.  Alternatively, you
     * can configure the job to specify a VM instance template that blocks
     * project-level SSH keys. In either case, Batch blocks project-level SSH
     * keys while creating the VMs for this job.
     *
     * Batch allows project-level SSH keys for a job's VMs only if all
     * the following are true:
     *
     * + This field is undefined or set to `false`.
     * + The job's VM instance template (if any) doesn't block project-level
     *   SSH keys.
     *
     * Notably, you can override this behavior by manually updating a VM to
     * block or allow project-level SSH keys. For more information about
     * blocking project-level SSH keys, see the Compute Engine documentation:
     * https://cloud.google.com/compute/docs/connect/restrict-ssh-keys#block-keys
     * </pre>
     *
     * <code>bool block_project_ssh_keys = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The blockProjectSshKeys.
     */
    boolean getBlockProjectSshKeys();

    com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.PolicyTemplateCase
        getPolicyTemplateCase();
  }

  /**
   *
   *
   * <pre>
   * InstancePolicyOrTemplate lets you define the type of resources to use for
   * this job either with an InstancePolicy or an instance template.
   * If undefined, Batch picks the type of VM to use and doesn't include
   * optional VM resources such as GPUs and extra disks.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate}
   */
  public static final class InstancePolicyOrTemplate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)
      InstancePolicyOrTemplateOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InstancePolicyOrTemplate.newBuilder() to construct.
    private InstancePolicyOrTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstancePolicyOrTemplate() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstancePolicyOrTemplate();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicyOrTemplate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicyOrTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
                  .class);
    }

    private int policyTemplateCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object policyTemplate_;

    public enum PolicyTemplateCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      POLICY(1),
      INSTANCE_TEMPLATE(2),
      POLICYTEMPLATE_NOT_SET(0);
      private final int value;

      private PolicyTemplateCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PolicyTemplateCase valueOf(int value) {
        return forNumber(value);
      }

      public static PolicyTemplateCase forNumber(int value) {
        switch (value) {
          case 1:
            return POLICY;
          case 2:
            return INSTANCE_TEMPLATE;
          case 0:
            return POLICYTEMPLATE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public PolicyTemplateCase getPolicyTemplateCase() {
      return PolicyTemplateCase.forNumber(policyTemplateCase_);
    }

    public static final int POLICY_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     *
     * @return Whether the policy field is set.
     */
    @java.lang.Override
    public boolean hasPolicy() {
      return policyTemplateCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     *
     * @return The policy.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy getPolicy() {
      if (policyTemplateCase_ == 1) {
        return (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_;
      }
      return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * InstancePolicy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder
        getPolicyOrBuilder() {
      if (policyTemplateCase_ == 1) {
        return (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_;
      }
      return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance();
    }

    public static final int INSTANCE_TEMPLATE_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return Whether the instanceTemplate field is set.
     */
    public boolean hasInstanceTemplate() {
      return policyTemplateCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return The instanceTemplate.
     */
    public java.lang.String getInstanceTemplate() {
      java.lang.Object ref = "";
      if (policyTemplateCase_ == 2) {
        ref = policyTemplate_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (policyTemplateCase_ == 2) {
          policyTemplate_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of an instance template used to create VMs.
     * Named the field as 'instance_template' instead of 'template' to avoid
     * C++ keyword conflict.
     *
     * Batch only supports global instance templates from the same project as
     * the job.
     * You can specify the global instance template as a full or partial URL.
     * </pre>
     *
     * <code>string instance_template = 2;</code>
     *
     * @return The bytes for instanceTemplate.
     */
    public com.google.protobuf.ByteString getInstanceTemplateBytes() {
      java.lang.Object ref = "";
      if (policyTemplateCase_ == 2) {
        ref = policyTemplate_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (policyTemplateCase_ == 2) {
          policyTemplate_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTALL_GPU_DRIVERS_FIELD_NUMBER = 3;
    private boolean installGpuDrivers_ = false;

    /**
     *
     *
     * <pre>
     * Set this field true if you want Batch to help fetch drivers from a third
     * party location and install them for GPUs specified in
     * `policy.accelerators` or `instance_template` on your behalf. Default is
     * false.
     *
     * For Container-Optimized Image cases, Batch will install the
     * accelerator driver following milestones of
     * https://cloud.google.com/container-optimized-os/docs/release-notes. For
     * non Container-Optimized Image cases, following
     * https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
     * </pre>
     *
     * <code>bool install_gpu_drivers = 3;</code>
     *
     * @return The installGpuDrivers.
     */
    @java.lang.Override
    public boolean getInstallGpuDrivers() {
      return installGpuDrivers_;
    }

    public static final int INSTALL_OPS_AGENT_FIELD_NUMBER = 4;
    private boolean installOpsAgent_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Set this field true if you want Batch to install Ops Agent on
     * your behalf. Default is false.
     * </pre>
     *
     * <code>bool install_ops_agent = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The installOpsAgent.
     */
    @java.lang.Override
    public boolean getInstallOpsAgent() {
      return installOpsAgent_;
    }

    public static final int BLOCK_PROJECT_SSH_KEYS_FIELD_NUMBER = 5;
    private boolean blockProjectSshKeys_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Set this field to `true` if you want Batch to block
     * project-level SSH keys from accessing this job's VMs.  Alternatively, you
     * can configure the job to specify a VM instance template that blocks
     * project-level SSH keys. In either case, Batch blocks project-level SSH
     * keys while creating the VMs for this job.
     *
     * Batch allows project-level SSH keys for a job's VMs only if all
     * the following are true:
     *
     * + This field is undefined or set to `false`.
     * + The job's VM instance template (if any) doesn't block project-level
     *   SSH keys.
     *
     * Notably, you can override this behavior by manually updating a VM to
     * block or allow project-level SSH keys. For more information about
     * blocking project-level SSH keys, see the Compute Engine documentation:
     * https://cloud.google.com/compute/docs/connect/restrict-ssh-keys#block-keys
     * </pre>
     *
     * <code>bool block_project_ssh_keys = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The blockProjectSshKeys.
     */
    @java.lang.Override
    public boolean getBlockProjectSshKeys() {
      return blockProjectSshKeys_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (policyTemplateCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_);
      }
      if (policyTemplateCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, policyTemplate_);
      }
      if (installGpuDrivers_ != false) {
        output.writeBool(3, installGpuDrivers_);
      }
      if (installOpsAgent_ != false) {
        output.writeBool(4, installOpsAgent_);
      }
      if (blockProjectSshKeys_ != false) {
        output.writeBool(5, blockProjectSshKeys_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (policyTemplateCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_);
      }
      if (policyTemplateCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, policyTemplate_);
      }
      if (installGpuDrivers_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, installGpuDrivers_);
      }
      if (installOpsAgent_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, installOpsAgent_);
      }
      if (blockProjectSshKeys_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, blockProjectSshKeys_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate) obj;

      if (getInstallGpuDrivers() != other.getInstallGpuDrivers()) return false;
      if (getInstallOpsAgent() != other.getInstallOpsAgent()) return false;
      if (getBlockProjectSshKeys() != other.getBlockProjectSshKeys()) return false;
      if (!getPolicyTemplateCase().equals(other.getPolicyTemplateCase())) return false;
      switch (policyTemplateCase_) {
        case 1:
          if (!getPolicy().equals(other.getPolicy())) return false;
          break;
        case 2:
          if (!getInstanceTemplate().equals(other.getInstanceTemplate())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INSTALL_GPU_DRIVERS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInstallGpuDrivers());
      hash = (37 * hash) + INSTALL_OPS_AGENT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getInstallOpsAgent());
      hash = (37 * hash) + BLOCK_PROJECT_SSH_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBlockProjectSshKeys());
      switch (policyTemplateCase_) {
        case 1:
          hash = (37 * hash) + POLICY_FIELD_NUMBER;
          hash = (53 * hash) + getPolicy().hashCode();
          break;
        case 2:
          hash = (37 * hash) + INSTANCE_TEMPLATE_FIELD_NUMBER;
          hash = (53 * hash) + getInstanceTemplate().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * InstancePolicyOrTemplate lets you define the type of resources to use for
     * this job either with an InstancePolicy or an instance template.
     * If undefined, Batch picks the type of VM to use and doesn't include
     * optional VM resources such as GPUs and extra disks.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicyOrTemplate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicyOrTemplate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (policyBuilder_ != null) {
          policyBuilder_.clear();
        }
        installGpuDrivers_ = false;
        installOpsAgent_ = false;
        blockProjectSshKeys_ = false;
        policyTemplateCase_ = 0;
        policyTemplate_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_InstancePolicyOrTemplate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
          buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.installGpuDrivers_ = installGpuDrivers_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.installOpsAgent_ = installOpsAgent_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.blockProjectSshKeys_ = blockProjectSshKeys_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate result) {
        result.policyTemplateCase_ = policyTemplateCase_;
        result.policyTemplate_ = this.policyTemplate_;
        if (policyTemplateCase_ == 1 && policyBuilder_ != null) {
          result.policyTemplate_ = policyBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate) {
          return mergeFrom(
              (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
                .getDefaultInstance()) return this;
        if (other.getInstallGpuDrivers() != false) {
          setInstallGpuDrivers(other.getInstallGpuDrivers());
        }
        if (other.getInstallOpsAgent() != false) {
          setInstallOpsAgent(other.getInstallOpsAgent());
        }
        if (other.getBlockProjectSshKeys() != false) {
          setBlockProjectSshKeys(other.getBlockProjectSshKeys());
        }
        switch (other.getPolicyTemplateCase()) {
          case POLICY:
            {
              mergePolicy(other.getPolicy());
              break;
            }
          case INSTANCE_TEMPLATE:
            {
              policyTemplateCase_ = 2;
              policyTemplate_ = other.policyTemplate_;
              onChanged();
              break;
            }
          case POLICYTEMPLATE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getPolicyFieldBuilder().getBuilder(), extensionRegistry);
                  policyTemplateCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  policyTemplateCase_ = 2;
                  policyTemplate_ = s;
                  break;
                } // case 18
              case 24:
                {
                  installGpuDrivers_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  installOpsAgent_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  blockProjectSshKeys_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int policyTemplateCase_ = 0;
      private java.lang.Object policyTemplate_;

      public PolicyTemplateCase getPolicyTemplateCase() {
        return PolicyTemplateCase.forNumber(policyTemplateCase_);
      }

      public Builder clearPolicyTemplate() {
        policyTemplateCase_ = 0;
        policyTemplate_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>
          policyBuilder_;

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       *
       * @return Whether the policy field is set.
       */
      @java.lang.Override
      public boolean hasPolicy() {
        return policyTemplateCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       *
       * @return The policy.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy getPolicy() {
        if (policyBuilder_ == null) {
          if (policyTemplateCase_ == 1) {
            return (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_;
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
              .getDefaultInstance();
        } else {
          if (policyTemplateCase_ == 1) {
            return policyBuilder_.getMessage();
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      public Builder setPolicy(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy value) {
        if (policyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policyTemplate_ = value;
          onChanged();
        } else {
          policyBuilder_.setMessage(value);
        }
        policyTemplateCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      public Builder setPolicy(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder builderForValue) {
        if (policyBuilder_ == null) {
          policyTemplate_ = builderForValue.build();
          onChanged();
        } else {
          policyBuilder_.setMessage(builderForValue.build());
        }
        policyTemplateCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      public Builder mergePolicy(
          com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy value) {
        if (policyBuilder_ == null) {
          if (policyTemplateCase_ == 1
              && policyTemplate_
                  != com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
                      .getDefaultInstance()) {
            policyTemplate_ =
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.newBuilder(
                        (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy)
                            policyTemplate_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            policyTemplate_ = value;
          }
          onChanged();
        } else {
          if (policyTemplateCase_ == 1) {
            policyBuilder_.mergeFrom(value);
          } else {
            policyBuilder_.setMessage(value);
          }
        }
        policyTemplateCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      public Builder clearPolicy() {
        if (policyBuilder_ == null) {
          if (policyTemplateCase_ == 1) {
            policyTemplateCase_ = 0;
            policyTemplate_ = null;
            onChanged();
          }
        } else {
          if (policyTemplateCase_ == 1) {
            policyTemplateCase_ = 0;
            policyTemplate_ = null;
          }
          policyBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder
          getPolicyBuilder() {
        return getPolicyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder
          getPolicyOrBuilder() {
        if ((policyTemplateCase_ == 1) && (policyBuilder_ != null)) {
          return policyBuilder_.getMessageOrBuilder();
        } else {
          if (policyTemplateCase_ == 1) {
            return (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_;
          }
          return com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * InstancePolicy.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy policy = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>
          getPolicyFieldBuilder() {
        if (policyBuilder_ == null) {
          if (!(policyTemplateCase_ == 1)) {
            policyTemplate_ =
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance();
          }
          policyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>(
                  (com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy) policyTemplate_,
                  getParentForChildren(),
                  isClean());
          policyTemplate_ = null;
        }
        policyTemplateCase_ = 1;
        onChanged();
        return policyBuilder_;
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @return Whether the instanceTemplate field is set.
       */
      @java.lang.Override
      public boolean hasInstanceTemplate() {
        return policyTemplateCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @return The instanceTemplate.
       */
      @java.lang.Override
      public java.lang.String getInstanceTemplate() {
        java.lang.Object ref = "";
        if (policyTemplateCase_ == 2) {
          ref = policyTemplate_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (policyTemplateCase_ == 2) {
            policyTemplate_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @return The bytes for instanceTemplate.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getInstanceTemplateBytes() {
        java.lang.Object ref = "";
        if (policyTemplateCase_ == 2) {
          ref = policyTemplate_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (policyTemplateCase_ == 2) {
            policyTemplate_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @param value The instanceTemplate to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceTemplate(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        policyTemplateCase_ = 2;
        policyTemplate_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstanceTemplate() {
        if (policyTemplateCase_ == 2) {
          policyTemplateCase_ = 0;
          policyTemplate_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of an instance template used to create VMs.
       * Named the field as 'instance_template' instead of 'template' to avoid
       * C++ keyword conflict.
       *
       * Batch only supports global instance templates from the same project as
       * the job.
       * You can specify the global instance template as a full or partial URL.
       * </pre>
       *
       * <code>string instance_template = 2;</code>
       *
       * @param value The bytes for instanceTemplate to set.
       * @return This builder for chaining.
       */
      public Builder setInstanceTemplateBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        policyTemplateCase_ = 2;
        policyTemplate_ = value;
        onChanged();
        return this;
      }

      private boolean installGpuDrivers_;

      /**
       *
       *
       * <pre>
       * Set this field true if you want Batch to help fetch drivers from a third
       * party location and install them for GPUs specified in
       * `policy.accelerators` or `instance_template` on your behalf. Default is
       * false.
       *
       * For Container-Optimized Image cases, Batch will install the
       * accelerator driver following milestones of
       * https://cloud.google.com/container-optimized-os/docs/release-notes. For
       * non Container-Optimized Image cases, following
       * https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3;</code>
       *
       * @return The installGpuDrivers.
       */
      @java.lang.Override
      public boolean getInstallGpuDrivers() {
        return installGpuDrivers_;
      }

      /**
       *
       *
       * <pre>
       * Set this field true if you want Batch to help fetch drivers from a third
       * party location and install them for GPUs specified in
       * `policy.accelerators` or `instance_template` on your behalf. Default is
       * false.
       *
       * For Container-Optimized Image cases, Batch will install the
       * accelerator driver following milestones of
       * https://cloud.google.com/container-optimized-os/docs/release-notes. For
       * non Container-Optimized Image cases, following
       * https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3;</code>
       *
       * @param value The installGpuDrivers to set.
       * @return This builder for chaining.
       */
      public Builder setInstallGpuDrivers(boolean value) {

        installGpuDrivers_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set this field true if you want Batch to help fetch drivers from a third
       * party location and install them for GPUs specified in
       * `policy.accelerators` or `instance_template` on your behalf. Default is
       * false.
       *
       * For Container-Optimized Image cases, Batch will install the
       * accelerator driver following milestones of
       * https://cloud.google.com/container-optimized-os/docs/release-notes. For
       * non Container-Optimized Image cases, following
       * https://github.com/GoogleCloudPlatform/compute-gpu-installation/blob/main/linux/install_gpu_driver.py.
       * </pre>
       *
       * <code>bool install_gpu_drivers = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstallGpuDrivers() {
        bitField0_ = (bitField0_ & ~0x00000004);
        installGpuDrivers_ = false;
        onChanged();
        return this;
      }

      private boolean installOpsAgent_;

      /**
       *
       *
       * <pre>
       * Optional. Set this field true if you want Batch to install Ops Agent on
       * your behalf. Default is false.
       * </pre>
       *
       * <code>bool install_ops_agent = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The installOpsAgent.
       */
      @java.lang.Override
      public boolean getInstallOpsAgent() {
        return installOpsAgent_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Set this field true if you want Batch to install Ops Agent on
       * your behalf. Default is false.
       * </pre>
       *
       * <code>bool install_ops_agent = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The installOpsAgent to set.
       * @return This builder for chaining.
       */
      public Builder setInstallOpsAgent(boolean value) {

        installOpsAgent_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Set this field true if you want Batch to install Ops Agent on
       * your behalf. Default is false.
       * </pre>
       *
       * <code>bool install_ops_agent = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstallOpsAgent() {
        bitField0_ = (bitField0_ & ~0x00000008);
        installOpsAgent_ = false;
        onChanged();
        return this;
      }

      private boolean blockProjectSshKeys_;

      /**
       *
       *
       * <pre>
       * Optional. Set this field to `true` if you want Batch to block
       * project-level SSH keys from accessing this job's VMs.  Alternatively, you
       * can configure the job to specify a VM instance template that blocks
       * project-level SSH keys. In either case, Batch blocks project-level SSH
       * keys while creating the VMs for this job.
       *
       * Batch allows project-level SSH keys for a job's VMs only if all
       * the following are true:
       *
       * + This field is undefined or set to `false`.
       * + The job's VM instance template (if any) doesn't block project-level
       *   SSH keys.
       *
       * Notably, you can override this behavior by manually updating a VM to
       * block or allow project-level SSH keys. For more information about
       * blocking project-level SSH keys, see the Compute Engine documentation:
       * https://cloud.google.com/compute/docs/connect/restrict-ssh-keys#block-keys
       * </pre>
       *
       * <code>bool block_project_ssh_keys = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The blockProjectSshKeys.
       */
      @java.lang.Override
      public boolean getBlockProjectSshKeys() {
        return blockProjectSshKeys_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Set this field to `true` if you want Batch to block
       * project-level SSH keys from accessing this job's VMs.  Alternatively, you
       * can configure the job to specify a VM instance template that blocks
       * project-level SSH keys. In either case, Batch blocks project-level SSH
       * keys while creating the VMs for this job.
       *
       * Batch allows project-level SSH keys for a job's VMs only if all
       * the following are true:
       *
       * + This field is undefined or set to `false`.
       * + The job's VM instance template (if any) doesn't block project-level
       *   SSH keys.
       *
       * Notably, you can override this behavior by manually updating a VM to
       * block or allow project-level SSH keys. For more information about
       * blocking project-level SSH keys, see the Compute Engine documentation:
       * https://cloud.google.com/compute/docs/connect/restrict-ssh-keys#block-keys
       * </pre>
       *
       * <code>bool block_project_ssh_keys = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The blockProjectSshKeys to set.
       * @return This builder for chaining.
       */
      public Builder setBlockProjectSshKeys(boolean value) {

        blockProjectSshKeys_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Set this field to `true` if you want Batch to block
       * project-level SSH keys from accessing this job's VMs.  Alternatively, you
       * can configure the job to specify a VM instance template that blocks
       * project-level SSH keys. In either case, Batch blocks project-level SSH
       * keys while creating the VMs for this job.
       *
       * Batch allows project-level SSH keys for a job's VMs only if all
       * the following are true:
       *
       * + This field is undefined or set to `false`.
       * + The job's VM instance template (if any) doesn't block project-level
       *   SSH keys.
       *
       * Notably, you can override this behavior by manually updating a VM to
       * block or allow project-level SSH keys. For more information about
       * blocking project-level SSH keys, see the Compute Engine documentation:
       * https://cloud.google.com/compute/docs/connect/restrict-ssh-keys#block-keys
       * </pre>
       *
       * <code>bool block_project_ssh_keys = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockProjectSshKeys() {
        bitField0_ = (bitField0_ & ~0x00000010);
        blockProjectSshKeys_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstancePolicyOrTemplate> PARSER =
        new com.google.protobuf.AbstractParser<InstancePolicyOrTemplate>() {
          @java.lang.Override
          public InstancePolicyOrTemplate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstancePolicyOrTemplate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstancePolicyOrTemplate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkInterfaceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The URL of an existing network resource.
     * You can specify the network as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
     * * projects/{project}/global/networks/{network}
     * * global/networks/{network}
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The network.
     */
    java.lang.String getNetwork();

    /**
     *
     *
     * <pre>
     * The URL of an existing network resource.
     * You can specify the network as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
     * * projects/{project}/global/networks/{network}
     * * global/networks/{network}
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The bytes for network.
     */
    com.google.protobuf.ByteString getNetworkBytes();

    /**
     *
     *
     * <pre>
     * The URL of an existing subnetwork resource in the network.
     * You can specify the subnetwork as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * regions/{region}/subnetworks/{subnetwork}
     * </pre>
     *
     * <code>string subnetwork = 2;</code>
     *
     * @return The subnetwork.
     */
    java.lang.String getSubnetwork();

    /**
     *
     *
     * <pre>
     * The URL of an existing subnetwork resource in the network.
     * You can specify the subnetwork as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * regions/{region}/subnetworks/{subnetwork}
     * </pre>
     *
     * <code>string subnetwork = 2;</code>
     *
     * @return The bytes for subnetwork.
     */
    com.google.protobuf.ByteString getSubnetworkBytes();

    /**
     *
     *
     * <pre>
     * Default is false (with an external IP address). Required if
     * no external public IP address is attached to the VM. If no external
     * public IP address, additional configuration is required to allow the VM
     * to access Google Services. See
     * https://cloud.google.com/vpc/docs/configure-private-google-access and
     * https://cloud.google.com/nat/docs/gce-example#create-nat for more
     * information.
     * </pre>
     *
     * <code>bool no_external_ip_address = 3;</code>
     *
     * @return The noExternalIpAddress.
     */
    boolean getNoExternalIpAddress();
  }

  /**
   *
   *
   * <pre>
   * A network interface.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface}
   */
  public static final class NetworkInterface extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)
      NetworkInterfaceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NetworkInterface.newBuilder() to construct.
    private NetworkInterface(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkInterface() {
      network_ = "";
      subnetwork_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NetworkInterface();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkInterface_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkInterface_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder.class);
    }

    public static final int NETWORK_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * The URL of an existing network resource.
     * You can specify the network as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
     * * projects/{project}/global/networks/{network}
     * * global/networks/{network}
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The network.
     */
    @java.lang.Override
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of an existing network resource.
     * You can specify the network as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
     * * projects/{project}/global/networks/{network}
     * * global/networks/{network}
     * </pre>
     *
     * <code>string network = 1;</code>
     *
     * @return The bytes for network.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBNETWORK_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object subnetwork_ = "";

    /**
     *
     *
     * <pre>
     * The URL of an existing subnetwork resource in the network.
     * You can specify the subnetwork as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * regions/{region}/subnetworks/{subnetwork}
     * </pre>
     *
     * <code>string subnetwork = 2;</code>
     *
     * @return The subnetwork.
     */
    @java.lang.Override
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of an existing subnetwork resource in the network.
     * You can specify the subnetwork as a full or partial URL.
     *
     * For example, the following are all valid URLs:
     *
     * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
     * * regions/{region}/subnetworks/{subnetwork}
     * </pre>
     *
     * <code>string subnetwork = 2;</code>
     *
     * @return The bytes for subnetwork.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NO_EXTERNAL_IP_ADDRESS_FIELD_NUMBER = 3;
    private boolean noExternalIpAddress_ = false;

    /**
     *
     *
     * <pre>
     * Default is false (with an external IP address). Required if
     * no external public IP address is attached to the VM. If no external
     * public IP address, additional configuration is required to allow the VM
     * to access Google Services. See
     * https://cloud.google.com/vpc/docs/configure-private-google-access and
     * https://cloud.google.com/nat/docs/gce-example#create-nat for more
     * information.
     * </pre>
     *
     * <code>bool no_external_ip_address = 3;</code>
     *
     * @return The noExternalIpAddress.
     */
    @java.lang.Override
    public boolean getNoExternalIpAddress() {
      return noExternalIpAddress_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, network_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subnetwork_);
      }
      if (noExternalIpAddress_ != false) {
        output.writeBool(3, noExternalIpAddress_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, network_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subnetwork_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subnetwork_);
      }
      if (noExternalIpAddress_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, noExternalIpAddress_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface) obj;

      if (!getNetwork().equals(other.getNetwork())) return false;
      if (!getSubnetwork().equals(other.getSubnetwork())) return false;
      if (getNoExternalIpAddress() != other.getNoExternalIpAddress()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
      hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetwork().hashCode();
      hash = (37 * hash) + NO_EXTERNAL_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoExternalIpAddress());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A network interface.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkInterface_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkInterface_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder.class);
      }

      // Construct using
      // com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        network_ = "";
        subnetwork_ = "";
        noExternalIpAddress_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkInterface_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.network_ = network_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.subnetwork_ = subnetwork_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.noExternalIpAddress_ = noExternalIpAddress_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface) {
          return mergeFrom(
              (com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
                .getDefaultInstance()) return this;
        if (!other.getNetwork().isEmpty()) {
          network_ = other.network_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getSubnetwork().isEmpty()) {
          subnetwork_ = other.subnetwork_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getNoExternalIpAddress() != false) {
          setNoExternalIpAddress(other.getNoExternalIpAddress());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  network_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  subnetwork_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  noExternalIpAddress_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object network_ = "";

      /**
       *
       *
       * <pre>
       * The URL of an existing network resource.
       * You can specify the network as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
       * * projects/{project}/global/networks/{network}
       * * global/networks/{network}
       * </pre>
       *
       * <code>string network = 1;</code>
       *
       * @return The network.
       */
      public java.lang.String getNetwork() {
        java.lang.Object ref = network_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          network_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing network resource.
       * You can specify the network as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
       * * projects/{project}/global/networks/{network}
       * * global/networks/{network}
       * </pre>
       *
       * <code>string network = 1;</code>
       *
       * @return The bytes for network.
       */
      public com.google.protobuf.ByteString getNetworkBytes() {
        java.lang.Object ref = network_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          network_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing network resource.
       * You can specify the network as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
       * * projects/{project}/global/networks/{network}
       * * global/networks/{network}
       * </pre>
       *
       * <code>string network = 1;</code>
       *
       * @param value The network to set.
       * @return This builder for chaining.
       */
      public Builder setNetwork(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing network resource.
       * You can specify the network as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
       * * projects/{project}/global/networks/{network}
       * * global/networks/{network}
       * </pre>
       *
       * <code>string network = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNetwork() {
        network_ = getDefaultInstance().getNetwork();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing network resource.
       * You can specify the network as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}
       * * projects/{project}/global/networks/{network}
       * * global/networks/{network}
       * </pre>
       *
       * <code>string network = 1;</code>
       *
       * @param value The bytes for network to set.
       * @return This builder for chaining.
       */
      public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        network_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object subnetwork_ = "";

      /**
       *
       *
       * <pre>
       * The URL of an existing subnetwork resource in the network.
       * You can specify the subnetwork as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * regions/{region}/subnetworks/{subnetwork}
       * </pre>
       *
       * <code>string subnetwork = 2;</code>
       *
       * @return The subnetwork.
       */
      public java.lang.String getSubnetwork() {
        java.lang.Object ref = subnetwork_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subnetwork_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing subnetwork resource in the network.
       * You can specify the subnetwork as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * regions/{region}/subnetworks/{subnetwork}
       * </pre>
       *
       * <code>string subnetwork = 2;</code>
       *
       * @return The bytes for subnetwork.
       */
      public com.google.protobuf.ByteString getSubnetworkBytes() {
        java.lang.Object ref = subnetwork_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subnetwork_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing subnetwork resource in the network.
       * You can specify the subnetwork as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * regions/{region}/subnetworks/{subnetwork}
       * </pre>
       *
       * <code>string subnetwork = 2;</code>
       *
       * @param value The subnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setSubnetwork(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        subnetwork_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing subnetwork resource in the network.
       * You can specify the subnetwork as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * regions/{region}/subnetworks/{subnetwork}
       * </pre>
       *
       * <code>string subnetwork = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubnetwork() {
        subnetwork_ = getDefaultInstance().getSubnetwork();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The URL of an existing subnetwork resource in the network.
       * You can specify the subnetwork as a full or partial URL.
       *
       * For example, the following are all valid URLs:
       *
       * * https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * projects/{project}/regions/{region}/subnetworks/{subnetwork}
       * * regions/{region}/subnetworks/{subnetwork}
       * </pre>
       *
       * <code>string subnetwork = 2;</code>
       *
       * @param value The bytes for subnetwork to set.
       * @return This builder for chaining.
       */
      public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        subnetwork_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean noExternalIpAddress_;

      /**
       *
       *
       * <pre>
       * Default is false (with an external IP address). Required if
       * no external public IP address is attached to the VM. If no external
       * public IP address, additional configuration is required to allow the VM
       * to access Google Services. See
       * https://cloud.google.com/vpc/docs/configure-private-google-access and
       * https://cloud.google.com/nat/docs/gce-example#create-nat for more
       * information.
       * </pre>
       *
       * <code>bool no_external_ip_address = 3;</code>
       *
       * @return The noExternalIpAddress.
       */
      @java.lang.Override
      public boolean getNoExternalIpAddress() {
        return noExternalIpAddress_;
      }

      /**
       *
       *
       * <pre>
       * Default is false (with an external IP address). Required if
       * no external public IP address is attached to the VM. If no external
       * public IP address, additional configuration is required to allow the VM
       * to access Google Services. See
       * https://cloud.google.com/vpc/docs/configure-private-google-access and
       * https://cloud.google.com/nat/docs/gce-example#create-nat for more
       * information.
       * </pre>
       *
       * <code>bool no_external_ip_address = 3;</code>
       *
       * @param value The noExternalIpAddress to set.
       * @return This builder for chaining.
       */
      public Builder setNoExternalIpAddress(boolean value) {

        noExternalIpAddress_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Default is false (with an external IP address). Required if
       * no external public IP address is attached to the VM. If no external
       * public IP address, additional configuration is required to allow the VM
       * to access Google Services. See
       * https://cloud.google.com/vpc/docs/configure-private-google-access and
       * https://cloud.google.com/nat/docs/gce-example#create-nat for more
       * information.
       * </pre>
       *
       * <code>bool no_external_ip_address = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNoExternalIpAddress() {
        bitField0_ = (bitField0_ & ~0x00000004);
        noExternalIpAddress_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NetworkInterface> PARSER =
        new com.google.protobuf.AbstractParser<NetworkInterface>() {
          @java.lang.Override
          public NetworkInterface parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NetworkInterface> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkInterface> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
        getNetworkInterfacesList();

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface getNetworkInterfaces(
        int index);

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    int getNetworkInterfacesCount();

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder
        getNetworkInterfacesOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * NetworkPolicy describes VM instance network configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy}
   */
  public static final class NetworkPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)
      NetworkPolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NetworkPolicy.newBuilder() to construct.
    private NetworkPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicy() {
      networkInterfaces_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NetworkPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder.class);
    }

    public static final int NETWORK_INTERFACES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
        networkInterfaces_;

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
        getNetworkInterfacesList() {
      return networkInterfaces_;
    }

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList() {
      return networkInterfaces_;
    }

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    @java.lang.Override
    public int getNetworkInterfacesCount() {
      return networkInterfaces_.size();
    }

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface getNetworkInterfaces(
        int index) {
      return networkInterfaces_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Network configurations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder
        getNetworkInterfacesOrBuilder(int index) {
      return networkInterfaces_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < networkInterfaces_.size(); i++) {
        output.writeMessage(1, networkInterfaces_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < networkInterfaces_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, networkInterfaces_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy) obj;

      if (!getNetworkInterfacesList().equals(other.getNetworkInterfacesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getNetworkInterfacesCount() > 0) {
        hash = (37 * hash) + NETWORK_INTERFACES_FIELD_NUMBER;
        hash = (53 * hash) + getNetworkInterfacesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * NetworkPolicy describes VM instance network configurations.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (networkInterfacesBuilder_ == null) {
          networkInterfaces_ = java.util.Collections.emptyList();
        } else {
          networkInterfaces_ = null;
          networkInterfacesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_NetworkPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy result) {
        if (networkInterfacesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            networkInterfaces_ = java.util.Collections.unmodifiableList(networkInterfaces_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.networkInterfaces_ = networkInterfaces_;
        } else {
          result.networkInterfaces_ = networkInterfacesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance())
          return this;
        if (networkInterfacesBuilder_ == null) {
          if (!other.networkInterfaces_.isEmpty()) {
            if (networkInterfaces_.isEmpty()) {
              networkInterfaces_ = other.networkInterfaces_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureNetworkInterfacesIsMutable();
              networkInterfaces_.addAll(other.networkInterfaces_);
            }
            onChanged();
          }
        } else {
          if (!other.networkInterfaces_.isEmpty()) {
            if (networkInterfacesBuilder_.isEmpty()) {
              networkInterfacesBuilder_.dispose();
              networkInterfacesBuilder_ = null;
              networkInterfaces_ = other.networkInterfaces_;
              bitField0_ = (bitField0_ & ~0x00000001);
              networkInterfacesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getNetworkInterfacesFieldBuilder()
                      : null;
            } else {
              networkInterfacesBuilder_.addAllMessages(other.networkInterfaces_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface m =
                      input.readMessage(
                          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.parser(),
                          extensionRegistry);
                  if (networkInterfacesBuilder_ == null) {
                    ensureNetworkInterfacesIsMutable();
                    networkInterfaces_.add(m);
                  } else {
                    networkInterfacesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
          networkInterfaces_ = java.util.Collections.emptyList();

      private void ensureNetworkInterfacesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          networkInterfaces_ =
              new java.util.ArrayList<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>(
                  networkInterfaces_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>
          networkInterfacesBuilder_;

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
          getNetworkInterfacesList() {
        if (networkInterfacesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(networkInterfaces_);
        } else {
          return networkInterfacesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public int getNetworkInterfacesCount() {
        if (networkInterfacesBuilder_ == null) {
          return networkInterfaces_.size();
        } else {
          return networkInterfacesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface getNetworkInterfaces(
          int index) {
        if (networkInterfacesBuilder_ == null) {
          return networkInterfaces_.get(index);
        } else {
          return networkInterfacesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder setNetworkInterfaces(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface value) {
        if (networkInterfacesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.set(index, value);
          onChanged();
        } else {
          networkInterfacesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder setNetworkInterfaces(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
              builderForValue) {
        if (networkInterfacesBuilder_ == null) {
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.set(index, builderForValue.build());
          onChanged();
        } else {
          networkInterfacesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder addNetworkInterfaces(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface value) {
        if (networkInterfacesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.add(value);
          onChanged();
        } else {
          networkInterfacesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder addNetworkInterfaces(
          int index, com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface value) {
        if (networkInterfacesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.add(index, value);
          onChanged();
        } else {
          networkInterfacesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder addNetworkInterfaces(
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
              builderForValue) {
        if (networkInterfacesBuilder_ == null) {
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.add(builderForValue.build());
          onChanged();
        } else {
          networkInterfacesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder addNetworkInterfaces(
          int index,
          com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
              builderForValue) {
        if (networkInterfacesBuilder_ == null) {
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.add(index, builderForValue.build());
          onChanged();
        } else {
          networkInterfacesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder addAllNetworkInterfaces(
          java.lang.Iterable<
                  ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface>
              values) {
        if (networkInterfacesBuilder_ == null) {
          ensureNetworkInterfacesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkInterfaces_);
          onChanged();
        } else {
          networkInterfacesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder clearNetworkInterfaces() {
        if (networkInterfacesBuilder_ == null) {
          networkInterfaces_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          networkInterfacesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public Builder removeNetworkInterfaces(int index) {
        if (networkInterfacesBuilder_ == null) {
          ensureNetworkInterfacesIsMutable();
          networkInterfaces_.remove(index);
          onChanged();
        } else {
          networkInterfacesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
          getNetworkInterfacesBuilder(int index) {
        return getNetworkInterfacesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder
          getNetworkInterfacesOrBuilder(int index) {
        if (networkInterfacesBuilder_ == null) {
          return networkInterfaces_.get(index);
        } else {
          return networkInterfacesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>
          getNetworkInterfacesOrBuilderList() {
        if (networkInterfacesBuilder_ != null) {
          return networkInterfacesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(networkInterfaces_);
        }
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
          addNetworkInterfacesBuilder() {
        return getNetworkInterfacesFieldBuilder()
            .addBuilder(
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder
          addNetworkInterfacesBuilder(int index) {
        return getNetworkInterfacesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Network configurations.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface network_interfaces = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder>
          getNetworkInterfacesBuilderList() {
        return getNetworkInterfacesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>
          getNetworkInterfacesFieldBuilder() {
        if (networkInterfacesBuilder_ == null) {
          networkInterfacesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterface.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkInterfaceOrBuilder>(
                  networkInterfaces_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          networkInterfaces_ = null;
        }
        return networkInterfacesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NetworkPolicy> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPolicy>() {
          @java.lang.Override
          public NetworkPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NetworkPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PlacementPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
     * want VMs to be located close to each other for low network latency
     * between the VMs. No placement policy will be generated when collocation
     * is UNSPECIFIED.
     * </pre>
     *
     * <code>string collocation = 1;</code>
     *
     * @return The collocation.
     */
    java.lang.String getCollocation();

    /**
     *
     *
     * <pre>
     * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
     * want VMs to be located close to each other for low network latency
     * between the VMs. No placement policy will be generated when collocation
     * is UNSPECIFIED.
     * </pre>
     *
     * <code>string collocation = 1;</code>
     *
     * @return The bytes for collocation.
     */
    com.google.protobuf.ByteString getCollocationBytes();

    /**
     *
     *
     * <pre>
     * When specified, causes the job to fail if more than max_distance logical
     * switches are required between VMs. Batch uses the most compact possible
     * placement of VMs even when max_distance is not specified. An explicit
     * max_distance makes that level of compactness a strict requirement.
     * Not yet implemented
     * </pre>
     *
     * <code>int64 max_distance = 2;</code>
     *
     * @return The maxDistance.
     */
    long getMaxDistance();
  }

  /**
   *
   *
   * <pre>
   * PlacementPolicy describes a group placement policy for the VMs controlled
   * by this AllocationPolicy.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy}
   */
  public static final class PlacementPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)
      PlacementPolicyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PlacementPolicy.newBuilder() to construct.
    private PlacementPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PlacementPolicy() {
      collocation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PlacementPolicy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_PlacementPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_PlacementPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder.class);
    }

    public static final int COLLOCATION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object collocation_ = "";

    /**
     *
     *
     * <pre>
     * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
     * want VMs to be located close to each other for low network latency
     * between the VMs. No placement policy will be generated when collocation
     * is UNSPECIFIED.
     * </pre>
     *
     * <code>string collocation = 1;</code>
     *
     * @return The collocation.
     */
    @java.lang.Override
    public java.lang.String getCollocation() {
      java.lang.Object ref = collocation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        collocation_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
     * want VMs to be located close to each other for low network latency
     * between the VMs. No placement policy will be generated when collocation
     * is UNSPECIFIED.
     * </pre>
     *
     * <code>string collocation = 1;</code>
     *
     * @return The bytes for collocation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCollocationBytes() {
      java.lang.Object ref = collocation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        collocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAX_DISTANCE_FIELD_NUMBER = 2;
    private long maxDistance_ = 0L;

    /**
     *
     *
     * <pre>
     * When specified, causes the job to fail if more than max_distance logical
     * switches are required between VMs. Batch uses the most compact possible
     * placement of VMs even when max_distance is not specified. An explicit
     * max_distance makes that level of compactness a strict requirement.
     * Not yet implemented
     * </pre>
     *
     * <code>int64 max_distance = 2;</code>
     *
     * @return The maxDistance.
     */
    @java.lang.Override
    public long getMaxDistance() {
      return maxDistance_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collocation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, collocation_);
      }
      if (maxDistance_ != 0L) {
        output.writeInt64(2, maxDistance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(collocation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, collocation_);
      }
      if (maxDistance_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, maxDistance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy other =
          (com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy) obj;

      if (!getCollocation().equals(other.getCollocation())) return false;
      if (getMaxDistance() != other.getMaxDistance()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + COLLOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getCollocation().hashCode();
      hash = (37 * hash) + MAX_DISTANCE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxDistance());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * PlacementPolicy describes a group placement policy for the VMs controlled
     * by this AllocationPolicy.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_PlacementPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_PlacementPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.class,
                com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder.class);
      }

      // Construct using
      // com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        collocation_ = "";
        maxDistance_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_PlacementPolicy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
          getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy build() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy buildPartial() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy result =
            new com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.collocation_ = collocation_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.maxDistance_ = maxDistance_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy) {
          return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy other) {
        if (other
            == com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance())
          return this;
        if (!other.getCollocation().isEmpty()) {
          collocation_ = other.collocation_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getMaxDistance() != 0L) {
          setMaxDistance(other.getMaxDistance());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  collocation_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  maxDistance_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object collocation_ = "";

      /**
       *
       *
       * <pre>
       * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
       * want VMs to be located close to each other for low network latency
       * between the VMs. No placement policy will be generated when collocation
       * is UNSPECIFIED.
       * </pre>
       *
       * <code>string collocation = 1;</code>
       *
       * @return The collocation.
       */
      public java.lang.String getCollocation() {
        java.lang.Object ref = collocation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          collocation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
       * want VMs to be located close to each other for low network latency
       * between the VMs. No placement policy will be generated when collocation
       * is UNSPECIFIED.
       * </pre>
       *
       * <code>string collocation = 1;</code>
       *
       * @return The bytes for collocation.
       */
      public com.google.protobuf.ByteString getCollocationBytes() {
        java.lang.Object ref = collocation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          collocation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
       * want VMs to be located close to each other for low network latency
       * between the VMs. No placement policy will be generated when collocation
       * is UNSPECIFIED.
       * </pre>
       *
       * <code>string collocation = 1;</code>
       *
       * @param value The collocation to set.
       * @return This builder for chaining.
       */
      public Builder setCollocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        collocation_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
       * want VMs to be located close to each other for low network latency
       * between the VMs. No placement policy will be generated when collocation
       * is UNSPECIFIED.
       * </pre>
       *
       * <code>string collocation = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCollocation() {
        collocation_ = getDefaultInstance().getCollocation();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * UNSPECIFIED vs. COLLOCATED (default UNSPECIFIED). Use COLLOCATED when you
       * want VMs to be located close to each other for low network latency
       * between the VMs. No placement policy will be generated when collocation
       * is UNSPECIFIED.
       * </pre>
       *
       * <code>string collocation = 1;</code>
       *
       * @param value The bytes for collocation to set.
       * @return This builder for chaining.
       */
      public Builder setCollocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        collocation_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long maxDistance_;

      /**
       *
       *
       * <pre>
       * When specified, causes the job to fail if more than max_distance logical
       * switches are required between VMs. Batch uses the most compact possible
       * placement of VMs even when max_distance is not specified. An explicit
       * max_distance makes that level of compactness a strict requirement.
       * Not yet implemented
       * </pre>
       *
       * <code>int64 max_distance = 2;</code>
       *
       * @return The maxDistance.
       */
      @java.lang.Override
      public long getMaxDistance() {
        return maxDistance_;
      }

      /**
       *
       *
       * <pre>
       * When specified, causes the job to fail if more than max_distance logical
       * switches are required between VMs. Batch uses the most compact possible
       * placement of VMs even when max_distance is not specified. An explicit
       * max_distance makes that level of compactness a strict requirement.
       * Not yet implemented
       * </pre>
       *
       * <code>int64 max_distance = 2;</code>
       *
       * @param value The maxDistance to set.
       * @return This builder for chaining.
       */
      public Builder setMaxDistance(long value) {

        maxDistance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * When specified, causes the job to fail if more than max_distance logical
       * switches are required between VMs. Batch uses the most compact possible
       * placement of VMs even when max_distance is not specified. An explicit
       * max_distance makes that level of compactness a strict requirement.
       * Not yet implemented
       * </pre>
       *
       * <code>int64 max_distance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxDistance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        maxDistance_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy)
    private static final com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy();
    }

    public static com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PlacementPolicy> PARSER =
        new com.google.protobuf.AbstractParser<PlacementPolicy>() {
          @java.lang.Override
          public PlacementPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PlacementPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PlacementPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int LOCATION_FIELD_NUMBER = 1;
  private com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location_;

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy getLocation() {
    return location_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance()
        : location_;
  }

  /**
   *
   *
   * <pre>
   * Location where compute resources should be allocated for the Job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder
      getLocationOrBuilder() {
    return location_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance()
        : location_;
  }

  public static final int INSTANCE_FIELD_NUMBER = 2;
  private com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance_;

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy instead.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=642
   * @return Whether the instance field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasInstance() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy instead.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=642
   * @return The instance.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy getInstance() {
    return instance_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance()
        : instance_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy instead.
   * </pre>
   *
   * <code>
   * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder
      getInstanceOrBuilder() {
    return instance_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance()
        : instance_;
  }

  public static final int INSTANCES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>
      instances_;

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>
      getInstancesList() {
    return instances_;
  }

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>
      getInstancesOrBuilderList() {
    return instances_;
  }

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  @java.lang.Override
  public int getInstancesCount() {
    return instances_.size();
  }

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate getInstances(
      int index) {
    return instances_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Describe instances that can be created by this AllocationPolicy.
   * Only instances[0] is supported now.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder
      getInstancesOrBuilder(int index) {
    return instances_.get(index);
  }

  public static final int INSTANCE_TEMPLATES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList instanceTemplates_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].template instead.
   * </pre>
   *
   * <code>repeated string instance_templates = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=649
   * @return A list containing the instanceTemplates.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getInstanceTemplatesList() {
    return instanceTemplates_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].template instead.
   * </pre>
   *
   * <code>repeated string instance_templates = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=649
   * @return The count of instanceTemplates.
   */
  @java.lang.Deprecated
  public int getInstanceTemplatesCount() {
    return instanceTemplates_.size();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].template instead.
   * </pre>
   *
   * <code>repeated string instance_templates = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=649
   * @param index The index of the element to return.
   * @return The instanceTemplates at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getInstanceTemplates(int index) {
    return instanceTemplates_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].template instead.
   * </pre>
   *
   * <code>repeated string instance_templates = 3 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=649
   * @param index The index of the value to return.
   * @return The bytes of the instanceTemplates at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getInstanceTemplatesBytes(int index) {
    return instanceTemplates_.getByteString(index);
  }

  public static final int PROVISIONING_MODELS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> provisioningModels_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>
      provisioningModels_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>() {
            public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel convert(
                java.lang.Integer from) {
              com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel result =
                  com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.forNumber(from);
              return result == null
                  ? com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy.provisioning_model instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=652
   * @return A list containing the provisioningModels.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>
      getProvisioningModelsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>(
        provisioningModels_, provisioningModels_converter_);
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy.provisioning_model instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=652
   * @return The count of provisioningModels.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getProvisioningModelsCount() {
    return provisioningModels_.size();
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy.provisioning_model instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=652
   * @param index The index of the element to return.
   * @return The provisioningModels at the given index.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel getProvisioningModels(
      int index) {
    return provisioningModels_converter_.convert(provisioningModels_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy.provisioning_model instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=652
   * @return A list containing the enum numeric values on the wire for provisioningModels.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<java.lang.Integer> getProvisioningModelsValueList() {
    return provisioningModels_;
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use instances[0].policy.provisioning_model instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated. See
   *     google/cloud/batch/v1alpha/job.proto;l=652
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of provisioningModels at the given index.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getProvisioningModelsValue(int index) {
    return provisioningModels_.get(index);
  }

  private int provisioningModelsMemoizedSerializedSize;

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";

  /**
   *
   *
   * <pre>
   * Deprecated: please use service_account instead.
   * </pre>
   *
   * <code>string service_account_email = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
   *     See google/cloud/batch/v1alpha/job.proto;l=655
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Deprecated: please use service_account instead.
   * </pre>
   *
   * <code>string service_account_email = 5 [deprecated = true];</code>
   *
   * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
   *     See google/cloud/batch/v1alpha/job.proto;l=655
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 9;
  private com.google.cloud.batch.v1alpha.ServiceAccount serviceAccount_;

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  @java.lang.Override
  public boolean hasServiceAccount() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ServiceAccount getServiceAccount() {
    return serviceAccount_ == null
        ? com.google.cloud.batch.v1alpha.ServiceAccount.getDefaultInstance()
        : serviceAccount_;
  }

  /**
   *
   *
   * <pre>
   * Defines the service account for Batch-created VMs. If omitted, the [default
   * Compute Engine service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. Must match the service account specified in any used instance
   * template configured in the Batch job.
   *
   * Includes the following fields:
   *  * email: The service account's email address. If not set, the default
   *  Compute Engine service account is used.
   *  * scopes: Additional OAuth scopes to grant the service account, beyond the
   *  default cloud-platform scope. (list of strings)
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ServiceAccountOrBuilder getServiceAccountOrBuilder() {
    return serviceAccount_ == null
        ? com.google.cloud.batch.v1alpha.ServiceAccount.getDefaultInstance()
        : serviceAccount_;
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1alpha.JobProto
                .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Custom labels to apply to the job and all the Compute Engine resources
   * that both are created by this allocation policy and support labels.
   *
   * Use labels to group and describe the resources they are applied to. Batch
   * automatically applies predefined labels and supports multiple `labels`
   * fields for each job, which each let you apply custom labels to various
   * resources. Label names that start with "goog-" or "google-" are
   * reserved for predefined labels. For more information about labels with
   * Batch, see
   * [Organize resources using
   * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_FIELD_NUMBER = 7;
  private com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network_;

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy getNetwork() {
    return network_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance()
        : network_;
  }

  /**
   *
   *
   * <pre>
   * The network policy.
   *
   * If you define an instance template in the `InstancePolicyOrTemplate` field,
   * Batch will use the network settings in the instance template instead of
   * this field.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder
      getNetworkOrBuilder() {
    return network_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance()
        : network_;
  }

  public static final int PLACEMENT_FIELD_NUMBER = 10;
  private com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement_;

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
   *
   * @return Whether the placement field is set.
   */
  @java.lang.Override
  public boolean hasPlacement() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
   *
   * @return The placement.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy getPlacement() {
    return placement_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance()
        : placement_;
  }

  /**
   *
   *
   * <pre>
   * The placement policy.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder
      getPlacementOrBuilder() {
    return placement_ == null
        ? com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance()
        : placement_;
  }

  public static final int TAGS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Tags applied to the VM instances.
   *
   * The tags identify valid sources or targets for network firewalls.
   * Each tag must be 1-63 characters long, and comply with
   * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
   * </pre>
   *
   * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getLocation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getInstance());
    }
    for (int i = 0; i < instanceTemplates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, instanceTemplates_.getRaw(i));
    }
    if (getProvisioningModelsList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(provisioningModelsMemoizedSerializedSize);
    }
    for (int i = 0; i < provisioningModels_.size(); i++) {
      output.writeEnumNoTag(provisioningModels_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccountEmail_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getNetwork());
    }
    for (int i = 0; i < instances_.size(); i++) {
      output.writeMessage(8, instances_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getServiceAccount());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getPlacement());
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, tags_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLocation());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInstance());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < instanceTemplates_.size(); i++) {
        dataSize += computeStringSizeNoTag(instanceTemplates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInstanceTemplatesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < provisioningModels_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(provisioningModels_.get(i));
      }
      size += dataSize;
      if (!getProvisioningModelsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      provisioningModelsMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccountEmail_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNetwork());
    }
    for (int i = 0; i < instances_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, instances_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getServiceAccount());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getPlacement());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.AllocationPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.AllocationPolicy other =
        (com.google.cloud.batch.v1alpha.AllocationPolicy) obj;

    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (hasInstance() != other.hasInstance()) return false;
    if (hasInstance()) {
      if (!getInstance().equals(other.getInstance())) return false;
    }
    if (!getInstancesList().equals(other.getInstancesList())) return false;
    if (!getInstanceTemplatesList().equals(other.getInstanceTemplatesList())) return false;
    if (!provisioningModels_.equals(other.provisioningModels_)) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (hasServiceAccount() != other.hasServiceAccount()) return false;
    if (hasServiceAccount()) {
      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasPlacement() != other.hasPlacement()) return false;
    if (hasPlacement()) {
      if (!getPlacement().equals(other.getPlacement())) return false;
    }
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (hasInstance()) {
      hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstance().hashCode();
    }
    if (getInstancesCount() > 0) {
      hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
      hash = (53 * hash) + getInstancesList().hashCode();
    }
    if (getInstanceTemplatesCount() > 0) {
      hash = (37 * hash) + INSTANCE_TEMPLATES_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceTemplatesList().hashCode();
    }
    if (getProvisioningModelsCount() > 0) {
      hash = (37 * hash) + PROVISIONING_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + provisioningModels_.hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    if (hasServiceAccount()) {
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasPlacement()) {
      hash = (37 * hash) + PLACEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPlacement().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.AllocationPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A Job's resource allocation policy describes when, where, and how compute
   * resources should be allocated for the Job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.AllocationPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.AllocationPolicy)
      com.google.cloud.batch.v1alpha.AllocationPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.AllocationPolicy.class,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.AllocationPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLocationFieldBuilder();
        getInstanceFieldBuilder();
        getInstancesFieldBuilder();
        getServiceAccountFieldBuilder();
        getNetworkFieldBuilder();
        getPlacementFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = null;
      if (locationBuilder_ != null) {
        locationBuilder_.dispose();
        locationBuilder_ = null;
      }
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
      } else {
        instances_ = null;
        instancesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      instanceTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      provisioningModels_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      serviceAccountEmail_ = "";
      serviceAccount_ = null;
      if (serviceAccountBuilder_ != null) {
        serviceAccountBuilder_.dispose();
        serviceAccountBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_AllocationPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.AllocationPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy build() {
      com.google.cloud.batch.v1alpha.AllocationPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy buildPartial() {
      com.google.cloud.batch.v1alpha.AllocationPolicy result =
          new com.google.cloud.batch.v1alpha.AllocationPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.batch.v1alpha.AllocationPolicy result) {
      if (instancesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          instances_ = java.util.Collections.unmodifiableList(instances_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.instances_ = instances_;
      } else {
        result.instances_ = instancesBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        provisioningModels_ = java.util.Collections.unmodifiableList(provisioningModels_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.provisioningModels_ = provisioningModels_;
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.AllocationPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = locationBuilder_ == null ? location_ : locationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instance_ = instanceBuilder_ == null ? instance_ : instanceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        instanceTemplates_.makeImmutable();
        result.instanceTemplates_ = instanceTemplates_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.serviceAccount_ =
            serviceAccountBuilder_ == null ? serviceAccount_ : serviceAccountBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.network_ = networkBuilder_ == null ? network_ : networkBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.placement_ = placementBuilder_ == null ? placement_ : placementBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.AllocationPolicy) {
        return mergeFrom((com.google.cloud.batch.v1alpha.AllocationPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.AllocationPolicy other) {
      if (other == com.google.cloud.batch.v1alpha.AllocationPolicy.getDefaultInstance())
        return this;
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (other.hasInstance()) {
        mergeInstance(other.getInstance());
      }
      if (instancesBuilder_ == null) {
        if (!other.instances_.isEmpty()) {
          if (instances_.isEmpty()) {
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureInstancesIsMutable();
            instances_.addAll(other.instances_);
          }
          onChanged();
        }
      } else {
        if (!other.instances_.isEmpty()) {
          if (instancesBuilder_.isEmpty()) {
            instancesBuilder_.dispose();
            instancesBuilder_ = null;
            instances_ = other.instances_;
            bitField0_ = (bitField0_ & ~0x00000004);
            instancesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstancesFieldBuilder()
                    : null;
          } else {
            instancesBuilder_.addAllMessages(other.instances_);
          }
        }
      }
      if (!other.instanceTemplates_.isEmpty()) {
        if (instanceTemplates_.isEmpty()) {
          instanceTemplates_ = other.instanceTemplates_;
          bitField0_ |= 0x00000008;
        } else {
          ensureInstanceTemplatesIsMutable();
          instanceTemplates_.addAll(other.instanceTemplates_);
        }
        onChanged();
      }
      if (!other.provisioningModels_.isEmpty()) {
        if (provisioningModels_.isEmpty()) {
          provisioningModels_ = other.provisioningModels_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureProvisioningModelsIsMutable();
          provisioningModels_.addAll(other.provisioningModels_);
        }
        onChanged();
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasServiceAccount()) {
        mergeServiceAccount(other.getServiceAccount());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.hasNetwork()) {
        mergeNetwork(other.getNetwork());
      }
      if (other.hasPlacement()) {
        mergePlacement(other.getPlacement());
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000400;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInstanceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInstanceTemplatesIsMutable();
                instanceTemplates_.add(s);
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureProvisioningModelsIsMutable();
                provisioningModels_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureProvisioningModelsIsMutable();
                  provisioningModels_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 42:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate m =
                    input.readMessage(
                        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
                            .parser(),
                        extensionRegistry);
                if (instancesBuilder_ == null) {
                  ensureInstancesIsMutable();
                  instances_.add(m);
                } else {
                  instancesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getServiceAccountFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getPlacementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder>
        locationBuilder_;

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     *
     * @return The location.
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance()
            : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public Builder setLocation(
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
      } else {
        locationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public Builder setLocation(
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public Builder mergeLocation(
        com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy value) {
      if (locationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && location_ != null
            && location_
                != com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy
                    .getDefaultInstance()) {
          getLocationBuilder().mergeFrom(value);
        } else {
          location_ = value;
        }
      } else {
        locationBuilder_.mergeFrom(value);
      }
      if (location_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public Builder clearLocation() {
      bitField0_ = (bitField0_ & ~0x00000001);
      location_ = null;
      if (locationBuilder_ != null) {
        locationBuilder_.dispose();
        locationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder
        getLocationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder
        getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.getDefaultInstance()
            : location_;
      }
    }

    /**
     *
     *
     * <pre>
     * Location where compute resources should be allocated for the Job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy location = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy,
                com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicy.Builder,
                com.google.cloud.batch.v1alpha.AllocationPolicy.LocationPolicyOrBuilder>(
                getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>
        instanceBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=642
     * @return Whether the instance field is set.
     */
    @java.lang.Deprecated
    public boolean hasInstance() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=642
     * @return The instance.
     */
    @java.lang.Deprecated
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy getInstance() {
      if (instanceBuilder_ == null) {
        return instance_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance()
            : instance_;
      } else {
        return instanceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInstance(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy value) {
      if (instanceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instance_ = value;
      } else {
        instanceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInstance(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder builderForValue) {
      if (instanceBuilder_ == null) {
        instance_ = builderForValue.build();
      } else {
        instanceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeInstance(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy value) {
      if (instanceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && instance_ != null
            && instance_
                != com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy
                    .getDefaultInstance()) {
          getInstanceBuilder().mergeFrom(value);
        } else {
          instance_ = value;
        }
      } else {
        instanceBuilder_.mergeFrom(value);
      }
      if (instance_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearInstance() {
      bitField0_ = (bitField0_ & ~0x00000002);
      instance_ = null;
      if (instanceBuilder_ != null) {
        instanceBuilder_.dispose();
        instanceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder
        getInstanceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInstanceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder
        getInstanceOrBuilder() {
      if (instanceBuilder_ != null) {
        return instanceBuilder_.getMessageOrBuilder();
      } else {
        return instance_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.getDefaultInstance()
            : instance_;
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy instead.
     * </pre>
     *
     * <code>
     * .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy instance = 2 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>
        getInstanceFieldBuilder() {
      if (instanceBuilder_ == null) {
        instanceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicy.Builder,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrBuilder>(
                getInstance(), getParentForChildren(), isClean());
        instance_ = null;
      }
      return instanceBuilder_;
    }

    private java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>
        instances_ = java.util.Collections.emptyList();

    private void ensureInstancesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        instances_ =
            new java.util.ArrayList<
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>(
                instances_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>
        instancesBuilder_;

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>
        getInstancesList() {
      if (instancesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instances_);
      } else {
        return instancesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public int getInstancesCount() {
      if (instancesBuilder_ == null) {
        return instances_.size();
      } else {
        return instancesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate getInstances(
        int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder setInstances(
        int index, com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.set(index, value);
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder setInstances(
        int index,
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.set(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder addInstances(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder addInstances(
        int index, com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate value) {
      if (instancesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstancesIsMutable();
        instances_.add(index, value);
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder addInstances(
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder addInstances(
        int index,
        com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
            builderForValue) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.add(index, builderForValue.build());
        onChanged();
      } else {
        instancesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder addAllInstances(
        java.lang.Iterable<
                ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate>
            values) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
        onChanged();
      } else {
        instancesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder clearInstances() {
      if (instancesBuilder_ == null) {
        instances_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        instancesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public Builder removeInstances(int index) {
      if (instancesBuilder_ == null) {
        ensureInstancesIsMutable();
        instances_.remove(index);
        onChanged();
      } else {
        instancesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
        getInstancesBuilder(int index) {
      return getInstancesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder
        getInstancesOrBuilder(int index) {
      if (instancesBuilder_ == null) {
        return instances_.get(index);
      } else {
        return instancesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>
        getInstancesOrBuilderList() {
      if (instancesBuilder_ != null) {
        return instancesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instances_);
      }
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
        addInstancesBuilder() {
      return getInstancesFieldBuilder()
          .addBuilder(
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder
        addInstancesBuilder(int index) {
      return getInstancesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Describe instances that can be created by this AllocationPolicy.
     * Only instances[0] is supported now.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate instances = 8;
     * </code>
     */
    public java.util.List<
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder>
        getInstancesBuilderList() {
      return getInstancesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>
        getInstancesFieldBuilder() {
      if (instancesBuilder_ == null) {
        instancesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplate.Builder,
                com.google.cloud.batch.v1alpha.AllocationPolicy.InstancePolicyOrTemplateOrBuilder>(
                instances_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        instances_ = null;
      }
      return instancesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList instanceTemplates_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureInstanceTemplatesIsMutable() {
      if (!instanceTemplates_.isModifiable()) {
        instanceTemplates_ = new com.google.protobuf.LazyStringArrayList(instanceTemplates_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @return A list containing the instanceTemplates.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getInstanceTemplatesList() {
      instanceTemplates_.makeImmutable();
      return instanceTemplates_;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @return The count of instanceTemplates.
     */
    @java.lang.Deprecated
    public int getInstanceTemplatesCount() {
      return instanceTemplates_.size();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param index The index of the element to return.
     * @return The instanceTemplates at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getInstanceTemplates(int index) {
      return instanceTemplates_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param index The index of the value to return.
     * @return The bytes of the instanceTemplates at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getInstanceTemplatesBytes(int index) {
      return instanceTemplates_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param index The index to set the value at.
     * @param value The instanceTemplates to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setInstanceTemplates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTemplatesIsMutable();
      instanceTemplates_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param value The instanceTemplates to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addInstanceTemplates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInstanceTemplatesIsMutable();
      instanceTemplates_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param values The instanceTemplates to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllInstanceTemplates(java.lang.Iterable<java.lang.String> values) {
      ensureInstanceTemplatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceTemplates_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearInstanceTemplates() {
      instanceTemplates_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].template instead.
     * </pre>
     *
     * <code>repeated string instance_templates = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.instance_templates is deprecated. See
     *     google/cloud/batch/v1alpha/job.proto;l=649
     * @param value The bytes of the instanceTemplates to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addInstanceTemplatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInstanceTemplatesIsMutable();
      instanceTemplates_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> provisioningModels_ =
        java.util.Collections.emptyList();

    private void ensureProvisioningModelsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        provisioningModels_ = new java.util.ArrayList<java.lang.Integer>(provisioningModels_);
        bitField0_ |= 0x00000010;
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @return A list containing the provisioningModels.
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>
        getProvisioningModelsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>(
          provisioningModels_, provisioningModels_converter_);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @return The count of provisioningModels.
     */
    @java.lang.Deprecated
    public int getProvisioningModelsCount() {
      return provisioningModels_.size();
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param index The index of the element to return.
     * @return The provisioningModels at the given index.
     */
    @java.lang.Deprecated
    public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel getProvisioningModels(
        int index) {
      return provisioningModels_converter_.convert(provisioningModels_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param index The index to set the value at.
     * @param value The provisioningModels to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProvisioningModels(
        int index, com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProvisioningModelsIsMutable();
      provisioningModels_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param value The provisioningModels to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addProvisioningModels(
        com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureProvisioningModelsIsMutable();
      provisioningModels_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param values The provisioningModels to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllProvisioningModels(
        java.lang.Iterable<
                ? extends com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel>
            values) {
      ensureProvisioningModelsIsMutable();
      for (com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel value : values) {
        provisioningModels_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearProvisioningModels() {
      provisioningModels_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @return A list containing the enum numeric values on the wire for provisioningModels.
     */
    @java.lang.Deprecated
    public java.util.List<java.lang.Integer> getProvisioningModelsValueList() {
      return java.util.Collections.unmodifiableList(provisioningModels_);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of provisioningModels at the given index.
     */
    @java.lang.Deprecated
    public int getProvisioningModelsValue(int index) {
      return provisioningModels_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for provisioningModels to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setProvisioningModelsValue(int index, int value) {
      ensureProvisioningModelsIsMutable();
      provisioningModels_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param value The enum numeric value on the wire for provisioningModels to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addProvisioningModelsValue(int value) {
      ensureProvisioningModelsIsMutable();
      provisioningModels_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use instances[0].policy.provisioning_model instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_models = 4 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.provisioning_models is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=652
     * @param values The enum numeric values on the wire for provisioningModels to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllProvisioningModelsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureProvisioningModelsIsMutable();
      for (int value : values) {
        provisioningModels_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";

    /**
     *
     *
     * <pre>
     * Deprecated: please use service_account instead.
     * </pre>
     *
     * <code>string service_account_email = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=655
     * @return The serviceAccountEmail.
     */
    @java.lang.Deprecated
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use service_account instead.
     * </pre>
     *
     * <code>string service_account_email = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=655
     * @return The bytes for serviceAccountEmail.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use service_account instead.
     * </pre>
     *
     * <code>string service_account_email = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=655
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use service_account instead.
     * </pre>
     *
     * <code>string service_account_email = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=655
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deprecated: please use service_account instead.
     * </pre>
     *
     * <code>string service_account_email = 5 [deprecated = true];</code>
     *
     * @deprecated google.cloud.batch.v1alpha.AllocationPolicy.service_account_email is deprecated.
     *     See google/cloud/batch/v1alpha/job.proto;l=655
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1alpha.ServiceAccount serviceAccount_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ServiceAccount,
            com.google.cloud.batch.v1alpha.ServiceAccount.Builder,
            com.google.cloud.batch.v1alpha.ServiceAccountOrBuilder>
        serviceAccountBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     *
     * @return The serviceAccount.
     */
    public com.google.cloud.batch.v1alpha.ServiceAccount getServiceAccount() {
      if (serviceAccountBuilder_ == null) {
        return serviceAccount_ == null
            ? com.google.cloud.batch.v1alpha.ServiceAccount.getDefaultInstance()
            : serviceAccount_;
      } else {
        return serviceAccountBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public Builder setServiceAccount(com.google.cloud.batch.v1alpha.ServiceAccount value) {
      if (serviceAccountBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceAccount_ = value;
      } else {
        serviceAccountBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public Builder setServiceAccount(
        com.google.cloud.batch.v1alpha.ServiceAccount.Builder builderForValue) {
      if (serviceAccountBuilder_ == null) {
        serviceAccount_ = builderForValue.build();
      } else {
        serviceAccountBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public Builder mergeServiceAccount(com.google.cloud.batch.v1alpha.ServiceAccount value) {
      if (serviceAccountBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && serviceAccount_ != null
            && serviceAccount_
                != com.google.cloud.batch.v1alpha.ServiceAccount.getDefaultInstance()) {
          getServiceAccountBuilder().mergeFrom(value);
        } else {
          serviceAccount_ = value;
        }
      } else {
        serviceAccountBuilder_.mergeFrom(value);
      }
      if (serviceAccount_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public Builder clearServiceAccount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      serviceAccount_ = null;
      if (serviceAccountBuilder_ != null) {
        serviceAccountBuilder_.dispose();
        serviceAccountBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public com.google.cloud.batch.v1alpha.ServiceAccount.Builder getServiceAccountBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getServiceAccountFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    public com.google.cloud.batch.v1alpha.ServiceAccountOrBuilder getServiceAccountOrBuilder() {
      if (serviceAccountBuilder_ != null) {
        return serviceAccountBuilder_.getMessageOrBuilder();
      } else {
        return serviceAccount_ == null
            ? com.google.cloud.batch.v1alpha.ServiceAccount.getDefaultInstance()
            : serviceAccount_;
      }
    }

    /**
     *
     *
     * <pre>
     * Defines the service account for Batch-created VMs. If omitted, the [default
     * Compute Engine service
     * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
     * is used. Must match the service account specified in any used instance
     * template configured in the Batch job.
     *
     * Includes the following fields:
     *  * email: The service account's email address. If not set, the default
     *  Compute Engine service account is used.
     *  * scopes: Additional OAuth scopes to grant the service account, beyond the
     *  default cloud-platform scope. (list of strings)
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ServiceAccount service_account = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ServiceAccount,
            com.google.cloud.batch.v1alpha.ServiceAccount.Builder,
            com.google.cloud.batch.v1alpha.ServiceAccountOrBuilder>
        getServiceAccountFieldBuilder() {
      if (serviceAccountBuilder_ == null) {
        serviceAccountBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.ServiceAccount,
                com.google.cloud.batch.v1alpha.ServiceAccount.Builder,
                com.google.cloud.batch.v1alpha.ServiceAccountOrBuilder>(
                getServiceAccount(), getParentForChildren(), isClean());
        serviceAccount_ = null;
      }
      return serviceAccountBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom labels to apply to the job and all the Compute Engine resources
     * that both are created by this allocation policy and support labels.
     *
     * Use labels to group and describe the resources they are applied to. Batch
     * automatically applies predefined labels and supports multiple `labels`
     * fields for each job, which each let you apply custom labels to various
     * resources. Label names that start with "goog-" or "google-" are
     * reserved for predefined labels. For more information about labels with
     * Batch, see
     * [Organize resources using
     * labels](https://cloud.google.com/batch/docs/organize-resources-using-labels).
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder>
        networkBuilder_;

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     *
     * @return The network.
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy getNetwork() {
      if (networkBuilder_ == null) {
        return network_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance()
            : network_;
      } else {
        return networkBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public Builder setNetwork(com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
      } else {
        networkBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public Builder setNetwork(
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder builderForValue) {
      if (networkBuilder_ == null) {
        network_ = builderForValue.build();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public Builder mergeNetwork(
        com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy value) {
      if (networkBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && network_ != null
            && network_
                != com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy
                    .getDefaultInstance()) {
          getNetworkBuilder().mergeFrom(value);
        } else {
          network_ = value;
        }
      } else {
        networkBuilder_.mergeFrom(value);
      }
      if (network_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public Builder clearNetwork() {
      bitField0_ = (bitField0_ & ~0x00000100);
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder
        getNetworkBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getNetworkFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder
        getNetworkOrBuilder() {
      if (networkBuilder_ != null) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        return network_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.getDefaultInstance()
            : network_;
      }
    }

    /**
     *
     *
     * <pre>
     * The network policy.
     *
     * If you define an instance template in the `InstancePolicyOrTemplate` field,
     * Batch will use the network settings in the instance template instead of
     * this field.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy network = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy,
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicy.Builder,
                com.google.cloud.batch.v1alpha.AllocationPolicy.NetworkPolicyOrBuilder>(
                getNetwork(), getParentForChildren(), isClean());
        network_ = null;
      }
      return networkBuilder_;
    }

    private com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder>
        placementBuilder_;

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     *
     * @return Whether the placement field is set.
     */
    public boolean hasPlacement() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     *
     * @return The placement.
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy getPlacement() {
      if (placementBuilder_ == null) {
        return placement_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance()
            : placement_;
      } else {
        return placementBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public Builder setPlacement(
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy value) {
      if (placementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placement_ = value;
      } else {
        placementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public Builder setPlacement(
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder builderForValue) {
      if (placementBuilder_ == null) {
        placement_ = builderForValue.build();
      } else {
        placementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public Builder mergePlacement(
        com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy value) {
      if (placementBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && placement_ != null
            && placement_
                != com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy
                    .getDefaultInstance()) {
          getPlacementBuilder().mergeFrom(value);
        } else {
          placement_ = value;
        }
      } else {
        placementBuilder_.mergeFrom(value);
      }
      if (placement_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public Builder clearPlacement() {
      bitField0_ = (bitField0_ & ~0x00000200);
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder
        getPlacementBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getPlacementFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    public com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder
        getPlacementOrBuilder() {
      if (placementBuilder_ != null) {
        return placementBuilder_.getMessageOrBuilder();
      } else {
        return placement_ == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.getDefaultInstance()
            : placement_;
      }
    }

    /**
     *
     *
     * <pre>
     * The placement policy.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy placement = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy,
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder,
            com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder>
        getPlacementFieldBuilder() {
      if (placementBuilder_ == null) {
        placementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy,
                com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicy.Builder,
                com.google.cloud.batch.v1alpha.AllocationPolicy.PlacementPolicyOrBuilder>(
                getPlacement(), getParentForChildren(), isClean());
        placement_ = null;
      }
      return placementBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000400;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Tags applied to the VM instances.
     *
     * The tags identify valid sources or targets for network firewalls.
     * Each tag must be 1-63 characters long, and comply with
     * [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
     * </pre>
     *
     * <code>repeated string tags = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.AllocationPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.AllocationPolicy)
  private static final com.google.cloud.batch.v1alpha.AllocationPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.AllocationPolicy();
  }

  public static com.google.cloud.batch.v1alpha.AllocationPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AllocationPolicy> PARSER =
      new com.google.protobuf.AbstractParser<AllocationPolicy>() {
        @java.lang.Override
        public AllocationPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AllocationPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AllocationPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.AllocationPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
