/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * JobDependency describes the state of other Jobs that the start of this Job
 * depends on.
 * All dependent Jobs must have been submitted in the same region.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.JobDependency}
 */
public final class JobDependency extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobDependency)
    JobDependencyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use JobDependency.newBuilder() to construct.
  private JobDependency(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobDependency() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobDependency();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobDependency_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetItems();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobDependency_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.JobDependency.class,
            com.google.cloud.batch.v1alpha.JobDependency.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Dependency type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1alpha.JobDependency.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The dependent Job has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * The dependent Job has failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * SUCCEEDED or FAILED.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    FINISHED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The dependent Job has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The dependent Job has failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * SUCCEEDED or FAILED.
     * </pre>
     *
     * <code>FINISHED = 3;</code>
     */
    public static final int FINISHED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return FAILED;
        case 3:
          return FINISHED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobDependency.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1alpha.JobDependency.Type)
  }

  public static final int ITEMS_FIELD_NUMBER = 1;

  private static final class ItemsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.batch.v1alpha.JobProto
                .internal_static_google_cloud_batch_v1alpha_JobDependency_ItemsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.ENUM,
            com.google.cloud.batch.v1alpha.JobDependency.Type.TYPE_UNSPECIFIED.getNumber());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> items_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> internalGetItems() {
    if (items_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ItemsDefaultEntryHolder.defaultEntry);
    }
    return items_;
  }

  private static final com.google.protobuf.Internal.MapAdapter.Converter<
          java.lang.Integer, com.google.cloud.batch.v1alpha.JobDependency.Type>
      itemsValueConverter =
          com.google.protobuf.Internal.MapAdapter.newEnumConverter(
              com.google.cloud.batch.v1alpha.JobDependency.Type.internalGetValueMap(),
              com.google.cloud.batch.v1alpha.JobDependency.Type.UNRECOGNIZED);

  private static final java.util.Map<
          java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
      internalGetAdaptedItemsMap(java.util.Map<java.lang.String, java.lang.Integer> map) {
    return new com.google.protobuf.Internal.MapAdapter<
        java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type, java.lang.Integer>(
        map, itemsValueConverter);
  }

  public int getItemsCount() {
    return internalGetItems().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public boolean containsItems(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetItems().getMap().containsKey(key);
  }

  /** Use {@link #getItemsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
      getItems() {
    return getItemsMap();
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
      getItemsMap() {
    return internalGetAdaptedItemsMap(internalGetItems().getMap());
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.batch.v1alpha.JobDependency.Type getItemsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.batch.v1alpha.JobDependency.Type defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
    return map.containsKey(key) ? itemsValueConverter.doForward(map.get(key)) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobDependency.Type getItemsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return itemsValueConverter.doForward(map.get(key));
  }

  /** Use {@link #getItemsValueMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getItemsValue() {
    return getItemsValueMap();
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getItemsValueMap() {
    return internalGetItems().getMap();
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public int getItemsValueOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Each item maps a Job name to a Type.
   * All items must be satisfied for the JobDependency to be satisfied (the AND
   * operation).
   * Once a condition for one item becomes true, it won't go back to false
   * even the dependent Job state changes again.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
   */
  @java.lang.Override
  public int getItemsValueOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetItems(), ItemsDefaultEntryHolder.defaultEntry, 1);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetItems().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> items__ =
          ItemsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, items__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.JobDependency)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.JobDependency other =
        (com.google.cloud.batch.v1alpha.JobDependency) obj;

    if (!internalGetItems().equals(other.internalGetItems())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetItems().getMap().isEmpty()) {
      hash = (37 * hash) + ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetItems().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobDependency parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.JobDependency prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * JobDependency describes the state of other Jobs that the start of this Job
   * depends on.
   * All dependent Jobs must have been submitted in the same region.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobDependency}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobDependency)
      com.google.cloud.batch.v1alpha.JobDependencyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobDependency_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetItems();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableItems();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobDependency_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobDependency.class,
              com.google.cloud.batch.v1alpha.JobDependency.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.JobDependency.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableItems().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobDependency_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobDependency getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.JobDependency.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobDependency build() {
      com.google.cloud.batch.v1alpha.JobDependency result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobDependency buildPartial() {
      com.google.cloud.batch.v1alpha.JobDependency result =
          new com.google.cloud.batch.v1alpha.JobDependency(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.JobDependency result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.items_ = internalGetItems();
        result.items_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.JobDependency) {
        return mergeFrom((com.google.cloud.batch.v1alpha.JobDependency) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobDependency other) {
      if (other == com.google.cloud.batch.v1alpha.JobDependency.getDefaultInstance()) return this;
      internalGetMutableItems().mergeFrom(other.internalGetItems());
      bitField0_ |= 0x00000001;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> items__ =
                    input.readMessage(
                        ItemsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableItems().getMutableMap().put(items__.getKey(), items__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> items_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> internalGetItems() {
      if (items_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ItemsDefaultEntryHolder.defaultEntry);
      }
      return items_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableItems() {
      if (items_ == null) {
        items_ = com.google.protobuf.MapField.newMapField(ItemsDefaultEntryHolder.defaultEntry);
      }
      if (!items_.isMutable()) {
        items_ = items_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return items_;
    }

    public int getItemsCount() {
      return internalGetItems().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public boolean containsItems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetItems().getMap().containsKey(key);
    }

    /** Use {@link #getItemsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
        getItems() {
      return getItemsMap();
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
        getItemsMap() {
      return internalGetAdaptedItemsMap(internalGetItems().getMap());
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.batch.v1alpha.JobDependency.Type getItemsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.batch.v1alpha.JobDependency.Type defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
      return map.containsKey(key) ? itemsValueConverter.doForward(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobDependency.Type getItemsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return itemsValueConverter.doForward(map.get(key));
    }

    /** Use {@link #getItemsValueMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getItemsValue() {
      return getItemsValueMap();
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getItemsValueMap() {
      return internalGetItems().getMap();
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public int getItemsValueOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    @java.lang.Override
    public int getItemsValueOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetItems().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearItems() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableItems().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    public Builder removeItems(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableItems().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type>
        getMutableItems() {
      bitField0_ |= 0x00000001;
      return internalGetAdaptedItemsMap(internalGetMutableItems().getMutableMap());
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    public Builder putItems(
        java.lang.String key, com.google.cloud.batch.v1alpha.JobDependency.Type value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableItems().getMutableMap().put(key, itemsValueConverter.doBackward(value));
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    public Builder putAllItems(
        java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobDependency.Type> values) {
      internalGetAdaptedItemsMap(internalGetMutableItems().getMutableMap()).putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableItemsValue() {
      bitField0_ |= 0x00000001;
      return internalGetMutableItems().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    public Builder putItemsValue(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableItems().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each item maps a Job name to a Type.
     * All items must be satisfied for the JobDependency to be satisfied (the AND
     * operation).
     * Once a condition for one item becomes true, it won't go back to false
     * even the dependent Job state changes again.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.batch.v1alpha.JobDependency.Type&gt; items = 1;</code>
     */
    public Builder putAllItemsValue(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableItems().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobDependency)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobDependency)
  private static final com.google.cloud.batch.v1alpha.JobDependency DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobDependency();
  }

  public static com.google.cloud.batch.v1alpha.JobDependency getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobDependency> PARSER =
      new com.google.protobuf.AbstractParser<JobDependency>() {
        @java.lang.Override
        public JobDependency parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobDependency> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobDependency> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobDependency getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
