/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * Notification configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.JobNotification}
 */
public final class JobNotification extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobNotification)
    JobNotificationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use JobNotification.newBuilder() to construct.
  private JobNotification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobNotification() {
    pubsubTopic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobNotification();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobNotification_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobNotification_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.JobNotification.class,
            com.google.cloud.batch.v1alpha.JobNotification.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The message type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1alpha.JobNotification.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Notify users that the job state has changed.
     * </pre>
     *
     * <code>JOB_STATE_CHANGED = 1;</code>
     */
    JOB_STATE_CHANGED(1),
    /**
     *
     *
     * <pre>
     * Notify users that the task state has changed.
     * </pre>
     *
     * <code>TASK_STATE_CHANGED = 2;</code>
     */
    TASK_STATE_CHANGED(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Notify users that the job state has changed.
     * </pre>
     *
     * <code>JOB_STATE_CHANGED = 1;</code>
     */
    public static final int JOB_STATE_CHANGED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Notify users that the task state has changed.
     * </pre>
     *
     * <code>TASK_STATE_CHANGED = 2;</code>
     */
    public static final int TASK_STATE_CHANGED_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return JOB_STATE_CHANGED;
        case 2:
          return TASK_STATE_CHANGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobNotification.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1alpha.JobNotification.Type)
  }

  public interface MessageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.JobNotification.Message)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The message type.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * The message type.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloud.batch.v1alpha.JobNotification.Type getType();

    /**
     *
     *
     * <pre>
     * The new job state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
     *
     * @return The enum numeric value on the wire for newJobState.
     */
    int getNewJobStateValue();

    /**
     *
     *
     * <pre>
     * The new job state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
     *
     * @return The newJobState.
     */
    com.google.cloud.batch.v1alpha.JobStatus.State getNewJobState();

    /**
     *
     *
     * <pre>
     * The new task state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
     *
     * @return The enum numeric value on the wire for newTaskState.
     */
    int getNewTaskStateValue();

    /**
     *
     *
     * <pre>
     * The new task state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
     *
     * @return The newTaskState.
     */
    com.google.cloud.batch.v1alpha.TaskStatus.State getNewTaskState();
  }

  /**
   *
   *
   * <pre>
   * Message details.
   * Describe the conditions under which messages will be sent.
   * If no attribute is defined, no message will be sent by default.
   * One message should specify either the job or the task level attributes,
   * but not both. For example,
   * job level: JOB_STATE_CHANGED and/or a specified new_job_state;
   * task level: TASK_STATE_CHANGED and/or a specified new_task_state.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobNotification.Message}
   */
  public static final class Message extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobNotification.Message)
      MessageOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Message.newBuilder() to construct.
    private Message(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Message() {
      type_ = 0;
      newJobState_ = 0;
      newTaskState_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Message();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobNotification_Message_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobNotification_Message_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobNotification.Message.class,
              com.google.cloud.batch.v1alpha.JobNotification.Message.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * The message type.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * The message type.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobNotification.Type getType() {
      com.google.cloud.batch.v1alpha.JobNotification.Type result =
          com.google.cloud.batch.v1alpha.JobNotification.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.batch.v1alpha.JobNotification.Type.UNRECOGNIZED
          : result;
    }

    public static final int NEW_JOB_STATE_FIELD_NUMBER = 2;
    private int newJobState_ = 0;

    /**
     *
     *
     * <pre>
     * The new job state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
     *
     * @return The enum numeric value on the wire for newJobState.
     */
    @java.lang.Override
    public int getNewJobStateValue() {
      return newJobState_;
    }

    /**
     *
     *
     * <pre>
     * The new job state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
     *
     * @return The newJobState.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.State getNewJobState() {
      com.google.cloud.batch.v1alpha.JobStatus.State result =
          com.google.cloud.batch.v1alpha.JobStatus.State.forNumber(newJobState_);
      return result == null ? com.google.cloud.batch.v1alpha.JobStatus.State.UNRECOGNIZED : result;
    }

    public static final int NEW_TASK_STATE_FIELD_NUMBER = 3;
    private int newTaskState_ = 0;

    /**
     *
     *
     * <pre>
     * The new task state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
     *
     * @return The enum numeric value on the wire for newTaskState.
     */
    @java.lang.Override
    public int getNewTaskStateValue() {
      return newTaskState_;
    }

    /**
     *
     *
     * <pre>
     * The new task state.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
     *
     * @return The newTaskState.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.TaskStatus.State getNewTaskState() {
      com.google.cloud.batch.v1alpha.TaskStatus.State result =
          com.google.cloud.batch.v1alpha.TaskStatus.State.forNumber(newTaskState_);
      return result == null ? com.google.cloud.batch.v1alpha.TaskStatus.State.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.batch.v1alpha.JobNotification.Type.TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (newJobState_
          != com.google.cloud.batch.v1alpha.JobStatus.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, newJobState_);
      }
      if (newTaskState_
          != com.google.cloud.batch.v1alpha.TaskStatus.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, newTaskState_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.batch.v1alpha.JobNotification.Type.TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      if (newJobState_
          != com.google.cloud.batch.v1alpha.JobStatus.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, newJobState_);
      }
      if (newTaskState_
          != com.google.cloud.batch.v1alpha.TaskStatus.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, newTaskState_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.JobNotification.Message)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.JobNotification.Message other =
          (com.google.cloud.batch.v1alpha.JobNotification.Message) obj;

      if (type_ != other.type_) return false;
      if (newJobState_ != other.newJobState_) return false;
      if (newTaskState_ != other.newTaskState_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + NEW_JOB_STATE_FIELD_NUMBER;
      hash = (53 * hash) + newJobState_;
      hash = (37 * hash) + NEW_TASK_STATE_FIELD_NUMBER;
      hash = (53 * hash) + newTaskState_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.JobNotification.Message prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Message details.
     * Describe the conditions under which messages will be sent.
     * If no attribute is defined, no message will be sent by default.
     * One message should specify either the job or the task level attributes,
     * but not both. For example,
     * job level: JOB_STATE_CHANGED and/or a specified new_job_state;
     * task level: TASK_STATE_CHANGED and/or a specified new_task_state.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.JobNotification.Message}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobNotification.Message)
        com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobNotification_Message_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobNotification_Message_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.JobNotification.Message.class,
                com.google.cloud.batch.v1alpha.JobNotification.Message.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.JobNotification.Message.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        newJobState_ = 0;
        newTaskState_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobNotification_Message_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobNotification.Message getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobNotification.Message build() {
        com.google.cloud.batch.v1alpha.JobNotification.Message result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobNotification.Message buildPartial() {
        com.google.cloud.batch.v1alpha.JobNotification.Message result =
            new com.google.cloud.batch.v1alpha.JobNotification.Message(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.JobNotification.Message result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.newJobState_ = newJobState_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.newTaskState_ = newTaskState_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.JobNotification.Message) {
          return mergeFrom((com.google.cloud.batch.v1alpha.JobNotification.Message) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobNotification.Message other) {
        if (other == com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.newJobState_ != 0) {
          setNewJobStateValue(other.getNewJobStateValue());
        }
        if (other.newTaskState_ != 0) {
          setNewTaskStateValue(other.getNewTaskStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  newJobState_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  newTaskState_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * The message type.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * The message type.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The message type.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobNotification.Type getType() {
        com.google.cloud.batch.v1alpha.JobNotification.Type result =
            com.google.cloud.batch.v1alpha.JobNotification.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.batch.v1alpha.JobNotification.Type.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The message type.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.batch.v1alpha.JobNotification.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The message type.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobNotification.Type type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private int newJobState_ = 0;

      /**
       *
       *
       * <pre>
       * The new job state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
       *
       * @return The enum numeric value on the wire for newJobState.
       */
      @java.lang.Override
      public int getNewJobStateValue() {
        return newJobState_;
      }

      /**
       *
       *
       * <pre>
       * The new job state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
       *
       * @param value The enum numeric value on the wire for newJobState to set.
       * @return This builder for chaining.
       */
      public Builder setNewJobStateValue(int value) {
        newJobState_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The new job state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
       *
       * @return The newJobState.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.State getNewJobState() {
        com.google.cloud.batch.v1alpha.JobStatus.State result =
            com.google.cloud.batch.v1alpha.JobStatus.State.forNumber(newJobState_);
        return result == null
            ? com.google.cloud.batch.v1alpha.JobStatus.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The new job state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
       *
       * @param value The newJobState to set.
       * @return This builder for chaining.
       */
      public Builder setNewJobState(com.google.cloud.batch.v1alpha.JobStatus.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        newJobState_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The new job state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.JobStatus.State new_job_state = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNewJobState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        newJobState_ = 0;
        onChanged();
        return this;
      }

      private int newTaskState_ = 0;

      /**
       *
       *
       * <pre>
       * The new task state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
       *
       * @return The enum numeric value on the wire for newTaskState.
       */
      @java.lang.Override
      public int getNewTaskStateValue() {
        return newTaskState_;
      }

      /**
       *
       *
       * <pre>
       * The new task state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
       *
       * @param value The enum numeric value on the wire for newTaskState to set.
       * @return This builder for chaining.
       */
      public Builder setNewTaskStateValue(int value) {
        newTaskState_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The new task state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
       *
       * @return The newTaskState.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.TaskStatus.State getNewTaskState() {
        com.google.cloud.batch.v1alpha.TaskStatus.State result =
            com.google.cloud.batch.v1alpha.TaskStatus.State.forNumber(newTaskState_);
        return result == null
            ? com.google.cloud.batch.v1alpha.TaskStatus.State.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The new task state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
       *
       * @param value The newTaskState to set.
       * @return This builder for chaining.
       */
      public Builder setNewTaskState(com.google.cloud.batch.v1alpha.TaskStatus.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        newTaskState_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The new task state.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.TaskStatus.State new_task_state = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNewTaskState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        newTaskState_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobNotification.Message)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobNotification.Message)
    private static final com.google.cloud.batch.v1alpha.JobNotification.Message DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobNotification.Message();
    }

    public static com.google.cloud.batch.v1alpha.JobNotification.Message getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Message> PARSER =
        new com.google.protobuf.AbstractParser<Message>() {
          @java.lang.Override
          public Message parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Message> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Message> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobNotification.Message getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PUBSUB_TOPIC_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pubsubTopic_ = "";

  /**
   *
   *
   * <pre>
   * The Pub/Sub topic where notifications for the job, like state
   * changes, will be published. If undefined, no Pub/Sub notifications
   * are sent for this job.
   *
   * Specify the topic using the following format:
   * `projects/{project}/topics/{topic}`.
   * Notably, if you want to specify a Pub/Sub topic that is in a
   * different project than the job, your administrator must grant your
   * project's Batch service agent permission to publish to that topic.
   *
   * For more information about configuring Pub/Sub notifications for
   * a job, see
   * https://cloud.google.com/batch/docs/enable-notifications.
   * </pre>
   *
   * <code>string pubsub_topic = 1;</code>
   *
   * @return The pubsubTopic.
   */
  @java.lang.Override
  public java.lang.String getPubsubTopic() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pubsubTopic_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The Pub/Sub topic where notifications for the job, like state
   * changes, will be published. If undefined, no Pub/Sub notifications
   * are sent for this job.
   *
   * Specify the topic using the following format:
   * `projects/{project}/topics/{topic}`.
   * Notably, if you want to specify a Pub/Sub topic that is in a
   * different project than the job, your administrator must grant your
   * project's Batch service agent permission to publish to that topic.
   *
   * For more information about configuring Pub/Sub notifications for
   * a job, see
   * https://cloud.google.com/batch/docs/enable-notifications.
   * </pre>
   *
   * <code>string pubsub_topic = 1;</code>
   *
   * @return The bytes for pubsubTopic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPubsubTopicBytes() {
    java.lang.Object ref = pubsubTopic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pubsubTopic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_FIELD_NUMBER = 2;
  private com.google.cloud.batch.v1alpha.JobNotification.Message message_;

  /**
   *
   *
   * <pre>
   * The attribute requirements of messages to be sent to this Pub/Sub topic.
   * Without this field, no message will be sent.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
   *
   * @return Whether the message field is set.
   */
  @java.lang.Override
  public boolean hasMessage() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The attribute requirements of messages to be sent to this Pub/Sub topic.
   * Without this field, no message will be sent.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobNotification.Message getMessage() {
    return message_ == null
        ? com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance()
        : message_;
  }

  /**
   *
   *
   * <pre>
   * The attribute requirements of messages to be sent to this Pub/Sub topic.
   * Without this field, no message will be sent.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder getMessageOrBuilder() {
    return message_ == null
        ? com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance()
        : message_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pubsubTopic_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getMessage());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pubsubTopic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pubsubTopic_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMessage());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.JobNotification)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.JobNotification other =
        (com.google.cloud.batch.v1alpha.JobNotification) obj;

    if (!getPubsubTopic().equals(other.getPubsubTopic())) return false;
    if (hasMessage() != other.hasMessage()) return false;
    if (hasMessage()) {
      if (!getMessage().equals(other.getMessage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PUBSUB_TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getPubsubTopic().hashCode();
    if (hasMessage()) {
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobNotification parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.JobNotification prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Notification configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobNotification}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobNotification)
      com.google.cloud.batch.v1alpha.JobNotificationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobNotification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobNotification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobNotification.class,
              com.google.cloud.batch.v1alpha.JobNotification.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.JobNotification.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMessageFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pubsubTopic_ = "";
      message_ = null;
      if (messageBuilder_ != null) {
        messageBuilder_.dispose();
        messageBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobNotification_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobNotification getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.JobNotification.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobNotification build() {
      com.google.cloud.batch.v1alpha.JobNotification result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobNotification buildPartial() {
      com.google.cloud.batch.v1alpha.JobNotification result =
          new com.google.cloud.batch.v1alpha.JobNotification(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.JobNotification result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pubsubTopic_ = pubsubTopic_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.message_ = messageBuilder_ == null ? message_ : messageBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.JobNotification) {
        return mergeFrom((com.google.cloud.batch.v1alpha.JobNotification) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobNotification other) {
      if (other == com.google.cloud.batch.v1alpha.JobNotification.getDefaultInstance()) return this;
      if (!other.getPubsubTopic().isEmpty()) {
        pubsubTopic_ = other.pubsubTopic_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasMessage()) {
        mergeMessage(other.getMessage());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pubsubTopic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMessageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object pubsubTopic_ = "";

    /**
     *
     *
     * <pre>
     * The Pub/Sub topic where notifications for the job, like state
     * changes, will be published. If undefined, no Pub/Sub notifications
     * are sent for this job.
     *
     * Specify the topic using the following format:
     * `projects/{project}/topics/{topic}`.
     * Notably, if you want to specify a Pub/Sub topic that is in a
     * different project than the job, your administrator must grant your
     * project's Batch service agent permission to publish to that topic.
     *
     * For more information about configuring Pub/Sub notifications for
     * a job, see
     * https://cloud.google.com/batch/docs/enable-notifications.
     * </pre>
     *
     * <code>string pubsub_topic = 1;</code>
     *
     * @return The pubsubTopic.
     */
    public java.lang.String getPubsubTopic() {
      java.lang.Object ref = pubsubTopic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pubsubTopic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Pub/Sub topic where notifications for the job, like state
     * changes, will be published. If undefined, no Pub/Sub notifications
     * are sent for this job.
     *
     * Specify the topic using the following format:
     * `projects/{project}/topics/{topic}`.
     * Notably, if you want to specify a Pub/Sub topic that is in a
     * different project than the job, your administrator must grant your
     * project's Batch service agent permission to publish to that topic.
     *
     * For more information about configuring Pub/Sub notifications for
     * a job, see
     * https://cloud.google.com/batch/docs/enable-notifications.
     * </pre>
     *
     * <code>string pubsub_topic = 1;</code>
     *
     * @return The bytes for pubsubTopic.
     */
    public com.google.protobuf.ByteString getPubsubTopicBytes() {
      java.lang.Object ref = pubsubTopic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pubsubTopic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The Pub/Sub topic where notifications for the job, like state
     * changes, will be published. If undefined, no Pub/Sub notifications
     * are sent for this job.
     *
     * Specify the topic using the following format:
     * `projects/{project}/topics/{topic}`.
     * Notably, if you want to specify a Pub/Sub topic that is in a
     * different project than the job, your administrator must grant your
     * project's Batch service agent permission to publish to that topic.
     *
     * For more information about configuring Pub/Sub notifications for
     * a job, see
     * https://cloud.google.com/batch/docs/enable-notifications.
     * </pre>
     *
     * <code>string pubsub_topic = 1;</code>
     *
     * @param value The pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pubsubTopic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Pub/Sub topic where notifications for the job, like state
     * changes, will be published. If undefined, no Pub/Sub notifications
     * are sent for this job.
     *
     * Specify the topic using the following format:
     * `projects/{project}/topics/{topic}`.
     * Notably, if you want to specify a Pub/Sub topic that is in a
     * different project than the job, your administrator must grant your
     * project's Batch service agent permission to publish to that topic.
     *
     * For more information about configuring Pub/Sub notifications for
     * a job, see
     * https://cloud.google.com/batch/docs/enable-notifications.
     * </pre>
     *
     * <code>string pubsub_topic = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPubsubTopic() {
      pubsubTopic_ = getDefaultInstance().getPubsubTopic();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Pub/Sub topic where notifications for the job, like state
     * changes, will be published. If undefined, no Pub/Sub notifications
     * are sent for this job.
     *
     * Specify the topic using the following format:
     * `projects/{project}/topics/{topic}`.
     * Notably, if you want to specify a Pub/Sub topic that is in a
     * different project than the job, your administrator must grant your
     * project's Batch service agent permission to publish to that topic.
     *
     * For more information about configuring Pub/Sub notifications for
     * a job, see
     * https://cloud.google.com/batch/docs/enable-notifications.
     * </pre>
     *
     * <code>string pubsub_topic = 1;</code>
     *
     * @param value The bytes for pubsubTopic to set.
     * @return This builder for chaining.
     */
    public Builder setPubsubTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pubsubTopic_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1alpha.JobNotification.Message message_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.JobNotification.Message,
            com.google.cloud.batch.v1alpha.JobNotification.Message.Builder,
            com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder>
        messageBuilder_;

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     *
     * @return Whether the message field is set.
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     *
     * @return The message.
     */
    public com.google.cloud.batch.v1alpha.JobNotification.Message getMessage() {
      if (messageBuilder_ == null) {
        return message_ == null
            ? com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance()
            : message_;
      } else {
        return messageBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public Builder setMessage(com.google.cloud.batch.v1alpha.JobNotification.Message value) {
      if (messageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
      } else {
        messageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public Builder setMessage(
        com.google.cloud.batch.v1alpha.JobNotification.Message.Builder builderForValue) {
      if (messageBuilder_ == null) {
        message_ = builderForValue.build();
      } else {
        messageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public Builder mergeMessage(com.google.cloud.batch.v1alpha.JobNotification.Message value) {
      if (messageBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && message_ != null
            && message_
                != com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance()) {
          getMessageBuilder().mergeFrom(value);
        } else {
          message_ = value;
        }
      } else {
        messageBuilder_.mergeFrom(value);
      }
      if (message_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public Builder clearMessage() {
      bitField0_ = (bitField0_ & ~0x00000002);
      message_ = null;
      if (messageBuilder_ != null) {
        messageBuilder_.dispose();
        messageBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.JobNotification.Message.Builder getMessageBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMessageFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder getMessageOrBuilder() {
      if (messageBuilder_ != null) {
        return messageBuilder_.getMessageOrBuilder();
      } else {
        return message_ == null
            ? com.google.cloud.batch.v1alpha.JobNotification.Message.getDefaultInstance()
            : message_;
      }
    }

    /**
     *
     *
     * <pre>
     * The attribute requirements of messages to be sent to this Pub/Sub topic.
     * Without this field, no message will be sent.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobNotification.Message message = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.JobNotification.Message,
            com.google.cloud.batch.v1alpha.JobNotification.Message.Builder,
            com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder>
        getMessageFieldBuilder() {
      if (messageBuilder_ == null) {
        messageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.JobNotification.Message,
                com.google.cloud.batch.v1alpha.JobNotification.Message.Builder,
                com.google.cloud.batch.v1alpha.JobNotification.MessageOrBuilder>(
                getMessage(), getParentForChildren(), isClean());
        message_ = null;
      }
      return messageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobNotification)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobNotification)
  private static final com.google.cloud.batch.v1alpha.JobNotification DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobNotification();
  }

  public static com.google.cloud.batch.v1alpha.JobNotification getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobNotification> PARSER =
      new com.google.protobuf.AbstractParser<JobNotification>() {
        @java.lang.Override
        public JobNotification parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobNotification> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobNotification> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobNotification getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
