/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * Job status.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus}
 */
public final class JobStatus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobStatus)
    JobStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use JobStatus.newBuilder() to construct.
  private JobStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobStatus() {
    state_ = 0;
    statusEvents_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobStatus_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetTaskGroups();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.JobProto
        .internal_static_google_cloud_batch_v1alpha_JobStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.JobStatus.class,
            com.google.cloud.batch.v1alpha.JobStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid Job states.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.batch.v1alpha.JobStatus.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Job state unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Job is admitted (validated and persisted) and waiting for resources.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    QUEUED(1),
    /**
     *
     *
     * <pre>
     * Job is scheduled to run as soon as resource allocation is ready.
     * The resource allocation may happen at a later time but with a high
     * chance to succeed.
     * </pre>
     *
     * <code>SCHEDULED = 2;</code>
     */
    SCHEDULED(2),
    /**
     *
     *
     * <pre>
     * Resource allocation has been successful. At least one Task in the Job is
     * RUNNING.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    /**
     *
     *
     * <pre>
     * All Tasks in the Job have finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    SUCCEEDED(4),
    /**
     *
     *
     * <pre>
     * At least one Task in the Job has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * The Job will be deleted, but has not been deleted yet. Typically this is
     * because resources used by the Job are still being cleaned up.
     * </pre>
     *
     * <code>DELETION_IN_PROGRESS = 6;</code>
     */
    DELETION_IN_PROGRESS(6),
    /**
     *
     *
     * <pre>
     * The Job cancellation is in progress, this is because the resources used
     * by the Job are still being cleaned up.
     * </pre>
     *
     * <code>CANCELLATION_IN_PROGRESS = 7;</code>
     */
    CANCELLATION_IN_PROGRESS(7),
    /**
     *
     *
     * <pre>
     * The Job has been cancelled, the task executions were stopped and the
     * resources were cleaned up.
     * </pre>
     *
     * <code>CANCELLED = 8;</code>
     */
    CANCELLED(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Job state unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Job is admitted (validated and persisted) and waiting for resources.
     * </pre>
     *
     * <code>QUEUED = 1;</code>
     */
    public static final int QUEUED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Job is scheduled to run as soon as resource allocation is ready.
     * The resource allocation may happen at a later time but with a high
     * chance to succeed.
     * </pre>
     *
     * <code>SCHEDULED = 2;</code>
     */
    public static final int SCHEDULED_VALUE = 2;

    /**
     *
     *
     * <pre>
     * Resource allocation has been successful. At least one Task in the Job is
     * RUNNING.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;

    /**
     *
     *
     * <pre>
     * All Tasks in the Job have finished successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 4;</code>
     */
    public static final int SUCCEEDED_VALUE = 4;

    /**
     *
     *
     * <pre>
     * At least one Task in the Job has failed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The Job will be deleted, but has not been deleted yet. Typically this is
     * because resources used by the Job are still being cleaned up.
     * </pre>
     *
     * <code>DELETION_IN_PROGRESS = 6;</code>
     */
    public static final int DELETION_IN_PROGRESS_VALUE = 6;

    /**
     *
     *
     * <pre>
     * The Job cancellation is in progress, this is because the resources used
     * by the Job are still being cleaned up.
     * </pre>
     *
     * <code>CANCELLATION_IN_PROGRESS = 7;</code>
     */
    public static final int CANCELLATION_IN_PROGRESS_VALUE = 7;

    /**
     *
     *
     * <pre>
     * The Job has been cancelled, the task executions were stopped and the
     * resources were cleaned up.
     * </pre>
     *
     * <code>CANCELLED = 8;</code>
     */
    public static final int CANCELLED_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return QUEUED;
        case 2:
          return SCHEDULED;
        case 3:
          return RUNNING;
        case 4:
          return SUCCEEDED;
        case 5:
          return FAILED;
        case 6:
          return DELETION_IN_PROGRESS;
        case 7:
          return CANCELLATION_IN_PROGRESS;
        case 8:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobStatus.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.batch.v1alpha.JobStatus.State)
  }

  public interface InstanceStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.JobStatus.InstanceStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * The VM instance provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for provisioningModel.
     */
    int getProvisioningModelValue();

    /**
     *
     *
     * <pre>
     * The VM instance provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
     * </code>
     *
     * @return The provisioningModel.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel getProvisioningModel();

    /**
     *
     *
     * <pre>
     * The max number of tasks can be assigned to this instance type.
     * </pre>
     *
     * <code>int64 task_pack = 3;</code>
     *
     * @return The taskPack.
     */
    long getTaskPack();

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     *
     * @return Whether the bootDisk field is set.
     */
    boolean hasBootDisk();

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     *
     * @return The bootDisk.
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk();

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     */
    com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * VM instance status.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus.InstanceStatus}
   */
  public static final class InstanceStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobStatus.InstanceStatus)
      InstanceStatusOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InstanceStatus.newBuilder() to construct.
    private InstanceStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceStatus() {
      machineType_ = "";
      provisioningModel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_InstanceStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_InstanceStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.class,
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder.class);
    }

    private int bitField0_;
    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object machineType_ = "";

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 1;</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROVISIONING_MODEL_FIELD_NUMBER = 2;
    private int provisioningModel_ = 0;

    /**
     *
     *
     * <pre>
     * The VM instance provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for provisioningModel.
     */
    @java.lang.Override
    public int getProvisioningModelValue() {
      return provisioningModel_;
    }

    /**
     *
     *
     * <pre>
     * The VM instance provisioning model.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
     * </code>
     *
     * @return The provisioningModel.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
        getProvisioningModel() {
      com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel result =
          com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.forNumber(
              provisioningModel_);
      return result == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.UNRECOGNIZED
          : result;
    }

    public static final int TASK_PACK_FIELD_NUMBER = 3;
    private long taskPack_ = 0L;

    /**
     *
     *
     * <pre>
     * The max number of tasks can be assigned to this instance type.
     * </pre>
     *
     * <code>int64 task_pack = 3;</code>
     *
     * @return The taskPack.
     */
    @java.lang.Override
    public long getTaskPack() {
      return taskPack_;
    }

    public static final int BOOT_DISK_FIELD_NUMBER = 4;
    private com.google.cloud.batch.v1alpha.AllocationPolicy.Disk bootDisk_;

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     *
     * @return Whether the bootDisk field is set.
     */
    @java.lang.Override
    public boolean hasBootDisk() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     *
     * @return The bootDisk.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk() {
      return bootDisk_ == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
          : bootDisk_;
    }

    /**
     *
     *
     * <pre>
     * The VM boot disk.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder() {
      return bootDisk_ == null
          ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
          : bootDisk_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
      }
      if (provisioningModel_
          != com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
              .PROVISIONING_MODEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, provisioningModel_);
      }
      if (taskPack_ != 0L) {
        output.writeInt64(3, taskPack_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getBootDisk());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
      }
      if (provisioningModel_
          != com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
              .PROVISIONING_MODEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, provisioningModel_);
      }
      if (taskPack_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, taskPack_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBootDisk());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus other =
          (com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus) obj;

      if (!getMachineType().equals(other.getMachineType())) return false;
      if (provisioningModel_ != other.provisioningModel_) return false;
      if (getTaskPack() != other.getTaskPack()) return false;
      if (hasBootDisk() != other.hasBootDisk()) return false;
      if (hasBootDisk()) {
        if (!getBootDisk().equals(other.getBootDisk())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
      hash = (37 * hash) + PROVISIONING_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + provisioningModel_;
      hash = (37 * hash) + TASK_PACK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTaskPack());
      if (hasBootDisk()) {
        hash = (37 * hash) + BOOT_DISK_FIELD_NUMBER;
        hash = (53 * hash) + getBootDisk().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * VM instance status.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus.InstanceStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobStatus.InstanceStatus)
        com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_InstanceStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_InstanceStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.class,
                com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBootDiskFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineType_ = "";
        provisioningModel_ = 0;
        taskPack_ = 0L;
        bootDisk_ = null;
        if (bootDiskBuilder_ != null) {
          bootDiskBuilder_.dispose();
          bootDiskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_InstanceStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus build() {
        com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus buildPartial() {
        com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus result =
            new com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineType_ = machineType_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.provisioningModel_ = provisioningModel_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.taskPack_ = taskPack_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.bootDisk_ = bootDiskBuilder_ == null ? bootDisk_ : bootDiskBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus) {
          return mergeFrom((com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus other) {
        if (other == com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.getDefaultInstance())
          return this;
        if (!other.getMachineType().isEmpty()) {
          machineType_ = other.machineType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.provisioningModel_ != 0) {
          setProvisioningModelValue(other.getProvisioningModelValue());
        }
        if (other.getTaskPack() != 0L) {
          setTaskPack(other.getTaskPack());
        }
        if (other.hasBootDisk()) {
          mergeBootDisk(other.getBootDisk());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  machineType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  provisioningModel_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  taskPack_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getBootDiskFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object machineType_ = "";

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {
        machineType_ = getDefaultInstance().getMachineType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The Compute Engine machine type.
       * </pre>
       *
       * <code>string machine_type = 1;</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int provisioningModel_ = 0;

      /**
       *
       *
       * <pre>
       * The VM instance provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for provisioningModel.
       */
      @java.lang.Override
      public int getProvisioningModelValue() {
        return provisioningModel_;
      }

      /**
       *
       *
       * <pre>
       * The VM instance provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for provisioningModel to set.
       * @return This builder for chaining.
       */
      public Builder setProvisioningModelValue(int value) {
        provisioningModel_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM instance provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
       * </code>
       *
       * @return The provisioningModel.
       */
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel
          getProvisioningModel() {
        com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel result =
            com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.forNumber(
                provisioningModel_);
        return result == null
            ? com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The VM instance provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
       * </code>
       *
       * @param value The provisioningModel to set.
       * @return This builder for chaining.
       */
      public Builder setProvisioningModel(
          com.google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        provisioningModel_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM instance provisioning model.
       * </pre>
       *
       * <code>
       * .google.cloud.batch.v1alpha.AllocationPolicy.ProvisioningModel provisioning_model = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProvisioningModel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        provisioningModel_ = 0;
        onChanged();
        return this;
      }

      private long taskPack_;

      /**
       *
       *
       * <pre>
       * The max number of tasks can be assigned to this instance type.
       * </pre>
       *
       * <code>int64 task_pack = 3;</code>
       *
       * @return The taskPack.
       */
      @java.lang.Override
      public long getTaskPack() {
        return taskPack_;
      }

      /**
       *
       *
       * <pre>
       * The max number of tasks can be assigned to this instance type.
       * </pre>
       *
       * <code>int64 task_pack = 3;</code>
       *
       * @param value The taskPack to set.
       * @return This builder for chaining.
       */
      public Builder setTaskPack(long value) {

        taskPack_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The max number of tasks can be assigned to this instance type.
       * </pre>
       *
       * <code>int64 task_pack = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTaskPack() {
        bitField0_ = (bitField0_ & ~0x00000004);
        taskPack_ = 0L;
        onChanged();
        return this;
      }

      private com.google.cloud.batch.v1alpha.AllocationPolicy.Disk bootDisk_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          bootDiskBuilder_;

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       *
       * @return Whether the bootDisk field is set.
       */
      public boolean hasBootDisk() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       *
       * @return The bootDisk.
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk getBootDisk() {
        if (bootDiskBuilder_ == null) {
          return bootDisk_ == null
              ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
              : bootDisk_;
        } else {
          return bootDiskBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public Builder setBootDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (bootDiskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          bootDisk_ = value;
        } else {
          bootDiskBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public Builder setBootDisk(
          com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder builderForValue) {
        if (bootDiskBuilder_ == null) {
          bootDisk_ = builderForValue.build();
        } else {
          bootDiskBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public Builder mergeBootDisk(com.google.cloud.batch.v1alpha.AllocationPolicy.Disk value) {
        if (bootDiskBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && bootDisk_ != null
              && bootDisk_
                  != com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()) {
            getBootDiskBuilder().mergeFrom(value);
          } else {
            bootDisk_ = value;
          }
        } else {
          bootDiskBuilder_.mergeFrom(value);
        }
        if (bootDisk_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public Builder clearBootDisk() {
        bitField0_ = (bitField0_ & ~0x00000008);
        bootDisk_ = null;
        if (bootDiskBuilder_ != null) {
          bootDiskBuilder_.dispose();
          bootDiskBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder getBootDiskBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getBootDiskFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      public com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder getBootDiskOrBuilder() {
        if (bootDiskBuilder_ != null) {
          return bootDiskBuilder_.getMessageOrBuilder();
        } else {
          return bootDisk_ == null
              ? com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.getDefaultInstance()
              : bootDisk_;
        }
      }

      /**
       *
       *
       * <pre>
       * The VM boot disk.
       * </pre>
       *
       * <code>.google.cloud.batch.v1alpha.AllocationPolicy.Disk boot_disk = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
              com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
              com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>
          getBootDiskFieldBuilder() {
        if (bootDiskBuilder_ == null) {
          bootDiskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.Disk.Builder,
                  com.google.cloud.batch.v1alpha.AllocationPolicy.DiskOrBuilder>(
                  getBootDisk(), getParentForChildren(), isClean());
          bootDisk_ = null;
        }
        return bootDiskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobStatus.InstanceStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobStatus.InstanceStatus)
    private static final com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus();
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceStatus> PARSER =
        new com.google.protobuf.AbstractParser<InstanceStatus>() {
          @java.lang.Override
          public InstanceStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TaskGroupStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    int getCountsCount();

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    boolean containsCounts(java.lang.String key);

    /** Use {@link #getCountsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.Long> getCounts();

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    java.util.Map<java.lang.String, java.lang.Long> getCountsMap();

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    long getCountsOrDefault(java.lang.String key, long defaultValue);

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    long getCountsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus> getInstancesList();

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getInstances(int index);

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    int getInstancesCount();

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    java.util.List<? extends com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>
        getInstancesOrBuilderList();

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder getInstancesOrBuilder(
        int index);
  }

  /**
   *
   *
   * <pre>
   * Aggregated task status for a TaskGroup.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus}
   */
  public static final class TaskGroupStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)
      TaskGroupStatusOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TaskGroupStatus.newBuilder() to construct.
    private TaskGroupStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TaskGroupStatus() {
      instances_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TaskGroupStatus();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetCounts();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.class,
              com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder.class);
    }

    public static final int COUNTS_FIELD_NUMBER = 1;

    private static final class CountsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
              com.google.cloud.batch.v1alpha.JobProto
                  .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_CountsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.INT64,
              0L);
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> counts_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetCounts() {
      if (counts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(CountsDefaultEntryHolder.defaultEntry);
      }
      return counts_;
    }

    public int getCountsCount() {
      return internalGetCounts().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    @java.lang.Override
    public boolean containsCounts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCounts().getMap().containsKey(key);
    }

    /** Use {@link #getCountsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getCounts() {
      return getCountsMap();
    }

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getCountsMap() {
      return internalGetCounts().getMap();
    }

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    @java.lang.Override
    public long getCountsOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Count of task in each state in the TaskGroup.
     * The map key is task state name.
     * </pre>
     *
     * <code>map&lt;string, int64&gt; counts = 1;</code>
     */
    @java.lang.Override
    public long getCountsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int INSTANCES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus> instances_;

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus>
        getInstancesList() {
      return instances_;
    }

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>
        getInstancesOrBuilderList() {
      return instances_;
    }

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    @java.lang.Override
    public int getInstancesCount() {
      return instances_.size();
    }

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getInstances(int index) {
      return instances_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Status of instances allocated for the TaskGroup.
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder getInstancesOrBuilder(
        int index) {
      return instances_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetCounts(), CountsDefaultEntryHolder.defaultEntry, 1);
      for (int i = 0; i < instances_.size(); i++) {
        output.writeMessage(2, instances_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
          internalGetCounts().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> counts__ =
            CountsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, counts__);
      }
      for (int i = 0; i < instances_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, instances_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus other =
          (com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) obj;

      if (!internalGetCounts().equals(other.internalGetCounts())) return false;
      if (!getInstancesList().equals(other.getInstancesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetCounts().getMap().isEmpty()) {
        hash = (37 * hash) + COUNTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetCounts().hashCode();
      }
      if (getInstancesCount() > 0) {
        hash = (37 * hash) + INSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getInstancesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for a TaskGroup.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)
        com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetCounts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 1:
            return internalGetMutableCounts();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.class,
                com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableCounts().clear();
        if (instancesBuilder_ == null) {
          instances_ = java.util.Collections.emptyList();
        } else {
          instances_ = null;
          instancesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.JobProto
            .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupStatus_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus build() {
        com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus buildPartial() {
        com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus result =
            new com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus result) {
        if (instancesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            instances_ = java.util.Collections.unmodifiableList(instances_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.instances_ = instances_;
        } else {
          result.instances_ = instancesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.counts_ = internalGetCounts();
          result.counts_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) {
          return mergeFrom((com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus other) {
        if (other == com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.getDefaultInstance())
          return this;
        internalGetMutableCounts().mergeFrom(other.internalGetCounts());
        bitField0_ |= 0x00000001;
        if (instancesBuilder_ == null) {
          if (!other.instances_.isEmpty()) {
            if (instances_.isEmpty()) {
              instances_ = other.instances_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureInstancesIsMutable();
              instances_.addAll(other.instances_);
            }
            onChanged();
          }
        } else {
          if (!other.instances_.isEmpty()) {
            if (instancesBuilder_.isEmpty()) {
              instancesBuilder_.dispose();
              instancesBuilder_ = null;
              instances_ = other.instances_;
              bitField0_ = (bitField0_ & ~0x00000002);
              instancesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getInstancesFieldBuilder()
                      : null;
            } else {
              instancesBuilder_.addAllMessages(other.instances_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> counts__ =
                      input.readMessage(
                          CountsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableCounts()
                      .getMutableMap()
                      .put(counts__.getKey(), counts__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus m =
                      input.readMessage(
                          com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.parser(),
                          extensionRegistry);
                  if (instancesBuilder_ == null) {
                    ensureInstancesIsMutable();
                    instances_.add(m);
                  } else {
                    instancesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> counts_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetCounts() {
        if (counts_ == null) {
          return com.google.protobuf.MapField.emptyMapField(CountsDefaultEntryHolder.defaultEntry);
        }
        return counts_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
          internalGetMutableCounts() {
        if (counts_ == null) {
          counts_ = com.google.protobuf.MapField.newMapField(CountsDefaultEntryHolder.defaultEntry);
        }
        if (!counts_.isMutable()) {
          counts_ = counts_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return counts_;
      }

      public int getCountsCount() {
        return internalGetCounts().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      @java.lang.Override
      public boolean containsCounts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetCounts().getMap().containsKey(key);
      }

      /** Use {@link #getCountsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getCounts() {
        return getCountsMap();
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.Long> getCountsMap() {
        return internalGetCounts().getMap();
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      @java.lang.Override
      public long getCountsOrDefault(java.lang.String key, long defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      @java.lang.Override
      public long getCountsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetCounts().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearCounts() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableCounts().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      public Builder removeCounts(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableCounts().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getMutableCounts() {
        bitField0_ |= 0x00000001;
        return internalGetMutableCounts().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      public Builder putCounts(java.lang.String key, long value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }

        internalGetMutableCounts().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Count of task in each state in the TaskGroup.
       * The map key is task state name.
       * </pre>
       *
       * <code>map&lt;string, int64&gt; counts = 1;</code>
       */
      public Builder putAllCounts(java.util.Map<java.lang.String, java.lang.Long> values) {
        internalGetMutableCounts().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      private java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus> instances_ =
          java.util.Collections.emptyList();

      private void ensureInstancesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          instances_ =
              new java.util.ArrayList<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus>(
                  instances_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus,
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder,
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>
          instancesBuilder_;

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus>
          getInstancesList() {
        if (instancesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(instances_);
        } else {
          return instancesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public int getInstancesCount() {
        if (instancesBuilder_ == null) {
          return instances_.size();
        } else {
          return instancesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus getInstances(int index) {
        if (instancesBuilder_ == null) {
          return instances_.get(index);
        } else {
          return instancesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder setInstances(
          int index, com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus value) {
        if (instancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInstancesIsMutable();
          instances_.set(index, value);
          onChanged();
        } else {
          instancesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder setInstances(
          int index,
          com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder builderForValue) {
        if (instancesBuilder_ == null) {
          ensureInstancesIsMutable();
          instances_.set(index, builderForValue.build());
          onChanged();
        } else {
          instancesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder addInstances(com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus value) {
        if (instancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInstancesIsMutable();
          instances_.add(value);
          onChanged();
        } else {
          instancesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder addInstances(
          int index, com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus value) {
        if (instancesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInstancesIsMutable();
          instances_.add(index, value);
          onChanged();
        } else {
          instancesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder addInstances(
          com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder builderForValue) {
        if (instancesBuilder_ == null) {
          ensureInstancesIsMutable();
          instances_.add(builderForValue.build());
          onChanged();
        } else {
          instancesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder addInstances(
          int index,
          com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder builderForValue) {
        if (instancesBuilder_ == null) {
          ensureInstancesIsMutable();
          instances_.add(index, builderForValue.build());
          onChanged();
        } else {
          instancesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder addAllInstances(
          java.lang.Iterable<? extends com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus>
              values) {
        if (instancesBuilder_ == null) {
          ensureInstancesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instances_);
          onChanged();
        } else {
          instancesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder clearInstances() {
        if (instancesBuilder_ == null) {
          instances_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          instancesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public Builder removeInstances(int index) {
        if (instancesBuilder_ == null) {
          ensureInstancesIsMutable();
          instances_.remove(index);
          onChanged();
        } else {
          instancesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder getInstancesBuilder(
          int index) {
        return getInstancesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder getInstancesOrBuilder(
          int index) {
        if (instancesBuilder_ == null) {
          return instances_.get(index);
        } else {
          return instancesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public java.util.List<
              ? extends com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>
          getInstancesOrBuilderList() {
        if (instancesBuilder_ != null) {
          return instancesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(instances_);
        }
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder addInstancesBuilder() {
        return getInstancesFieldBuilder()
            .addBuilder(
                com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder addInstancesBuilder(
          int index) {
        return getInstancesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Status of instances allocated for the TaskGroup.
       * </pre>
       *
       * <code>repeated .google.cloud.batch.v1alpha.JobStatus.InstanceStatus instances = 2;</code>
       */
      public java.util.List<com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder>
          getInstancesBuilderList() {
        return getInstancesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus,
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder,
              com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>
          getInstancesFieldBuilder() {
        if (instancesBuilder_ == null) {
          instancesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus,
                  com.google.cloud.batch.v1alpha.JobStatus.InstanceStatus.Builder,
                  com.google.cloud.batch.v1alpha.JobStatus.InstanceStatusOrBuilder>(
                  instances_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          instances_ = null;
        }
        return instancesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus)
    private static final com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus();
    }

    public static com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TaskGroupStatus> PARSER =
        new com.google.protobuf.AbstractParser<TaskGroupStatus>() {
          @java.lang.Override
          public TaskGroupStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TaskGroupStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TaskGroupStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Job state
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Job state
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobStatus.State getState() {
    com.google.cloud.batch.v1alpha.JobStatus.State result =
        com.google.cloud.batch.v1alpha.JobStatus.State.forNumber(state_);
    return result == null ? com.google.cloud.batch.v1alpha.JobStatus.State.UNRECOGNIZED : result;
  }

  public static final int STATUS_EVENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.batch.v1alpha.StatusEvent> statusEvents_;

  /**
   *
   *
   * <pre>
   * Job status events
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.batch.v1alpha.StatusEvent> getStatusEventsList() {
    return statusEvents_;
  }

  /**
   *
   *
   * <pre>
   * Job status events
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.batch.v1alpha.StatusEventOrBuilder>
      getStatusEventsOrBuilderList() {
    return statusEvents_;
  }

  /**
   *
   *
   * <pre>
   * Job status events
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
   */
  @java.lang.Override
  public int getStatusEventsCount() {
    return statusEvents_.size();
  }

  /**
   *
   *
   * <pre>
   * Job status events
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.StatusEvent getStatusEvents(int index) {
    return statusEvents_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Job status events
   * </pre>
   *
   * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.StatusEventOrBuilder getStatusEventsOrBuilder(int index) {
    return statusEvents_.get(index);
  }

  public static final int TASK_GROUPS_FIELD_NUMBER = 4;

  private static final class TaskGroupsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
                    newDefaultInstance(
                        com.google.cloud.batch.v1alpha.JobProto
                            .internal_static_google_cloud_batch_v1alpha_JobStatus_TaskGroupsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
      taskGroups_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
      internalGetTaskGroups() {
    if (taskGroups_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TaskGroupsDefaultEntryHolder.defaultEntry);
    }
    return taskGroups_;
  }

  public int getTaskGroupsCount() {
    return internalGetTaskGroups().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Aggregated task status for each TaskGroup in the Job.
   * The map key is TaskGroup ID.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
   * </code>
   */
  @java.lang.Override
  public boolean containsTaskGroups(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTaskGroups().getMap().containsKey(key);
  }

  /** Use {@link #getTaskGroupsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
      getTaskGroups() {
    return getTaskGroupsMap();
  }

  /**
   *
   *
   * <pre>
   * Aggregated task status for each TaskGroup in the Job.
   * The map key is TaskGroup ID.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
      getTaskGroupsMap() {
    return internalGetTaskGroups().getMap();
  }

  /**
   *
   *
   * <pre>
   * Aggregated task status for each TaskGroup in the Job.
   * The map key is TaskGroup ID.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus
      getTaskGroupsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus> map =
        internalGetTaskGroups().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Aggregated task status for each TaskGroup in the Job.
   * The map key is TaskGroup ID.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus getTaskGroupsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus> map =
        internalGetTaskGroups().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUN_DURATION_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration runDuration_;

  /**
   *
   *
   * <pre>
   * The duration of time that the Job spent in status RUNNING.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_duration = 5;</code>
   *
   * @return Whether the runDuration field is set.
   */
  @java.lang.Override
  public boolean hasRunDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The duration of time that the Job spent in status RUNNING.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_duration = 5;</code>
   *
   * @return The runDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRunDuration() {
    return runDuration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : runDuration_;
  }

  /**
   *
   *
   * <pre>
   * The duration of time that the Job spent in status RUNNING.
   * </pre>
   *
   * <code>.google.protobuf.Duration run_duration = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRunDurationOrBuilder() {
    return runDuration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : runDuration_;
  }

  public static final int RESOURCE_USAGE_FIELD_NUMBER = 6;
  private com.google.cloud.batch.v1alpha.ResourceUsage resourceUsage_;

  /**
   *
   *
   * <pre>
   * The resource usage of the job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
   *
   * @return Whether the resourceUsage field is set.
   */
  @java.lang.Override
  public boolean hasResourceUsage() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The resource usage of the job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
   *
   * @return The resourceUsage.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ResourceUsage getResourceUsage() {
    return resourceUsage_ == null
        ? com.google.cloud.batch.v1alpha.ResourceUsage.getDefaultInstance()
        : resourceUsage_;
  }

  /**
   *
   *
   * <pre>
   * The resource usage of the job.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.ResourceUsageOrBuilder getResourceUsageOrBuilder() {
    return resourceUsage_ == null
        ? com.google.cloud.batch.v1alpha.ResourceUsage.getDefaultInstance()
        : resourceUsage_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_ != com.google.cloud.batch.v1alpha.JobStatus.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, state_);
    }
    for (int i = 0; i < statusEvents_.size(); i++) {
      output.writeMessage(2, statusEvents_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTaskGroups(), TaskGroupsDefaultEntryHolder.defaultEntry, 4);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getRunDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getResourceUsage());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_ != com.google.cloud.batch.v1alpha.JobStatus.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    for (int i = 0; i < statusEvents_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, statusEvents_.get(i));
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
        entry : internalGetTaskGroups().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
          taskGroups__ =
              TaskGroupsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, taskGroups__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRunDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getResourceUsage());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.JobStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.JobStatus other = (com.google.cloud.batch.v1alpha.JobStatus) obj;

    if (state_ != other.state_) return false;
    if (!getStatusEventsList().equals(other.getStatusEventsList())) return false;
    if (!internalGetTaskGroups().equals(other.internalGetTaskGroups())) return false;
    if (hasRunDuration() != other.hasRunDuration()) return false;
    if (hasRunDuration()) {
      if (!getRunDuration().equals(other.getRunDuration())) return false;
    }
    if (hasResourceUsage() != other.hasResourceUsage()) return false;
    if (hasResourceUsage()) {
      if (!getResourceUsage().equals(other.getResourceUsage())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getStatusEventsCount() > 0) {
      hash = (37 * hash) + STATUS_EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + getStatusEventsList().hashCode();
    }
    if (!internalGetTaskGroups().getMap().isEmpty()) {
      hash = (37 * hash) + TASK_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTaskGroups().hashCode();
    }
    if (hasRunDuration()) {
      hash = (37 * hash) + RUN_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getRunDuration().hashCode();
    }
    if (hasResourceUsage()) {
      hash = (37 * hash) + RESOURCE_USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getResourceUsage().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.JobStatus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.JobStatus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Job status.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.JobStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.JobStatus)
      com.google.cloud.batch.v1alpha.JobStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetTaskGroups();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableTaskGroups();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.JobStatus.class,
              com.google.cloud.batch.v1alpha.JobStatus.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.JobStatus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatusEventsFieldBuilder();
        getRunDurationFieldBuilder();
        getResourceUsageFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      if (statusEventsBuilder_ == null) {
        statusEvents_ = java.util.Collections.emptyList();
      } else {
        statusEvents_ = null;
        statusEventsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableTaskGroups().clear();
      runDuration_ = null;
      if (runDurationBuilder_ != null) {
        runDurationBuilder_.dispose();
        runDurationBuilder_ = null;
      }
      resourceUsage_ = null;
      if (resourceUsageBuilder_ != null) {
        resourceUsageBuilder_.dispose();
        resourceUsageBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.JobProto
          .internal_static_google_cloud_batch_v1alpha_JobStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.JobStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus build() {
      com.google.cloud.batch.v1alpha.JobStatus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus buildPartial() {
      com.google.cloud.batch.v1alpha.JobStatus result =
          new com.google.cloud.batch.v1alpha.JobStatus(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.batch.v1alpha.JobStatus result) {
      if (statusEventsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          statusEvents_ = java.util.Collections.unmodifiableList(statusEvents_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.statusEvents_ = statusEvents_;
      } else {
        result.statusEvents_ = statusEventsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.JobStatus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.taskGroups_ =
            internalGetTaskGroups().build(TaskGroupsDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.runDuration_ =
            runDurationBuilder_ == null ? runDuration_ : runDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.resourceUsage_ =
            resourceUsageBuilder_ == null ? resourceUsage_ : resourceUsageBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.JobStatus) {
        return mergeFrom((com.google.cloud.batch.v1alpha.JobStatus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.JobStatus other) {
      if (other == com.google.cloud.batch.v1alpha.JobStatus.getDefaultInstance()) return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (statusEventsBuilder_ == null) {
        if (!other.statusEvents_.isEmpty()) {
          if (statusEvents_.isEmpty()) {
            statusEvents_ = other.statusEvents_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStatusEventsIsMutable();
            statusEvents_.addAll(other.statusEvents_);
          }
          onChanged();
        }
      } else {
        if (!other.statusEvents_.isEmpty()) {
          if (statusEventsBuilder_.isEmpty()) {
            statusEventsBuilder_.dispose();
            statusEventsBuilder_ = null;
            statusEvents_ = other.statusEvents_;
            bitField0_ = (bitField0_ & ~0x00000002);
            statusEventsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusEventsFieldBuilder()
                    : null;
          } else {
            statusEventsBuilder_.addAllMessages(other.statusEvents_);
          }
        }
      }
      internalGetMutableTaskGroups().mergeFrom(other.internalGetTaskGroups());
      bitField0_ |= 0x00000004;
      if (other.hasRunDuration()) {
        mergeRunDuration(other.getRunDuration());
      }
      if (other.hasResourceUsage()) {
        mergeResourceUsage(other.getResourceUsage());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.batch.v1alpha.StatusEvent m =
                    input.readMessage(
                        com.google.cloud.batch.v1alpha.StatusEvent.parser(), extensionRegistry);
                if (statusEventsBuilder_ == null) {
                  ensureStatusEventsIsMutable();
                  statusEvents_.add(m);
                } else {
                  statusEventsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
                    taskGroups__ =
                        input.readMessage(
                            TaskGroupsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTaskGroups()
                    .ensureBuilderMap()
                    .put(taskGroups__.getKey(), taskGroups__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRunDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getResourceUsageFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Job state
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Job state
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job state
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.State getState() {
      com.google.cloud.batch.v1alpha.JobStatus.State result =
          com.google.cloud.batch.v1alpha.JobStatus.State.forNumber(state_);
      return result == null ? com.google.cloud.batch.v1alpha.JobStatus.State.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Job state
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.batch.v1alpha.JobStatus.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job state
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.JobStatus.State state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.batch.v1alpha.StatusEvent> statusEvents_ =
        java.util.Collections.emptyList();

    private void ensureStatusEventsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        statusEvents_ =
            new java.util.ArrayList<com.google.cloud.batch.v1alpha.StatusEvent>(statusEvents_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.StatusEvent,
            com.google.cloud.batch.v1alpha.StatusEvent.Builder,
            com.google.cloud.batch.v1alpha.StatusEventOrBuilder>
        statusEventsBuilder_;

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public java.util.List<com.google.cloud.batch.v1alpha.StatusEvent> getStatusEventsList() {
      if (statusEventsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusEvents_);
      } else {
        return statusEventsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public int getStatusEventsCount() {
      if (statusEventsBuilder_ == null) {
        return statusEvents_.size();
      } else {
        return statusEventsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.StatusEvent getStatusEvents(int index) {
      if (statusEventsBuilder_ == null) {
        return statusEvents_.get(index);
      } else {
        return statusEventsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder setStatusEvents(int index, com.google.cloud.batch.v1alpha.StatusEvent value) {
      if (statusEventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusEventsIsMutable();
        statusEvents_.set(index, value);
        onChanged();
      } else {
        statusEventsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder setStatusEvents(
        int index, com.google.cloud.batch.v1alpha.StatusEvent.Builder builderForValue) {
      if (statusEventsBuilder_ == null) {
        ensureStatusEventsIsMutable();
        statusEvents_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusEventsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder addStatusEvents(com.google.cloud.batch.v1alpha.StatusEvent value) {
      if (statusEventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusEventsIsMutable();
        statusEvents_.add(value);
        onChanged();
      } else {
        statusEventsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder addStatusEvents(int index, com.google.cloud.batch.v1alpha.StatusEvent value) {
      if (statusEventsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusEventsIsMutable();
        statusEvents_.add(index, value);
        onChanged();
      } else {
        statusEventsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder addStatusEvents(
        com.google.cloud.batch.v1alpha.StatusEvent.Builder builderForValue) {
      if (statusEventsBuilder_ == null) {
        ensureStatusEventsIsMutable();
        statusEvents_.add(builderForValue.build());
        onChanged();
      } else {
        statusEventsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder addStatusEvents(
        int index, com.google.cloud.batch.v1alpha.StatusEvent.Builder builderForValue) {
      if (statusEventsBuilder_ == null) {
        ensureStatusEventsIsMutable();
        statusEvents_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusEventsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder addAllStatusEvents(
        java.lang.Iterable<? extends com.google.cloud.batch.v1alpha.StatusEvent> values) {
      if (statusEventsBuilder_ == null) {
        ensureStatusEventsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusEvents_);
        onChanged();
      } else {
        statusEventsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder clearStatusEvents() {
      if (statusEventsBuilder_ == null) {
        statusEvents_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        statusEventsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public Builder removeStatusEvents(int index) {
      if (statusEventsBuilder_ == null) {
        ensureStatusEventsIsMutable();
        statusEvents_.remove(index);
        onChanged();
      } else {
        statusEventsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.StatusEvent.Builder getStatusEventsBuilder(int index) {
      return getStatusEventsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.StatusEventOrBuilder getStatusEventsOrBuilder(int index) {
      if (statusEventsBuilder_ == null) {
        return statusEvents_.get(index);
      } else {
        return statusEventsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.batch.v1alpha.StatusEventOrBuilder>
        getStatusEventsOrBuilderList() {
      if (statusEventsBuilder_ != null) {
        return statusEventsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusEvents_);
      }
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.StatusEvent.Builder addStatusEventsBuilder() {
      return getStatusEventsFieldBuilder()
          .addBuilder(com.google.cloud.batch.v1alpha.StatusEvent.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.StatusEvent.Builder addStatusEventsBuilder(int index) {
      return getStatusEventsFieldBuilder()
          .addBuilder(index, com.google.cloud.batch.v1alpha.StatusEvent.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Job status events
     * </pre>
     *
     * <code>repeated .google.cloud.batch.v1alpha.StatusEvent status_events = 2;</code>
     */
    public java.util.List<com.google.cloud.batch.v1alpha.StatusEvent.Builder>
        getStatusEventsBuilderList() {
      return getStatusEventsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.batch.v1alpha.StatusEvent,
            com.google.cloud.batch.v1alpha.StatusEvent.Builder,
            com.google.cloud.batch.v1alpha.StatusEventOrBuilder>
        getStatusEventsFieldBuilder() {
      if (statusEventsBuilder_ == null) {
        statusEventsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.batch.v1alpha.StatusEvent,
                com.google.cloud.batch.v1alpha.StatusEvent.Builder,
                com.google.cloud.batch.v1alpha.StatusEventOrBuilder>(
                statusEvents_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        statusEvents_ = null;
      }
      return statusEventsBuilder_;
    }

    private static final class TaskGroupsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus> {
      @java.lang.Override
      public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus build(
          com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder val) {
        if (val instanceof com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) {
          return (com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) val;
        }
        return ((com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
          defaultEntry() {
        return TaskGroupsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final TaskGroupsConverter taskGroupsConverter = new TaskGroupsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder>
        taskGroups_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder>
        internalGetTaskGroups() {
      if (taskGroups_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(taskGroupsConverter);
      }
      return taskGroups_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus,
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder>
        internalGetMutableTaskGroups() {
      if (taskGroups_ == null) {
        taskGroups_ = new com.google.protobuf.MapFieldBuilder<>(taskGroupsConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return taskGroups_;
    }

    public int getTaskGroupsCount() {
      return internalGetTaskGroups().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    @java.lang.Override
    public boolean containsTaskGroups(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTaskGroups().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getTaskGroupsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
        getTaskGroups() {
      return getTaskGroupsMap();
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
        getTaskGroupsMap() {
      return internalGetTaskGroups().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus
        getTaskGroupsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder>
          map = internalGetMutableTaskGroups().ensureBuilderMap();
      return map.containsKey(key) ? taskGroupsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus getTaskGroupsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder>
          map = internalGetMutableTaskGroups().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return taskGroupsConverter.build(map.get(key));
    }

    public Builder clearTaskGroups() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableTaskGroups().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    public Builder removeTaskGroups(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTaskGroups().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
        getMutableTaskGroups() {
      bitField0_ |= 0x00000004;
      return internalGetMutableTaskGroups().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    public Builder putTaskGroups(
        java.lang.String key, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTaskGroups().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    public Builder putAllTaskGroups(
        java.util.Map<java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableTaskGroups().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Aggregated task status for each TaskGroup in the Job.
     * The map key is TaskGroup ID.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus&gt; task_groups = 4;
     * </code>
     */
    public com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder
        putTaskGroupsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String, com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder>
          builderMap = internalGetMutableTaskGroups().ensureBuilderMap();
      com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatusOrBuilder entry = builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) {
        entry = ((com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.batch.v1alpha.JobStatus.TaskGroupStatus.Builder) entry;
    }

    private com.google.protobuf.Duration runDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        runDurationBuilder_;

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     *
     * @return Whether the runDuration field is set.
     */
    public boolean hasRunDuration() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     *
     * @return The runDuration.
     */
    public com.google.protobuf.Duration getRunDuration() {
      if (runDurationBuilder_ == null) {
        return runDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runDuration_;
      } else {
        return runDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public Builder setRunDuration(com.google.protobuf.Duration value) {
      if (runDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runDuration_ = value;
      } else {
        runDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public Builder setRunDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (runDurationBuilder_ == null) {
        runDuration_ = builderForValue.build();
      } else {
        runDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public Builder mergeRunDuration(com.google.protobuf.Duration value) {
      if (runDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && runDuration_ != null
            && runDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getRunDurationBuilder().mergeFrom(value);
        } else {
          runDuration_ = value;
        }
      } else {
        runDurationBuilder_.mergeFrom(value);
      }
      if (runDuration_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public Builder clearRunDuration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      runDuration_ = null;
      if (runDurationBuilder_ != null) {
        runDurationBuilder_.dispose();
        runDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getRunDurationBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRunDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getRunDurationOrBuilder() {
      if (runDurationBuilder_ != null) {
        return runDurationBuilder_.getMessageOrBuilder();
      } else {
        return runDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : runDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * The duration of time that the Job spent in status RUNNING.
     * </pre>
     *
     * <code>.google.protobuf.Duration run_duration = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRunDurationFieldBuilder() {
      if (runDurationBuilder_ == null) {
        runDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRunDuration(), getParentForChildren(), isClean());
        runDuration_ = null;
      }
      return runDurationBuilder_;
    }

    private com.google.cloud.batch.v1alpha.ResourceUsage resourceUsage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ResourceUsage,
            com.google.cloud.batch.v1alpha.ResourceUsage.Builder,
            com.google.cloud.batch.v1alpha.ResourceUsageOrBuilder>
        resourceUsageBuilder_;

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     *
     * @return Whether the resourceUsage field is set.
     */
    public boolean hasResourceUsage() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     *
     * @return The resourceUsage.
     */
    public com.google.cloud.batch.v1alpha.ResourceUsage getResourceUsage() {
      if (resourceUsageBuilder_ == null) {
        return resourceUsage_ == null
            ? com.google.cloud.batch.v1alpha.ResourceUsage.getDefaultInstance()
            : resourceUsage_;
      } else {
        return resourceUsageBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public Builder setResourceUsage(com.google.cloud.batch.v1alpha.ResourceUsage value) {
      if (resourceUsageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceUsage_ = value;
      } else {
        resourceUsageBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public Builder setResourceUsage(
        com.google.cloud.batch.v1alpha.ResourceUsage.Builder builderForValue) {
      if (resourceUsageBuilder_ == null) {
        resourceUsage_ = builderForValue.build();
      } else {
        resourceUsageBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public Builder mergeResourceUsage(com.google.cloud.batch.v1alpha.ResourceUsage value) {
      if (resourceUsageBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && resourceUsage_ != null
            && resourceUsage_
                != com.google.cloud.batch.v1alpha.ResourceUsage.getDefaultInstance()) {
          getResourceUsageBuilder().mergeFrom(value);
        } else {
          resourceUsage_ = value;
        }
      } else {
        resourceUsageBuilder_.mergeFrom(value);
      }
      if (resourceUsage_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public Builder clearResourceUsage() {
      bitField0_ = (bitField0_ & ~0x00000010);
      resourceUsage_ = null;
      if (resourceUsageBuilder_ != null) {
        resourceUsageBuilder_.dispose();
        resourceUsageBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public com.google.cloud.batch.v1alpha.ResourceUsage.Builder getResourceUsageBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getResourceUsageFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    public com.google.cloud.batch.v1alpha.ResourceUsageOrBuilder getResourceUsageOrBuilder() {
      if (resourceUsageBuilder_ != null) {
        return resourceUsageBuilder_.getMessageOrBuilder();
      } else {
        return resourceUsage_ == null
            ? com.google.cloud.batch.v1alpha.ResourceUsage.getDefaultInstance()
            : resourceUsage_;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource usage of the job.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.ResourceUsage resource_usage = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.ResourceUsage,
            com.google.cloud.batch.v1alpha.ResourceUsage.Builder,
            com.google.cloud.batch.v1alpha.ResourceUsageOrBuilder>
        getResourceUsageFieldBuilder() {
      if (resourceUsageBuilder_ == null) {
        resourceUsageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.ResourceUsage,
                com.google.cloud.batch.v1alpha.ResourceUsage.Builder,
                com.google.cloud.batch.v1alpha.ResourceUsageOrBuilder>(
                getResourceUsage(), getParentForChildren(), isClean());
        resourceUsage_ = null;
      }
      return resourceUsageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.JobStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.JobStatus)
  private static final com.google.cloud.batch.v1alpha.JobStatus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.JobStatus();
  }

  public static com.google.cloud.batch.v1alpha.JobStatus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobStatus> PARSER =
      new com.google.protobuf.AbstractParser<JobStatus>() {
        @java.lang.Override
        public JobStatus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobStatus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobStatus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.JobStatus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
