/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/batch/v1alpha/task.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.batch.v1alpha;

/**
 *
 *
 * <pre>
 * Runnable describes instructions for executing a specific script or container
 * as part of a Task.
 * </pre>
 *
 * Protobuf type {@code google.cloud.batch.v1alpha.Runnable}
 */
public final class Runnable extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.Runnable)
    RunnableOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Runnable.newBuilder() to construct.
  private Runnable(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Runnable() {
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Runnable();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.batch.v1alpha.TaskProto
        .internal_static_google_cloud_batch_v1alpha_Runnable_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.batch.v1alpha.TaskProto
        .internal_static_google_cloud_batch_v1alpha_Runnable_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.batch.v1alpha.Runnable.class,
            com.google.cloud.batch.v1alpha.Runnable.Builder.class);
  }

  public interface ContainerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.Runnable.Container)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from.
     * </pre>
     *
     * <code>string image_uri = 1;</code>
     *
     * @return The imageUri.
     */
    java.lang.String getImageUri();

    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from.
     * </pre>
     *
     * <code>string image_uri = 1;</code>
     *
     * @return The bytes for imageUri.
     */
    com.google.protobuf.ByteString getImageUriBytes();

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @return A list containing the commands.
     */
    java.util.List<java.lang.String> getCommandsList();

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @return The count of commands.
     */
    int getCommandsCount();

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The commands at the given index.
     */
    java.lang.String getCommands(int index);

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the commands at the given index.
     */
    com.google.protobuf.ByteString getCommandsBytes(int index);

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `ENTRYPOINT` specified
     * in the container.
     * </pre>
     *
     * <code>string entrypoint = 3;</code>
     *
     * @return The entrypoint.
     */
    java.lang.String getEntrypoint();

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `ENTRYPOINT` specified
     * in the container.
     * </pre>
     *
     * <code>string entrypoint = 3;</code>
     *
     * @return The bytes for entrypoint.
     */
    com.google.protobuf.ByteString getEntrypointBytes();

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @return A list containing the volumes.
     */
    java.util.List<java.lang.String> getVolumesList();

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @return The count of volumes.
     */
    int getVolumesCount();

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The volumes at the given index.
     */
    java.lang.String getVolumes(int index);

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the volumes at the given index.
     */
    com.google.protobuf.ByteString getVolumesBytes(int index);

    /**
     *
     *
     * <pre>
     * Required for some container images. Arbitrary additional options to
     * include in the `docker run` command when running this container&amp;mdash;for
     * example, `--network host`. For the `--volume` option, use the `volumes`
     * field for the container.
     * </pre>
     *
     * <code>string options = 8;</code>
     *
     * @return The options.
     */
    java.lang.String getOptions();

    /**
     *
     *
     * <pre>
     * Required for some container images. Arbitrary additional options to
     * include in the `docker run` command when running this container&amp;mdash;for
     * example, `--network host`. For the `--volume` option, use the `volumes`
     * field for the container.
     * </pre>
     *
     * <code>string options = 8;</code>
     *
     * @return The bytes for options.
     */
    com.google.protobuf.ByteString getOptionsBytes();

    /**
     *
     *
     * <pre>
     * If set to true, external network access to and from container will be
     * blocked, containers that are with block_external_network as true can
     * still communicate with each other, network cannot be specified in the
     * `container.options` field.
     * </pre>
     *
     * <code>bool block_external_network = 9;</code>
     *
     * @return The blockExternalNetwork.
     */
    boolean getBlockExternalNetwork();

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * username to login to the Docker registry that contains the image.
     *
     * You can either specify the username directly by using plain text or
     * specify an encrypted username by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
     * recommended for enhanced security.
     *
     * Caution: If you specify the username using plain text, you risk the
     * username being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the username instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string username = 10;</code>
     *
     * @return The username.
     */
    java.lang.String getUsername();

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * username to login to the Docker registry that contains the image.
     *
     * You can either specify the username directly by using plain text or
     * specify an encrypted username by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
     * recommended for enhanced security.
     *
     * Caution: If you specify the username using plain text, you risk the
     * username being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the username instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string username = 10;</code>
     *
     * @return The bytes for username.
     */
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * password to login to the Docker registry that contains the image.
     *
     * For security, it is strongly recommended to specify an
     * encrypted password by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Warning: If you specify the password using plain text, you risk the
     * password being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the password instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string password = 11;</code>
     *
     * @return The password.
     */
    java.lang.String getPassword();

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * password to login to the Docker registry that contains the image.
     *
     * For security, it is strongly recommended to specify an
     * encrypted password by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Warning: If you specify the password using plain text, you risk the
     * password being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the password instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string password = 11;</code>
     *
     * @return The bytes for password.
     */
    com.google.protobuf.ByteString getPasswordBytes();

    /**
     *
     *
     * <pre>
     * Optional. If set to true, this container runnable uses Image streaming.
     *
     * Use Image streaming to allow the runnable to initialize without
     * waiting for the entire container image to download, which can
     * significantly reduce startup time for large container images.
     *
     * When `enableImageStreaming` is set to true, the container
     * runtime is [containerd](https://containerd.io/) instead of Docker.
     * Additionally, this container runnable only supports the following
     * `container` subfields: `imageUri`,
     * `commands[]`, `entrypoint`, and
     * `volumes[]`; any other `container` subfields are ignored.
     *
     * For more information about the requirements and limitations for using
     * Image streaming with Batch, see the [`image-streaming`
     * sample on
     * GitHub](https://github.com/GoogleCloudPlatform/batch-samples/tree/main/api-samples/image-streaming).
     * </pre>
     *
     * <code>bool enable_image_streaming = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableImageStreaming.
     */
    boolean getEnableImageStreaming();
  }

  /**
   *
   *
   * <pre>
   * Container runnable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Container}
   */
  public static final class Container extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.Runnable.Container)
      ContainerOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Container.newBuilder() to construct.
    private Container(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Container() {
      imageUri_ = "";
      commands_ = com.google.protobuf.LazyStringArrayList.emptyList();
      entrypoint_ = "";
      volumes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      options_ = "";
      username_ = "";
      password_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Container();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Container_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Container_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.Runnable.Container.class,
              com.google.cloud.batch.v1alpha.Runnable.Container.Builder.class);
    }

    public static final int IMAGE_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from.
     * </pre>
     *
     * <code>string image_uri = 1;</code>
     *
     * @return The imageUri.
     */
    @java.lang.Override
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The URI to pull the container image from.
     * </pre>
     *
     * <code>string image_uri = 1;</code>
     *
     * @return The bytes for imageUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMMANDS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList commands_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @return A list containing the commands.
     */
    public com.google.protobuf.ProtocolStringList getCommandsList() {
      return commands_;
    }

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @return The count of commands.
     */
    public int getCommandsCount() {
      return commands_.size();
    }

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The commands at the given index.
     */
    public java.lang.String getCommands(int index) {
      return commands_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `CMD` specified in the
     * container. If there is an `ENTRYPOINT` (either in the container image or
     * with the `entrypoint` field below) then these commands are appended as
     * arguments to the `ENTRYPOINT`.
     * </pre>
     *
     * <code>repeated string commands = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the commands at the given index.
     */
    public com.google.protobuf.ByteString getCommandsBytes(int index) {
      return commands_.getByteString(index);
    }

    public static final int ENTRYPOINT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object entrypoint_ = "";

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `ENTRYPOINT` specified
     * in the container.
     * </pre>
     *
     * <code>string entrypoint = 3;</code>
     *
     * @return The entrypoint.
     */
    @java.lang.Override
    public java.lang.String getEntrypoint() {
      java.lang.Object ref = entrypoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entrypoint_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required for some container images. Overrides the `ENTRYPOINT` specified
     * in the container.
     * </pre>
     *
     * <code>string entrypoint = 3;</code>
     *
     * @return The bytes for entrypoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntrypointBytes() {
      java.lang.Object ref = entrypoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entrypoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VOLUMES_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList volumes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @return A list containing the volumes.
     */
    public com.google.protobuf.ProtocolStringList getVolumesList() {
      return volumes_;
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @return The count of volumes.
     */
    public int getVolumesCount() {
      return volumes_.size();
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The volumes at the given index.
     */
    public java.lang.String getVolumes(int index) {
      return volumes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Volumes to mount (bind mount) from the host machine files or directories
     * into the container, formatted to match `--volume` option for the
     * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
     *
     * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
     * will mount each volume from the host machine to the container with the
     * same mount path by default. In this case, the default mount option for
     * containers will be read-only (`ro`) for existing persistent disks and
     * read-write (`rw`) for other volume types, regardless of the original
     * mount options specified in `TaskSpec.Volumes`. If you need different
     * mount settings, you can explicitly configure them in this field.
     * </pre>
     *
     * <code>repeated string volumes = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the volumes at the given index.
     */
    public com.google.protobuf.ByteString getVolumesBytes(int index) {
      return volumes_.getByteString(index);
    }

    public static final int OPTIONS_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object options_ = "";

    /**
     *
     *
     * <pre>
     * Required for some container images. Arbitrary additional options to
     * include in the `docker run` command when running this container&amp;mdash;for
     * example, `--network host`. For the `--volume` option, use the `volumes`
     * field for the container.
     * </pre>
     *
     * <code>string options = 8;</code>
     *
     * @return The options.
     */
    @java.lang.Override
    public java.lang.String getOptions() {
      java.lang.Object ref = options_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        options_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required for some container images. Arbitrary additional options to
     * include in the `docker run` command when running this container&amp;mdash;for
     * example, `--network host`. For the `--volume` option, use the `volumes`
     * field for the container.
     * </pre>
     *
     * <code>string options = 8;</code>
     *
     * @return The bytes for options.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOptionsBytes() {
      java.lang.Object ref = options_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        options_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BLOCK_EXTERNAL_NETWORK_FIELD_NUMBER = 9;
    private boolean blockExternalNetwork_ = false;

    /**
     *
     *
     * <pre>
     * If set to true, external network access to and from container will be
     * blocked, containers that are with block_external_network as true can
     * still communicate with each other, network cannot be specified in the
     * `container.options` field.
     * </pre>
     *
     * <code>bool block_external_network = 9;</code>
     *
     * @return The blockExternalNetwork.
     */
    @java.lang.Override
    public boolean getBlockExternalNetwork() {
      return blockExternalNetwork_;
    }

    public static final int USERNAME_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private volatile java.lang.Object username_ = "";

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * username to login to the Docker registry that contains the image.
     *
     * You can either specify the username directly by using plain text or
     * specify an encrypted username by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
     * recommended for enhanced security.
     *
     * Caution: If you specify the username using plain text, you risk the
     * username being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the username instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string username = 10;</code>
     *
     * @return The username.
     */
    @java.lang.Override
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * username to login to the Docker registry that contains the image.
     *
     * You can either specify the username directly by using plain text or
     * specify an encrypted username by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
     * recommended for enhanced security.
     *
     * Caution: If you specify the username using plain text, you risk the
     * username being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the username instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string username = 10;</code>
     *
     * @return The bytes for username.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private volatile java.lang.Object password_ = "";

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * password to login to the Docker registry that contains the image.
     *
     * For security, it is strongly recommended to specify an
     * encrypted password by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Warning: If you specify the password using plain text, you risk the
     * password being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the password instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string password = 11;</code>
     *
     * @return The password.
     */
    @java.lang.Override
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required if the container image is from a private Docker registry. The
     * password to login to the Docker registry that contains the image.
     *
     * For security, it is strongly recommended to specify an
     * encrypted password by using a Secret Manager secret:
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Warning: If you specify the password using plain text, you risk the
     * password being exposed to any users who can view the job or its logs.
     * To avoid this risk, specify a secret that contains the password instead.
     *
     * Learn more about [Secret
     * Manager](https://cloud.google.com/secret-manager/docs/) and [using
     * Secret Manager with
     * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
     * </pre>
     *
     * <code>string password = 11;</code>
     *
     * @return The bytes for password.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENABLE_IMAGE_STREAMING_FIELD_NUMBER = 12;
    private boolean enableImageStreaming_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, this container runnable uses Image streaming.
     *
     * Use Image streaming to allow the runnable to initialize without
     * waiting for the entire container image to download, which can
     * significantly reduce startup time for large container images.
     *
     * When `enableImageStreaming` is set to true, the container
     * runtime is [containerd](https://containerd.io/) instead of Docker.
     * Additionally, this container runnable only supports the following
     * `container` subfields: `imageUri`,
     * `commands[]`, `entrypoint`, and
     * `volumes[]`; any other `container` subfields are ignored.
     *
     * For more information about the requirements and limitations for using
     * Image streaming with Batch, see the [`image-streaming`
     * sample on
     * GitHub](https://github.com/GoogleCloudPlatform/batch-samples/tree/main/api-samples/image-streaming).
     * </pre>
     *
     * <code>bool enable_image_streaming = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableImageStreaming.
     */
    @java.lang.Override
    public boolean getEnableImageStreaming() {
      return enableImageStreaming_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
      }
      for (int i = 0; i < commands_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, commands_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entrypoint_);
      }
      for (int i = 0; i < volumes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, volumes_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(options_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, options_);
      }
      if (blockExternalNetwork_ != false) {
        output.writeBool(9, blockExternalNetwork_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, password_);
      }
      if (enableImageStreaming_ != false) {
        output.writeBool(12, enableImageStreaming_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < commands_.size(); i++) {
          dataSize += computeStringSizeNoTag(commands_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCommandsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entrypoint_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < volumes_.size(); i++) {
          dataSize += computeStringSizeNoTag(volumes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getVolumesList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(options_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, options_);
      }
      if (blockExternalNetwork_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, blockExternalNetwork_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, password_);
      }
      if (enableImageStreaming_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, enableImageStreaming_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.Runnable.Container)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.Runnable.Container other =
          (com.google.cloud.batch.v1alpha.Runnable.Container) obj;

      if (!getImageUri().equals(other.getImageUri())) return false;
      if (!getCommandsList().equals(other.getCommandsList())) return false;
      if (!getEntrypoint().equals(other.getEntrypoint())) return false;
      if (!getVolumesList().equals(other.getVolumesList())) return false;
      if (!getOptions().equals(other.getOptions())) return false;
      if (getBlockExternalNetwork() != other.getBlockExternalNetwork()) return false;
      if (!getUsername().equals(other.getUsername())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (getEnableImageStreaming() != other.getEnableImageStreaming()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
      hash = (53 * hash) + getImageUri().hashCode();
      if (getCommandsCount() > 0) {
        hash = (37 * hash) + COMMANDS_FIELD_NUMBER;
        hash = (53 * hash) + getCommandsList().hashCode();
      }
      hash = (37 * hash) + ENTRYPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEntrypoint().hashCode();
      if (getVolumesCount() > 0) {
        hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
        hash = (53 * hash) + getVolumesList().hashCode();
      }
      hash = (37 * hash) + OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOptions().hashCode();
      hash = (37 * hash) + BLOCK_EXTERNAL_NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBlockExternalNetwork());
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      hash = (37 * hash) + ENABLE_IMAGE_STREAMING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableImageStreaming());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.batch.v1alpha.Runnable.Container prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Container}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.Runnable.Container)
        com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Container_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Container_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.Runnable.Container.class,
                com.google.cloud.batch.v1alpha.Runnable.Container.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.Runnable.Container.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        imageUri_ = "";
        commands_ = com.google.protobuf.LazyStringArrayList.emptyList();
        entrypoint_ = "";
        volumes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        options_ = "";
        blockExternalNetwork_ = false;
        username_ = "";
        password_ = "";
        enableImageStreaming_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Container_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Container getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Container build() {
        com.google.cloud.batch.v1alpha.Runnable.Container result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Container buildPartial() {
        com.google.cloud.batch.v1alpha.Runnable.Container result =
            new com.google.cloud.batch.v1alpha.Runnable.Container(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.Runnable.Container result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.imageUri_ = imageUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          commands_.makeImmutable();
          result.commands_ = commands_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.entrypoint_ = entrypoint_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          volumes_.makeImmutable();
          result.volumes_ = volumes_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.options_ = options_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.blockExternalNetwork_ = blockExternalNetwork_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.username_ = username_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.password_ = password_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.enableImageStreaming_ = enableImageStreaming_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.Runnable.Container) {
          return mergeFrom((com.google.cloud.batch.v1alpha.Runnable.Container) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.Runnable.Container other) {
        if (other == com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance())
          return this;
        if (!other.getImageUri().isEmpty()) {
          imageUri_ = other.imageUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.commands_.isEmpty()) {
          if (commands_.isEmpty()) {
            commands_ = other.commands_;
            bitField0_ |= 0x00000002;
          } else {
            ensureCommandsIsMutable();
            commands_.addAll(other.commands_);
          }
          onChanged();
        }
        if (!other.getEntrypoint().isEmpty()) {
          entrypoint_ = other.entrypoint_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ |= 0x00000008;
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
        if (!other.getOptions().isEmpty()) {
          options_ = other.options_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.getBlockExternalNetwork() != false) {
          setBlockExternalNetwork(other.getBlockExternalNetwork());
        }
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          bitField0_ |= 0x00000040;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        if (other.getEnableImageStreaming() != false) {
          setEnableImageStreaming(other.getEnableImageStreaming());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  imageUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCommandsIsMutable();
                  commands_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  entrypoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 58:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureVolumesIsMutable();
                  volumes_.add(s);
                  break;
                } // case 58
              case 66:
                {
                  options_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 66
              case 72:
                {
                  blockExternalNetwork_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 72
              case 82:
                {
                  username_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 82
              case 90:
                {
                  password_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 90
              case 96:
                {
                  enableImageStreaming_ = input.readBool();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 96
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object imageUri_ = "";

      /**
       *
       *
       * <pre>
       * Required. The URI to pull the container image from.
       * </pre>
       *
       * <code>string image_uri = 1;</code>
       *
       * @return The imageUri.
       */
      public java.lang.String getImageUri() {
        java.lang.Object ref = imageUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to pull the container image from.
       * </pre>
       *
       * <code>string image_uri = 1;</code>
       *
       * @return The bytes for imageUri.
       */
      public com.google.protobuf.ByteString getImageUriBytes() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to pull the container image from.
       * </pre>
       *
       * <code>string image_uri = 1;</code>
       *
       * @param value The imageUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to pull the container image from.
       * </pre>
       *
       * <code>string image_uri = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageUri() {
        imageUri_ = getDefaultInstance().getImageUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The URI to pull the container image from.
       * </pre>
       *
       * <code>string image_uri = 1;</code>
       *
       * @param value The bytes for imageUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList commands_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCommandsIsMutable() {
        if (!commands_.isModifiable()) {
          commands_ = new com.google.protobuf.LazyStringArrayList(commands_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @return A list containing the commands.
       */
      public com.google.protobuf.ProtocolStringList getCommandsList() {
        commands_.makeImmutable();
        return commands_;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @return The count of commands.
       */
      public int getCommandsCount() {
        return commands_.size();
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The commands at the given index.
       */
      public java.lang.String getCommands(int index) {
        return commands_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the commands at the given index.
       */
      public com.google.protobuf.ByteString getCommandsBytes(int index) {
        return commands_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The commands to set.
       * @return This builder for chaining.
       */
      public Builder setCommands(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandsIsMutable();
        commands_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param value The commands to add.
       * @return This builder for chaining.
       */
      public Builder addCommands(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommandsIsMutable();
        commands_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param values The commands to add.
       * @return This builder for chaining.
       */
      public Builder addAllCommands(java.lang.Iterable<java.lang.String> values) {
        ensureCommandsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, commands_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommands() {
        commands_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `CMD` specified in the
       * container. If there is an `ENTRYPOINT` (either in the container image or
       * with the `entrypoint` field below) then these commands are appended as
       * arguments to the `ENTRYPOINT`.
       * </pre>
       *
       * <code>repeated string commands = 2;</code>
       *
       * @param value The bytes of the commands to add.
       * @return This builder for chaining.
       */
      public Builder addCommandsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCommandsIsMutable();
        commands_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object entrypoint_ = "";

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `ENTRYPOINT` specified
       * in the container.
       * </pre>
       *
       * <code>string entrypoint = 3;</code>
       *
       * @return The entrypoint.
       */
      public java.lang.String getEntrypoint() {
        java.lang.Object ref = entrypoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entrypoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `ENTRYPOINT` specified
       * in the container.
       * </pre>
       *
       * <code>string entrypoint = 3;</code>
       *
       * @return The bytes for entrypoint.
       */
      public com.google.protobuf.ByteString getEntrypointBytes() {
        java.lang.Object ref = entrypoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entrypoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `ENTRYPOINT` specified
       * in the container.
       * </pre>
       *
       * <code>string entrypoint = 3;</code>
       *
       * @param value The entrypoint to set.
       * @return This builder for chaining.
       */
      public Builder setEntrypoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        entrypoint_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `ENTRYPOINT` specified
       * in the container.
       * </pre>
       *
       * <code>string entrypoint = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntrypoint() {
        entrypoint_ = getDefaultInstance().getEntrypoint();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Overrides the `ENTRYPOINT` specified
       * in the container.
       * </pre>
       *
       * <code>string entrypoint = 3;</code>
       *
       * @param value The bytes for entrypoint to set.
       * @return This builder for chaining.
       */
      public Builder setEntrypointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        entrypoint_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList volumes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureVolumesIsMutable() {
        if (!volumes_.isModifiable()) {
          volumes_ = new com.google.protobuf.LazyStringArrayList(volumes_);
        }
        bitField0_ |= 0x00000008;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @return A list containing the volumes.
       */
      public com.google.protobuf.ProtocolStringList getVolumesList() {
        volumes_.makeImmutable();
        return volumes_;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @return The count of volumes.
       */
      public int getVolumesCount() {
        return volumes_.size();
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param index The index of the element to return.
       * @return The volumes at the given index.
       */
      public java.lang.String getVolumes(int index) {
        return volumes_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the volumes at the given index.
       */
      public com.google.protobuf.ByteString getVolumesBytes(int index) {
        return volumes_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param index The index to set the value at.
       * @param value The volumes to set.
       * @return This builder for chaining.
       */
      public Builder setVolumes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param value The volumes to add.
       * @return This builder for chaining.
       */
      public Builder addVolumes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param values The volumes to add.
       * @return This builder for chaining.
       */
      public Builder addAllVolumes(java.lang.Iterable<java.lang.String> values) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVolumes() {
        volumes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Volumes to mount (bind mount) from the host machine files or directories
       * into the container, formatted to match `--volume` option for the
       * `docker run` command&amp;mdash;for example, `/foo:/bar` or `/foo:/bar:ro`.
       *
       * If the `TaskSpec.Volumes` field is specified but this field is not, Batch
       * will mount each volume from the host machine to the container with the
       * same mount path by default. In this case, the default mount option for
       * containers will be read-only (`ro`) for existing persistent disks and
       * read-write (`rw`) for other volume types, regardless of the original
       * mount options specified in `TaskSpec.Volumes`. If you need different
       * mount settings, you can explicitly configure them in this field.
       * </pre>
       *
       * <code>repeated string volumes = 7;</code>
       *
       * @param value The bytes of the volumes to add.
       * @return This builder for chaining.
       */
      public Builder addVolumesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureVolumesIsMutable();
        volumes_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private java.lang.Object options_ = "";

      /**
       *
       *
       * <pre>
       * Required for some container images. Arbitrary additional options to
       * include in the `docker run` command when running this container&amp;mdash;for
       * example, `--network host`. For the `--volume` option, use the `volumes`
       * field for the container.
       * </pre>
       *
       * <code>string options = 8;</code>
       *
       * @return The options.
       */
      public java.lang.String getOptions() {
        java.lang.Object ref = options_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          options_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Arbitrary additional options to
       * include in the `docker run` command when running this container&amp;mdash;for
       * example, `--network host`. For the `--volume` option, use the `volumes`
       * field for the container.
       * </pre>
       *
       * <code>string options = 8;</code>
       *
       * @return The bytes for options.
       */
      public com.google.protobuf.ByteString getOptionsBytes() {
        java.lang.Object ref = options_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          options_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Arbitrary additional options to
       * include in the `docker run` command when running this container&amp;mdash;for
       * example, `--network host`. For the `--volume` option, use the `volumes`
       * field for the container.
       * </pre>
       *
       * <code>string options = 8;</code>
       *
       * @param value The options to set.
       * @return This builder for chaining.
       */
      public Builder setOptions(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        options_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Arbitrary additional options to
       * include in the `docker run` command when running this container&amp;mdash;for
       * example, `--network host`. For the `--volume` option, use the `volumes`
       * field for the container.
       * </pre>
       *
       * <code>string options = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOptions() {
        options_ = getDefaultInstance().getOptions();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required for some container images. Arbitrary additional options to
       * include in the `docker run` command when running this container&amp;mdash;for
       * example, `--network host`. For the `--volume` option, use the `volumes`
       * field for the container.
       * </pre>
       *
       * <code>string options = 8;</code>
       *
       * @param value The bytes for options to set.
       * @return This builder for chaining.
       */
      public Builder setOptionsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        options_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private boolean blockExternalNetwork_;

      /**
       *
       *
       * <pre>
       * If set to true, external network access to and from container will be
       * blocked, containers that are with block_external_network as true can
       * still communicate with each other, network cannot be specified in the
       * `container.options` field.
       * </pre>
       *
       * <code>bool block_external_network = 9;</code>
       *
       * @return The blockExternalNetwork.
       */
      @java.lang.Override
      public boolean getBlockExternalNetwork() {
        return blockExternalNetwork_;
      }

      /**
       *
       *
       * <pre>
       * If set to true, external network access to and from container will be
       * blocked, containers that are with block_external_network as true can
       * still communicate with each other, network cannot be specified in the
       * `container.options` field.
       * </pre>
       *
       * <code>bool block_external_network = 9;</code>
       *
       * @param value The blockExternalNetwork to set.
       * @return This builder for chaining.
       */
      public Builder setBlockExternalNetwork(boolean value) {

        blockExternalNetwork_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If set to true, external network access to and from container will be
       * blocked, containers that are with block_external_network as true can
       * still communicate with each other, network cannot be specified in the
       * `container.options` field.
       * </pre>
       *
       * <code>bool block_external_network = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBlockExternalNetwork() {
        bitField0_ = (bitField0_ & ~0x00000020);
        blockExternalNetwork_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object username_ = "";

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * username to login to the Docker registry that contains the image.
       *
       * You can either specify the username directly by using plain text or
       * specify an encrypted username by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
       * recommended for enhanced security.
       *
       * Caution: If you specify the username using plain text, you risk the
       * username being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the username instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string username = 10;</code>
       *
       * @return The username.
       */
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * username to login to the Docker registry that contains the image.
       *
       * You can either specify the username directly by using plain text or
       * specify an encrypted username by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
       * recommended for enhanced security.
       *
       * Caution: If you specify the username using plain text, you risk the
       * username being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the username instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string username = 10;</code>
       *
       * @return The bytes for username.
       */
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * username to login to the Docker registry that contains the image.
       *
       * You can either specify the username directly by using plain text or
       * specify an encrypted username by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
       * recommended for enhanced security.
       *
       * Caution: If you specify the username using plain text, you risk the
       * username being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the username instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string username = 10;</code>
       *
       * @param value The username to set.
       * @return This builder for chaining.
       */
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        username_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * username to login to the Docker registry that contains the image.
       *
       * You can either specify the username directly by using plain text or
       * specify an encrypted username by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
       * recommended for enhanced security.
       *
       * Caution: If you specify the username using plain text, you risk the
       * username being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the username instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string username = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsername() {
        username_ = getDefaultInstance().getUsername();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * username to login to the Docker registry that contains the image.
       *
       * You can either specify the username directly by using plain text or
       * specify an encrypted username by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. However, using a secret is
       * recommended for enhanced security.
       *
       * Caution: If you specify the username using plain text, you risk the
       * username being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the username instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string username = 10;</code>
       *
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        username_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * password to login to the Docker registry that contains the image.
       *
       * For security, it is strongly recommended to specify an
       * encrypted password by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       *
       * Warning: If you specify the password using plain text, you risk the
       * password being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the password instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string password = 11;</code>
       *
       * @return The password.
       */
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * password to login to the Docker registry that contains the image.
       *
       * For security, it is strongly recommended to specify an
       * encrypted password by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       *
       * Warning: If you specify the password using plain text, you risk the
       * password being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the password instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string password = 11;</code>
       *
       * @return The bytes for password.
       */
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * password to login to the Docker registry that contains the image.
       *
       * For security, it is strongly recommended to specify an
       * encrypted password by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       *
       * Warning: If you specify the password using plain text, you risk the
       * password being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the password instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string password = 11;</code>
       *
       * @param value The password to set.
       * @return This builder for chaining.
       */
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        password_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * password to login to the Docker registry that contains the image.
       *
       * For security, it is strongly recommended to specify an
       * encrypted password by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       *
       * Warning: If you specify the password using plain text, you risk the
       * password being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the password instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string password = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPassword() {
        password_ = getDefaultInstance().getPassword();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required if the container image is from a private Docker registry. The
       * password to login to the Docker registry that contains the image.
       *
       * For security, it is strongly recommended to specify an
       * encrypted password by using a Secret Manager secret:
       * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
       *
       * Warning: If you specify the password using plain text, you risk the
       * password being exposed to any users who can view the job or its logs.
       * To avoid this risk, specify a secret that contains the password instead.
       *
       * Learn more about [Secret
       * Manager](https://cloud.google.com/secret-manager/docs/) and [using
       * Secret Manager with
       * Batch](https://cloud.google.com/batch/docs/create-run-job-secret-manager).
       * </pre>
       *
       * <code>string password = 11;</code>
       *
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        password_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private boolean enableImageStreaming_;

      /**
       *
       *
       * <pre>
       * Optional. If set to true, this container runnable uses Image streaming.
       *
       * Use Image streaming to allow the runnable to initialize without
       * waiting for the entire container image to download, which can
       * significantly reduce startup time for large container images.
       *
       * When `enableImageStreaming` is set to true, the container
       * runtime is [containerd](https://containerd.io/) instead of Docker.
       * Additionally, this container runnable only supports the following
       * `container` subfields: `imageUri`,
       * `commands[]`, `entrypoint`, and
       * `volumes[]`; any other `container` subfields are ignored.
       *
       * For more information about the requirements and limitations for using
       * Image streaming with Batch, see the [`image-streaming`
       * sample on
       * GitHub](https://github.com/GoogleCloudPlatform/batch-samples/tree/main/api-samples/image-streaming).
       * </pre>
       *
       * <code>bool enable_image_streaming = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The enableImageStreaming.
       */
      @java.lang.Override
      public boolean getEnableImageStreaming() {
        return enableImageStreaming_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set to true, this container runnable uses Image streaming.
       *
       * Use Image streaming to allow the runnable to initialize without
       * waiting for the entire container image to download, which can
       * significantly reduce startup time for large container images.
       *
       * When `enableImageStreaming` is set to true, the container
       * runtime is [containerd](https://containerd.io/) instead of Docker.
       * Additionally, this container runnable only supports the following
       * `container` subfields: `imageUri`,
       * `commands[]`, `entrypoint`, and
       * `volumes[]`; any other `container` subfields are ignored.
       *
       * For more information about the requirements and limitations for using
       * Image streaming with Batch, see the [`image-streaming`
       * sample on
       * GitHub](https://github.com/GoogleCloudPlatform/batch-samples/tree/main/api-samples/image-streaming).
       * </pre>
       *
       * <code>bool enable_image_streaming = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The enableImageStreaming to set.
       * @return This builder for chaining.
       */
      public Builder setEnableImageStreaming(boolean value) {

        enableImageStreaming_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set to true, this container runnable uses Image streaming.
       *
       * Use Image streaming to allow the runnable to initialize without
       * waiting for the entire container image to download, which can
       * significantly reduce startup time for large container images.
       *
       * When `enableImageStreaming` is set to true, the container
       * runtime is [containerd](https://containerd.io/) instead of Docker.
       * Additionally, this container runnable only supports the following
       * `container` subfields: `imageUri`,
       * `commands[]`, `entrypoint`, and
       * `volumes[]`; any other `container` subfields are ignored.
       *
       * For more information about the requirements and limitations for using
       * Image streaming with Batch, see the [`image-streaming`
       * sample on
       * GitHub](https://github.com/GoogleCloudPlatform/batch-samples/tree/main/api-samples/image-streaming).
       * </pre>
       *
       * <code>bool enable_image_streaming = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableImageStreaming() {
        bitField0_ = (bitField0_ & ~0x00000100);
        enableImageStreaming_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.Runnable.Container)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.Runnable.Container)
    private static final com.google.cloud.batch.v1alpha.Runnable.Container DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.Runnable.Container();
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Container getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Container> PARSER =
        new com.google.protobuf.AbstractParser<Container>() {
          @java.lang.Override
          public Container parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Container> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Container> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Container getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScriptOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.Runnable.Script)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return Whether the path field is set.
     */
    boolean hasPath();

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return Whether the text field is set.
     */
    boolean hasText();

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    java.lang.String getText();

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    com.google.protobuf.ByteString getTextBytes();

    com.google.cloud.batch.v1alpha.Runnable.Script.CommandCase getCommandCase();
  }

  /**
   *
   *
   * <pre>
   * Script runnable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Script}
   */
  public static final class Script extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.Runnable.Script)
      ScriptOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Script.newBuilder() to construct.
    private Script(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Script() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Script();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Script_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Script_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.Runnable.Script.class,
              com.google.cloud.batch.v1alpha.Runnable.Script.Builder.class);
    }

    private int commandCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object command_;

    public enum CommandCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PATH(1),
      TEXT(2),
      COMMAND_NOT_SET(0);
      private final int value;

      private CommandCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CommandCase valueOf(int value) {
        return forNumber(value);
      }

      public static CommandCase forNumber(int value) {
        switch (value) {
          case 1:
            return PATH;
          case 2:
            return TEXT;
          case 0:
            return COMMAND_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public CommandCase getCommandCase() {
      return CommandCase.forNumber(commandCase_);
    }

    public static final int PATH_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return Whether the path field is set.
     */
    public boolean hasPath() {
      return commandCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = "";
      if (commandCase_ == 1) {
        ref = command_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (commandCase_ == 1) {
          command_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The path to a script file that is accessible from the host VM(s).
     *
     * Unless the script file supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
     * first line of the file. For example, to execute the script using bash,
     * include `#!/bin/bash` as the first line of the file. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3`
     * as the first line of the file.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = "";
      if (commandCase_ == 1) {
        ref = command_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (commandCase_ == 1) {
          command_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TEXT_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return Whether the text field is set.
     */
    public boolean hasText() {
      return commandCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (commandCase_ == 2) {
        ref = command_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (commandCase_ == 2) {
          command_ = s;
        }
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The text for a script.
     *
     * Unless the script text supports the default `#!/bin/sh` shell
     * interpreter, you must specify an interpreter by including a
     * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
     * beginning of the text. For example, to execute the script using bash,
     * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
     * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
     * at the beginning of the text.
     * </pre>
     *
     * <code>string text = 2;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (commandCase_ == 2) {
        ref = command_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (commandCase_ == 2) {
          command_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (commandCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, command_);
      }
      if (commandCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (commandCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, command_);
      }
      if (commandCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, command_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.Runnable.Script)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.Runnable.Script other =
          (com.google.cloud.batch.v1alpha.Runnable.Script) obj;

      if (!getCommandCase().equals(other.getCommandCase())) return false;
      switch (commandCase_) {
        case 1:
          if (!getPath().equals(other.getPath())) return false;
          break;
        case 2:
          if (!getText().equals(other.getText())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (commandCase_) {
        case 1:
          hash = (37 * hash) + PATH_FIELD_NUMBER;
          hash = (53 * hash) + getPath().hashCode();
          break;
        case 2:
          hash = (37 * hash) + TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getText().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.batch.v1alpha.Runnable.Script prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Script}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.Runnable.Script)
        com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Script_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Script_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.Runnable.Script.class,
                com.google.cloud.batch.v1alpha.Runnable.Script.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.Runnable.Script.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        commandCase_ = 0;
        command_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Script_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Script getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Script build() {
        com.google.cloud.batch.v1alpha.Runnable.Script result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Script buildPartial() {
        com.google.cloud.batch.v1alpha.Runnable.Script result =
            new com.google.cloud.batch.v1alpha.Runnable.Script(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.Runnable.Script result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(com.google.cloud.batch.v1alpha.Runnable.Script result) {
        result.commandCase_ = commandCase_;
        result.command_ = this.command_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.Runnable.Script) {
          return mergeFrom((com.google.cloud.batch.v1alpha.Runnable.Script) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.Runnable.Script other) {
        if (other == com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance())
          return this;
        switch (other.getCommandCase()) {
          case PATH:
            {
              commandCase_ = 1;
              command_ = other.command_;
              onChanged();
              break;
            }
          case TEXT:
            {
              commandCase_ = 2;
              command_ = other.command_;
              onChanged();
              break;
            }
          case COMMAND_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  commandCase_ = 1;
                  command_ = s;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  commandCase_ = 2;
                  command_ = s;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int commandCase_ = 0;
      private java.lang.Object command_;

      public CommandCase getCommandCase() {
        return CommandCase.forNumber(commandCase_);
      }

      public Builder clearCommand() {
        commandCase_ = 0;
        command_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return Whether the path field is set.
       */
      @java.lang.Override
      public boolean hasPath() {
        return commandCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The path.
       */
      @java.lang.Override
      public java.lang.String getPath() {
        java.lang.Object ref = "";
        if (commandCase_ == 1) {
          ref = command_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (commandCase_ == 1) {
            command_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return The bytes for path.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = "";
        if (commandCase_ == 1) {
          ref = command_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (commandCase_ == 1) {
            command_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        commandCase_ = 1;
        command_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        if (commandCase_ == 1) {
          commandCase_ = 0;
          command_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The path to a script file that is accessible from the host VM(s).
       *
       * Unless the script file supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) as the
       * first line of the file. For example, to execute the script using bash,
       * include `#!/bin/bash` as the first line of the file. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3`
       * as the first line of the file.
       * </pre>
       *
       * <code>string path = 1;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        commandCase_ = 1;
        command_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return Whether the text field is set.
       */
      @java.lang.Override
      public boolean hasText() {
        return commandCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = "";
        if (commandCase_ == 2) {
          ref = command_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (commandCase_ == 2) {
            command_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = "";
        if (commandCase_ == 2) {
          ref = command_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (commandCase_ == 2) {
            command_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The text to set.
       * @return This builder for chaining.
       */
      public Builder setText(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        commandCase_ = 2;
        command_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearText() {
        if (commandCase_ == 2) {
          commandCase_ = 0;
          command_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The text for a script.
       *
       * Unless the script text supports the default `#!/bin/sh` shell
       * interpreter, you must specify an interpreter by including a
       * [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix) at the
       * beginning of the text. For example, to execute the script using bash,
       * include `#!/bin/bash&#92;n` at the beginning of the text. Alternatively,
       * to execute the script using Python3, include `#!/usr/bin/env python3&#92;n`
       * at the beginning of the text.
       * </pre>
       *
       * <code>string text = 2;</code>
       *
       * @param value The bytes for text to set.
       * @return This builder for chaining.
       */
      public Builder setTextBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        commandCase_ = 2;
        command_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.Runnable.Script)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.Runnable.Script)
    private static final com.google.cloud.batch.v1alpha.Runnable.Script DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.Runnable.Script();
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Script getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Script> PARSER =
        new com.google.protobuf.AbstractParser<Script>() {
          @java.lang.Override
          public Script parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Script> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Script> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Script getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BarrierOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.batch.v1alpha.Runnable.Barrier)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Barriers are identified by their index in runnable list.
     * Names are not required, but if present should be an identifier.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Barriers are identified by their index in runnable list.
     * Names are not required, but if present should be an identifier.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }

  /**
   *
   *
   * <pre>
   * A barrier runnable automatically blocks the execution of subsequent
   * runnables until all the tasks in the task group reach the barrier.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Barrier}
   */
  public static final class Barrier extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.batch.v1alpha.Runnable.Barrier)
      BarrierOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Barrier.newBuilder() to construct.
    private Barrier(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Barrier() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Barrier();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Barrier_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_Barrier_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.Runnable.Barrier.class,
              com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Barriers are identified by their index in runnable list.
     * Names are not required, but if present should be an identifier.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Barriers are identified by their index in runnable list.
     * Names are not required, but if present should be an identifier.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.batch.v1alpha.Runnable.Barrier)) {
        return super.equals(obj);
      }
      com.google.cloud.batch.v1alpha.Runnable.Barrier other =
          (com.google.cloud.batch.v1alpha.Runnable.Barrier) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.batch.v1alpha.Runnable.Barrier prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A barrier runnable automatically blocks the execution of subsequent
     * runnables until all the tasks in the task group reach the barrier.
     * </pre>
     *
     * Protobuf type {@code google.cloud.batch.v1alpha.Runnable.Barrier}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.Runnable.Barrier)
        com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Barrier_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Barrier_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.batch.v1alpha.Runnable.Barrier.class,
                com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder.class);
      }

      // Construct using com.google.cloud.batch.v1alpha.Runnable.Barrier.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.batch.v1alpha.TaskProto
            .internal_static_google_cloud_batch_v1alpha_Runnable_Barrier_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Barrier getDefaultInstanceForType() {
        return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Barrier build() {
        com.google.cloud.batch.v1alpha.Runnable.Barrier result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.batch.v1alpha.Runnable.Barrier buildPartial() {
        com.google.cloud.batch.v1alpha.Runnable.Barrier result =
            new com.google.cloud.batch.v1alpha.Runnable.Barrier(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.batch.v1alpha.Runnable.Barrier result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.batch.v1alpha.Runnable.Barrier) {
          return mergeFrom((com.google.cloud.batch.v1alpha.Runnable.Barrier) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.batch.v1alpha.Runnable.Barrier other) {
        if (other == com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Barriers are identified by their index in runnable list.
       * Names are not required, but if present should be an identifier.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Barriers are identified by their index in runnable list.
       * Names are not required, but if present should be an identifier.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Barriers are identified by their index in runnable list.
       * Names are not required, but if present should be an identifier.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Barriers are identified by their index in runnable list.
       * Names are not required, but if present should be an identifier.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Barriers are identified by their index in runnable list.
       * Names are not required, but if present should be an identifier.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.Runnable.Barrier)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.Runnable.Barrier)
    private static final com.google.cloud.batch.v1alpha.Runnable.Barrier DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.Runnable.Barrier();
    }

    public static com.google.cloud.batch.v1alpha.Runnable.Barrier getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Barrier> PARSER =
        new com.google.protobuf.AbstractParser<Barrier>() {
          @java.lang.Override
          public Barrier parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Barrier> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Barrier> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Barrier getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int executableCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object executable_;

  public enum ExecutableCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONTAINER(1),
    SCRIPT(2),
    BARRIER(6),
    EXECUTABLE_NOT_SET(0);
    private final int value;

    private ExecutableCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExecutableCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExecutableCase forNumber(int value) {
      switch (value) {
        case 1:
          return CONTAINER;
        case 2:
          return SCRIPT;
        case 6:
          return BARRIER;
        case 0:
          return EXECUTABLE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExecutableCase getExecutableCase() {
    return ExecutableCase.forNumber(executableCase_);
  }

  public static final int CONTAINER_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Container runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
   *
   * @return Whether the container field is set.
   */
  @java.lang.Override
  public boolean hasContainer() {
    return executableCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Container runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
   *
   * @return The container.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.Container getContainer() {
    if (executableCase_ == 1) {
      return (com.google.cloud.batch.v1alpha.Runnable.Container) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Container runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder getContainerOrBuilder() {
    if (executableCase_ == 1) {
      return (com.google.cloud.batch.v1alpha.Runnable.Container) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
  }

  public static final int SCRIPT_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Script runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
   *
   * @return Whether the script field is set.
   */
  @java.lang.Override
  public boolean hasScript() {
    return executableCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Script runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
   *
   * @return The script.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.Script getScript() {
    if (executableCase_ == 2) {
      return (com.google.cloud.batch.v1alpha.Runnable.Script) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Script runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder getScriptOrBuilder() {
    if (executableCase_ == 2) {
      return (com.google.cloud.batch.v1alpha.Runnable.Script) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
  }

  public static final int BARRIER_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Barrier runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
   *
   * @return Whether the barrier field is set.
   */
  @java.lang.Override
  public boolean hasBarrier() {
    return executableCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Barrier runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
   *
   * @return The barrier.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.Barrier getBarrier() {
    if (executableCase_ == 6) {
      return (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Barrier runnable.
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder getBarrierOrBuilder() {
    if (executableCase_ == 6) {
      return (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_;
    }
    return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. DisplayName is an optional field that can be provided by the
   * caller. If provided, it will be used in logs and other outputs to identify
   * the script, making it easier for users to understand the logs. If not
   * provided the index of the runnable will be used for outputs.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. DisplayName is an optional field that can be provided by the
   * caller. If provided, it will be used in logs and other outputs to identify
   * the script, making it easier for users to understand the logs. If not
   * provided the index of the runnable will be used for outputs.
   * </pre>
   *
   * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IGNORE_EXIT_STATUS_FIELD_NUMBER = 3;
  private boolean ignoreExitStatus_ = false;

  /**
   *
   *
   * <pre>
   * Normally, a runnable that returns a non-zero exit status fails and causes
   * the task to fail. However, you can set this field to `true` to allow the
   * task to continue executing its other runnables even if this runnable
   * fails.
   * </pre>
   *
   * <code>bool ignore_exit_status = 3;</code>
   *
   * @return The ignoreExitStatus.
   */
  @java.lang.Override
  public boolean getIgnoreExitStatus() {
    return ignoreExitStatus_;
  }

  public static final int BACKGROUND_FIELD_NUMBER = 4;
  private boolean background_ = false;

  /**
   *
   *
   * <pre>
   * Normally, a runnable that doesn't exit causes its task to fail. However,
   * you can set this field to `true` to configure a background runnable.
   * Background runnables are allowed continue running in the background while
   * the task executes subsequent runnables. For example, background runnables
   * are useful for providing services to other runnables or providing
   * debugging-support tools like SSH servers.
   *
   * Specifically, background runnables are killed automatically (if they have
   * not already exited) a short time after all foreground runnables have
   * completed. Even though this is likely to result in a non-zero exit status
   * for the background runnable, these automatic kills are not treated as task
   * failures.
   * </pre>
   *
   * <code>bool background = 4;</code>
   *
   * @return The background.
   */
  @java.lang.Override
  public boolean getBackground() {
    return background_;
  }

  public static final int ALWAYS_RUN_FIELD_NUMBER = 5;
  private boolean alwaysRun_ = false;

  /**
   *
   *
   * <pre>
   * By default, after a Runnable fails, no further Runnable are executed. This
   * flag indicates that this Runnable must be run even if the Task has already
   * failed. This is useful for Runnables that copy output files off of the VM
   * or for debugging.
   *
   * The always_run flag does not override the Task's overall max_run_duration.
   * If the max_run_duration has expired then no further Runnables will execute,
   * not even always_run Runnables.
   * </pre>
   *
   * <code>bool always_run = 5;</code>
   *
   * @return The alwaysRun.
   */
  @java.lang.Override
  public boolean getAlwaysRun() {
    return alwaysRun_;
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 7;
  private com.google.cloud.batch.v1alpha.Environment environment_;

  /**
   *
   *
   * <pre>
   * Environment variables for this Runnable (overrides variables set for the
   * whole Task or TaskGroup).
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
   *
   * @return Whether the environment field is set.
   */
  @java.lang.Override
  public boolean hasEnvironment() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Environment variables for this Runnable (overrides variables set for the
   * whole Task or TaskGroup).
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Environment getEnvironment() {
    return environment_ == null
        ? com.google.cloud.batch.v1alpha.Environment.getDefaultInstance()
        : environment_;
  }

  /**
   *
   *
   * <pre>
   * Environment variables for this Runnable (overrides variables set for the
   * whole Task or TaskGroup).
   * </pre>
   *
   * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.batch.v1alpha.EnvironmentOrBuilder getEnvironmentOrBuilder() {
    return environment_ == null
        ? com.google.cloud.batch.v1alpha.Environment.getDefaultInstance()
        : environment_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration timeout_;

  /**
   *
   *
   * <pre>
   * Timeout for this Runnable.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Timeout for this Runnable.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  /**
   *
   *
   * <pre>
   * Timeout for this Runnable.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.batch.v1alpha.TaskProto
                .internal_static_google_cloud_batch_v1alpha_Runnable_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Labels for this Runnable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this Runnable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Labels for this Runnable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Labels for this Runnable.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (executableCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.batch.v1alpha.Runnable.Container) executable_);
    }
    if (executableCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.batch.v1alpha.Runnable.Script) executable_);
    }
    if (ignoreExitStatus_ != false) {
      output.writeBool(3, ignoreExitStatus_);
    }
    if (background_ != false) {
      output.writeBool(4, background_);
    }
    if (alwaysRun_ != false) {
      output.writeBool(5, alwaysRun_);
    }
    if (executableCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getEnvironment());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getTimeout());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (executableCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.batch.v1alpha.Runnable.Container) executable_);
    }
    if (executableCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.batch.v1alpha.Runnable.Script) executable_);
    }
    if (ignoreExitStatus_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, ignoreExitStatus_);
    }
    if (background_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, background_);
    }
    if (alwaysRun_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, alwaysRun_);
    }
    if (executableCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEnvironment());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTimeout());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.batch.v1alpha.Runnable)) {
      return super.equals(obj);
    }
    com.google.cloud.batch.v1alpha.Runnable other = (com.google.cloud.batch.v1alpha.Runnable) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getIgnoreExitStatus() != other.getIgnoreExitStatus()) return false;
    if (getBackground() != other.getBackground()) return false;
    if (getAlwaysRun() != other.getAlwaysRun()) return false;
    if (hasEnvironment() != other.hasEnvironment()) return false;
    if (hasEnvironment()) {
      if (!getEnvironment().equals(other.getEnvironment())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getExecutableCase().equals(other.getExecutableCase())) return false;
    switch (executableCase_) {
      case 1:
        if (!getContainer().equals(other.getContainer())) return false;
        break;
      case 2:
        if (!getScript().equals(other.getScript())) return false;
        break;
      case 6:
        if (!getBarrier().equals(other.getBarrier())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + IGNORE_EXIT_STATUS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreExitStatus());
    hash = (37 * hash) + BACKGROUND_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBackground());
    hash = (37 * hash) + ALWAYS_RUN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAlwaysRun());
    if (hasEnvironment()) {
      hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironment().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    switch (executableCase_) {
      case 1:
        hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
        hash = (53 * hash) + getContainer().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SCRIPT_FIELD_NUMBER;
        hash = (53 * hash) + getScript().hashCode();
        break;
      case 6:
        hash = (37 * hash) + BARRIER_FIELD_NUMBER;
        hash = (53 * hash) + getBarrier().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.batch.v1alpha.Runnable parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.batch.v1alpha.Runnable prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Runnable describes instructions for executing a specific script or container
   * as part of a Task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.batch.v1alpha.Runnable}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.batch.v1alpha.Runnable)
      com.google.cloud.batch.v1alpha.RunnableOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.batch.v1alpha.Runnable.class,
              com.google.cloud.batch.v1alpha.Runnable.Builder.class);
    }

    // Construct using com.google.cloud.batch.v1alpha.Runnable.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEnvironmentFieldBuilder();
        getTimeoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (containerBuilder_ != null) {
        containerBuilder_.clear();
      }
      if (scriptBuilder_ != null) {
        scriptBuilder_.clear();
      }
      if (barrierBuilder_ != null) {
        barrierBuilder_.clear();
      }
      displayName_ = "";
      ignoreExitStatus_ = false;
      background_ = false;
      alwaysRun_ = false;
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      executableCase_ = 0;
      executable_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.batch.v1alpha.TaskProto
          .internal_static_google_cloud_batch_v1alpha_Runnable_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable getDefaultInstanceForType() {
      return com.google.cloud.batch.v1alpha.Runnable.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable build() {
      com.google.cloud.batch.v1alpha.Runnable result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable buildPartial() {
      com.google.cloud.batch.v1alpha.Runnable result =
          new com.google.cloud.batch.v1alpha.Runnable(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.batch.v1alpha.Runnable result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ignoreExitStatus_ = ignoreExitStatus_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.background_ = background_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.alwaysRun_ = alwaysRun_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.environment_ =
            environmentBuilder_ == null ? environment_ : environmentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.batch.v1alpha.Runnable result) {
      result.executableCase_ = executableCase_;
      result.executable_ = this.executable_;
      if (executableCase_ == 1 && containerBuilder_ != null) {
        result.executable_ = containerBuilder_.build();
      }
      if (executableCase_ == 2 && scriptBuilder_ != null) {
        result.executable_ = scriptBuilder_.build();
      }
      if (executableCase_ == 6 && barrierBuilder_ != null) {
        result.executable_ = barrierBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.batch.v1alpha.Runnable) {
        return mergeFrom((com.google.cloud.batch.v1alpha.Runnable) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.batch.v1alpha.Runnable other) {
      if (other == com.google.cloud.batch.v1alpha.Runnable.getDefaultInstance()) return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getIgnoreExitStatus() != false) {
        setIgnoreExitStatus(other.getIgnoreExitStatus());
      }
      if (other.getBackground() != false) {
        setBackground(other.getBackground());
      }
      if (other.getAlwaysRun() != false) {
        setAlwaysRun(other.getAlwaysRun());
      }
      if (other.hasEnvironment()) {
        mergeEnvironment(other.getEnvironment());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000200;
      switch (other.getExecutableCase()) {
        case CONTAINER:
          {
            mergeContainer(other.getContainer());
            break;
          }
        case SCRIPT:
          {
            mergeScript(other.getScript());
            break;
          }
        case BARRIER:
          {
            mergeBarrier(other.getBarrier());
            break;
          }
        case EXECUTABLE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getContainerFieldBuilder().getBuilder(), extensionRegistry);
                executableCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getScriptFieldBuilder().getBuilder(), extensionRegistry);
                executableCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                ignoreExitStatus_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 24
            case 32:
              {
                background_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 40:
              {
                alwaysRun_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getBarrierFieldBuilder().getBuilder(), extensionRegistry);
                executableCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getEnvironmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int executableCase_ = 0;
    private java.lang.Object executable_;

    public ExecutableCase getExecutableCase() {
      return ExecutableCase.forNumber(executableCase_);
    }

    public Builder clearExecutable() {
      executableCase_ = 0;
      executable_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Container,
            com.google.cloud.batch.v1alpha.Runnable.Container.Builder,
            com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder>
        containerBuilder_;

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     *
     * @return Whether the container field is set.
     */
    @java.lang.Override
    public boolean hasContainer() {
      return executableCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     *
     * @return The container.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Container getContainer() {
      if (containerBuilder_ == null) {
        if (executableCase_ == 1) {
          return (com.google.cloud.batch.v1alpha.Runnable.Container) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
      } else {
        if (executableCase_ == 1) {
          return containerBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    public Builder setContainer(com.google.cloud.batch.v1alpha.Runnable.Container value) {
      if (containerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executable_ = value;
        onChanged();
      } else {
        containerBuilder_.setMessage(value);
      }
      executableCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    public Builder setContainer(
        com.google.cloud.batch.v1alpha.Runnable.Container.Builder builderForValue) {
      if (containerBuilder_ == null) {
        executable_ = builderForValue.build();
        onChanged();
      } else {
        containerBuilder_.setMessage(builderForValue.build());
      }
      executableCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    public Builder mergeContainer(com.google.cloud.batch.v1alpha.Runnable.Container value) {
      if (containerBuilder_ == null) {
        if (executableCase_ == 1
            && executable_
                != com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance()) {
          executable_ =
              com.google.cloud.batch.v1alpha.Runnable.Container.newBuilder(
                      (com.google.cloud.batch.v1alpha.Runnable.Container) executable_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          executable_ = value;
        }
        onChanged();
      } else {
        if (executableCase_ == 1) {
          containerBuilder_.mergeFrom(value);
        } else {
          containerBuilder_.setMessage(value);
        }
      }
      executableCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    public Builder clearContainer() {
      if (containerBuilder_ == null) {
        if (executableCase_ == 1) {
          executableCase_ = 0;
          executable_ = null;
          onChanged();
        }
      } else {
        if (executableCase_ == 1) {
          executableCase_ = 0;
          executable_ = null;
        }
        containerBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    public com.google.cloud.batch.v1alpha.Runnable.Container.Builder getContainerBuilder() {
      return getContainerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder getContainerOrBuilder() {
      if ((executableCase_ == 1) && (containerBuilder_ != null)) {
        return containerBuilder_.getMessageOrBuilder();
      } else {
        if (executableCase_ == 1) {
          return (com.google.cloud.batch.v1alpha.Runnable.Container) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Container runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Container container = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Container,
            com.google.cloud.batch.v1alpha.Runnable.Container.Builder,
            com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder>
        getContainerFieldBuilder() {
      if (containerBuilder_ == null) {
        if (!(executableCase_ == 1)) {
          executable_ = com.google.cloud.batch.v1alpha.Runnable.Container.getDefaultInstance();
        }
        containerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.Runnable.Container,
                com.google.cloud.batch.v1alpha.Runnable.Container.Builder,
                com.google.cloud.batch.v1alpha.Runnable.ContainerOrBuilder>(
                (com.google.cloud.batch.v1alpha.Runnable.Container) executable_,
                getParentForChildren(),
                isClean());
        executable_ = null;
      }
      executableCase_ = 1;
      onChanged();
      return containerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Script,
            com.google.cloud.batch.v1alpha.Runnable.Script.Builder,
            com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder>
        scriptBuilder_;

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     *
     * @return Whether the script field is set.
     */
    @java.lang.Override
    public boolean hasScript() {
      return executableCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     *
     * @return The script.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Script getScript() {
      if (scriptBuilder_ == null) {
        if (executableCase_ == 2) {
          return (com.google.cloud.batch.v1alpha.Runnable.Script) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
      } else {
        if (executableCase_ == 2) {
          return scriptBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    public Builder setScript(com.google.cloud.batch.v1alpha.Runnable.Script value) {
      if (scriptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executable_ = value;
        onChanged();
      } else {
        scriptBuilder_.setMessage(value);
      }
      executableCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    public Builder setScript(
        com.google.cloud.batch.v1alpha.Runnable.Script.Builder builderForValue) {
      if (scriptBuilder_ == null) {
        executable_ = builderForValue.build();
        onChanged();
      } else {
        scriptBuilder_.setMessage(builderForValue.build());
      }
      executableCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    public Builder mergeScript(com.google.cloud.batch.v1alpha.Runnable.Script value) {
      if (scriptBuilder_ == null) {
        if (executableCase_ == 2
            && executable_ != com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance()) {
          executable_ =
              com.google.cloud.batch.v1alpha.Runnable.Script.newBuilder(
                      (com.google.cloud.batch.v1alpha.Runnable.Script) executable_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          executable_ = value;
        }
        onChanged();
      } else {
        if (executableCase_ == 2) {
          scriptBuilder_.mergeFrom(value);
        } else {
          scriptBuilder_.setMessage(value);
        }
      }
      executableCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    public Builder clearScript() {
      if (scriptBuilder_ == null) {
        if (executableCase_ == 2) {
          executableCase_ = 0;
          executable_ = null;
          onChanged();
        }
      } else {
        if (executableCase_ == 2) {
          executableCase_ = 0;
          executable_ = null;
        }
        scriptBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    public com.google.cloud.batch.v1alpha.Runnable.Script.Builder getScriptBuilder() {
      return getScriptFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder getScriptOrBuilder() {
      if ((executableCase_ == 2) && (scriptBuilder_ != null)) {
        return scriptBuilder_.getMessageOrBuilder();
      } else {
        if (executableCase_ == 2) {
          return (com.google.cloud.batch.v1alpha.Runnable.Script) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Script runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Script script = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Script,
            com.google.cloud.batch.v1alpha.Runnable.Script.Builder,
            com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder>
        getScriptFieldBuilder() {
      if (scriptBuilder_ == null) {
        if (!(executableCase_ == 2)) {
          executable_ = com.google.cloud.batch.v1alpha.Runnable.Script.getDefaultInstance();
        }
        scriptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.Runnable.Script,
                com.google.cloud.batch.v1alpha.Runnable.Script.Builder,
                com.google.cloud.batch.v1alpha.Runnable.ScriptOrBuilder>(
                (com.google.cloud.batch.v1alpha.Runnable.Script) executable_,
                getParentForChildren(),
                isClean());
        executable_ = null;
      }
      executableCase_ = 2;
      onChanged();
      return scriptBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Barrier,
            com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder,
            com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder>
        barrierBuilder_;

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     *
     * @return Whether the barrier field is set.
     */
    @java.lang.Override
    public boolean hasBarrier() {
      return executableCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     *
     * @return The barrier.
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.Barrier getBarrier() {
      if (barrierBuilder_ == null) {
        if (executableCase_ == 6) {
          return (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
      } else {
        if (executableCase_ == 6) {
          return barrierBuilder_.getMessage();
        }
        return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    public Builder setBarrier(com.google.cloud.batch.v1alpha.Runnable.Barrier value) {
      if (barrierBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        executable_ = value;
        onChanged();
      } else {
        barrierBuilder_.setMessage(value);
      }
      executableCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    public Builder setBarrier(
        com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder builderForValue) {
      if (barrierBuilder_ == null) {
        executable_ = builderForValue.build();
        onChanged();
      } else {
        barrierBuilder_.setMessage(builderForValue.build());
      }
      executableCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    public Builder mergeBarrier(com.google.cloud.batch.v1alpha.Runnable.Barrier value) {
      if (barrierBuilder_ == null) {
        if (executableCase_ == 6
            && executable_
                != com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance()) {
          executable_ =
              com.google.cloud.batch.v1alpha.Runnable.Barrier.newBuilder(
                      (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          executable_ = value;
        }
        onChanged();
      } else {
        if (executableCase_ == 6) {
          barrierBuilder_.mergeFrom(value);
        } else {
          barrierBuilder_.setMessage(value);
        }
      }
      executableCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    public Builder clearBarrier() {
      if (barrierBuilder_ == null) {
        if (executableCase_ == 6) {
          executableCase_ = 0;
          executable_ = null;
          onChanged();
        }
      } else {
        if (executableCase_ == 6) {
          executableCase_ = 0;
          executable_ = null;
        }
        barrierBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    public com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder getBarrierBuilder() {
      return getBarrierFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder getBarrierOrBuilder() {
      if ((executableCase_ == 6) && (barrierBuilder_ != null)) {
        return barrierBuilder_.getMessageOrBuilder();
      } else {
        if (executableCase_ == 6) {
          return (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_;
        }
        return com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Barrier runnable.
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Runnable.Barrier barrier = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Runnable.Barrier,
            com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder,
            com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder>
        getBarrierFieldBuilder() {
      if (barrierBuilder_ == null) {
        if (!(executableCase_ == 6)) {
          executable_ = com.google.cloud.batch.v1alpha.Runnable.Barrier.getDefaultInstance();
        }
        barrierBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.Runnable.Barrier,
                com.google.cloud.batch.v1alpha.Runnable.Barrier.Builder,
                com.google.cloud.batch.v1alpha.Runnable.BarrierOrBuilder>(
                (com.google.cloud.batch.v1alpha.Runnable.Barrier) executable_,
                getParentForChildren(),
                isClean());
        executable_ = null;
      }
      executableCase_ = 6;
      onChanged();
      return barrierBuilder_;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. DisplayName is an optional field that can be provided by the
     * caller. If provided, it will be used in logs and other outputs to identify
     * the script, making it easier for users to understand the logs. If not
     * provided the index of the runnable will be used for outputs.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DisplayName is an optional field that can be provided by the
     * caller. If provided, it will be used in logs and other outputs to identify
     * the script, making it easier for users to understand the logs. If not
     * provided the index of the runnable will be used for outputs.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. DisplayName is an optional field that can be provided by the
     * caller. If provided, it will be used in logs and other outputs to identify
     * the script, making it easier for users to understand the logs. If not
     * provided the index of the runnable will be used for outputs.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DisplayName is an optional field that can be provided by the
     * caller. If provided, it will be used in logs and other outputs to identify
     * the script, making it easier for users to understand the logs. If not
     * provided the index of the runnable will be used for outputs.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. DisplayName is an optional field that can be provided by the
     * caller. If provided, it will be used in logs and other outputs to identify
     * the script, making it easier for users to understand the logs. If not
     * provided the index of the runnable will be used for outputs.
     * </pre>
     *
     * <code>string display_name = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean ignoreExitStatus_;

    /**
     *
     *
     * <pre>
     * Normally, a runnable that returns a non-zero exit status fails and causes
     * the task to fail. However, you can set this field to `true` to allow the
     * task to continue executing its other runnables even if this runnable
     * fails.
     * </pre>
     *
     * <code>bool ignore_exit_status = 3;</code>
     *
     * @return The ignoreExitStatus.
     */
    @java.lang.Override
    public boolean getIgnoreExitStatus() {
      return ignoreExitStatus_;
    }

    /**
     *
     *
     * <pre>
     * Normally, a runnable that returns a non-zero exit status fails and causes
     * the task to fail. However, you can set this field to `true` to allow the
     * task to continue executing its other runnables even if this runnable
     * fails.
     * </pre>
     *
     * <code>bool ignore_exit_status = 3;</code>
     *
     * @param value The ignoreExitStatus to set.
     * @return This builder for chaining.
     */
    public Builder setIgnoreExitStatus(boolean value) {

      ignoreExitStatus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Normally, a runnable that returns a non-zero exit status fails and causes
     * the task to fail. However, you can set this field to `true` to allow the
     * task to continue executing its other runnables even if this runnable
     * fails.
     * </pre>
     *
     * <code>bool ignore_exit_status = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIgnoreExitStatus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ignoreExitStatus_ = false;
      onChanged();
      return this;
    }

    private boolean background_;

    /**
     *
     *
     * <pre>
     * Normally, a runnable that doesn't exit causes its task to fail. However,
     * you can set this field to `true` to configure a background runnable.
     * Background runnables are allowed continue running in the background while
     * the task executes subsequent runnables. For example, background runnables
     * are useful for providing services to other runnables or providing
     * debugging-support tools like SSH servers.
     *
     * Specifically, background runnables are killed automatically (if they have
     * not already exited) a short time after all foreground runnables have
     * completed. Even though this is likely to result in a non-zero exit status
     * for the background runnable, these automatic kills are not treated as task
     * failures.
     * </pre>
     *
     * <code>bool background = 4;</code>
     *
     * @return The background.
     */
    @java.lang.Override
    public boolean getBackground() {
      return background_;
    }

    /**
     *
     *
     * <pre>
     * Normally, a runnable that doesn't exit causes its task to fail. However,
     * you can set this field to `true` to configure a background runnable.
     * Background runnables are allowed continue running in the background while
     * the task executes subsequent runnables. For example, background runnables
     * are useful for providing services to other runnables or providing
     * debugging-support tools like SSH servers.
     *
     * Specifically, background runnables are killed automatically (if they have
     * not already exited) a short time after all foreground runnables have
     * completed. Even though this is likely to result in a non-zero exit status
     * for the background runnable, these automatic kills are not treated as task
     * failures.
     * </pre>
     *
     * <code>bool background = 4;</code>
     *
     * @param value The background to set.
     * @return This builder for chaining.
     */
    public Builder setBackground(boolean value) {

      background_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Normally, a runnable that doesn't exit causes its task to fail. However,
     * you can set this field to `true` to configure a background runnable.
     * Background runnables are allowed continue running in the background while
     * the task executes subsequent runnables. For example, background runnables
     * are useful for providing services to other runnables or providing
     * debugging-support tools like SSH servers.
     *
     * Specifically, background runnables are killed automatically (if they have
     * not already exited) a short time after all foreground runnables have
     * completed. Even though this is likely to result in a non-zero exit status
     * for the background runnable, these automatic kills are not treated as task
     * failures.
     * </pre>
     *
     * <code>bool background = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackground() {
      bitField0_ = (bitField0_ & ~0x00000020);
      background_ = false;
      onChanged();
      return this;
    }

    private boolean alwaysRun_;

    /**
     *
     *
     * <pre>
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     *
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     * </pre>
     *
     * <code>bool always_run = 5;</code>
     *
     * @return The alwaysRun.
     */
    @java.lang.Override
    public boolean getAlwaysRun() {
      return alwaysRun_;
    }

    /**
     *
     *
     * <pre>
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     *
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     * </pre>
     *
     * <code>bool always_run = 5;</code>
     *
     * @param value The alwaysRun to set.
     * @return This builder for chaining.
     */
    public Builder setAlwaysRun(boolean value) {

      alwaysRun_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * By default, after a Runnable fails, no further Runnable are executed. This
     * flag indicates that this Runnable must be run even if the Task has already
     * failed. This is useful for Runnables that copy output files off of the VM
     * or for debugging.
     *
     * The always_run flag does not override the Task's overall max_run_duration.
     * If the max_run_duration has expired then no further Runnables will execute,
     * not even always_run Runnables.
     * </pre>
     *
     * <code>bool always_run = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlwaysRun() {
      bitField0_ = (bitField0_ & ~0x00000040);
      alwaysRun_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.batch.v1alpha.Environment environment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Environment,
            com.google.cloud.batch.v1alpha.Environment.Builder,
            com.google.cloud.batch.v1alpha.EnvironmentOrBuilder>
        environmentBuilder_;

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     *
     * @return Whether the environment field is set.
     */
    public boolean hasEnvironment() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     *
     * @return The environment.
     */
    public com.google.cloud.batch.v1alpha.Environment getEnvironment() {
      if (environmentBuilder_ == null) {
        return environment_ == null
            ? com.google.cloud.batch.v1alpha.Environment.getDefaultInstance()
            : environment_;
      } else {
        return environmentBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public Builder setEnvironment(com.google.cloud.batch.v1alpha.Environment value) {
      if (environmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environment_ = value;
      } else {
        environmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public Builder setEnvironment(
        com.google.cloud.batch.v1alpha.Environment.Builder builderForValue) {
      if (environmentBuilder_ == null) {
        environment_ = builderForValue.build();
      } else {
        environmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public Builder mergeEnvironment(com.google.cloud.batch.v1alpha.Environment value) {
      if (environmentBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && environment_ != null
            && environment_ != com.google.cloud.batch.v1alpha.Environment.getDefaultInstance()) {
          getEnvironmentBuilder().mergeFrom(value);
        } else {
          environment_ = value;
        }
      } else {
        environmentBuilder_.mergeFrom(value);
      }
      if (environment_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public Builder clearEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000080);
      environment_ = null;
      if (environmentBuilder_ != null) {
        environmentBuilder_.dispose();
        environmentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public com.google.cloud.batch.v1alpha.Environment.Builder getEnvironmentBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEnvironmentFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    public com.google.cloud.batch.v1alpha.EnvironmentOrBuilder getEnvironmentOrBuilder() {
      if (environmentBuilder_ != null) {
        return environmentBuilder_.getMessageOrBuilder();
      } else {
        return environment_ == null
            ? com.google.cloud.batch.v1alpha.Environment.getDefaultInstance()
            : environment_;
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables for this Runnable (overrides variables set for the
     * whole Task or TaskGroup).
     * </pre>
     *
     * <code>.google.cloud.batch.v1alpha.Environment environment = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.batch.v1alpha.Environment,
            com.google.cloud.batch.v1alpha.Environment.Builder,
            com.google.cloud.batch.v1alpha.EnvironmentOrBuilder>
        getEnvironmentFieldBuilder() {
      if (environmentBuilder_ == null) {
        environmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.batch.v1alpha.Environment,
                com.google.cloud.batch.v1alpha.Environment.Builder,
                com.google.cloud.batch.v1alpha.EnvironmentOrBuilder>(
                getEnvironment(), getParentForChildren(), isClean());
        environment_ = null;
      }
      return environmentBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000100);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * Timeout for this Runnable.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000200;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Labels for this Runnable.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.batch.v1alpha.Runnable)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.batch.v1alpha.Runnable)
  private static final com.google.cloud.batch.v1alpha.Runnable DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.batch.v1alpha.Runnable();
  }

  public static com.google.cloud.batch.v1alpha.Runnable getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Runnable> PARSER =
      new com.google.protobuf.AbstractParser<Runnable>() {
        @java.lang.Override
        public Runnable parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Runnable> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Runnable> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.batch.v1alpha.Runnable getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
