/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LockName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_DATABASE_LOCK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/databases/{database}/locks/{lock}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String database;
    private final String lock;

    @Deprecated
    protected LockName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.database = null;
        this.lock = null;
    }

    private LockName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
        this.lock = (String)Preconditions.checkNotNull((Object)builder.getLock());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getLock() {
        return this.lock;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LockName of(String project, String location, String catalog, String database, String lock) {
        return LockName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).setLock(lock).build();
    }

    public static String format(String project, String location, String catalog, String database, String lock) {
        return LockName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).setLock(lock).build().toString();
    }

    public static LockName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_DATABASE_LOCK.validatedMatch(formattedString, "LockName.parse: formattedString not in valid format");
        return LockName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("database"), (String)matchMap.get("lock"));
    }

    public static List<LockName> parseList(List<String> formattedStrings) {
        ArrayList<LockName> list = new ArrayList<LockName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LockName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LockName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LockName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_DATABASE_LOCK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LockName lockName = this;
            synchronized (lockName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    if (this.lock != null) {
                        fieldMapBuilder.put((Object)"lock", (Object)this.lock);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_DATABASE_LOCK.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "database", this.database, "lock", this.lock});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LockName that = (LockName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.database, that.database) && Objects.equals(this.lock, that.lock);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        h ^= Objects.hashCode(this.database);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lock);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String database;
        private String lock;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getLock() {
            return this.lock;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setLock(String lock) {
            this.lock = lock;
            return this;
        }

        private Builder(LockName lockName) {
            this.project = lockName.project;
            this.location = lockName.location;
            this.catalog = lockName.catalog;
            this.database = lockName.database;
            this.lock = lockName.lock;
        }

        public LockName build() {
            return new LockName(this);
        }
    }
}

