/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SkuGroupName
implements ResourceName {
    private static final PathTemplate ACCOUNT_SKU_GROUP = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/skuGroups/{sku_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String skuGroup;

    @Deprecated
    protected SkuGroupName() {
        this.account = null;
        this.skuGroup = null;
    }

    private SkuGroupName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.skuGroup = (String)Preconditions.checkNotNull((Object)builder.getSkuGroup());
    }

    public String getAccount() {
        return this.account;
    }

    public String getSkuGroup() {
        return this.skuGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SkuGroupName of(String account, String skuGroup) {
        return SkuGroupName.newBuilder().setAccount(account).setSkuGroup(skuGroup).build();
    }

    public static String format(String account, String skuGroup) {
        return SkuGroupName.newBuilder().setAccount(account).setSkuGroup(skuGroup).build().toString();
    }

    public static SkuGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_SKU_GROUP.validatedMatch(formattedString, "SkuGroupName.parse: formattedString not in valid format");
        return SkuGroupName.of((String)matchMap.get("account"), (String)matchMap.get("sku_group"));
    }

    public static List<SkuGroupName> parseList(List<String> formattedStrings) {
        ArrayList<SkuGroupName> list = new ArrayList<SkuGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SkuGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SkuGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SkuGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_SKU_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SkuGroupName skuGroupName = this;
            synchronized (skuGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.skuGroup != null) {
                        fieldMapBuilder.put((Object)"sku_group", (Object)this.skuGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_SKU_GROUP.instantiate(new String[]{"account", this.account, "sku_group", this.skuGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SkuGroupName that = (SkuGroupName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.skuGroup, that.skuGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        return h ^= Objects.hashCode(this.skuGroup);
    }

    public static class Builder {
        private String account;
        private String skuGroup;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getSkuGroup() {
            return this.skuGroup;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setSkuGroup(String skuGroup) {
            this.skuGroup = skuGroup;
            return this;
        }

        private Builder(SkuGroupName skuGroupName) {
            this.account = skuGroupName.account;
            this.skuGroup = skuGroupName.skuGroup;
        }

        public SkuGroupName build() {
            return new SkuGroupName(this);
        }
    }
}

