/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataScanJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASCAN_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataScans/{dataScan}/jobs/{job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataScan;
    private final String job;

    @Deprecated
    protected DataScanJobName() {
        this.project = null;
        this.location = null;
        this.dataScan = null;
        this.job = null;
    }

    private DataScanJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataScan = (String)Preconditions.checkNotNull((Object)builder.getDataScan());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataScan() {
        return this.dataScan;
    }

    public String getJob() {
        return this.job;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataScanJobName of(String project, String location, String dataScan, String job) {
        return DataScanJobName.newBuilder().setProject(project).setLocation(location).setDataScan(dataScan).setJob(job).build();
    }

    public static String format(String project, String location, String dataScan, String job) {
        return DataScanJobName.newBuilder().setProject(project).setLocation(location).setDataScan(dataScan).setJob(job).build().toString();
    }

    public static DataScanJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASCAN_JOB.validatedMatch(formattedString, "DataScanJobName.parse: formattedString not in valid format");
        return DataScanJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataScan"), (String)matchMap.get("job"));
    }

    public static List<DataScanJobName> parseList(List<String> formattedStrings) {
        ArrayList<DataScanJobName> list = new ArrayList<DataScanJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataScanJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataScanJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataScanJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASCAN_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataScanJobName dataScanJobName = this;
            synchronized (dataScanJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataScan != null) {
                        fieldMapBuilder.put((Object)"dataScan", (Object)this.dataScan);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASCAN_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "dataScan", this.dataScan, "job", this.job});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataScanJobName that = (DataScanJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataScan, that.dataScan) && Objects.equals(this.job, that.job);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataScan);
        h *= 1000003;
        return h ^= Objects.hashCode(this.job);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataScan;
        private String job;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataScan() {
            return this.dataScan;
        }

        public String getJob() {
            return this.job;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataScan(String dataScan) {
            this.dataScan = dataScan;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        private Builder(DataScanJobName dataScanJobName) {
            this.project = dataScanJobName.project;
            this.location = dataScanJobName.location;
            this.dataScan = dataScanJobName.dataScan;
            this.job = dataScanJobName.job;
        }

        public DataScanJobName build() {
            return new DataScanJobName(this);
        }
    }
}

