/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/document_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [DocumentService.GetDocument][google.cloud.discoveryengine.v1alpha.DocumentService.GetDocument]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest}
 */
public final class GetProcessedDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest)
    GetProcessedDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GetProcessedDocumentRequest.newBuilder() to construct.
  private GetProcessedDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetProcessedDocumentRequest() {
    name_ = "";
    processedDocumentType_ = 0;
    processedDocumentFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetProcessedDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_GetProcessedDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
        .internal_static_google_cloud_discoveryengine_v1alpha_GetProcessedDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.class,
            com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of processing to return in the response.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType}
   */
  public enum ProcessedDocumentType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>PROCESSED_DOCUMENT_TYPE_UNSPECIFIED = 0;</code>
     */
    PROCESSED_DOCUMENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Available for all data store parsing configs.
     * </pre>
     *
     * <code>PARSED_DOCUMENT = 1;</code>
     */
    PARSED_DOCUMENT(1),
    /**
     *
     *
     * <pre>
     * Only available if ChunkingConfig is enabled on the data store.
     * </pre>
     *
     * <code>CHUNKED_DOCUMENT = 2;</code>
     */
    CHUNKED_DOCUMENT(2),
    /**
     *
     *
     * <pre>
     * Returns the converted Image bytes (as JPEG or PNG) if available.
     * </pre>
     *
     * <code>PNG_CONVERTED_DOCUMENT = 3;</code>
     */
    PNG_CONVERTED_DOCUMENT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>PROCESSED_DOCUMENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int PROCESSED_DOCUMENT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Available for all data store parsing configs.
     * </pre>
     *
     * <code>PARSED_DOCUMENT = 1;</code>
     */
    public static final int PARSED_DOCUMENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only available if ChunkingConfig is enabled on the data store.
     * </pre>
     *
     * <code>CHUNKED_DOCUMENT = 2;</code>
     */
    public static final int CHUNKED_DOCUMENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Returns the converted Image bytes (as JPEG or PNG) if available.
     * </pre>
     *
     * <code>PNG_CONVERTED_DOCUMENT = 3;</code>
     */
    public static final int PNG_CONVERTED_DOCUMENT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProcessedDocumentType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProcessedDocumentType forNumber(int value) {
      switch (value) {
        case 0:
          return PROCESSED_DOCUMENT_TYPE_UNSPECIFIED;
        case 1:
          return PARSED_DOCUMENT;
        case 2:
          return CHUNKED_DOCUMENT;
        case 3:
          return PNG_CONVERTED_DOCUMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentType>() {
              public ProcessedDocumentType findValueByNumber(int number) {
                return ProcessedDocumentType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ProcessedDocumentType[] VALUES = values();

    public static ProcessedDocumentType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProcessedDocumentType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType)
  }

  /**
   *
   *
   * <pre>
   * The format of the returned processed document. If unspecified, defaults to
   * JSON.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat}
   */
  public enum ProcessedDocumentFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED = 0;</code>
     */
    PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Output format is a JSON string representation of processed document.
     * </pre>
     *
     * <code>JSON = 1;</code>
     */
    JSON(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Output format is a JSON string representation of processed document.
     * </pre>
     *
     * <code>JSON = 1;</code>
     */
    public static final int JSON_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProcessedDocumentFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProcessedDocumentFormat forNumber(int value) {
      switch (value) {
        case 0:
          return PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED;
        case 1:
          return JSON;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentFormat>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentFormat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProcessedDocumentFormat>() {
              public ProcessedDocumentFormat findValueByNumber(int number) {
                return ProcessedDocumentFormat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ProcessedDocumentFormat[] VALUES = values();

    public static ProcessedDocumentFormat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProcessedDocumentFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Full resource name of
   * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
   *
   * If the caller does not have permission to access the
   * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
   * whether or not it exists, a `PERMISSION_DENIED` error is returned.
   *
   * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
   * does not exist, a `NOT_FOUND` error is returned.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Full resource name of
   * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
   *
   * If the caller does not have permission to access the
   * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
   * whether or not it exists, a `PERMISSION_DENIED` error is returned.
   *
   * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
   * does not exist, a `NOT_FOUND` error is returned.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROCESSED_DOCUMENT_TYPE_FIELD_NUMBER = 2;
  private int processedDocumentType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. What type of processing to return.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for processedDocumentType.
   */
  @java.lang.Override
  public int getProcessedDocumentTypeValue() {
    return processedDocumentType_;
  }
  /**
   *
   *
   * <pre>
   * Required. What type of processing to return.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The processedDocumentType.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType
      getProcessedDocumentType() {
    com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType
        result =
            com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
                .ProcessedDocumentType.forNumber(processedDocumentType_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType
            .UNRECOGNIZED
        : result;
  }

  public static final int PROCESSED_DOCUMENT_FORMAT_FIELD_NUMBER = 3;
  private int processedDocumentFormat_ = 0;
  /**
   *
   *
   * <pre>
   * What format output should be.  If unspecified, defaults to JSON.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for processedDocumentFormat.
   */
  @java.lang.Override
  public int getProcessedDocumentFormatValue() {
    return processedDocumentFormat_;
  }
  /**
   *
   *
   * <pre>
   * What format output should be.  If unspecified, defaults to JSON.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
   * </code>
   *
   * @return The processedDocumentFormat.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
          .ProcessedDocumentFormat
      getProcessedDocumentFormat() {
    com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat
        result =
            com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
                .ProcessedDocumentFormat.forNumber(processedDocumentFormat_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentFormat.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (processedDocumentType_
        != com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentType.PROCESSED_DOCUMENT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, processedDocumentType_);
    }
    if (processedDocumentFormat_
        != com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentFormat.PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, processedDocumentFormat_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (processedDocumentType_
        != com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentType.PROCESSED_DOCUMENT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, processedDocumentType_);
    }
    if (processedDocumentFormat_
        != com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentFormat.PROCESSED_DOCUMENT_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, processedDocumentFormat_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest other =
        (com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (processedDocumentType_ != other.processedDocumentType_) return false;
    if (processedDocumentFormat_ != other.processedDocumentFormat_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROCESSED_DOCUMENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + processedDocumentType_;
    hash = (37 * hash) + PROCESSED_DOCUMENT_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + processedDocumentFormat_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [DocumentService.GetDocument][google.cloud.discoveryengine.v1alpha.DocumentService.GetDocument]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest)
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_GetProcessedDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_GetProcessedDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.class,
              com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      processedDocumentType_ = 0;
      processedDocumentFormat_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.DocumentServiceProto
          .internal_static_google_cloud_discoveryengine_v1alpha_GetProcessedDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest build() {
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest result =
          new com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.processedDocumentType_ = processedDocumentType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.processedDocumentFormat_ = processedDocumentFormat_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
              .getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.processedDocumentType_ != 0) {
        setProcessedDocumentTypeValue(other.getProcessedDocumentTypeValue());
      }
      if (other.processedDocumentFormat_ != 0) {
        setProcessedDocumentFormatValue(other.getProcessedDocumentFormatValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                processedDocumentType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                processedDocumentFormat_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
     *
     * If the caller does not have permission to access the
     * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
     * whether or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
     * does not exist, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
     *
     * If the caller does not have permission to access the
     * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
     * whether or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
     * does not exist, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
     *
     * If the caller does not have permission to access the
     * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
     * whether or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
     * does not exist, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
     *
     * If the caller does not have permission to access the
     * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
     * whether or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
     * does not exist, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Full resource name of
     * [Document][google.cloud.discoveryengine.v1alpha.Document], such as
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/branches/{branch}/documents/{document}`.
     *
     * If the caller does not have permission to access the
     * [Document][google.cloud.discoveryengine.v1alpha.Document], regardless of
     * whether or not it exists, a `PERMISSION_DENIED` error is returned.
     *
     * If the requested [Document][google.cloud.discoveryengine.v1alpha.Document]
     * does not exist, a `NOT_FOUND` error is returned.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int processedDocumentType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. What type of processing to return.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for processedDocumentType.
     */
    @java.lang.Override
    public int getProcessedDocumentTypeValue() {
      return processedDocumentType_;
    }
    /**
     *
     *
     * <pre>
     * Required. What type of processing to return.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for processedDocumentType to set.
     * @return This builder for chaining.
     */
    public Builder setProcessedDocumentTypeValue(int value) {
      processedDocumentType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. What type of processing to return.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The processedDocumentType.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentType
        getProcessedDocumentType() {
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType
          result =
              com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
                  .ProcessedDocumentType.forNumber(processedDocumentType_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
              .ProcessedDocumentType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. What type of processing to return.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The processedDocumentType to set.
     * @return This builder for chaining.
     */
    public Builder setProcessedDocumentType(
        com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      processedDocumentType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. What type of processing to return.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentType processed_document_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessedDocumentType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      processedDocumentType_ = 0;
      onChanged();
      return this;
    }

    private int processedDocumentFormat_ = 0;
    /**
     *
     *
     * <pre>
     * What format output should be.  If unspecified, defaults to JSON.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for processedDocumentFormat.
     */
    @java.lang.Override
    public int getProcessedDocumentFormatValue() {
      return processedDocumentFormat_;
    }
    /**
     *
     *
     * <pre>
     * What format output should be.  If unspecified, defaults to JSON.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for processedDocumentFormat to set.
     * @return This builder for chaining.
     */
    public Builder setProcessedDocumentFormatValue(int value) {
      processedDocumentFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What format output should be.  If unspecified, defaults to JSON.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
     * </code>
     *
     * @return The processedDocumentFormat.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
            .ProcessedDocumentFormat
        getProcessedDocumentFormat() {
      com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat
          result =
              com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
                  .ProcessedDocumentFormat.forNumber(processedDocumentFormat_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
              .ProcessedDocumentFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * What format output should be.  If unspecified, defaults to JSON.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
     * </code>
     *
     * @param value The processedDocumentFormat to set.
     * @return This builder for chaining.
     */
    public Builder setProcessedDocumentFormat(
        com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      processedDocumentFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What format output should be.  If unspecified, defaults to JSON.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest.ProcessedDocumentFormat processed_document_format = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessedDocumentFormat() {
      bitField0_ = (bitField0_ & ~0x00000004);
      processedDocumentFormat_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetProcessedDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<GetProcessedDocumentRequest>() {
        @java.lang.Override
        public GetProcessedDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetProcessedDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetProcessedDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GetProcessedDocumentRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
