/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/import_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Request message for
 * [SampleQueryService.ImportSampleQueries][google.cloud.discoveryengine.v1alpha.SampleQueryService.ImportSampleQueries]
 * method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest}
 */
public final class ImportSampleQueriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest)
    ImportSampleQueriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportSampleQueriesRequest.newBuilder() to construct.
  private ImportSampleQueriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportSampleQueriesRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportSampleQueriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.class,
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.Builder.class);
  }

  public interface InlineSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery> getSampleQueriesList();
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.SampleQuery getSampleQueries(int index);
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getSampleQueriesCount();
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>
        getSampleQueriesOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder getSampleQueriesOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * The inline source for
   * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource}
   */
  public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
      InlineSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InlineSource.newBuilder() to construct.
    private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InlineSource() {
      sampleQueries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InlineSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_InlineSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_InlineSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                  .class,
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                  .Builder.class);
    }

    public static final int SAMPLE_QUERIES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery> sampleQueries_;
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery>
        getSampleQueriesList() {
      return sampleQueries_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>
        getSampleQueriesOrBuilderList() {
      return sampleQueries_;
    }
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getSampleQueriesCount() {
      return sampleQueries_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SampleQuery getSampleQueries(int index) {
      return sampleQueries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A list of
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
     * import. Max of 1000 items.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder getSampleQueriesOrBuilder(
        int index) {
      return sampleQueries_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < sampleQueries_.size(); i++) {
        output.writeMessage(1, sampleQueries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < sampleQueries_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, sampleQueries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource other =
          (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource) obj;

      if (!getSampleQueriesList().equals(other.getSampleQueriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSampleQueriesCount() > 0) {
        hash = (37 * hash) + SAMPLE_QUERIES_FIELD_NUMBER;
        hash = (53 * hash) + getSampleQueriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The inline source for
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                    .class,
                com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (sampleQueriesBuilder_ == null) {
          sampleQueries_ = java.util.Collections.emptyList();
        } else {
          sampleQueries_ = null;
          sampleQueriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
            .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_InlineSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
          build() {
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
          buildPartial() {
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource result =
            new com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource result) {
        if (sampleQueriesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            sampleQueries_ = java.util.Collections.unmodifiableList(sampleQueries_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.sampleQueries_ = sampleQueries_;
        } else {
          result.sampleQueries_ = sampleQueriesBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource other) {
        if (other
            == com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                .getDefaultInstance()) return this;
        if (sampleQueriesBuilder_ == null) {
          if (!other.sampleQueries_.isEmpty()) {
            if (sampleQueries_.isEmpty()) {
              sampleQueries_ = other.sampleQueries_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSampleQueriesIsMutable();
              sampleQueries_.addAll(other.sampleQueries_);
            }
            onChanged();
          }
        } else {
          if (!other.sampleQueries_.isEmpty()) {
            if (sampleQueriesBuilder_.isEmpty()) {
              sampleQueriesBuilder_.dispose();
              sampleQueriesBuilder_ = null;
              sampleQueries_ = other.sampleQueries_;
              bitField0_ = (bitField0_ & ~0x00000001);
              sampleQueriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSampleQueriesFieldBuilder()
                      : null;
            } else {
              sampleQueriesBuilder_.addAllMessages(other.sampleQueries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.discoveryengine.v1alpha.SampleQuery m =
                      input.readMessage(
                          com.google.cloud.discoveryengine.v1alpha.SampleQuery.parser(),
                          extensionRegistry);
                  if (sampleQueriesBuilder_ == null) {
                    ensureSampleQueriesIsMutable();
                    sampleQueries_.add(m);
                  } else {
                    sampleQueriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery> sampleQueries_ =
          java.util.Collections.emptyList();

      private void ensureSampleQueriesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          sampleQueries_ =
              new java.util.ArrayList<com.google.cloud.discoveryengine.v1alpha.SampleQuery>(
                  sampleQueries_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.SampleQuery,
              com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder,
              com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>
          sampleQueriesBuilder_;

      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery>
          getSampleQueriesList() {
        if (sampleQueriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sampleQueries_);
        } else {
          return sampleQueriesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getSampleQueriesCount() {
        if (sampleQueriesBuilder_ == null) {
          return sampleQueries_.size();
        } else {
          return sampleQueriesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.SampleQuery getSampleQueries(int index) {
        if (sampleQueriesBuilder_ == null) {
          return sampleQueries_.get(index);
        } else {
          return sampleQueriesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSampleQueries(
          int index, com.google.cloud.discoveryengine.v1alpha.SampleQuery value) {
        if (sampleQueriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSampleQueriesIsMutable();
          sampleQueries_.set(index, value);
          onChanged();
        } else {
          sampleQueriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setSampleQueries(
          int index, com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder builderForValue) {
        if (sampleQueriesBuilder_ == null) {
          ensureSampleQueriesIsMutable();
          sampleQueries_.set(index, builderForValue.build());
          onChanged();
        } else {
          sampleQueriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addSampleQueries(com.google.cloud.discoveryengine.v1alpha.SampleQuery value) {
        if (sampleQueriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSampleQueriesIsMutable();
          sampleQueries_.add(value);
          onChanged();
        } else {
          sampleQueriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addSampleQueries(
          int index, com.google.cloud.discoveryengine.v1alpha.SampleQuery value) {
        if (sampleQueriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSampleQueriesIsMutable();
          sampleQueries_.add(index, value);
          onChanged();
        } else {
          sampleQueriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addSampleQueries(
          com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder builderForValue) {
        if (sampleQueriesBuilder_ == null) {
          ensureSampleQueriesIsMutable();
          sampleQueries_.add(builderForValue.build());
          onChanged();
        } else {
          sampleQueriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addSampleQueries(
          int index, com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder builderForValue) {
        if (sampleQueriesBuilder_ == null) {
          ensureSampleQueriesIsMutable();
          sampleQueries_.add(index, builderForValue.build());
          onChanged();
        } else {
          sampleQueriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllSampleQueries(
          java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1alpha.SampleQuery>
              values) {
        if (sampleQueriesBuilder_ == null) {
          ensureSampleQueriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sampleQueries_);
          onChanged();
        } else {
          sampleQueriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearSampleQueries() {
        if (sampleQueriesBuilder_ == null) {
          sampleQueries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          sampleQueriesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeSampleQueries(int index) {
        if (sampleQueriesBuilder_ == null) {
          ensureSampleQueriesIsMutable();
          sampleQueries_.remove(index);
          onChanged();
        } else {
          sampleQueriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder getSampleQueriesBuilder(
          int index) {
        return getSampleQueriesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder
          getSampleQueriesOrBuilder(int index) {
        if (sampleQueriesBuilder_ == null) {
          return sampleQueries_.get(index);
        } else {
          return sampleQueriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>
          getSampleQueriesOrBuilderList() {
        if (sampleQueriesBuilder_ != null) {
          return sampleQueriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sampleQueries_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder
          addSampleQueriesBuilder() {
        return getSampleQueriesFieldBuilder()
            .addBuilder(com.google.cloud.discoveryengine.v1alpha.SampleQuery.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder addSampleQueriesBuilder(
          int index) {
        return getSampleQueriesFieldBuilder()
            .addBuilder(
                index, com.google.cloud.discoveryengine.v1alpha.SampleQuery.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. A list of
       * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s to
       * import. Max of 1000 items.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1alpha.SampleQuery sample_queries = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder>
          getSampleQueriesBuilderList() {
        return getSampleQueriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.discoveryengine.v1alpha.SampleQuery,
              com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder,
              com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>
          getSampleQueriesFieldBuilder() {
        if (sampleQueriesBuilder_ == null) {
          sampleQueriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1alpha.SampleQuery,
                  com.google.cloud.discoveryengine.v1alpha.SampleQuery.Builder,
                  com.google.cloud.discoveryengine.v1alpha.SampleQueryOrBuilder>(
                  sampleQueries_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          sampleQueries_ = null;
        }
        return sampleQueriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
    private static final com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
            .InlineSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource();
    }

    public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InlineSource> PARSER =
        new com.google.protobuf.AbstractParser<InlineSource>() {
          @java.lang.Override
          public InlineSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InlineSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InlineSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INLINE_SOURCE(2),
    GCS_SOURCE(3),
    BIGQUERY_SOURCE(4),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return INLINE_SOURCE;
        case 3:
          return GCS_SOURCE;
        case 4:
          return BIGQUERY_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int INLINE_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The Inline source for sample query entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return Whether the inlineSource field is set.
   */
  @java.lang.Override
  public boolean hasInlineSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The Inline source for sample query entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
   * </code>
   *
   * @return The inlineSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
      getInlineSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Inline source for sample query entries.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSourceOrBuilder
      getInlineSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
          source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        .getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage location for the input content.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
  }

  public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   *
   * @return Whether the bigquerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigquerySource() {
    return sourceCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   *
   * @return The bigquerySource.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * BigQuery input source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
      getBigquerySourceOrBuilder() {
    if (sourceCase_ == 4) {
      return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
    }
    return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent sample query set resource name, such as
   * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
   *
   * If the caller does not have permission to list
   * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
   * sample query set, regardless of whether or not this sample query set
   * exists, a `PERMISSION_DENIED` error is returned.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent sample query set resource name, such as
   * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
   *
   * If the caller does not have permission to list
   * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
   * sample query set, regardless of whether or not this sample query set
   * exists, a `PERMISSION_DENIED` error is returned.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig errorConfig_;
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   *
   * @return Whether the errorConfig field is set.
   */
  @java.lang.Override
  public boolean hasErrorConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   *
   * @return The errorConfig.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig getErrorConfig() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }
  /**
   *
   *
   * <pre>
   * The desired location of errors incurred during the Import.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder
      getErrorConfigOrBuilder() {
    return errorConfig_ == null
        ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
        : errorConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
              source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getErrorConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
                  source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_);
    }
    if (sourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getErrorConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest other =
        (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasErrorConfig() != other.hasErrorConfig()) return false;
    if (hasErrorConfig()) {
      if (!getErrorConfig().equals(other.getErrorConfig())) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getInlineSource().equals(other.getInlineSource())) return false;
        break;
      case 3:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 4:
        if (!getBigquerySource().equals(other.getBigquerySource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasErrorConfig()) {
      hash = (37 * hash) + ERROR_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getErrorConfig().hashCode();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getInlineSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigquerySource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SampleQueryService.ImportSampleQueries][google.cloud.discoveryengine.v1alpha.SampleQueryService.ImportSampleQueries]
   * method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest)
      com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.class,
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inlineSourceBuilder_ != null) {
        inlineSourceBuilder_.clear();
      }
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (bigquerySourceBuilder_ != null) {
        bigquerySourceBuilder_.clear();
      }
      parent_ = "";
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1alpha_ImportSampleQueriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest build() {
      com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest result =
          new com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.errorConfig_ =
            errorConfigBuilder_ == null ? errorConfig_ : errorConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && inlineSourceBuilder_ != null) {
        result.source_ = inlineSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
      if (sourceCase_ == 4 && bigquerySourceBuilder_ != null) {
        result.source_ = bigquerySourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest other) {
      if (other
          == com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasErrorConfig()) {
        mergeErrorConfig(other.getErrorConfig());
      }
      switch (other.getSourceCase()) {
        case INLINE_SOURCE:
          {
            mergeInlineSource(other.getInlineSource());
            break;
          }
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case BIGQUERY_SOURCE:
          {
            mergeBigquerySource(other.getBigquerySource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBigquerySourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getErrorConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource,
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                .Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
                .InlineSourceOrBuilder>
        inlineSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
        getInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return inlineSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder setInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource.Builder
            builderForValue) {
      if (inlineSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        inlineSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder mergeInlineSource(
        com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource value) {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                  .newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
                              .InlineSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          inlineSourceBuilder_.mergeFrom(value);
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public Builder clearInlineSource() {
      if (inlineSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        inlineSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource.Builder
        getInlineSourceBuilder() {
      return getInlineSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if ((sourceCase_ == 2) && (inlineSourceBuilder_ != null)) {
        return inlineSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
              source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Inline source for sample query entries.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource inline_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource,
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                .Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
                .InlineSourceOrBuilder>
        getInlineSourceFieldBuilder() {
      if (inlineSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                  .getDefaultInstance();
        }
        inlineSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource,
                com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource
                    .Builder,
                com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
                    .InlineSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest.InlineSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return inlineSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.GcsSource,
            com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.discoveryengine.v1alpha.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.GcsSource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 3) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage location for the input content.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.GcsSource gcs_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.GcsSource,
            com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
            com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.GcsSource,
                com.google.cloud.discoveryengine.v1alpha.GcsSource.Builder,
                com.google.cloud.discoveryengine.v1alpha.GcsSourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
        bigquerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySource getBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 4) {
          return bigquerySourceBuilder_.getMessage();
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder builderForValue) {
      if (bigquerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder mergeBigquerySource(
        com.google.cloud.discoveryengine.v1alpha.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4
            && source_
                != com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.discoveryengine.v1alpha.BigQuerySource.newBuilder(
                      (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 4) {
          bigquerySourceBuilder_.mergeFrom(value);
        } else {
          bigquerySourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public Builder clearBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 4) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigquerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder
        getBigquerySourceBuilder() {
      return getBigquerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if ((sourceCase_ == 4) && (bigquerySourceBuilder_ != null)) {
        return bigquerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 4) {
          return (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_;
        }
        return com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery input source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.BigQuerySource bigquery_source = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
            com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>
        getBigquerySourceFieldBuilder() {
      if (bigquerySourceBuilder_ == null) {
        if (!(sourceCase_ == 4)) {
          source_ = com.google.cloud.discoveryengine.v1alpha.BigQuerySource.getDefaultInstance();
        }
        bigquerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.BigQuerySource,
                com.google.cloud.discoveryengine.v1alpha.BigQuerySource.Builder,
                com.google.cloud.discoveryengine.v1alpha.BigQuerySourceOrBuilder>(
                (com.google.cloud.discoveryengine.v1alpha.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 4;
      onChanged();
      return bigquerySourceBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent sample query set resource name, such as
     * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
     *
     * If the caller does not have permission to list
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
     * sample query set, regardless of whether or not this sample query set
     * exists, a `PERMISSION_DENIED` error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent sample query set resource name, such as
     * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
     *
     * If the caller does not have permission to list
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
     * sample query set, regardless of whether or not this sample query set
     * exists, a `PERMISSION_DENIED` error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent sample query set resource name, such as
     * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
     *
     * If the caller does not have permission to list
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
     * sample query set, regardless of whether or not this sample query set
     * exists, a `PERMISSION_DENIED` error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent sample query set resource name, such as
     * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
     *
     * If the caller does not have permission to list
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
     * sample query set, regardless of whether or not this sample query set
     * exists, a `PERMISSION_DENIED` error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent sample query set resource name, such as
     * `projects/{project}/locations/{location}/sampleQuerySets/{sampleQuerySet}`.
     *
     * If the caller does not have permission to list
     * [SampleQuery][google.cloud.discoveryengine.v1alpha.SampleQuery]s under this
     * sample query set, regardless of whether or not this sample query set
     * exists, a `PERMISSION_DENIED` error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig errorConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>
        errorConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     *
     * @return Whether the errorConfig field is set.
     */
    public boolean hasErrorConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     *
     * @return The errorConfig.
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig getErrorConfig() {
      if (errorConfigBuilder_ == null) {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      } else {
        return errorConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorConfig_ = value;
      } else {
        errorConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder setErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder builderForValue) {
      if (errorConfigBuilder_ == null) {
        errorConfig_ = builderForValue.build();
      } else {
        errorConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder mergeErrorConfig(
        com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig value) {
      if (errorConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && errorConfig_ != null
            && errorConfig_
                != com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig
                    .getDefaultInstance()) {
          getErrorConfigBuilder().mergeFrom(value);
        } else {
          errorConfig_ = value;
        }
      } else {
        errorConfigBuilder_.mergeFrom(value);
      }
      if (errorConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public Builder clearErrorConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      errorConfig_ = null;
      if (errorConfigBuilder_ != null) {
        errorConfigBuilder_.dispose();
        errorConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder
        getErrorConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getErrorConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    public com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder
        getErrorConfigOrBuilder() {
      if (errorConfigBuilder_ != null) {
        return errorConfigBuilder_.getMessageOrBuilder();
      } else {
        return errorConfig_ == null
            ? com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.getDefaultInstance()
            : errorConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired location of errors incurred during the Import.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.ImportErrorConfig error_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
            com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>
        getErrorConfigFieldBuilder() {
      if (errorConfigBuilder_ == null) {
        errorConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig,
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfig.Builder,
                com.google.cloud.discoveryengine.v1alpha.ImportErrorConfigOrBuilder>(
                getErrorConfig(), getParentForChildren(), isClean());
        errorConfig_ = null;
      }
      return errorConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest)
  private static final com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest();
  }

  public static com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportSampleQueriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportSampleQueriesRequest>() {
        @java.lang.Override
        public ImportSampleQueriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportSampleQueriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportSampleQueriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.ImportSampleQueriesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
