/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1alpha/data_store.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1alpha;

/**
 *
 *
 * <pre>
 * Config to store data store type configuration for workspace data
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1alpha.WorkspaceConfig}
 */
public final class WorkspaceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1alpha.WorkspaceConfig)
    WorkspaceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WorkspaceConfig.newBuilder() to construct.
  private WorkspaceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkspaceConfig() {
    type_ = 0;
    dasherCustomerId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkspaceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1alpha.DataStoreProto
        .internal_static_google_cloud_discoveryengine_v1alpha_WorkspaceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1alpha.DataStoreProto
        .internal_static_google_cloud_discoveryengine_v1alpha_WorkspaceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.class,
            com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the type of Workspace App supported by this DataStore
   * </pre>
   *
   * Protobuf enum {@code google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Defaults to an unspecified Workspace type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Drive data
     * </pre>
     *
     * <code>GOOGLE_DRIVE = 1;</code>
     */
    GOOGLE_DRIVE(1),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Mail data
     * </pre>
     *
     * <code>GOOGLE_MAIL = 2;</code>
     */
    GOOGLE_MAIL(2),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Sites data
     * </pre>
     *
     * <code>GOOGLE_SITES = 3;</code>
     */
    GOOGLE_SITES(3),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Calendar data
     * </pre>
     *
     * <code>GOOGLE_CALENDAR = 4;</code>
     */
    GOOGLE_CALENDAR(4),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Chat data
     * </pre>
     *
     * <code>GOOGLE_CHAT = 5;</code>
     */
    GOOGLE_CHAT(5),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Groups data
     * </pre>
     *
     * <code>GOOGLE_GROUPS = 6;</code>
     */
    GOOGLE_GROUPS(6),
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Keep data
     * </pre>
     *
     * <code>GOOGLE_KEEP = 7;</code>
     */
    GOOGLE_KEEP(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Defaults to an unspecified Workspace type.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Drive data
     * </pre>
     *
     * <code>GOOGLE_DRIVE = 1;</code>
     */
    public static final int GOOGLE_DRIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Mail data
     * </pre>
     *
     * <code>GOOGLE_MAIL = 2;</code>
     */
    public static final int GOOGLE_MAIL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Sites data
     * </pre>
     *
     * <code>GOOGLE_SITES = 3;</code>
     */
    public static final int GOOGLE_SITES_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Calendar data
     * </pre>
     *
     * <code>GOOGLE_CALENDAR = 4;</code>
     */
    public static final int GOOGLE_CALENDAR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Chat data
     * </pre>
     *
     * <code>GOOGLE_CHAT = 5;</code>
     */
    public static final int GOOGLE_CHAT_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Groups data
     * </pre>
     *
     * <code>GOOGLE_GROUPS = 6;</code>
     */
    public static final int GOOGLE_GROUPS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Workspace Data Store contains Keep data
     * </pre>
     *
     * <code>GOOGLE_KEEP = 7;</code>
     */
    public static final int GOOGLE_KEEP_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return GOOGLE_DRIVE;
        case 2:
          return GOOGLE_MAIL;
        case 3:
          return GOOGLE_SITES;
        case 4:
          return GOOGLE_CALENDAR;
        case 5:
          return GOOGLE_CHAT;
        case 6:
          return GOOGLE_GROUPS;
        case 7:
          return GOOGLE_KEEP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * The Google Workspace data source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The Google Workspace data source.
   * </pre>
   *
   * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type getType() {
    com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type result =
        com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.UNRECOGNIZED
        : result;
  }

  public static final int DASHER_CUSTOMER_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dasherCustomerId_ = "";
  /**
   *
   *
   * <pre>
   * Obfuscated Dasher customer ID.
   * </pre>
   *
   * <code>string dasher_customer_id = 2;</code>
   *
   * @return The dasherCustomerId.
   */
  @java.lang.Override
  public java.lang.String getDasherCustomerId() {
    java.lang.Object ref = dasherCustomerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dasherCustomerId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Obfuscated Dasher customer ID.
   * </pre>
   *
   * <code>string dasher_customer_id = 2;</code>
   *
   * @return The bytes for dasherCustomerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDasherCustomerIdBytes() {
    java.lang.Object ref = dasherCustomerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dasherCustomerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dasherCustomerId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dasherCustomerId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dasherCustomerId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dasherCustomerId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig other =
        (com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig) obj;

    if (type_ != other.type_) return false;
    if (!getDasherCustomerId().equals(other.getDasherCustomerId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + DASHER_CUSTOMER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDasherCustomerId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config to store data store type configuration for workspace data
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1alpha.WorkspaceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1alpha.WorkspaceConfig)
      com.google.cloud.discoveryengine.v1alpha.WorkspaceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1alpha.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1alpha_WorkspaceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1alpha.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1alpha_WorkspaceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.class,
              com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      dasherCustomerId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1alpha.DataStoreProto
          .internal_static_google_cloud_discoveryengine_v1alpha_WorkspaceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig build() {
      com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig buildPartial() {
      com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig result =
          new com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dasherCustomerId_ = dasherCustomerId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig) {
        return mergeFrom((com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig other) {
      if (other == com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getDasherCustomerId().isEmpty()) {
        dasherCustomerId_ = other.dasherCustomerId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                dasherCustomerId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The Google Workspace data source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The Google Workspace data source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Workspace data source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type getType() {
      com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type result =
          com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The Google Workspace data source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Workspace data source.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1alpha.WorkspaceConfig.Type type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object dasherCustomerId_ = "";
    /**
     *
     *
     * <pre>
     * Obfuscated Dasher customer ID.
     * </pre>
     *
     * <code>string dasher_customer_id = 2;</code>
     *
     * @return The dasherCustomerId.
     */
    public java.lang.String getDasherCustomerId() {
      java.lang.Object ref = dasherCustomerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dasherCustomerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated Dasher customer ID.
     * </pre>
     *
     * <code>string dasher_customer_id = 2;</code>
     *
     * @return The bytes for dasherCustomerId.
     */
    public com.google.protobuf.ByteString getDasherCustomerIdBytes() {
      java.lang.Object ref = dasherCustomerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dasherCustomerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated Dasher customer ID.
     * </pre>
     *
     * <code>string dasher_customer_id = 2;</code>
     *
     * @param value The dasherCustomerId to set.
     * @return This builder for chaining.
     */
    public Builder setDasherCustomerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dasherCustomerId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated Dasher customer ID.
     * </pre>
     *
     * <code>string dasher_customer_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDasherCustomerId() {
      dasherCustomerId_ = getDefaultInstance().getDasherCustomerId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated Dasher customer ID.
     * </pre>
     *
     * <code>string dasher_customer_id = 2;</code>
     *
     * @param value The bytes for dasherCustomerId to set.
     * @return This builder for chaining.
     */
    public Builder setDasherCustomerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dasherCustomerId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1alpha.WorkspaceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1alpha.WorkspaceConfig)
  private static final com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig();
  }

  public static com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkspaceConfig> PARSER =
      new com.google.protobuf.AbstractParser<WorkspaceConfig>() {
        @java.lang.Override
        public WorkspaceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkspaceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkspaceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1alpha.WorkspaceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
