/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/import_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * The Cloud Bigtable source for importing data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.BigtableSource}
 */
public final class BigtableSource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.BigtableSource)
    BigtableSourceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigtableSource.newBuilder() to construct.
  private BigtableSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigtableSource() {
    projectId_ = "";
    instanceId_ = "";
    tableId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigtableSource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_BigtableSource_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
        .internal_static_google_cloud_discoveryengine_v1beta_BigtableSource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.BigtableSource.class,
            com.google.cloud.discoveryengine.v1beta.BigtableSource.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECT_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object projectId_ = "";
  /**
   *
   *
   * <pre>
   * The project ID that contains the Bigtable source. Has a length limit of 128
   * characters. If not specified, inherits the project ID from the parent
   * request.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project ID that contains the Bigtable source. Has a length limit of 128
   * characters. If not specified, inherits the project ID from the parent
   * request.
   * </pre>
   *
   * <code>string project_id = 1;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The instance ID of the Cloud Bigtable that needs to be imported.
   * </pre>
   *
   * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The instanceId.
   */
  @java.lang.Override
  public java.lang.String getInstanceId() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The instance ID of the Cloud Bigtable that needs to be imported.
   * </pre>
   *
   * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for instanceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceIdBytes() {
    java.lang.Object ref = instanceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tableId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The table ID of the Cloud Bigtable that needs to be imported.
   * </pre>
   *
   * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The tableId.
   */
  @java.lang.Override
  public java.lang.String getTableId() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The table ID of the Cloud Bigtable that needs to be imported.
   * </pre>
   *
   * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for tableId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableIdBytes() {
    java.lang.Object ref = tableId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BIGTABLE_OPTIONS_FIELD_NUMBER = 4;
  private com.google.cloud.discoveryengine.v1beta.BigtableOptions bigtableOptions_;
  /**
   *
   *
   * <pre>
   * Required. Bigtable options that contains information needed when parsing
   * data into typed structures. For example, column type annotations.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the bigtableOptions field is set.
   */
  @java.lang.Override
  public boolean hasBigtableOptions() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Bigtable options that contains information needed when parsing
   * data into typed structures. For example, column type annotations.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bigtableOptions.
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigtableOptions getBigtableOptions() {
    return bigtableOptions_ == null
        ? com.google.cloud.discoveryengine.v1beta.BigtableOptions.getDefaultInstance()
        : bigtableOptions_;
  }
  /**
   *
   *
   * <pre>
   * Required. Bigtable options that contains information needed when parsing
   * data into typed structures. For example, column type annotations.
   * </pre>
   *
   * <code>
   * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigtableOptionsOrBuilder
      getBigtableOptionsOrBuilder() {
    return bigtableOptions_ == null
        ? com.google.cloud.discoveryengine.v1beta.BigtableOptions.getDefaultInstance()
        : bigtableOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tableId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getBigtableOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instanceId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tableId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getBigtableOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.BigtableSource)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.BigtableSource other =
        (com.google.cloud.discoveryengine.v1beta.BigtableSource) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getInstanceId().equals(other.getInstanceId())) return false;
    if (!getTableId().equals(other.getTableId())) return false;
    if (hasBigtableOptions() != other.hasBigtableOptions()) return false;
    if (hasBigtableOptions()) {
      if (!getBigtableOptions().equals(other.getBigtableOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + INSTANCE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceId().hashCode();
    hash = (37 * hash) + TABLE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTableId().hashCode();
    if (hasBigtableOptions()) {
      hash = (37 * hash) + BIGTABLE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBigtableOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.BigtableSource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Cloud Bigtable source for importing data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.BigtableSource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.BigtableSource)
      com.google.cloud.discoveryengine.v1beta.BigtableSourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigtableSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigtableSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.BigtableSource.class,
              com.google.cloud.discoveryengine.v1beta.BigtableSource.Builder.class);
    }

    // Construct using com.google.cloud.discoveryengine.v1beta.BigtableSource.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBigtableOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      projectId_ = "";
      instanceId_ = "";
      tableId_ = "";
      bigtableOptions_ = null;
      if (bigtableOptionsBuilder_ != null) {
        bigtableOptionsBuilder_.dispose();
        bigtableOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.ImportConfigProto
          .internal_static_google_cloud_discoveryengine_v1beta_BigtableSource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigtableSource getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.BigtableSource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigtableSource build() {
      com.google.cloud.discoveryengine.v1beta.BigtableSource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.BigtableSource buildPartial() {
      com.google.cloud.discoveryengine.v1beta.BigtableSource result =
          new com.google.cloud.discoveryengine.v1beta.BigtableSource(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.discoveryengine.v1beta.BigtableSource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.projectId_ = projectId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceId_ = instanceId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.tableId_ = tableId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.bigtableOptions_ =
            bigtableOptionsBuilder_ == null ? bigtableOptions_ : bigtableOptionsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.discoveryengine.v1beta.BigtableSource) {
        return mergeFrom((com.google.cloud.discoveryengine.v1beta.BigtableSource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.discoveryengine.v1beta.BigtableSource other) {
      if (other == com.google.cloud.discoveryengine.v1beta.BigtableSource.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getInstanceId().isEmpty()) {
        instanceId_ = other.instanceId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTableId().isEmpty()) {
        tableId_ = other.tableId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasBigtableOptions()) {
        mergeBigtableOptions(other.getBigtableOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                projectId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                instanceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                tableId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBigtableOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project ID that contains the Bigtable source. Has a length limit of 128
     * characters. If not specified, inherits the project ID from the parent
     * request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID that contains the Bigtable source. Has a length limit of 128
     * characters. If not specified, inherits the project ID from the parent
     * request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project ID that contains the Bigtable source. Has a length limit of 128
     * characters. If not specified, inherits the project ID from the parent
     * request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID that contains the Bigtable source. Has a length limit of 128
     * characters. If not specified, inherits the project ID from the parent
     * request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {
      projectId_ = getDefaultInstance().getProjectId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project ID that contains the Bigtable source. Has a length limit of 128
     * characters. If not specified, inherits the project ID from the parent
     * request.
     * </pre>
     *
     * <code>string project_id = 1;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      projectId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object instanceId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The instance ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The instanceId.
     */
    public java.lang.String getInstanceId() {
      java.lang.Object ref = instanceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for instanceId.
     */
    public com.google.protobuf.ByteString getInstanceIdBytes() {
      java.lang.Object ref = instanceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The instance ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceId() {
      instanceId_ = getDefaultInstance().getInstanceId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The instance ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string instance_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for instanceId to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object tableId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The table ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The tableId.
     */
    public java.lang.String getTableId() {
      java.lang.Object ref = tableId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for tableId.
     */
    public com.google.protobuf.ByteString getTableIdBytes() {
      java.lang.Object ref = tableId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The table ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tableId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The table ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableId() {
      tableId_ = getDefaultInstance().getTableId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The table ID of the Cloud Bigtable that needs to be imported.
     * </pre>
     *
     * <code>string table_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for tableId to set.
     * @return This builder for chaining.
     */
    public Builder setTableIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tableId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.discoveryengine.v1beta.BigtableOptions bigtableOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.BigtableOptions,
            com.google.cloud.discoveryengine.v1beta.BigtableOptions.Builder,
            com.google.cloud.discoveryengine.v1beta.BigtableOptionsOrBuilder>
        bigtableOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the bigtableOptions field is set.
     */
    public boolean hasBigtableOptions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bigtableOptions.
     */
    public com.google.cloud.discoveryengine.v1beta.BigtableOptions getBigtableOptions() {
      if (bigtableOptionsBuilder_ == null) {
        return bigtableOptions_ == null
            ? com.google.cloud.discoveryengine.v1beta.BigtableOptions.getDefaultInstance()
            : bigtableOptions_;
      } else {
        return bigtableOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBigtableOptions(
        com.google.cloud.discoveryengine.v1beta.BigtableOptions value) {
      if (bigtableOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigtableOptions_ = value;
      } else {
        bigtableOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBigtableOptions(
        com.google.cloud.discoveryengine.v1beta.BigtableOptions.Builder builderForValue) {
      if (bigtableOptionsBuilder_ == null) {
        bigtableOptions_ = builderForValue.build();
      } else {
        bigtableOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeBigtableOptions(
        com.google.cloud.discoveryengine.v1beta.BigtableOptions value) {
      if (bigtableOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && bigtableOptions_ != null
            && bigtableOptions_
                != com.google.cloud.discoveryengine.v1beta.BigtableOptions.getDefaultInstance()) {
          getBigtableOptionsBuilder().mergeFrom(value);
        } else {
          bigtableOptions_ = value;
        }
      } else {
        bigtableOptionsBuilder_.mergeFrom(value);
      }
      if (bigtableOptions_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBigtableOptions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      bigtableOptions_ = null;
      if (bigtableOptionsBuilder_ != null) {
        bigtableOptionsBuilder_.dispose();
        bigtableOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.BigtableOptions.Builder
        getBigtableOptionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getBigtableOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.BigtableOptionsOrBuilder
        getBigtableOptionsOrBuilder() {
      if (bigtableOptionsBuilder_ != null) {
        return bigtableOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bigtableOptions_ == null
            ? com.google.cloud.discoveryengine.v1beta.BigtableOptions.getDefaultInstance()
            : bigtableOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Bigtable options that contains information needed when parsing
     * data into typed structures. For example, column type annotations.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.BigtableOptions bigtable_options = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.BigtableOptions,
            com.google.cloud.discoveryengine.v1beta.BigtableOptions.Builder,
            com.google.cloud.discoveryengine.v1beta.BigtableOptionsOrBuilder>
        getBigtableOptionsFieldBuilder() {
      if (bigtableOptionsBuilder_ == null) {
        bigtableOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.BigtableOptions,
                com.google.cloud.discoveryengine.v1beta.BigtableOptions.Builder,
                com.google.cloud.discoveryengine.v1beta.BigtableOptionsOrBuilder>(
                getBigtableOptions(), getParentForChildren(), isClean());
        bigtableOptions_ = null;
      }
      return bigtableOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.BigtableSource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.BigtableSource)
  private static final com.google.cloud.discoveryengine.v1beta.BigtableSource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.discoveryengine.v1beta.BigtableSource();
  }

  public static com.google.cloud.discoveryengine.v1beta.BigtableSource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigtableSource> PARSER =
      new com.google.protobuf.AbstractParser<BigtableSource>() {
        @java.lang.Override
        public BigtableSource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigtableSource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigtableSource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.BigtableSource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
