/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/discoveryengine/v1beta/grounded_generation_service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.discoveryengine.v1beta;

/**
 *
 *
 * <pre>
 * Response for the `GenerateGroundedContent` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse}
 */
public final class GenerateGroundedContentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse)
    GenerateGroundedContentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GenerateGroundedContentResponse.newBuilder() to construct.
  private GenerateGroundedContentResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateGroundedContentResponse() {
    candidates_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateGroundedContentResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
        .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.class,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Builder.class);
  }

  public interface CandidateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Index of the candidate.
     * </pre>
     *
     * <code>int32 index = 1;</code>
     *
     * @return The index.
     */
    int getIndex();

    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     *
     * @return Whether the content field is set.
     */
    boolean hasContent();
    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     *
     * @return The content.
     */
    com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent getContent();
    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     */
    com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder
        getContentOrBuilder();

    /**
     *
     *
     * <pre>
     * The overall grounding score for the candidate, in the range of [0, 1].
     * </pre>
     *
     * <code>optional float grounding_score = 3;</code>
     *
     * @return Whether the groundingScore field is set.
     */
    boolean hasGroundingScore();
    /**
     *
     *
     * <pre>
     * The overall grounding score for the candidate, in the range of [0, 1].
     * </pre>
     *
     * <code>optional float grounding_score = 3;</code>
     *
     * @return The groundingScore.
     */
    float getGroundingScore();

    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     *
     * @return Whether the groundingMetadata field is set.
     */
    boolean hasGroundingMetadata();
    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     *
     * @return The groundingMetadata.
     */
    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .GroundingMetadata
        getGroundingMetadata();
    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     */
    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .GroundingMetadataOrBuilder
        getGroundingMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A response candidate generated from the model.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate}
   */
  public static final class Candidate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
      CandidateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Candidate.newBuilder() to construct.
    private Candidate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Candidate() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Candidate();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .class,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .Builder.class);
    }

    public interface GroundingMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata>
          getRetrievalMetadataList();
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.RetrievalMetadata
          getRetrievalMetadata(int index);
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      int getRetrievalMetadataCount();
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadataOrBuilder>
          getRetrievalMetadataOrBuilderList();
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.RetrievalMetadataOrBuilder
          getRetrievalMetadataOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> getSupportChunksList();
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      com.google.cloud.discoveryengine.v1beta.FactChunk getSupportChunks(int index);
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      int getSupportChunksCount();
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      java.util.List<? extends com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
          getSupportChunksOrBuilderList();
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder getSupportChunksOrBuilder(
          int index);

      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @return A list containing the webSearchQueries.
       */
      java.util.List<java.lang.String> getWebSearchQueriesList();
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @return The count of webSearchQueries.
       */
      int getWebSearchQueriesCount();
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The webSearchQueries at the given index.
       */
      java.lang.String getWebSearchQueries(int index);
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the webSearchQueries at the given index.
       */
      com.google.protobuf.ByteString getWebSearchQueriesBytes(int index);

      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       *
       * @return Whether the searchEntryPoint field is set.
       */
      boolean hasSearchEntryPoint();
      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       *
       * @return The searchEntryPoint.
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.SearchEntryPoint
          getSearchEntryPoint();
      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.SearchEntryPointOrBuilder
          getSearchEntryPointOrBuilder();

      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport>
          getGroundingSupportList();
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.GroundingSupport
          getGroundingSupport(int index);
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      int getGroundingSupportCount();
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupportOrBuilder>
          getGroundingSupportOrBuilderList();
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.GroundingSupportOrBuilder
          getGroundingSupportOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * Citation for the generated content.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata}
     */
    public static final class GroundingMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata)
        GroundingMetadataOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use GroundingMetadata.newBuilder() to construct.
      private GroundingMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private GroundingMetadata() {
        retrievalMetadata_ = java.util.Collections.emptyList();
        supportChunks_ = java.util.Collections.emptyList();
        webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
        groundingSupport_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new GroundingMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.class,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.Builder.class);
      }

      public interface RetrievalMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Describes the source to which the metadata is referring to.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for source.
         */
        int getSourceValue();
        /**
         *
         *
         * <pre>
         * Describes the source to which the metadata is referring to.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
         * </code>
         *
         * @return The source.
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.Source
            getSource();

        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         *
         * @return Whether the dynamicRetrievalMetadata field is set.
         */
        boolean hasDynamicRetrievalMetadata();
        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         *
         * @return The dynamicRetrievalMetadata.
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadata
            getDynamicRetrievalMetadata();
        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadataOrBuilder
            getDynamicRetrievalMetadataOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Describes the metadata associated with a retrieval step.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata}
       */
      public static final class RetrievalMetadata extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata)
          RetrievalMetadataOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use RetrievalMetadata.newBuilder() to construct.
        private RetrievalMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private RetrievalMetadata() {
          source_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new RetrievalMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * Describes the source to which the metadata is associated to.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source}
         */
        public enum Source implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified source.
           * </pre>
           *
           * <code>SOURCE_UNSPECIFIED = 0;</code>
           */
          SOURCE_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * Vertex AI search.
           * </pre>
           *
           * <code>VERTEX_AI_SEARCH = 1;</code>
           */
          VERTEX_AI_SEARCH(1),
          /**
           *
           *
           * <pre>
           * Google Search.
           * </pre>
           *
           * <code>GOOGLE_SEARCH = 3;</code>
           */
          GOOGLE_SEARCH(3),
          /**
           *
           *
           * <pre>
           * User inline provided content.
           * </pre>
           *
           * <code>INLINE_CONTENT = 2;</code>
           */
          INLINE_CONTENT(2),
          /**
           *
           *
           * <pre>
           * Google Maps.
           * </pre>
           *
           * <code>GOOGLE_MAPS = 4;</code>
           */
          GOOGLE_MAPS(4),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified source.
           * </pre>
           *
           * <code>SOURCE_UNSPECIFIED = 0;</code>
           */
          public static final int SOURCE_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * Vertex AI search.
           * </pre>
           *
           * <code>VERTEX_AI_SEARCH = 1;</code>
           */
          public static final int VERTEX_AI_SEARCH_VALUE = 1;
          /**
           *
           *
           * <pre>
           * Google Search.
           * </pre>
           *
           * <code>GOOGLE_SEARCH = 3;</code>
           */
          public static final int GOOGLE_SEARCH_VALUE = 3;
          /**
           *
           *
           * <pre>
           * User inline provided content.
           * </pre>
           *
           * <code>INLINE_CONTENT = 2;</code>
           */
          public static final int INLINE_CONTENT_VALUE = 2;
          /**
           *
           *
           * <pre>
           * Google Maps.
           * </pre>
           *
           * <code>GOOGLE_MAPS = 4;</code>
           */
          public static final int GOOGLE_MAPS_VALUE = 4;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Source valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Source forNumber(int value) {
            switch (value) {
              case 0:
                return SOURCE_UNSPECIFIED;
              case 1:
                return VERTEX_AI_SEARCH;
              case 3:
                return GOOGLE_SEARCH;
              case 2:
                return INLINE_CONTENT;
              case 4:
                return GOOGLE_MAPS;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Source> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Source> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Source>() {
                public Source findValueByNumber(int number) {
                  return Source.forNumber(number);
                }
              };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Source[] VALUES = values();

          public static Source valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Source(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source)
        }

        private int bitField0_;
        public static final int SOURCE_FIELD_NUMBER = 1;
        private int source_ = 0;
        /**
         *
         *
         * <pre>
         * Describes the source to which the metadata is referring to.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for source.
         */
        @java.lang.Override
        public int getSourceValue() {
          return source_;
        }
        /**
         *
         *
         * <pre>
         * Describes the source to which the metadata is referring to.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
         * </code>
         *
         * @return The source.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.Source
            getSource() {
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata.Source
              result =
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.Source.forNumber(source_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata.Source.UNRECOGNIZED
              : result;
        }

        public static final int DYNAMIC_RETRIEVAL_METADATA_FIELD_NUMBER = 2;
        private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadata
            dynamicRetrievalMetadata_;
        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         *
         * @return Whether the dynamicRetrievalMetadata field is set.
         */
        @java.lang.Override
        public boolean hasDynamicRetrievalMetadata() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         *
         * @return The dynamicRetrievalMetadata.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadata
            getDynamicRetrievalMetadata() {
          return dynamicRetrievalMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance()
              : dynamicRetrievalMetadata_;
        }
        /**
         *
         *
         * <pre>
         * Metadata for dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadataOrBuilder
            getDynamicRetrievalMetadataOrBuilder() {
          return dynamicRetrievalMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance()
              : dynamicRetrievalMetadata_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (source_
              != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata.Source.SOURCE_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, source_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(2, getDynamicRetrievalMetadata());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (source_
              != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata.Source.SOURCE_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, source_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(
                    2, getDynamicRetrievalMetadata());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata
              other =
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.RetrievalMetadata)
                      obj;

          if (source_ != other.source_) return false;
          if (hasDynamicRetrievalMetadata() != other.hasDynamicRetrievalMetadata()) return false;
          if (hasDynamicRetrievalMetadata()) {
            if (!getDynamicRetrievalMetadata().equals(other.getDynamicRetrievalMetadata()))
              return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + source_;
          if (hasDynamicRetrievalMetadata()) {
            hash = (37 * hash) + DYNAMIC_RETRIEVAL_METADATA_FIELD_NUMBER;
            hash = (53 * hash) + getDynamicRetrievalMetadata().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Describes the metadata associated with a retrieval step.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata)
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata.class,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getDynamicRetrievalMetadataFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            source_ = 0;
            dynamicRetrievalMetadata_ = null;
            if (dynamicRetrievalMetadataBuilder_ != null) {
              dynamicRetrievalMetadataBuilder_.dispose();
              dynamicRetrievalMetadataBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_RetrievalMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata
              build() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                result =
                    new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.source_ = source_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.dynamicRetrievalMetadata_ =
                  dynamicRetrievalMetadataBuilder_ == null
                      ? dynamicRetrievalMetadata_
                      : dynamicRetrievalMetadataBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.RetrievalMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.getDefaultInstance()) return this;
            if (other.source_ != 0) {
              setSourceValue(other.getSourceValue());
            }
            if (other.hasDynamicRetrievalMetadata()) {
              mergeDynamicRetrievalMetadata(other.getDynamicRetrievalMetadata());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      source_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 18:
                    {
                      input.readMessage(
                          getDynamicRetrievalMetadataFieldBuilder().getBuilder(),
                          extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int source_ = 0;
          /**
           *
           *
           * <pre>
           * Describes the source to which the metadata is referring to.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
           * </code>
           *
           * @return The enum numeric value on the wire for source.
           */
          @java.lang.Override
          public int getSourceValue() {
            return source_;
          }
          /**
           *
           *
           * <pre>
           * Describes the source to which the metadata is referring to.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
           * </code>
           *
           * @param value The enum numeric value on the wire for source to set.
           * @return This builder for chaining.
           */
          public Builder setSourceValue(int value) {
            source_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Describes the source to which the metadata is referring to.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
           * </code>
           *
           * @return The source.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata.Source
              getSource() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Source
                result =
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata.Source.forNumber(source_);
            return result == null
                ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Source.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * Describes the source to which the metadata is referring to.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
           * </code>
           *
           * @param value The source to set.
           * @return This builder for chaining.
           */
          public Builder setSource(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.Source
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            source_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Describes the source to which the metadata is referring to.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata.Source source = 1;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSource() {
            bitField0_ = (bitField0_ & ~0x00000001);
            source_ = 0;
            onChanged();
            return this;
          }

          private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              dynamicRetrievalMetadata_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata.Builder,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadataOrBuilder>
              dynamicRetrievalMetadataBuilder_;
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           *
           * @return Whether the dynamicRetrievalMetadata field is set.
           */
          public boolean hasDynamicRetrievalMetadata() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           *
           * @return The dynamicRetrievalMetadata.
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              getDynamicRetrievalMetadata() {
            if (dynamicRetrievalMetadataBuilder_ == null) {
              return dynamicRetrievalMetadata_ == null
                  ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance()
                  : dynamicRetrievalMetadata_;
            } else {
              return dynamicRetrievalMetadataBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public Builder setDynamicRetrievalMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata
                  value) {
            if (dynamicRetrievalMetadataBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              dynamicRetrievalMetadata_ = value;
            } else {
              dynamicRetrievalMetadataBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public Builder setDynamicRetrievalMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata.Builder
                  builderForValue) {
            if (dynamicRetrievalMetadataBuilder_ == null) {
              dynamicRetrievalMetadata_ = builderForValue.build();
            } else {
              dynamicRetrievalMetadataBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public Builder mergeDynamicRetrievalMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata
                  value) {
            if (dynamicRetrievalMetadataBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && dynamicRetrievalMetadata_ != null
                  && dynamicRetrievalMetadata_
                      != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalMetadata
                          .getDefaultInstance()) {
                getDynamicRetrievalMetadataBuilder().mergeFrom(value);
              } else {
                dynamicRetrievalMetadata_ = value;
              }
            } else {
              dynamicRetrievalMetadataBuilder_.mergeFrom(value);
            }
            if (dynamicRetrievalMetadata_ != null) {
              bitField0_ |= 0x00000002;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public Builder clearDynamicRetrievalMetadata() {
            bitField0_ = (bitField0_ & ~0x00000002);
            dynamicRetrievalMetadata_ = null;
            if (dynamicRetrievalMetadataBuilder_ != null) {
              dynamicRetrievalMetadataBuilder_.dispose();
              dynamicRetrievalMetadataBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata.Builder
              getDynamicRetrievalMetadataBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getDynamicRetrievalMetadataFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadataOrBuilder
              getDynamicRetrievalMetadataOrBuilder() {
            if (dynamicRetrievalMetadataBuilder_ != null) {
              return dynamicRetrievalMetadataBuilder_.getMessageOrBuilder();
            } else {
              return dynamicRetrievalMetadata_ == null
                  ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance()
                  : dynamicRetrievalMetadata_;
            }
          }
          /**
           *
           *
           * <pre>
           * Metadata for dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata dynamic_retrieval_metadata = 2;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata.Builder,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadataOrBuilder>
              getDynamicRetrievalMetadataFieldBuilder() {
            if (dynamicRetrievalMetadataBuilder_ == null) {
              dynamicRetrievalMetadataBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalMetadata,
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalMetadata.Builder,
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalMetadataOrBuilder>(
                      getDynamicRetrievalMetadata(), getParentForChildren(), isClean());
              dynamicRetrievalMetadata_ = null;
            }
            return dynamicRetrievalMetadataBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata)
        private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata();
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.RetrievalMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<RetrievalMetadata> PARSER =
            new com.google.protobuf.AbstractParser<RetrievalMetadata>() {
              @java.lang.Override
              public RetrievalMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<RetrievalMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<RetrievalMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface DynamicRetrievalMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         *
         * @return Whether the predictorMetadata field is set.
         */
        boolean hasPredictorMetadata();
        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         *
         * @return The predictorMetadata.
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata
            getPredictorMetadata();
        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder
            getPredictorMetadataOrBuilder();
      }
      /**
       *
       *
       * <pre>
       * Describes the metadata about dynamic retrieval.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata}
       */
      public static final class DynamicRetrievalMetadata
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata)
          DynamicRetrievalMetadataOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DynamicRetrievalMetadata.newBuilder() to construct.
        private DynamicRetrievalMetadata(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DynamicRetrievalMetadata() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DynamicRetrievalMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata.Builder.class);
        }

        private int bitField0_;
        public static final int PREDICTOR_METADATA_FIELD_NUMBER = 1;
        private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata
            predictorMetadata_;
        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         *
         * @return Whether the predictorMetadata field is set.
         */
        @java.lang.Override
        public boolean hasPredictorMetadata() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         *
         * @return The predictorMetadata.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata
            getPredictorMetadata() {
          return predictorMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.getDefaultInstance()
              : predictorMetadata_;
        }
        /**
         *
         *
         * <pre>
         * Metadata for the dynamic retrieval predictor.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder
            getPredictorMetadataOrBuilder() {
          return predictorMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.getDefaultInstance()
              : predictorMetadata_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeMessage(1, getPredictorMetadata());
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPredictorMetadata());
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              other =
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.DynamicRetrievalMetadata)
                      obj;

          if (hasPredictorMetadata() != other.hasPredictorMetadata()) return false;
          if (hasPredictorMetadata()) {
            if (!getPredictorMetadata().equals(other.getPredictorMetadata())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasPredictorMetadata()) {
            hash = (37 * hash) + PREDICTOR_METADATA_FIELD_NUMBER;
            hash = (53 * hash) + getPredictorMetadata().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Describes the metadata about dynamic retrieval.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata)
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalMetadata.class,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalMetadata.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getPredictorMetadataFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            predictorMetadata_ = null;
            if (predictorMetadataBuilder_ != null) {
              predictorMetadataBuilder_.dispose();
              predictorMetadataBuilder_ = null;
            }
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              build() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalMetadata
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalMetadata
                result =
                    new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalMetadata(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.predictorMetadata_ =
                  predictorMetadataBuilder_ == null
                      ? predictorMetadata_
                      : predictorMetadataBuilder_.build();
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalMetadata) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.DynamicRetrievalMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalMetadata
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalMetadata.getDefaultInstance()) return this;
            if (other.hasPredictorMetadata()) {
              mergePredictorMetadata(other.getPredictorMetadata());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getPredictorMetadataFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              predictorMetadata_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder>
              predictorMetadataBuilder_;
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           *
           * @return Whether the predictorMetadata field is set.
           */
          public boolean hasPredictorMetadata() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           *
           * @return The predictorMetadata.
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              getPredictorMetadata() {
            if (predictorMetadataBuilder_ == null) {
              return predictorMetadata_ == null
                  ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
                      .getDefaultInstance()
                  : predictorMetadata_;
            } else {
              return predictorMetadataBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public Builder setPredictorMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata
                  value) {
            if (predictorMetadataBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              predictorMetadata_ = value;
            } else {
              predictorMetadataBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public Builder setPredictorMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder
                  builderForValue) {
            if (predictorMetadataBuilder_ == null) {
              predictorMetadata_ = builderForValue.build();
            } else {
              predictorMetadataBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public Builder mergePredictorMetadata(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata
                  value) {
            if (predictorMetadataBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && predictorMetadata_ != null
                  && predictorMetadata_
                      != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
                          .getDefaultInstance()) {
                getPredictorMetadataBuilder().mergeFrom(value);
              } else {
                predictorMetadata_ = value;
              }
            } else {
              predictorMetadataBuilder_.mergeFrom(value);
            }
            if (predictorMetadata_ != null) {
              bitField0_ |= 0x00000001;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public Builder clearPredictorMetadata() {
            bitField0_ = (bitField0_ & ~0x00000001);
            predictorMetadata_ = null;
            if (predictorMetadataBuilder_ != null) {
              predictorMetadataBuilder_.dispose();
              predictorMetadataBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder
              getPredictorMetadataBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getPredictorMetadataFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder
              getPredictorMetadataOrBuilder() {
            if (predictorMetadataBuilder_ != null) {
              return predictorMetadataBuilder_.getMessageOrBuilder();
            } else {
              return predictorMetadata_ == null
                  ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
                      .getDefaultInstance()
                  : predictorMetadata_;
            }
          }
          /**
           *
           *
           * <pre>
           * Metadata for the dynamic retrieval predictor.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata predictor_metadata = 1;
           * </code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder>
              getPredictorMetadataFieldBuilder() {
            if (predictorMetadataBuilder_ == null) {
              predictorMetadataBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata,
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder,
                      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                          .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder>(
                      getPredictorMetadata(), getParentForChildren(), isClean());
              predictorMetadata_ = null;
            }
            return predictorMetadataBuilder_;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalMetadata)
        private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalMetadata();
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DynamicRetrievalMetadata> PARSER =
            new com.google.protobuf.AbstractParser<DynamicRetrievalMetadata>() {
              @java.lang.Override
              public DynamicRetrievalMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DynamicRetrievalMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DynamicRetrievalMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface DynamicRetrievalPredictorMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The version of the predictor which was used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for version.
         */
        int getVersionValue();
        /**
         *
         *
         * <pre>
         * The version of the predictor which was used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
         * </code>
         *
         * @return The version.
         */
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
            getVersion();

        /**
         *
         *
         * <pre>
         * The value of the predictor. This should be between [0, 1] where
         * a value of 0 means that the query would not benefit from grounding,
         * while a value of 1.0 means that the query would benefit the most.
         * In between values allow to differentiate between different usefulness
         * scores for grounding.
         * </pre>
         *
         * <code>optional float prediction = 2;</code>
         *
         * @return Whether the prediction field is set.
         */
        boolean hasPrediction();
        /**
         *
         *
         * <pre>
         * The value of the predictor. This should be between [0, 1] where
         * a value of 0 means that the query would not benefit from grounding,
         * while a value of 1.0 means that the query would benefit the most.
         * In between values allow to differentiate between different usefulness
         * scores for grounding.
         * </pre>
         *
         * <code>optional float prediction = 2;</code>
         *
         * @return The prediction.
         */
        float getPrediction();
      }
      /**
       *
       *
       * <pre>
       * Describes the metadata about the dynamic retrieval predictor.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata}
       */
      public static final class DynamicRetrievalPredictorMetadata
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata)
          DynamicRetrievalPredictorMetadataOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DynamicRetrievalPredictorMetadata.newBuilder() to construct.
        private DynamicRetrievalPredictorMetadata(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DynamicRetrievalPredictorMetadata() {
          version_ = 0;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DynamicRetrievalPredictorMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder.class);
        }

        /**
         *
         *
         * <pre>
         * The version of the predictor which was used in dynamic retrieval.
         * </pre>
         *
         * Protobuf enum {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version}
         */
        public enum Version implements com.google.protobuf.ProtocolMessageEnum {
          /**
           *
           *
           * <pre>
           * Unspecified version, should never be used.
           * </pre>
           *
           * <code>VERSION_UNSPECIFIED = 0;</code>
           */
          VERSION_UNSPECIFIED(0),
          /**
           *
           *
           * <pre>
           * The V1 model which is evaluating each source independently.
           * </pre>
           *
           * <code>V1_INDEPENDENT = 1;</code>
           */
          V1_INDEPENDENT(1),
          UNRECOGNIZED(-1),
          ;

          /**
           *
           *
           * <pre>
           * Unspecified version, should never be used.
           * </pre>
           *
           * <code>VERSION_UNSPECIFIED = 0;</code>
           */
          public static final int VERSION_UNSPECIFIED_VALUE = 0;
          /**
           *
           *
           * <pre>
           * The V1 model which is evaluating each source independently.
           * </pre>
           *
           * <code>V1_INDEPENDENT = 1;</code>
           */
          public static final int V1_INDEPENDENT_VALUE = 1;

          public final int getNumber() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalArgumentException(
                  "Can't get the number of an unknown enum value.");
            }
            return value;
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           * @deprecated Use {@link #forNumber(int)} instead.
           */
          @java.lang.Deprecated
          public static Version valueOf(int value) {
            return forNumber(value);
          }

          /**
           * @param value The numeric wire value of the corresponding enum entry.
           * @return The enum associated with the given numeric wire value.
           */
          public static Version forNumber(int value) {
            switch (value) {
              case 0:
                return VERSION_UNSPECIFIED;
              case 1:
                return V1_INDEPENDENT;
              default:
                return null;
            }
          }

          public static com.google.protobuf.Internal.EnumLiteMap<Version> internalGetValueMap() {
            return internalValueMap;
          }

          private static final com.google.protobuf.Internal.EnumLiteMap<Version> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Version>() {
                public Version findValueByNumber(int number) {
                  return Version.forNumber(number);
                }
              };

          public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
              throw new java.lang.IllegalStateException(
                  "Can't get the descriptor of an unrecognized enum value.");
            }
            return getDescriptor().getValues().get(ordinal());
          }

          public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
            return getDescriptor();
          }

          public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata.getDescriptor()
                .getEnumTypes()
                .get(0);
          }

          private static final Version[] VALUES = values();

          public static Version valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
              throw new java.lang.IllegalArgumentException(
                  "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
              return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
          }

          private final int value;

          private Version(int value) {
            this.value = value;
          }

          // @@protoc_insertion_point(enum_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version)
        }

        private int bitField0_;
        public static final int VERSION_FIELD_NUMBER = 1;
        private int version_ = 0;
        /**
         *
         *
         * <pre>
         * The version of the predictor which was used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for version.
         */
        @java.lang.Override
        public int getVersionValue() {
          return version_;
        }
        /**
         *
         *
         * <pre>
         * The version of the predictor which was used in dynamic retrieval.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
         * </code>
         *
         * @return The version.
         */
        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
            getVersion() {
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
              result =
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version.forNumber(
                      version_);
          return result == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version.UNRECOGNIZED
              : result;
        }

        public static final int PREDICTION_FIELD_NUMBER = 2;
        private float prediction_ = 0F;
        /**
         *
         *
         * <pre>
         * The value of the predictor. This should be between [0, 1] where
         * a value of 0 means that the query would not benefit from grounding,
         * while a value of 1.0 means that the query would benefit the most.
         * In between values allow to differentiate between different usefulness
         * scores for grounding.
         * </pre>
         *
         * <code>optional float prediction = 2;</code>
         *
         * @return Whether the prediction field is set.
         */
        @java.lang.Override
        public boolean hasPrediction() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The value of the predictor. This should be between [0, 1] where
         * a value of 0 means that the query would not benefit from grounding,
         * while a value of 1.0 means that the query would benefit the most.
         * In between values allow to differentiate between different usefulness
         * scores for grounding.
         * </pre>
         *
         * <code>optional float prediction = 2;</code>
         *
         * @return The prediction.
         */
        @java.lang.Override
        public float getPrediction() {
          return prediction_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (version_
              != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version.VERSION_UNSPECIFIED
                  .getNumber()) {
            output.writeEnum(1, version_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeFloat(2, prediction_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (version_
              != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version.VERSION_UNSPECIFIED
                  .getNumber()) {
            size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, version_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, prediction_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              other =
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.DynamicRetrievalPredictorMetadata)
                      obj;

          if (version_ != other.version_) return false;
          if (hasPrediction() != other.hasPrediction()) return false;
          if (hasPrediction()) {
            if (java.lang.Float.floatToIntBits(getPrediction())
                != java.lang.Float.floatToIntBits(other.getPrediction())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + VERSION_FIELD_NUMBER;
          hash = (53 * hash) + version_;
          if (hasPrediction()) {
            hash = (37 * hash) + PREDICTION_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrediction());
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Describes the metadata about the dynamic retrieval predictor.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata)
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.class,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            version_ = 0;
            prediction_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_DynamicRetrievalPredictorMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              build() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata
                result =
                    new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.version_ = version_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.prediction_ = prediction_;
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.DynamicRetrievalPredictorMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata.getDefaultInstance())
              return this;
            if (other.version_ != 0) {
              setVersionValue(other.getVersionValue());
            }
            if (other.hasPrediction()) {
              setPrediction(other.getPrediction());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      version_ = input.readEnum();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 21:
                    {
                      prediction_ = input.readFloat();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 21
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int version_ = 0;
          /**
           *
           *
           * <pre>
           * The version of the predictor which was used in dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
           * </code>
           *
           * @return The enum numeric value on the wire for version.
           */
          @java.lang.Override
          public int getVersionValue() {
            return version_;
          }
          /**
           *
           *
           * <pre>
           * The version of the predictor which was used in dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
           * </code>
           *
           * @param value The enum numeric value on the wire for version to set.
           * @return This builder for chaining.
           */
          public Builder setVersionValue(int value) {
            version_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The version of the predictor which was used in dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
           * </code>
           *
           * @return The version.
           */
          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
              getVersion() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
                result =
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
                        .forNumber(version_);
            return result == null
                ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version.UNRECOGNIZED
                : result;
          }
          /**
           *
           *
           * <pre>
           * The version of the predictor which was used in dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
           * </code>
           *
           * @param value The version to set.
           * @return This builder for chaining.
           */
          public Builder setVersion(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.DynamicRetrievalPredictorMetadata.Version
                  value) {
            if (value == null) {
              throw new NullPointerException();
            }
            bitField0_ |= 0x00000001;
            version_ = value.getNumber();
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The version of the predictor which was used in dynamic retrieval.
           * </pre>
           *
           * <code>
           * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata.Version version = 1;
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearVersion() {
            bitField0_ = (bitField0_ & ~0x00000001);
            version_ = 0;
            onChanged();
            return this;
          }

          private float prediction_;
          /**
           *
           *
           * <pre>
           * The value of the predictor. This should be between [0, 1] where
           * a value of 0 means that the query would not benefit from grounding,
           * while a value of 1.0 means that the query would benefit the most.
           * In between values allow to differentiate between different usefulness
           * scores for grounding.
           * </pre>
           *
           * <code>optional float prediction = 2;</code>
           *
           * @return Whether the prediction field is set.
           */
          @java.lang.Override
          public boolean hasPrediction() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * The value of the predictor. This should be between [0, 1] where
           * a value of 0 means that the query would not benefit from grounding,
           * while a value of 1.0 means that the query would benefit the most.
           * In between values allow to differentiate between different usefulness
           * scores for grounding.
           * </pre>
           *
           * <code>optional float prediction = 2;</code>
           *
           * @return The prediction.
           */
          @java.lang.Override
          public float getPrediction() {
            return prediction_;
          }
          /**
           *
           *
           * <pre>
           * The value of the predictor. This should be between [0, 1] where
           * a value of 0 means that the query would not benefit from grounding,
           * while a value of 1.0 means that the query would benefit the most.
           * In between values allow to differentiate between different usefulness
           * scores for grounding.
           * </pre>
           *
           * <code>optional float prediction = 2;</code>
           *
           * @param value The prediction to set.
           * @return This builder for chaining.
           */
          public Builder setPrediction(float value) {

            prediction_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The value of the predictor. This should be between [0, 1] where
           * a value of 0 means that the query would not benefit from grounding,
           * while a value of 1.0 means that the query would benefit the most.
           * In between values allow to differentiate between different usefulness
           * scores for grounding.
           * </pre>
           *
           * <code>optional float prediction = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearPrediction() {
            bitField0_ = (bitField0_ & ~0x00000002);
            prediction_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata)
        private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.DynamicRetrievalPredictorMetadata();
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.DynamicRetrievalPredictorMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DynamicRetrievalPredictorMetadata> PARSER =
            new com.google.protobuf.AbstractParser<DynamicRetrievalPredictorMetadata>() {
              @java.lang.Override
              public DynamicRetrievalPredictorMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DynamicRetrievalPredictorMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DynamicRetrievalPredictorMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.DynamicRetrievalPredictorMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface SearchEntryPointOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Web content snippet that can be embedded in a web page or an app
         * webview.
         * </pre>
         *
         * <code>string rendered_content = 1;</code>
         *
         * @return The renderedContent.
         */
        java.lang.String getRenderedContent();
        /**
         *
         *
         * <pre>
         * Web content snippet that can be embedded in a web page or an app
         * webview.
         * </pre>
         *
         * <code>string rendered_content = 1;</code>
         *
         * @return The bytes for renderedContent.
         */
        com.google.protobuf.ByteString getRenderedContentBytes();

        /**
         *
         *
         * <pre>
         * Base64 encoded JSON representing array of &lt;search term, search url&gt;
         * tuple.
         * </pre>
         *
         * <code>bytes sdk_blob = 2;</code>
         *
         * @return The sdkBlob.
         */
        com.google.protobuf.ByteString getSdkBlob();
      }
      /**
       *
       *
       * <pre>
       * Google search entry point.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint}
       */
      public static final class SearchEntryPoint extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint)
          SearchEntryPointOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use SearchEntryPoint.newBuilder() to construct.
        private SearchEntryPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private SearchEntryPoint() {
          renderedContent_ = "";
          sdkBlob_ = com.google.protobuf.ByteString.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new SearchEntryPoint();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.SearchEntryPoint.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.SearchEntryPoint.Builder.class);
        }

        public static final int RENDERED_CONTENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object renderedContent_ = "";
        /**
         *
         *
         * <pre>
         * Web content snippet that can be embedded in a web page or an app
         * webview.
         * </pre>
         *
         * <code>string rendered_content = 1;</code>
         *
         * @return The renderedContent.
         */
        @java.lang.Override
        public java.lang.String getRenderedContent() {
          java.lang.Object ref = renderedContent_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            renderedContent_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Web content snippet that can be embedded in a web page or an app
         * webview.
         * </pre>
         *
         * <code>string rendered_content = 1;</code>
         *
         * @return The bytes for renderedContent.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getRenderedContentBytes() {
          java.lang.Object ref = renderedContent_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            renderedContent_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SDK_BLOB_FIELD_NUMBER = 2;
        private com.google.protobuf.ByteString sdkBlob_ = com.google.protobuf.ByteString.EMPTY;
        /**
         *
         *
         * <pre>
         * Base64 encoded JSON representing array of &lt;search term, search url&gt;
         * tuple.
         * </pre>
         *
         * <code>bytes sdk_blob = 2;</code>
         *
         * @return The sdkBlob.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSdkBlob() {
          return sdkBlob_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedContent_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, renderedContent_);
          }
          if (!sdkBlob_.isEmpty()) {
            output.writeBytes(2, sdkBlob_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderedContent_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, renderedContent_);
          }
          if (!sdkBlob_.isEmpty()) {
            size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, sdkBlob_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint
              other =
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.SearchEntryPoint)
                      obj;

          if (!getRenderedContent().equals(other.getRenderedContent())) return false;
          if (!getSdkBlob().equals(other.getSdkBlob())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + RENDERED_CONTENT_FIELD_NUMBER;
          hash = (53 * hash) + getRenderedContent().hashCode();
          hash = (37 * hash) + SDK_BLOB_FIELD_NUMBER;
          hash = (53 * hash) + getSdkBlob().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Google search entry point.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint)
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPointOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint.class,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            renderedContent_ = "";
            sdkBlob_ = com.google.protobuf.ByteString.EMPTY;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_SearchEntryPoint_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint
              build() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint
                result =
                    new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.SearchEntryPoint
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.renderedContent_ = renderedContent_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.sdkBlob_ = sdkBlob_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.SearchEntryPoint)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.SearchEntryPoint
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.getDefaultInstance()) return this;
            if (!other.getRenderedContent().isEmpty()) {
              renderedContent_ = other.renderedContent_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (other.getSdkBlob() != com.google.protobuf.ByteString.EMPTY) {
              setSdkBlob(other.getSdkBlob());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      renderedContent_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      sdkBlob_ = input.readBytes();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object renderedContent_ = "";
          /**
           *
           *
           * <pre>
           * Web content snippet that can be embedded in a web page or an app
           * webview.
           * </pre>
           *
           * <code>string rendered_content = 1;</code>
           *
           * @return The renderedContent.
           */
          public java.lang.String getRenderedContent() {
            java.lang.Object ref = renderedContent_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              renderedContent_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Web content snippet that can be embedded in a web page or an app
           * webview.
           * </pre>
           *
           * <code>string rendered_content = 1;</code>
           *
           * @return The bytes for renderedContent.
           */
          public com.google.protobuf.ByteString getRenderedContentBytes() {
            java.lang.Object ref = renderedContent_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              renderedContent_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Web content snippet that can be embedded in a web page or an app
           * webview.
           * </pre>
           *
           * <code>string rendered_content = 1;</code>
           *
           * @param value The renderedContent to set.
           * @return This builder for chaining.
           */
          public Builder setRenderedContent(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            renderedContent_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Web content snippet that can be embedded in a web page or an app
           * webview.
           * </pre>
           *
           * <code>string rendered_content = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearRenderedContent() {
            renderedContent_ = getDefaultInstance().getRenderedContent();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Web content snippet that can be embedded in a web page or an app
           * webview.
           * </pre>
           *
           * <code>string rendered_content = 1;</code>
           *
           * @param value The bytes for renderedContent to set.
           * @return This builder for chaining.
           */
          public Builder setRenderedContentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            renderedContent_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private com.google.protobuf.ByteString sdkBlob_ = com.google.protobuf.ByteString.EMPTY;
          /**
           *
           *
           * <pre>
           * Base64 encoded JSON representing array of &lt;search term, search url&gt;
           * tuple.
           * </pre>
           *
           * <code>bytes sdk_blob = 2;</code>
           *
           * @return The sdkBlob.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getSdkBlob() {
            return sdkBlob_;
          }
          /**
           *
           *
           * <pre>
           * Base64 encoded JSON representing array of &lt;search term, search url&gt;
           * tuple.
           * </pre>
           *
           * <code>bytes sdk_blob = 2;</code>
           *
           * @param value The sdkBlob to set.
           * @return This builder for chaining.
           */
          public Builder setSdkBlob(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            sdkBlob_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Base64 encoded JSON representing array of &lt;search term, search url&gt;
           * tuple.
           * </pre>
           *
           * <code>bytes sdk_blob = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSdkBlob() {
            bitField0_ = (bitField0_ & ~0x00000002);
            sdkBlob_ = getDefaultInstance().getSdkBlob();
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint)
        private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.SearchEntryPoint();
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.SearchEntryPoint
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<SearchEntryPoint> PARSER =
            new com.google.protobuf.AbstractParser<SearchEntryPoint>() {
              @java.lang.Override
              public SearchEntryPoint parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<SearchEntryPoint> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<SearchEntryPoint> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface GroundingSupportOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Text for the claim in the candidate. Always provided when a
         * support is found.
         * </pre>
         *
         * <code>string claim_text = 1;</code>
         *
         * @return The claimText.
         */
        java.lang.String getClaimText();
        /**
         *
         *
         * <pre>
         * Text for the claim in the candidate. Always provided when a
         * support is found.
         * </pre>
         *
         * <code>string claim_text = 1;</code>
         *
         * @return The bytes for claimText.
         */
        com.google.protobuf.ByteString getClaimTextBytes();

        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @return A list containing the supportChunkIndices.
         */
        java.util.List<java.lang.Integer> getSupportChunkIndicesList();
        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @return The count of supportChunkIndices.
         */
        int getSupportChunkIndicesCount();
        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The supportChunkIndices at the given index.
         */
        int getSupportChunkIndices(int index);

        /**
         *
         *
         * <pre>
         * A score in the range of [0, 1] describing how grounded is a specific
         * claim in the support chunks indicated.
         * Higher value means that the claim is better supported by the chunks.
         * </pre>
         *
         * <code>optional float support_score = 2;</code>
         *
         * @return Whether the supportScore field is set.
         */
        boolean hasSupportScore();
        /**
         *
         *
         * <pre>
         * A score in the range of [0, 1] describing how grounded is a specific
         * claim in the support chunks indicated.
         * Higher value means that the claim is better supported by the chunks.
         * </pre>
         *
         * <code>optional float support_score = 2;</code>
         *
         * @return The supportScore.
         */
        float getSupportScore();
      }
      /**
       *
       *
       * <pre>
       * Grounding info for a claim in the candidate and its support.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport}
       */
      public static final class GroundingSupport extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport)
          GroundingSupportOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use GroundingSupport.newBuilder() to construct.
        private GroundingSupport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private GroundingSupport() {
          claimText_ = "";
          supportChunkIndices_ = emptyIntList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new GroundingSupport();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport.Builder.class);
        }

        private int bitField0_;
        public static final int CLAIM_TEXT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object claimText_ = "";
        /**
         *
         *
         * <pre>
         * Text for the claim in the candidate. Always provided when a
         * support is found.
         * </pre>
         *
         * <code>string claim_text = 1;</code>
         *
         * @return The claimText.
         */
        @java.lang.Override
        public java.lang.String getClaimText() {
          java.lang.Object ref = claimText_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            claimText_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Text for the claim in the candidate. Always provided when a
         * support is found.
         * </pre>
         *
         * <code>string claim_text = 1;</code>
         *
         * @return The bytes for claimText.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getClaimTextBytes() {
          java.lang.Object ref = claimText_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            claimText_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int SUPPORT_CHUNK_INDICES_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private com.google.protobuf.Internal.IntList supportChunkIndices_ = emptyIntList();
        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @return A list containing the supportChunkIndices.
         */
        @java.lang.Override
        public java.util.List<java.lang.Integer> getSupportChunkIndicesList() {
          return supportChunkIndices_;
        }
        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @return The count of supportChunkIndices.
         */
        public int getSupportChunkIndicesCount() {
          return supportChunkIndices_.size();
        }
        /**
         *
         *
         * <pre>
         * A list of indices (into 'support_chunks') specifying the
         * citations associated with the claim. For instance [1,3,4] means
         * that support_chunks[1], support_chunks[3],
         * support_chunks[4] are the chunks attributed to the claim.
         * </pre>
         *
         * <code>repeated int32 support_chunk_indices = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The supportChunkIndices at the given index.
         */
        public int getSupportChunkIndices(int index) {
          return supportChunkIndices_.getInt(index);
        }

        private int supportChunkIndicesMemoizedSerializedSize = -1;

        public static final int SUPPORT_SCORE_FIELD_NUMBER = 2;
        private float supportScore_ = 0F;
        /**
         *
         *
         * <pre>
         * A score in the range of [0, 1] describing how grounded is a specific
         * claim in the support chunks indicated.
         * Higher value means that the claim is better supported by the chunks.
         * </pre>
         *
         * <code>optional float support_score = 2;</code>
         *
         * @return Whether the supportScore field is set.
         */
        @java.lang.Override
        public boolean hasSupportScore() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * A score in the range of [0, 1] describing how grounded is a specific
         * claim in the support chunks indicated.
         * Higher value means that the claim is better supported by the chunks.
         * </pre>
         *
         * <code>optional float support_score = 2;</code>
         *
         * @return The supportScore.
         */
        @java.lang.Override
        public float getSupportScore() {
          return supportScore_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(claimText_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, claimText_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeFloat(2, supportScore_);
          }
          if (getSupportChunkIndicesList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(supportChunkIndicesMemoizedSerializedSize);
          }
          for (int i = 0; i < supportChunkIndices_.size(); i++) {
            output.writeInt32NoTag(supportChunkIndices_.getInt(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(claimText_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, claimText_);
          }
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, supportScore_);
          }
          {
            int dataSize = 0;
            for (int i = 0; i < supportChunkIndices_.size(); i++) {
              dataSize +=
                  com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(
                      supportChunkIndices_.getInt(i));
            }
            size += dataSize;
            if (!getSupportChunkIndicesList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            supportChunkIndicesMemoizedSerializedSize = dataSize;
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport)) {
            return super.equals(obj);
          }
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport
              other =
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.GroundingSupport)
                      obj;

          if (!getClaimText().equals(other.getClaimText())) return false;
          if (!getSupportChunkIndicesList().equals(other.getSupportChunkIndicesList()))
            return false;
          if (hasSupportScore() != other.hasSupportScore()) return false;
          if (hasSupportScore()) {
            if (java.lang.Float.floatToIntBits(getSupportScore())
                != java.lang.Float.floatToIntBits(other.getSupportScore())) return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + CLAIM_TEXT_FIELD_NUMBER;
          hash = (53 * hash) + getClaimText().hashCode();
          if (getSupportChunkIndicesCount() > 0) {
            hash = (37 * hash) + SUPPORT_CHUNK_INDICES_FIELD_NUMBER;
            hash = (53 * hash) + getSupportChunkIndicesList().hashCode();
          }
          if (hasSupportScore()) {
            hash = (37 * hash) + SUPPORT_SCORE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getSupportScore());
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Grounding info for a claim in the candidate and its support.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport)
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupportOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport.class,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport.Builder.class);
          }

          // Construct using
          // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            claimText_ = "";
            supportChunkIndices_ = emptyIntList();
            supportScore_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
                .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_GroundingSupport_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport
              getDefaultInstanceForType() {
            return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport
              build() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport
              buildPartial() {
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                result =
                    new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.claimText_ = claimText_;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              supportChunkIndices_.makeImmutable();
              result.supportChunkIndices_ = supportChunkIndices_;
            }
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.supportScore_ = supportScore_;
              to_bitField0_ |= 0x00000001;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport) {
              return mergeFrom(
                  (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                          .GroundingMetadata.GroundingSupport)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport
                  other) {
            if (other
                == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.getDefaultInstance()) return this;
            if (!other.getClaimText().isEmpty()) {
              claimText_ = other.claimText_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            if (!other.supportChunkIndices_.isEmpty()) {
              if (supportChunkIndices_.isEmpty()) {
                supportChunkIndices_ = other.supportChunkIndices_;
                supportChunkIndices_.makeImmutable();
                bitField0_ |= 0x00000002;
              } else {
                ensureSupportChunkIndicesIsMutable();
                supportChunkIndices_.addAll(other.supportChunkIndices_);
              }
              onChanged();
            }
            if (other.hasSupportScore()) {
              setSupportScore(other.getSupportScore());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      claimText_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 21:
                    {
                      supportScore_ = input.readFloat();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 21
                  case 24:
                    {
                      int v = input.readInt32();
                      ensureSupportChunkIndicesIsMutable();
                      supportChunkIndices_.addInt(v);
                      break;
                    } // case 24
                  case 26:
                    {
                      int length = input.readRawVarint32();
                      int limit = input.pushLimit(length);
                      ensureSupportChunkIndicesIsMutable();
                      while (input.getBytesUntilLimit() > 0) {
                        supportChunkIndices_.addInt(input.readInt32());
                      }
                      input.popLimit(limit);
                      break;
                    } // case 26
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object claimText_ = "";
          /**
           *
           *
           * <pre>
           * Text for the claim in the candidate. Always provided when a
           * support is found.
           * </pre>
           *
           * <code>string claim_text = 1;</code>
           *
           * @return The claimText.
           */
          public java.lang.String getClaimText() {
            java.lang.Object ref = claimText_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              claimText_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Text for the claim in the candidate. Always provided when a
           * support is found.
           * </pre>
           *
           * <code>string claim_text = 1;</code>
           *
           * @return The bytes for claimText.
           */
          public com.google.protobuf.ByteString getClaimTextBytes() {
            java.lang.Object ref = claimText_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              claimText_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Text for the claim in the candidate. Always provided when a
           * support is found.
           * </pre>
           *
           * <code>string claim_text = 1;</code>
           *
           * @param value The claimText to set.
           * @return This builder for chaining.
           */
          public Builder setClaimText(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            claimText_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Text for the claim in the candidate. Always provided when a
           * support is found.
           * </pre>
           *
           * <code>string claim_text = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearClaimText() {
            claimText_ = getDefaultInstance().getClaimText();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Text for the claim in the candidate. Always provided when a
           * support is found.
           * </pre>
           *
           * <code>string claim_text = 1;</code>
           *
           * @param value The bytes for claimText to set.
           * @return This builder for chaining.
           */
          public Builder setClaimTextBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            claimText_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          private com.google.protobuf.Internal.IntList supportChunkIndices_ = emptyIntList();

          private void ensureSupportChunkIndicesIsMutable() {
            if (!supportChunkIndices_.isModifiable()) {
              supportChunkIndices_ = makeMutableCopy(supportChunkIndices_);
            }
            bitField0_ |= 0x00000002;
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @return A list containing the supportChunkIndices.
           */
          public java.util.List<java.lang.Integer> getSupportChunkIndicesList() {
            supportChunkIndices_.makeImmutable();
            return supportChunkIndices_;
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @return The count of supportChunkIndices.
           */
          public int getSupportChunkIndicesCount() {
            return supportChunkIndices_.size();
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @param index The index of the element to return.
           * @return The supportChunkIndices at the given index.
           */
          public int getSupportChunkIndices(int index) {
            return supportChunkIndices_.getInt(index);
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @param index The index to set the value at.
           * @param value The supportChunkIndices to set.
           * @return This builder for chaining.
           */
          public Builder setSupportChunkIndices(int index, int value) {

            ensureSupportChunkIndicesIsMutable();
            supportChunkIndices_.setInt(index, value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @param value The supportChunkIndices to add.
           * @return This builder for chaining.
           */
          public Builder addSupportChunkIndices(int value) {

            ensureSupportChunkIndicesIsMutable();
            supportChunkIndices_.addInt(value);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @param values The supportChunkIndices to add.
           * @return This builder for chaining.
           */
          public Builder addAllSupportChunkIndices(
              java.lang.Iterable<? extends java.lang.Integer> values) {
            ensureSupportChunkIndicesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportChunkIndices_);
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * A list of indices (into 'support_chunks') specifying the
           * citations associated with the claim. For instance [1,3,4] means
           * that support_chunks[1], support_chunks[3],
           * support_chunks[4] are the chunks attributed to the claim.
           * </pre>
           *
           * <code>repeated int32 support_chunk_indices = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSupportChunkIndices() {
            supportChunkIndices_ = emptyIntList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
            return this;
          }

          private float supportScore_;
          /**
           *
           *
           * <pre>
           * A score in the range of [0, 1] describing how grounded is a specific
           * claim in the support chunks indicated.
           * Higher value means that the claim is better supported by the chunks.
           * </pre>
           *
           * <code>optional float support_score = 2;</code>
           *
           * @return Whether the supportScore field is set.
           */
          @java.lang.Override
          public boolean hasSupportScore() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           *
           *
           * <pre>
           * A score in the range of [0, 1] describing how grounded is a specific
           * claim in the support chunks indicated.
           * Higher value means that the claim is better supported by the chunks.
           * </pre>
           *
           * <code>optional float support_score = 2;</code>
           *
           * @return The supportScore.
           */
          @java.lang.Override
          public float getSupportScore() {
            return supportScore_;
          }
          /**
           *
           *
           * <pre>
           * A score in the range of [0, 1] describing how grounded is a specific
           * claim in the support chunks indicated.
           * Higher value means that the claim is better supported by the chunks.
           * </pre>
           *
           * <code>optional float support_score = 2;</code>
           *
           * @param value The supportScore to set.
           * @return This builder for chaining.
           */
          public Builder setSupportScore(float value) {

            supportScore_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * A score in the range of [0, 1] describing how grounded is a specific
           * claim in the support chunks indicated.
           * Higher value means that the claim is better supported by the chunks.
           * </pre>
           *
           * <code>optional float support_score = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSupportScore() {
            bitField0_ = (bitField0_ & ~0x00000004);
            supportScore_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport)
        private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport();
        }

        public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .Candidate.GroundingMetadata.GroundingSupport
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<GroundingSupport> PARSER =
            new com.google.protobuf.AbstractParser<GroundingSupport>() {
              @java.lang.Override
              public GroundingSupport parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<GroundingSupport> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<GroundingSupport> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int RETRIEVAL_METADATA_FIELD_NUMBER = 5;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata>
          retrievalMetadata_;
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.RetrievalMetadata>
          getRetrievalMetadataList() {
        return retrievalMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadataOrBuilder>
          getRetrievalMetadataOrBuilderList() {
        return retrievalMetadata_;
      }
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      @java.lang.Override
      public int getRetrievalMetadataCount() {
        return retrievalMetadata_.size();
      }
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.RetrievalMetadata
          getRetrievalMetadata(int index) {
        return retrievalMetadata_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Retrieval metadata to provide an understanding in the
       * retrieval steps performed by the model. There can be multiple such
       * messages which can correspond to different parts of the retrieval. This
       * is a mechanism used to ensure transparency to our users.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.RetrievalMetadataOrBuilder
          getRetrievalMetadataOrBuilder(int index) {
        return retrievalMetadata_.get(index);
      }

      public static final int SUPPORT_CHUNKS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> supportChunks_;
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      @java.lang.Override
      public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk>
          getSupportChunksList() {
        return supportChunks_;
      }
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
          getSupportChunksOrBuilderList() {
        return supportChunks_;
      }
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      @java.lang.Override
      public int getSupportChunksCount() {
        return supportChunks_.size();
      }
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.FactChunk getSupportChunks(int index) {
        return supportChunks_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of chunks to be attributed across all claims in the candidate.
       * These are derived from the grounding sources supplied in the request.
       * </pre>
       *
       * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder getSupportChunksOrBuilder(
          int index) {
        return supportChunks_.get(index);
      }

      public static final int WEB_SEARCH_QUERIES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList webSearchQueries_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @return A list containing the webSearchQueries.
       */
      public com.google.protobuf.ProtocolStringList getWebSearchQueriesList() {
        return webSearchQueries_;
      }
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @return The count of webSearchQueries.
       */
      public int getWebSearchQueriesCount() {
        return webSearchQueries_.size();
      }
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The webSearchQueries at the given index.
       */
      public java.lang.String getWebSearchQueries(int index) {
        return webSearchQueries_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Web search queries for the following-up web search.
       * </pre>
       *
       * <code>repeated string web_search_queries = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the webSearchQueries at the given index.
       */
      public com.google.protobuf.ByteString getWebSearchQueriesBytes(int index) {
        return webSearchQueries_.getByteString(index);
      }

      public static final int SEARCH_ENTRY_POINT_FIELD_NUMBER = 4;
      private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.SearchEntryPoint
          searchEntryPoint_;
      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       *
       * @return Whether the searchEntryPoint field is set.
       */
      @java.lang.Override
      public boolean hasSearchEntryPoint() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       *
       * @return The searchEntryPoint.
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.SearchEntryPoint
          getSearchEntryPoint() {
        return searchEntryPoint_ == null
            ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint.getDefaultInstance()
            : searchEntryPoint_;
      }
      /**
       *
       *
       * <pre>
       * Google search entry for the following-up web searches.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.SearchEntryPointOrBuilder
          getSearchEntryPointOrBuilder() {
        return searchEntryPoint_ == null
            ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint.getDefaultInstance()
            : searchEntryPoint_;
      }

      public static final int GROUNDING_SUPPORT_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport>
          groundingSupport_;
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.GroundingSupport>
          getGroundingSupportList() {
        return groundingSupport_;
      }
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupportOrBuilder>
          getGroundingSupportOrBuilderList() {
        return groundingSupport_;
      }
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      @java.lang.Override
      public int getGroundingSupportCount() {
        return groundingSupport_.size();
      }
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.GroundingSupport
          getGroundingSupport(int index) {
        return groundingSupport_.get(index);
      }
      /**
       *
       *
       * <pre>
       * GroundingSupport across all claims in the answer candidate.
       * An support to a fact indicates that the claim is supported by
       * the fact.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.GroundingSupportOrBuilder
          getGroundingSupportOrBuilder(int index) {
        return groundingSupport_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < supportChunks_.size(); i++) {
          output.writeMessage(1, supportChunks_.get(i));
        }
        for (int i = 0; i < groundingSupport_.size(); i++) {
          output.writeMessage(2, groundingSupport_.get(i));
        }
        for (int i = 0; i < webSearchQueries_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 3, webSearchQueries_.getRaw(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(4, getSearchEntryPoint());
        }
        for (int i = 0; i < retrievalMetadata_.size(); i++) {
          output.writeMessage(5, retrievalMetadata_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < supportChunks_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, supportChunks_.get(i));
        }
        for (int i = 0; i < groundingSupport_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(2, groundingSupport_.get(i));
        }
        {
          int dataSize = 0;
          for (int i = 0; i < webSearchQueries_.size(); i++) {
            dataSize += computeStringSizeNoTag(webSearchQueries_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getWebSearchQueriesList().size();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSearchEntryPoint());
        }
        for (int i = 0; i < retrievalMetadata_.size(); i++) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  5, retrievalMetadata_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata)) {
          return super.equals(obj);
        }
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata
            other =
                (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                        .GroundingMetadata)
                    obj;

        if (!getRetrievalMetadataList().equals(other.getRetrievalMetadataList())) return false;
        if (!getSupportChunksList().equals(other.getSupportChunksList())) return false;
        if (!getWebSearchQueriesList().equals(other.getWebSearchQueriesList())) return false;
        if (hasSearchEntryPoint() != other.hasSearchEntryPoint()) return false;
        if (hasSearchEntryPoint()) {
          if (!getSearchEntryPoint().equals(other.getSearchEntryPoint())) return false;
        }
        if (!getGroundingSupportList().equals(other.getGroundingSupportList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getRetrievalMetadataCount() > 0) {
          hash = (37 * hash) + RETRIEVAL_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getRetrievalMetadataList().hashCode();
        }
        if (getSupportChunksCount() > 0) {
          hash = (37 * hash) + SUPPORT_CHUNKS_FIELD_NUMBER;
          hash = (53 * hash) + getSupportChunksList().hashCode();
        }
        if (getWebSearchQueriesCount() > 0) {
          hash = (37 * hash) + WEB_SEARCH_QUERIES_FIELD_NUMBER;
          hash = (53 * hash) + getWebSearchQueriesList().hashCode();
        }
        if (hasSearchEntryPoint()) {
          hash = (37 * hash) + SEARCH_ENTRY_POINT_FIELD_NUMBER;
          hash = (53 * hash) + getSearchEntryPoint().hashCode();
        }
        if (getGroundingSupportCount() > 0) {
          hash = (37 * hash) + GROUNDING_SUPPORT_FIELD_NUMBER;
          hash = (53 * hash) + getGroundingSupportList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Citation for the generated content.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata)
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.class,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.Builder.class);
        }

        // Construct using
        // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getRetrievalMetadataFieldBuilder();
            getSupportChunksFieldBuilder();
            getSearchEntryPointFieldBuilder();
            getGroundingSupportFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (retrievalMetadataBuilder_ == null) {
            retrievalMetadata_ = java.util.Collections.emptyList();
          } else {
            retrievalMetadata_ = null;
            retrievalMetadataBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          if (supportChunksBuilder_ == null) {
            supportChunks_ = java.util.Collections.emptyList();
          } else {
            supportChunks_ = null;
            supportChunksBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
          searchEntryPoint_ = null;
          if (searchEntryPointBuilder_ != null) {
            searchEntryPointBuilder_.dispose();
            searchEntryPointBuilder_ = null;
          }
          if (groundingSupportBuilder_ == null) {
            groundingSupport_ = java.util.Collections.emptyList();
          } else {
            groundingSupport_ = null;
            groundingSupportBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000010);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
              .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_GroundingMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata
            getDefaultInstanceForType() {
          return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata
            build() {
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata
            buildPartial() {
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata
              result =
                  new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata
                result) {
          if (retrievalMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              retrievalMetadata_ = java.util.Collections.unmodifiableList(retrievalMetadata_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.retrievalMetadata_ = retrievalMetadata_;
          } else {
            result.retrievalMetadata_ = retrievalMetadataBuilder_.build();
          }
          if (supportChunksBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              supportChunks_ = java.util.Collections.unmodifiableList(supportChunks_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.supportChunks_ = supportChunks_;
          } else {
            result.supportChunks_ = supportChunksBuilder_.build();
          }
          if (groundingSupportBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0)) {
              groundingSupport_ = java.util.Collections.unmodifiableList(groundingSupport_);
              bitField0_ = (bitField0_ & ~0x00000010);
            }
            result.groundingSupport_ = groundingSupport_;
          } else {
            result.groundingSupport_ = groundingSupportBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            webSearchQueries_.makeImmutable();
            result.webSearchQueries_ = webSearchQueries_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.searchEntryPoint_ =
                searchEntryPointBuilder_ == null
                    ? searchEntryPoint_
                    : searchEntryPointBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata) {
            return mergeFrom(
                (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                        .GroundingMetadata)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata
                other) {
          if (other
              == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.getDefaultInstance()) return this;
          if (retrievalMetadataBuilder_ == null) {
            if (!other.retrievalMetadata_.isEmpty()) {
              if (retrievalMetadata_.isEmpty()) {
                retrievalMetadata_ = other.retrievalMetadata_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureRetrievalMetadataIsMutable();
                retrievalMetadata_.addAll(other.retrievalMetadata_);
              }
              onChanged();
            }
          } else {
            if (!other.retrievalMetadata_.isEmpty()) {
              if (retrievalMetadataBuilder_.isEmpty()) {
                retrievalMetadataBuilder_.dispose();
                retrievalMetadataBuilder_ = null;
                retrievalMetadata_ = other.retrievalMetadata_;
                bitField0_ = (bitField0_ & ~0x00000001);
                retrievalMetadataBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getRetrievalMetadataFieldBuilder()
                        : null;
              } else {
                retrievalMetadataBuilder_.addAllMessages(other.retrievalMetadata_);
              }
            }
          }
          if (supportChunksBuilder_ == null) {
            if (!other.supportChunks_.isEmpty()) {
              if (supportChunks_.isEmpty()) {
                supportChunks_ = other.supportChunks_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureSupportChunksIsMutable();
                supportChunks_.addAll(other.supportChunks_);
              }
              onChanged();
            }
          } else {
            if (!other.supportChunks_.isEmpty()) {
              if (supportChunksBuilder_.isEmpty()) {
                supportChunksBuilder_.dispose();
                supportChunksBuilder_ = null;
                supportChunks_ = other.supportChunks_;
                bitField0_ = (bitField0_ & ~0x00000002);
                supportChunksBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getSupportChunksFieldBuilder()
                        : null;
              } else {
                supportChunksBuilder_.addAllMessages(other.supportChunks_);
              }
            }
          }
          if (!other.webSearchQueries_.isEmpty()) {
            if (webSearchQueries_.isEmpty()) {
              webSearchQueries_ = other.webSearchQueries_;
              bitField0_ |= 0x00000004;
            } else {
              ensureWebSearchQueriesIsMutable();
              webSearchQueries_.addAll(other.webSearchQueries_);
            }
            onChanged();
          }
          if (other.hasSearchEntryPoint()) {
            mergeSearchEntryPoint(other.getSearchEntryPoint());
          }
          if (groundingSupportBuilder_ == null) {
            if (!other.groundingSupport_.isEmpty()) {
              if (groundingSupport_.isEmpty()) {
                groundingSupport_ = other.groundingSupport_;
                bitField0_ = (bitField0_ & ~0x00000010);
              } else {
                ensureGroundingSupportIsMutable();
                groundingSupport_.addAll(other.groundingSupport_);
              }
              onChanged();
            }
          } else {
            if (!other.groundingSupport_.isEmpty()) {
              if (groundingSupportBuilder_.isEmpty()) {
                groundingSupportBuilder_.dispose();
                groundingSupportBuilder_ = null;
                groundingSupport_ = other.groundingSupport_;
                bitField0_ = (bitField0_ & ~0x00000010);
                groundingSupportBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getGroundingSupportFieldBuilder()
                        : null;
              } else {
                groundingSupportBuilder_.addAllMessages(other.groundingSupport_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.cloud.discoveryengine.v1beta.FactChunk m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.FactChunk.parser(),
                            extensionRegistry);
                    if (supportChunksBuilder_ == null) {
                      ensureSupportChunksIsMutable();
                      supportChunks_.add(m);
                    } else {
                      supportChunksBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                            .Candidate.GroundingMetadata.GroundingSupport
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1beta
                                    .GenerateGroundedContentResponse.Candidate.GroundingMetadata
                                    .GroundingSupport.parser(),
                                extensionRegistry);
                    if (groundingSupportBuilder_ == null) {
                      ensureGroundingSupportIsMutable();
                      groundingSupport_.add(m);
                    } else {
                      groundingSupportBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureWebSearchQueriesIsMutable();
                    webSearchQueries_.add(s);
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(
                        getSearchEntryPointFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                case 42:
                  {
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                            .Candidate.GroundingMetadata.RetrievalMetadata
                        m =
                            input.readMessage(
                                com.google.cloud.discoveryengine.v1beta
                                    .GenerateGroundedContentResponse.Candidate.GroundingMetadata
                                    .RetrievalMetadata.parser(),
                                extensionRegistry);
                    if (retrievalMetadataBuilder_ == null) {
                      ensureRetrievalMetadataIsMutable();
                      retrievalMetadata_.add(m);
                    } else {
                      retrievalMetadataBuilder_.addMessage(m);
                    }
                    break;
                  } // case 42
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata>
            retrievalMetadata_ = java.util.Collections.emptyList();

        private void ensureRetrievalMetadataIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            retrievalMetadata_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata>(retrievalMetadata_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadataOrBuilder>
            retrievalMetadataBuilder_;

        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata>
            getRetrievalMetadataList() {
          if (retrievalMetadataBuilder_ == null) {
            return java.util.Collections.unmodifiableList(retrievalMetadata_);
          } else {
            return retrievalMetadataBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public int getRetrievalMetadataCount() {
          if (retrievalMetadataBuilder_ == null) {
            return retrievalMetadata_.size();
          } else {
            return retrievalMetadataBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata
            getRetrievalMetadata(int index) {
          if (retrievalMetadataBuilder_ == null) {
            return retrievalMetadata_.get(index);
          } else {
            return retrievalMetadataBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder setRetrievalMetadata(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                value) {
          if (retrievalMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.set(index, value);
            onChanged();
          } else {
            retrievalMetadataBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder setRetrievalMetadata(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder
                builderForValue) {
          if (retrievalMetadataBuilder_ == null) {
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.set(index, builderForValue.build());
            onChanged();
          } else {
            retrievalMetadataBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder addRetrievalMetadata(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                value) {
          if (retrievalMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.add(value);
            onChanged();
          } else {
            retrievalMetadataBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder addRetrievalMetadata(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata
                value) {
          if (retrievalMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.add(index, value);
            onChanged();
          } else {
            retrievalMetadataBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder addRetrievalMetadata(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder
                builderForValue) {
          if (retrievalMetadataBuilder_ == null) {
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.add(builderForValue.build());
            onChanged();
          } else {
            retrievalMetadataBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder addRetrievalMetadata(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder
                builderForValue) {
          if (retrievalMetadataBuilder_ == null) {
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.add(index, builderForValue.build());
            onChanged();
          } else {
            retrievalMetadataBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder addAllRetrievalMetadata(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                            .Candidate.GroundingMetadata.RetrievalMetadata>
                values) {
          if (retrievalMetadataBuilder_ == null) {
            ensureRetrievalMetadataIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, retrievalMetadata_);
            onChanged();
          } else {
            retrievalMetadataBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder clearRetrievalMetadata() {
          if (retrievalMetadataBuilder_ == null) {
            retrievalMetadata_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            retrievalMetadataBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public Builder removeRetrievalMetadata(int index) {
          if (retrievalMetadataBuilder_ == null) {
            ensureRetrievalMetadataIsMutable();
            retrievalMetadata_.remove(index);
            onChanged();
          } else {
            retrievalMetadataBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.Builder
            getRetrievalMetadataBuilder(int index) {
          return getRetrievalMetadataFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadataOrBuilder
            getRetrievalMetadataOrBuilder(int index) {
          if (retrievalMetadataBuilder_ == null) {
            return retrievalMetadata_.get(index);
          } else {
            return retrievalMetadataBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadataOrBuilder>
            getRetrievalMetadataOrBuilderList() {
          if (retrievalMetadataBuilder_ != null) {
            return retrievalMetadataBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(retrievalMetadata_);
          }
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.Builder
            addRetrievalMetadataBuilder() {
          return getRetrievalMetadataFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.RetrievalMetadata.Builder
            addRetrievalMetadataBuilder(int index) {
          return getRetrievalMetadataFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.RetrievalMetadata.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * Retrieval metadata to provide an understanding in the
         * retrieval steps performed by the model. There can be multiple such
         * messages which can correspond to different parts of the retrieval. This
         * is a mechanism used to ensure transparency to our users.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.RetrievalMetadata retrieval_metadata = 5;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder>
            getRetrievalMetadataBuilderList() {
          return getRetrievalMetadataFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadata.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.RetrievalMetadataOrBuilder>
            getRetrievalMetadataFieldBuilder() {
          if (retrievalMetadataBuilder_ == null) {
            retrievalMetadataBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadata.Builder,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.RetrievalMetadataOrBuilder>(
                    retrievalMetadata_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            retrievalMetadata_ = null;
          }
          return retrievalMetadataBuilder_;
        }

        private java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk> supportChunks_ =
            java.util.Collections.emptyList();

        private void ensureSupportChunksIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            supportChunks_ =
                new java.util.ArrayList<com.google.cloud.discoveryengine.v1beta.FactChunk>(
                    supportChunks_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.FactChunk,
                com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
                com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
            supportChunksBuilder_;

        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk>
            getSupportChunksList() {
          if (supportChunksBuilder_ == null) {
            return java.util.Collections.unmodifiableList(supportChunks_);
          } else {
            return supportChunksBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public int getSupportChunksCount() {
          if (supportChunksBuilder_ == null) {
            return supportChunks_.size();
          } else {
            return supportChunksBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.FactChunk getSupportChunks(int index) {
          if (supportChunksBuilder_ == null) {
            return supportChunks_.get(index);
          } else {
            return supportChunksBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder setSupportChunks(
            int index, com.google.cloud.discoveryengine.v1beta.FactChunk value) {
          if (supportChunksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSupportChunksIsMutable();
            supportChunks_.set(index, value);
            onChanged();
          } else {
            supportChunksBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder setSupportChunks(
            int index, com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
          if (supportChunksBuilder_ == null) {
            ensureSupportChunksIsMutable();
            supportChunks_.set(index, builderForValue.build());
            onChanged();
          } else {
            supportChunksBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder addSupportChunks(com.google.cloud.discoveryengine.v1beta.FactChunk value) {
          if (supportChunksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSupportChunksIsMutable();
            supportChunks_.add(value);
            onChanged();
          } else {
            supportChunksBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder addSupportChunks(
            int index, com.google.cloud.discoveryengine.v1beta.FactChunk value) {
          if (supportChunksBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureSupportChunksIsMutable();
            supportChunks_.add(index, value);
            onChanged();
          } else {
            supportChunksBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder addSupportChunks(
            com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
          if (supportChunksBuilder_ == null) {
            ensureSupportChunksIsMutable();
            supportChunks_.add(builderForValue.build());
            onChanged();
          } else {
            supportChunksBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder addSupportChunks(
            int index, com.google.cloud.discoveryengine.v1beta.FactChunk.Builder builderForValue) {
          if (supportChunksBuilder_ == null) {
            ensureSupportChunksIsMutable();
            supportChunks_.add(index, builderForValue.build());
            onChanged();
          } else {
            supportChunksBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder addAllSupportChunks(
            java.lang.Iterable<? extends com.google.cloud.discoveryengine.v1beta.FactChunk>
                values) {
          if (supportChunksBuilder_ == null) {
            ensureSupportChunksIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportChunks_);
            onChanged();
          } else {
            supportChunksBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder clearSupportChunks() {
          if (supportChunksBuilder_ == null) {
            supportChunks_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            supportChunksBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public Builder removeSupportChunks(int index) {
          if (supportChunksBuilder_ == null) {
            ensureSupportChunksIsMutable();
            supportChunks_.remove(index);
            onChanged();
          } else {
            supportChunksBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder getSupportChunksBuilder(
            int index) {
          return getSupportChunksFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder getSupportChunksOrBuilder(
            int index) {
          if (supportChunksBuilder_ == null) {
            return supportChunks_.get(index);
          } else {
            return supportChunksBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public java.util.List<? extends com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
            getSupportChunksOrBuilderList() {
          if (supportChunksBuilder_ != null) {
            return supportChunksBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(supportChunks_);
          }
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder addSupportChunksBuilder() {
          return getSupportChunksFieldBuilder()
              .addBuilder(com.google.cloud.discoveryengine.v1beta.FactChunk.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public com.google.cloud.discoveryengine.v1beta.FactChunk.Builder addSupportChunksBuilder(
            int index) {
          return getSupportChunksFieldBuilder()
              .addBuilder(
                  index, com.google.cloud.discoveryengine.v1beta.FactChunk.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * List of chunks to be attributed across all claims in the candidate.
         * These are derived from the grounding sources supplied in the request.
         * </pre>
         *
         * <code>repeated .google.cloud.discoveryengine.v1beta.FactChunk support_chunks = 1;</code>
         */
        public java.util.List<com.google.cloud.discoveryengine.v1beta.FactChunk.Builder>
            getSupportChunksBuilderList() {
          return getSupportChunksFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.FactChunk,
                com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
                com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>
            getSupportChunksFieldBuilder() {
          if (supportChunksBuilder_ == null) {
            supportChunksBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.FactChunk,
                    com.google.cloud.discoveryengine.v1beta.FactChunk.Builder,
                    com.google.cloud.discoveryengine.v1beta.FactChunkOrBuilder>(
                    supportChunks_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            supportChunks_ = null;
          }
          return supportChunksBuilder_;
        }

        private com.google.protobuf.LazyStringArrayList webSearchQueries_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureWebSearchQueriesIsMutable() {
          if (!webSearchQueries_.isModifiable()) {
            webSearchQueries_ = new com.google.protobuf.LazyStringArrayList(webSearchQueries_);
          }
          bitField0_ |= 0x00000004;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @return A list containing the webSearchQueries.
         */
        public com.google.protobuf.ProtocolStringList getWebSearchQueriesList() {
          webSearchQueries_.makeImmutable();
          return webSearchQueries_;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @return The count of webSearchQueries.
         */
        public int getWebSearchQueriesCount() {
          return webSearchQueries_.size();
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param index The index of the element to return.
         * @return The webSearchQueries at the given index.
         */
        public java.lang.String getWebSearchQueries(int index) {
          return webSearchQueries_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the webSearchQueries at the given index.
         */
        public com.google.protobuf.ByteString getWebSearchQueriesBytes(int index) {
          return webSearchQueries_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param index The index to set the value at.
         * @param value The webSearchQueries to set.
         * @return This builder for chaining.
         */
        public Builder setWebSearchQueries(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWebSearchQueriesIsMutable();
          webSearchQueries_.set(index, value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param value The webSearchQueries to add.
         * @return This builder for chaining.
         */
        public Builder addWebSearchQueries(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWebSearchQueriesIsMutable();
          webSearchQueries_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param values The webSearchQueries to add.
         * @return This builder for chaining.
         */
        public Builder addAllWebSearchQueries(java.lang.Iterable<java.lang.String> values) {
          ensureWebSearchQueriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, webSearchQueries_);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearWebSearchQueries() {
          webSearchQueries_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Web search queries for the following-up web search.
         * </pre>
         *
         * <code>repeated string web_search_queries = 3;</code>
         *
         * @param value The bytes of the webSearchQueries to add.
         * @return This builder for chaining.
         */
        public Builder addWebSearchQueriesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureWebSearchQueriesIsMutable();
          webSearchQueries_.add(value);
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint
            searchEntryPoint_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPointOrBuilder>
            searchEntryPointBuilder_;
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         *
         * @return Whether the searchEntryPoint field is set.
         */
        public boolean hasSearchEntryPoint() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         *
         * @return The searchEntryPoint.
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint
            getSearchEntryPoint() {
          if (searchEntryPointBuilder_ == null) {
            return searchEntryPoint_ == null
                ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.getDefaultInstance()
                : searchEntryPoint_;
          } else {
            return searchEntryPointBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public Builder setSearchEntryPoint(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint
                value) {
          if (searchEntryPointBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            searchEntryPoint_ = value;
          } else {
            searchEntryPointBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public Builder setSearchEntryPoint(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.Builder
                builderForValue) {
          if (searchEntryPointBuilder_ == null) {
            searchEntryPoint_ = builderForValue.build();
          } else {
            searchEntryPointBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public Builder mergeSearchEntryPoint(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint
                value) {
          if (searchEntryPointBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && searchEntryPoint_ != null
                && searchEntryPoint_
                    != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint.getDefaultInstance()) {
              getSearchEntryPointBuilder().mergeFrom(value);
            } else {
              searchEntryPoint_ = value;
            }
          } else {
            searchEntryPointBuilder_.mergeFrom(value);
          }
          if (searchEntryPoint_ != null) {
            bitField0_ |= 0x00000008;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public Builder clearSearchEntryPoint() {
          bitField0_ = (bitField0_ & ~0x00000008);
          searchEntryPoint_ = null;
          if (searchEntryPointBuilder_ != null) {
            searchEntryPointBuilder_.dispose();
            searchEntryPointBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPoint.Builder
            getSearchEntryPointBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getSearchEntryPointFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.SearchEntryPointOrBuilder
            getSearchEntryPointOrBuilder() {
          if (searchEntryPointBuilder_ != null) {
            return searchEntryPointBuilder_.getMessageOrBuilder();
          } else {
            return searchEntryPoint_ == null
                ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.getDefaultInstance()
                : searchEntryPoint_;
          }
        }
        /**
         *
         *
         * <pre>
         * Google search entry for the following-up web searches.
         * </pre>
         *
         * <code>
         * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.SearchEntryPoint search_entry_point = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPoint.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.SearchEntryPointOrBuilder>
            getSearchEntryPointFieldBuilder() {
          if (searchEntryPointBuilder_ == null) {
            searchEntryPointBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPoint.Builder,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.SearchEntryPointOrBuilder>(
                    getSearchEntryPoint(), getParentForChildren(), isClean());
            searchEntryPoint_ = null;
          }
          return searchEntryPointBuilder_;
        }

        private java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport>
            groundingSupport_ = java.util.Collections.emptyList();

        private void ensureGroundingSupportIsMutable() {
          if (!((bitField0_ & 0x00000010) != 0)) {
            groundingSupport_ =
                new java.util.ArrayList<
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport>(groundingSupport_);
            bitField0_ |= 0x00000010;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupportOrBuilder>
            groundingSupportBuilder_;

        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport>
            getGroundingSupportList() {
          if (groundingSupportBuilder_ == null) {
            return java.util.Collections.unmodifiableList(groundingSupport_);
          } else {
            return groundingSupportBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public int getGroundingSupportCount() {
          if (groundingSupportBuilder_ == null) {
            return groundingSupport_.size();
          } else {
            return groundingSupportBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport
            getGroundingSupport(int index) {
          if (groundingSupportBuilder_ == null) {
            return groundingSupport_.get(index);
          } else {
            return groundingSupportBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder setGroundingSupport(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                value) {
          if (groundingSupportBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingSupportIsMutable();
            groundingSupport_.set(index, value);
            onChanged();
          } else {
            groundingSupportBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder setGroundingSupport(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder
                builderForValue) {
          if (groundingSupportBuilder_ == null) {
            ensureGroundingSupportIsMutable();
            groundingSupport_.set(index, builderForValue.build());
            onChanged();
          } else {
            groundingSupportBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder addGroundingSupport(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                value) {
          if (groundingSupportBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingSupportIsMutable();
            groundingSupport_.add(value);
            onChanged();
          } else {
            groundingSupportBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder addGroundingSupport(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport
                value) {
          if (groundingSupportBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureGroundingSupportIsMutable();
            groundingSupport_.add(index, value);
            onChanged();
          } else {
            groundingSupportBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder addGroundingSupport(
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder
                builderForValue) {
          if (groundingSupportBuilder_ == null) {
            ensureGroundingSupportIsMutable();
            groundingSupport_.add(builderForValue.build());
            onChanged();
          } else {
            groundingSupportBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder addGroundingSupport(
            int index,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder
                builderForValue) {
          if (groundingSupportBuilder_ == null) {
            ensureGroundingSupportIsMutable();
            groundingSupport_.add(index, builderForValue.build());
            onChanged();
          } else {
            groundingSupportBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder addAllGroundingSupport(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                            .Candidate.GroundingMetadata.GroundingSupport>
                values) {
          if (groundingSupportBuilder_ == null) {
            ensureGroundingSupportIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groundingSupport_);
            onChanged();
          } else {
            groundingSupportBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder clearGroundingSupport() {
          if (groundingSupportBuilder_ == null) {
            groundingSupport_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000010);
            onChanged();
          } else {
            groundingSupportBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public Builder removeGroundingSupport(int index) {
          if (groundingSupportBuilder_ == null) {
            ensureGroundingSupportIsMutable();
            groundingSupport_.remove(index);
            onChanged();
          } else {
            groundingSupportBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport.Builder
            getGroundingSupportBuilder(int index) {
          return getGroundingSupportFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupportOrBuilder
            getGroundingSupportOrBuilder(int index) {
          if (groundingSupportBuilder_ == null) {
            return groundingSupport_.get(index);
          } else {
            return groundingSupportBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupportOrBuilder>
            getGroundingSupportOrBuilderList() {
          if (groundingSupportBuilder_ != null) {
            return groundingSupportBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(groundingSupport_);
          }
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport.Builder
            addGroundingSupportBuilder() {
          return getGroundingSupportFieldBuilder()
              .addBuilder(
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata.GroundingSupport.Builder
            addGroundingSupportBuilder(int index) {
          return getGroundingSupportFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.GroundingSupport.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * GroundingSupport across all claims in the answer candidate.
         * An support to a fact indicates that the claim is supported by
         * the fact.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata.GroundingSupport grounding_support = 2;
         * </code>
         */
        public java.util.List<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder>
            getGroundingSupportBuilderList() {
          return getGroundingSupportFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupport.Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .GroundingMetadata.GroundingSupportOrBuilder>
            getGroundingSupportFieldBuilder() {
          if (groundingSupportBuilder_ == null) {
            groundingSupportBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupport.Builder,
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate.GroundingMetadata.GroundingSupportOrBuilder>(
                    groundingSupport_,
                    ((bitField0_ & 0x00000010) != 0),
                    getParentForChildren(),
                    isClean());
            groundingSupport_ = null;
          }
          return groundingSupportBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata)
      private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .GroundingMetadata();
      }

      public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .Candidate.GroundingMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<GroundingMetadata> PARSER =
          new com.google.protobuf.AbstractParser<GroundingMetadata>() {
            @java.lang.Override
            public GroundingMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<GroundingMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<GroundingMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int INDEX_FIELD_NUMBER = 1;
    private int index_ = 0;
    /**
     *
     *
     * <pre>
     * Index of the candidate.
     * </pre>
     *
     * <code>int32 index = 1;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public int getIndex() {
      return index_;
    }

    public static final int CONTENT_FIELD_NUMBER = 2;
    private com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content_;
    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     *
     * @return Whether the content field is set.
     */
    @java.lang.Override
    public boolean hasContent() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent getContent() {
      return content_ == null
          ? com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.getDefaultInstance()
          : content_;
    }
    /**
     *
     *
     * <pre>
     * Content of the candidate.
     * </pre>
     *
     * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder
        getContentOrBuilder() {
      return content_ == null
          ? com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.getDefaultInstance()
          : content_;
    }

    public static final int GROUNDING_SCORE_FIELD_NUMBER = 3;
    private float groundingScore_ = 0F;
    /**
     *
     *
     * <pre>
     * The overall grounding score for the candidate, in the range of [0, 1].
     * </pre>
     *
     * <code>optional float grounding_score = 3;</code>
     *
     * @return Whether the groundingScore field is set.
     */
    @java.lang.Override
    public boolean hasGroundingScore() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The overall grounding score for the candidate, in the range of [0, 1].
     * </pre>
     *
     * <code>optional float grounding_score = 3;</code>
     *
     * @return The groundingScore.
     */
    @java.lang.Override
    public float getGroundingScore() {
      return groundingScore_;
    }

    public static final int GROUNDING_METADATA_FIELD_NUMBER = 4;
    private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .GroundingMetadata
        groundingMetadata_;
    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     *
     * @return Whether the groundingMetadata field is set.
     */
    @java.lang.Override
    public boolean hasGroundingMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     *
     * @return The groundingMetadata.
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .GroundingMetadata
        getGroundingMetadata() {
      return groundingMetadata_ == null
          ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.getDefaultInstance()
          : groundingMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Grounding metadata for the generated content.
     * </pre>
     *
     * <code>
     * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .GroundingMetadataOrBuilder
        getGroundingMetadataOrBuilder() {
      return groundingMetadata_ == null
          ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.getDefaultInstance()
          : groundingMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (index_ != 0) {
        output.writeInt32(1, index_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getContent());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeFloat(3, groundingScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getGroundingMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (index_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, index_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getContent());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, groundingScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getGroundingMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)) {
        return super.equals(obj);
      }
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate other =
          (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate) obj;

      if (getIndex() != other.getIndex()) return false;
      if (hasContent() != other.hasContent()) return false;
      if (hasContent()) {
        if (!getContent().equals(other.getContent())) return false;
      }
      if (hasGroundingScore() != other.hasGroundingScore()) return false;
      if (hasGroundingScore()) {
        if (java.lang.Float.floatToIntBits(getGroundingScore())
            != java.lang.Float.floatToIntBits(other.getGroundingScore())) return false;
      }
      if (hasGroundingMetadata() != other.hasGroundingMetadata()) return false;
      if (hasGroundingMetadata()) {
        if (!getGroundingMetadata().equals(other.getGroundingMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex();
      if (hasContent()) {
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
      }
      if (hasGroundingScore()) {
        hash = (37 * hash) + GROUNDING_SCORE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getGroundingScore());
      }
      if (hasGroundingMetadata()) {
        hash = (37 * hash) + GROUNDING_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getGroundingMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A response candidate generated from the model.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.CandidateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .class,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContentFieldBuilder();
          getGroundingMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        index_ = 0;
        content_ = null;
        if (contentBuilder_ != null) {
          contentBuilder_.dispose();
          contentBuilder_ = null;
        }
        groundingScore_ = 0F;
        groundingMetadata_ = null;
        if (groundingMetadataBuilder_ != null) {
          groundingMetadataBuilder_.dispose();
          groundingMetadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
            .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_Candidate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
          getDefaultInstanceForType() {
        return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
          build() {
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
          buildPartial() {
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate result =
            new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.index_ = index_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.content_ = contentBuilder_ == null ? content_ : contentBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.groundingScore_ = groundingScore_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.groundingMetadata_ =
              groundingMetadataBuilder_ == null
                  ? groundingMetadata_
                  : groundingMetadataBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate) {
          return mergeFrom(
              (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate other) {
        if (other
            == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .getDefaultInstance()) return this;
        if (other.getIndex() != 0) {
          setIndex(other.getIndex());
        }
        if (other.hasContent()) {
          mergeContent(other.getContent());
        }
        if (other.hasGroundingScore()) {
          setGroundingScore(other.getGroundingScore());
        }
        if (other.hasGroundingMetadata()) {
          mergeGroundingMetadata(other.getGroundingMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  index_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getContentFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 29:
                {
                  groundingScore_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 34:
                {
                  input.readMessage(
                      getGroundingMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int index_;
      /**
       *
       *
       * <pre>
       * Index of the candidate.
       * </pre>
       *
       * <code>int32 index = 1;</code>
       *
       * @return The index.
       */
      @java.lang.Override
      public int getIndex() {
        return index_;
      }
      /**
       *
       *
       * <pre>
       * Index of the candidate.
       * </pre>
       *
       * <code>int32 index = 1;</code>
       *
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(int value) {

        index_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Index of the candidate.
       * </pre>
       *
       * <code>int32 index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        bitField0_ = (bitField0_ & ~0x00000001);
        index_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent,
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Builder,
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder>
          contentBuilder_;
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       *
       * @return Whether the content field is set.
       */
      public boolean hasContent() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       *
       * @return The content.
       */
      public com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent getContent() {
        if (contentBuilder_ == null) {
          return content_ == null
              ? com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent
                  .getDefaultInstance()
              : content_;
        } else {
          return contentBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public Builder setContent(
          com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent value) {
        if (contentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
        } else {
          contentBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public Builder setContent(
          com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Builder
              builderForValue) {
        if (contentBuilder_ == null) {
          content_ = builderForValue.build();
        } else {
          contentBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public Builder mergeContent(
          com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent value) {
        if (contentBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && content_ != null
              && content_
                  != com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent
                      .getDefaultInstance()) {
            getContentBuilder().mergeFrom(value);
          } else {
            content_ = value;
          }
        } else {
          contentBuilder_.mergeFrom(value);
        }
        if (content_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public Builder clearContent() {
        bitField0_ = (bitField0_ & ~0x00000002);
        content_ = null;
        if (contentBuilder_ != null) {
          contentBuilder_.dispose();
          contentBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Builder
          getContentBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getContentFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      public com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder
          getContentOrBuilder() {
        if (contentBuilder_ != null) {
          return contentBuilder_.getMessageOrBuilder();
        } else {
          return content_ == null
              ? com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent
                  .getDefaultInstance()
              : content_;
        }
      }
      /**
       *
       *
       * <pre>
       * Content of the candidate.
       * </pre>
       *
       * <code>.google.cloud.discoveryengine.v1beta.GroundedGenerationContent content = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent,
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Builder,
              com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder>
          getContentFieldBuilder() {
        if (contentBuilder_ == null) {
          contentBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent,
                  com.google.cloud.discoveryengine.v1beta.GroundedGenerationContent.Builder,
                  com.google.cloud.discoveryengine.v1beta.GroundedGenerationContentOrBuilder>(
                  getContent(), getParentForChildren(), isClean());
          content_ = null;
        }
        return contentBuilder_;
      }

      private float groundingScore_;
      /**
       *
       *
       * <pre>
       * The overall grounding score for the candidate, in the range of [0, 1].
       * </pre>
       *
       * <code>optional float grounding_score = 3;</code>
       *
       * @return Whether the groundingScore field is set.
       */
      @java.lang.Override
      public boolean hasGroundingScore() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The overall grounding score for the candidate, in the range of [0, 1].
       * </pre>
       *
       * <code>optional float grounding_score = 3;</code>
       *
       * @return The groundingScore.
       */
      @java.lang.Override
      public float getGroundingScore() {
        return groundingScore_;
      }
      /**
       *
       *
       * <pre>
       * The overall grounding score for the candidate, in the range of [0, 1].
       * </pre>
       *
       * <code>optional float grounding_score = 3;</code>
       *
       * @param value The groundingScore to set.
       * @return This builder for chaining.
       */
      public Builder setGroundingScore(float value) {

        groundingScore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The overall grounding score for the candidate, in the range of [0, 1].
       * </pre>
       *
       * <code>optional float grounding_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroundingScore() {
        bitField0_ = (bitField0_ & ~0x00000004);
        groundingScore_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata
          groundingMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.Builder,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadataOrBuilder>
          groundingMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       *
       * @return Whether the groundingMetadata field is set.
       */
      public boolean hasGroundingMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       *
       * @return The groundingMetadata.
       */
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata
          getGroundingMetadata() {
        if (groundingMetadataBuilder_ == null) {
          return groundingMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.getDefaultInstance()
              : groundingMetadata_;
        } else {
          return groundingMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public Builder setGroundingMetadata(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata
              value) {
        if (groundingMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          groundingMetadata_ = value;
        } else {
          groundingMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public Builder setGroundingMetadata(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.Builder
              builderForValue) {
        if (groundingMetadataBuilder_ == null) {
          groundingMetadata_ = builderForValue.build();
        } else {
          groundingMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public Builder mergeGroundingMetadata(
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata
              value) {
        if (groundingMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && groundingMetadata_ != null
              && groundingMetadata_
                  != com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                      .Candidate.GroundingMetadata.getDefaultInstance()) {
            getGroundingMetadataBuilder().mergeFrom(value);
          } else {
            groundingMetadata_ = value;
          }
        } else {
          groundingMetadataBuilder_.mergeFrom(value);
        }
        if (groundingMetadata_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public Builder clearGroundingMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        groundingMetadata_ = null;
        if (groundingMetadataBuilder_ != null) {
          groundingMetadataBuilder_.dispose();
          groundingMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadata.Builder
          getGroundingMetadataBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getGroundingMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
              .GroundingMetadataOrBuilder
          getGroundingMetadataOrBuilder() {
        if (groundingMetadataBuilder_ != null) {
          return groundingMetadataBuilder_.getMessageOrBuilder();
        } else {
          return groundingMetadata_ == null
              ? com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.getDefaultInstance()
              : groundingMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Grounding metadata for the generated content.
       * </pre>
       *
       * <code>
       * .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.GroundingMetadata grounding_metadata = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadata.Builder,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .GroundingMetadataOrBuilder>
          getGroundingMetadataFieldBuilder() {
        if (groundingMetadataBuilder_ == null) {
          groundingMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadata.Builder,
                  com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                      .GroundingMetadataOrBuilder>(
                  getGroundingMetadata(), getParentForChildren(), isClean());
          groundingMetadata_ = null;
        }
        return groundingMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate)
    private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
            .Candidate
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate();
    }

    public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Candidate> PARSER =
        new com.google.protobuf.AbstractParser<Candidate>() {
          @java.lang.Override
          public Candidate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Candidate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Candidate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CANDIDATES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate>
      candidates_;
  /**
   *
   *
   * <pre>
   * Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate>
      getCandidatesList() {
    return candidates_;
  }
  /**
   *
   *
   * <pre>
   * Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                  .CandidateOrBuilder>
      getCandidatesOrBuilderList() {
    return candidates_;
  }
  /**
   *
   *
   * <pre>
   * Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
   * </code>
   */
  @java.lang.Override
  public int getCandidatesCount() {
    return candidates_.size();
  }
  /**
   *
   *
   * <pre>
   * Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
      getCandidates(int index) {
    return candidates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Generated candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.CandidateOrBuilder
      getCandidatesOrBuilder(int index) {
    return candidates_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < candidates_.size(); i++) {
      output.writeMessage(1, candidates_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < candidates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, candidates_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse other =
        (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse) obj;

    if (!getCandidatesList().equals(other.getCandidatesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCandidatesCount() > 0) {
      hash = (37 * hash) + CANDIDATES_FIELD_NUMBER;
      hash = (53 * hash) + getCandidatesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for the `GenerateGroundedContent` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse)
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.class,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
      } else {
        candidates_ = null;
        candidatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.discoveryengine.v1beta.GroundedGenerationServiceProto
          .internal_static_google_cloud_discoveryengine_v1beta_GenerateGroundedContentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
        getDefaultInstanceForType() {
      return com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse build() {
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse buildPartial() {
      com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse result =
          new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse result) {
      if (candidatesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          candidates_ = java.util.Collections.unmodifiableList(candidates_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.candidates_ = candidates_;
      } else {
        result.candidates_ = candidatesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse) {
        return mergeFrom(
            (com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse other) {
      if (other
          == com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
              .getDefaultInstance()) return this;
      if (candidatesBuilder_ == null) {
        if (!other.candidates_.isEmpty()) {
          if (candidates_.isEmpty()) {
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCandidatesIsMutable();
            candidates_.addAll(other.candidates_);
          }
          onChanged();
        }
      } else {
        if (!other.candidates_.isEmpty()) {
          if (candidatesBuilder_.isEmpty()) {
            candidatesBuilder_.dispose();
            candidatesBuilder_ = null;
            candidates_ = other.candidates_;
            bitField0_ = (bitField0_ & ~0x00000001);
            candidatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCandidatesFieldBuilder()
                    : null;
          } else {
            candidatesBuilder_.addAllMessages(other.candidates_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    m =
                        input.readMessage(
                            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                                .Candidate.parser(),
                            extensionRegistry);
                if (candidatesBuilder_ == null) {
                  ensureCandidatesIsMutable();
                  candidates_.add(m);
                } else {
                  candidatesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate>
        candidates_ = java.util.Collections.emptyList();

    private void ensureCandidatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        candidates_ =
            new java.util.ArrayList<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate>(
                candidates_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .Builder,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .CandidateOrBuilder>
        candidatesBuilder_;

    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate>
        getCandidatesList() {
      if (candidatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(candidates_);
      } else {
        return candidatesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public int getCandidatesCount() {
      if (candidatesBuilder_ == null) {
        return candidates_.size();
      } else {
        return candidatesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
        getCandidates(int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder setCandidates(
        int index,
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.set(index, value);
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder setCandidates(
        int index,
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
            builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.set(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder addCandidates(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder addCandidates(
        int index,
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate value) {
      if (candidatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCandidatesIsMutable();
        candidates_.add(index, value);
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder addCandidates(
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
            builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder addCandidates(
        int index,
        com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
            builderForValue) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.add(index, builderForValue.build());
        onChanged();
      } else {
        candidatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder addAllCandidates(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                        .Candidate>
            values) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, candidates_);
        onChanged();
      } else {
        candidatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder clearCandidates() {
      if (candidatesBuilder_ == null) {
        candidates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        candidatesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public Builder removeCandidates(int index) {
      if (candidatesBuilder_ == null) {
        ensureCandidatesIsMutable();
        candidates_.remove(index);
        onChanged();
      } else {
        candidatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
        getCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
            .CandidateOrBuilder
        getCandidatesOrBuilder(int index) {
      if (candidatesBuilder_ == null) {
        return candidates_.get(index);
      } else {
        return candidatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                    .CandidateOrBuilder>
        getCandidatesOrBuilderList() {
      if (candidatesBuilder_ != null) {
        return candidatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(candidates_);
      }
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
        addCandidatesBuilder() {
      return getCandidatesFieldBuilder()
          .addBuilder(
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate.Builder
        addCandidatesBuilder(int index) {
      return getCandidatesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Generated candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate candidates = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .Builder>
        getCandidatesBuilderList() {
      return getCandidatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                .Builder,
            com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                .CandidateOrBuilder>
        getCandidatesFieldBuilder() {
      if (candidatesBuilder_ == null) {
        candidatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse.Candidate
                    .Builder,
                com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
                    .CandidateOrBuilder>(
                candidates_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        candidates_ = null;
      }
      return candidatesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse)
  private static final com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse();
  }

  public static com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateGroundedContentResponse> PARSER =
      new com.google.protobuf.AbstractParser<GenerateGroundedContentResponse>() {
        @java.lang.Override
        public GenerateGroundedContentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateGroundedContentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateGroundedContentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.discoveryengine.v1beta.GenerateGroundedContentResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
