/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [Firestore.UpdateDocument][google.firestore.v1.Firestore.UpdateDocument].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.UpdateDocumentRequest}
 */
public final class UpdateDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.UpdateDocumentRequest)
    UpdateDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateDocumentRequest.newBuilder() to construct.
  private UpdateDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateDocumentRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateDocumentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_UpdateDocumentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_UpdateDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.UpdateDocumentRequest.class,
            com.google.firestore.v1.UpdateDocumentRequest.Builder.class);
  }

  public static final int DOCUMENT_FIELD_NUMBER = 1;
  private com.google.firestore.v1.Document document_;
  /**
   *
   *
   * <pre>
   * Required. The updated document.
   * Creates the document if it does not already exist.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the document field is set.
   */
  @java.lang.Override
  public boolean hasDocument() {
    return document_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The updated document.
   * Creates the document if it does not already exist.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The document.
   */
  @java.lang.Override
  public com.google.firestore.v1.Document getDocument() {
    return document_ == null ? com.google.firestore.v1.Document.getDefaultInstance() : document_;
  }
  /**
   *
   *
   * <pre>
   * Required. The updated document.
   * Creates the document if it does not already exist.
   * </pre>
   *
   * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
    return document_ == null ? com.google.firestore.v1.Document.getDefaultInstance() : document_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 2;
  private com.google.firestore.v1.DocumentMask updateMask_;
  /**
   *
   *
   * <pre>
   * The fields to update.
   * None of the field paths in the mask may contain a reserved name.
   *
   * If the document exists on the server and has fields not referenced in the
   * mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * The fields to update.
   * None of the field paths in the mask may contain a reserved name.
   *
   * If the document exists on the server and has fields not referenced in the
   * mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMask getUpdateMask() {
    return updateMask_ == null
        ? com.google.firestore.v1.DocumentMask.getDefaultInstance()
        : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * The fields to update.
   * None of the field paths in the mask may contain a reserved name.
   *
   * If the document exists on the server and has fields not referenced in the
   * mask, they are left unchanged.
   * Fields referenced in the mask, but not present in the input document, are
   * deleted from the document on the server.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null
        ? com.google.firestore.v1.DocumentMask.getDefaultInstance()
        : updateMask_;
  }

  public static final int MASK_FIELD_NUMBER = 3;
  private com.google.firestore.v1.DocumentMask mask_;
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If the document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   *
   * @return Whether the mask field is set.
   */
  @java.lang.Override
  public boolean hasMask() {
    return mask_ != null;
  }
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If the document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   *
   * @return The mask.
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMask getMask() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }
  /**
   *
   *
   * <pre>
   * The fields to return. If not set, returns all fields.
   *
   * If the document has a field that is not present in this mask, that field
   * will not be returned in the response.
   * </pre>
   *
   * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
    return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
  }

  public static final int CURRENT_DOCUMENT_FIELD_NUMBER = 4;
  private com.google.firestore.v1.Precondition currentDocument_;
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The request will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1.Precondition current_document = 4;</code>
   *
   * @return Whether the currentDocument field is set.
   */
  @java.lang.Override
  public boolean hasCurrentDocument() {
    return currentDocument_ != null;
  }
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The request will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1.Precondition current_document = 4;</code>
   *
   * @return The currentDocument.
   */
  @java.lang.Override
  public com.google.firestore.v1.Precondition getCurrentDocument() {
    return currentDocument_ == null
        ? com.google.firestore.v1.Precondition.getDefaultInstance()
        : currentDocument_;
  }
  /**
   *
   *
   * <pre>
   * An optional precondition on the document.
   * The request will fail if this is set and not met by the target document.
   * </pre>
   *
   * <code>.google.firestore.v1.Precondition current_document = 4;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.PreconditionOrBuilder getCurrentDocumentOrBuilder() {
    return currentDocument_ == null
        ? com.google.firestore.v1.Precondition.getDefaultInstance()
        : currentDocument_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (document_ != null) {
      output.writeMessage(1, getDocument());
    }
    if (updateMask_ != null) {
      output.writeMessage(2, getUpdateMask());
    }
    if (mask_ != null) {
      output.writeMessage(3, getMask());
    }
    if (currentDocument_ != null) {
      output.writeMessage(4, getCurrentDocument());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (document_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDocument());
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
    }
    if (mask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMask());
    }
    if (currentDocument_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCurrentDocument());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.UpdateDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.UpdateDocumentRequest other =
        (com.google.firestore.v1.UpdateDocumentRequest) obj;

    if (hasDocument() != other.hasDocument()) return false;
    if (hasDocument()) {
      if (!getDocument().equals(other.getDocument())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (hasMask() != other.hasMask()) return false;
    if (hasMask()) {
      if (!getMask().equals(other.getMask())) return false;
    }
    if (hasCurrentDocument() != other.hasCurrentDocument()) return false;
    if (hasCurrentDocument()) {
      if (!getCurrentDocument().equals(other.getCurrentDocument())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDocument()) {
      hash = (37 * hash) + DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDocument().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (hasMask()) {
      hash = (37 * hash) + MASK_FIELD_NUMBER;
      hash = (53 * hash) + getMask().hashCode();
    }
    if (hasCurrentDocument()) {
      hash = (37 * hash) + CURRENT_DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentDocument().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.UpdateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.UpdateDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [Firestore.UpdateDocument][google.firestore.v1.Firestore.UpdateDocument].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.UpdateDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.UpdateDocumentRequest)
      com.google.firestore.v1.UpdateDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_UpdateDocumentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_UpdateDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.UpdateDocumentRequest.class,
              com.google.firestore.v1.UpdateDocumentRequest.Builder.class);
    }

    // Construct using com.google.firestore.v1.UpdateDocumentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      currentDocument_ = null;
      if (currentDocumentBuilder_ != null) {
        currentDocumentBuilder_.dispose();
        currentDocumentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_UpdateDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.UpdateDocumentRequest getDefaultInstanceForType() {
      return com.google.firestore.v1.UpdateDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.UpdateDocumentRequest build() {
      com.google.firestore.v1.UpdateDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.UpdateDocumentRequest buildPartial() {
      com.google.firestore.v1.UpdateDocumentRequest result =
          new com.google.firestore.v1.UpdateDocumentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.firestore.v1.UpdateDocumentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.document_ = documentBuilder_ == null ? document_ : documentBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.mask_ = maskBuilder_ == null ? mask_ : maskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.currentDocument_ =
            currentDocumentBuilder_ == null ? currentDocument_ : currentDocumentBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.UpdateDocumentRequest) {
        return mergeFrom((com.google.firestore.v1.UpdateDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.UpdateDocumentRequest other) {
      if (other == com.google.firestore.v1.UpdateDocumentRequest.getDefaultInstance()) return this;
      if (other.hasDocument()) {
        mergeDocument(other.getDocument());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.hasMask()) {
        mergeMask(other.getMask());
      }
      if (other.hasCurrentDocument()) {
        mergeCurrentDocument(other.getCurrentDocument());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCurrentDocumentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.firestore.v1.Document document_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        documentBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the document field is set.
     */
    public boolean hasDocument() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The document.
     */
    public com.google.firestore.v1.Document getDocument() {
      if (documentBuilder_ == null) {
        return document_ == null
            ? com.google.firestore.v1.Document.getDefaultInstance()
            : document_;
      } else {
        return documentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
      } else {
        documentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocument(com.google.firestore.v1.Document.Builder builderForValue) {
      if (documentBuilder_ == null) {
        document_ = builderForValue.build();
      } else {
        documentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocument(com.google.firestore.v1.Document value) {
      if (documentBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && document_ != null
            && document_ != com.google.firestore.v1.Document.getDefaultInstance()) {
          getDocumentBuilder().mergeFrom(value);
        } else {
          document_ = value;
        }
      } else {
        documentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocument() {
      bitField0_ = (bitField0_ & ~0x00000001);
      document_ = null;
      if (documentBuilder_ != null) {
        documentBuilder_.dispose();
        documentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.Document.Builder getDocumentBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.firestore.v1.DocumentOrBuilder getDocumentOrBuilder() {
      if (documentBuilder_ != null) {
        return documentBuilder_.getMessageOrBuilder();
      } else {
        return document_ == null
            ? com.google.firestore.v1.Document.getDefaultInstance()
            : document_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The updated document.
     * Creates the document if it does not already exist.
     * </pre>
     *
     * <code>.google.firestore.v1.Document document = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Document,
            com.google.firestore.v1.Document.Builder,
            com.google.firestore.v1.DocumentOrBuilder>
        getDocumentFieldBuilder() {
      if (documentBuilder_ == null) {
        documentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Document,
                com.google.firestore.v1.Document.Builder,
                com.google.firestore.v1.DocumentOrBuilder>(
                getDocument(), getParentForChildren(), isClean());
        document_ = null;
      }
      return documentBuilder_;
    }

    private com.google.firestore.v1.DocumentMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     *
     * @return The updateMask.
     */
    public com.google.firestore.v1.DocumentMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.firestore.v1.DocumentMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public Builder setUpdateMask(com.google.firestore.v1.DocumentMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public Builder setUpdateMask(com.google.firestore.v1.DocumentMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public Builder mergeUpdateMask(com.google.firestore.v1.DocumentMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.firestore.v1.DocumentMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public com.google.firestore.v1.DocumentMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    public com.google.firestore.v1.DocumentMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.firestore.v1.DocumentMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to update.
     * None of the field paths in the mask may contain a reserved name.
     *
     * If the document exists on the server and has fields not referenced in the
     * mask, they are left unchanged.
     * Fields referenced in the mask, but not present in the input document, are
     * deleted from the document on the server.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask update_mask = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentMask,
                com.google.firestore.v1.DocumentMask.Builder,
                com.google.firestore.v1.DocumentMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private com.google.firestore.v1.DocumentMask mask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        maskBuilder_;
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     *
     * @return Whether the mask field is set.
     */
    public boolean hasMask() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     *
     * @return The mask.
     */
    public com.google.firestore.v1.DocumentMask getMask() {
      if (maskBuilder_ == null) {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      } else {
        return maskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mask_ = value;
      } else {
        maskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder setMask(com.google.firestore.v1.DocumentMask.Builder builderForValue) {
      if (maskBuilder_ == null) {
        mask_ = builderForValue.build();
      } else {
        maskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder mergeMask(com.google.firestore.v1.DocumentMask value) {
      if (maskBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && mask_ != null
            && mask_ != com.google.firestore.v1.DocumentMask.getDefaultInstance()) {
          getMaskBuilder().mergeFrom(value);
        } else {
          mask_ = value;
        }
      } else {
        maskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public Builder clearMask() {
      bitField0_ = (bitField0_ & ~0x00000004);
      mask_ = null;
      if (maskBuilder_ != null) {
        maskBuilder_.dispose();
        maskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public com.google.firestore.v1.DocumentMask.Builder getMaskBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    public com.google.firestore.v1.DocumentMaskOrBuilder getMaskOrBuilder() {
      if (maskBuilder_ != null) {
        return maskBuilder_.getMessageOrBuilder();
      } else {
        return mask_ == null ? com.google.firestore.v1.DocumentMask.getDefaultInstance() : mask_;
      }
    }
    /**
     *
     *
     * <pre>
     * The fields to return. If not set, returns all fields.
     *
     * If the document has a field that is not present in this mask, that field
     * will not be returned in the response.
     * </pre>
     *
     * <code>.google.firestore.v1.DocumentMask mask = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.DocumentMask,
            com.google.firestore.v1.DocumentMask.Builder,
            com.google.firestore.v1.DocumentMaskOrBuilder>
        getMaskFieldBuilder() {
      if (maskBuilder_ == null) {
        maskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.DocumentMask,
                com.google.firestore.v1.DocumentMask.Builder,
                com.google.firestore.v1.DocumentMaskOrBuilder>(
                getMask(), getParentForChildren(), isClean());
        mask_ = null;
      }
      return maskBuilder_;
    }

    private com.google.firestore.v1.Precondition currentDocument_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Precondition,
            com.google.firestore.v1.Precondition.Builder,
            com.google.firestore.v1.PreconditionOrBuilder>
        currentDocumentBuilder_;
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     *
     * @return Whether the currentDocument field is set.
     */
    public boolean hasCurrentDocument() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     *
     * @return The currentDocument.
     */
    public com.google.firestore.v1.Precondition getCurrentDocument() {
      if (currentDocumentBuilder_ == null) {
        return currentDocument_ == null
            ? com.google.firestore.v1.Precondition.getDefaultInstance()
            : currentDocument_;
      } else {
        return currentDocumentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public Builder setCurrentDocument(com.google.firestore.v1.Precondition value) {
      if (currentDocumentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentDocument_ = value;
      } else {
        currentDocumentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public Builder setCurrentDocument(
        com.google.firestore.v1.Precondition.Builder builderForValue) {
      if (currentDocumentBuilder_ == null) {
        currentDocument_ = builderForValue.build();
      } else {
        currentDocumentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public Builder mergeCurrentDocument(com.google.firestore.v1.Precondition value) {
      if (currentDocumentBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && currentDocument_ != null
            && currentDocument_ != com.google.firestore.v1.Precondition.getDefaultInstance()) {
          getCurrentDocumentBuilder().mergeFrom(value);
        } else {
          currentDocument_ = value;
        }
      } else {
        currentDocumentBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public Builder clearCurrentDocument() {
      bitField0_ = (bitField0_ & ~0x00000008);
      currentDocument_ = null;
      if (currentDocumentBuilder_ != null) {
        currentDocumentBuilder_.dispose();
        currentDocumentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public com.google.firestore.v1.Precondition.Builder getCurrentDocumentBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCurrentDocumentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    public com.google.firestore.v1.PreconditionOrBuilder getCurrentDocumentOrBuilder() {
      if (currentDocumentBuilder_ != null) {
        return currentDocumentBuilder_.getMessageOrBuilder();
      } else {
        return currentDocument_ == null
            ? com.google.firestore.v1.Precondition.getDefaultInstance()
            : currentDocument_;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional precondition on the document.
     * The request will fail if this is set and not met by the target document.
     * </pre>
     *
     * <code>.google.firestore.v1.Precondition current_document = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.Precondition,
            com.google.firestore.v1.Precondition.Builder,
            com.google.firestore.v1.PreconditionOrBuilder>
        getCurrentDocumentFieldBuilder() {
      if (currentDocumentBuilder_ == null) {
        currentDocumentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.Precondition,
                com.google.firestore.v1.Precondition.Builder,
                com.google.firestore.v1.PreconditionOrBuilder>(
                getCurrentDocument(), getParentForChildren(), isClean());
        currentDocument_ = null;
      }
      return currentDocumentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.UpdateDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.UpdateDocumentRequest)
  private static final com.google.firestore.v1.UpdateDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.UpdateDocumentRequest();
  }

  public static com.google.firestore.v1.UpdateDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateDocumentRequest>() {
        @java.lang.Override
        public UpdateDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.UpdateDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
