/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/firestore.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * The response for
 * [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.PartitionQueryResponse}
 */
public final class PartitionQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.PartitionQueryResponse)
    PartitionQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartitionQueryResponse.newBuilder() to construct.
  private PartitionQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartitionQueryResponse() {
    partitions_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartitionQueryResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_PartitionQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.FirestoreProto
        .internal_static_google_firestore_v1_PartitionQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.PartitionQueryResponse.class,
            com.google.firestore.v1.PartitionQueryResponse.Builder.class);
  }

  public static final int PARTITIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.v1.Cursor> partitions_;
  /**
   *
   *
   * <pre>
   * Partition results.
   * Each partition is a split point that can be used by RunQuery as a starting
   * or end point for the query results. The RunQuery requests must be made with
   * the same query supplied to this PartitionQuery request. The partition
   * cursors will be ordered according to same ordering as the results of the
   * query supplied to PartitionQuery.
   * For example, if a PartitionQuery request returns partition cursors A and B,
   * running the following three queries will return the entire result set of
   * the original query:
   *  * query, end_at A
   *  * query, start_at A, end_at B
   *  * query, start_at B
   * An empty result may indicate that the query has too few results to be
   * partitioned.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.Cursor> getPartitionsList() {
    return partitions_;
  }
  /**
   *
   *
   * <pre>
   * Partition results.
   * Each partition is a split point that can be used by RunQuery as a starting
   * or end point for the query results. The RunQuery requests must be made with
   * the same query supplied to this PartitionQuery request. The partition
   * cursors will be ordered according to same ordering as the results of the
   * query supplied to PartitionQuery.
   * For example, if a PartitionQuery request returns partition cursors A and B,
   * running the following three queries will return the entire result set of
   * the original query:
   *  * query, end_at A
   *  * query, start_at A, end_at B
   *  * query, start_at B
   * An empty result may indicate that the query has too few results to be
   * partitioned.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.firestore.v1.CursorOrBuilder>
      getPartitionsOrBuilderList() {
    return partitions_;
  }
  /**
   *
   *
   * <pre>
   * Partition results.
   * Each partition is a split point that can be used by RunQuery as a starting
   * or end point for the query results. The RunQuery requests must be made with
   * the same query supplied to this PartitionQuery request. The partition
   * cursors will be ordered according to same ordering as the results of the
   * query supplied to PartitionQuery.
   * For example, if a PartitionQuery request returns partition cursors A and B,
   * running the following three queries will return the entire result set of
   * the original query:
   *  * query, end_at A
   *  * query, start_at A, end_at B
   *  * query, start_at B
   * An empty result may indicate that the query has too few results to be
   * partitioned.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
   */
  @java.lang.Override
  public int getPartitionsCount() {
    return partitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Partition results.
   * Each partition is a split point that can be used by RunQuery as a starting
   * or end point for the query results. The RunQuery requests must be made with
   * the same query supplied to this PartitionQuery request. The partition
   * cursors will be ordered according to same ordering as the results of the
   * query supplied to PartitionQuery.
   * For example, if a PartitionQuery request returns partition cursors A and B,
   * running the following three queries will return the entire result set of
   * the original query:
   *  * query, end_at A
   *  * query, start_at A, end_at B
   *  * query, start_at B
   * An empty result may indicate that the query has too few results to be
   * partitioned.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.Cursor getPartitions(int index) {
    return partitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partition results.
   * Each partition is a split point that can be used by RunQuery as a starting
   * or end point for the query results. The RunQuery requests must be made with
   * the same query supplied to this PartitionQuery request. The partition
   * cursors will be ordered according to same ordering as the results of the
   * query supplied to PartitionQuery.
   * For example, if a PartitionQuery request returns partition cursors A and B,
   * running the following three queries will return the entire result set of
   * the original query:
   *  * query, end_at A
   *  * query, start_at A, end_at B
   *  * query, start_at B
   * An empty result may indicate that the query has too few results to be
   * partitioned.
   * </pre>
   *
   * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.CursorOrBuilder getPartitionsOrBuilder(int index) {
    return partitions_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A page token that may be used to request an additional set of results, up
   * to the number specified by `partition_count` in the PartitionQuery request.
   * If blank, there are no more results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A page token that may be used to request an additional set of results, up
   * to the number specified by `partition_count` in the PartitionQuery request.
   * If blank, there are no more results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < partitions_.size(); i++) {
      output.writeMessage(1, partitions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < partitions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, partitions_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.PartitionQueryResponse)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.PartitionQueryResponse other =
        (com.google.firestore.v1.PartitionQueryResponse) obj;

    if (!getPartitionsList().equals(other.getPartitionsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPartitionsCount() > 0) {
      hash = (37 * hash) + PARTITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.PartitionQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.PartitionQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for
   * [Firestore.PartitionQuery][google.firestore.v1.Firestore.PartitionQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.PartitionQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.PartitionQueryResponse)
      com.google.firestore.v1.PartitionQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.PartitionQueryResponse.class,
              com.google.firestore.v1.PartitionQueryResponse.Builder.class);
    }

    // Construct using com.google.firestore.v1.PartitionQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (partitionsBuilder_ == null) {
        partitions_ = java.util.Collections.emptyList();
      } else {
        partitions_ = null;
        partitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.FirestoreProto
          .internal_static_google_firestore_v1_PartitionQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryResponse getDefaultInstanceForType() {
      return com.google.firestore.v1.PartitionQueryResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryResponse build() {
      com.google.firestore.v1.PartitionQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.PartitionQueryResponse buildPartial() {
      com.google.firestore.v1.PartitionQueryResponse result =
          new com.google.firestore.v1.PartitionQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.firestore.v1.PartitionQueryResponse result) {
      if (partitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          partitions_ = java.util.Collections.unmodifiableList(partitions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.partitions_ = partitions_;
      } else {
        result.partitions_ = partitionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.v1.PartitionQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.PartitionQueryResponse) {
        return mergeFrom((com.google.firestore.v1.PartitionQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.PartitionQueryResponse other) {
      if (other == com.google.firestore.v1.PartitionQueryResponse.getDefaultInstance()) return this;
      if (partitionsBuilder_ == null) {
        if (!other.partitions_.isEmpty()) {
          if (partitions_.isEmpty()) {
            partitions_ = other.partitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePartitionsIsMutable();
            partitions_.addAll(other.partitions_);
          }
          onChanged();
        }
      } else {
        if (!other.partitions_.isEmpty()) {
          if (partitionsBuilder_.isEmpty()) {
            partitionsBuilder_.dispose();
            partitionsBuilder_ = null;
            partitions_ = other.partitions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            partitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartitionsFieldBuilder()
                    : null;
          } else {
            partitionsBuilder_.addAllMessages(other.partitions_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.firestore.v1.Cursor m =
                    input.readMessage(com.google.firestore.v1.Cursor.parser(), extensionRegistry);
                if (partitionsBuilder_ == null) {
                  ensurePartitionsIsMutable();
                  partitions_.add(m);
                } else {
                  partitionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.firestore.v1.Cursor> partitions_ =
        java.util.Collections.emptyList();

    private void ensurePartitionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        partitions_ = new java.util.ArrayList<com.google.firestore.v1.Cursor>(partitions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Cursor,
            com.google.firestore.v1.Cursor.Builder,
            com.google.firestore.v1.CursorOrBuilder>
        partitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public java.util.List<com.google.firestore.v1.Cursor> getPartitionsList() {
      if (partitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partitions_);
      } else {
        return partitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public int getPartitionsCount() {
      if (partitionsBuilder_ == null) {
        return partitions_.size();
      } else {
        return partitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public com.google.firestore.v1.Cursor getPartitions(int index) {
      if (partitionsBuilder_ == null) {
        return partitions_.get(index);
      } else {
        return partitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder setPartitions(int index, com.google.firestore.v1.Cursor value) {
      if (partitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionsIsMutable();
        partitions_.set(index, value);
        onChanged();
      } else {
        partitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder setPartitions(
        int index, com.google.firestore.v1.Cursor.Builder builderForValue) {
      if (partitionsBuilder_ == null) {
        ensurePartitionsIsMutable();
        partitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        partitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder addPartitions(com.google.firestore.v1.Cursor value) {
      if (partitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionsIsMutable();
        partitions_.add(value);
        onChanged();
      } else {
        partitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder addPartitions(int index, com.google.firestore.v1.Cursor value) {
      if (partitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionsIsMutable();
        partitions_.add(index, value);
        onChanged();
      } else {
        partitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder addPartitions(com.google.firestore.v1.Cursor.Builder builderForValue) {
      if (partitionsBuilder_ == null) {
        ensurePartitionsIsMutable();
        partitions_.add(builderForValue.build());
        onChanged();
      } else {
        partitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder addPartitions(
        int index, com.google.firestore.v1.Cursor.Builder builderForValue) {
      if (partitionsBuilder_ == null) {
        ensurePartitionsIsMutable();
        partitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        partitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder addAllPartitions(
        java.lang.Iterable<? extends com.google.firestore.v1.Cursor> values) {
      if (partitionsBuilder_ == null) {
        ensurePartitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partitions_);
        onChanged();
      } else {
        partitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder clearPartitions() {
      if (partitionsBuilder_ == null) {
        partitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        partitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public Builder removePartitions(int index) {
      if (partitionsBuilder_ == null) {
        ensurePartitionsIsMutable();
        partitions_.remove(index);
        onChanged();
      } else {
        partitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public com.google.firestore.v1.Cursor.Builder getPartitionsBuilder(int index) {
      return getPartitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public com.google.firestore.v1.CursorOrBuilder getPartitionsOrBuilder(int index) {
      if (partitionsBuilder_ == null) {
        return partitions_.get(index);
      } else {
        return partitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public java.util.List<? extends com.google.firestore.v1.CursorOrBuilder>
        getPartitionsOrBuilderList() {
      if (partitionsBuilder_ != null) {
        return partitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public com.google.firestore.v1.Cursor.Builder addPartitionsBuilder() {
      return getPartitionsFieldBuilder()
          .addBuilder(com.google.firestore.v1.Cursor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public com.google.firestore.v1.Cursor.Builder addPartitionsBuilder(int index) {
      return getPartitionsFieldBuilder()
          .addBuilder(index, com.google.firestore.v1.Cursor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partition results.
     * Each partition is a split point that can be used by RunQuery as a starting
     * or end point for the query results. The RunQuery requests must be made with
     * the same query supplied to this PartitionQuery request. The partition
     * cursors will be ordered according to same ordering as the results of the
     * query supplied to PartitionQuery.
     * For example, if a PartitionQuery request returns partition cursors A and B,
     * running the following three queries will return the entire result set of
     * the original query:
     *  * query, end_at A
     *  * query, start_at A, end_at B
     *  * query, start_at B
     * An empty result may indicate that the query has too few results to be
     * partitioned.
     * </pre>
     *
     * <code>repeated .google.firestore.v1.Cursor partitions = 1;</code>
     */
    public java.util.List<com.google.firestore.v1.Cursor.Builder> getPartitionsBuilderList() {
      return getPartitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.Cursor,
            com.google.firestore.v1.Cursor.Builder,
            com.google.firestore.v1.CursorOrBuilder>
        getPartitionsFieldBuilder() {
      if (partitionsBuilder_ == null) {
        partitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1.Cursor,
                com.google.firestore.v1.Cursor.Builder,
                com.google.firestore.v1.CursorOrBuilder>(
                partitions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        partitions_ = null;
      }
      return partitionsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A page token that may be used to request an additional set of results, up
     * to the number specified by `partition_count` in the PartitionQuery request.
     * If blank, there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token that may be used to request an additional set of results, up
     * to the number specified by `partition_count` in the PartitionQuery request.
     * If blank, there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A page token that may be used to request an additional set of results, up
     * to the number specified by `partition_count` in the PartitionQuery request.
     * If blank, there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token that may be used to request an additional set of results, up
     * to the number specified by `partition_count` in the PartitionQuery request.
     * If blank, there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A page token that may be used to request an additional set of results, up
     * to the number specified by `partition_count` in the PartitionQuery request.
     * If blank, there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.PartitionQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.PartitionQueryResponse)
  private static final com.google.firestore.v1.PartitionQueryResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.PartitionQueryResponse();
  }

  public static com.google.firestore.v1.PartitionQueryResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartitionQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<PartitionQueryResponse>() {
        @java.lang.Override
        public PartitionQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PartitionQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartitionQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.PartitionQueryResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
