/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/query.proto

package com.google.firestore.v1;

/**
 *
 *
 * <pre>
 * Firestore query for running an aggregation over a
 * [StructuredQuery][google.firestore.v1.StructuredQuery].
 * </pre>
 *
 * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery}
 */
public final class StructuredAggregationQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.firestore.v1.StructuredAggregationQuery)
    StructuredAggregationQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StructuredAggregationQuery.newBuilder() to construct.
  private StructuredAggregationQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StructuredAggregationQuery() {
    aggregations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StructuredAggregationQuery();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.firestore.v1.QueryProto
        .internal_static_google_firestore_v1_StructuredAggregationQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.firestore.v1.QueryProto
        .internal_static_google_firestore_v1_StructuredAggregationQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.firestore.v1.StructuredAggregationQuery.class,
            com.google.firestore.v1.StructuredAggregationQuery.Builder.class);
  }

  public interface AggregationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.firestore.v1.StructuredAggregationQuery.Aggregation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return Whether the count field is set.
     */
    boolean hasCount();
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return The count.
     */
    com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count getCount();
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     */
    com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder
        getCountOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to store the result of the
     * aggregation into.
     * If not provided, Firestore will pick a default name following the format
     * `field_&lt;incremental_id++&gt;`. For example:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4)
     * OVER (
     *   ...
     * );
     * ```
     * becomes:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS field_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4) AS field_2
     * OVER (
     *   ...
     * );
     * ```
     * Requires:
     * * Must be unique across all aggregation aliases.
     * * Conform to [document field name][google.firestore.v1.Document.fields]
     * limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alias.
     */
    java.lang.String getAlias();
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to store the result of the
     * aggregation into.
     * If not provided, Firestore will pick a default name following the format
     * `field_&lt;incremental_id++&gt;`. For example:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4)
     * OVER (
     *   ...
     * );
     * ```
     * becomes:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS field_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4) AS field_2
     * OVER (
     *   ...
     * );
     * ```
     * Requires:
     * * Must be unique across all aggregation aliases.
     * * Conform to [document field name][google.firestore.v1.Document.fields]
     * limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alias.
     */
    com.google.protobuf.ByteString getAliasBytes();

    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.OperatorCase
        getOperatorCase();
  }
  /**
   *
   *
   * <pre>
   * Defines a aggregation that produces a single result.
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery.Aggregation}
   */
  public static final class Aggregation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.firestore.v1.StructuredAggregationQuery.Aggregation)
      AggregationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Aggregation.newBuilder() to construct.
    private Aggregation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Aggregation() {
      alias_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Aggregation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.QueryProto
          .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.QueryProto
          .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.class,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder.class);
    }

    public interface CountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the upTo field is set.
       */
      boolean hasUpTo();
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The upTo.
       */
      com.google.protobuf.Int64Value getUpTo();
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Count of documents that match the query.
     * The `COUNT(*)` aggregation function operates on the entire document
     * so it does not require a field reference.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery.Aggregation.Count}
     */
    public static final class Count extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
        CountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Count.newBuilder() to construct.
      private Count(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Count() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Count();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.QueryProto
            .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_Count_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.QueryProto
            .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_Count_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.class,
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder.class);
      }

      public static final int UP_TO_FIELD_NUMBER = 1;
      private com.google.protobuf.Int64Value upTo_;
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the upTo field is set.
       */
      @java.lang.Override
      public boolean hasUpTo() {
        return upTo_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The upTo.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getUpTo() {
        return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of documents to
       * count.
       * This provides a way to set an upper bound on the number of documents
       * to scan, limiting latency and cost.
       * Unspecified is interpreted as no bound.
       * High-Level Example:
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       * Requires:
       * * Must be greater than zero when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder() {
        return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (upTo_ != null) {
          output.writeMessage(1, getUpTo());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (upTo_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUpTo());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)) {
          return super.equals(obj);
        }
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count other =
            (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) obj;

        if (hasUpTo() != other.hasUpTo()) return false;
        if (hasUpTo()) {
          if (!getUpTo().equals(other.getUpTo())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasUpTo()) {
          hash = (37 * hash) + UP_TO_FIELD_NUMBER;
          hash = (53 * hash) + getUpTo().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Count of documents that match the query.
       * The `COUNT(*)` aggregation function operates on the entire document
       * so it does not require a field reference.
       * </pre>
       *
       * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery.Aggregation.Count}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.firestore.v1.QueryProto
              .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_Count_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.firestore.v1.QueryProto
              .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_Count_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.class,
                  com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder
                      .class);
        }

        // Construct using
        // com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          upTo_ = null;
          if (upToBuilder_ != null) {
            upToBuilder_.dispose();
            upToBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.firestore.v1.QueryProto
              .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_Count_descriptor;
        }

        @java.lang.Override
        public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
            getDefaultInstanceForType() {
          return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count build() {
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count buildPartial() {
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count result =
              new com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.upTo_ = upToBuilder_ == null ? upTo_ : upToBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) {
            return mergeFrom(
                (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count other) {
          if (other
              == com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
                  .getDefaultInstance()) return this;
          if (other.hasUpTo()) {
            mergeUpTo(other.getUpTo());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getUpToFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Int64Value upTo_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            upToBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the upTo field is set.
         */
        public boolean hasUpTo() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The upTo.
         */
        public com.google.protobuf.Int64Value getUpTo() {
          if (upToBuilder_ == null) {
            return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
          } else {
            return upToBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setUpTo(com.google.protobuf.Int64Value value) {
          if (upToBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            upTo_ = value;
          } else {
            upToBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setUpTo(com.google.protobuf.Int64Value.Builder builderForValue) {
          if (upToBuilder_ == null) {
            upTo_ = builderForValue.build();
          } else {
            upToBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeUpTo(com.google.protobuf.Int64Value value) {
          if (upToBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && upTo_ != null
                && upTo_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
              getUpToBuilder().mergeFrom(value);
            } else {
              upTo_ = value;
            }
          } else {
            upToBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearUpTo() {
          bitField0_ = (bitField0_ & ~0x00000001);
          upTo_ = null;
          if (upToBuilder_ != null) {
            upToBuilder_.dispose();
            upToBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Int64Value.Builder getUpToBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getUpToFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder() {
          if (upToBuilder_ != null) {
            return upToBuilder_.getMessageOrBuilder();
          } else {
            return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of documents to
         * count.
         * This provides a way to set an upper bound on the number of documents
         * to scan, limiting latency and cost.
         * Unspecified is interpreted as no bound.
         * High-Level Example:
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         * Requires:
         * * Must be greater than zero when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            getUpToFieldBuilder() {
          if (upToBuilder_ == null) {
            upToBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Int64Value,
                    com.google.protobuf.Int64Value.Builder,
                    com.google.protobuf.Int64ValueOrBuilder>(
                    getUpTo(), getParentForChildren(), isClean());
            upTo_ = null;
          }
          return upToBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
      }

      // @@protoc_insertion_point(class_scope:google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
      private static final com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count();
      }

      public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Count> PARSER =
          new com.google.protobuf.AbstractParser<Count>() {
            @java.lang.Override
            public Count parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Count> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Count> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int operatorCase_ = 0;
    private java.lang.Object operator_;

    public enum OperatorCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      COUNT(1),
      OPERATOR_NOT_SET(0);
      private final int value;

      private OperatorCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OperatorCase valueOf(int value) {
        return forNumber(value);
      }

      public static OperatorCase forNumber(int value) {
        switch (value) {
          case 1:
            return COUNT;
          case 0:
            return OPERATOR_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OperatorCase getOperatorCase() {
      return OperatorCase.forNumber(operatorCase_);
    }

    public static final int COUNT_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return operatorCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count getCount() {
      if (operatorCase_ == 1) {
        return (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_;
      }
      return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder
        getCountOrBuilder() {
      if (operatorCase_ == 1) {
        return (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_;
      }
      return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
          .getDefaultInstance();
    }

    public static final int ALIAS_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object alias_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to store the result of the
     * aggregation into.
     * If not provided, Firestore will pick a default name following the format
     * `field_&lt;incremental_id++&gt;`. For example:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4)
     * OVER (
     *   ...
     * );
     * ```
     * becomes:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS field_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4) AS field_2
     * OVER (
     *   ...
     * );
     * ```
     * Requires:
     * * Must be unique across all aggregation aliases.
     * * Conform to [document field name][google.firestore.v1.Document.fields]
     * limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alias.
     */
    @java.lang.Override
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alias_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the field to store the result of the
     * aggregation into.
     * If not provided, Firestore will pick a default name following the format
     * `field_&lt;incremental_id++&gt;`. For example:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4)
     * OVER (
     *   ...
     * );
     * ```
     * becomes:
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS field_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT_UP_TO(4) AS field_2
     * OVER (
     *   ...
     * );
     * ```
     * Requires:
     * * Must be unique across all aggregation aliases.
     * * Conform to [document field name][google.firestore.v1.Document.fields]
     * limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alias.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (operatorCase_ == 1) {
        output.writeMessage(
            1, (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, alias_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (operatorCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, alias_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.firestore.v1.StructuredAggregationQuery.Aggregation)) {
        return super.equals(obj);
      }
      com.google.firestore.v1.StructuredAggregationQuery.Aggregation other =
          (com.google.firestore.v1.StructuredAggregationQuery.Aggregation) obj;

      if (!getAlias().equals(other.getAlias())) return false;
      if (!getOperatorCase().equals(other.getOperatorCase())) return false;
      switch (operatorCase_) {
        case 1:
          if (!getCount().equals(other.getCount())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALIAS_FIELD_NUMBER;
      hash = (53 * hash) + getAlias().hashCode();
      switch (operatorCase_) {
        case 1:
          hash = (37 * hash) + COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getCount().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines a aggregation that produces a single result.
     * </pre>
     *
     * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery.Aggregation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.firestore.v1.StructuredAggregationQuery.Aggregation)
        com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.firestore.v1.QueryProto
            .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.firestore.v1.QueryProto
            .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.class,
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder.class);
      }

      // Construct using com.google.firestore.v1.StructuredAggregationQuery.Aggregation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (countBuilder_ != null) {
          countBuilder_.clear();
        }
        alias_ = "";
        operatorCase_ = 0;
        operator_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.firestore.v1.QueryProto
            .internal_static_google_firestore_v1_StructuredAggregationQuery_Aggregation_descriptor;
      }

      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation
          getDefaultInstanceForType() {
        return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation build() {
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation buildPartial() {
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation result =
            new com.google.firestore.v1.StructuredAggregationQuery.Aggregation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.alias_ = alias_;
        }
      }

      private void buildPartialOneofs(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation result) {
        result.operatorCase_ = operatorCase_;
        result.operator_ = this.operator_;
        if (operatorCase_ == 1 && countBuilder_ != null) {
          result.operator_ = countBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.firestore.v1.StructuredAggregationQuery.Aggregation) {
          return mergeFrom((com.google.firestore.v1.StructuredAggregationQuery.Aggregation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation other) {
        if (other
            == com.google.firestore.v1.StructuredAggregationQuery.Aggregation.getDefaultInstance())
          return this;
        if (!other.getAlias().isEmpty()) {
          alias_ = other.alias_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getOperatorCase()) {
          case COUNT:
            {
              mergeCount(other.getCount());
              break;
            }
          case OPERATOR_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getCountFieldBuilder().getBuilder(), extensionRegistry);
                  operatorCase_ = 1;
                  break;
                } // case 10
              case 58:
                {
                  alias_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int operatorCase_ = 0;
      private java.lang.Object operator_;

      public OperatorCase getOperatorCase() {
        return OperatorCase.forNumber(operatorCase_);
      }

      public Builder clearOperator() {
        operatorCase_ = 0;
        operator_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder>
          countBuilder_;
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      @java.lang.Override
      public boolean hasCount() {
        return operatorCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count getCount() {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1) {
            return (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_;
          }
          return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
              .getDefaultInstance();
        } else {
          if (operatorCase_ == 1) {
            return countBuilder_.getMessage();
          }
          return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder setCount(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count value) {
        if (countBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operator_ = value;
          onChanged();
        } else {
          countBuilder_.setMessage(value);
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder setCount(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder
              builderForValue) {
        if (countBuilder_ == null) {
          operator_ = builderForValue.build();
          onChanged();
        } else {
          countBuilder_.setMessage(builderForValue.build());
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder mergeCount(
          com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count value) {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1
              && operator_
                  != com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
                      .getDefaultInstance()) {
            operator_ =
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.newBuilder(
                        (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count)
                            operator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            operator_ = value;
          }
          onChanged();
        } else {
          if (operatorCase_ == 1) {
            countBuilder_.mergeFrom(value);
          } else {
            countBuilder_.setMessage(value);
          }
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder clearCount() {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1) {
            operatorCase_ = 0;
            operator_ = null;
            onChanged();
          }
        } else {
          if (operatorCase_ == 1) {
            operatorCase_ = 0;
            operator_ = null;
          }
          countBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder
          getCountBuilder() {
        return getCountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      @java.lang.Override
      public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder
          getCountOrBuilder() {
        if ((operatorCase_ == 1) && (countBuilder_ != null)) {
          return countBuilder_.getMessageOrBuilder();
        } else {
          if (operatorCase_ == 1) {
            return (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_;
          }
          return com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count count = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder>
          getCountFieldBuilder() {
        if (countBuilder_ == null) {
          if (!(operatorCase_ == 1)) {
            operator_ =
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count
                    .getDefaultInstance();
          }
          countBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count,
                  com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count.Builder,
                  com.google.firestore.v1.StructuredAggregationQuery.Aggregation.CountOrBuilder>(
                  (com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Count) operator_,
                  getParentForChildren(),
                  isClean());
          operator_ = null;
        }
        operatorCase_ = 1;
        onChanged();
        return countBuilder_;
      }

      private java.lang.Object alias_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the field to store the result of the
       * aggregation into.
       * If not provided, Firestore will pick a default name following the format
       * `field_&lt;incremental_id++&gt;`. For example:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4)
       * OVER (
       *   ...
       * );
       * ```
       * becomes:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS field_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4) AS field_2
       * OVER (
       *   ...
       * );
       * ```
       * Requires:
       * * Must be unique across all aggregation aliases.
       * * Conform to [document field name][google.firestore.v1.Document.fields]
       * limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alias.
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alias_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the field to store the result of the
       * aggregation into.
       * If not provided, Firestore will pick a default name following the format
       * `field_&lt;incremental_id++&gt;`. For example:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4)
       * OVER (
       *   ...
       * );
       * ```
       * becomes:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS field_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4) AS field_2
       * OVER (
       *   ...
       * );
       * ```
       * Requires:
       * * Must be unique across all aggregation aliases.
       * * Conform to [document field name][google.firestore.v1.Document.fields]
       * limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alias.
       */
      public com.google.protobuf.ByteString getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the field to store the result of the
       * aggregation into.
       * If not provided, Firestore will pick a default name following the format
       * `field_&lt;incremental_id++&gt;`. For example:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4)
       * OVER (
       *   ...
       * );
       * ```
       * becomes:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS field_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4) AS field_2
       * OVER (
       *   ...
       * );
       * ```
       * Requires:
       * * Must be unique across all aggregation aliases.
       * * Conform to [document field name][google.firestore.v1.Document.fields]
       * limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The alias to set.
       * @return This builder for chaining.
       */
      public Builder setAlias(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the field to store the result of the
       * aggregation into.
       * If not provided, Firestore will pick a default name following the format
       * `field_&lt;incremental_id++&gt;`. For example:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4)
       * OVER (
       *   ...
       * );
       * ```
       * becomes:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS field_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4) AS field_2
       * OVER (
       *   ...
       * );
       * ```
       * Requires:
       * * Must be unique across all aggregation aliases.
       * * Conform to [document field name][google.firestore.v1.Document.fields]
       * limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlias() {
        alias_ = getDefaultInstance().getAlias();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the field to store the result of the
       * aggregation into.
       * If not provided, Firestore will pick a default name following the format
       * `field_&lt;incremental_id++&gt;`. For example:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4)
       * OVER (
       *   ...
       * );
       * ```
       * becomes:
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS field_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT_UP_TO(4) AS field_2
       * OVER (
       *   ...
       * );
       * ```
       * Requires:
       * * Must be unique across all aggregation aliases.
       * * Conform to [document field name][google.firestore.v1.Document.fields]
       * limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for alias to set.
       * @return This builder for chaining.
       */
      public Builder setAliasBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.firestore.v1.StructuredAggregationQuery.Aggregation)
    }

    // @@protoc_insertion_point(class_scope:google.firestore.v1.StructuredAggregationQuery.Aggregation)
    private static final com.google.firestore.v1.StructuredAggregationQuery.Aggregation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.firestore.v1.StructuredAggregationQuery.Aggregation();
    }

    public static com.google.firestore.v1.StructuredAggregationQuery.Aggregation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Aggregation> PARSER =
        new com.google.protobuf.AbstractParser<Aggregation>() {
          @java.lang.Override
          public Aggregation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Aggregation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Aggregation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int queryTypeCase_ = 0;
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STRUCTURED_QUERY(1),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return STRUCTURED_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  public static final int STRUCTURED_QUERY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Nested structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
   *
   * @return Whether the structuredQuery field is set.
   */
  @java.lang.Override
  public boolean hasStructuredQuery() {
    return queryTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Nested structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
   *
   * @return The structuredQuery.
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
    if (queryTypeCase_ == 1) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Nested structured query.
   * </pre>
   *
   * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
    if (queryTypeCase_ == 1) {
      return (com.google.firestore.v1.StructuredQuery) queryType_;
    }
    return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
  }

  public static final int AGGREGATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.firestore.v1.StructuredAggregationQuery.Aggregation>
      aggregations_;
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `structured_query`.
   * Requires:
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.firestore.v1.StructuredAggregationQuery.Aggregation>
      getAggregationsList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `structured_query`.
   * Requires:
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder>
      getAggregationsOrBuilderList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `structured_query`.
   * Requires:
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAggregationsCount() {
    return aggregations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `structured_query`.
   * Requires:
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredAggregationQuery.Aggregation getAggregations(int index) {
    return aggregations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `structured_query`.
   * Requires:
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder
      getAggregationsOrBuilder(int index) {
    return aggregations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (queryTypeCase_ == 1) {
      output.writeMessage(1, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      output.writeMessage(3, aggregations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (queryTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.firestore.v1.StructuredQuery) queryType_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, aggregations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.firestore.v1.StructuredAggregationQuery)) {
      return super.equals(obj);
    }
    com.google.firestore.v1.StructuredAggregationQuery other =
        (com.google.firestore.v1.StructuredAggregationQuery) obj;

    if (!getAggregationsList().equals(other.getAggregationsList())) return false;
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 1:
        if (!getStructuredQuery().equals(other.getStructuredQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAggregationsCount() > 0) {
      hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationsList().hashCode();
    }
    switch (queryTypeCase_) {
      case 1:
        hash = (37 * hash) + STRUCTURED_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getStructuredQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.firestore.v1.StructuredAggregationQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.firestore.v1.StructuredAggregationQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Firestore query for running an aggregation over a
   * [StructuredQuery][google.firestore.v1.StructuredQuery].
   * </pre>
   *
   * Protobuf type {@code google.firestore.v1.StructuredAggregationQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.firestore.v1.StructuredAggregationQuery)
      com.google.firestore.v1.StructuredAggregationQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.firestore.v1.QueryProto
          .internal_static_google_firestore_v1_StructuredAggregationQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.firestore.v1.QueryProto
          .internal_static_google_firestore_v1_StructuredAggregationQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.firestore.v1.StructuredAggregationQuery.class,
              com.google.firestore.v1.StructuredAggregationQuery.Builder.class);
    }

    // Construct using com.google.firestore.v1.StructuredAggregationQuery.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (structuredQueryBuilder_ != null) {
        structuredQueryBuilder_.clear();
      }
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
      } else {
        aggregations_ = null;
        aggregationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      queryTypeCase_ = 0;
      queryType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.firestore.v1.QueryProto
          .internal_static_google_firestore_v1_StructuredAggregationQuery_descriptor;
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery getDefaultInstanceForType() {
      return com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery build() {
      com.google.firestore.v1.StructuredAggregationQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.firestore.v1.StructuredAggregationQuery buildPartial() {
      com.google.firestore.v1.StructuredAggregationQuery result =
          new com.google.firestore.v1.StructuredAggregationQuery(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.firestore.v1.StructuredAggregationQuery result) {
      if (aggregationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.aggregations_ = aggregations_;
      } else {
        result.aggregations_ = aggregationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.firestore.v1.StructuredAggregationQuery result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.firestore.v1.StructuredAggregationQuery result) {
      result.queryTypeCase_ = queryTypeCase_;
      result.queryType_ = this.queryType_;
      if (queryTypeCase_ == 1 && structuredQueryBuilder_ != null) {
        result.queryType_ = structuredQueryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.firestore.v1.StructuredAggregationQuery) {
        return mergeFrom((com.google.firestore.v1.StructuredAggregationQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.firestore.v1.StructuredAggregationQuery other) {
      if (other == com.google.firestore.v1.StructuredAggregationQuery.getDefaultInstance())
        return this;
      if (aggregationsBuilder_ == null) {
        if (!other.aggregations_.isEmpty()) {
          if (aggregations_.isEmpty()) {
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAggregationsIsMutable();
            aggregations_.addAll(other.aggregations_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregations_.isEmpty()) {
          if (aggregationsBuilder_.isEmpty()) {
            aggregationsBuilder_.dispose();
            aggregationsBuilder_ = null;
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            aggregationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAggregationsFieldBuilder()
                    : null;
          } else {
            aggregationsBuilder_.addAllMessages(other.aggregations_);
          }
        }
      }
      switch (other.getQueryTypeCase()) {
        case STRUCTURED_QUERY:
          {
            mergeStructuredQuery(other.getStructuredQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStructuredQueryFieldBuilder().getBuilder(), extensionRegistry);
                queryTypeCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation m =
                    input.readMessage(
                        com.google.firestore.v1.StructuredAggregationQuery.Aggregation.parser(),
                        extensionRegistry);
                if (aggregationsBuilder_ == null) {
                  ensureAggregationsIsMutable();
                  aggregations_.add(m);
                } else {
                  aggregationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        structuredQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     *
     * @return Whether the structuredQuery field is set.
     */
    @java.lang.Override
    public boolean hasStructuredQuery() {
      return queryTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     *
     * @return The structuredQuery.
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQuery getStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 1) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 1) {
          return structuredQueryBuilder_.getMessage();
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    public Builder setStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    public Builder setStructuredQuery(
        com.google.firestore.v1.StructuredQuery.Builder builderForValue) {
      if (structuredQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        structuredQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    public Builder mergeStructuredQuery(com.google.firestore.v1.StructuredQuery value) {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 1
            && queryType_ != com.google.firestore.v1.StructuredQuery.getDefaultInstance()) {
          queryType_ =
              com.google.firestore.v1.StructuredQuery.newBuilder(
                      (com.google.firestore.v1.StructuredQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 1) {
          structuredQueryBuilder_.mergeFrom(value);
        } else {
          structuredQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    public Builder clearStructuredQuery() {
      if (structuredQueryBuilder_ == null) {
        if (queryTypeCase_ == 1) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 1) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        structuredQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    public com.google.firestore.v1.StructuredQuery.Builder getStructuredQueryBuilder() {
      return getStructuredQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    @java.lang.Override
    public com.google.firestore.v1.StructuredQueryOrBuilder getStructuredQueryOrBuilder() {
      if ((queryTypeCase_ == 1) && (structuredQueryBuilder_ != null)) {
        return structuredQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 1) {
          return (com.google.firestore.v1.StructuredQuery) queryType_;
        }
        return com.google.firestore.v1.StructuredQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Nested structured query.
     * </pre>
     *
     * <code>.google.firestore.v1.StructuredQuery structured_query = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.firestore.v1.StructuredQuery,
            com.google.firestore.v1.StructuredQuery.Builder,
            com.google.firestore.v1.StructuredQueryOrBuilder>
        getStructuredQueryFieldBuilder() {
      if (structuredQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 1)) {
          queryType_ = com.google.firestore.v1.StructuredQuery.getDefaultInstance();
        }
        structuredQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.firestore.v1.StructuredQuery,
                com.google.firestore.v1.StructuredQuery.Builder,
                com.google.firestore.v1.StructuredQueryOrBuilder>(
                (com.google.firestore.v1.StructuredQuery) queryType_,
                getParentForChildren(),
                isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 1;
      onChanged();
      return structuredQueryBuilder_;
    }

    private java.util.List<com.google.firestore.v1.StructuredAggregationQuery.Aggregation>
        aggregations_ = java.util.Collections.emptyList();

    private void ensureAggregationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        aggregations_ =
            new java.util.ArrayList<com.google.firestore.v1.StructuredAggregationQuery.Aggregation>(
                aggregations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation,
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder,
            com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder>
        aggregationsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.firestore.v1.StructuredAggregationQuery.Aggregation>
        getAggregationsList() {
      if (aggregationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregations_);
      } else {
        return aggregationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAggregationsCount() {
      if (aggregationsBuilder_ == null) {
        return aggregations_.size();
      } else {
        return aggregationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation getAggregations(
        int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAggregations(
        int index, com.google.firestore.v1.StructuredAggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.set(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAggregations(
        int index,
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        int index, com.google.firestore.v1.StructuredAggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        int index,
        com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAggregations(
        java.lang.Iterable<? extends com.google.firestore.v1.StructuredAggregationQuery.Aggregation>
            values) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
        onChanged();
      } else {
        aggregationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAggregations() {
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        aggregationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAggregations(int index) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.remove(index);
        onChanged();
      } else {
        aggregationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder
        getAggregationsBuilder(int index) {
      return getAggregationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder
        getAggregationsOrBuilder(int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder>
        getAggregationsOrBuilderList() {
      if (aggregationsBuilder_ != null) {
        return aggregationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder
        addAggregationsBuilder() {
      return getAggregationsFieldBuilder()
          .addBuilder(
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder
        addAggregationsBuilder(int index) {
      return getAggregationsFieldBuilder()
          .addBuilder(
              index,
              com.google.firestore.v1.StructuredAggregationQuery.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `structured_query`.
     * Requires:
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.firestore.v1.StructuredAggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder>
        getAggregationsBuilderList() {
      return getAggregationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation,
            com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder,
            com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder>
        getAggregationsFieldBuilder() {
      if (aggregationsBuilder_ == null) {
        aggregationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation,
                com.google.firestore.v1.StructuredAggregationQuery.Aggregation.Builder,
                com.google.firestore.v1.StructuredAggregationQuery.AggregationOrBuilder>(
                aggregations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        aggregations_ = null;
      }
      return aggregationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.firestore.v1.StructuredAggregationQuery)
  }

  // @@protoc_insertion_point(class_scope:google.firestore.v1.StructuredAggregationQuery)
  private static final com.google.firestore.v1.StructuredAggregationQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.firestore.v1.StructuredAggregationQuery();
  }

  public static com.google.firestore.v1.StructuredAggregationQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StructuredAggregationQuery> PARSER =
      new com.google.protobuf.AbstractParser<StructuredAggregationQuery>() {
        @java.lang.Override
        public StructuredAggregationQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StructuredAggregationQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StructuredAggregationQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.firestore.v1.StructuredAggregationQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
