/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkebackup.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VolumeBackupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_BACKUP_PLAN_BACKUP_VOLUME_BACKUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/backupPlans/{backup_plan}/backups/{backup}/volumeBackups/{volume_backup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String backupPlan;
    private final String backup;
    private final String volumeBackup;

    @Deprecated
    protected VolumeBackupName() {
        this.project = null;
        this.location = null;
        this.backupPlan = null;
        this.backup = null;
        this.volumeBackup = null;
    }

    private VolumeBackupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.backupPlan = (String)Preconditions.checkNotNull((Object)builder.getBackupPlan());
        this.backup = (String)Preconditions.checkNotNull((Object)builder.getBackup());
        this.volumeBackup = (String)Preconditions.checkNotNull((Object)builder.getVolumeBackup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBackupPlan() {
        return this.backupPlan;
    }

    public String getBackup() {
        return this.backup;
    }

    public String getVolumeBackup() {
        return this.volumeBackup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VolumeBackupName of(String project, String location, String backupPlan, String backup, String volumeBackup) {
        return VolumeBackupName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).setBackup(backup).setVolumeBackup(volumeBackup).build();
    }

    public static String format(String project, String location, String backupPlan, String backup, String volumeBackup) {
        return VolumeBackupName.newBuilder().setProject(project).setLocation(location).setBackupPlan(backupPlan).setBackup(backup).setVolumeBackup(volumeBackup).build().toString();
    }

    public static VolumeBackupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_BACKUP_PLAN_BACKUP_VOLUME_BACKUP.validatedMatch(formattedString, "VolumeBackupName.parse: formattedString not in valid format");
        return VolumeBackupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("backup_plan"), (String)matchMap.get("backup"), (String)matchMap.get("volume_backup"));
    }

    public static List<VolumeBackupName> parseList(List<String> formattedStrings) {
        ArrayList<VolumeBackupName> list = new ArrayList<VolumeBackupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VolumeBackupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VolumeBackupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VolumeBackupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_BACKUP_PLAN_BACKUP_VOLUME_BACKUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VolumeBackupName volumeBackupName = this;
            synchronized (volumeBackupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.backupPlan != null) {
                        fieldMapBuilder.put((Object)"backup_plan", (Object)this.backupPlan);
                    }
                    if (this.backup != null) {
                        fieldMapBuilder.put((Object)"backup", (Object)this.backup);
                    }
                    if (this.volumeBackup != null) {
                        fieldMapBuilder.put((Object)"volume_backup", (Object)this.volumeBackup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_BACKUP_PLAN_BACKUP_VOLUME_BACKUP.instantiate(new String[]{"project", this.project, "location", this.location, "backup_plan", this.backupPlan, "backup", this.backup, "volume_backup", this.volumeBackup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VolumeBackupName that = (VolumeBackupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.backupPlan, that.backupPlan) && Objects.equals(this.backup, that.backup) && Objects.equals(this.volumeBackup, that.volumeBackup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.backupPlan);
        h *= 1000003;
        h ^= Objects.hashCode(this.backup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.volumeBackup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String backupPlan;
        private String backup;
        private String volumeBackup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBackupPlan() {
            return this.backupPlan;
        }

        public String getBackup() {
            return this.backup;
        }

        public String getVolumeBackup() {
            return this.volumeBackup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBackupPlan(String backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public Builder setBackup(String backup) {
            this.backup = backup;
            return this;
        }

        public Builder setVolumeBackup(String volumeBackup) {
            this.volumeBackup = volumeBackup;
            return this;
        }

        private Builder(VolumeBackupName volumeBackupName) {
            this.project = volumeBackupName.project;
            this.location = volumeBackupName.location;
            this.backupPlan = volumeBackupName.backupPlan;
            this.backup = volumeBackupName.backup;
            this.volumeBackup = volumeBackupName.volumeBackup;
        }

        public VolumeBackupName build() {
            return new VolumeBackupName(this);
        }
    }
}

