/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AwsClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AWS_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/awsClusters/{aws_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String awsCluster;

    @Deprecated
    protected AwsClusterName() {
        this.project = null;
        this.location = null;
        this.awsCluster = null;
    }

    private AwsClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.awsCluster = (String)Preconditions.checkNotNull((Object)builder.getAwsCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAwsCluster() {
        return this.awsCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AwsClusterName of(String project, String location, String awsCluster) {
        return AwsClusterName.newBuilder().setProject(project).setLocation(location).setAwsCluster(awsCluster).build();
    }

    public static String format(String project, String location, String awsCluster) {
        return AwsClusterName.newBuilder().setProject(project).setLocation(location).setAwsCluster(awsCluster).build().toString();
    }

    public static AwsClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AWS_CLUSTER.validatedMatch(formattedString, "AwsClusterName.parse: formattedString not in valid format");
        return AwsClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("aws_cluster"));
    }

    public static List<AwsClusterName> parseList(List<String> formattedStrings) {
        ArrayList<AwsClusterName> list = new ArrayList<AwsClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AwsClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AwsClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AwsClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AWS_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AwsClusterName awsClusterName = this;
            synchronized (awsClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.awsCluster != null) {
                        fieldMapBuilder.put((Object)"aws_cluster", (Object)this.awsCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AWS_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "aws_cluster", this.awsCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AwsClusterName that = (AwsClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.awsCluster, that.awsCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.awsCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String awsCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAwsCluster() {
            return this.awsCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAwsCluster(String awsCluster) {
            this.awsCluster = awsCluster;
            return this;
        }

        private Builder(AwsClusterName awsClusterName) {
            this.project = awsClusterName.project;
            this.location = awsClusterName.location;
            this.awsCluster = awsClusterName.awsCluster;
        }

        public AwsClusterName build() {
            return new AwsClusterName(this);
        }
    }
}

