/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AwsNodePoolName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AWS_CLUSTER_AWS_NODE_POOL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/awsClusters/{aws_cluster}/awsNodePools/{aws_node_pool}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String awsCluster;
    private final String awsNodePool;

    @Deprecated
    protected AwsNodePoolName() {
        this.project = null;
        this.location = null;
        this.awsCluster = null;
        this.awsNodePool = null;
    }

    private AwsNodePoolName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.awsCluster = (String)Preconditions.checkNotNull((Object)builder.getAwsCluster());
        this.awsNodePool = (String)Preconditions.checkNotNull((Object)builder.getAwsNodePool());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAwsCluster() {
        return this.awsCluster;
    }

    public String getAwsNodePool() {
        return this.awsNodePool;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AwsNodePoolName of(String project, String location, String awsCluster, String awsNodePool) {
        return AwsNodePoolName.newBuilder().setProject(project).setLocation(location).setAwsCluster(awsCluster).setAwsNodePool(awsNodePool).build();
    }

    public static String format(String project, String location, String awsCluster, String awsNodePool) {
        return AwsNodePoolName.newBuilder().setProject(project).setLocation(location).setAwsCluster(awsCluster).setAwsNodePool(awsNodePool).build().toString();
    }

    public static AwsNodePoolName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AWS_CLUSTER_AWS_NODE_POOL.validatedMatch(formattedString, "AwsNodePoolName.parse: formattedString not in valid format");
        return AwsNodePoolName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("aws_cluster"), (String)matchMap.get("aws_node_pool"));
    }

    public static List<AwsNodePoolName> parseList(List<String> formattedStrings) {
        ArrayList<AwsNodePoolName> list = new ArrayList<AwsNodePoolName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AwsNodePoolName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AwsNodePoolName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AwsNodePoolName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AWS_CLUSTER_AWS_NODE_POOL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AwsNodePoolName awsNodePoolName = this;
            synchronized (awsNodePoolName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.awsCluster != null) {
                        fieldMapBuilder.put((Object)"aws_cluster", (Object)this.awsCluster);
                    }
                    if (this.awsNodePool != null) {
                        fieldMapBuilder.put((Object)"aws_node_pool", (Object)this.awsNodePool);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AWS_CLUSTER_AWS_NODE_POOL.instantiate(new String[]{"project", this.project, "location", this.location, "aws_cluster", this.awsCluster, "aws_node_pool", this.awsNodePool});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AwsNodePoolName that = (AwsNodePoolName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.awsCluster, that.awsCluster) && Objects.equals(this.awsNodePool, that.awsNodePool);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.awsCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.awsNodePool);
    }

    public static class Builder {
        private String project;
        private String location;
        private String awsCluster;
        private String awsNodePool;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAwsCluster() {
            return this.awsCluster;
        }

        public String getAwsNodePool() {
            return this.awsNodePool;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAwsCluster(String awsCluster) {
            this.awsCluster = awsCluster;
            return this;
        }

        public Builder setAwsNodePool(String awsNodePool) {
            this.awsNodePool = awsNodePool;
            return this;
        }

        private Builder(AwsNodePoolName awsNodePoolName) {
            this.project = awsNodePoolName.project;
            this.location = awsNodePoolName.location;
            this.awsCluster = awsNodePoolName.awsCluster;
            this.awsNodePool = awsNodePoolName.awsNodePool;
        }

        public AwsNodePoolName build() {
            return new AwsNodePoolName(this);
        }
    }
}

