/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iot.v1;

import com.google.cloud.iot.v1.DeviceConfig;
import com.google.cloud.iot.v1.DeviceConfigOrBuilder;
import com.google.cloud.iot.v1.DeviceCredential;
import com.google.cloud.iot.v1.DeviceCredentialOrBuilder;
import com.google.cloud.iot.v1.DeviceOrBuilder;
import com.google.cloud.iot.v1.DeviceState;
import com.google.cloud.iot.v1.DeviceStateOrBuilder;
import com.google.cloud.iot.v1.GatewayConfig;
import com.google.cloud.iot.v1.GatewayConfigOrBuilder;
import com.google.cloud.iot.v1.LogLevel;
import com.google.cloud.iot.v1.ResourcesProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import com.google.rpc.Status;
import com.google.rpc.StatusOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Device
extends GeneratedMessageV3
implements DeviceOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile Object id_ = "";
    public static final int NAME_FIELD_NUMBER = 2;
    private volatile Object name_ = "";
    public static final int NUM_ID_FIELD_NUMBER = 3;
    private long numId_ = 0L;
    public static final int CREDENTIALS_FIELD_NUMBER = 12;
    private List<DeviceCredential> credentials_;
    public static final int LAST_HEARTBEAT_TIME_FIELD_NUMBER = 7;
    private Timestamp lastHeartbeatTime_;
    public static final int LAST_EVENT_TIME_FIELD_NUMBER = 8;
    private Timestamp lastEventTime_;
    public static final int LAST_STATE_TIME_FIELD_NUMBER = 20;
    private Timestamp lastStateTime_;
    public static final int LAST_CONFIG_ACK_TIME_FIELD_NUMBER = 14;
    private Timestamp lastConfigAckTime_;
    public static final int LAST_CONFIG_SEND_TIME_FIELD_NUMBER = 18;
    private Timestamp lastConfigSendTime_;
    public static final int BLOCKED_FIELD_NUMBER = 19;
    private boolean blocked_ = false;
    public static final int LAST_ERROR_TIME_FIELD_NUMBER = 10;
    private Timestamp lastErrorTime_;
    public static final int LAST_ERROR_STATUS_FIELD_NUMBER = 11;
    private Status lastErrorStatus_;
    public static final int CONFIG_FIELD_NUMBER = 13;
    private DeviceConfig config_;
    public static final int STATE_FIELD_NUMBER = 16;
    private DeviceState state_;
    public static final int LOG_LEVEL_FIELD_NUMBER = 21;
    private int logLevel_ = 0;
    public static final int METADATA_FIELD_NUMBER = 17;
    private MapField<String, String> metadata_;
    public static final int GATEWAY_CONFIG_FIELD_NUMBER = 24;
    private GatewayConfig gatewayConfig_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Device DEFAULT_INSTANCE = new Device();
    private static final Parser<Device> PARSER = new AbstractParser<Device>(){

        public Device parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Device.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Device(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Device() {
        this.id_ = "";
        this.name_ = "";
        this.credentials_ = Collections.emptyList();
        this.logLevel_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Device();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ResourcesProto.internal_static_google_cloud_iot_v1_Device_descriptor;
    }

    protected MapField internalGetMapField(int number) {
        switch (number) {
            case 17: {
                return this.internalGetMetadata();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ResourcesProto.internal_static_google_cloud_iot_v1_Device_fieldAccessorTable.ensureFieldAccessorsInitialized(Device.class, Builder.class);
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getNumId() {
        return this.numId_;
    }

    @Override
    public List<DeviceCredential> getCredentialsList() {
        return this.credentials_;
    }

    @Override
    public List<? extends DeviceCredentialOrBuilder> getCredentialsOrBuilderList() {
        return this.credentials_;
    }

    @Override
    public int getCredentialsCount() {
        return this.credentials_.size();
    }

    @Override
    public DeviceCredential getCredentials(int index) {
        return this.credentials_.get(index);
    }

    @Override
    public DeviceCredentialOrBuilder getCredentialsOrBuilder(int index) {
        return this.credentials_.get(index);
    }

    @Override
    public boolean hasLastHeartbeatTime() {
        return this.lastHeartbeatTime_ != null;
    }

    @Override
    public Timestamp getLastHeartbeatTime() {
        return this.lastHeartbeatTime_ == null ? Timestamp.getDefaultInstance() : this.lastHeartbeatTime_;
    }

    @Override
    public TimestampOrBuilder getLastHeartbeatTimeOrBuilder() {
        return this.lastHeartbeatTime_ == null ? Timestamp.getDefaultInstance() : this.lastHeartbeatTime_;
    }

    @Override
    public boolean hasLastEventTime() {
        return this.lastEventTime_ != null;
    }

    @Override
    public Timestamp getLastEventTime() {
        return this.lastEventTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventTime_;
    }

    @Override
    public TimestampOrBuilder getLastEventTimeOrBuilder() {
        return this.lastEventTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventTime_;
    }

    @Override
    public boolean hasLastStateTime() {
        return this.lastStateTime_ != null;
    }

    @Override
    public Timestamp getLastStateTime() {
        return this.lastStateTime_ == null ? Timestamp.getDefaultInstance() : this.lastStateTime_;
    }

    @Override
    public TimestampOrBuilder getLastStateTimeOrBuilder() {
        return this.lastStateTime_ == null ? Timestamp.getDefaultInstance() : this.lastStateTime_;
    }

    @Override
    public boolean hasLastConfigAckTime() {
        return this.lastConfigAckTime_ != null;
    }

    @Override
    public Timestamp getLastConfigAckTime() {
        return this.lastConfigAckTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigAckTime_;
    }

    @Override
    public TimestampOrBuilder getLastConfigAckTimeOrBuilder() {
        return this.lastConfigAckTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigAckTime_;
    }

    @Override
    public boolean hasLastConfigSendTime() {
        return this.lastConfigSendTime_ != null;
    }

    @Override
    public Timestamp getLastConfigSendTime() {
        return this.lastConfigSendTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigSendTime_;
    }

    @Override
    public TimestampOrBuilder getLastConfigSendTimeOrBuilder() {
        return this.lastConfigSendTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigSendTime_;
    }

    @Override
    public boolean getBlocked() {
        return this.blocked_;
    }

    @Override
    public boolean hasLastErrorTime() {
        return this.lastErrorTime_ != null;
    }

    @Override
    public Timestamp getLastErrorTime() {
        return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
    }

    @Override
    public TimestampOrBuilder getLastErrorTimeOrBuilder() {
        return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
    }

    @Override
    public boolean hasLastErrorStatus() {
        return this.lastErrorStatus_ != null;
    }

    @Override
    public Status getLastErrorStatus() {
        return this.lastErrorStatus_ == null ? Status.getDefaultInstance() : this.lastErrorStatus_;
    }

    @Override
    public StatusOrBuilder getLastErrorStatusOrBuilder() {
        return this.lastErrorStatus_ == null ? Status.getDefaultInstance() : this.lastErrorStatus_;
    }

    @Override
    public boolean hasConfig() {
        return this.config_ != null;
    }

    @Override
    public DeviceConfig getConfig() {
        return this.config_ == null ? DeviceConfig.getDefaultInstance() : this.config_;
    }

    @Override
    public DeviceConfigOrBuilder getConfigOrBuilder() {
        return this.config_ == null ? DeviceConfig.getDefaultInstance() : this.config_;
    }

    @Override
    public boolean hasState() {
        return this.state_ != null;
    }

    @Override
    public DeviceState getState() {
        return this.state_ == null ? DeviceState.getDefaultInstance() : this.state_;
    }

    @Override
    public DeviceStateOrBuilder getStateOrBuilder() {
        return this.state_ == null ? DeviceState.getDefaultInstance() : this.state_;
    }

    @Override
    public int getLogLevelValue() {
        return this.logLevel_;
    }

    @Override
    public LogLevel getLogLevel() {
        LogLevel result = LogLevel.forNumber(this.logLevel_);
        return result == null ? LogLevel.UNRECOGNIZED : result;
    }

    private MapField<String, String> internalGetMetadata() {
        if (this.metadata_ == null) {
            return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
        }
        return this.metadata_;
    }

    @Override
    public int getMetadataCount() {
        return this.internalGetMetadata().getMap().size();
    }

    @Override
    public boolean containsMetadata(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetMetadata().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getMetadata() {
        return this.getMetadataMap();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        return this.internalGetMetadata().getMap();
    }

    @Override
    public String getMetadataOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetMetadata().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getMetadataOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetMetadata().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public boolean hasGatewayConfig() {
        return this.gatewayConfig_ != null;
    }

    @Override
    public GatewayConfig getGatewayConfig() {
        return this.gatewayConfig_ == null ? GatewayConfig.getDefaultInstance() : this.gatewayConfig_;
    }

    @Override
    public GatewayConfigOrBuilder getGatewayConfigOrBuilder() {
        return this.gatewayConfig_ == null ? GatewayConfig.getDefaultInstance() : this.gatewayConfig_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.id_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.name_);
        }
        if (this.numId_ != 0L) {
            output.writeUInt64(3, this.numId_);
        }
        if (this.lastHeartbeatTime_ != null) {
            output.writeMessage(7, (MessageLite)this.getLastHeartbeatTime());
        }
        if (this.lastEventTime_ != null) {
            output.writeMessage(8, (MessageLite)this.getLastEventTime());
        }
        if (this.lastErrorTime_ != null) {
            output.writeMessage(10, (MessageLite)this.getLastErrorTime());
        }
        if (this.lastErrorStatus_ != null) {
            output.writeMessage(11, (MessageLite)this.getLastErrorStatus());
        }
        for (int i = 0; i < this.credentials_.size(); ++i) {
            output.writeMessage(12, (MessageLite)this.credentials_.get(i));
        }
        if (this.config_ != null) {
            output.writeMessage(13, (MessageLite)this.getConfig());
        }
        if (this.lastConfigAckTime_ != null) {
            output.writeMessage(14, (MessageLite)this.getLastConfigAckTime());
        }
        if (this.state_ != null) {
            output.writeMessage(16, (MessageLite)this.getState());
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, (int)17);
        if (this.lastConfigSendTime_ != null) {
            output.writeMessage(18, (MessageLite)this.getLastConfigSendTime());
        }
        if (this.blocked_) {
            output.writeBool(19, this.blocked_);
        }
        if (this.lastStateTime_ != null) {
            output.writeMessage(20, (MessageLite)this.getLastStateTime());
        }
        if (this.logLevel_ != LogLevel.LOG_LEVEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(21, this.logLevel_);
        }
        if (this.gatewayConfig_ != null) {
            output.writeMessage(24, (MessageLite)this.getGatewayConfig());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.id_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.name_);
        }
        if (this.numId_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)3, (long)this.numId_);
        }
        if (this.lastHeartbeatTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getLastHeartbeatTime());
        }
        if (this.lastEventTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getLastEventTime());
        }
        if (this.lastErrorTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getLastErrorTime());
        }
        if (this.lastErrorStatus_ != null) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getLastErrorStatus());
        }
        for (int i = 0; i < this.credentials_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)((MessageLite)this.credentials_.get(i)));
        }
        if (this.config_ != null) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)this.getConfig());
        }
        if (this.lastConfigAckTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getLastConfigAckTime());
        }
        if (this.state_ != null) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)this.getState());
        }
        for (Map.Entry entry : this.internalGetMetadata().getMap().entrySet()) {
            MapEntry metadata__ = MetadataDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)metadata__);
        }
        if (this.lastConfigSendTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getLastConfigSendTime());
        }
        if (this.blocked_) {
            size += CodedOutputStream.computeBoolSize((int)19, (boolean)this.blocked_);
        }
        if (this.lastStateTime_ != null) {
            size += CodedOutputStream.computeMessageSize((int)20, (MessageLite)this.getLastStateTime());
        }
        if (this.logLevel_ != LogLevel.LOG_LEVEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)21, (int)this.logLevel_);
        }
        if (this.gatewayConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)24, (MessageLite)this.getGatewayConfig());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Device)) {
            return super.equals(obj);
        }
        Device other = (Device)obj;
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getNumId() != other.getNumId()) {
            return false;
        }
        if (!this.getCredentialsList().equals(other.getCredentialsList())) {
            return false;
        }
        if (this.hasLastHeartbeatTime() != other.hasLastHeartbeatTime()) {
            return false;
        }
        if (this.hasLastHeartbeatTime() && !this.getLastHeartbeatTime().equals((Object)other.getLastHeartbeatTime())) {
            return false;
        }
        if (this.hasLastEventTime() != other.hasLastEventTime()) {
            return false;
        }
        if (this.hasLastEventTime() && !this.getLastEventTime().equals((Object)other.getLastEventTime())) {
            return false;
        }
        if (this.hasLastStateTime() != other.hasLastStateTime()) {
            return false;
        }
        if (this.hasLastStateTime() && !this.getLastStateTime().equals((Object)other.getLastStateTime())) {
            return false;
        }
        if (this.hasLastConfigAckTime() != other.hasLastConfigAckTime()) {
            return false;
        }
        if (this.hasLastConfigAckTime() && !this.getLastConfigAckTime().equals((Object)other.getLastConfigAckTime())) {
            return false;
        }
        if (this.hasLastConfigSendTime() != other.hasLastConfigSendTime()) {
            return false;
        }
        if (this.hasLastConfigSendTime() && !this.getLastConfigSendTime().equals((Object)other.getLastConfigSendTime())) {
            return false;
        }
        if (this.getBlocked() != other.getBlocked()) {
            return false;
        }
        if (this.hasLastErrorTime() != other.hasLastErrorTime()) {
            return false;
        }
        if (this.hasLastErrorTime() && !this.getLastErrorTime().equals((Object)other.getLastErrorTime())) {
            return false;
        }
        if (this.hasLastErrorStatus() != other.hasLastErrorStatus()) {
            return false;
        }
        if (this.hasLastErrorStatus() && !this.getLastErrorStatus().equals((Object)other.getLastErrorStatus())) {
            return false;
        }
        if (this.hasConfig() != other.hasConfig()) {
            return false;
        }
        if (this.hasConfig() && !this.getConfig().equals(other.getConfig())) {
            return false;
        }
        if (this.hasState() != other.hasState()) {
            return false;
        }
        if (this.hasState() && !this.getState().equals(other.getState())) {
            return false;
        }
        if (this.logLevel_ != other.logLevel_) {
            return false;
        }
        if (!this.internalGetMetadata().equals(other.internalGetMetadata())) {
            return false;
        }
        if (this.hasGatewayConfig() != other.hasGatewayConfig()) {
            return false;
        }
        if (this.hasGatewayConfig() && !this.getGatewayConfig().equals(other.getGatewayConfig())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Device.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getNumId());
        if (this.getCredentialsCount() > 0) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getCredentialsList().hashCode();
        }
        if (this.hasLastHeartbeatTime()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getLastHeartbeatTime().hashCode();
        }
        if (this.hasLastEventTime()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getLastEventTime().hashCode();
        }
        if (this.hasLastStateTime()) {
            hash = 37 * hash + 20;
            hash = 53 * hash + this.getLastStateTime().hashCode();
        }
        if (this.hasLastConfigAckTime()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getLastConfigAckTime().hashCode();
        }
        if (this.hasLastConfigSendTime()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getLastConfigSendTime().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getBlocked());
        if (this.hasLastErrorTime()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getLastErrorTime().hashCode();
        }
        if (this.hasLastErrorStatus()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getLastErrorStatus().hashCode();
        }
        if (this.hasConfig()) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getConfig().hashCode();
        }
        if (this.hasState()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getState().hashCode();
        }
        hash = 37 * hash + 21;
        hash = 53 * hash + this.logLevel_;
        if (!this.internalGetMetadata().getMap().isEmpty()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.internalGetMetadata().hashCode();
        }
        if (this.hasGatewayConfig()) {
            hash = 37 * hash + 24;
            hash = 53 * hash + this.getGatewayConfig().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Device parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data);
    }

    public static Device parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Device parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data);
    }

    public static Device parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Device parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data);
    }

    public static Device parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Device)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Device parseFrom(InputStream input) throws IOException {
        return (Device)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Device parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Device)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Device parseDelimitedFrom(InputStream input) throws IOException {
        return (Device)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Device parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Device)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Device parseFrom(CodedInputStream input) throws IOException {
        return (Device)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Device parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Device)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Device.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Device prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Device getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Device> parser() {
        return PARSER;
    }

    public Parser<Device> getParserForType() {
        return PARSER;
    }

    public Device getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DeviceOrBuilder {
        private int bitField0_;
        private Object id_ = "";
        private Object name_ = "";
        private long numId_;
        private List<DeviceCredential> credentials_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<DeviceCredential, DeviceCredential.Builder, DeviceCredentialOrBuilder> credentialsBuilder_;
        private Timestamp lastHeartbeatTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastHeartbeatTimeBuilder_;
        private Timestamp lastEventTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastEventTimeBuilder_;
        private Timestamp lastStateTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastStateTimeBuilder_;
        private Timestamp lastConfigAckTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastConfigAckTimeBuilder_;
        private Timestamp lastConfigSendTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastConfigSendTimeBuilder_;
        private boolean blocked_;
        private Timestamp lastErrorTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> lastErrorTimeBuilder_;
        private Status lastErrorStatus_;
        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> lastErrorStatusBuilder_;
        private DeviceConfig config_;
        private SingleFieldBuilderV3<DeviceConfig, DeviceConfig.Builder, DeviceConfigOrBuilder> configBuilder_;
        private DeviceState state_;
        private SingleFieldBuilderV3<DeviceState, DeviceState.Builder, DeviceStateOrBuilder> stateBuilder_;
        private int logLevel_ = 0;
        private MapField<String, String> metadata_;
        private GatewayConfig gatewayConfig_;
        private SingleFieldBuilderV3<GatewayConfig, GatewayConfig.Builder, GatewayConfigOrBuilder> gatewayConfigBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return ResourcesProto.internal_static_google_cloud_iot_v1_Device_descriptor;
        }

        protected MapField internalGetMapField(int number) {
            switch (number) {
                case 17: {
                    return this.internalGetMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapField internalGetMutableMapField(int number) {
            switch (number) {
                case 17: {
                    return this.internalGetMutableMetadata();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ResourcesProto.internal_static_google_cloud_iot_v1_Device_fieldAccessorTable.ensureFieldAccessorsInitialized(Device.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.id_ = "";
            this.name_ = "";
            this.numId_ = 0L;
            if (this.credentialsBuilder_ == null) {
                this.credentials_ = Collections.emptyList();
            } else {
                this.credentials_ = null;
                this.credentialsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.lastHeartbeatTime_ = null;
            if (this.lastHeartbeatTimeBuilder_ != null) {
                this.lastHeartbeatTimeBuilder_.dispose();
                this.lastHeartbeatTimeBuilder_ = null;
            }
            this.lastEventTime_ = null;
            if (this.lastEventTimeBuilder_ != null) {
                this.lastEventTimeBuilder_.dispose();
                this.lastEventTimeBuilder_ = null;
            }
            this.lastStateTime_ = null;
            if (this.lastStateTimeBuilder_ != null) {
                this.lastStateTimeBuilder_.dispose();
                this.lastStateTimeBuilder_ = null;
            }
            this.lastConfigAckTime_ = null;
            if (this.lastConfigAckTimeBuilder_ != null) {
                this.lastConfigAckTimeBuilder_.dispose();
                this.lastConfigAckTimeBuilder_ = null;
            }
            this.lastConfigSendTime_ = null;
            if (this.lastConfigSendTimeBuilder_ != null) {
                this.lastConfigSendTimeBuilder_.dispose();
                this.lastConfigSendTimeBuilder_ = null;
            }
            this.blocked_ = false;
            this.lastErrorTime_ = null;
            if (this.lastErrorTimeBuilder_ != null) {
                this.lastErrorTimeBuilder_.dispose();
                this.lastErrorTimeBuilder_ = null;
            }
            this.lastErrorStatus_ = null;
            if (this.lastErrorStatusBuilder_ != null) {
                this.lastErrorStatusBuilder_.dispose();
                this.lastErrorStatusBuilder_ = null;
            }
            this.config_ = null;
            if (this.configBuilder_ != null) {
                this.configBuilder_.dispose();
                this.configBuilder_ = null;
            }
            this.state_ = null;
            if (this.stateBuilder_ != null) {
                this.stateBuilder_.dispose();
                this.stateBuilder_ = null;
            }
            this.logLevel_ = 0;
            this.internalGetMutableMetadata().clear();
            this.gatewayConfig_ = null;
            if (this.gatewayConfigBuilder_ != null) {
                this.gatewayConfigBuilder_.dispose();
                this.gatewayConfigBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ResourcesProto.internal_static_google_cloud_iot_v1_Device_descriptor;
        }

        public Device getDefaultInstanceForType() {
            return Device.getDefaultInstance();
        }

        public Device build() {
            Device result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Device buildPartial() {
            Device result = new Device(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Device result) {
            if (this.credentialsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.credentials_ = Collections.unmodifiableList(this.credentials_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.credentials_ = this.credentials_;
            } else {
                result.credentials_ = this.credentialsBuilder_.build();
            }
        }

        private void buildPartial0(Device result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.id_ = this.id_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.numId_ = this.numId_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.lastHeartbeatTime_ = this.lastHeartbeatTimeBuilder_ == null ? this.lastHeartbeatTime_ : (Timestamp)this.lastHeartbeatTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.lastEventTime_ = this.lastEventTimeBuilder_ == null ? this.lastEventTime_ : (Timestamp)this.lastEventTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.lastStateTime_ = this.lastStateTimeBuilder_ == null ? this.lastStateTime_ : (Timestamp)this.lastStateTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.lastConfigAckTime_ = this.lastConfigAckTimeBuilder_ == null ? this.lastConfigAckTime_ : (Timestamp)this.lastConfigAckTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.lastConfigSendTime_ = this.lastConfigSendTimeBuilder_ == null ? this.lastConfigSendTime_ : (Timestamp)this.lastConfigSendTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.blocked_ = this.blocked_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.lastErrorTime_ = this.lastErrorTimeBuilder_ == null ? this.lastErrorTime_ : (Timestamp)this.lastErrorTimeBuilder_.build();
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.lastErrorStatus_ = this.lastErrorStatusBuilder_ == null ? this.lastErrorStatus_ : (Status)this.lastErrorStatusBuilder_.build();
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.config_ = this.configBuilder_ == null ? this.config_ : (DeviceConfig)this.configBuilder_.build();
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.state_ = this.stateBuilder_ == null ? this.state_ : (DeviceState)this.stateBuilder_.build();
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.logLevel_ = this.logLevel_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.metadata_ = this.internalGetMetadata();
                result.metadata_.makeImmutable();
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.gatewayConfig_ = this.gatewayConfigBuilder_ == null ? this.gatewayConfig_ : (GatewayConfig)this.gatewayConfigBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Device) {
                return this.mergeFrom((Device)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Device other) {
            if (other == Device.getDefaultInstance()) {
                return this;
            }
            if (!other.getId().isEmpty()) {
                this.id_ = other.id_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (other.getNumId() != 0L) {
                this.setNumId(other.getNumId());
            }
            if (this.credentialsBuilder_ == null) {
                if (!other.credentials_.isEmpty()) {
                    if (this.credentials_.isEmpty()) {
                        this.credentials_ = other.credentials_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureCredentialsIsMutable();
                        this.credentials_.addAll(other.credentials_);
                    }
                    this.onChanged();
                }
            } else if (!other.credentials_.isEmpty()) {
                if (this.credentialsBuilder_.isEmpty()) {
                    this.credentialsBuilder_.dispose();
                    this.credentialsBuilder_ = null;
                    this.credentials_ = other.credentials_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.credentialsBuilder_ = alwaysUseFieldBuilders ? this.getCredentialsFieldBuilder() : null;
                } else {
                    this.credentialsBuilder_.addAllMessages((Iterable)other.credentials_);
                }
            }
            if (other.hasLastHeartbeatTime()) {
                this.mergeLastHeartbeatTime(other.getLastHeartbeatTime());
            }
            if (other.hasLastEventTime()) {
                this.mergeLastEventTime(other.getLastEventTime());
            }
            if (other.hasLastStateTime()) {
                this.mergeLastStateTime(other.getLastStateTime());
            }
            if (other.hasLastConfigAckTime()) {
                this.mergeLastConfigAckTime(other.getLastConfigAckTime());
            }
            if (other.hasLastConfigSendTime()) {
                this.mergeLastConfigSendTime(other.getLastConfigSendTime());
            }
            if (other.getBlocked()) {
                this.setBlocked(other.getBlocked());
            }
            if (other.hasLastErrorTime()) {
                this.mergeLastErrorTime(other.getLastErrorTime());
            }
            if (other.hasLastErrorStatus()) {
                this.mergeLastErrorStatus(other.getLastErrorStatus());
            }
            if (other.hasConfig()) {
                this.mergeConfig(other.getConfig());
            }
            if (other.hasState()) {
                this.mergeState(other.getState());
            }
            if (other.logLevel_ != 0) {
                this.setLogLevelValue(other.getLogLevelValue());
            }
            this.internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
            this.bitField0_ |= 0x8000;
            if (other.hasGatewayConfig()) {
                this.mergeGatewayConfig(other.getGatewayConfig());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block25: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block25;
                        }
                        case 10: {
                            this.id_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block25;
                        }
                        case 18: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block25;
                        }
                        case 24: {
                            this.numId_ = input.readUInt64();
                            this.bitField0_ |= 4;
                            continue block25;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getLastHeartbeatTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block25;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getLastEventTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20;
                            continue block25;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getLastErrorTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block25;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getLastErrorStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block25;
                        }
                        case 98: {
                            DeviceCredential m = (DeviceCredential)input.readMessage(DeviceCredential.parser(), extensionRegistry);
                            if (this.credentialsBuilder_ == null) {
                                this.ensureCredentialsIsMutable();
                                this.credentials_.add(m);
                                continue block25;
                            }
                            this.credentialsBuilder_.addMessage((AbstractMessage)m);
                            continue block25;
                        }
                        case 106: {
                            input.readMessage((MessageLite.Builder)this.getConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block25;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getLastConfigAckTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block25;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getStateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block25;
                        }
                        case 138: {
                            MapEntry metadata__ = (MapEntry)input.readMessage(MetadataDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableMetadata().getMutableMap().put(metadata__.getKey(), metadata__.getValue());
                            this.bitField0_ |= 0x8000;
                            continue block25;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getLastConfigSendTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block25;
                        }
                        case 152: {
                            this.blocked_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block25;
                        }
                        case 162: {
                            input.readMessage((MessageLite.Builder)this.getLastStateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block25;
                        }
                        case 168: {
                            this.logLevel_ = input.readEnum();
                            this.bitField0_ |= 0x4000;
                            continue block25;
                        }
                        case 194: {
                            input.readMessage((MessageLite.Builder)this.getGatewayConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block25;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = Device.getDefaultInstance().getId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Device.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Device.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Device.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public long getNumId() {
            return this.numId_;
        }

        public Builder setNumId(long value) {
            this.numId_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearNumId() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.numId_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureCredentialsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.credentials_ = new ArrayList<DeviceCredential>(this.credentials_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<DeviceCredential> getCredentialsList() {
            if (this.credentialsBuilder_ == null) {
                return Collections.unmodifiableList(this.credentials_);
            }
            return this.credentialsBuilder_.getMessageList();
        }

        @Override
        public int getCredentialsCount() {
            if (this.credentialsBuilder_ == null) {
                return this.credentials_.size();
            }
            return this.credentialsBuilder_.getCount();
        }

        @Override
        public DeviceCredential getCredentials(int index) {
            if (this.credentialsBuilder_ == null) {
                return this.credentials_.get(index);
            }
            return (DeviceCredential)this.credentialsBuilder_.getMessage(index);
        }

        public Builder setCredentials(int index, DeviceCredential value) {
            if (this.credentialsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCredentialsIsMutable();
                this.credentials_.set(index, value);
                this.onChanged();
            } else {
                this.credentialsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setCredentials(int index, DeviceCredential.Builder builderForValue) {
            if (this.credentialsBuilder_ == null) {
                this.ensureCredentialsIsMutable();
                this.credentials_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.credentialsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCredentials(DeviceCredential value) {
            if (this.credentialsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCredentialsIsMutable();
                this.credentials_.add(value);
                this.onChanged();
            } else {
                this.credentialsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addCredentials(int index, DeviceCredential value) {
            if (this.credentialsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCredentialsIsMutable();
                this.credentials_.add(index, value);
                this.onChanged();
            } else {
                this.credentialsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addCredentials(DeviceCredential.Builder builderForValue) {
            if (this.credentialsBuilder_ == null) {
                this.ensureCredentialsIsMutable();
                this.credentials_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.credentialsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addCredentials(int index, DeviceCredential.Builder builderForValue) {
            if (this.credentialsBuilder_ == null) {
                this.ensureCredentialsIsMutable();
                this.credentials_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.credentialsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllCredentials(Iterable<? extends DeviceCredential> values) {
            if (this.credentialsBuilder_ == null) {
                this.ensureCredentialsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.credentials_);
                this.onChanged();
            } else {
                this.credentialsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearCredentials() {
            if (this.credentialsBuilder_ == null) {
                this.credentials_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.credentialsBuilder_.clear();
            }
            return this;
        }

        public Builder removeCredentials(int index) {
            if (this.credentialsBuilder_ == null) {
                this.ensureCredentialsIsMutable();
                this.credentials_.remove(index);
                this.onChanged();
            } else {
                this.credentialsBuilder_.remove(index);
            }
            return this;
        }

        public DeviceCredential.Builder getCredentialsBuilder(int index) {
            return (DeviceCredential.Builder)this.getCredentialsFieldBuilder().getBuilder(index);
        }

        @Override
        public DeviceCredentialOrBuilder getCredentialsOrBuilder(int index) {
            if (this.credentialsBuilder_ == null) {
                return this.credentials_.get(index);
            }
            return (DeviceCredentialOrBuilder)this.credentialsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends DeviceCredentialOrBuilder> getCredentialsOrBuilderList() {
            if (this.credentialsBuilder_ != null) {
                return this.credentialsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.credentials_);
        }

        public DeviceCredential.Builder addCredentialsBuilder() {
            return (DeviceCredential.Builder)this.getCredentialsFieldBuilder().addBuilder((AbstractMessage)DeviceCredential.getDefaultInstance());
        }

        public DeviceCredential.Builder addCredentialsBuilder(int index) {
            return (DeviceCredential.Builder)this.getCredentialsFieldBuilder().addBuilder(index, (AbstractMessage)DeviceCredential.getDefaultInstance());
        }

        public List<DeviceCredential.Builder> getCredentialsBuilderList() {
            return this.getCredentialsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<DeviceCredential, DeviceCredential.Builder, DeviceCredentialOrBuilder> getCredentialsFieldBuilder() {
            if (this.credentialsBuilder_ == null) {
                this.credentialsBuilder_ = new RepeatedFieldBuilderV3(this.credentials_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.credentials_ = null;
            }
            return this.credentialsBuilder_;
        }

        @Override
        public boolean hasLastHeartbeatTime() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Timestamp getLastHeartbeatTime() {
            if (this.lastHeartbeatTimeBuilder_ == null) {
                return this.lastHeartbeatTime_ == null ? Timestamp.getDefaultInstance() : this.lastHeartbeatTime_;
            }
            return (Timestamp)this.lastHeartbeatTimeBuilder_.getMessage();
        }

        public Builder setLastHeartbeatTime(Timestamp value) {
            if (this.lastHeartbeatTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastHeartbeatTime_ = value;
            } else {
                this.lastHeartbeatTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setLastHeartbeatTime(Timestamp.Builder builderForValue) {
            if (this.lastHeartbeatTimeBuilder_ == null) {
                this.lastHeartbeatTime_ = builderForValue.build();
            } else {
                this.lastHeartbeatTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeLastHeartbeatTime(Timestamp value) {
            if (this.lastHeartbeatTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.lastHeartbeatTime_ != null && this.lastHeartbeatTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastHeartbeatTimeBuilder().mergeFrom(value);
                } else {
                    this.lastHeartbeatTime_ = value;
                }
            } else {
                this.lastHeartbeatTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearLastHeartbeatTime() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.lastHeartbeatTime_ = null;
            if (this.lastHeartbeatTimeBuilder_ != null) {
                this.lastHeartbeatTimeBuilder_.dispose();
                this.lastHeartbeatTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastHeartbeatTimeBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Timestamp.Builder)this.getLastHeartbeatTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastHeartbeatTimeOrBuilder() {
            if (this.lastHeartbeatTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastHeartbeatTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastHeartbeatTime_ == null ? Timestamp.getDefaultInstance() : this.lastHeartbeatTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastHeartbeatTimeFieldBuilder() {
            if (this.lastHeartbeatTimeBuilder_ == null) {
                this.lastHeartbeatTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastHeartbeatTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastHeartbeatTime_ = null;
            }
            return this.lastHeartbeatTimeBuilder_;
        }

        @Override
        public boolean hasLastEventTime() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public Timestamp getLastEventTime() {
            if (this.lastEventTimeBuilder_ == null) {
                return this.lastEventTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventTime_;
            }
            return (Timestamp)this.lastEventTimeBuilder_.getMessage();
        }

        public Builder setLastEventTime(Timestamp value) {
            if (this.lastEventTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastEventTime_ = value;
            } else {
                this.lastEventTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setLastEventTime(Timestamp.Builder builderForValue) {
            if (this.lastEventTimeBuilder_ == null) {
                this.lastEventTime_ = builderForValue.build();
            } else {
                this.lastEventTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeLastEventTime(Timestamp value) {
            if (this.lastEventTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.lastEventTime_ != null && this.lastEventTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastEventTimeBuilder().mergeFrom(value);
                } else {
                    this.lastEventTime_ = value;
                }
            } else {
                this.lastEventTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearLastEventTime() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.lastEventTime_ = null;
            if (this.lastEventTimeBuilder_ != null) {
                this.lastEventTimeBuilder_.dispose();
                this.lastEventTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastEventTimeBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (Timestamp.Builder)this.getLastEventTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastEventTimeOrBuilder() {
            if (this.lastEventTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastEventTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastEventTime_ == null ? Timestamp.getDefaultInstance() : this.lastEventTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastEventTimeFieldBuilder() {
            if (this.lastEventTimeBuilder_ == null) {
                this.lastEventTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastEventTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastEventTime_ = null;
            }
            return this.lastEventTimeBuilder_;
        }

        @Override
        public boolean hasLastStateTime() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Timestamp getLastStateTime() {
            if (this.lastStateTimeBuilder_ == null) {
                return this.lastStateTime_ == null ? Timestamp.getDefaultInstance() : this.lastStateTime_;
            }
            return (Timestamp)this.lastStateTimeBuilder_.getMessage();
        }

        public Builder setLastStateTime(Timestamp value) {
            if (this.lastStateTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastStateTime_ = value;
            } else {
                this.lastStateTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setLastStateTime(Timestamp.Builder builderForValue) {
            if (this.lastStateTimeBuilder_ == null) {
                this.lastStateTime_ = builderForValue.build();
            } else {
                this.lastStateTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergeLastStateTime(Timestamp value) {
            if (this.lastStateTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.lastStateTime_ != null && this.lastStateTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastStateTimeBuilder().mergeFrom(value);
                } else {
                    this.lastStateTime_ = value;
                }
            } else {
                this.lastStateTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearLastStateTime() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.lastStateTime_ = null;
            if (this.lastStateTimeBuilder_ != null) {
                this.lastStateTimeBuilder_.dispose();
                this.lastStateTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastStateTimeBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Timestamp.Builder)this.getLastStateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastStateTimeOrBuilder() {
            if (this.lastStateTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastStateTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastStateTime_ == null ? Timestamp.getDefaultInstance() : this.lastStateTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastStateTimeFieldBuilder() {
            if (this.lastStateTimeBuilder_ == null) {
                this.lastStateTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastStateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastStateTime_ = null;
            }
            return this.lastStateTimeBuilder_;
        }

        @Override
        public boolean hasLastConfigAckTime() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getLastConfigAckTime() {
            if (this.lastConfigAckTimeBuilder_ == null) {
                return this.lastConfigAckTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigAckTime_;
            }
            return (Timestamp)this.lastConfigAckTimeBuilder_.getMessage();
        }

        public Builder setLastConfigAckTime(Timestamp value) {
            if (this.lastConfigAckTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastConfigAckTime_ = value;
            } else {
                this.lastConfigAckTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setLastConfigAckTime(Timestamp.Builder builderForValue) {
            if (this.lastConfigAckTimeBuilder_ == null) {
                this.lastConfigAckTime_ = builderForValue.build();
            } else {
                this.lastConfigAckTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeLastConfigAckTime(Timestamp value) {
            if (this.lastConfigAckTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.lastConfigAckTime_ != null && this.lastConfigAckTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastConfigAckTimeBuilder().mergeFrom(value);
                } else {
                    this.lastConfigAckTime_ = value;
                }
            } else {
                this.lastConfigAckTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearLastConfigAckTime() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.lastConfigAckTime_ = null;
            if (this.lastConfigAckTimeBuilder_ != null) {
                this.lastConfigAckTimeBuilder_.dispose();
                this.lastConfigAckTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastConfigAckTimeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getLastConfigAckTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastConfigAckTimeOrBuilder() {
            if (this.lastConfigAckTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastConfigAckTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastConfigAckTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigAckTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastConfigAckTimeFieldBuilder() {
            if (this.lastConfigAckTimeBuilder_ == null) {
                this.lastConfigAckTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastConfigAckTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastConfigAckTime_ = null;
            }
            return this.lastConfigAckTimeBuilder_;
        }

        @Override
        public boolean hasLastConfigSendTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getLastConfigSendTime() {
            if (this.lastConfigSendTimeBuilder_ == null) {
                return this.lastConfigSendTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigSendTime_;
            }
            return (Timestamp)this.lastConfigSendTimeBuilder_.getMessage();
        }

        public Builder setLastConfigSendTime(Timestamp value) {
            if (this.lastConfigSendTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastConfigSendTime_ = value;
            } else {
                this.lastConfigSendTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setLastConfigSendTime(Timestamp.Builder builderForValue) {
            if (this.lastConfigSendTimeBuilder_ == null) {
                this.lastConfigSendTime_ = builderForValue.build();
            } else {
                this.lastConfigSendTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeLastConfigSendTime(Timestamp value) {
            if (this.lastConfigSendTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.lastConfigSendTime_ != null && this.lastConfigSendTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastConfigSendTimeBuilder().mergeFrom(value);
                } else {
                    this.lastConfigSendTime_ = value;
                }
            } else {
                this.lastConfigSendTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearLastConfigSendTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.lastConfigSendTime_ = null;
            if (this.lastConfigSendTimeBuilder_ != null) {
                this.lastConfigSendTimeBuilder_.dispose();
                this.lastConfigSendTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastConfigSendTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getLastConfigSendTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastConfigSendTimeOrBuilder() {
            if (this.lastConfigSendTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastConfigSendTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastConfigSendTime_ == null ? Timestamp.getDefaultInstance() : this.lastConfigSendTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastConfigSendTimeFieldBuilder() {
            if (this.lastConfigSendTimeBuilder_ == null) {
                this.lastConfigSendTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastConfigSendTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastConfigSendTime_ = null;
            }
            return this.lastConfigSendTimeBuilder_;
        }

        @Override
        public boolean getBlocked() {
            return this.blocked_;
        }

        public Builder setBlocked(boolean value) {
            this.blocked_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearBlocked() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.blocked_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasLastErrorTime() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public Timestamp getLastErrorTime() {
            if (this.lastErrorTimeBuilder_ == null) {
                return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
            }
            return (Timestamp)this.lastErrorTimeBuilder_.getMessage();
        }

        public Builder setLastErrorTime(Timestamp value) {
            if (this.lastErrorTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastErrorTime_ = value;
            } else {
                this.lastErrorTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setLastErrorTime(Timestamp.Builder builderForValue) {
            if (this.lastErrorTimeBuilder_ == null) {
                this.lastErrorTime_ = builderForValue.build();
            } else {
                this.lastErrorTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeLastErrorTime(Timestamp value) {
            if (this.lastErrorTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.lastErrorTime_ != null && this.lastErrorTime_ != Timestamp.getDefaultInstance()) {
                    this.getLastErrorTimeBuilder().mergeFrom(value);
                } else {
                    this.lastErrorTime_ = value;
                }
            } else {
                this.lastErrorTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearLastErrorTime() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.lastErrorTime_ = null;
            if (this.lastErrorTimeBuilder_ != null) {
                this.lastErrorTimeBuilder_.dispose();
                this.lastErrorTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getLastErrorTimeBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (Timestamp.Builder)this.getLastErrorTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getLastErrorTimeOrBuilder() {
            if (this.lastErrorTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.lastErrorTimeBuilder_.getMessageOrBuilder();
            }
            return this.lastErrorTime_ == null ? Timestamp.getDefaultInstance() : this.lastErrorTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getLastErrorTimeFieldBuilder() {
            if (this.lastErrorTimeBuilder_ == null) {
                this.lastErrorTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastErrorTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastErrorTime_ = null;
            }
            return this.lastErrorTimeBuilder_;
        }

        @Override
        public boolean hasLastErrorStatus() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public Status getLastErrorStatus() {
            if (this.lastErrorStatusBuilder_ == null) {
                return this.lastErrorStatus_ == null ? Status.getDefaultInstance() : this.lastErrorStatus_;
            }
            return (Status)this.lastErrorStatusBuilder_.getMessage();
        }

        public Builder setLastErrorStatus(Status value) {
            if (this.lastErrorStatusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.lastErrorStatus_ = value;
            } else {
                this.lastErrorStatusBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setLastErrorStatus(Status.Builder builderForValue) {
            if (this.lastErrorStatusBuilder_ == null) {
                this.lastErrorStatus_ = builderForValue.build();
            } else {
                this.lastErrorStatusBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeLastErrorStatus(Status value) {
            if (this.lastErrorStatusBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.lastErrorStatus_ != null && this.lastErrorStatus_ != Status.getDefaultInstance()) {
                    this.getLastErrorStatusBuilder().mergeFrom(value);
                } else {
                    this.lastErrorStatus_ = value;
                }
            } else {
                this.lastErrorStatusBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearLastErrorStatus() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.lastErrorStatus_ = null;
            if (this.lastErrorStatusBuilder_ != null) {
                this.lastErrorStatusBuilder_.dispose();
                this.lastErrorStatusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Status.Builder getLastErrorStatusBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (Status.Builder)this.getLastErrorStatusFieldBuilder().getBuilder();
        }

        @Override
        public StatusOrBuilder getLastErrorStatusOrBuilder() {
            if (this.lastErrorStatusBuilder_ != null) {
                return (StatusOrBuilder)this.lastErrorStatusBuilder_.getMessageOrBuilder();
            }
            return this.lastErrorStatus_ == null ? Status.getDefaultInstance() : this.lastErrorStatus_;
        }

        private SingleFieldBuilderV3<Status, Status.Builder, StatusOrBuilder> getLastErrorStatusFieldBuilder() {
            if (this.lastErrorStatusBuilder_ == null) {
                this.lastErrorStatusBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getLastErrorStatus(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.lastErrorStatus_ = null;
            }
            return this.lastErrorStatusBuilder_;
        }

        @Override
        public boolean hasConfig() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public DeviceConfig getConfig() {
            if (this.configBuilder_ == null) {
                return this.config_ == null ? DeviceConfig.getDefaultInstance() : this.config_;
            }
            return (DeviceConfig)this.configBuilder_.getMessage();
        }

        public Builder setConfig(DeviceConfig value) {
            if (this.configBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.config_ = value;
            } else {
                this.configBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setConfig(DeviceConfig.Builder builderForValue) {
            if (this.configBuilder_ == null) {
                this.config_ = builderForValue.build();
            } else {
                this.configBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeConfig(DeviceConfig value) {
            if (this.configBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.config_ != null && this.config_ != DeviceConfig.getDefaultInstance()) {
                    this.getConfigBuilder().mergeFrom(value);
                } else {
                    this.config_ = value;
                }
            } else {
                this.configBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearConfig() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.config_ = null;
            if (this.configBuilder_ != null) {
                this.configBuilder_.dispose();
                this.configBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeviceConfig.Builder getConfigBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (DeviceConfig.Builder)this.getConfigFieldBuilder().getBuilder();
        }

        @Override
        public DeviceConfigOrBuilder getConfigOrBuilder() {
            if (this.configBuilder_ != null) {
                return (DeviceConfigOrBuilder)this.configBuilder_.getMessageOrBuilder();
            }
            return this.config_ == null ? DeviceConfig.getDefaultInstance() : this.config_;
        }

        private SingleFieldBuilderV3<DeviceConfig, DeviceConfig.Builder, DeviceConfigOrBuilder> getConfigFieldBuilder() {
            if (this.configBuilder_ == null) {
                this.configBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.config_ = null;
            }
            return this.configBuilder_;
        }

        @Override
        public boolean hasState() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public DeviceState getState() {
            if (this.stateBuilder_ == null) {
                return this.state_ == null ? DeviceState.getDefaultInstance() : this.state_;
            }
            return (DeviceState)this.stateBuilder_.getMessage();
        }

        public Builder setState(DeviceState value) {
            if (this.stateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.state_ = value;
            } else {
                this.stateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setState(DeviceState.Builder builderForValue) {
            if (this.stateBuilder_ == null) {
                this.state_ = builderForValue.build();
            } else {
                this.stateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeState(DeviceState value) {
            if (this.stateBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.state_ != null && this.state_ != DeviceState.getDefaultInstance()) {
                    this.getStateBuilder().mergeFrom(value);
                } else {
                    this.state_ = value;
                }
            } else {
                this.stateBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.state_ = null;
            if (this.stateBuilder_ != null) {
                this.stateBuilder_.dispose();
                this.stateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public DeviceState.Builder getStateBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (DeviceState.Builder)this.getStateFieldBuilder().getBuilder();
        }

        @Override
        public DeviceStateOrBuilder getStateOrBuilder() {
            if (this.stateBuilder_ != null) {
                return (DeviceStateOrBuilder)this.stateBuilder_.getMessageOrBuilder();
            }
            return this.state_ == null ? DeviceState.getDefaultInstance() : this.state_;
        }

        private SingleFieldBuilderV3<DeviceState, DeviceState.Builder, DeviceStateOrBuilder> getStateFieldBuilder() {
            if (this.stateBuilder_ == null) {
                this.stateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getState(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.state_ = null;
            }
            return this.stateBuilder_;
        }

        @Override
        public int getLogLevelValue() {
            return this.logLevel_;
        }

        public Builder setLogLevelValue(int value) {
            this.logLevel_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        @Override
        public LogLevel getLogLevel() {
            LogLevel result = LogLevel.forNumber(this.logLevel_);
            return result == null ? LogLevel.UNRECOGNIZED : result;
        }

        public Builder setLogLevel(LogLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x4000;
            this.logLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLogLevel() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.logLevel_ = 0;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetMetadata() {
            if (this.metadata_ == null) {
                return MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            return this.metadata_;
        }

        private MapField<String, String> internalGetMutableMetadata() {
            if (this.metadata_ == null) {
                this.metadata_ = MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
            }
            if (!this.metadata_.isMutable()) {
                this.metadata_ = this.metadata_.copy();
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this.metadata_;
        }

        @Override
        public int getMetadataCount() {
            return this.internalGetMetadata().getMap().size();
        }

        @Override
        public boolean containsMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetMetadata().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getMetadata() {
            return this.getMetadataMap();
        }

        @Override
        public Map<String, String> getMetadataMap() {
            return this.internalGetMetadata().getMap();
        }

        @Override
        public String getMetadataOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMetadata().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getMetadataOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetMetadata().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearMetadata() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.internalGetMutableMetadata().getMutableMap().clear();
            return this;
        }

        public Builder removeMetadata(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableMetadata().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableMetadata() {
            this.bitField0_ |= 0x8000;
            return this.internalGetMutableMetadata().getMutableMap();
        }

        public Builder putMetadata(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableMetadata().getMutableMap().put(key, value);
            this.bitField0_ |= 0x8000;
            return this;
        }

        public Builder putAllMetadata(Map<String, String> values) {
            this.internalGetMutableMetadata().getMutableMap().putAll(values);
            this.bitField0_ |= 0x8000;
            return this;
        }

        @Override
        public boolean hasGatewayConfig() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public GatewayConfig getGatewayConfig() {
            if (this.gatewayConfigBuilder_ == null) {
                return this.gatewayConfig_ == null ? GatewayConfig.getDefaultInstance() : this.gatewayConfig_;
            }
            return (GatewayConfig)this.gatewayConfigBuilder_.getMessage();
        }

        public Builder setGatewayConfig(GatewayConfig value) {
            if (this.gatewayConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.gatewayConfig_ = value;
            } else {
                this.gatewayConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setGatewayConfig(GatewayConfig.Builder builderForValue) {
            if (this.gatewayConfigBuilder_ == null) {
                this.gatewayConfig_ = builderForValue.build();
            } else {
                this.gatewayConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeGatewayConfig(GatewayConfig value) {
            if (this.gatewayConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.gatewayConfig_ != null && this.gatewayConfig_ != GatewayConfig.getDefaultInstance()) {
                    this.getGatewayConfigBuilder().mergeFrom(value);
                } else {
                    this.gatewayConfig_ = value;
                }
            } else {
                this.gatewayConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearGatewayConfig() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.gatewayConfig_ = null;
            if (this.gatewayConfigBuilder_ != null) {
                this.gatewayConfigBuilder_.dispose();
                this.gatewayConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public GatewayConfig.Builder getGatewayConfigBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (GatewayConfig.Builder)this.getGatewayConfigFieldBuilder().getBuilder();
        }

        @Override
        public GatewayConfigOrBuilder getGatewayConfigOrBuilder() {
            if (this.gatewayConfigBuilder_ != null) {
                return (GatewayConfigOrBuilder)this.gatewayConfigBuilder_.getMessageOrBuilder();
            }
            return this.gatewayConfig_ == null ? GatewayConfig.getDefaultInstance() : this.gatewayConfig_;
        }

        private SingleFieldBuilderV3<GatewayConfig, GatewayConfig.Builder, GatewayConfigOrBuilder> getGatewayConfigFieldBuilder() {
            if (this.gatewayConfigBuilder_ == null) {
                this.gatewayConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getGatewayConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.gatewayConfig_ = null;
            }
            return this.gatewayConfigBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class MetadataDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)ResourcesProto.internal_static_google_cloud_iot_v1_Device_MetadataEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private MetadataDefaultEntryHolder() {
        }
    }
}

