/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EkmConnectionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EKM_CONNECTION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/ekmConnections/{ekm_connection}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String ekmConnection;

    @Deprecated
    protected EkmConnectionName() {
        this.project = null;
        this.location = null;
        this.ekmConnection = null;
    }

    private EkmConnectionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.ekmConnection = (String)Preconditions.checkNotNull((Object)builder.getEkmConnection());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEkmConnection() {
        return this.ekmConnection;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EkmConnectionName of(String project, String location, String ekmConnection) {
        return EkmConnectionName.newBuilder().setProject(project).setLocation(location).setEkmConnection(ekmConnection).build();
    }

    public static String format(String project, String location, String ekmConnection) {
        return EkmConnectionName.newBuilder().setProject(project).setLocation(location).setEkmConnection(ekmConnection).build().toString();
    }

    public static EkmConnectionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EKM_CONNECTION.validatedMatch(formattedString, "EkmConnectionName.parse: formattedString not in valid format");
        return EkmConnectionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ekm_connection"));
    }

    public static List<EkmConnectionName> parseList(List<String> formattedStrings) {
        ArrayList<EkmConnectionName> list = new ArrayList<EkmConnectionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EkmConnectionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EkmConnectionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EkmConnectionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EKM_CONNECTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EkmConnectionName ekmConnectionName = this;
            synchronized (ekmConnectionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.ekmConnection != null) {
                        fieldMapBuilder.put((Object)"ekm_connection", (Object)this.ekmConnection);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EKM_CONNECTION.instantiate(new String[]{"project", this.project, "location", this.location, "ekm_connection", this.ekmConnection});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            EkmConnectionName that = (EkmConnectionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.ekmConnection, that.ekmConnection);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.ekmConnection);
    }

    public static class Builder {
        private String project;
        private String location;
        private String ekmConnection;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEkmConnection() {
            return this.ekmConnection;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEkmConnection(String ekmConnection) {
            this.ekmConnection = ekmConnection;
            return this;
        }

        private Builder(EkmConnectionName ekmConnectionName) {
            this.project = ekmConnectionName.project;
            this.location = ekmConnectionName.location;
            this.ekmConnection = ekmConnectionName.ekmConnection;
        }

        public EkmConnectionName build() {
            return new EkmConnectionName(this);
        }
    }
}

