/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.DecryptRequest}
 */
public final class DecryptRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.DecryptRequest)
    DecryptRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DecryptRequest.newBuilder() to construct.
  private DecryptRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DecryptRequest() {
    name_ = "";
    ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    additionalAuthenticatedData_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DecryptRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_DecryptRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_DecryptRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.DecryptRequest.class,
            com.google.cloud.kms.v1.DecryptRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
   * server will choose the appropriate version.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
   * server will choose the appropriate version.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CIPHERTEXT_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Required. The encrypted data originally returned in
   * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
   * </pre>
   *
   * <code>bytes ciphertext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The ciphertext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCiphertext() {
    return ciphertext_;
  }

  public static final int ADDITIONAL_AUTHENTICATED_DATA_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString additionalAuthenticatedData_ =
      com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * Optional. Optional data that must match the data originally supplied in
   * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
   * </pre>
   *
   * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The additionalAuthenticatedData.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdditionalAuthenticatedData() {
    return additionalAuthenticatedData_;
  }

  public static final int CIPHERTEXT_CRC32C_FIELD_NUMBER = 5;
  private com.google.protobuf.Int64Value ciphertextCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
   * is equal to
   * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasCiphertextCrc32C() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
   * is equal to
   * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ciphertextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getCiphertextCrc32C() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
   * is equal to
   * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }

  public static final int ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER = 6;
  private com.google.protobuf.Int64Value additionalAuthenticatedDataCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
   * is equal to
   * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the additionalAuthenticatedDataCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasAdditionalAuthenticatedDataCrc32C() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
   * is equal to
   * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The additionalAuthenticatedDataCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C() {
    return additionalAuthenticatedDataCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : additionalAuthenticatedDataCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
   * is equal to
   * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder() {
    return additionalAuthenticatedDataCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : additionalAuthenticatedDataCrc32C_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      output.writeBytes(2, ciphertext_);
    }
    if (!additionalAuthenticatedData_.isEmpty()) {
      output.writeBytes(3, additionalAuthenticatedData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCiphertextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getAdditionalAuthenticatedDataCrc32C());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, ciphertext_);
    }
    if (!additionalAuthenticatedData_.isEmpty()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(3, additionalAuthenticatedData_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCiphertextCrc32C());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, getAdditionalAuthenticatedDataCrc32C());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.DecryptRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.DecryptRequest other = (com.google.cloud.kms.v1.DecryptRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCiphertext().equals(other.getCiphertext())) return false;
    if (!getAdditionalAuthenticatedData().equals(other.getAdditionalAuthenticatedData()))
      return false;
    if (hasCiphertextCrc32C() != other.hasCiphertextCrc32C()) return false;
    if (hasCiphertextCrc32C()) {
      if (!getCiphertextCrc32C().equals(other.getCiphertextCrc32C())) return false;
    }
    if (hasAdditionalAuthenticatedDataCrc32C() != other.hasAdditionalAuthenticatedDataCrc32C())
      return false;
    if (hasAdditionalAuthenticatedDataCrc32C()) {
      if (!getAdditionalAuthenticatedDataCrc32C()
          .equals(other.getAdditionalAuthenticatedDataCrc32C())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CIPHERTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getCiphertext().hashCode();
    hash = (37 * hash) + ADDITIONAL_AUTHENTICATED_DATA_FIELD_NUMBER;
    hash = (53 * hash) + getAdditionalAuthenticatedData().hashCode();
    if (hasCiphertextCrc32C()) {
      hash = (37 * hash) + CIPHERTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getCiphertextCrc32C().hashCode();
    }
    if (hasAdditionalAuthenticatedDataCrc32C()) {
      hash = (37 * hash) + ADDITIONAL_AUTHENTICATED_DATA_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getAdditionalAuthenticatedDataCrc32C().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.DecryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.DecryptRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [KeyManagementService.Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.DecryptRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.DecryptRequest)
      com.google.cloud.kms.v1.DecryptRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.DecryptRequest.class,
              com.google.cloud.kms.v1.DecryptRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.DecryptRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCiphertextCrc32CFieldBuilder();
        getAdditionalAuthenticatedDataCrc32CFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      ciphertext_ = com.google.protobuf.ByteString.EMPTY;
      additionalAuthenticatedData_ = com.google.protobuf.ByteString.EMPTY;
      ciphertextCrc32C_ = null;
      if (ciphertextCrc32CBuilder_ != null) {
        ciphertextCrc32CBuilder_.dispose();
        ciphertextCrc32CBuilder_ = null;
      }
      additionalAuthenticatedDataCrc32C_ = null;
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        additionalAuthenticatedDataCrc32CBuilder_.dispose();
        additionalAuthenticatedDataCrc32CBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_DecryptRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.DecryptRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptRequest build() {
      com.google.cloud.kms.v1.DecryptRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.DecryptRequest buildPartial() {
      com.google.cloud.kms.v1.DecryptRequest result =
          new com.google.cloud.kms.v1.DecryptRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.DecryptRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ciphertext_ = ciphertext_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.additionalAuthenticatedData_ = additionalAuthenticatedData_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ciphertextCrc32C_ =
            ciphertextCrc32CBuilder_ == null ? ciphertextCrc32C_ : ciphertextCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.additionalAuthenticatedDataCrc32C_ =
            additionalAuthenticatedDataCrc32CBuilder_ == null
                ? additionalAuthenticatedDataCrc32C_
                : additionalAuthenticatedDataCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.DecryptRequest) {
        return mergeFrom((com.google.cloud.kms.v1.DecryptRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.DecryptRequest other) {
      if (other == com.google.cloud.kms.v1.DecryptRequest.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getCiphertext() != com.google.protobuf.ByteString.EMPTY) {
        setCiphertext(other.getCiphertext());
      }
      if (other.getAdditionalAuthenticatedData() != com.google.protobuf.ByteString.EMPTY) {
        setAdditionalAuthenticatedData(other.getAdditionalAuthenticatedData());
      }
      if (other.hasCiphertextCrc32C()) {
        mergeCiphertextCrc32C(other.getCiphertextCrc32C());
      }
      if (other.hasAdditionalAuthenticatedDataCrc32C()) {
        mergeAdditionalAuthenticatedDataCrc32C(other.getAdditionalAuthenticatedDataCrc32C());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                ciphertext_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                additionalAuthenticatedData_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getCiphertextCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAdditionalAuthenticatedDataCrc32CFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
     * server will choose the appropriate version.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
     * server will choose the appropriate version.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
     * server will choose the appropriate version.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
     * server will choose the appropriate version.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] to use for decryption. The
     * server will choose the appropriate version.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The encrypted data originally returned in
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * </pre>
     *
     * <code>bytes ciphertext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The ciphertext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCiphertext() {
      return ciphertext_;
    }
    /**
     *
     *
     * <pre>
     * Required. The encrypted data originally returned in
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * </pre>
     *
     * <code>bytes ciphertext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The ciphertext to set.
     * @return This builder for chaining.
     */
    public Builder setCiphertext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ciphertext_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The encrypted data originally returned in
     * [EncryptResponse.ciphertext][google.cloud.kms.v1.EncryptResponse.ciphertext].
     * </pre>
     *
     * <code>bytes ciphertext = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCiphertext() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ciphertext_ = getDefaultInstance().getCiphertext();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString additionalAuthenticatedData_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optional. Optional data that must match the data originally supplied in
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The additionalAuthenticatedData.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAdditionalAuthenticatedData() {
      return additionalAuthenticatedData_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional data that must match the data originally supplied in
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The additionalAuthenticatedData to set.
     * @return This builder for chaining.
     */
    public Builder setAdditionalAuthenticatedData(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      additionalAuthenticatedData_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional data that must match the data originally supplied in
     * [EncryptRequest.additional_authenticated_data][google.cloud.kms.v1.EncryptRequest.additional_authenticated_data].
     * </pre>
     *
     * <code>bytes additional_authenticated_data = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdditionalAuthenticatedData() {
      bitField0_ = (bitField0_ & ~0x00000004);
      additionalAuthenticatedData_ = getDefaultInstance().getAdditionalAuthenticatedData();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value ciphertextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        ciphertextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ciphertextCrc32c field is set.
     */
    public boolean hasCiphertextCrc32C() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ciphertextCrc32c.
     */
    public com.google.protobuf.Int64Value getCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      } else {
        return ciphertextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ciphertextCrc32C_ = value;
      } else {
        ciphertextCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = builderForValue.build();
      } else {
        ciphertextCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ciphertextCrc32C_ != null
            && ciphertextCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getCiphertextCrc32CBuilder().mergeFrom(value);
        } else {
          ciphertextCrc32C_ = value;
        }
      } else {
        ciphertextCrc32CBuilder_.mergeFrom(value);
      }
      if (ciphertextCrc32C_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCiphertextCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ciphertextCrc32C_ = null;
      if (ciphertextCrc32CBuilder_ != null) {
        ciphertextCrc32CBuilder_.dispose();
        ciphertextCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getCiphertextCrc32CBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCiphertextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
      if (ciphertextCrc32CBuilder_ != null) {
        return ciphertextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.ciphertext][google.cloud.kms.v1.DecryptRequest.ciphertext])
     * is equal to
     * [DecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.DecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getCiphertextCrc32CFieldBuilder() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getCiphertextCrc32C(), getParentForChildren(), isClean());
        ciphertextCrc32C_ = null;
      }
      return ciphertextCrc32CBuilder_;
    }

    private com.google.protobuf.Int64Value additionalAuthenticatedDataCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        additionalAuthenticatedDataCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the additionalAuthenticatedDataCrc32c field is set.
     */
    public boolean hasAdditionalAuthenticatedDataCrc32C() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The additionalAuthenticatedDataCrc32c.
     */
    public com.google.protobuf.Int64Value getAdditionalAuthenticatedDataCrc32C() {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        return additionalAuthenticatedDataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : additionalAuthenticatedDataCrc32C_;
      } else {
        return additionalAuthenticatedDataCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdditionalAuthenticatedDataCrc32C(com.google.protobuf.Int64Value value) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        additionalAuthenticatedDataCrc32C_ = value;
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAdditionalAuthenticatedDataCrc32C(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        additionalAuthenticatedDataCrc32C_ = builderForValue.build();
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAdditionalAuthenticatedDataCrc32C(com.google.protobuf.Int64Value value) {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && additionalAuthenticatedDataCrc32C_ != null
            && additionalAuthenticatedDataCrc32C_
                != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getAdditionalAuthenticatedDataCrc32CBuilder().mergeFrom(value);
        } else {
          additionalAuthenticatedDataCrc32C_ = value;
        }
      } else {
        additionalAuthenticatedDataCrc32CBuilder_.mergeFrom(value);
      }
      if (additionalAuthenticatedDataCrc32C_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAdditionalAuthenticatedDataCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000010);
      additionalAuthenticatedDataCrc32C_ = null;
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        additionalAuthenticatedDataCrc32CBuilder_.dispose();
        additionalAuthenticatedDataCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getAdditionalAuthenticatedDataCrc32CBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAdditionalAuthenticatedDataCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getAdditionalAuthenticatedDataCrc32COrBuilder() {
      if (additionalAuthenticatedDataCrc32CBuilder_ != null) {
        return additionalAuthenticatedDataCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return additionalAuthenticatedDataCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : additionalAuthenticatedDataCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([DecryptRequest.additional_authenticated_data][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data])
     * is equal to
     * [DecryptRequest.additional_authenticated_data_crc32c][google.cloud.kms.v1.DecryptRequest.additional_authenticated_data_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value additional_authenticated_data_crc32c = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getAdditionalAuthenticatedDataCrc32CFieldBuilder() {
      if (additionalAuthenticatedDataCrc32CBuilder_ == null) {
        additionalAuthenticatedDataCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getAdditionalAuthenticatedDataCrc32C(), getParentForChildren(), isClean());
        additionalAuthenticatedDataCrc32C_ = null;
      }
      return additionalAuthenticatedDataCrc32CBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.DecryptRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.DecryptRequest)
  private static final com.google.cloud.kms.v1.DecryptRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.DecryptRequest();
  }

  public static com.google.cloud.kms.v1.DecryptRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DecryptRequest> PARSER =
      new com.google.protobuf.AbstractParser<DecryptRequest>() {
        @java.lang.Override
        public DecryptRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DecryptRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DecryptRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.DecryptRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
