/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * A
 * [KeyAccessJustificationsPolicy][google.cloud.kms.v1.KeyAccessJustificationsPolicy]
 * specifies zero or more allowed
 * [AccessReason][google.cloud.kms.v1.AccessReason] values for encrypt, decrypt,
 * and sign operations on a [CryptoKey][google.cloud.kms.v1.CryptoKey].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.KeyAccessJustificationsPolicy}
 */
public final class KeyAccessJustificationsPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.KeyAccessJustificationsPolicy)
    KeyAccessJustificationsPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KeyAccessJustificationsPolicy.newBuilder() to construct.
  private KeyAccessJustificationsPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KeyAccessJustificationsPolicy() {
    allowedAccessReasons_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KeyAccessJustificationsPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_KeyAccessJustificationsPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_KeyAccessJustificationsPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.class,
            com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.Builder.class);
  }

  public static final int ALLOWED_ACCESS_REASONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> allowedAccessReasons_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.kms.v1.AccessReason>
      allowedAccessReasons_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.kms.v1.AccessReason>() {
            public com.google.cloud.kms.v1.AccessReason convert(java.lang.Integer from) {
              com.google.cloud.kms.v1.AccessReason result =
                  com.google.cloud.kms.v1.AccessReason.forNumber(from);
              return result == null ? com.google.cloud.kms.v1.AccessReason.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of allowed reasons for access to a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
   * means all encrypt, decrypt, and sign operations for the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
   * fail.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
   *
   * @return A list containing the allowedAccessReasons.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.kms.v1.AccessReason> getAllowedAccessReasonsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.kms.v1.AccessReason>(
        allowedAccessReasons_, allowedAccessReasons_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of allowed reasons for access to a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
   * means all encrypt, decrypt, and sign operations for the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
   * fail.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
   *
   * @return The count of allowedAccessReasons.
   */
  @java.lang.Override
  public int getAllowedAccessReasonsCount() {
    return allowedAccessReasons_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of allowed reasons for access to a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
   * means all encrypt, decrypt, and sign operations for the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
   * fail.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedAccessReasons at the given index.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.AccessReason getAllowedAccessReasons(int index) {
    return allowedAccessReasons_converter_.convert(allowedAccessReasons_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of allowed reasons for access to a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
   * means all encrypt, decrypt, and sign operations for the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
   * fail.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
   *
   * @return A list containing the enum numeric values on the wire for allowedAccessReasons.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getAllowedAccessReasonsValueList() {
    return allowedAccessReasons_;
  }
  /**
   *
   *
   * <pre>
   * The list of allowed reasons for access to a
   * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
   * means all encrypt, decrypt, and sign operations for the
   * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
   * fail.
   * </pre>
   *
   * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of allowedAccessReasons at the given index.
   */
  @java.lang.Override
  public int getAllowedAccessReasonsValue(int index) {
    return allowedAccessReasons_.get(index);
  }

  private int allowedAccessReasonsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getAllowedAccessReasonsList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(allowedAccessReasonsMemoizedSerializedSize);
    }
    for (int i = 0; i < allowedAccessReasons_.size(); i++) {
      output.writeEnumNoTag(allowedAccessReasons_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < allowedAccessReasons_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                allowedAccessReasons_.get(i));
      }
      size += dataSize;
      if (!getAllowedAccessReasonsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      allowedAccessReasonsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.KeyAccessJustificationsPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.KeyAccessJustificationsPolicy other =
        (com.google.cloud.kms.v1.KeyAccessJustificationsPolicy) obj;

    if (!allowedAccessReasons_.equals(other.allowedAccessReasons_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAllowedAccessReasonsCount() > 0) {
      hash = (37 * hash) + ALLOWED_ACCESS_REASONS_FIELD_NUMBER;
      hash = (53 * hash) + allowedAccessReasons_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.kms.v1.KeyAccessJustificationsPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A
   * [KeyAccessJustificationsPolicy][google.cloud.kms.v1.KeyAccessJustificationsPolicy]
   * specifies zero or more allowed
   * [AccessReason][google.cloud.kms.v1.AccessReason] values for encrypt, decrypt,
   * and sign operations on a [CryptoKey][google.cloud.kms.v1.CryptoKey].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.KeyAccessJustificationsPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.KeyAccessJustificationsPolicy)
      com.google.cloud.kms.v1.KeyAccessJustificationsPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyAccessJustificationsPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyAccessJustificationsPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.class,
              com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      allowedAccessReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_KeyAccessJustificationsPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyAccessJustificationsPolicy getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyAccessJustificationsPolicy build() {
      com.google.cloud.kms.v1.KeyAccessJustificationsPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.KeyAccessJustificationsPolicy buildPartial() {
      com.google.cloud.kms.v1.KeyAccessJustificationsPolicy result =
          new com.google.cloud.kms.v1.KeyAccessJustificationsPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.kms.v1.KeyAccessJustificationsPolicy result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        allowedAccessReasons_ = java.util.Collections.unmodifiableList(allowedAccessReasons_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.allowedAccessReasons_ = allowedAccessReasons_;
    }

    private void buildPartial0(com.google.cloud.kms.v1.KeyAccessJustificationsPolicy result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.KeyAccessJustificationsPolicy) {
        return mergeFrom((com.google.cloud.kms.v1.KeyAccessJustificationsPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.KeyAccessJustificationsPolicy other) {
      if (other == com.google.cloud.kms.v1.KeyAccessJustificationsPolicy.getDefaultInstance())
        return this;
      if (!other.allowedAccessReasons_.isEmpty()) {
        if (allowedAccessReasons_.isEmpty()) {
          allowedAccessReasons_ = other.allowedAccessReasons_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureAllowedAccessReasonsIsMutable();
          allowedAccessReasons_.addAll(other.allowedAccessReasons_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                int tmpRaw = input.readEnum();
                ensureAllowedAccessReasonsIsMutable();
                allowedAccessReasons_.add(tmpRaw);
                break;
              } // case 8
            case 10:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureAllowedAccessReasonsIsMutable();
                  allowedAccessReasons_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<java.lang.Integer> allowedAccessReasons_ =
        java.util.Collections.emptyList();

    private void ensureAllowedAccessReasonsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        allowedAccessReasons_ = new java.util.ArrayList<java.lang.Integer>(allowedAccessReasons_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @return A list containing the allowedAccessReasons.
     */
    public java.util.List<com.google.cloud.kms.v1.AccessReason> getAllowedAccessReasonsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.kms.v1.AccessReason>(
          allowedAccessReasons_, allowedAccessReasons_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @return The count of allowedAccessReasons.
     */
    public int getAllowedAccessReasonsCount() {
      return allowedAccessReasons_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedAccessReasons at the given index.
     */
    public com.google.cloud.kms.v1.AccessReason getAllowedAccessReasons(int index) {
      return allowedAccessReasons_converter_.convert(allowedAccessReasons_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedAccessReasons to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedAccessReasons(int index, com.google.cloud.kms.v1.AccessReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedAccessReasonsIsMutable();
      allowedAccessReasons_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param value The allowedAccessReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedAccessReasons(com.google.cloud.kms.v1.AccessReason value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedAccessReasonsIsMutable();
      allowedAccessReasons_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param values The allowedAccessReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedAccessReasons(
        java.lang.Iterable<? extends com.google.cloud.kms.v1.AccessReason> values) {
      ensureAllowedAccessReasonsIsMutable();
      for (com.google.cloud.kms.v1.AccessReason value : values) {
        allowedAccessReasons_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedAccessReasons() {
      allowedAccessReasons_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @return A list containing the enum numeric values on the wire for allowedAccessReasons.
     */
    public java.util.List<java.lang.Integer> getAllowedAccessReasonsValueList() {
      return java.util.Collections.unmodifiableList(allowedAccessReasons_);
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allowedAccessReasons at the given index.
     */
    public int getAllowedAccessReasonsValue(int index) {
      return allowedAccessReasons_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for allowedAccessReasons to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedAccessReasonsValue(int index, int value) {
      ensureAllowedAccessReasonsIsMutable();
      allowedAccessReasons_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param value The enum numeric value on the wire for allowedAccessReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedAccessReasonsValue(int value) {
      ensureAllowedAccessReasonsIsMutable();
      allowedAccessReasons_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of allowed reasons for access to a
     * [CryptoKey][google.cloud.kms.v1.CryptoKey]. Zero allowed access reasons
     * means all encrypt, decrypt, and sign operations for the
     * [CryptoKey][google.cloud.kms.v1.CryptoKey] associated with this policy will
     * fail.
     * </pre>
     *
     * <code>repeated .google.cloud.kms.v1.AccessReason allowed_access_reasons = 1;</code>
     *
     * @param values The enum numeric values on the wire for allowedAccessReasons to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedAccessReasonsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureAllowedAccessReasonsIsMutable();
      for (int value : values) {
        allowedAccessReasons_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.KeyAccessJustificationsPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.KeyAccessJustificationsPolicy)
  private static final com.google.cloud.kms.v1.KeyAccessJustificationsPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.KeyAccessJustificationsPolicy();
  }

  public static com.google.cloud.kms.v1.KeyAccessJustificationsPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KeyAccessJustificationsPolicy> PARSER =
      new com.google.protobuf.AbstractParser<KeyAccessJustificationsPolicy>() {
        @java.lang.Override
        public KeyAccessJustificationsPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KeyAccessJustificationsPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KeyAccessJustificationsPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.KeyAccessJustificationsPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
