/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * The public keys for a given
 * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Obtained via
 * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.PublicKey}
 */
public final class PublicKey extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.PublicKey)
    PublicKeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PublicKey.newBuilder() to construct.
  private PublicKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PublicKey() {
    pem_ = "";
    algorithm_ = 0;
    name_ = "";
    protectionLevel_ = 0;
    publicKeyFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PublicKey();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_PublicKey_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsResourcesProto
        .internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.PublicKey.class,
            com.google.cloud.kms.v1.PublicKey.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The supported [PublicKey][google.cloud.kms.v1.PublicKey] formats.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.kms.v1.PublicKey.PublicKeyFormat}
   */
  public enum PublicKeyFormat implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * If the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field is not specified:
     * - For PQC algorithms, an error will be returned.
     * - For non-PQC algorithms, the default format is PEM, and the field
     *   [pem][google.cloud.kms.v1.PublicKey.pem] will be populated.
     *
     * Otherwise, the public key will be exported through the
     * [public_key][google.cloud.kms.v1.PublicKey.public_key] field in the
     * requested format.
     * </pre>
     *
     * <code>PUBLIC_KEY_FORMAT_UNSPECIFIED = 0;</code>
     */
    PUBLIC_KEY_FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The returned public key will be encoded in PEM format.
     * See the [RFC7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2)
     * and [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13) for more information.
     * </pre>
     *
     * <code>PEM = 1;</code>
     */
    PEM(1),
    /**
     *
     *
     * <pre>
     * This is supported only for PQC algorithms.
     * The key material is returned in the format defined by NIST PQC
     * standards (FIPS 203, FIPS 204, and FIPS 205).
     * </pre>
     *
     * <code>NIST_PQC = 3;</code>
     */
    NIST_PQC(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * If the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field is not specified:
     * - For PQC algorithms, an error will be returned.
     * - For non-PQC algorithms, the default format is PEM, and the field
     *   [pem][google.cloud.kms.v1.PublicKey.pem] will be populated.
     *
     * Otherwise, the public key will be exported through the
     * [public_key][google.cloud.kms.v1.PublicKey.public_key] field in the
     * requested format.
     * </pre>
     *
     * <code>PUBLIC_KEY_FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int PUBLIC_KEY_FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The returned public key will be encoded in PEM format.
     * See the [RFC7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2)
     * and [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13) for more information.
     * </pre>
     *
     * <code>PEM = 1;</code>
     */
    public static final int PEM_VALUE = 1;
    /**
     *
     *
     * <pre>
     * This is supported only for PQC algorithms.
     * The key material is returned in the format defined by NIST PQC
     * standards (FIPS 203, FIPS 204, and FIPS 205).
     * </pre>
     *
     * <code>NIST_PQC = 3;</code>
     */
    public static final int NIST_PQC_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PublicKeyFormat valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PublicKeyFormat forNumber(int value) {
      switch (value) {
        case 0:
          return PUBLIC_KEY_FORMAT_UNSPECIFIED;
        case 1:
          return PEM;
        case 3:
          return NIST_PQC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PublicKeyFormat> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PublicKeyFormat>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PublicKeyFormat>() {
              public PublicKeyFormat findValueByNumber(int number) {
                return PublicKeyFormat.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.kms.v1.PublicKey.getDescriptor().getEnumTypes().get(0);
    }

    private static final PublicKeyFormat[] VALUES = values();

    public static PublicKeyFormat valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PublicKeyFormat(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.kms.v1.PublicKey.PublicKeyFormat)
  }

  private int bitField0_;
  public static final int PEM_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pem_ = "";
  /**
   *
   *
   * <pre>
   * The public key, encoded in PEM format. For more information, see the
   * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
   * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
   * [Textual Encoding of Subject Public Key Info]
   * (https://tools.ietf.org/html/rfc7468#section-13).
   * </pre>
   *
   * <code>string pem = 1;</code>
   *
   * @return The pem.
   */
  @java.lang.Override
  public java.lang.String getPem() {
    java.lang.Object ref = pem_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pem_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The public key, encoded in PEM format. For more information, see the
   * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
   * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
   * [Textual Encoding of Subject Public Key Info]
   * (https://tools.ietf.org/html/rfc7468#section-13).
   * </pre>
   *
   * <code>string pem = 1;</code>
   *
   * @return The bytes for pem.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPemBytes() {
    java.lang.Object ref = pem_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pem_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALGORITHM_FIELD_NUMBER = 2;
  private int algorithm_ = 0;
  /**
   *
   *
   * <pre>
   * The
   * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
   * associated with this key.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  @java.lang.Override
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * The
   * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
   * associated with this key.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
    com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(algorithm_);
    return result == null
        ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
        : result;
  }

  public static final int PEM_CRC32C_FIELD_NUMBER = 3;
  private com.google.protobuf.Int64Value pemCrc32C_;
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
   * computing the CRC32C checksum of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed `2^32-1`, and can be safely downconverted to uint32 in
   * languages that support this type.
   *
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
   *
   * @return Whether the pemCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasPemCrc32C() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
   * computing the CRC32C checksum of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed `2^32-1`, and can be safely downconverted to uint32 in
   * languages that support this type.
   *
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
   *
   * @return The pemCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getPemCrc32C() {
    return pemCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : pemCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Integrity verification field. A CRC32C checksum of the returned
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
   * computing the CRC32C checksum of
   * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
   * results to this field. Discard the response in case of non-matching
   * checksum values, and perform a limited number of retries. A persistent
   * mismatch may indicate an issue in your computation of the CRC32C checksum.
   * Note: This field is defined as int64 for reasons of compatibility across
   * different languages. However, it is a non-negative integer, which will
   * never exceed `2^32-1`, and can be safely downconverted to uint32 in
   * languages that support this type.
   *
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getPemCrc32COrBuilder() {
    return pemCrc32C_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : pemCrc32C_;
  }

  public static final int NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
   * Provided here for verification.
   *
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
   * Provided here for verification.
   *
   * NOTE: This field is in Beta.
   * </pre>
   *
   * <code>string name = 4;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROTECTION_LEVEL_FIELD_NUMBER = 5;
  private int protectionLevel_ = 0;
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
   *
   * @return The enum numeric value on the wire for protectionLevel.
   */
  @java.lang.Override
  public int getProtectionLevelValue() {
    return protectionLevel_;
  }
  /**
   *
   *
   * <pre>
   * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
   *
   * @return The protectionLevel.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
    com.google.cloud.kms.v1.ProtectionLevel result =
        com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
    return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
  }

  public static final int PUBLIC_KEY_FORMAT_FIELD_NUMBER = 7;
  private int publicKeyFormat_ = 0;
  /**
   *
   *
   * <pre>
   * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
   * customer through the
   * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
   * field.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
   *
   * @return The enum numeric value on the wire for publicKeyFormat.
   */
  @java.lang.Override
  public int getPublicKeyFormatValue() {
    return publicKeyFormat_;
  }
  /**
   *
   *
   * <pre>
   * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
   * customer through the
   * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
   * field.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
   *
   * @return The publicKeyFormat.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.PublicKey.PublicKeyFormat getPublicKeyFormat() {
    com.google.cloud.kms.v1.PublicKey.PublicKeyFormat result =
        com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.forNumber(publicKeyFormat_);
    return result == null ? com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.UNRECOGNIZED : result;
  }

  public static final int PUBLIC_KEY_FIELD_NUMBER = 8;
  private com.google.cloud.kms.v1.ChecksummedData publicKey_;
  /**
   *
   *
   * <pre>
   * This field contains the public key (with integrity verification), formatted
   * according to the
   * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
   *
   * @return Whether the publicKey field is set.
   */
  @java.lang.Override
  public boolean hasPublicKey() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field contains the public key (with integrity verification), formatted
   * according to the
   * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
   *
   * @return The publicKey.
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ChecksummedData getPublicKey() {
    return publicKey_ == null
        ? com.google.cloud.kms.v1.ChecksummedData.getDefaultInstance()
        : publicKey_;
  }
  /**
   *
   *
   * <pre>
   * This field contains the public key (with integrity verification), formatted
   * according to the
   * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
   * </pre>
   *
   * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.kms.v1.ChecksummedDataOrBuilder getPublicKeyOrBuilder() {
    return publicKey_ == null
        ? com.google.cloud.kms.v1.ChecksummedData.getDefaultInstance()
        : publicKey_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pem_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pem_);
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, algorithm_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getPemCrc32C());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, protectionLevel_);
    }
    if (publicKeyFormat_
        != com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.PUBLIC_KEY_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, publicKeyFormat_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getPublicKey());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pem_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pem_);
    }
    if (algorithm_
        != com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm
            .CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, algorithm_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPemCrc32C());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
    }
    if (protectionLevel_
        != com.google.cloud.kms.v1.ProtectionLevel.PROTECTION_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, protectionLevel_);
    }
    if (publicKeyFormat_
        != com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.PUBLIC_KEY_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, publicKeyFormat_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getPublicKey());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.PublicKey)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.PublicKey other = (com.google.cloud.kms.v1.PublicKey) obj;

    if (!getPem().equals(other.getPem())) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (hasPemCrc32C() != other.hasPemCrc32C()) return false;
    if (hasPemCrc32C()) {
      if (!getPemCrc32C().equals(other.getPemCrc32C())) return false;
    }
    if (!getName().equals(other.getName())) return false;
    if (protectionLevel_ != other.protectionLevel_) return false;
    if (publicKeyFormat_ != other.publicKeyFormat_) return false;
    if (hasPublicKey() != other.hasPublicKey()) return false;
    if (hasPublicKey()) {
      if (!getPublicKey().equals(other.getPublicKey())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PEM_FIELD_NUMBER;
    hash = (53 * hash) + getPem().hashCode();
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    if (hasPemCrc32C()) {
      hash = (37 * hash) + PEM_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getPemCrc32C().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + PROTECTION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + protectionLevel_;
    hash = (37 * hash) + PUBLIC_KEY_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + publicKeyFormat_;
    if (hasPublicKey()) {
      hash = (37 * hash) + PUBLIC_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getPublicKey().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.PublicKey parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.PublicKey parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.PublicKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.PublicKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The public keys for a given
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Obtained via
   * [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.PublicKey}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.PublicKey)
      com.google.cloud.kms.v1.PublicKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_PublicKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_PublicKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.PublicKey.class,
              com.google.cloud.kms.v1.PublicKey.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.PublicKey.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPemCrc32CFieldBuilder();
        getPublicKeyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      pem_ = "";
      algorithm_ = 0;
      pemCrc32C_ = null;
      if (pemCrc32CBuilder_ != null) {
        pemCrc32CBuilder_.dispose();
        pemCrc32CBuilder_ = null;
      }
      name_ = "";
      protectionLevel_ = 0;
      publicKeyFormat_ = 0;
      publicKey_ = null;
      if (publicKeyBuilder_ != null) {
        publicKeyBuilder_.dispose();
        publicKeyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsResourcesProto
          .internal_static_google_cloud_kms_v1_PublicKey_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.PublicKey getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.PublicKey.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.PublicKey build() {
      com.google.cloud.kms.v1.PublicKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.PublicKey buildPartial() {
      com.google.cloud.kms.v1.PublicKey result = new com.google.cloud.kms.v1.PublicKey(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.kms.v1.PublicKey result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.pem_ = pem_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.algorithm_ = algorithm_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pemCrc32C_ = pemCrc32CBuilder_ == null ? pemCrc32C_ : pemCrc32CBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.protectionLevel_ = protectionLevel_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.publicKeyFormat_ = publicKeyFormat_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.publicKey_ = publicKeyBuilder_ == null ? publicKey_ : publicKeyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.PublicKey) {
        return mergeFrom((com.google.cloud.kms.v1.PublicKey) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.PublicKey other) {
      if (other == com.google.cloud.kms.v1.PublicKey.getDefaultInstance()) return this;
      if (!other.getPem().isEmpty()) {
        pem_ = other.pem_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (other.hasPemCrc32C()) {
        mergePemCrc32C(other.getPemCrc32C());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.protectionLevel_ != 0) {
        setProtectionLevelValue(other.getProtectionLevelValue());
      }
      if (other.publicKeyFormat_ != 0) {
        setPublicKeyFormatValue(other.getPublicKeyFormatValue());
      }
      if (other.hasPublicKey()) {
        mergePublicKey(other.getPublicKey());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                pem_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                algorithm_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getPemCrc32CFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                protectionLevel_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 56:
              {
                publicKeyFormat_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getPublicKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object pem_ = "";
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the
     * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The pem.
     */
    public java.lang.String getPem() {
      java.lang.Object ref = pem_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pem_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the
     * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return The bytes for pem.
     */
    public com.google.protobuf.ByteString getPemBytes() {
      java.lang.Object ref = pem_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pem_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the
     * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @param value The pem to set.
     * @return This builder for chaining.
     */
    public Builder setPem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pem_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the
     * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPem() {
      pem_ = getDefaultInstance().getPem();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The public key, encoded in PEM format. For more information, see the
     * [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
     * [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
     * [Textual Encoding of Subject Public Key Info]
     * (https://tools.ietf.org/html/rfc7468#section-13).
     * </pre>
     *
     * <code>string pem = 1;</code>
     *
     * @param value The bytes for pem to set.
     * @return This builder for chaining.
     */
    public Builder setPemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pem_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The
     * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * associated with this key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * The
     * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * associated with this key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {
      algorithm_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The
     * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * associated with this key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm getAlgorithm() {
      com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm result =
          com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.forNumber(algorithm_);
      return result == null
          ? com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The
     * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * associated with this key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(
        com.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The
     * [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
     * associated with this key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm algorithm = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000002);
      algorithm_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value pemCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        pemCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     *
     * @return Whether the pemCrc32c field is set.
     */
    public boolean hasPemCrc32C() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     *
     * @return The pemCrc32c.
     */
    public com.google.protobuf.Int64Value getPemCrc32C() {
      if (pemCrc32CBuilder_ == null) {
        return pemCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : pemCrc32C_;
      } else {
        return pemCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public Builder setPemCrc32C(com.google.protobuf.Int64Value value) {
      if (pemCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pemCrc32C_ = value;
      } else {
        pemCrc32CBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public Builder setPemCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (pemCrc32CBuilder_ == null) {
        pemCrc32C_ = builderForValue.build();
      } else {
        pemCrc32CBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public Builder mergePemCrc32C(com.google.protobuf.Int64Value value) {
      if (pemCrc32CBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && pemCrc32C_ != null
            && pemCrc32C_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getPemCrc32CBuilder().mergeFrom(value);
        } else {
          pemCrc32C_ = value;
        }
      } else {
        pemCrc32CBuilder_.mergeFrom(value);
      }
      if (pemCrc32C_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public Builder clearPemCrc32C() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pemCrc32C_ = null;
      if (pemCrc32CBuilder_ != null) {
        pemCrc32CBuilder_.dispose();
        pemCrc32CBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public com.google.protobuf.Int64Value.Builder getPemCrc32CBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPemCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getPemCrc32COrBuilder() {
      if (pemCrc32CBuilder_ != null) {
        return pemCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return pemCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : pemCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Integrity verification field. A CRC32C checksum of the returned
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem]. An integrity check of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] can be performed by
     * computing the CRC32C checksum of
     * [PublicKey.pem][google.cloud.kms.v1.PublicKey.pem] and comparing your
     * results to this field. Discard the response in case of non-matching
     * checksum values, and perform a limited number of retries. A persistent
     * mismatch may indicate an issue in your computation of the CRC32C checksum.
     * Note: This field is defined as int64 for reasons of compatibility across
     * different languages. However, it is a non-negative integer, which will
     * never exceed `2^32-1`, and can be safely downconverted to uint32 in
     * languages that support this type.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value pem_crc32c = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getPemCrc32CFieldBuilder() {
      if (pemCrc32CBuilder_ == null) {
        pemCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getPemCrc32C(), getParentForChildren(), isClean());
        pemCrc32C_ = null;
      }
      return pemCrc32CBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * Provided here for verification.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * Provided here for verification.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * Provided here for verification.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * Provided here for verification.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [name][google.cloud.kms.v1.CryptoKeyVersion.name] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * Provided here for verification.
     *
     * NOTE: This field is in Beta.
     * </pre>
     *
     * <code>string name = 4;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int protectionLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return The enum numeric value on the wire for protectionLevel.
     */
    @java.lang.Override
    public int getProtectionLevelValue() {
      return protectionLevel_;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @param value The enum numeric value on the wire for protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevelValue(int value) {
      protectionLevel_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return The protectionLevel.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.ProtectionLevel getProtectionLevel() {
      com.google.cloud.kms.v1.ProtectionLevel result =
          com.google.cloud.kms.v1.ProtectionLevel.forNumber(protectionLevel_);
      return result == null ? com.google.cloud.kms.v1.ProtectionLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @param value The protectionLevel to set.
     * @return This builder for chaining.
     */
    public Builder setProtectionLevel(com.google.cloud.kms.v1.ProtectionLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      protectionLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] public key.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ProtectionLevel protection_level = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtectionLevel() {
      bitField0_ = (bitField0_ & ~0x00000010);
      protectionLevel_ = 0;
      onChanged();
      return this;
    }

    private int publicKeyFormat_ = 0;
    /**
     *
     *
     * <pre>
     * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
     * customer through the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
     *
     * @return The enum numeric value on the wire for publicKeyFormat.
     */
    @java.lang.Override
    public int getPublicKeyFormatValue() {
      return publicKeyFormat_;
    }
    /**
     *
     *
     * <pre>
     * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
     * customer through the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
     *
     * @param value The enum numeric value on the wire for publicKeyFormat to set.
     * @return This builder for chaining.
     */
    public Builder setPublicKeyFormatValue(int value) {
      publicKeyFormat_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
     * customer through the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
     *
     * @return The publicKeyFormat.
     */
    @java.lang.Override
    public com.google.cloud.kms.v1.PublicKey.PublicKeyFormat getPublicKeyFormat() {
      com.google.cloud.kms.v1.PublicKey.PublicKeyFormat result =
          com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.forNumber(publicKeyFormat_);
      return result == null
          ? com.google.cloud.kms.v1.PublicKey.PublicKeyFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
     * customer through the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
     *
     * @param value The publicKeyFormat to set.
     * @return This builder for chaining.
     */
    public Builder setPublicKeyFormat(com.google.cloud.kms.v1.PublicKey.PublicKeyFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      publicKeyFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [PublicKey][google.cloud.kms.v1.PublicKey] format specified by the
     * customer through the
     * [public_key_format][google.cloud.kms.v1.GetPublicKeyRequest.public_key_format]
     * field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.PublicKey.PublicKeyFormat public_key_format = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPublicKeyFormat() {
      bitField0_ = (bitField0_ & ~0x00000020);
      publicKeyFormat_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.kms.v1.ChecksummedData publicKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ChecksummedData,
            com.google.cloud.kms.v1.ChecksummedData.Builder,
            com.google.cloud.kms.v1.ChecksummedDataOrBuilder>
        publicKeyBuilder_;
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     *
     * @return Whether the publicKey field is set.
     */
    public boolean hasPublicKey() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     *
     * @return The publicKey.
     */
    public com.google.cloud.kms.v1.ChecksummedData getPublicKey() {
      if (publicKeyBuilder_ == null) {
        return publicKey_ == null
            ? com.google.cloud.kms.v1.ChecksummedData.getDefaultInstance()
            : publicKey_;
      } else {
        return publicKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public Builder setPublicKey(com.google.cloud.kms.v1.ChecksummedData value) {
      if (publicKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publicKey_ = value;
      } else {
        publicKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public Builder setPublicKey(com.google.cloud.kms.v1.ChecksummedData.Builder builderForValue) {
      if (publicKeyBuilder_ == null) {
        publicKey_ = builderForValue.build();
      } else {
        publicKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public Builder mergePublicKey(com.google.cloud.kms.v1.ChecksummedData value) {
      if (publicKeyBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && publicKey_ != null
            && publicKey_ != com.google.cloud.kms.v1.ChecksummedData.getDefaultInstance()) {
          getPublicKeyBuilder().mergeFrom(value);
        } else {
          publicKey_ = value;
        }
      } else {
        publicKeyBuilder_.mergeFrom(value);
      }
      if (publicKey_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public Builder clearPublicKey() {
      bitField0_ = (bitField0_ & ~0x00000040);
      publicKey_ = null;
      if (publicKeyBuilder_ != null) {
        publicKeyBuilder_.dispose();
        publicKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public com.google.cloud.kms.v1.ChecksummedData.Builder getPublicKeyBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getPublicKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    public com.google.cloud.kms.v1.ChecksummedDataOrBuilder getPublicKeyOrBuilder() {
      if (publicKeyBuilder_ != null) {
        return publicKeyBuilder_.getMessageOrBuilder();
      } else {
        return publicKey_ == null
            ? com.google.cloud.kms.v1.ChecksummedData.getDefaultInstance()
            : publicKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * This field contains the public key (with integrity verification), formatted
     * according to the
     * [public_key_format][google.cloud.kms.v1.PublicKey.public_key_format] field.
     * </pre>
     *
     * <code>.google.cloud.kms.v1.ChecksummedData public_key = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.kms.v1.ChecksummedData,
            com.google.cloud.kms.v1.ChecksummedData.Builder,
            com.google.cloud.kms.v1.ChecksummedDataOrBuilder>
        getPublicKeyFieldBuilder() {
      if (publicKeyBuilder_ == null) {
        publicKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.kms.v1.ChecksummedData,
                com.google.cloud.kms.v1.ChecksummedData.Builder,
                com.google.cloud.kms.v1.ChecksummedDataOrBuilder>(
                getPublicKey(), getParentForChildren(), isClean());
        publicKey_ = null;
      }
      return publicKeyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.PublicKey)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.PublicKey)
  private static final com.google.cloud.kms.v1.PublicKey DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.PublicKey();
  }

  public static com.google.cloud.kms.v1.PublicKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PublicKey> PARSER =
      new com.google.protobuf.AbstractParser<PublicKey>() {
        @java.lang.Override
        public PublicKey parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PublicKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PublicKey> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.PublicKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
