/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/kms/v1/service.proto

package com.google.cloud.kms.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
 * </pre>
 *
 * Protobuf type {@code google.cloud.kms.v1.AsymmetricDecryptRequest}
 */
public final class AsymmetricDecryptRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.kms.v1.AsymmetricDecryptRequest)
    AsymmetricDecryptRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AsymmetricDecryptRequest.newBuilder() to construct.
  private AsymmetricDecryptRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AsymmetricDecryptRequest() {
    name_ = "";
    ciphertext_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AsymmetricDecryptRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AsymmetricDecryptRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 26:
            {
              ciphertext_ = input.readBytes();
              break;
            }
          case 34:
            {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (ciphertextCrc32C_ != null) {
                subBuilder = ciphertextCrc32C_.toBuilder();
              }
              ciphertextCrc32C_ =
                  input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ciphertextCrc32C_);
                ciphertextCrc32C_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricDecryptRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.kms.v1.KmsProto
        .internal_static_google_cloud_kms_v1_AsymmetricDecryptRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.kms.v1.AsymmetricDecryptRequest.class,
            com.google.cloud.kms.v1.AsymmetricDecryptRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * decryption.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
   * decryption.
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CIPHERTEXT_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString ciphertext_;
  /**
   *
   *
   * <pre>
   * Required. The data encrypted with the named
   * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public key using
   * OAEP.
   * </pre>
   *
   * <code>bytes ciphertext = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The ciphertext.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCiphertext() {
    return ciphertext_;
  }

  public static final int CIPHERTEXT_CRC32C_FIELD_NUMBER = 4;
  private com.google.protobuf.Int64Value ciphertextCrc32C_;
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
   * is equal to
   * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ciphertextCrc32c field is set.
   */
  @java.lang.Override
  public boolean hasCiphertextCrc32C() {
    return ciphertextCrc32C_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
   * is equal to
   * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ciphertextCrc32c.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getCiphertextCrc32C() {
    return ciphertextCrc32C_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : ciphertextCrc32C_;
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional CRC32C checksum of the
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
   * If specified,
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * verify the integrity of the received
   * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
   * using this checksum.
   * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
   * report an error if the checksum verification fails. If you receive a
   * checksum error, your client should verify that
   * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
   * is equal to
   * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
   * and if so, perform a limited number of retries. A persistent mismatch may
   * indicate an issue in your computation of the CRC32C checksum. Note: This
   * field is defined as int64 for reasons of compatibility across different
   * languages. However, it is a non-negative integer, which will never exceed
   * 2^32-1, and can be safely downconverted to uint32 in languages that support
   * this type.
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
    return getCiphertextCrc32C();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      output.writeBytes(3, ciphertext_);
    }
    if (ciphertextCrc32C_ != null) {
      output.writeMessage(4, getCiphertextCrc32C());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!ciphertext_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, ciphertext_);
    }
    if (ciphertextCrc32C_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCiphertextCrc32C());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.kms.v1.AsymmetricDecryptRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.kms.v1.AsymmetricDecryptRequest other =
        (com.google.cloud.kms.v1.AsymmetricDecryptRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCiphertext().equals(other.getCiphertext())) return false;
    if (hasCiphertextCrc32C() != other.hasCiphertextCrc32C()) return false;
    if (hasCiphertextCrc32C()) {
      if (!getCiphertextCrc32C().equals(other.getCiphertextCrc32C())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + CIPHERTEXT_FIELD_NUMBER;
    hash = (53 * hash) + getCiphertext().hashCode();
    if (hasCiphertextCrc32C()) {
      hash = (37 * hash) + CIPHERTEXT_CRC32C_FIELD_NUMBER;
      hash = (53 * hash) + getCiphertextCrc32C().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.kms.v1.AsymmetricDecryptRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [KeyManagementService.AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt].
   * </pre>
   *
   * Protobuf type {@code google.cloud.kms.v1.AsymmetricDecryptRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.kms.v1.AsymmetricDecryptRequest)
      com.google.cloud.kms.v1.AsymmetricDecryptRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricDecryptRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricDecryptRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.kms.v1.AsymmetricDecryptRequest.class,
              com.google.cloud.kms.v1.AsymmetricDecryptRequest.Builder.class);
    }

    // Construct using com.google.cloud.kms.v1.AsymmetricDecryptRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      ciphertext_ = com.google.protobuf.ByteString.EMPTY;

      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = null;
      } else {
        ciphertextCrc32C_ = null;
        ciphertextCrc32CBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.kms.v1.KmsProto
          .internal_static_google_cloud_kms_v1_AsymmetricDecryptRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricDecryptRequest getDefaultInstanceForType() {
      return com.google.cloud.kms.v1.AsymmetricDecryptRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricDecryptRequest build() {
      com.google.cloud.kms.v1.AsymmetricDecryptRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.kms.v1.AsymmetricDecryptRequest buildPartial() {
      com.google.cloud.kms.v1.AsymmetricDecryptRequest result =
          new com.google.cloud.kms.v1.AsymmetricDecryptRequest(this);
      result.name_ = name_;
      result.ciphertext_ = ciphertext_;
      if (ciphertextCrc32CBuilder_ == null) {
        result.ciphertextCrc32C_ = ciphertextCrc32C_;
      } else {
        result.ciphertextCrc32C_ = ciphertextCrc32CBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.kms.v1.AsymmetricDecryptRequest) {
        return mergeFrom((com.google.cloud.kms.v1.AsymmetricDecryptRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.kms.v1.AsymmetricDecryptRequest other) {
      if (other == com.google.cloud.kms.v1.AsymmetricDecryptRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getCiphertext() != com.google.protobuf.ByteString.EMPTY) {
        setCiphertext(other.getCiphertext());
      }
      if (other.hasCiphertextCrc32C()) {
        mergeCiphertextCrc32C(other.getCiphertextCrc32C());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.kms.v1.AsymmetricDecryptRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.kms.v1.AsymmetricDecryptRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * decryption.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * decryption.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * decryption.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * decryption.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] to use for
     * decryption.
     * </pre>
     *
     * <code>
     * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString ciphertext_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The data encrypted with the named
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public key using
     * OAEP.
     * </pre>
     *
     * <code>bytes ciphertext = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The ciphertext.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCiphertext() {
      return ciphertext_;
    }
    /**
     *
     *
     * <pre>
     * Required. The data encrypted with the named
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public key using
     * OAEP.
     * </pre>
     *
     * <code>bytes ciphertext = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The ciphertext to set.
     * @return This builder for chaining.
     */
    public Builder setCiphertext(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      ciphertext_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data encrypted with the named
     * [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s public key using
     * OAEP.
     * </pre>
     *
     * <code>bytes ciphertext = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCiphertext() {

      ciphertext_ = getDefaultInstance().getCiphertext();
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value ciphertextCrc32C_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        ciphertextCrc32CBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ciphertextCrc32c field is set.
     */
    public boolean hasCiphertextCrc32C() {
      return ciphertextCrc32CBuilder_ != null || ciphertextCrc32C_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ciphertextCrc32c.
     */
    public com.google.protobuf.Int64Value getCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      } else {
        return ciphertextCrc32CBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ciphertextCrc32C_ = value;
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCiphertextCrc32C(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = builderForValue.build();
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCiphertextCrc32C(com.google.protobuf.Int64Value value) {
      if (ciphertextCrc32CBuilder_ == null) {
        if (ciphertextCrc32C_ != null) {
          ciphertextCrc32C_ =
              com.google.protobuf.Int64Value.newBuilder(ciphertextCrc32C_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ciphertextCrc32C_ = value;
        }
        onChanged();
      } else {
        ciphertextCrc32CBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCiphertextCrc32C() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32C_ = null;
        onChanged();
      } else {
        ciphertextCrc32C_ = null;
        ciphertextCrc32CBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getCiphertextCrc32CBuilder() {

      onChanged();
      return getCiphertextCrc32CFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getCiphertextCrc32COrBuilder() {
      if (ciphertextCrc32CBuilder_ != null) {
        return ciphertextCrc32CBuilder_.getMessageOrBuilder();
      } else {
        return ciphertextCrc32C_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : ciphertextCrc32C_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional CRC32C checksum of the
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext].
     * If specified,
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * verify the integrity of the received
     * [AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext]
     * using this checksum.
     * [KeyManagementService][google.cloud.kms.v1.KeyManagementService] will
     * report an error if the checksum verification fails. If you receive a
     * checksum error, your client should verify that
     * CRC32C([AsymmetricDecryptRequest.ciphertext][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext])
     * is equal to
     * [AsymmetricDecryptRequest.ciphertext_crc32c][google.cloud.kms.v1.AsymmetricDecryptRequest.ciphertext_crc32c],
     * and if so, perform a limited number of retries. A persistent mismatch may
     * indicate an issue in your computation of the CRC32C checksum. Note: This
     * field is defined as int64 for reasons of compatibility across different
     * languages. However, it is a non-negative integer, which will never exceed
     * 2^32-1, and can be safely downconverted to uint32 in languages that support
     * this type.
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value ciphertext_crc32c = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getCiphertextCrc32CFieldBuilder() {
      if (ciphertextCrc32CBuilder_ == null) {
        ciphertextCrc32CBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getCiphertextCrc32C(), getParentForChildren(), isClean());
        ciphertextCrc32C_ = null;
      }
      return ciphertextCrc32CBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.kms.v1.AsymmetricDecryptRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.kms.v1.AsymmetricDecryptRequest)
  private static final com.google.cloud.kms.v1.AsymmetricDecryptRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.kms.v1.AsymmetricDecryptRequest();
  }

  public static com.google.cloud.kms.v1.AsymmetricDecryptRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AsymmetricDecryptRequest> PARSER =
      new com.google.protobuf.AbstractParser<AsymmetricDecryptRequest>() {
        @java.lang.Override
        public AsymmetricDecryptRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AsymmetricDecryptRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AsymmetricDecryptRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AsymmetricDecryptRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.kms.v1.AsymmetricDecryptRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
