/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InputName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INPUT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/inputs/{input}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String input;

    @Deprecated
    protected InputName() {
        this.project = null;
        this.location = null;
        this.input = null;
    }

    private InputName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.input = (String)Preconditions.checkNotNull((Object)builder.getInput());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInput() {
        return this.input;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InputName of(String project, String location, String input) {
        return InputName.newBuilder().setProject(project).setLocation(location).setInput(input).build();
    }

    public static String format(String project, String location, String input) {
        return InputName.newBuilder().setProject(project).setLocation(location).setInput(input).build().toString();
    }

    public static InputName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INPUT.validatedMatch(formattedString, "InputName.parse: formattedString not in valid format");
        return InputName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("input"));
    }

    public static List<InputName> parseList(List<String> formattedStrings) {
        ArrayList<InputName> list = new ArrayList<InputName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InputName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InputName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InputName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INPUT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InputName inputName = this;
            synchronized (inputName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.input != null) {
                        fieldMapBuilder.put((Object)"input", (Object)this.input);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INPUT.instantiate(new String[]{"project", this.project, "location", this.location, "input", this.input});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InputName that = (InputName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.input, that.input);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.input);
    }

    public static class Builder {
        private String project;
        private String location;
        private String input;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInput() {
            return this.input;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        private Builder(InputName inputName) {
            this.project = inputName.project;
            this.location = inputName.location;
            this.input = inputName.input;
        }

        public InputName build() {
            return new InputName(this);
        }
    }
}

