/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.logging.v2.MetricName;

public class MetricNameOneof {
    private final ResourceName resourceName;

    public MetricName getMetricName() {
        if (this.resourceName instanceof MetricName) {
            return (MetricName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private MetricNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static MetricNameOneof parse(String resourceNameString) {
        if (MetricName.isParsableFrom(resourceNameString)) {
            return new MetricNameOneof(MetricName.parse(resourceNameString));
        }
        return new MetricNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static MetricNameOneof from(MetricName metricName) {
        return new MetricNameOneof(metricName);
    }

    public static MetricNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new MetricNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricNameOneof) {
            MetricNameOneof that = (MetricNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

