/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.OrganizationSinkNameType;
import java.util.Map;

public class OrganizationSinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sinks/{sink}");
    private final String organization;
    private final String sink;

    public String getOrganization() {
        return this.organization;
    }

    public String getSink() {
        return this.sink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OrganizationSinkName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
    }

    public static OrganizationSinkName create(String organization, String sink) {
        return OrganizationSinkName.newBuilder().setOrganization(organization).setSink(sink).build();
    }

    public static OrganizationSinkName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "OrganizationSinkName.parse: formattedString not in valid format");
        return OrganizationSinkName.create((String)matchMap.get("organization"), (String)matchMap.get("sink"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return OrganizationSinkNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"organization", this.organization, "sink", this.sink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OrganizationSinkName) {
            OrganizationSinkName that = (OrganizationSinkName)o;
            return this.organization.equals(that.organization) && this.sink.equals(that.sink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.organization.hashCode();
        h *= 1000003;
        return h ^= this.sink.hashCode();
    }

    public static class Builder {
        private String organization;
        private String sink;

        public String getOrganization() {
            return this.organization;
        }

        public String getSink() {
            return this.sink;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        private Builder() {
        }

        private Builder(OrganizationSinkName organizationSinkName) {
            this.organization = organizationSinkName.organization;
            this.sink = organizationSinkName.sink;
        }

        public OrganizationSinkName build() {
            return new OrganizationSinkName(this);
        }
    }
}

