/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.dashboard.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DashboardName
implements ResourceName {
    private static final PathTemplate PROJECT_DASHBOARD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dashboards/{dashboard}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dashboard;

    @Deprecated
    protected DashboardName() {
        this.project = null;
        this.dashboard = null;
    }

    private DashboardName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dashboard = (String)Preconditions.checkNotNull((Object)builder.getDashboard());
    }

    public String getProject() {
        return this.project;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DashboardName of(String project, String dashboard) {
        return DashboardName.newBuilder().setProject(project).setDashboard(dashboard).build();
    }

    public static String format(String project, String dashboard) {
        return DashboardName.newBuilder().setProject(project).setDashboard(dashboard).build().toString();
    }

    public static DashboardName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DASHBOARD.validatedMatch(formattedString, "DashboardName.parse: formattedString not in valid format");
        return DashboardName.of((String)matchMap.get("project"), (String)matchMap.get("dashboard"));
    }

    public static List<DashboardName> parseList(List<String> formattedStrings) {
        ArrayList<DashboardName> list = new ArrayList<DashboardName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DashboardName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DashboardName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DashboardName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DASHBOARD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DashboardName dashboardName = this;
            synchronized (dashboardName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dashboard != null) {
                        fieldMapBuilder.put((Object)"dashboard", (Object)this.dashboard);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DASHBOARD.instantiate(new String[]{"project", this.project, "dashboard", this.dashboard});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DashboardName that = (DashboardName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dashboard, that.dashboard);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dashboard);
    }

    public static class Builder {
        private String project;
        private String dashboard;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDashboard() {
            return this.dashboard;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        private Builder(DashboardName dashboardName) {
            this.project = dashboardName.project;
            this.dashboard = dashboardName.dashboard;
        }

        public DashboardName build() {
            return new DashboardName(this);
        }
    }
}

