/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/common.proto

// Protobuf Java Version: 3.25.4
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * Describes how to combine multiple time series to provide a different view of
 * the data.  Aggregation of time series is done in two steps. First, each time
 * series in the set is _aligned_ to the same time interval boundaries, then the
 * set of time series is optionally _reduced_ in number.
 *
 * Alignment consists of applying the `per_series_aligner` operation
 * to each time series after its data has been divided into regular
 * `alignment_period` time intervals. This process takes _all_ of the data
 * points in an alignment period, applies a mathematical transformation such as
 * averaging, minimum, maximum, delta, etc., and converts them into a single
 * data point per period.
 *
 * Reduction is when the aligned and transformed time series can optionally be
 * combined, reducing the number of time series through similar mathematical
 * transformations. Reduction involves applying a `cross_series_reducer` to
 * all the time series, optionally sorting the time series into subsets with
 * `group_by_fields`, and applying the reducer to each subset.
 *
 * The raw time series data can contain a huge amount of information from
 * multiple sources. Alignment and reduction transforms this mass of data into
 * a more manageable and representative collection of data, for example "the
 * 95% latency across the average of all tasks in a cluster". This
 * representative data can be more easily graphed and comprehended, and the
 * individual time series data is still available for later drilldown. For more
 * details, see [Filtering and
 * aggregation](https://cloud.google.com/monitoring/api/v3/aggregation).
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.Aggregation}
 */
public final class Aggregation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.Aggregation)
    AggregationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Aggregation.newBuilder() to construct.
  private Aggregation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Aggregation() {
    perSeriesAligner_ = 0;
    crossSeriesReducer_ = 0;
    groupByFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Aggregation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.CommonProto
        .internal_static_google_monitoring_v3_Aggregation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.CommonProto
        .internal_static_google_monitoring_v3_Aggregation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.Aggregation.class,
            com.google.monitoring.v3.Aggregation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The `Aligner` specifies the operation that will be applied to the data
   * points in each alignment period in a time series. Except for
   * `ALIGN_NONE`, which specifies that no operation be applied, each alignment
   * operation replaces the set of data values in each alignment period with
   * a single value: the result of applying the operation to the data values.
   * An aligned time series has a single data value at the end of each
   * `alignment_period`.
   *
   * An alignment operation can change the data type of the values, too. For
   * example, if you apply a counting operation to boolean values, the data
   * `value_type` in the original time series is `BOOLEAN`, but the `value_type`
   * in the aligned result is `INT64`.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.Aggregation.Aligner}
   */
  public enum Aligner implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No alignment. Raw data is returned. Not valid if cross-series reduction
     * is requested. The `value_type` of the result is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_NONE = 0;</code>
     */
    ALIGN_NONE(0),
    /**
     *
     *
     * <pre>
     * Align and convert to
     * [DELTA][google.api.MetricDescriptor.MetricKind.DELTA].
     * The output is `delta = y1 - y0`.
     *
     * This alignment is valid for
     * [CUMULATIVE][google.api.MetricDescriptor.MetricKind.CUMULATIVE] and
     * `DELTA` metrics. If the selected alignment period results in periods
     * with no data, then the aligned value for such a period is created by
     * interpolation. The `value_type`  of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_DELTA = 1;</code>
     */
    ALIGN_DELTA(1),
    /**
     *
     *
     * <pre>
     * Align and convert to a rate. The result is computed as
     * `rate = (y1 - y0)/(t1 - t0)`, or "delta over time".
     * Think of this aligner as providing the slope of the line that passes
     * through the value at the start and at the end of the `alignment_period`.
     *
     * This aligner is valid for `CUMULATIVE`
     * and `DELTA` metrics with numeric values. If the selected alignment
     * period results in periods with no data, then the aligned value for
     * such a period is created by interpolation. The output is a `GAUGE`
     * metric with `value_type` `DOUBLE`.
     *
     * If, by "rate", you mean "percentage change", see the
     * `ALIGN_PERCENT_CHANGE` aligner instead.
     * </pre>
     *
     * <code>ALIGN_RATE = 2;</code>
     */
    ALIGN_RATE(2),
    /**
     *
     *
     * <pre>
     * Align by interpolating between adjacent points around the alignment
     * period boundary. This aligner is valid for `GAUGE` metrics with
     * numeric values. The `value_type` of the aligned result is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_INTERPOLATE = 3;</code>
     */
    ALIGN_INTERPOLATE(3),
    /**
     *
     *
     * <pre>
     * Align by moving the most recent data point before the end of the
     * alignment period to the boundary at the end of the alignment
     * period. This aligner is valid for `GAUGE` metrics. The `value_type` of
     * the aligned result is the same as the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_NEXT_OLDER = 4;</code>
     */
    ALIGN_NEXT_OLDER(4),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the minimum value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_MIN = 10;</code>
     */
    ALIGN_MIN(10),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the maximum value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_MAX = 11;</code>
     */
    ALIGN_MAX(11),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the mean value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_MEAN = 12;</code>
     */
    ALIGN_MEAN(12),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of values in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric or Boolean values. The `value_type` of the aligned result is
     * `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT = 13;</code>
     */
    ALIGN_COUNT(13),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the sum of the values in each
     * alignment period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with numeric and distribution values. The `value_type` of the
     * aligned result is the same as the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_SUM = 14;</code>
     */
    ALIGN_SUM(14),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the standard deviation of the values
     * in each alignment period. This aligner is valid for `GAUGE` and
     * `DELTA` metrics with numeric values. The `value_type` of the output is
     * `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_STDDEV = 15;</code>
     */
    ALIGN_STDDEV(15),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of `True` values in
     * each alignment period. This aligner is valid for `GAUGE` metrics with
     * Boolean values. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT_TRUE = 16;</code>
     */
    ALIGN_COUNT_TRUE(16),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of `False` values in
     * each alignment period. This aligner is valid for `GAUGE` metrics with
     * Boolean values. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT_FALSE = 24;</code>
     */
    ALIGN_COUNT_FALSE(24),
    /**
     *
     *
     * <pre>
     * Align the time series by returning the ratio of the number of `True`
     * values to the total number of values in each alignment period. This
     * aligner is valid for `GAUGE` metrics with Boolean values. The output
     * value is in the range [0.0, 1.0] and has `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_FRACTION_TRUE = 17;</code>
     */
    ALIGN_FRACTION_TRUE(17),
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 99th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_99 = 18;</code>
     */
    ALIGN_PERCENTILE_99(18),
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 95th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_95 = 19;</code>
     */
    ALIGN_PERCENTILE_95(19),
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 50th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_50 = 20;</code>
     */
    ALIGN_PERCENTILE_50(20),
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 5th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_05 = 21;</code>
     */
    ALIGN_PERCENTILE_05(21),
    /**
     *
     *
     * <pre>
     * Align and convert to a percentage change. This aligner is valid for
     * `GAUGE` and `DELTA` metrics with numeric values. This alignment returns
     * `((current - previous)/previous) * 100`, where the value of `previous` is
     * determined based on the `alignment_period`.
     *
     * If the values of `current` and `previous` are both 0, then the returned
     * value is 0. If only `previous` is 0, the returned value is infinity.
     *
     * A 10-minute moving mean is computed at each point of the alignment period
     * prior to the above calculation to smooth the metric and prevent false
     * positives from very short-lived spikes. The moving mean is only
     * applicable for data whose values are `&gt;= 0`. Any values `&lt; 0` are
     * treated as a missing datapoint, and are ignored. While `DELTA`
     * metrics are accepted by this alignment, special care should be taken that
     * the values for the metric will always be positive. The output is a
     * `GAUGE` metric with `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENT_CHANGE = 23;</code>
     */
    ALIGN_PERCENT_CHANGE(23),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No alignment. Raw data is returned. Not valid if cross-series reduction
     * is requested. The `value_type` of the result is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_NONE = 0;</code>
     */
    public static final int ALIGN_NONE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Align and convert to
     * [DELTA][google.api.MetricDescriptor.MetricKind.DELTA].
     * The output is `delta = y1 - y0`.
     *
     * This alignment is valid for
     * [CUMULATIVE][google.api.MetricDescriptor.MetricKind.CUMULATIVE] and
     * `DELTA` metrics. If the selected alignment period results in periods
     * with no data, then the aligned value for such a period is created by
     * interpolation. The `value_type`  of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_DELTA = 1;</code>
     */
    public static final int ALIGN_DELTA_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Align and convert to a rate. The result is computed as
     * `rate = (y1 - y0)/(t1 - t0)`, or "delta over time".
     * Think of this aligner as providing the slope of the line that passes
     * through the value at the start and at the end of the `alignment_period`.
     *
     * This aligner is valid for `CUMULATIVE`
     * and `DELTA` metrics with numeric values. If the selected alignment
     * period results in periods with no data, then the aligned value for
     * such a period is created by interpolation. The output is a `GAUGE`
     * metric with `value_type` `DOUBLE`.
     *
     * If, by "rate", you mean "percentage change", see the
     * `ALIGN_PERCENT_CHANGE` aligner instead.
     * </pre>
     *
     * <code>ALIGN_RATE = 2;</code>
     */
    public static final int ALIGN_RATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Align by interpolating between adjacent points around the alignment
     * period boundary. This aligner is valid for `GAUGE` metrics with
     * numeric values. The `value_type` of the aligned result is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_INTERPOLATE = 3;</code>
     */
    public static final int ALIGN_INTERPOLATE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Align by moving the most recent data point before the end of the
     * alignment period to the boundary at the end of the alignment
     * period. This aligner is valid for `GAUGE` metrics. The `value_type` of
     * the aligned result is the same as the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_NEXT_OLDER = 4;</code>
     */
    public static final int ALIGN_NEXT_OLDER_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the minimum value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_MIN = 10;</code>
     */
    public static final int ALIGN_MIN_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the maximum value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is the same as
     * the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_MAX = 11;</code>
     */
    public static final int ALIGN_MAX_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the mean value in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric values. The `value_type` of the aligned result is `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_MEAN = 12;</code>
     */
    public static final int ALIGN_MEAN_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of values in each alignment
     * period. This aligner is valid for `GAUGE` and `DELTA` metrics with
     * numeric or Boolean values. The `value_type` of the aligned result is
     * `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT = 13;</code>
     */
    public static final int ALIGN_COUNT_VALUE = 13;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the sum of the values in each
     * alignment period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with numeric and distribution values. The `value_type` of the
     * aligned result is the same as the `value_type` of the input.
     * </pre>
     *
     * <code>ALIGN_SUM = 14;</code>
     */
    public static final int ALIGN_SUM_VALUE = 14;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the standard deviation of the values
     * in each alignment period. This aligner is valid for `GAUGE` and
     * `DELTA` metrics with numeric values. The `value_type` of the output is
     * `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_STDDEV = 15;</code>
     */
    public static final int ALIGN_STDDEV_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of `True` values in
     * each alignment period. This aligner is valid for `GAUGE` metrics with
     * Boolean values. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT_TRUE = 16;</code>
     */
    public static final int ALIGN_COUNT_TRUE_VALUE = 16;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the number of `False` values in
     * each alignment period. This aligner is valid for `GAUGE` metrics with
     * Boolean values. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>ALIGN_COUNT_FALSE = 24;</code>
     */
    public static final int ALIGN_COUNT_FALSE_VALUE = 24;
    /**
     *
     *
     * <pre>
     * Align the time series by returning the ratio of the number of `True`
     * values to the total number of values in each alignment period. This
     * aligner is valid for `GAUGE` metrics with Boolean values. The output
     * value is in the range [0.0, 1.0] and has `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_FRACTION_TRUE = 17;</code>
     */
    public static final int ALIGN_FRACTION_TRUE_VALUE = 17;
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 99th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_99 = 18;</code>
     */
    public static final int ALIGN_PERCENTILE_99_VALUE = 18;
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 95th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_95 = 19;</code>
     */
    public static final int ALIGN_PERCENTILE_95_VALUE = 19;
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 50th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_50 = 20;</code>
     */
    public static final int ALIGN_PERCENTILE_50_VALUE = 20;
    /**
     *
     *
     * <pre>
     * Align the time series by using [percentile
     * aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
     * data point in each alignment period is the 5th percentile of all data
     * points in the period. This aligner is valid for `GAUGE` and `DELTA`
     * metrics with distribution values. The output is a `GAUGE` metric with
     * `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENTILE_05 = 21;</code>
     */
    public static final int ALIGN_PERCENTILE_05_VALUE = 21;
    /**
     *
     *
     * <pre>
     * Align and convert to a percentage change. This aligner is valid for
     * `GAUGE` and `DELTA` metrics with numeric values. This alignment returns
     * `((current - previous)/previous) * 100`, where the value of `previous` is
     * determined based on the `alignment_period`.
     *
     * If the values of `current` and `previous` are both 0, then the returned
     * value is 0. If only `previous` is 0, the returned value is infinity.
     *
     * A 10-minute moving mean is computed at each point of the alignment period
     * prior to the above calculation to smooth the metric and prevent false
     * positives from very short-lived spikes. The moving mean is only
     * applicable for data whose values are `&gt;= 0`. Any values `&lt; 0` are
     * treated as a missing datapoint, and are ignored. While `DELTA`
     * metrics are accepted by this alignment, special care should be taken that
     * the values for the metric will always be positive. The output is a
     * `GAUGE` metric with `value_type` `DOUBLE`.
     * </pre>
     *
     * <code>ALIGN_PERCENT_CHANGE = 23;</code>
     */
    public static final int ALIGN_PERCENT_CHANGE_VALUE = 23;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Aligner valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Aligner forNumber(int value) {
      switch (value) {
        case 0:
          return ALIGN_NONE;
        case 1:
          return ALIGN_DELTA;
        case 2:
          return ALIGN_RATE;
        case 3:
          return ALIGN_INTERPOLATE;
        case 4:
          return ALIGN_NEXT_OLDER;
        case 10:
          return ALIGN_MIN;
        case 11:
          return ALIGN_MAX;
        case 12:
          return ALIGN_MEAN;
        case 13:
          return ALIGN_COUNT;
        case 14:
          return ALIGN_SUM;
        case 15:
          return ALIGN_STDDEV;
        case 16:
          return ALIGN_COUNT_TRUE;
        case 24:
          return ALIGN_COUNT_FALSE;
        case 17:
          return ALIGN_FRACTION_TRUE;
        case 18:
          return ALIGN_PERCENTILE_99;
        case 19:
          return ALIGN_PERCENTILE_95;
        case 20:
          return ALIGN_PERCENTILE_50;
        case 21:
          return ALIGN_PERCENTILE_05;
        case 23:
          return ALIGN_PERCENT_CHANGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Aligner> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Aligner> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Aligner>() {
          public Aligner findValueByNumber(int number) {
            return Aligner.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.Aggregation.getDescriptor().getEnumTypes().get(0);
    }

    private static final Aligner[] VALUES = values();

    public static Aligner valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Aligner(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.Aggregation.Aligner)
  }

  /**
   *
   *
   * <pre>
   * A Reducer operation describes how to aggregate data points from multiple
   * time series into a single time series, where the value of each data point
   * in the resulting series is a function of all the already aligned values in
   * the input time series.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.Aggregation.Reducer}
   */
  public enum Reducer implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No cross-time series reduction. The output of the `Aligner` is
     * returned.
     * </pre>
     *
     * <code>REDUCE_NONE = 0;</code>
     */
    REDUCE_NONE(0),
    /**
     *
     *
     * <pre>
     * Reduce by computing the mean value across time series for each
     * alignment period. This reducer is valid for
     * [DELTA][google.api.MetricDescriptor.MetricKind.DELTA] and
     * [GAUGE][google.api.MetricDescriptor.MetricKind.GAUGE] metrics with
     * numeric or distribution values. The `value_type` of the output is
     * [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
     * </pre>
     *
     * <code>REDUCE_MEAN = 1;</code>
     */
    REDUCE_MEAN(1),
    /**
     *
     *
     * <pre>
     * Reduce by computing the minimum value across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric values. The `value_type` of the output is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_MIN = 2;</code>
     */
    REDUCE_MIN(2),
    /**
     *
     *
     * <pre>
     * Reduce by computing the maximum value across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric values. The `value_type` of the output is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_MAX = 3;</code>
     */
    REDUCE_MAX(3),
    /**
     *
     *
     * <pre>
     * Reduce by computing the sum across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric and distribution values. The `value_type` of the output is
     * the same as the `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_SUM = 4;</code>
     */
    REDUCE_SUM(4),
    /**
     *
     *
     * <pre>
     * Reduce by computing the standard deviation across time series
     * for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics with numeric or distribution values. The `value_type`
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_STDDEV = 5;</code>
     */
    REDUCE_STDDEV(5),
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of data points across time series
     * for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of numeric, Boolean, distribution, and string
     * `value_type`. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT = 6;</code>
     */
    REDUCE_COUNT(6),
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of `True`-valued data points across time
     * series for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
     * is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT_TRUE = 7;</code>
     */
    REDUCE_COUNT_TRUE(7),
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of `False`-valued data points across time
     * series for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
     * is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT_FALSE = 15;</code>
     */
    REDUCE_COUNT_FALSE(15),
    /**
     *
     *
     * <pre>
     * Reduce by computing the ratio of the number of `True`-valued data points
     * to the total number of data points for each alignment period. This
     * reducer is valid for `DELTA` and `GAUGE` metrics of Boolean `value_type`.
     * The output value is in the range [0.0, 1.0] and has `value_type`
     * `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_FRACTION_TRUE = 8;</code>
     */
    REDUCE_FRACTION_TRUE(8),
    /**
     *
     *
     * <pre>
     * Reduce by computing the [99th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_99 = 9;</code>
     */
    REDUCE_PERCENTILE_99(9),
    /**
     *
     *
     * <pre>
     * Reduce by computing the [95th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_95 = 10;</code>
     */
    REDUCE_PERCENTILE_95(10),
    /**
     *
     *
     * <pre>
     * Reduce by computing the [50th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_50 = 11;</code>
     */
    REDUCE_PERCENTILE_50(11),
    /**
     *
     *
     * <pre>
     * Reduce by computing the [5th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_05 = 12;</code>
     */
    REDUCE_PERCENTILE_05(12),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No cross-time series reduction. The output of the `Aligner` is
     * returned.
     * </pre>
     *
     * <code>REDUCE_NONE = 0;</code>
     */
    public static final int REDUCE_NONE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Reduce by computing the mean value across time series for each
     * alignment period. This reducer is valid for
     * [DELTA][google.api.MetricDescriptor.MetricKind.DELTA] and
     * [GAUGE][google.api.MetricDescriptor.MetricKind.GAUGE] metrics with
     * numeric or distribution values. The `value_type` of the output is
     * [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
     * </pre>
     *
     * <code>REDUCE_MEAN = 1;</code>
     */
    public static final int REDUCE_MEAN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Reduce by computing the minimum value across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric values. The `value_type` of the output is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_MIN = 2;</code>
     */
    public static final int REDUCE_MIN_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Reduce by computing the maximum value across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric values. The `value_type` of the output is the same as the
     * `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_MAX = 3;</code>
     */
    public static final int REDUCE_MAX_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Reduce by computing the sum across time series for each
     * alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
     * with numeric and distribution values. The `value_type` of the output is
     * the same as the `value_type` of the input.
     * </pre>
     *
     * <code>REDUCE_SUM = 4;</code>
     */
    public static final int REDUCE_SUM_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Reduce by computing the standard deviation across time series
     * for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics with numeric or distribution values. The `value_type`
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_STDDEV = 5;</code>
     */
    public static final int REDUCE_STDDEV_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of data points across time series
     * for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of numeric, Boolean, distribution, and string
     * `value_type`. The `value_type` of the output is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT = 6;</code>
     */
    public static final int REDUCE_COUNT_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of `True`-valued data points across time
     * series for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
     * is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT_TRUE = 7;</code>
     */
    public static final int REDUCE_COUNT_TRUE_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Reduce by computing the number of `False`-valued data points across time
     * series for each alignment period. This reducer is valid for `DELTA` and
     * `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
     * is `INT64`.
     * </pre>
     *
     * <code>REDUCE_COUNT_FALSE = 15;</code>
     */
    public static final int REDUCE_COUNT_FALSE_VALUE = 15;
    /**
     *
     *
     * <pre>
     * Reduce by computing the ratio of the number of `True`-valued data points
     * to the total number of data points for each alignment period. This
     * reducer is valid for `DELTA` and `GAUGE` metrics of Boolean `value_type`.
     * The output value is in the range [0.0, 1.0] and has `value_type`
     * `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_FRACTION_TRUE = 8;</code>
     */
    public static final int REDUCE_FRACTION_TRUE_VALUE = 8;
    /**
     *
     *
     * <pre>
     * Reduce by computing the [99th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_99 = 9;</code>
     */
    public static final int REDUCE_PERCENTILE_99_VALUE = 9;
    /**
     *
     *
     * <pre>
     * Reduce by computing the [95th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_95 = 10;</code>
     */
    public static final int REDUCE_PERCENTILE_95_VALUE = 10;
    /**
     *
     *
     * <pre>
     * Reduce by computing the [50th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_50 = 11;</code>
     */
    public static final int REDUCE_PERCENTILE_50_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Reduce by computing the [5th
     * percentile](https://en.wikipedia.org/wiki/Percentile) of data points
     * across time series for each alignment period. This reducer is valid for
     * `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
     * of the output is `DOUBLE`.
     * </pre>
     *
     * <code>REDUCE_PERCENTILE_05 = 12;</code>
     */
    public static final int REDUCE_PERCENTILE_05_VALUE = 12;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Reducer valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Reducer forNumber(int value) {
      switch (value) {
        case 0:
          return REDUCE_NONE;
        case 1:
          return REDUCE_MEAN;
        case 2:
          return REDUCE_MIN;
        case 3:
          return REDUCE_MAX;
        case 4:
          return REDUCE_SUM;
        case 5:
          return REDUCE_STDDEV;
        case 6:
          return REDUCE_COUNT;
        case 7:
          return REDUCE_COUNT_TRUE;
        case 15:
          return REDUCE_COUNT_FALSE;
        case 8:
          return REDUCE_FRACTION_TRUE;
        case 9:
          return REDUCE_PERCENTILE_99;
        case 10:
          return REDUCE_PERCENTILE_95;
        case 11:
          return REDUCE_PERCENTILE_50;
        case 12:
          return REDUCE_PERCENTILE_05;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Reducer> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Reducer> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Reducer>() {
          public Reducer findValueByNumber(int number) {
            return Reducer.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.Aggregation.getDescriptor().getEnumTypes().get(1);
    }

    private static final Reducer[] VALUES = values();

    public static Reducer valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Reducer(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.Aggregation.Reducer)
  }

  private int bitField0_;
  public static final int ALIGNMENT_PERIOD_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration alignmentPeriod_;
  /**
   *
   *
   * <pre>
   * The `alignment_period` specifies a time interval, in seconds, that is used
   * to divide the data in all the
   * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
   * time. This will be done before the per-series aligner can be applied to
   * the data.
   *
   * The value must be at least 60 seconds. If a per-series
   * aligner other than `ALIGN_NONE` is specified, this field is required or an
   * error is returned. If no per-series aligner is specified, or the aligner
   * `ALIGN_NONE` is specified, then this field is ignored.
   *
   * The maximum value of the `alignment_period` is 104 weeks (2 years) for
   * charts, and 90,000 seconds (25 hours) for alerting policies.
   * </pre>
   *
   * <code>.google.protobuf.Duration alignment_period = 1;</code>
   *
   * @return Whether the alignmentPeriod field is set.
   */
  @java.lang.Override
  public boolean hasAlignmentPeriod() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The `alignment_period` specifies a time interval, in seconds, that is used
   * to divide the data in all the
   * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
   * time. This will be done before the per-series aligner can be applied to
   * the data.
   *
   * The value must be at least 60 seconds. If a per-series
   * aligner other than `ALIGN_NONE` is specified, this field is required or an
   * error is returned. If no per-series aligner is specified, or the aligner
   * `ALIGN_NONE` is specified, then this field is ignored.
   *
   * The maximum value of the `alignment_period` is 104 weeks (2 years) for
   * charts, and 90,000 seconds (25 hours) for alerting policies.
   * </pre>
   *
   * <code>.google.protobuf.Duration alignment_period = 1;</code>
   *
   * @return The alignmentPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getAlignmentPeriod() {
    return alignmentPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : alignmentPeriod_;
  }
  /**
   *
   *
   * <pre>
   * The `alignment_period` specifies a time interval, in seconds, that is used
   * to divide the data in all the
   * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
   * time. This will be done before the per-series aligner can be applied to
   * the data.
   *
   * The value must be at least 60 seconds. If a per-series
   * aligner other than `ALIGN_NONE` is specified, this field is required or an
   * error is returned. If no per-series aligner is specified, or the aligner
   * `ALIGN_NONE` is specified, then this field is ignored.
   *
   * The maximum value of the `alignment_period` is 104 weeks (2 years) for
   * charts, and 90,000 seconds (25 hours) for alerting policies.
   * </pre>
   *
   * <code>.google.protobuf.Duration alignment_period = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getAlignmentPeriodOrBuilder() {
    return alignmentPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : alignmentPeriod_;
  }

  public static final int PER_SERIES_ALIGNER_FIELD_NUMBER = 2;
  private int perSeriesAligner_ = 0;
  /**
   *
   *
   * <pre>
   * An `Aligner` describes how to bring the data points in a single
   * time series into temporal alignment. Except for `ALIGN_NONE`, all
   * alignments cause all the data points in an `alignment_period` to be
   * mathematically grouped together, resulting in a single data point for
   * each `alignment_period` with end timestamp at the end of the period.
   *
   * Not all alignment operations may be applied to all time series. The valid
   * choices depend on the `metric_kind` and `value_type` of the original time
   * series. Alignment can change the `metric_kind` or the `value_type` of
   * the time series.
   *
   * Time series data must be aligned in order to perform cross-time
   * series reduction. If `cross_series_reducer` is specified, then
   * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
   * and `alignment_period` must be specified; otherwise, an error is
   * returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
   *
   * @return The enum numeric value on the wire for perSeriesAligner.
   */
  @java.lang.Override
  public int getPerSeriesAlignerValue() {
    return perSeriesAligner_;
  }
  /**
   *
   *
   * <pre>
   * An `Aligner` describes how to bring the data points in a single
   * time series into temporal alignment. Except for `ALIGN_NONE`, all
   * alignments cause all the data points in an `alignment_period` to be
   * mathematically grouped together, resulting in a single data point for
   * each `alignment_period` with end timestamp at the end of the period.
   *
   * Not all alignment operations may be applied to all time series. The valid
   * choices depend on the `metric_kind` and `value_type` of the original time
   * series. Alignment can change the `metric_kind` or the `value_type` of
   * the time series.
   *
   * Time series data must be aligned in order to perform cross-time
   * series reduction. If `cross_series_reducer` is specified, then
   * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
   * and `alignment_period` must be specified; otherwise, an error is
   * returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
   *
   * @return The perSeriesAligner.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Aggregation.Aligner getPerSeriesAligner() {
    com.google.monitoring.v3.Aggregation.Aligner result =
        com.google.monitoring.v3.Aggregation.Aligner.forNumber(perSeriesAligner_);
    return result == null ? com.google.monitoring.v3.Aggregation.Aligner.UNRECOGNIZED : result;
  }

  public static final int CROSS_SERIES_REDUCER_FIELD_NUMBER = 4;
  private int crossSeriesReducer_ = 0;
  /**
   *
   *
   * <pre>
   * The reduction operation to be used to combine time series into a single
   * time series, where the value of each data point in the resulting series is
   * a function of all the already aligned values in the input time series.
   *
   * Not all reducer operations can be applied to all time series. The valid
   * choices depend on the `metric_kind` and the `value_type` of the original
   * time series. Reduction can yield a time series with a different
   * `metric_kind` or `value_type` than the input time series.
   *
   * Time series data must first be aligned (see `per_series_aligner`) in order
   * to perform cross-time series reduction. If `cross_series_reducer` is
   * specified, then `per_series_aligner` must be specified, and must not be
   * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
   * error is returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
   *
   * @return The enum numeric value on the wire for crossSeriesReducer.
   */
  @java.lang.Override
  public int getCrossSeriesReducerValue() {
    return crossSeriesReducer_;
  }
  /**
   *
   *
   * <pre>
   * The reduction operation to be used to combine time series into a single
   * time series, where the value of each data point in the resulting series is
   * a function of all the already aligned values in the input time series.
   *
   * Not all reducer operations can be applied to all time series. The valid
   * choices depend on the `metric_kind` and the `value_type` of the original
   * time series. Reduction can yield a time series with a different
   * `metric_kind` or `value_type` than the input time series.
   *
   * Time series data must first be aligned (see `per_series_aligner`) in order
   * to perform cross-time series reduction. If `cross_series_reducer` is
   * specified, then `per_series_aligner` must be specified, and must not be
   * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
   * error is returned.
   * </pre>
   *
   * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
   *
   * @return The crossSeriesReducer.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Aggregation.Reducer getCrossSeriesReducer() {
    com.google.monitoring.v3.Aggregation.Reducer result =
        com.google.monitoring.v3.Aggregation.Reducer.forNumber(crossSeriesReducer_);
    return result == null ? com.google.monitoring.v3.Aggregation.Reducer.UNRECOGNIZED : result;
  }

  public static final int GROUP_BY_FIELDS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList groupByFields_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The set of fields to preserve when `cross_series_reducer` is
   * specified. The `group_by_fields` determine how the time series are
   * partitioned into subsets prior to applying the aggregation
   * operation. Each subset contains time series that have the same
   * value for each of the grouping fields. Each individual time
   * series is a member of exactly one subset. The
   * `cross_series_reducer` is applied to each subset of time series.
   * It is not possible to reduce across different resource types, so
   * this field implicitly contains `resource.type`.  Fields not
   * specified in `group_by_fields` are aggregated away.  If
   * `group_by_fields` is not specified and all the time series have
   * the same resource type, then the time series are aggregated into
   * a single output time series. If `cross_series_reducer` is not
   * defined, this field is ignored.
   * </pre>
   *
   * <code>repeated string group_by_fields = 5;</code>
   *
   * @return A list containing the groupByFields.
   */
  public com.google.protobuf.ProtocolStringList getGroupByFieldsList() {
    return groupByFields_;
  }
  /**
   *
   *
   * <pre>
   * The set of fields to preserve when `cross_series_reducer` is
   * specified. The `group_by_fields` determine how the time series are
   * partitioned into subsets prior to applying the aggregation
   * operation. Each subset contains time series that have the same
   * value for each of the grouping fields. Each individual time
   * series is a member of exactly one subset. The
   * `cross_series_reducer` is applied to each subset of time series.
   * It is not possible to reduce across different resource types, so
   * this field implicitly contains `resource.type`.  Fields not
   * specified in `group_by_fields` are aggregated away.  If
   * `group_by_fields` is not specified and all the time series have
   * the same resource type, then the time series are aggregated into
   * a single output time series. If `cross_series_reducer` is not
   * defined, this field is ignored.
   * </pre>
   *
   * <code>repeated string group_by_fields = 5;</code>
   *
   * @return The count of groupByFields.
   */
  public int getGroupByFieldsCount() {
    return groupByFields_.size();
  }
  /**
   *
   *
   * <pre>
   * The set of fields to preserve when `cross_series_reducer` is
   * specified. The `group_by_fields` determine how the time series are
   * partitioned into subsets prior to applying the aggregation
   * operation. Each subset contains time series that have the same
   * value for each of the grouping fields. Each individual time
   * series is a member of exactly one subset. The
   * `cross_series_reducer` is applied to each subset of time series.
   * It is not possible to reduce across different resource types, so
   * this field implicitly contains `resource.type`.  Fields not
   * specified in `group_by_fields` are aggregated away.  If
   * `group_by_fields` is not specified and all the time series have
   * the same resource type, then the time series are aggregated into
   * a single output time series. If `cross_series_reducer` is not
   * defined, this field is ignored.
   * </pre>
   *
   * <code>repeated string group_by_fields = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The groupByFields at the given index.
   */
  public java.lang.String getGroupByFields(int index) {
    return groupByFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The set of fields to preserve when `cross_series_reducer` is
   * specified. The `group_by_fields` determine how the time series are
   * partitioned into subsets prior to applying the aggregation
   * operation. Each subset contains time series that have the same
   * value for each of the grouping fields. Each individual time
   * series is a member of exactly one subset. The
   * `cross_series_reducer` is applied to each subset of time series.
   * It is not possible to reduce across different resource types, so
   * this field implicitly contains `resource.type`.  Fields not
   * specified in `group_by_fields` are aggregated away.  If
   * `group_by_fields` is not specified and all the time series have
   * the same resource type, then the time series are aggregated into
   * a single output time series. If `cross_series_reducer` is not
   * defined, this field is ignored.
   * </pre>
   *
   * <code>repeated string group_by_fields = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the groupByFields at the given index.
   */
  public com.google.protobuf.ByteString getGroupByFieldsBytes(int index) {
    return groupByFields_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getAlignmentPeriod());
    }
    if (perSeriesAligner_ != com.google.monitoring.v3.Aggregation.Aligner.ALIGN_NONE.getNumber()) {
      output.writeEnum(2, perSeriesAligner_);
    }
    if (crossSeriesReducer_
        != com.google.monitoring.v3.Aggregation.Reducer.REDUCE_NONE.getNumber()) {
      output.writeEnum(4, crossSeriesReducer_);
    }
    for (int i = 0; i < groupByFields_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, groupByFields_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAlignmentPeriod());
    }
    if (perSeriesAligner_ != com.google.monitoring.v3.Aggregation.Aligner.ALIGN_NONE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, perSeriesAligner_);
    }
    if (crossSeriesReducer_
        != com.google.monitoring.v3.Aggregation.Reducer.REDUCE_NONE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, crossSeriesReducer_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < groupByFields_.size(); i++) {
        dataSize += computeStringSizeNoTag(groupByFields_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getGroupByFieldsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.Aggregation)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.Aggregation other = (com.google.monitoring.v3.Aggregation) obj;

    if (hasAlignmentPeriod() != other.hasAlignmentPeriod()) return false;
    if (hasAlignmentPeriod()) {
      if (!getAlignmentPeriod().equals(other.getAlignmentPeriod())) return false;
    }
    if (perSeriesAligner_ != other.perSeriesAligner_) return false;
    if (crossSeriesReducer_ != other.crossSeriesReducer_) return false;
    if (!getGroupByFieldsList().equals(other.getGroupByFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAlignmentPeriod()) {
      hash = (37 * hash) + ALIGNMENT_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getAlignmentPeriod().hashCode();
    }
    hash = (37 * hash) + PER_SERIES_ALIGNER_FIELD_NUMBER;
    hash = (53 * hash) + perSeriesAligner_;
    hash = (37 * hash) + CROSS_SERIES_REDUCER_FIELD_NUMBER;
    hash = (53 * hash) + crossSeriesReducer_;
    if (getGroupByFieldsCount() > 0) {
      hash = (37 * hash) + GROUP_BY_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getGroupByFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Aggregation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Aggregation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.Aggregation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.Aggregation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes how to combine multiple time series to provide a different view of
   * the data.  Aggregation of time series is done in two steps. First, each time
   * series in the set is _aligned_ to the same time interval boundaries, then the
   * set of time series is optionally _reduced_ in number.
   *
   * Alignment consists of applying the `per_series_aligner` operation
   * to each time series after its data has been divided into regular
   * `alignment_period` time intervals. This process takes _all_ of the data
   * points in an alignment period, applies a mathematical transformation such as
   * averaging, minimum, maximum, delta, etc., and converts them into a single
   * data point per period.
   *
   * Reduction is when the aligned and transformed time series can optionally be
   * combined, reducing the number of time series through similar mathematical
   * transformations. Reduction involves applying a `cross_series_reducer` to
   * all the time series, optionally sorting the time series into subsets with
   * `group_by_fields`, and applying the reducer to each subset.
   *
   * The raw time series data can contain a huge amount of information from
   * multiple sources. Alignment and reduction transforms this mass of data into
   * a more manageable and representative collection of data, for example "the
   * 95% latency across the average of all tasks in a cluster". This
   * representative data can be more easily graphed and comprehended, and the
   * individual time series data is still available for later drilldown. For more
   * details, see [Filtering and
   * aggregation](https://cloud.google.com/monitoring/api/v3/aggregation).
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.Aggregation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.Aggregation)
      com.google.monitoring.v3.AggregationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.CommonProto
          .internal_static_google_monitoring_v3_Aggregation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.CommonProto
          .internal_static_google_monitoring_v3_Aggregation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.Aggregation.class,
              com.google.monitoring.v3.Aggregation.Builder.class);
    }

    // Construct using com.google.monitoring.v3.Aggregation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAlignmentPeriodFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      alignmentPeriod_ = null;
      if (alignmentPeriodBuilder_ != null) {
        alignmentPeriodBuilder_.dispose();
        alignmentPeriodBuilder_ = null;
      }
      perSeriesAligner_ = 0;
      crossSeriesReducer_ = 0;
      groupByFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.CommonProto
          .internal_static_google_monitoring_v3_Aggregation_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Aggregation getDefaultInstanceForType() {
      return com.google.monitoring.v3.Aggregation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.Aggregation build() {
      com.google.monitoring.v3.Aggregation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.Aggregation buildPartial() {
      com.google.monitoring.v3.Aggregation result = new com.google.monitoring.v3.Aggregation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.Aggregation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.alignmentPeriod_ =
            alignmentPeriodBuilder_ == null ? alignmentPeriod_ : alignmentPeriodBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.perSeriesAligner_ = perSeriesAligner_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.crossSeriesReducer_ = crossSeriesReducer_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        groupByFields_.makeImmutable();
        result.groupByFields_ = groupByFields_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.Aggregation) {
        return mergeFrom((com.google.monitoring.v3.Aggregation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.Aggregation other) {
      if (other == com.google.monitoring.v3.Aggregation.getDefaultInstance()) return this;
      if (other.hasAlignmentPeriod()) {
        mergeAlignmentPeriod(other.getAlignmentPeriod());
      }
      if (other.perSeriesAligner_ != 0) {
        setPerSeriesAlignerValue(other.getPerSeriesAlignerValue());
      }
      if (other.crossSeriesReducer_ != 0) {
        setCrossSeriesReducerValue(other.getCrossSeriesReducerValue());
      }
      if (!other.groupByFields_.isEmpty()) {
        if (groupByFields_.isEmpty()) {
          groupByFields_ = other.groupByFields_;
          bitField0_ |= 0x00000008;
        } else {
          ensureGroupByFieldsIsMutable();
          groupByFields_.addAll(other.groupByFields_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAlignmentPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                perSeriesAligner_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 32:
              {
                crossSeriesReducer_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureGroupByFieldsIsMutable();
                groupByFields_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration alignmentPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        alignmentPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     *
     * @return Whether the alignmentPeriod field is set.
     */
    public boolean hasAlignmentPeriod() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     *
     * @return The alignmentPeriod.
     */
    public com.google.protobuf.Duration getAlignmentPeriod() {
      if (alignmentPeriodBuilder_ == null) {
        return alignmentPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : alignmentPeriod_;
      } else {
        return alignmentPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public Builder setAlignmentPeriod(com.google.protobuf.Duration value) {
      if (alignmentPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        alignmentPeriod_ = value;
      } else {
        alignmentPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public Builder setAlignmentPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (alignmentPeriodBuilder_ == null) {
        alignmentPeriod_ = builderForValue.build();
      } else {
        alignmentPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public Builder mergeAlignmentPeriod(com.google.protobuf.Duration value) {
      if (alignmentPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && alignmentPeriod_ != null
            && alignmentPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getAlignmentPeriodBuilder().mergeFrom(value);
        } else {
          alignmentPeriod_ = value;
        }
      } else {
        alignmentPeriodBuilder_.mergeFrom(value);
      }
      if (alignmentPeriod_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public Builder clearAlignmentPeriod() {
      bitField0_ = (bitField0_ & ~0x00000001);
      alignmentPeriod_ = null;
      if (alignmentPeriodBuilder_ != null) {
        alignmentPeriodBuilder_.dispose();
        alignmentPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getAlignmentPeriodBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAlignmentPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getAlignmentPeriodOrBuilder() {
      if (alignmentPeriodBuilder_ != null) {
        return alignmentPeriodBuilder_.getMessageOrBuilder();
      } else {
        return alignmentPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : alignmentPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * The `alignment_period` specifies a time interval, in seconds, that is used
     * to divide the data in all the
     * [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
     * time. This will be done before the per-series aligner can be applied to
     * the data.
     *
     * The value must be at least 60 seconds. If a per-series
     * aligner other than `ALIGN_NONE` is specified, this field is required or an
     * error is returned. If no per-series aligner is specified, or the aligner
     * `ALIGN_NONE` is specified, then this field is ignored.
     *
     * The maximum value of the `alignment_period` is 104 weeks (2 years) for
     * charts, and 90,000 seconds (25 hours) for alerting policies.
     * </pre>
     *
     * <code>.google.protobuf.Duration alignment_period = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getAlignmentPeriodFieldBuilder() {
      if (alignmentPeriodBuilder_ == null) {
        alignmentPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getAlignmentPeriod(), getParentForChildren(), isClean());
        alignmentPeriod_ = null;
      }
      return alignmentPeriodBuilder_;
    }

    private int perSeriesAligner_ = 0;
    /**
     *
     *
     * <pre>
     * An `Aligner` describes how to bring the data points in a single
     * time series into temporal alignment. Except for `ALIGN_NONE`, all
     * alignments cause all the data points in an `alignment_period` to be
     * mathematically grouped together, resulting in a single data point for
     * each `alignment_period` with end timestamp at the end of the period.
     *
     * Not all alignment operations may be applied to all time series. The valid
     * choices depend on the `metric_kind` and `value_type` of the original time
     * series. Alignment can change the `metric_kind` or the `value_type` of
     * the time series.
     *
     * Time series data must be aligned in order to perform cross-time
     * series reduction. If `cross_series_reducer` is specified, then
     * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
     * and `alignment_period` must be specified; otherwise, an error is
     * returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
     *
     * @return The enum numeric value on the wire for perSeriesAligner.
     */
    @java.lang.Override
    public int getPerSeriesAlignerValue() {
      return perSeriesAligner_;
    }
    /**
     *
     *
     * <pre>
     * An `Aligner` describes how to bring the data points in a single
     * time series into temporal alignment. Except for `ALIGN_NONE`, all
     * alignments cause all the data points in an `alignment_period` to be
     * mathematically grouped together, resulting in a single data point for
     * each `alignment_period` with end timestamp at the end of the period.
     *
     * Not all alignment operations may be applied to all time series. The valid
     * choices depend on the `metric_kind` and `value_type` of the original time
     * series. Alignment can change the `metric_kind` or the `value_type` of
     * the time series.
     *
     * Time series data must be aligned in order to perform cross-time
     * series reduction. If `cross_series_reducer` is specified, then
     * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
     * and `alignment_period` must be specified; otherwise, an error is
     * returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
     *
     * @param value The enum numeric value on the wire for perSeriesAligner to set.
     * @return This builder for chaining.
     */
    public Builder setPerSeriesAlignerValue(int value) {
      perSeriesAligner_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An `Aligner` describes how to bring the data points in a single
     * time series into temporal alignment. Except for `ALIGN_NONE`, all
     * alignments cause all the data points in an `alignment_period` to be
     * mathematically grouped together, resulting in a single data point for
     * each `alignment_period` with end timestamp at the end of the period.
     *
     * Not all alignment operations may be applied to all time series. The valid
     * choices depend on the `metric_kind` and `value_type` of the original time
     * series. Alignment can change the `metric_kind` or the `value_type` of
     * the time series.
     *
     * Time series data must be aligned in order to perform cross-time
     * series reduction. If `cross_series_reducer` is specified, then
     * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
     * and `alignment_period` must be specified; otherwise, an error is
     * returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
     *
     * @return The perSeriesAligner.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Aggregation.Aligner getPerSeriesAligner() {
      com.google.monitoring.v3.Aggregation.Aligner result =
          com.google.monitoring.v3.Aggregation.Aligner.forNumber(perSeriesAligner_);
      return result == null ? com.google.monitoring.v3.Aggregation.Aligner.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * An `Aligner` describes how to bring the data points in a single
     * time series into temporal alignment. Except for `ALIGN_NONE`, all
     * alignments cause all the data points in an `alignment_period` to be
     * mathematically grouped together, resulting in a single data point for
     * each `alignment_period` with end timestamp at the end of the period.
     *
     * Not all alignment operations may be applied to all time series. The valid
     * choices depend on the `metric_kind` and `value_type` of the original time
     * series. Alignment can change the `metric_kind` or the `value_type` of
     * the time series.
     *
     * Time series data must be aligned in order to perform cross-time
     * series reduction. If `cross_series_reducer` is specified, then
     * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
     * and `alignment_period` must be specified; otherwise, an error is
     * returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
     *
     * @param value The perSeriesAligner to set.
     * @return This builder for chaining.
     */
    public Builder setPerSeriesAligner(com.google.monitoring.v3.Aggregation.Aligner value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      perSeriesAligner_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An `Aligner` describes how to bring the data points in a single
     * time series into temporal alignment. Except for `ALIGN_NONE`, all
     * alignments cause all the data points in an `alignment_period` to be
     * mathematically grouped together, resulting in a single data point for
     * each `alignment_period` with end timestamp at the end of the period.
     *
     * Not all alignment operations may be applied to all time series. The valid
     * choices depend on the `metric_kind` and `value_type` of the original time
     * series. Alignment can change the `metric_kind` or the `value_type` of
     * the time series.
     *
     * Time series data must be aligned in order to perform cross-time
     * series reduction. If `cross_series_reducer` is specified, then
     * `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
     * and `alignment_period` must be specified; otherwise, an error is
     * returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Aligner per_series_aligner = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPerSeriesAligner() {
      bitField0_ = (bitField0_ & ~0x00000002);
      perSeriesAligner_ = 0;
      onChanged();
      return this;
    }

    private int crossSeriesReducer_ = 0;
    /**
     *
     *
     * <pre>
     * The reduction operation to be used to combine time series into a single
     * time series, where the value of each data point in the resulting series is
     * a function of all the already aligned values in the input time series.
     *
     * Not all reducer operations can be applied to all time series. The valid
     * choices depend on the `metric_kind` and the `value_type` of the original
     * time series. Reduction can yield a time series with a different
     * `metric_kind` or `value_type` than the input time series.
     *
     * Time series data must first be aligned (see `per_series_aligner`) in order
     * to perform cross-time series reduction. If `cross_series_reducer` is
     * specified, then `per_series_aligner` must be specified, and must not be
     * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
     * error is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
     *
     * @return The enum numeric value on the wire for crossSeriesReducer.
     */
    @java.lang.Override
    public int getCrossSeriesReducerValue() {
      return crossSeriesReducer_;
    }
    /**
     *
     *
     * <pre>
     * The reduction operation to be used to combine time series into a single
     * time series, where the value of each data point in the resulting series is
     * a function of all the already aligned values in the input time series.
     *
     * Not all reducer operations can be applied to all time series. The valid
     * choices depend on the `metric_kind` and the `value_type` of the original
     * time series. Reduction can yield a time series with a different
     * `metric_kind` or `value_type` than the input time series.
     *
     * Time series data must first be aligned (see `per_series_aligner`) in order
     * to perform cross-time series reduction. If `cross_series_reducer` is
     * specified, then `per_series_aligner` must be specified, and must not be
     * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
     * error is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
     *
     * @param value The enum numeric value on the wire for crossSeriesReducer to set.
     * @return This builder for chaining.
     */
    public Builder setCrossSeriesReducerValue(int value) {
      crossSeriesReducer_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reduction operation to be used to combine time series into a single
     * time series, where the value of each data point in the resulting series is
     * a function of all the already aligned values in the input time series.
     *
     * Not all reducer operations can be applied to all time series. The valid
     * choices depend on the `metric_kind` and the `value_type` of the original
     * time series. Reduction can yield a time series with a different
     * `metric_kind` or `value_type` than the input time series.
     *
     * Time series data must first be aligned (see `per_series_aligner`) in order
     * to perform cross-time series reduction. If `cross_series_reducer` is
     * specified, then `per_series_aligner` must be specified, and must not be
     * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
     * error is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
     *
     * @return The crossSeriesReducer.
     */
    @java.lang.Override
    public com.google.monitoring.v3.Aggregation.Reducer getCrossSeriesReducer() {
      com.google.monitoring.v3.Aggregation.Reducer result =
          com.google.monitoring.v3.Aggregation.Reducer.forNumber(crossSeriesReducer_);
      return result == null ? com.google.monitoring.v3.Aggregation.Reducer.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The reduction operation to be used to combine time series into a single
     * time series, where the value of each data point in the resulting series is
     * a function of all the already aligned values in the input time series.
     *
     * Not all reducer operations can be applied to all time series. The valid
     * choices depend on the `metric_kind` and the `value_type` of the original
     * time series. Reduction can yield a time series with a different
     * `metric_kind` or `value_type` than the input time series.
     *
     * Time series data must first be aligned (see `per_series_aligner`) in order
     * to perform cross-time series reduction. If `cross_series_reducer` is
     * specified, then `per_series_aligner` must be specified, and must not be
     * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
     * error is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
     *
     * @param value The crossSeriesReducer to set.
     * @return This builder for chaining.
     */
    public Builder setCrossSeriesReducer(com.google.monitoring.v3.Aggregation.Reducer value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      crossSeriesReducer_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The reduction operation to be used to combine time series into a single
     * time series, where the value of each data point in the resulting series is
     * a function of all the already aligned values in the input time series.
     *
     * Not all reducer operations can be applied to all time series. The valid
     * choices depend on the `metric_kind` and the `value_type` of the original
     * time series. Reduction can yield a time series with a different
     * `metric_kind` or `value_type` than the input time series.
     *
     * Time series data must first be aligned (see `per_series_aligner`) in order
     * to perform cross-time series reduction. If `cross_series_reducer` is
     * specified, then `per_series_aligner` must be specified, and must not be
     * `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
     * error is returned.
     * </pre>
     *
     * <code>.google.monitoring.v3.Aggregation.Reducer cross_series_reducer = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCrossSeriesReducer() {
      bitField0_ = (bitField0_ & ~0x00000004);
      crossSeriesReducer_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList groupByFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureGroupByFieldsIsMutable() {
      if (!groupByFields_.isModifiable()) {
        groupByFields_ = new com.google.protobuf.LazyStringArrayList(groupByFields_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @return A list containing the groupByFields.
     */
    public com.google.protobuf.ProtocolStringList getGroupByFieldsList() {
      groupByFields_.makeImmutable();
      return groupByFields_;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @return The count of groupByFields.
     */
    public int getGroupByFieldsCount() {
      return groupByFields_.size();
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The groupByFields at the given index.
     */
    public java.lang.String getGroupByFields(int index) {
      return groupByFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the groupByFields at the given index.
     */
    public com.google.protobuf.ByteString getGroupByFieldsBytes(int index) {
      return groupByFields_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The groupByFields to set.
     * @return This builder for chaining.
     */
    public Builder setGroupByFields(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGroupByFieldsIsMutable();
      groupByFields_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param value The groupByFields to add.
     * @return This builder for chaining.
     */
    public Builder addGroupByFields(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGroupByFieldsIsMutable();
      groupByFields_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param values The groupByFields to add.
     * @return This builder for chaining.
     */
    public Builder addAllGroupByFields(java.lang.Iterable<java.lang.String> values) {
      ensureGroupByFieldsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupByFields_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroupByFields() {
      groupByFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of fields to preserve when `cross_series_reducer` is
     * specified. The `group_by_fields` determine how the time series are
     * partitioned into subsets prior to applying the aggregation
     * operation. Each subset contains time series that have the same
     * value for each of the grouping fields. Each individual time
     * series is a member of exactly one subset. The
     * `cross_series_reducer` is applied to each subset of time series.
     * It is not possible to reduce across different resource types, so
     * this field implicitly contains `resource.type`.  Fields not
     * specified in `group_by_fields` are aggregated away.  If
     * `group_by_fields` is not specified and all the time series have
     * the same resource type, then the time series are aggregated into
     * a single output time series. If `cross_series_reducer` is not
     * defined, this field is ignored.
     * </pre>
     *
     * <code>repeated string group_by_fields = 5;</code>
     *
     * @param value The bytes of the groupByFields to add.
     * @return This builder for chaining.
     */
    public Builder addGroupByFieldsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureGroupByFieldsIsMutable();
      groupByFields_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.Aggregation)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.Aggregation)
  private static final com.google.monitoring.v3.Aggregation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.Aggregation();
  }

  public static com.google.monitoring.v3.Aggregation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Aggregation> PARSER =
      new com.google.protobuf.AbstractParser<Aggregation>() {
        @java.lang.Override
        public Aggregation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Aggregation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Aggregation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.Aggregation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
