/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

// Protobuf Java Version: 3.25.4
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A Service-Level Objective (SLO) describes a level of desired good service. It
 * consists of a service-level indicator (SLI), a performance goal, and a period
 * over which the objective is to be evaluated against that goal. The SLO can
 * use SLIs defined in a number of different manners. Typical SLOs might include
 * "99% of requests in each rolling week have latency below 200 milliseconds" or
 * "99.5% of requests in each calendar month return successfully."
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ServiceLevelObjective}
 */
public final class ServiceLevelObjective extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ServiceLevelObjective)
    ServiceLevelObjectiveOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceLevelObjective.newBuilder() to construct.
  private ServiceLevelObjective(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceLevelObjective() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceLevelObjective();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_ServiceLevelObjective_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 12:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_ServiceLevelObjective_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ServiceLevelObjective.class,
            com.google.monitoring.v3.ServiceLevelObjective.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * `ServiceLevelObjective.View` determines what form of
   * `ServiceLevelObjective` is returned from `GetServiceLevelObjective`,
   * `ListServiceLevelObjectives`, and `ListServiceLevelObjectiveVersions` RPCs.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.ServiceLevelObjective.View}
   */
  public enum View implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Same as FULL.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Return the embedded `ServiceLevelIndicator` in the form in which it was
     * defined. If it was defined using a `BasicSli`, return that `BasicSli`.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    FULL(2),
    /**
     *
     *
     * <pre>
     * For `ServiceLevelIndicator`s using `BasicSli` articulation, instead
     * return the `ServiceLevelIndicator` with its mode of computation fully
     * spelled out as a `RequestBasedSli`. For `ServiceLevelIndicator`s using
     * `RequestBasedSli` or `WindowsBasedSli`, return the
     * `ServiceLevelIndicator` as it was provided.
     * </pre>
     *
     * <code>EXPLICIT = 1;</code>
     */
    EXPLICIT(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Same as FULL.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int VIEW_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Return the embedded `ServiceLevelIndicator` in the form in which it was
     * defined. If it was defined using a `BasicSli`, return that `BasicSli`.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    public static final int FULL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * For `ServiceLevelIndicator`s using `BasicSli` articulation, instead
     * return the `ServiceLevelIndicator` with its mode of computation fully
     * spelled out as a `RequestBasedSli`. For `ServiceLevelIndicator`s using
     * `RequestBasedSli` or `WindowsBasedSli`, return the
     * `ServiceLevelIndicator` as it was provided.
     * </pre>
     *
     * <code>EXPLICIT = 1;</code>
     */
    public static final int EXPLICIT_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static View valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static View forNumber(int value) {
      switch (value) {
        case 0:
          return VIEW_UNSPECIFIED;
        case 2:
          return FULL;
        case 1:
          return EXPLICIT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<View> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<View> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<View>() {
          public View findValueByNumber(int number) {
            return View.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceLevelObjective.getDescriptor().getEnumTypes().get(0);
    }

    private static final View[] VALUES = values();

    public static View valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private View(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.ServiceLevelObjective.View)
  }

  private int bitField0_;
  private int periodCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object period_;

  public enum PeriodCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ROLLING_PERIOD(5),
    CALENDAR_PERIOD(6),
    PERIOD_NOT_SET(0);
    private final int value;

    private PeriodCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PeriodCase valueOf(int value) {
      return forNumber(value);
    }

    public static PeriodCase forNumber(int value) {
      switch (value) {
        case 5:
          return ROLLING_PERIOD;
        case 6:
          return CALENDAR_PERIOD;
        case 0:
          return PERIOD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PeriodCase getPeriodCase() {
    return PeriodCase.forNumber(periodCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
   *
   *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this SLO.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name used for UI elements listing this SLO.
   * </pre>
   *
   * <code>string display_name = 11;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_LEVEL_INDICATOR_FIELD_NUMBER = 3;
  private com.google.monitoring.v3.ServiceLevelIndicator serviceLevelIndicator_;
  /**
   *
   *
   * <pre>
   * The definition of good service, used to measure and calculate the quality
   * of the `Service`'s performance with respect to a single aspect of service
   * quality.
   * </pre>
   *
   * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
   *
   * @return Whether the serviceLevelIndicator field is set.
   */
  @java.lang.Override
  public boolean hasServiceLevelIndicator() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The definition of good service, used to measure and calculate the quality
   * of the `Service`'s performance with respect to a single aspect of service
   * quality.
   * </pre>
   *
   * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
   *
   * @return The serviceLevelIndicator.
   */
  @java.lang.Override
  public com.google.monitoring.v3.ServiceLevelIndicator getServiceLevelIndicator() {
    return serviceLevelIndicator_ == null
        ? com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()
        : serviceLevelIndicator_;
  }
  /**
   *
   *
   * <pre>
   * The definition of good service, used to measure and calculate the quality
   * of the `Service`'s performance with respect to a single aspect of service
   * quality.
   * </pre>
   *
   * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder
      getServiceLevelIndicatorOrBuilder() {
    return serviceLevelIndicator_ == null
        ? com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()
        : serviceLevelIndicator_;
  }

  public static final int GOAL_FIELD_NUMBER = 4;
  private double goal_ = 0D;
  /**
   *
   *
   * <pre>
   * The fraction of service that must be good in order for this objective to be
   * met. `0 &lt; goal &lt;= 0.999`.
   * </pre>
   *
   * <code>double goal = 4;</code>
   *
   * @return The goal.
   */
  @java.lang.Override
  public double getGoal() {
    return goal_;
  }

  public static final int ROLLING_PERIOD_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
   * Must be an integer multiple of 1 day no larger than 30 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration rolling_period = 5;</code>
   *
   * @return Whether the rollingPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRollingPeriod() {
    return periodCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
   * Must be an integer multiple of 1 day no larger than 30 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration rolling_period = 5;</code>
   *
   * @return The rollingPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRollingPeriod() {
    if (periodCase_ == 5) {
      return (com.google.protobuf.Duration) period_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
   * Must be an integer multiple of 1 day no larger than 30 days.
   * </pre>
   *
   * <code>.google.protobuf.Duration rolling_period = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRollingPeriodOrBuilder() {
    if (periodCase_ == 5) {
      return (com.google.protobuf.Duration) period_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int CALENDAR_PERIOD_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A calendar period, semantically "since the start of the current
   * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
   * `MONTH` are supported.
   * </pre>
   *
   * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
   *
   * @return Whether the calendarPeriod field is set.
   */
  public boolean hasCalendarPeriod() {
    return periodCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A calendar period, semantically "since the start of the current
   * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
   * `MONTH` are supported.
   * </pre>
   *
   * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
   *
   * @return The enum numeric value on the wire for calendarPeriod.
   */
  public int getCalendarPeriodValue() {
    if (periodCase_ == 6) {
      return (java.lang.Integer) period_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * A calendar period, semantically "since the start of the current
   * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
   * `MONTH` are supported.
   * </pre>
   *
   * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
   *
   * @return The calendarPeriod.
   */
  public com.google.type.CalendarPeriod getCalendarPeriod() {
    if (periodCase_ == 6) {
      com.google.type.CalendarPeriod result =
          com.google.type.CalendarPeriod.forNumber((java.lang.Integer) period_);
      return result == null ? com.google.type.CalendarPeriod.UNRECOGNIZED : result;
    }
    return com.google.type.CalendarPeriod.CALENDAR_PERIOD_UNSPECIFIED;
  }

  public static final int USER_LABELS_FIELD_NUMBER = 12;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.ServiceMonitoringProto
                .internal_static_google_monitoring_v3_ServiceLevelObjective_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service-level objective. Label
   * keys must start with a letter. Label keys and values may contain lowercase
   * letters, numbers, underscores, and dashes. Label keys and values have a
   * maximum length of 63 characters, and must be less than 128 bytes in size.
   * Up to 64 label entries may be stored. For labels which do not have a
   * semantic value, the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 12;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }
  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service-level objective. Label
   * keys must start with a letter. Label keys and values may contain lowercase
   * letters, numbers, underscores, and dashes. Label keys and values have a
   * maximum length of 63 characters, and must be less than 128 bytes in size.
   * Up to 64 label entries may be stored. For labels which do not have a
   * semantic value, the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service-level objective. Label
   * keys must start with a letter. Label keys and values may contain lowercase
   * letters, numbers, underscores, and dashes. Label keys and values have a
   * maximum length of 63 characters, and must be less than 128 bytes in size.
   * Up to 64 label entries may be stored. For labels which do not have a
   * semantic value, the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels which have been used to annotate the service-level objective. Label
   * keys must start with a letter. Label keys and values may contain lowercase
   * letters, numbers, underscores, and dashes. Label keys and values have a
   * maximum length of 63 characters, and must be less than 128 bytes in size.
   * Up to 64 label entries may be stored. For labels which do not have a
   * semantic value, the empty string may be supplied for the label value.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 12;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getServiceLevelIndicator());
    }
    if (java.lang.Double.doubleToRawLongBits(goal_) != 0) {
      output.writeDouble(4, goal_);
    }
    if (periodCase_ == 5) {
      output.writeMessage(5, (com.google.protobuf.Duration) period_);
    }
    if (periodCase_ == 6) {
      output.writeEnum(6, ((java.lang.Integer) period_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 12);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getServiceLevelIndicator());
    }
    if (java.lang.Double.doubleToRawLongBits(goal_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, goal_);
    }
    if (periodCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.protobuf.Duration) period_);
    }
    if (periodCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(6, ((java.lang.Integer) period_));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, userLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ServiceLevelObjective)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ServiceLevelObjective other =
        (com.google.monitoring.v3.ServiceLevelObjective) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasServiceLevelIndicator() != other.hasServiceLevelIndicator()) return false;
    if (hasServiceLevelIndicator()) {
      if (!getServiceLevelIndicator().equals(other.getServiceLevelIndicator())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getGoal())
        != java.lang.Double.doubleToLongBits(other.getGoal())) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getPeriodCase().equals(other.getPeriodCase())) return false;
    switch (periodCase_) {
      case 5:
        if (!getRollingPeriod().equals(other.getRollingPeriod())) return false;
        break;
      case 6:
        if (getCalendarPeriodValue() != other.getCalendarPeriodValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasServiceLevelIndicator()) {
      hash = (37 * hash) + SERVICE_LEVEL_INDICATOR_FIELD_NUMBER;
      hash = (53 * hash) + getServiceLevelIndicator().hashCode();
    }
    hash = (37 * hash) + GOAL_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getGoal()));
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    switch (periodCase_) {
      case 5:
        hash = (37 * hash) + ROLLING_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getRollingPeriod().hashCode();
        break;
      case 6:
        hash = (37 * hash) + CALENDAR_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getCalendarPeriodValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelObjective parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.ServiceLevelObjective prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Service-Level Objective (SLO) describes a level of desired good service. It
   * consists of a service-level indicator (SLI), a performance goal, and a period
   * over which the objective is to be evaluated against that goal. The SLO can
   * use SLIs defined in a number of different manners. Typical SLOs might include
   * "99% of requests in each rolling week have latency below 200 milliseconds" or
   * "99.5% of requests in each calendar month return successfully."
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ServiceLevelObjective}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ServiceLevelObjective)
      com.google.monitoring.v3.ServiceLevelObjectiveOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelObjective_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 12:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelObjective_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ServiceLevelObjective.class,
              com.google.monitoring.v3.ServiceLevelObjective.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ServiceLevelObjective.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getServiceLevelIndicatorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      serviceLevelIndicator_ = null;
      if (serviceLevelIndicatorBuilder_ != null) {
        serviceLevelIndicatorBuilder_.dispose();
        serviceLevelIndicatorBuilder_ = null;
      }
      goal_ = 0D;
      if (rollingPeriodBuilder_ != null) {
        rollingPeriodBuilder_.clear();
      }
      internalGetMutableUserLabels().clear();
      periodCase_ = 0;
      period_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelObjective_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelObjective getDefaultInstanceForType() {
      return com.google.monitoring.v3.ServiceLevelObjective.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelObjective build() {
      com.google.monitoring.v3.ServiceLevelObjective result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelObjective buildPartial() {
      com.google.monitoring.v3.ServiceLevelObjective result =
          new com.google.monitoring.v3.ServiceLevelObjective(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.ServiceLevelObjective result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.serviceLevelIndicator_ =
            serviceLevelIndicatorBuilder_ == null
                ? serviceLevelIndicator_
                : serviceLevelIndicatorBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.goal_ = goal_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.monitoring.v3.ServiceLevelObjective result) {
      result.periodCase_ = periodCase_;
      result.period_ = this.period_;
      if (periodCase_ == 5 && rollingPeriodBuilder_ != null) {
        result.period_ = rollingPeriodBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ServiceLevelObjective) {
        return mergeFrom((com.google.monitoring.v3.ServiceLevelObjective) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ServiceLevelObjective other) {
      if (other == com.google.monitoring.v3.ServiceLevelObjective.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasServiceLevelIndicator()) {
        mergeServiceLevelIndicator(other.getServiceLevelIndicator());
      }
      if (other.getGoal() != 0D) {
        setGoal(other.getGoal());
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00000040;
      switch (other.getPeriodCase()) {
        case ROLLING_PERIOD:
          {
            mergeRollingPeriod(other.getRollingPeriod());
            break;
          }
        case CALENDAR_PERIOD:
          {
            setCalendarPeriodValue(other.getCalendarPeriodValue());
            break;
          }
        case PERIOD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getServiceLevelIndicatorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 33:
              {
                goal_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            case 42:
              {
                input.readMessage(getRollingPeriodFieldBuilder().getBuilder(), extensionRegistry);
                periodCase_ = 5;
                break;
              } // case 42
            case 48:
              {
                int rawValue = input.readEnum();
                periodCase_ = 6;
                period_ = rawValue;
                break;
              } // case 48
            case 90:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int periodCase_ = 0;
    private java.lang.Object period_;

    public PeriodCase getPeriodCase() {
      return PeriodCase.forNumber(periodCase_);
    }

    public Builder clearPeriod() {
      periodCase_ = 0;
      period_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name for this `ServiceLevelObjective`. The format is:
     *
     *     projects/[PROJECT_ID_OR_NUMBER]/services/[SERVICE_ID]/serviceLevelObjectives/[SLO_NAME]
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this SLO.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this SLO.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this SLO.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this SLO.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name used for UI elements listing this SLO.
     * </pre>
     *
     * <code>string display_name = 11;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.monitoring.v3.ServiceLevelIndicator serviceLevelIndicator_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.ServiceLevelIndicator,
            com.google.monitoring.v3.ServiceLevelIndicator.Builder,
            com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder>
        serviceLevelIndicatorBuilder_;
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     *
     * @return Whether the serviceLevelIndicator field is set.
     */
    public boolean hasServiceLevelIndicator() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     *
     * @return The serviceLevelIndicator.
     */
    public com.google.monitoring.v3.ServiceLevelIndicator getServiceLevelIndicator() {
      if (serviceLevelIndicatorBuilder_ == null) {
        return serviceLevelIndicator_ == null
            ? com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()
            : serviceLevelIndicator_;
      } else {
        return serviceLevelIndicatorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public Builder setServiceLevelIndicator(com.google.monitoring.v3.ServiceLevelIndicator value) {
      if (serviceLevelIndicatorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceLevelIndicator_ = value;
      } else {
        serviceLevelIndicatorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public Builder setServiceLevelIndicator(
        com.google.monitoring.v3.ServiceLevelIndicator.Builder builderForValue) {
      if (serviceLevelIndicatorBuilder_ == null) {
        serviceLevelIndicator_ = builderForValue.build();
      } else {
        serviceLevelIndicatorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public Builder mergeServiceLevelIndicator(
        com.google.monitoring.v3.ServiceLevelIndicator value) {
      if (serviceLevelIndicatorBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && serviceLevelIndicator_ != null
            && serviceLevelIndicator_
                != com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()) {
          getServiceLevelIndicatorBuilder().mergeFrom(value);
        } else {
          serviceLevelIndicator_ = value;
        }
      } else {
        serviceLevelIndicatorBuilder_.mergeFrom(value);
      }
      if (serviceLevelIndicator_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public Builder clearServiceLevelIndicator() {
      bitField0_ = (bitField0_ & ~0x00000004);
      serviceLevelIndicator_ = null;
      if (serviceLevelIndicatorBuilder_ != null) {
        serviceLevelIndicatorBuilder_.dispose();
        serviceLevelIndicatorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public com.google.monitoring.v3.ServiceLevelIndicator.Builder
        getServiceLevelIndicatorBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getServiceLevelIndicatorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    public com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder
        getServiceLevelIndicatorOrBuilder() {
      if (serviceLevelIndicatorBuilder_ != null) {
        return serviceLevelIndicatorBuilder_.getMessageOrBuilder();
      } else {
        return serviceLevelIndicator_ == null
            ? com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()
            : serviceLevelIndicator_;
      }
    }
    /**
     *
     *
     * <pre>
     * The definition of good service, used to measure and calculate the quality
     * of the `Service`'s performance with respect to a single aspect of service
     * quality.
     * </pre>
     *
     * <code>.google.monitoring.v3.ServiceLevelIndicator service_level_indicator = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.ServiceLevelIndicator,
            com.google.monitoring.v3.ServiceLevelIndicator.Builder,
            com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder>
        getServiceLevelIndicatorFieldBuilder() {
      if (serviceLevelIndicatorBuilder_ == null) {
        serviceLevelIndicatorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.ServiceLevelIndicator,
                com.google.monitoring.v3.ServiceLevelIndicator.Builder,
                com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder>(
                getServiceLevelIndicator(), getParentForChildren(), isClean());
        serviceLevelIndicator_ = null;
      }
      return serviceLevelIndicatorBuilder_;
    }

    private double goal_;
    /**
     *
     *
     * <pre>
     * The fraction of service that must be good in order for this objective to be
     * met. `0 &lt; goal &lt;= 0.999`.
     * </pre>
     *
     * <code>double goal = 4;</code>
     *
     * @return The goal.
     */
    @java.lang.Override
    public double getGoal() {
      return goal_;
    }
    /**
     *
     *
     * <pre>
     * The fraction of service that must be good in order for this objective to be
     * met. `0 &lt; goal &lt;= 0.999`.
     * </pre>
     *
     * <code>double goal = 4;</code>
     *
     * @param value The goal to set.
     * @return This builder for chaining.
     */
    public Builder setGoal(double value) {

      goal_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The fraction of service that must be good in order for this objective to be
     * met. `0 &lt; goal &lt;= 0.999`.
     * </pre>
     *
     * <code>double goal = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoal() {
      bitField0_ = (bitField0_ & ~0x00000008);
      goal_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        rollingPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     *
     * @return Whether the rollingPeriod field is set.
     */
    @java.lang.Override
    public boolean hasRollingPeriod() {
      return periodCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     *
     * @return The rollingPeriod.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRollingPeriod() {
      if (rollingPeriodBuilder_ == null) {
        if (periodCase_ == 5) {
          return (com.google.protobuf.Duration) period_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (periodCase_ == 5) {
          return rollingPeriodBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    public Builder setRollingPeriod(com.google.protobuf.Duration value) {
      if (rollingPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        period_ = value;
        onChanged();
      } else {
        rollingPeriodBuilder_.setMessage(value);
      }
      periodCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    public Builder setRollingPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (rollingPeriodBuilder_ == null) {
        period_ = builderForValue.build();
        onChanged();
      } else {
        rollingPeriodBuilder_.setMessage(builderForValue.build());
      }
      periodCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    public Builder mergeRollingPeriod(com.google.protobuf.Duration value) {
      if (rollingPeriodBuilder_ == null) {
        if (periodCase_ == 5 && period_ != com.google.protobuf.Duration.getDefaultInstance()) {
          period_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) period_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          period_ = value;
        }
        onChanged();
      } else {
        if (periodCase_ == 5) {
          rollingPeriodBuilder_.mergeFrom(value);
        } else {
          rollingPeriodBuilder_.setMessage(value);
        }
      }
      periodCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    public Builder clearRollingPeriod() {
      if (rollingPeriodBuilder_ == null) {
        if (periodCase_ == 5) {
          periodCase_ = 0;
          period_ = null;
          onChanged();
        }
      } else {
        if (periodCase_ == 5) {
          periodCase_ = 0;
          period_ = null;
        }
        rollingPeriodBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getRollingPeriodBuilder() {
      return getRollingPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRollingPeriodOrBuilder() {
      if ((periodCase_ == 5) && (rollingPeriodBuilder_ != null)) {
        return rollingPeriodBuilder_.getMessageOrBuilder();
      } else {
        if (periodCase_ == 5) {
          return (com.google.protobuf.Duration) period_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A rolling time period, semantically "in the past `&lt;rolling_period&gt;`".
     * Must be an integer multiple of 1 day no larger than 30 days.
     * </pre>
     *
     * <code>.google.protobuf.Duration rolling_period = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRollingPeriodFieldBuilder() {
      if (rollingPeriodBuilder_ == null) {
        if (!(periodCase_ == 5)) {
          period_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        rollingPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) period_, getParentForChildren(), isClean());
        period_ = null;
      }
      periodCase_ = 5;
      onChanged();
      return rollingPeriodBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @return Whether the calendarPeriod field is set.
     */
    @java.lang.Override
    public boolean hasCalendarPeriod() {
      return periodCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @return The enum numeric value on the wire for calendarPeriod.
     */
    @java.lang.Override
    public int getCalendarPeriodValue() {
      if (periodCase_ == 6) {
        return ((java.lang.Integer) period_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @param value The enum numeric value on the wire for calendarPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCalendarPeriodValue(int value) {
      periodCase_ = 6;
      period_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @return The calendarPeriod.
     */
    @java.lang.Override
    public com.google.type.CalendarPeriod getCalendarPeriod() {
      if (periodCase_ == 6) {
        com.google.type.CalendarPeriod result =
            com.google.type.CalendarPeriod.forNumber((java.lang.Integer) period_);
        return result == null ? com.google.type.CalendarPeriod.UNRECOGNIZED : result;
      }
      return com.google.type.CalendarPeriod.CALENDAR_PERIOD_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @param value The calendarPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setCalendarPeriod(com.google.type.CalendarPeriod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      periodCase_ = 6;
      period_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A calendar period, semantically "since the start of the current
     * `&lt;calendar_period&gt;`". At this time, only `DAY`, `WEEK`, `FORTNIGHT`, and
     * `MONTH` are supported.
     * </pre>
     *
     * <code>.google.type.CalendarPeriod calendar_period = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCalendarPeriod() {
      if (periodCase_ == 6) {
        periodCase_ = 0;
        period_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }
    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableUserLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels which have been used to annotate the service-level objective. Label
     * keys must start with a letter. Label keys and values may contain lowercase
     * letters, numbers, underscores, and dashes. Label keys and values have a
     * maximum length of 63 characters, and must be less than 128 bytes in size.
     * Up to 64 label entries may be stored. For labels which do not have a
     * semantic value, the empty string may be supplied for the label value.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 12;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ServiceLevelObjective)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ServiceLevelObjective)
  private static final com.google.monitoring.v3.ServiceLevelObjective DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ServiceLevelObjective();
  }

  public static com.google.monitoring.v3.ServiceLevelObjective getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceLevelObjective> PARSER =
      new com.google.protobuf.AbstractParser<ServiceLevelObjective>() {
        @java.lang.Override
        public ServiceLevelObjective parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceLevelObjective> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceLevelObjective> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ServiceLevelObjective getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
