/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/uptime.proto

// Protobuf Java Version: 3.25.5
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * This message configures which resources and services to monitor for
 * availability.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig}
 */
public final class UptimeCheckConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig)
    UptimeCheckConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UptimeCheckConfig.newBuilder() to construct.
  private UptimeCheckConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UptimeCheckConfig() {
    name_ = "";
    displayName_ = "";
    contentMatchers_ = java.util.Collections.emptyList();
    checkerType_ = 0;
    selectedRegions_ = java.util.Collections.emptyList();
    internalCheckers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UptimeCheckConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 20:
        return internalGetUserLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.UptimeProto
        .internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.UptimeCheckConfig.class,
            com.google.monitoring.v3.UptimeCheckConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * What kind of checkers are available to be used by the check.
   * </pre>
   *
   * Protobuf enum {@code google.monitoring.v3.UptimeCheckConfig.CheckerType}
   */
  public enum CheckerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default checker type. Currently converted to `STATIC_IP_CHECKERS`
     * on creation, the default conversion behavior may change in the future.
     * </pre>
     *
     * <code>CHECKER_TYPE_UNSPECIFIED = 0;</code>
     */
    CHECKER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * `STATIC_IP_CHECKERS` are used for uptime checks that perform egress
     * across the public internet. `STATIC_IP_CHECKERS` use the static IP
     * addresses returned by `ListUptimeCheckIps`.
     * </pre>
     *
     * <code>STATIC_IP_CHECKERS = 1;</code>
     */
    STATIC_IP_CHECKERS(1),
    /**
     *
     *
     * <pre>
     * `VPC_CHECKERS` are used for uptime checks that perform egress using
     * Service Directory and private network access. When using `VPC_CHECKERS`,
     * the monitored resource type must be `servicedirectory_service`.
     * </pre>
     *
     * <code>VPC_CHECKERS = 3;</code>
     */
    VPC_CHECKERS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default checker type. Currently converted to `STATIC_IP_CHECKERS`
     * on creation, the default conversion behavior may change in the future.
     * </pre>
     *
     * <code>CHECKER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CHECKER_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * `STATIC_IP_CHECKERS` are used for uptime checks that perform egress
     * across the public internet. `STATIC_IP_CHECKERS` use the static IP
     * addresses returned by `ListUptimeCheckIps`.
     * </pre>
     *
     * <code>STATIC_IP_CHECKERS = 1;</code>
     */
    public static final int STATIC_IP_CHECKERS_VALUE = 1;

    /**
     *
     *
     * <pre>
     * `VPC_CHECKERS` are used for uptime checks that perform egress using
     * Service Directory and private network access. When using `VPC_CHECKERS`,
     * the monitored resource type must be `servicedirectory_service`.
     * </pre>
     *
     * <code>VPC_CHECKERS = 3;</code>
     */
    public static final int VPC_CHECKERS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CheckerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CheckerType forNumber(int value) {
      switch (value) {
        case 0:
          return CHECKER_TYPE_UNSPECIFIED;
        case 1:
          return STATIC_IP_CHECKERS;
        case 3:
          return VPC_CHECKERS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CheckerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CheckerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CheckerType>() {
          public CheckerType findValueByNumber(int number) {
            return CheckerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeCheckConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final CheckerType[] VALUES = values();

    public static CheckerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CheckerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.CheckerType)
  }

  public interface ResourceGroupOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The groupId.
     */
    java.lang.String getGroupId();

    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The bytes for groupId.
     */
    com.google.protobuf.ByteString getGroupIdBytes();

    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    int getResourceTypeValue();

    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    com.google.monitoring.v3.GroupResourceType getResourceType();
  }

  /**
   *
   *
   * <pre>
   * The resource submessage for group checks. It can be used instead of a
   * monitored resource, when multiple resources are being monitored.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ResourceGroup}
   */
  public static final class ResourceGroup extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
      ResourceGroupOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ResourceGroup.newBuilder() to construct.
    private ResourceGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResourceGroup() {
      groupId_ = "";
      resourceType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResourceGroup();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.class,
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder.class);
    }

    public static final int GROUP_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object groupId_ = "";

    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The groupId.
     */
    @java.lang.Override
    public java.lang.String getGroupId() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        groupId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The group of resources being monitored. Should be only the `[GROUP_ID]`,
     * and not the full-path
     * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
     * </pre>
     *
     * <code>string group_id = 1;</code>
     *
     * @return The bytes for groupId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGroupIdBytes() {
      java.lang.Object ref = groupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        groupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOURCE_TYPE_FIELD_NUMBER = 2;
    private int resourceType_ = 0;

    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The enum numeric value on the wire for resourceType.
     */
    @java.lang.Override
    public int getResourceTypeValue() {
      return resourceType_;
    }

    /**
     *
     *
     * <pre>
     * The resource type of the group members.
     * </pre>
     *
     * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
     *
     * @return The resourceType.
     */
    @java.lang.Override
    public com.google.monitoring.v3.GroupResourceType getResourceType() {
      com.google.monitoring.v3.GroupResourceType result =
          com.google.monitoring.v3.GroupResourceType.forNumber(resourceType_);
      return result == null ? com.google.monitoring.v3.GroupResourceType.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, groupId_);
      }
      if (resourceType_
          != com.google.monitoring.v3.GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
        output.writeEnum(2, resourceType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(groupId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, groupId_);
      }
      if (resourceType_
          != com.google.monitoring.v3.GroupResourceType.RESOURCE_TYPE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, resourceType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup other =
          (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) obj;

      if (!getGroupId().equals(other.getGroupId())) return false;
      if (resourceType_ != other.resourceType_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getGroupId().hashCode();
      hash = (37 * hash) + RESOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + resourceType_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The resource submessage for group checks. It can be used instead of a
     * monitored resource, when multiple resources are being monitored.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ResourceGroup}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.class,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        groupId_ = "";
        resourceType_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ResourceGroup_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup build() {
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup result =
            new com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.groupId_ = groupId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.resourceType_ = resourceType_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance())
          return this;
        if (!other.getGroupId().isEmpty()) {
          groupId_ = other.groupId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.resourceType_ != 0) {
          setResourceTypeValue(other.getResourceTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  groupId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  resourceType_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object groupId_ = "";

      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return The groupId.
       */
      public java.lang.String getGroupId() {
        java.lang.Object ref = groupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          groupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return The bytes for groupId.
       */
      public com.google.protobuf.ByteString getGroupIdBytes() {
        java.lang.Object ref = groupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          groupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @param value The groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        groupId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupId() {
        groupId_ = getDefaultInstance().getGroupId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The group of resources being monitored. Should be only the `[GROUP_ID]`,
       * and not the full-path
       * `projects/[PROJECT_ID_OR_NUMBER]/groups/[GROUP_ID]`.
       * </pre>
       *
       * <code>string group_id = 1;</code>
       *
       * @param value The bytes for groupId to set.
       * @return This builder for chaining.
       */
      public Builder setGroupIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        groupId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int resourceType_ = 0;

      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return The enum numeric value on the wire for resourceType.
       */
      @java.lang.Override
      public int getResourceTypeValue() {
        return resourceType_;
      }

      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @param value The enum numeric value on the wire for resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceTypeValue(int value) {
        resourceType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return The resourceType.
       */
      @java.lang.Override
      public com.google.monitoring.v3.GroupResourceType getResourceType() {
        com.google.monitoring.v3.GroupResourceType result =
            com.google.monitoring.v3.GroupResourceType.forNumber(resourceType_);
        return result == null ? com.google.monitoring.v3.GroupResourceType.UNRECOGNIZED : result;
      }

      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @param value The resourceType to set.
       * @return This builder for chaining.
       */
      public Builder setResourceType(com.google.monitoring.v3.GroupResourceType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        resourceType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The resource type of the group members.
       * </pre>
       *
       * <code>.google.monitoring.v3.GroupResourceType resource_type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResourceType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        resourceType_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.ResourceGroup)
    private static final com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResourceGroup> PARSER =
        new com.google.protobuf.AbstractParser<ResourceGroup>() {
          @java.lang.Override
          public ResourceGroup parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResourceGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResourceGroup> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.PingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
     * </pre>
     *
     * <code>int32 pings_count = 1;</code>
     *
     * @return The pingsCount.
     */
    int getPingsCount();
  }

  /**
   *
   *
   * <pre>
   * Information involved in sending ICMP pings alongside public HTTP/TCP
   * checks. For HTTP, the pings are performed for each part of the redirect
   * chain.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.PingConfig}
   */
  public static final class PingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.PingConfig)
      PingConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PingConfig.newBuilder() to construct.
    private PingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.class,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder.class);
    }

    public static final int PINGS_COUNT_FIELD_NUMBER = 1;
    private int pingsCount_ = 0;

    /**
     *
     *
     * <pre>
     * Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
     * </pre>
     *
     * <code>int32 pings_count = 1;</code>
     *
     * @return The pingsCount.
     */
    @java.lang.Override
    public int getPingsCount() {
      return pingsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (pingsCount_ != 0) {
        output.writeInt32(1, pingsCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (pingsCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, pingsCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.PingConfig)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.PingConfig other =
          (com.google.monitoring.v3.UptimeCheckConfig.PingConfig) obj;

      if (getPingsCount() != other.getPingsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PINGS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getPingsCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.PingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information involved in sending ICMP pings alongside public HTTP/TCP
     * checks. For HTTP, the pings are performed for each part of the redirect
     * chain.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.PingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.PingConfig)
        com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.PingConfig.class,
                com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.PingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pingsCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_PingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig build() {
        com.google.monitoring.v3.UptimeCheckConfig.PingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.PingConfig result =
            new com.google.monitoring.v3.UptimeCheckConfig.PingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig.PingConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pingsCount_ = pingsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.PingConfig) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.PingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.PingConfig other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance())
          return this;
        if (other.getPingsCount() != 0) {
          setPingsCount(other.getPingsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  pingsCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int pingsCount_;

      /**
       *
       *
       * <pre>
       * Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
       * </pre>
       *
       * <code>int32 pings_count = 1;</code>
       *
       * @return The pingsCount.
       */
      @java.lang.Override
      public int getPingsCount() {
        return pingsCount_;
      }

      /**
       *
       *
       * <pre>
       * Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
       * </pre>
       *
       * <code>int32 pings_count = 1;</code>
       *
       * @param value The pingsCount to set.
       * @return This builder for chaining.
       */
      public Builder setPingsCount(int value) {

        pingsCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Number of ICMP pings. A maximum of 3 ICMP pings is currently supported.
       * </pre>
       *
       * <code>int32 pings_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPingsCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pingsCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.PingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.PingConfig)
    private static final com.google.monitoring.v3.UptimeCheckConfig.PingConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.PingConfig();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.PingConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PingConfig> PARSER =
        new com.google.protobuf.AbstractParser<PingConfig>() {
          @java.lang.Override
          public PingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HttpCheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for requestMethod.
     */
    int getRequestMethodValue();

    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The requestMethod.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod();

    /**
     *
     *
     * <pre>
     * If `true`, use HTTPS instead of HTTP to run the check.
     * </pre>
     *
     * <code>bool use_ssl = 1;</code>
     *
     * @return The useSsl.
     */
    boolean getUseSsl();

    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();

    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return The port.
     */
    int getPort();

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return Whether the authInfo field is set.
     */
    boolean hasAuthInfo();

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return The authInfo.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication getAuthInfo();

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
        getAuthInfoOrBuilder();

    /**
     *
     *
     * <pre>
     * Boolean specifying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     * </pre>
     *
     * <code>bool mask_headers = 5;</code>
     *
     * @return The maskHeaders.
     */
    boolean getMaskHeaders();

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    int getHeadersCount();

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    boolean containsHeaders(java.lang.String key);

    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getHeaders();

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getHeadersMap();

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    /* nullable */
    java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    java.lang.String getHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    int getContentTypeValue();

    /**
     *
     *
     * <pre>
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The contentType.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType();

    /**
     *
     *
     * <pre>
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     * </pre>
     *
     * <code>string custom_content_type = 13;</code>
     *
     * @return The customContentType.
     */
    java.lang.String getCustomContentType();

    /**
     *
     *
     * <pre>
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     * </pre>
     *
     * <code>string custom_content_type = 13;</code>
     *
     * @return The bytes for customContentType.
     */
    com.google.protobuf.ByteString getCustomContentTypeBytes();

    /**
     *
     *
     * <pre>
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     * </pre>
     *
     * <code>bool validate_ssl = 7;</code>
     *
     * @return The validateSsl.
     */
    boolean getValidateSsl();

    /**
     *
     *
     * <pre>
     * The request body associated with the HTTP POST request. If `content_type`
     * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     * provide a `Content-Length` header via the `headers` field or the API will
     * do so. If the `request_method` is `GET` and `body` is not empty, the API
     * will return an error. The maximum byte size is 1 megabyte.
     *
     * Note: If client libraries aren't used (which performs the conversion
     * automatically) base64 encode your `body` data since the field is of
     * `bytes` type.
     * </pre>
     *
     * <code>bytes body = 10;</code>
     *
     * @return The body.
     */
    com.google.protobuf.ByteString getBody();

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    java.util.List<com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
        getAcceptedResponseStatusCodesList();

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
        getAcceptedResponseStatusCodes(int index);

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    int getAcceptedResponseStatusCodesCount();

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>
        getAcceptedResponseStatusCodesOrBuilderList();

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder
        getAcceptedResponseStatusCodesOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     *
     * @return Whether the pingConfig field is set.
     */
    boolean hasPingConfig();

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     *
     * @return The pingConfig.
     */
    com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig();

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder getPingConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     *
     * @return Whether the serviceAgentAuthentication field is set.
     */
    boolean hasServiceAgentAuthentication();

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     *
     * @return The serviceAgentAuthentication.
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
        getServiceAgentAuthentication();

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthenticationOrBuilder
        getServiceAgentAuthenticationOrBuilder();

    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.AuthMethodCase getAuthMethodCase();
  }

  /**
   *
   *
   * <pre>
   * Information involved in an HTTP/HTTPS Uptime check request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck}
   */
  public static final class HttpCheck extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
      HttpCheckOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use HttpCheck.newBuilder() to construct.
    private HttpCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HttpCheck() {
      requestMethod_ = 0;
      path_ = "";
      contentType_ = 0;
      customContentType_ = "";
      body_ = com.google.protobuf.ByteString.EMPTY;
      acceptedResponseStatusCodes_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HttpCheck();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.class,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The HTTP request method options.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod}
     */
    public enum RequestMethod implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No request method specified.
       * </pre>
       *
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      METHOD_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * GET request.
       * </pre>
       *
       * <code>GET = 1;</code>
       */
      GET(1),
      /**
       *
       *
       * <pre>
       * POST request.
       * </pre>
       *
       * <code>POST = 2;</code>
       */
      POST(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No request method specified.
       * </pre>
       *
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      public static final int METHOD_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * GET request.
       * </pre>
       *
       * <code>GET = 1;</code>
       */
      public static final int GET_VALUE = 1;

      /**
       *
       *
       * <pre>
       * POST request.
       * </pre>
       *
       * <code>POST = 2;</code>
       */
      public static final int POST_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RequestMethod valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RequestMethod forNumber(int value) {
        switch (value) {
          case 0:
            return METHOD_UNSPECIFIED;
          case 1:
            return GET;
          case 2:
            return POST;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RequestMethod> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RequestMethod>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<RequestMethod>() {
                public RequestMethod findValueByNumber(int number) {
                  return RequestMethod.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RequestMethod[] VALUES = values();

      public static RequestMethod valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RequestMethod(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod)
    }

    /**
     *
     *
     * <pre>
     * Header options corresponding to the content type of a HTTP request body.
     * </pre>
     *
     * Protobuf enum {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType}
     */
    public enum ContentType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No content type specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * `body` is in URL-encoded form. Equivalent to setting the `Content-Type`
       * to `application/x-www-form-urlencoded` in the HTTP request.
       * </pre>
       *
       * <code>URL_ENCODED = 1;</code>
       */
      URL_ENCODED(1),
      /**
       *
       *
       * <pre>
       * `body` is in `custom_content_type` form. Equivalent to setting the
       * `Content-Type` to the contents of `custom_content_type` in the HTTP
       * request.
       * </pre>
       *
       * <code>USER_PROVIDED = 2;</code>
       */
      USER_PROVIDED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No content type specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * `body` is in URL-encoded form. Equivalent to setting the `Content-Type`
       * to `application/x-www-form-urlencoded` in the HTTP request.
       * </pre>
       *
       * <code>URL_ENCODED = 1;</code>
       */
      public static final int URL_ENCODED_VALUE = 1;

      /**
       *
       *
       * <pre>
       * `body` is in `custom_content_type` form. Equivalent to setting the
       * `Content-Type` to the contents of `custom_content_type` in the HTTP
       * request.
       * </pre>
       *
       * <code>USER_PROVIDED = 2;</code>
       */
      public static final int USER_PROVIDED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ContentType forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return URL_ENCODED;
          case 2:
            return USER_PROVIDED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ContentType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ContentType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ContentType>() {
            public ContentType findValueByNumber(int number) {
              return ContentType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final ContentType[] VALUES = values();

      public static ContentType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ContentType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType)
    }

    public interface BasicAuthenticationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The username.
       */
      java.lang.String getUsername();

      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The bytes for username.
       */
      com.google.protobuf.ByteString getUsernameBytes();

      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      java.lang.String getPassword();

      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      com.google.protobuf.ByteString getPasswordBytes();
    }

    /**
     *
     *
     * <pre>
     * The authentication parameters to provide to the specified resource or
     * URL that requires a username and password. Currently, only
     * [Basic HTTP authentication](https://tools.ietf.org/html/rfc7617) is
     * supported in Uptime checks.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication}
     */
    public static final class BasicAuthentication extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
        BasicAuthenticationOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use BasicAuthentication.newBuilder() to construct.
      private BasicAuthentication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BasicAuthentication() {
        username_ = "";
        password_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BasicAuthentication();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
                    .class);
      }

      public static final int USERNAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object username_ = "";

      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The username.
       */
      @java.lang.Override
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The username to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string username = 1;</code>
       *
       * @return The bytes for username.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PASSWORD_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object password_ = "";

      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The password.
       */
      @java.lang.Override
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * The password to use when authenticating with the HTTP server.
       * </pre>
       *
       * <code>string password = 2;</code>
       *
       * @return The bytes for password.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, password_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, username_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, password_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication other =
            (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) obj;

        if (!getUsername().equals(other.getUsername())) return false;
        if (!getPassword().equals(other.getPassword())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + USERNAME_FIELD_NUMBER;
        hash = (53 * hash) + getUsername().hashCode();
        hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
        hash = (53 * hash) + getPassword().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * The authentication parameters to provide to the specified resource or
       * URL that requires a username and password. Currently, only
       * [Basic HTTP authentication](https://tools.ietf.org/html/rfc7617) is
       * supported in Uptime checks.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.class,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
                      .class);
        }

        // Construct using
        // com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          username_ = "";
          password_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_BasicAuthentication_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication build() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
            buildPartial() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication result =
              new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.username_ = username_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.password_ = password_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) {
            return mergeFrom(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication other) {
          if (other
              == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()) return this;
          if (!other.getUsername().isEmpty()) {
            username_ = other.username_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getPassword().isEmpty()) {
            password_ = other.password_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    username_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    password_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object username_ = "";

        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return The username.
         */
        public java.lang.String getUsername() {
          java.lang.Object ref = username_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            username_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return The bytes for username.
         */
        public com.google.protobuf.ByteString getUsernameBytes() {
          java.lang.Object ref = username_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            username_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @param value The username to set.
         * @return This builder for chaining.
         */
        public Builder setUsername(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUsername() {
          username_ = getDefaultInstance().getUsername();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The username to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string username = 1;</code>
         *
         * @param value The bytes for username to set.
         * @return This builder for chaining.
         */
        public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          username_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object password_ = "";

        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return The password.
         */
        public java.lang.String getPassword() {
          java.lang.Object ref = password_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            password_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return The bytes for password.
         */
        public com.google.protobuf.ByteString getPasswordBytes() {
          java.lang.Object ref = password_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            password_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @param value The password to set.
         * @return This builder for chaining.
         */
        public Builder setPassword(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearPassword() {
          password_ = getDefaultInstance().getPassword();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The password to use when authenticating with the HTTP server.
         * </pre>
         *
         * <code>string password = 2;</code>
         *
         * @param value The bytes for password to set.
         * @return This builder for chaining.
         */
        public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          password_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication)
      private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication();
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BasicAuthentication> PARSER =
          new com.google.protobuf.AbstractParser<BasicAuthentication>() {
            @java.lang.Override
            public BasicAuthentication parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BasicAuthentication> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BasicAuthentication> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ResponseStatusCodeOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * A status code to accept.
       * </pre>
       *
       * <code>int32 status_value = 1;</code>
       *
       * @return Whether the statusValue field is set.
       */
      boolean hasStatusValue();

      /**
       *
       *
       * <pre>
       * A status code to accept.
       * </pre>
       *
       * <code>int32 status_value = 1;</code>
       *
       * @return The statusValue.
       */
      int getStatusValue();

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return Whether the statusClass field is set.
       */
      boolean hasStatusClass();

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for statusClass.
       */
      int getStatusClassValue();

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return The statusClass.
       */
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
          getStatusClass();

      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusCodeCase
          getStatusCodeCase();
    }

    /**
     *
     *
     * <pre>
     * A status to accept. Either a status code class like "2xx", or an integer
     * status code like "200".
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode}
     */
    public static final class ResponseStatusCode extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)
        ResponseStatusCodeOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ResponseStatusCode.newBuilder() to construct.
      private ResponseStatusCode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ResponseStatusCode() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ResponseStatusCode();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
                    .class);
      }

      /**
       *
       *
       * <pre>
       * An HTTP status code class.
       * </pre>
       *
       * Protobuf enum {@code
       * google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass}
       */
      public enum StatusClass implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value that matches no status codes.
         * </pre>
         *
         * <code>STATUS_CLASS_UNSPECIFIED = 0;</code>
         */
        STATUS_CLASS_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * The class of status codes between 100 and 199.
         * </pre>
         *
         * <code>STATUS_CLASS_1XX = 100;</code>
         */
        STATUS_CLASS_1XX(100),
        /**
         *
         *
         * <pre>
         * The class of status codes between 200 and 299.
         * </pre>
         *
         * <code>STATUS_CLASS_2XX = 200;</code>
         */
        STATUS_CLASS_2XX(200),
        /**
         *
         *
         * <pre>
         * The class of status codes between 300 and 399.
         * </pre>
         *
         * <code>STATUS_CLASS_3XX = 300;</code>
         */
        STATUS_CLASS_3XX(300),
        /**
         *
         *
         * <pre>
         * The class of status codes between 400 and 499.
         * </pre>
         *
         * <code>STATUS_CLASS_4XX = 400;</code>
         */
        STATUS_CLASS_4XX(400),
        /**
         *
         *
         * <pre>
         * The class of status codes between 500 and 599.
         * </pre>
         *
         * <code>STATUS_CLASS_5XX = 500;</code>
         */
        STATUS_CLASS_5XX(500),
        /**
         *
         *
         * <pre>
         * The class of all status codes.
         * </pre>
         *
         * <code>STATUS_CLASS_ANY = 1000;</code>
         */
        STATUS_CLASS_ANY(1000),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value that matches no status codes.
         * </pre>
         *
         * <code>STATUS_CLASS_UNSPECIFIED = 0;</code>
         */
        public static final int STATUS_CLASS_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * The class of status codes between 100 and 199.
         * </pre>
         *
         * <code>STATUS_CLASS_1XX = 100;</code>
         */
        public static final int STATUS_CLASS_1XX_VALUE = 100;

        /**
         *
         *
         * <pre>
         * The class of status codes between 200 and 299.
         * </pre>
         *
         * <code>STATUS_CLASS_2XX = 200;</code>
         */
        public static final int STATUS_CLASS_2XX_VALUE = 200;

        /**
         *
         *
         * <pre>
         * The class of status codes between 300 and 399.
         * </pre>
         *
         * <code>STATUS_CLASS_3XX = 300;</code>
         */
        public static final int STATUS_CLASS_3XX_VALUE = 300;

        /**
         *
         *
         * <pre>
         * The class of status codes between 400 and 499.
         * </pre>
         *
         * <code>STATUS_CLASS_4XX = 400;</code>
         */
        public static final int STATUS_CLASS_4XX_VALUE = 400;

        /**
         *
         *
         * <pre>
         * The class of status codes between 500 and 599.
         * </pre>
         *
         * <code>STATUS_CLASS_5XX = 500;</code>
         */
        public static final int STATUS_CLASS_5XX_VALUE = 500;

        /**
         *
         *
         * <pre>
         * The class of all status codes.
         * </pre>
         *
         * <code>STATUS_CLASS_ANY = 1000;</code>
         */
        public static final int STATUS_CLASS_ANY_VALUE = 1000;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static StatusClass valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static StatusClass forNumber(int value) {
          switch (value) {
            case 0:
              return STATUS_CLASS_UNSPECIFIED;
            case 100:
              return STATUS_CLASS_1XX;
            case 200:
              return STATUS_CLASS_2XX;
            case 300:
              return STATUS_CLASS_3XX;
            case 400:
              return STATUS_CLASS_4XX;
            case 500:
              return STATUS_CLASS_5XX;
            case 1000:
              return STATUS_CLASS_ANY;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<StatusClass> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<StatusClass>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<StatusClass>() {
                  public StatusClass findValueByNumber(int number) {
                    return StatusClass.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final StatusClass[] VALUES = values();

        public static StatusClass valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private StatusClass(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass)
      }

      private int statusCodeCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object statusCode_;

      public enum StatusCodeCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        STATUS_VALUE(1),
        STATUS_CLASS(2),
        STATUSCODE_NOT_SET(0);
        private final int value;

        private StatusCodeCase(int value) {
          this.value = value;
        }

        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static StatusCodeCase valueOf(int value) {
          return forNumber(value);
        }

        public static StatusCodeCase forNumber(int value) {
          switch (value) {
            case 1:
              return STATUS_VALUE;
            case 2:
              return STATUS_CLASS;
            case 0:
              return STATUSCODE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public StatusCodeCase getStatusCodeCase() {
        return StatusCodeCase.forNumber(statusCodeCase_);
      }

      public static final int STATUS_VALUE_FIELD_NUMBER = 1;

      /**
       *
       *
       * <pre>
       * A status code to accept.
       * </pre>
       *
       * <code>int32 status_value = 1;</code>
       *
       * @return Whether the statusValue field is set.
       */
      @java.lang.Override
      public boolean hasStatusValue() {
        return statusCodeCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * A status code to accept.
       * </pre>
       *
       * <code>int32 status_value = 1;</code>
       *
       * @return The statusValue.
       */
      @java.lang.Override
      public int getStatusValue() {
        if (statusCodeCase_ == 1) {
          return (java.lang.Integer) statusCode_;
        }
        return 0;
      }

      public static final int STATUS_CLASS_FIELD_NUMBER = 2;

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return Whether the statusClass field is set.
       */
      public boolean hasStatusClass() {
        return statusCodeCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for statusClass.
       */
      public int getStatusClassValue() {
        if (statusCodeCase_ == 2) {
          return (java.lang.Integer) statusCode_;
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * A class of status codes to accept.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
       * </code>
       *
       * @return The statusClass.
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
          getStatusClass() {
        if (statusCodeCase_ == 2) {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
              result =
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                      .StatusClass.forNumber((java.lang.Integer) statusCode_);
          return result == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
                  .UNRECOGNIZED
              : result;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
            .STATUS_CLASS_UNSPECIFIED;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (statusCodeCase_ == 1) {
          output.writeInt32(1, (int) ((java.lang.Integer) statusCode_));
        }
        if (statusCodeCase_ == 2) {
          output.writeEnum(2, ((java.lang.Integer) statusCode_));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (statusCodeCase_ == 1) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  1, (int) ((java.lang.Integer) statusCode_));
        }
        if (statusCodeCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeEnumSize(
                  2, ((java.lang.Integer) statusCode_));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode other =
            (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode) obj;

        if (!getStatusCodeCase().equals(other.getStatusCodeCase())) return false;
        switch (statusCodeCase_) {
          case 1:
            if (getStatusValue() != other.getStatusValue()) return false;
            break;
          case 2:
            if (getStatusClassValue() != other.getStatusClassValue()) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        switch (statusCodeCase_) {
          case 1:
            hash = (37 * hash) + STATUS_VALUE_FIELD_NUMBER;
            hash = (53 * hash) + getStatusValue();
            break;
          case 2:
            hash = (37 * hash) + STATUS_CLASS_FIELD_NUMBER;
            hash = (53 * hash) + getStatusClassValue();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A status to accept. Either a status code class like "2xx", or an integer
       * status code like "200".
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.class,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
                      .class);
        }

        // Construct using
        // com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          statusCodeCase_ = 0;
          statusCode_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ResponseStatusCode_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode build() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
            buildPartial() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode result =
              new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode result) {
          int from_bitField0_ = bitField0_;
        }

        private void buildPartialOneofs(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode result) {
          result.statusCodeCase_ = statusCodeCase_;
          result.statusCode_ = this.statusCode_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode) {
            return mergeFrom(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode other) {
          if (other
              == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                  .getDefaultInstance()) return this;
          switch (other.getStatusCodeCase()) {
            case STATUS_VALUE:
              {
                setStatusValue(other.getStatusValue());
                break;
              }
            case STATUS_CLASS:
              {
                setStatusClassValue(other.getStatusClassValue());
                break;
              }
            case STATUSCODE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    statusCode_ = input.readInt32();
                    statusCodeCase_ = 1;
                    break;
                  } // case 8
                case 16:
                  {
                    int rawValue = input.readEnum();
                    statusCodeCase_ = 2;
                    statusCode_ = rawValue;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int statusCodeCase_ = 0;
        private java.lang.Object statusCode_;

        public StatusCodeCase getStatusCodeCase() {
          return StatusCodeCase.forNumber(statusCodeCase_);
        }

        public Builder clearStatusCode() {
          statusCodeCase_ = 0;
          statusCode_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        /**
         *
         *
         * <pre>
         * A status code to accept.
         * </pre>
         *
         * <code>int32 status_value = 1;</code>
         *
         * @return Whether the statusValue field is set.
         */
        public boolean hasStatusValue() {
          return statusCodeCase_ == 1;
        }

        /**
         *
         *
         * <pre>
         * A status code to accept.
         * </pre>
         *
         * <code>int32 status_value = 1;</code>
         *
         * @return The statusValue.
         */
        public int getStatusValue() {
          if (statusCodeCase_ == 1) {
            return (java.lang.Integer) statusCode_;
          }
          return 0;
        }

        /**
         *
         *
         * <pre>
         * A status code to accept.
         * </pre>
         *
         * <code>int32 status_value = 1;</code>
         *
         * @param value The statusValue to set.
         * @return This builder for chaining.
         */
        public Builder setStatusValue(int value) {

          statusCodeCase_ = 1;
          statusCode_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A status code to accept.
         * </pre>
         *
         * <code>int32 status_value = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStatusValue() {
          if (statusCodeCase_ == 1) {
            statusCodeCase_ = 0;
            statusCode_ = null;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @return Whether the statusClass field is set.
         */
        @java.lang.Override
        public boolean hasStatusClass() {
          return statusCodeCase_ == 2;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for statusClass.
         */
        @java.lang.Override
        public int getStatusClassValue() {
          if (statusCodeCase_ == 2) {
            return ((java.lang.Integer) statusCode_).intValue();
          }
          return 0;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for statusClass to set.
         * @return This builder for chaining.
         */
        public Builder setStatusClassValue(int value) {
          statusCodeCase_ = 2;
          statusCode_ = value;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @return The statusClass.
         */
        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
            getStatusClass() {
          if (statusCodeCase_ == 2) {
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
                result =
                    com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                        .StatusClass.forNumber((java.lang.Integer) statusCode_);
            return result == null
                ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                    .StatusClass.UNRECOGNIZED
                : result;
          }
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
              .STATUS_CLASS_UNSPECIFIED;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @param value The statusClass to set.
         * @return This builder for chaining.
         */
        public Builder setStatusClass(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          statusCodeCase_ = 2;
          statusCode_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * A class of status codes to accept.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.StatusClass status_class = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearStatusClass() {
          if (statusCodeCase_ == 2) {
            statusCodeCase_ = 0;
            statusCode_ = null;
            onChanged();
          }
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode)
      private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode();
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ResponseStatusCode> PARSER =
          new com.google.protobuf.AbstractParser<ResponseStatusCode>() {
            @java.lang.Override
            public ResponseStatusCode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ResponseStatusCode> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ResponseStatusCode> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ServiceAgentAuthenticationOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Type of authentication.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      int getTypeValue();

      /**
       *
       *
       * <pre>
       * Type of authentication.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
       * </code>
       *
       * @return The type.
       */
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .ServiceAgentAuthenticationType
          getType();
    }

    /**
     *
     *
     * <pre>
     * Contains information needed for generating either an
     * [OpenID Connect
     * token](https://developers.google.com/identity/protocols/OpenIDConnect) or
     * [OAuth token](https://developers.google.com/identity/protocols/oauth2).
     * The token will be generated for the Monitoring service agent service
     * account.
     * </pre>
     *
     * Protobuf type {@code
     * google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication}
     */
    public static final class ServiceAgentAuthentication
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
        ServiceAgentAuthenticationOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ServiceAgentAuthentication.newBuilder() to construct.
      private ServiceAgentAuthentication(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ServiceAgentAuthentication() {
        type_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ServiceAgentAuthentication();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ServiceAgentAuthentication_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ServiceAgentAuthentication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Type of authentication.
       * </pre>
       *
       * Protobuf enum {@code
       * google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType}
       */
      public enum ServiceAgentAuthenticationType
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Default value, will result in OIDC Authentication.
         * </pre>
         *
         * <code>SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED = 0;</code>
         */
        SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * OIDC Authentication
         * </pre>
         *
         * <code>OIDC_TOKEN = 1;</code>
         */
        OIDC_TOKEN(1),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Default value, will result in OIDC Authentication.
         * </pre>
         *
         * <code>SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * OIDC Authentication
         * </pre>
         *
         * <code>OIDC_TOKEN = 1;</code>
         */
        public static final int OIDC_TOKEN_VALUE = 1;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ServiceAgentAuthenticationType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static ServiceAgentAuthenticationType forNumber(int value) {
          switch (value) {
            case 0:
              return SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED;
            case 1:
              return OIDC_TOKEN;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ServiceAgentAuthenticationType>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<
                ServiceAgentAuthenticationType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ServiceAgentAuthenticationType>() {
                  public ServiceAgentAuthenticationType findValueByNumber(int number) {
                    return ServiceAgentAuthenticationType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final ServiceAgentAuthenticationType[] VALUES = values();

        public static ServiceAgentAuthenticationType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ServiceAgentAuthenticationType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType)
      }

      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * Type of authentication.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * Type of authentication.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .ServiceAgentAuthenticationType
          getType() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                .ServiceAgentAuthenticationType
            result =
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .ServiceAgentAuthenticationType.forNumber(type_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                .ServiceAgentAuthenticationType.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (type_
            != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                .ServiceAgentAuthenticationType.SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, type_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (type_
            != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                .ServiceAgentAuthenticationType.SERVICE_AGENT_AUTHENTICATION_TYPE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication other =
            (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication) obj;

        if (type_ != other.type_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed for generating either an
       * [OpenID Connect
       * token](https://developers.google.com/identity/protocols/OpenIDConnect) or
       * [OAuth token](https://developers.google.com/identity/protocols/oauth2).
       * The token will be generated for the Monitoring service agent service
       * account.
       * </pre>
       *
       * Protobuf type {@code
       * google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthenticationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ServiceAgentAuthentication_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ServiceAgentAuthentication_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                      .class,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                      .Builder.class);
        }

        // Construct using
        // com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          type_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_ServiceAgentAuthentication_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
            build() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
            buildPartial() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication result =
              new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.type_ = type_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication) {
            return mergeFrom(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication other) {
          if (other
              == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                  .getDefaultInstance()) return this;
          if (other.type_ != 0) {
            setTypeValue(other.getTypeValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    type_ = input.readEnum();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int type_ = 0;

        /**
         *
         *
         * <pre>
         * Type of authentication.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for type.
         */
        @java.lang.Override
        public int getTypeValue() {
          return type_;
        }

        /**
         *
         *
         * <pre>
         * Type of authentication.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for type to set.
         * @return This builder for chaining.
         */
        public Builder setTypeValue(int value) {
          type_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of authentication.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
         * </code>
         *
         * @return The type.
         */
        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                .ServiceAgentAuthenticationType
            getType() {
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                  .ServiceAgentAuthenticationType
              result =
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                      .ServiceAgentAuthenticationType.forNumber(type_);
          return result == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                  .ServiceAgentAuthenticationType.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * Type of authentication.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
         * </code>
         *
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .ServiceAgentAuthenticationType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          type_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of authentication.
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.ServiceAgentAuthenticationType type = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          type_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
      private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
              .ServiceAgentAuthentication
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication();
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ServiceAgentAuthentication> PARSER =
          new com.google.protobuf.AbstractParser<ServiceAgentAuthentication>() {
            @java.lang.Override
            public ServiceAgentAuthentication parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ServiceAgentAuthentication> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ServiceAgentAuthentication> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int authMethodCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object authMethod_;

    public enum AuthMethodCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SERVICE_AGENT_AUTHENTICATION(14),
      AUTHMETHOD_NOT_SET(0);
      private final int value;

      private AuthMethodCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuthMethodCase valueOf(int value) {
        return forNumber(value);
      }

      public static AuthMethodCase forNumber(int value) {
        switch (value) {
          case 14:
            return SERVICE_AGENT_AUTHENTICATION;
          case 0:
            return AUTHMETHOD_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AuthMethodCase getAuthMethodCase() {
      return AuthMethodCase.forNumber(authMethodCase_);
    }

    public static final int REQUEST_METHOD_FIELD_NUMBER = 8;
    private int requestMethod_ = 0;

    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for requestMethod.
     */
    @java.lang.Override
    public int getRequestMethodValue() {
      return requestMethod_;
    }

    /**
     *
     *
     * <pre>
     * The HTTP request method to use for the check. If set to
     * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
     * </code>
     *
     * @return The requestMethod.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod() {
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod result =
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.forNumber(
              requestMethod_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.UNRECOGNIZED
          : result;
    }

    public static final int USE_SSL_FIELD_NUMBER = 1;
    private boolean useSsl_ = false;

    /**
     *
     *
     * <pre>
     * If `true`, use HTTPS instead of HTTP to run the check.
     * </pre>
     *
     * <code>bool use_ssl = 1;</code>
     *
     * @return The useSsl.
     */
    @java.lang.Override
    public boolean getUseSsl() {
      return useSsl_;
    }

    public static final int PATH_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object path_ = "";

    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional (defaults to "/"). The path to the page against which to run
     * the check. Will be combined with the `host` (specified within the
     * `monitored_resource`) and `port` to construct the full URL. If the
     * provided path does not begin with "/", a "/" will be prepended
     * automatically.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 3;
    private int port_ = 0;

    /**
     *
     *
     * <pre>
     * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
     * `use_ssl` is `true`). The TCP port on the HTTP server against which to
     * run the check. Will be combined with host (specified within the
     * `monitored_resource`) and `path` to construct the full URL.
     * </pre>
     *
     * <code>int32 port = 3;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int AUTH_INFO_FIELD_NUMBER = 4;
    private com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication authInfo_;

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return Whether the authInfo field is set.
     */
    @java.lang.Override
    public boolean hasAuthInfo() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     *
     * @return The authInfo.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication getAuthInfo() {
      return authInfo_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
              .getDefaultInstance()
          : authInfo_;
    }

    /**
     *
     *
     * <pre>
     * The authentication information. Optional when creating an HTTP check;
     * defaults to empty.
     * Do not set both `auth_method` and `auth_info`.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
        getAuthInfoOrBuilder() {
      return authInfo_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
              .getDefaultInstance()
          : authInfo_;
    }

    public static final int MASK_HEADERS_FIELD_NUMBER = 5;
    private boolean maskHeaders_ = false;

    /**
     *
     *
     * <pre>
     * Boolean specifying whether to encrypt the header information.
     * Encryption should be specified for any headers related to authentication
     * that you do not wish to be seen when retrieving the configuration. The
     * server will be responsible for encrypting the headers.
     * On Get/List calls, if `mask_headers` is set to `true` then the headers
     * will be obscured with `******.`
     * </pre>
     *
     * <code>bool mask_headers = 5;</code>
     *
     * @return The maskHeaders.
     */
    @java.lang.Override
    public boolean getMaskHeaders() {
      return maskHeaders_;
    }

    public static final int HEADERS_FIELD_NUMBER = 6;

    private static final class HeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.monitoring.v3.UptimeProto
                  .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_HeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }

    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The list of headers to send as part of the Uptime check request.
     * If two headers have the same key and different values, they should
     * be entered as a single header, with the value being a comma-separated
     * list of all the desired values as described at
     * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
     * Entering two separate headers with the same key in a Create call will
     * cause the first to be overwritten by the second.
     * The maximum number of headers allowed is 100.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int CONTENT_TYPE_FIELD_NUMBER = 9;
    private int contentType_ = 0;

    /**
     *
     *
     * <pre>
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The enum numeric value on the wire for contentType.
     */
    @java.lang.Override
    public int getContentTypeValue() {
      return contentType_;
    }

    /**
     *
     *
     * <pre>
     * The content type header to use for the check. The following
     * configurations result in errors:
     * 1. Content type is specified in both the `headers` field and the
     * `content_type` field.
     * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
     * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
     * 4. Request method is `POST` and a "Content-Type" header is provided via
     * `headers` field. The `content_type` field should be used instead.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;</code>
     *
     * @return The contentType.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType() {
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType result =
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.forNumber(contentType_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.UNRECOGNIZED
          : result;
    }

    public static final int CUSTOM_CONTENT_TYPE_FIELD_NUMBER = 13;

    @SuppressWarnings("serial")
    private volatile java.lang.Object customContentType_ = "";

    /**
     *
     *
     * <pre>
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     * </pre>
     *
     * <code>string custom_content_type = 13;</code>
     *
     * @return The customContentType.
     */
    @java.lang.Override
    public java.lang.String getCustomContentType() {
      java.lang.Object ref = customContentType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customContentType_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * A user provided content type header to use for the check. The invalid
     * configurations outlined in the `content_type` field apply to
     * `custom_content_type`, as well as the following:
     * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
     * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
     * set.
     * </pre>
     *
     * <code>string custom_content_type = 13;</code>
     *
     * @return The bytes for customContentType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getCustomContentTypeBytes() {
      java.lang.Object ref = customContentType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customContentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALIDATE_SSL_FIELD_NUMBER = 7;
    private boolean validateSsl_ = false;

    /**
     *
     *
     * <pre>
     * Boolean specifying whether to include SSL certificate validation as a
     * part of the Uptime check. Only applies to checks where
     * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
     * setting `validate_ssl` to `true` has no effect.
     * </pre>
     *
     * <code>bool validate_ssl = 7;</code>
     *
     * @return The validateSsl.
     */
    @java.lang.Override
    public boolean getValidateSsl() {
      return validateSsl_;
    }

    public static final int BODY_FIELD_NUMBER = 10;
    private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The request body associated with the HTTP POST request. If `content_type`
     * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
     * provide a `Content-Length` header via the `headers` field or the API will
     * do so. If the `request_method` is `GET` and `body` is not empty, the API
     * will return an error. The maximum byte size is 1 megabyte.
     *
     * Note: If client libraries aren't used (which performs the conversion
     * automatically) base64 encode your `body` data since the field is of
     * `bytes` type.
     * </pre>
     *
     * <code>bytes body = 10;</code>
     *
     * @return The body.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }

    public static final int ACCEPTED_RESPONSE_STATUS_CODES_FIELD_NUMBER = 11;

    @SuppressWarnings("serial")
    private java.util.List<com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
        acceptedResponseStatusCodes_;

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
        getAcceptedResponseStatusCodesList() {
      return acceptedResponseStatusCodes_;
    }

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>
        getAcceptedResponseStatusCodesOrBuilderList() {
      return acceptedResponseStatusCodes_;
    }

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    @java.lang.Override
    public int getAcceptedResponseStatusCodesCount() {
      return acceptedResponseStatusCodes_.size();
    }

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
        getAcceptedResponseStatusCodes(int index) {
      return acceptedResponseStatusCodes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * If present, the check will only pass if the HTTP response status code is
     * in this set of status codes. If empty, the HTTP status code will only
     * pass if the HTTP status code is 200-299.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder
        getAcceptedResponseStatusCodesOrBuilder(int index) {
      return acceptedResponseStatusCodes_.get(index);
    }

    public static final int PING_CONFIG_FIELD_NUMBER = 12;
    private com.google.monitoring.v3.UptimeCheckConfig.PingConfig pingConfig_;

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     *
     * @return Whether the pingConfig field is set.
     */
    @java.lang.Override
    public boolean hasPingConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     *
     * @return The pingConfig.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig() {
      return pingConfig_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
          : pingConfig_;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to an HTTP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder getPingConfigOrBuilder() {
      return pingConfig_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
          : pingConfig_;
    }

    public static final int SERVICE_AGENT_AUTHENTICATION_FIELD_NUMBER = 14;

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     *
     * @return Whether the serviceAgentAuthentication field is set.
     */
    @java.lang.Override
    public boolean hasServiceAgentAuthentication() {
      return authMethodCase_ == 14;
    }

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     *
     * @return The serviceAgentAuthentication.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
        getServiceAgentAuthentication() {
      if (authMethodCase_ == 14) {
        return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
            authMethod_;
      }
      return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * If specified, Uptime will generate and attach an OIDC JWT token for the
     * Monitoring service agent service account as an `Authorization` header
     * in the HTTP request when probing.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthenticationOrBuilder
        getServiceAgentAuthenticationOrBuilder() {
      if (authMethodCase_ == 14) {
        return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
            authMethod_;
      }
      return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useSsl_ != false) {
        output.writeBool(1, useSsl_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (port_ != 0) {
        output.writeInt32(3, port_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getAuthInfo());
      }
      if (maskHeaders_ != false) {
        output.writeBool(5, maskHeaders_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 6);
      if (validateSsl_ != false) {
        output.writeBool(7, validateSsl_);
      }
      if (requestMethod_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.METHOD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(8, requestMethod_);
      }
      if (contentType_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, contentType_);
      }
      if (!body_.isEmpty()) {
        output.writeBytes(10, body_);
      }
      for (int i = 0; i < acceptedResponseStatusCodes_.size(); i++) {
        output.writeMessage(11, acceptedResponseStatusCodes_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(12, getPingConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customContentType_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, customContentType_);
      }
      if (authMethodCase_ == 14) {
        output.writeMessage(
            14,
            (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                authMethod_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useSsl_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useSsl_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, port_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAuthInfo());
      }
      if (maskHeaders_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, maskHeaders_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
            HeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, headers__);
      }
      if (validateSsl_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, validateSsl_);
      }
      if (requestMethod_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.METHOD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, requestMethod_);
      }
      if (contentType_
          != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, contentType_);
      }
      if (!body_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(10, body_);
      }
      for (int i = 0; i < acceptedResponseStatusCodes_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                11, acceptedResponseStatusCodes_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getPingConfig());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customContentType_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, customContentType_);
      }
      if (authMethodCase_ == 14) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                14,
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                    authMethod_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.HttpCheck other =
          (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) obj;

      if (requestMethod_ != other.requestMethod_) return false;
      if (getUseSsl() != other.getUseSsl()) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (getPort() != other.getPort()) return false;
      if (hasAuthInfo() != other.hasAuthInfo()) return false;
      if (hasAuthInfo()) {
        if (!getAuthInfo().equals(other.getAuthInfo())) return false;
      }
      if (getMaskHeaders() != other.getMaskHeaders()) return false;
      if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
      if (contentType_ != other.contentType_) return false;
      if (!getCustomContentType().equals(other.getCustomContentType())) return false;
      if (getValidateSsl() != other.getValidateSsl()) return false;
      if (!getBody().equals(other.getBody())) return false;
      if (!getAcceptedResponseStatusCodesList().equals(other.getAcceptedResponseStatusCodesList()))
        return false;
      if (hasPingConfig() != other.hasPingConfig()) return false;
      if (hasPingConfig()) {
        if (!getPingConfig().equals(other.getPingConfig())) return false;
      }
      if (!getAuthMethodCase().equals(other.getAuthMethodCase())) return false;
      switch (authMethodCase_) {
        case 14:
          if (!getServiceAgentAuthentication().equals(other.getServiceAgentAuthentication()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REQUEST_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + requestMethod_;
      hash = (37 * hash) + USE_SSL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseSsl());
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      if (hasAuthInfo()) {
        hash = (37 * hash) + AUTH_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getAuthInfo().hashCode();
      }
      hash = (37 * hash) + MASK_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getMaskHeaders());
      if (!internalGetHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetHeaders().hashCode();
      }
      hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + contentType_;
      hash = (37 * hash) + CUSTOM_CONTENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getCustomContentType().hashCode();
      hash = (37 * hash) + VALIDATE_SSL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateSsl());
      hash = (37 * hash) + BODY_FIELD_NUMBER;
      hash = (53 * hash) + getBody().hashCode();
      if (getAcceptedResponseStatusCodesCount() > 0) {
        hash = (37 * hash) + ACCEPTED_RESPONSE_STATUS_CODES_FIELD_NUMBER;
        hash = (53 * hash) + getAcceptedResponseStatusCodesList().hashCode();
      }
      if (hasPingConfig()) {
        hash = (37 * hash) + PING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPingConfig().hashCode();
      }
      switch (authMethodCase_) {
        case 14:
          hash = (37 * hash) + SERVICE_AGENT_AUTHENTICATION_FIELD_NUMBER;
          hash = (53 * hash) + getServiceAgentAuthentication().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information involved in an HTTP/HTTPS Uptime check request.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.HttpCheck}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 6:
            return internalGetMutableHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.class,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAuthInfoFieldBuilder();
          getAcceptedResponseStatusCodesFieldBuilder();
          getPingConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        requestMethod_ = 0;
        useSsl_ = false;
        path_ = "";
        port_ = 0;
        authInfo_ = null;
        if (authInfoBuilder_ != null) {
          authInfoBuilder_.dispose();
          authInfoBuilder_ = null;
        }
        maskHeaders_ = false;
        internalGetMutableHeaders().clear();
        contentType_ = 0;
        customContentType_ = "";
        validateSsl_ = false;
        body_ = com.google.protobuf.ByteString.EMPTY;
        if (acceptedResponseStatusCodesBuilder_ == null) {
          acceptedResponseStatusCodes_ = java.util.Collections.emptyList();
        } else {
          acceptedResponseStatusCodes_ = null;
          acceptedResponseStatusCodesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000800);
        pingConfig_ = null;
        if (pingConfigBuilder_ != null) {
          pingConfigBuilder_.dispose();
          pingConfigBuilder_ = null;
        }
        if (serviceAgentAuthenticationBuilder_ != null) {
          serviceAgentAuthenticationBuilder_.clear();
        }
        authMethodCase_ = 0;
        authMethod_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_HttpCheck_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck build() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result =
            new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          if (((bitField0_ & 0x00000800) != 0)) {
            acceptedResponseStatusCodes_ =
                java.util.Collections.unmodifiableList(acceptedResponseStatusCodes_);
            bitField0_ = (bitField0_ & ~0x00000800);
          }
          result.acceptedResponseStatusCodes_ = acceptedResponseStatusCodes_;
        } else {
          result.acceptedResponseStatusCodes_ = acceptedResponseStatusCodesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.requestMethod_ = requestMethod_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.useSsl_ = useSsl_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.path_ = path_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.port_ = port_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.authInfo_ = authInfoBuilder_ == null ? authInfo_ : authInfoBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.maskHeaders_ = maskHeaders_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.headers_ = internalGetHeaders();
          result.headers_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.contentType_ = contentType_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.customContentType_ = customContentType_;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.validateSsl_ = validateSsl_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.body_ = body_;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.pingConfig_ =
              pingConfigBuilder_ == null ? pingConfig_ : pingConfigBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck result) {
        result.authMethodCase_ = authMethodCase_;
        result.authMethod_ = this.authMethod_;
        if (authMethodCase_ == 14 && serviceAgentAuthenticationBuilder_ != null) {
          result.authMethod_ = serviceAgentAuthenticationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance())
          return this;
        if (other.requestMethod_ != 0) {
          setRequestMethodValue(other.getRequestMethodValue());
        }
        if (other.getUseSsl() != false) {
          setUseSsl(other.getUseSsl());
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        if (other.hasAuthInfo()) {
          mergeAuthInfo(other.getAuthInfo());
        }
        if (other.getMaskHeaders() != false) {
          setMaskHeaders(other.getMaskHeaders());
        }
        internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
        bitField0_ |= 0x00000040;
        if (other.contentType_ != 0) {
          setContentTypeValue(other.getContentTypeValue());
        }
        if (!other.getCustomContentType().isEmpty()) {
          customContentType_ = other.customContentType_;
          bitField0_ |= 0x00000100;
          onChanged();
        }
        if (other.getValidateSsl() != false) {
          setValidateSsl(other.getValidateSsl());
        }
        if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
          setBody(other.getBody());
        }
        if (acceptedResponseStatusCodesBuilder_ == null) {
          if (!other.acceptedResponseStatusCodes_.isEmpty()) {
            if (acceptedResponseStatusCodes_.isEmpty()) {
              acceptedResponseStatusCodes_ = other.acceptedResponseStatusCodes_;
              bitField0_ = (bitField0_ & ~0x00000800);
            } else {
              ensureAcceptedResponseStatusCodesIsMutable();
              acceptedResponseStatusCodes_.addAll(other.acceptedResponseStatusCodes_);
            }
            onChanged();
          }
        } else {
          if (!other.acceptedResponseStatusCodes_.isEmpty()) {
            if (acceptedResponseStatusCodesBuilder_.isEmpty()) {
              acceptedResponseStatusCodesBuilder_.dispose();
              acceptedResponseStatusCodesBuilder_ = null;
              acceptedResponseStatusCodes_ = other.acceptedResponseStatusCodes_;
              bitField0_ = (bitField0_ & ~0x00000800);
              acceptedResponseStatusCodesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAcceptedResponseStatusCodesFieldBuilder()
                      : null;
            } else {
              acceptedResponseStatusCodesBuilder_.addAllMessages(
                  other.acceptedResponseStatusCodes_);
            }
          }
        }
        if (other.hasPingConfig()) {
          mergePingConfig(other.getPingConfig());
        }
        switch (other.getAuthMethodCase()) {
          case SERVICE_AGENT_AUTHENTICATION:
            {
              mergeServiceAgentAuthentication(other.getServiceAgentAuthentication());
              break;
            }
          case AUTHMETHOD_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  useSsl_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 8
              case 18:
                {
                  path_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 24:
                {
                  port_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 24
              case 34:
                {
                  input.readMessage(getAuthInfoFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 34
              case 40:
                {
                  maskHeaders_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 40
              case 50:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                      input.readMessage(
                          HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableHeaders()
                      .getMutableMap()
                      .put(headers__.getKey(), headers__.getValue());
                  bitField0_ |= 0x00000040;
                  break;
                } // case 50
              case 56:
                {
                  validateSsl_ = input.readBool();
                  bitField0_ |= 0x00000200;
                  break;
                } // case 56
              case 64:
                {
                  requestMethod_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 64
              case 72:
                {
                  contentType_ = input.readEnum();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 72
              case 82:
                {
                  body_ = input.readBytes();
                  bitField0_ |= 0x00000400;
                  break;
                } // case 82
              case 90:
                {
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode m =
                      input.readMessage(
                          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                              .parser(),
                          extensionRegistry);
                  if (acceptedResponseStatusCodesBuilder_ == null) {
                    ensureAcceptedResponseStatusCodesIsMutable();
                    acceptedResponseStatusCodes_.add(m);
                  } else {
                    acceptedResponseStatusCodesBuilder_.addMessage(m);
                  }
                  break;
                } // case 90
              case 98:
                {
                  input.readMessage(getPingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00001000;
                  break;
                } // case 98
              case 106:
                {
                  customContentType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 106
              case 114:
                {
                  input.readMessage(
                      getServiceAgentAuthenticationFieldBuilder().getBuilder(), extensionRegistry);
                  authMethodCase_ = 14;
                  break;
                } // case 114
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int authMethodCase_ = 0;
      private java.lang.Object authMethod_;

      public AuthMethodCase getAuthMethodCase() {
        return AuthMethodCase.forNumber(authMethodCase_);
      }

      public Builder clearAuthMethod() {
        authMethodCase_ = 0;
        authMethod_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private int requestMethod_ = 0;

      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check. If set to
       * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return The enum numeric value on the wire for requestMethod.
       */
      @java.lang.Override
      public int getRequestMethodValue() {
        return requestMethod_;
      }

      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check. If set to
       * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @param value The enum numeric value on the wire for requestMethod to set.
       * @return This builder for chaining.
       */
      public Builder setRequestMethodValue(int value) {
        requestMethod_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check. If set to
       * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return The requestMethod.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod getRequestMethod() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod result =
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.forNumber(
                requestMethod_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check. If set to
       * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @param value The requestMethod to set.
       * @return This builder for chaining.
       */
      public Builder setRequestMethod(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        requestMethod_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The HTTP request method to use for the check. If set to
       * `METHOD_UNSPECIFIED` then `request_method` defaults to `GET`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.RequestMethod request_method = 8;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestMethod() {
        bitField0_ = (bitField0_ & ~0x00000001);
        requestMethod_ = 0;
        onChanged();
        return this;
      }

      private boolean useSsl_;

      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @return The useSsl.
       */
      @java.lang.Override
      public boolean getUseSsl() {
        return useSsl_;
      }

      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @param value The useSsl to set.
       * @return This builder for chaining.
       */
      public Builder setUseSsl(boolean value) {

        useSsl_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * If `true`, use HTTPS instead of HTTP to run the check.
       * </pre>
       *
       * <code>bool use_ssl = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseSsl() {
        bitField0_ = (bitField0_ & ~0x00000002);
        useSsl_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";

      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = getDefaultInstance().getPath();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to "/"). The path to the page against which to run
       * the check. Will be combined with the `host` (specified within the
       * `monitored_resource`) and `port` to construct the full URL. If the
       * provided path does not begin with "/", a "/" will be prepended
       * automatically.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        path_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private int port_;

      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional (defaults to 80 when `use_ssl` is `false`, and 443 when
       * `use_ssl` is `true`). The TCP port on the HTTP server against which to
       * run the check. Will be combined with host (specified within the
       * `monitored_resource`) and `path` to construct the full URL.
       * </pre>
       *
       * <code>int32 port = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000008);
        port_ = 0;
        onChanged();
        return this;
      }

      private com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication authInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder>
          authInfoBuilder_;

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       *
       * @return Whether the authInfo field is set.
       */
      public boolean hasAuthInfo() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       *
       * @return The authInfo.
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
          getAuthInfo() {
        if (authInfoBuilder_ == null) {
          return authInfo_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()
              : authInfo_;
        } else {
          return authInfoBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder setAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication value) {
        if (authInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authInfo_ = value;
        } else {
          authInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder setAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
              builderForValue) {
        if (authInfoBuilder_ == null) {
          authInfo_ = builderForValue.build();
        } else {
          authInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder mergeAuthInfo(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication value) {
        if (authInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && authInfo_ != null
              && authInfo_
                  != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                      .getDefaultInstance()) {
            getAuthInfoBuilder().mergeFrom(value);
          } else {
            authInfo_ = value;
          }
        } else {
          authInfoBuilder_.mergeFrom(value);
        }
        if (authInfo_ != null) {
          bitField0_ |= 0x00000010;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public Builder clearAuthInfo() {
        bitField0_ = (bitField0_ & ~0x00000010);
        authInfo_ = null;
        if (authInfoBuilder_ != null) {
          authInfoBuilder_.dispose();
          authInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder
          getAuthInfoBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getAuthInfoFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder
          getAuthInfoOrBuilder() {
        if (authInfoBuilder_ != null) {
          return authInfoBuilder_.getMessageOrBuilder();
        } else {
          return authInfo_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication
                  .getDefaultInstance()
              : authInfo_;
        }
      }

      /**
       *
       *
       * <pre>
       * The authentication information. Optional when creating an HTTP check;
       * defaults to empty.
       * Do not set both `auth_method` and `auth_info`.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication auth_info = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthenticationOrBuilder>
          getAuthInfoFieldBuilder() {
        if (authInfoBuilder_ == null) {
          authInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.BasicAuthentication.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                      .BasicAuthenticationOrBuilder>(
                  getAuthInfo(), getParentForChildren(), isClean());
          authInfo_ = null;
        }
        return authInfoBuilder_;
      }

      private boolean maskHeaders_;

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @return The maskHeaders.
       */
      @java.lang.Override
      public boolean getMaskHeaders() {
        return maskHeaders_;
      }

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @param value The maskHeaders to set.
       * @return This builder for chaining.
       */
      public Builder setMaskHeaders(boolean value) {

        maskHeaders_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to encrypt the header information.
       * Encryption should be specified for any headers related to authentication
       * that you do not wish to be seen when retrieving the configuration. The
       * server will be responsible for encrypting the headers.
       * On Get/List calls, if `mask_headers` is set to `true` then the headers
       * will be obscured with `******.`
       * </pre>
       *
       * <code>bool mask_headers = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaskHeaders() {
        bitField0_ = (bitField0_ & ~0x00000020);
        maskHeaders_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetHeaders() {
        if (headers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        return headers_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableHeaders() {
        if (headers_ == null) {
          headers_ =
              com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
        }
        if (!headers_.isMutable()) {
          headers_ = headers_.copy();
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return headers_;
      }

      public int getHeadersCount() {
        return internalGetHeaders().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public boolean containsHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetHeaders().getMap().containsKey(key);
      }

      /** Use {@link #getHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
        return getHeadersMap();
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
        return internalGetHeaders().getMap();
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getHeadersOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      @java.lang.Override
      public java.lang.String getHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearHeaders() {
        bitField0_ = (bitField0_ & ~0x00000040);
        internalGetMutableHeaders().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder removeHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableHeaders().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
        bitField0_ |= 0x00000040;
        return internalGetMutableHeaders().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder putHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableHeaders().getMutableMap().put(key, value);
        bitField0_ |= 0x00000040;
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of headers to send as part of the Uptime check request.
       * If two headers have the same key and different values, they should
       * be entered as a single header, with the value being a comma-separated
       * list of all the desired values as described at
       * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31).
       * Entering two separate headers with the same key in a Create call will
       * cause the first to be overwritten by the second.
       * The maximum number of headers allowed is 100.
       * </pre>
       *
       * <code>map&lt;string, string&gt; headers = 6;</code>
       */
      public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableHeaders().getMutableMap().putAll(values);
        bitField0_ |= 0x00000040;
        return this;
      }

      private int contentType_ = 0;

      /**
       *
       *
       * <pre>
       * The content type header to use for the check. The following
       * configurations result in errors:
       * 1. Content type is specified in both the `headers` field and the
       * `content_type` field.
       * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
       * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
       * 4. Request method is `POST` and a "Content-Type" header is provided via
       * `headers` field. The `content_type` field should be used instead.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return The enum numeric value on the wire for contentType.
       */
      @java.lang.Override
      public int getContentTypeValue() {
        return contentType_;
      }

      /**
       *
       *
       * <pre>
       * The content type header to use for the check. The following
       * configurations result in errors:
       * 1. Content type is specified in both the `headers` field and the
       * `content_type` field.
       * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
       * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
       * 4. Request method is `POST` and a "Content-Type" header is provided via
       * `headers` field. The `content_type` field should be used instead.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @param value The enum numeric value on the wire for contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentTypeValue(int value) {
        contentType_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The content type header to use for the check. The following
       * configurations result in errors:
       * 1. Content type is specified in both the `headers` field and the
       * `content_type` field.
       * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
       * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
       * 4. Request method is `POST` and a "Content-Type" header is provided via
       * `headers` field. The `content_type` field should be used instead.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return The contentType.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType getContentType() {
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType result =
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.forNumber(
                contentType_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The content type header to use for the check. The following
       * configurations result in errors:
       * 1. Content type is specified in both the `headers` field and the
       * `content_type` field.
       * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
       * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
       * 4. Request method is `POST` and a "Content-Type" header is provided via
       * `headers` field. The `content_type` field should be used instead.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @param value The contentType to set.
       * @return This builder for chaining.
       */
      public Builder setContentType(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000080;
        contentType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The content type header to use for the check. The following
       * configurations result in errors:
       * 1. Content type is specified in both the `headers` field and the
       * `content_type` field.
       * 2. Request method is `GET` and `content_type` is not `TYPE_UNSPECIFIED`
       * 3. Request method is `POST` and `content_type` is `TYPE_UNSPECIFIED`.
       * 4. Request method is `POST` and a "Content-Type" header is provided via
       * `headers` field. The `content_type` field should be used instead.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ContentType content_type = 9;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContentType() {
        bitField0_ = (bitField0_ & ~0x00000080);
        contentType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object customContentType_ = "";

      /**
       *
       *
       * <pre>
       * A user provided content type header to use for the check. The invalid
       * configurations outlined in the `content_type` field apply to
       * `custom_content_type`, as well as the following:
       * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
       * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
       * set.
       * </pre>
       *
       * <code>string custom_content_type = 13;</code>
       *
       * @return The customContentType.
       */
      public java.lang.String getCustomContentType() {
        java.lang.Object ref = customContentType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          customContentType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A user provided content type header to use for the check. The invalid
       * configurations outlined in the `content_type` field apply to
       * `custom_content_type`, as well as the following:
       * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
       * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
       * set.
       * </pre>
       *
       * <code>string custom_content_type = 13;</code>
       *
       * @return The bytes for customContentType.
       */
      public com.google.protobuf.ByteString getCustomContentTypeBytes() {
        java.lang.Object ref = customContentType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          customContentType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * A user provided content type header to use for the check. The invalid
       * configurations outlined in the `content_type` field apply to
       * `custom_content_type`, as well as the following:
       * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
       * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
       * set.
       * </pre>
       *
       * <code>string custom_content_type = 13;</code>
       *
       * @param value The customContentType to set.
       * @return This builder for chaining.
       */
      public Builder setCustomContentType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        customContentType_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A user provided content type header to use for the check. The invalid
       * configurations outlined in the `content_type` field apply to
       * `custom_content_type`, as well as the following:
       * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
       * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
       * set.
       * </pre>
       *
       * <code>string custom_content_type = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomContentType() {
        customContentType_ = getDefaultInstance().getCustomContentType();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A user provided content type header to use for the check. The invalid
       * configurations outlined in the `content_type` field apply to
       * `custom_content_type`, as well as the following:
       * 1. `content_type` is `URL_ENCODED` and `custom_content_type` is set.
       * 2. `content_type` is `USER_PROVIDED` and `custom_content_type` is not
       * set.
       * </pre>
       *
       * <code>string custom_content_type = 13;</code>
       *
       * @param value The bytes for customContentType to set.
       * @return This builder for chaining.
       */
      public Builder setCustomContentTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        customContentType_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      private boolean validateSsl_;

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @return The validateSsl.
       */
      @java.lang.Override
      public boolean getValidateSsl() {
        return validateSsl_;
      }

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @param value The validateSsl to set.
       * @return This builder for chaining.
       */
      public Builder setValidateSsl(boolean value) {

        validateSsl_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boolean specifying whether to include SSL certificate validation as a
       * part of the Uptime check. Only applies to checks where
       * `monitored_resource` is set to `uptime_url`. If `use_ssl` is `false`,
       * setting `validate_ssl` to `true` has no effect.
       * </pre>
       *
       * <code>bool validate_ssl = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidateSsl() {
        bitField0_ = (bitField0_ & ~0x00000200);
        validateSsl_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP POST request. If `content_type`
       * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
       * provide a `Content-Length` header via the `headers` field or the API will
       * do so. If the `request_method` is `GET` and `body` is not empty, the API
       * will return an error. The maximum byte size is 1 megabyte.
       *
       * Note: If client libraries aren't used (which performs the conversion
       * automatically) base64 encode your `body` data since the field is of
       * `bytes` type.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @return The body.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBody() {
        return body_;
      }

      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP POST request. If `content_type`
       * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
       * provide a `Content-Length` header via the `headers` field or the API will
       * do so. If the `request_method` is `GET` and `body` is not empty, the API
       * will return an error. The maximum byte size is 1 megabyte.
       *
       * Note: If client libraries aren't used (which performs the conversion
       * automatically) base64 encode your `body` data since the field is of
       * `bytes` type.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @param value The body to set.
       * @return This builder for chaining.
       */
      public Builder setBody(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        body_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The request body associated with the HTTP POST request. If `content_type`
       * is `URL_ENCODED`, the body passed in must be URL-encoded. Users can
       * provide a `Content-Length` header via the `headers` field or the API will
       * do so. If the `request_method` is `GET` and `body` is not empty, the API
       * will return an error. The maximum byte size is 1 megabyte.
       *
       * Note: If client libraries aren't used (which performs the conversion
       * automatically) base64 encode your `body` data since the field is of
       * `bytes` type.
       * </pre>
       *
       * <code>bytes body = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBody() {
        bitField0_ = (bitField0_ & ~0x00000400);
        body_ = getDefaultInstance().getBody();
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
          acceptedResponseStatusCodes_ = java.util.Collections.emptyList();

      private void ensureAcceptedResponseStatusCodesIsMutable() {
        if (!((bitField0_ & 0x00000800) != 0)) {
          acceptedResponseStatusCodes_ =
              new java.util.ArrayList<
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>(
                  acceptedResponseStatusCodes_);
          bitField0_ |= 0x00000800;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>
          acceptedResponseStatusCodesBuilder_;

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
          getAcceptedResponseStatusCodesList() {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(acceptedResponseStatusCodes_);
        } else {
          return acceptedResponseStatusCodesBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public int getAcceptedResponseStatusCodesCount() {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          return acceptedResponseStatusCodes_.size();
        } else {
          return acceptedResponseStatusCodesBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
          getAcceptedResponseStatusCodes(int index) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          return acceptedResponseStatusCodes_.get(index);
        } else {
          return acceptedResponseStatusCodesBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder setAcceptedResponseStatusCodes(
          int index,
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode value) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.set(index, value);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder setAcceptedResponseStatusCodes(
          int index,
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
              builderForValue) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.set(index, builderForValue.build());
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder addAcceptedResponseStatusCodes(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode value) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.add(value);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder addAcceptedResponseStatusCodes(
          int index,
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode value) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.add(index, value);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder addAcceptedResponseStatusCodes(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
              builderForValue) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.add(builderForValue.build());
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder addAcceptedResponseStatusCodes(
          int index,
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
              builderForValue) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.add(index, builderForValue.build());
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder addAllAcceptedResponseStatusCodes(
          java.lang.Iterable<
                  ? extends com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode>
              values) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          ensureAcceptedResponseStatusCodesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, acceptedResponseStatusCodes_);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder clearAcceptedResponseStatusCodes() {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          acceptedResponseStatusCodes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000800);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public Builder removeAcceptedResponseStatusCodes(int index) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          ensureAcceptedResponseStatusCodesIsMutable();
          acceptedResponseStatusCodes_.remove(index);
          onChanged();
        } else {
          acceptedResponseStatusCodesBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
          getAcceptedResponseStatusCodesBuilder(int index) {
        return getAcceptedResponseStatusCodesFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder
          getAcceptedResponseStatusCodesOrBuilder(int index) {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          return acceptedResponseStatusCodes_.get(index);
        } else {
          return acceptedResponseStatusCodesBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>
          getAcceptedResponseStatusCodesOrBuilderList() {
        if (acceptedResponseStatusCodesBuilder_ != null) {
          return acceptedResponseStatusCodesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(acceptedResponseStatusCodes_);
        }
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
          addAcceptedResponseStatusCodesBuilder() {
        return getAcceptedResponseStatusCodesFieldBuilder()
            .addBuilder(
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder
          addAcceptedResponseStatusCodesBuilder(int index) {
        return getAcceptedResponseStatusCodesFieldBuilder()
            .addBuilder(
                index,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * If present, the check will only pass if the HTTP response status code is
       * in this set of status codes. If empty, the HTTP status code will only
       * pass if the HTTP status code is 200-299.
       * </pre>
       *
       * <code>
       * repeated .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode accepted_response_status_codes = 11;
       * </code>
       */
      public java.util.List<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder>
          getAcceptedResponseStatusCodesBuilderList() {
        return getAcceptedResponseStatusCodesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>
          getAcceptedResponseStatusCodesFieldBuilder() {
        if (acceptedResponseStatusCodesBuilder_ == null) {
          acceptedResponseStatusCodesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCode.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ResponseStatusCodeOrBuilder>(
                  acceptedResponseStatusCodes_,
                  ((bitField0_ & 0x00000800) != 0),
                  getParentForChildren(),
                  isClean());
          acceptedResponseStatusCodes_ = null;
        }
        return acceptedResponseStatusCodesBuilder_;
      }

      private com.google.monitoring.v3.UptimeCheckConfig.PingConfig pingConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>
          pingConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       *
       * @return Whether the pingConfig field is set.
       */
      public boolean hasPingConfig() {
        return ((bitField0_ & 0x00001000) != 0);
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       *
       * @return The pingConfig.
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig() {
        if (pingConfigBuilder_ == null) {
          return pingConfig_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
              : pingConfig_;
        } else {
          return pingConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public Builder setPingConfig(com.google.monitoring.v3.UptimeCheckConfig.PingConfig value) {
        if (pingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          pingConfig_ = value;
        } else {
          pingConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public Builder setPingConfig(
          com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder builderForValue) {
        if (pingConfigBuilder_ == null) {
          pingConfig_ = builderForValue.build();
        } else {
          pingConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public Builder mergePingConfig(com.google.monitoring.v3.UptimeCheckConfig.PingConfig value) {
        if (pingConfigBuilder_ == null) {
          if (((bitField0_ & 0x00001000) != 0)
              && pingConfig_ != null
              && pingConfig_
                  != com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()) {
            getPingConfigBuilder().mergeFrom(value);
          } else {
            pingConfig_ = value;
          }
        } else {
          pingConfigBuilder_.mergeFrom(value);
        }
        if (pingConfig_ != null) {
          bitField0_ |= 0x00001000;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public Builder clearPingConfig() {
        bitField0_ = (bitField0_ & ~0x00001000);
        pingConfig_ = null;
        if (pingConfigBuilder_ != null) {
          pingConfigBuilder_.dispose();
          pingConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder getPingConfigBuilder() {
        bitField0_ |= 0x00001000;
        onChanged();
        return getPingConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder
          getPingConfigOrBuilder() {
        if (pingConfigBuilder_ != null) {
          return pingConfigBuilder_.getMessageOrBuilder();
        } else {
          return pingConfig_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
              : pingConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to an HTTP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>
          getPingConfigFieldBuilder() {
        if (pingConfigBuilder_ == null) {
          pingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>(
                  getPingConfig(), getParentForChildren(), isClean());
          pingConfig_ = null;
        }
        return pingConfigBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                  .Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                  .ServiceAgentAuthenticationOrBuilder>
          serviceAgentAuthenticationBuilder_;

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       *
       * @return Whether the serviceAgentAuthentication field is set.
       */
      @java.lang.Override
      public boolean hasServiceAgentAuthentication() {
        return authMethodCase_ == 14;
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       *
       * @return The serviceAgentAuthentication.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
          getServiceAgentAuthentication() {
        if (serviceAgentAuthenticationBuilder_ == null) {
          if (authMethodCase_ == 14) {
            return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                authMethod_;
          }
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .getDefaultInstance();
        } else {
          if (authMethodCase_ == 14) {
            return serviceAgentAuthenticationBuilder_.getMessage();
          }
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      public Builder setServiceAgentAuthentication(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication value) {
        if (serviceAgentAuthenticationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          authMethod_ = value;
          onChanged();
        } else {
          serviceAgentAuthenticationBuilder_.setMessage(value);
        }
        authMethodCase_ = 14;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      public Builder setServiceAgentAuthentication(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.Builder
              builderForValue) {
        if (serviceAgentAuthenticationBuilder_ == null) {
          authMethod_ = builderForValue.build();
          onChanged();
        } else {
          serviceAgentAuthenticationBuilder_.setMessage(builderForValue.build());
        }
        authMethodCase_ = 14;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      public Builder mergeServiceAgentAuthentication(
          com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication value) {
        if (serviceAgentAuthenticationBuilder_ == null) {
          if (authMethodCase_ == 14
              && authMethod_
                  != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                      .getDefaultInstance()) {
            authMethod_ =
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .newBuilder(
                        (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                                .ServiceAgentAuthentication)
                            authMethod_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            authMethod_ = value;
          }
          onChanged();
        } else {
          if (authMethodCase_ == 14) {
            serviceAgentAuthenticationBuilder_.mergeFrom(value);
          } else {
            serviceAgentAuthenticationBuilder_.setMessage(value);
          }
        }
        authMethodCase_ = 14;
        return this;
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      public Builder clearServiceAgentAuthentication() {
        if (serviceAgentAuthenticationBuilder_ == null) {
          if (authMethodCase_ == 14) {
            authMethodCase_ = 0;
            authMethod_ = null;
            onChanged();
          }
        } else {
          if (authMethodCase_ == 14) {
            authMethodCase_ = 0;
            authMethod_ = null;
          }
          serviceAgentAuthenticationBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication.Builder
          getServiceAgentAuthenticationBuilder() {
        return getServiceAgentAuthenticationFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
              .ServiceAgentAuthenticationOrBuilder
          getServiceAgentAuthenticationOrBuilder() {
        if ((authMethodCase_ == 14) && (serviceAgentAuthenticationBuilder_ != null)) {
          return serviceAgentAuthenticationBuilder_.getMessageOrBuilder();
        } else {
          if (authMethodCase_ == 14) {
            return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                authMethod_;
          }
          return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * If specified, Uptime will generate and attach an OIDC JWT token for the
       * Monitoring service agent service account as an `Authorization` header
       * in the HTTP request when probing.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication service_agent_authentication = 14;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                  .Builder,
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                  .ServiceAgentAuthenticationOrBuilder>
          getServiceAgentAuthenticationFieldBuilder() {
        if (serviceAgentAuthenticationBuilder_ == null) {
          if (!(authMethodCase_ == 14)) {
            authMethod_ =
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                    .getDefaultInstance();
          }
          serviceAgentAuthenticationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication
                      .Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.HttpCheck
                      .ServiceAgentAuthenticationOrBuilder>(
                  (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.ServiceAgentAuthentication)
                      authMethod_,
                  getParentForChildren(),
                  isClean());
          authMethod_ = null;
        }
        authMethodCase_ = 14;
        onChanged();
        return serviceAgentAuthenticationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.HttpCheck)
    private static final com.google.monitoring.v3.UptimeCheckConfig.HttpCheck DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.HttpCheck();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HttpCheck> PARSER =
        new com.google.protobuf.AbstractParser<HttpCheck>() {
          @java.lang.Override
          public HttpCheck parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HttpCheck> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HttpCheck> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TcpCheckOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The TCP port on the server against which to run the check. Will be
     * combined with host (specified within the `monitored_resource`) to
     * construct the full URL. Required.
     * </pre>
     *
     * <code>int32 port = 1;</code>
     *
     * @return The port.
     */
    int getPort();

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     *
     * @return Whether the pingConfig field is set.
     */
    boolean hasPingConfig();

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     *
     * @return The pingConfig.
     */
    com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig();

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder getPingConfigOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Information required for a TCP Uptime check request.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.TcpCheck}
   */
  public static final class TcpCheck extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
      TcpCheckOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use TcpCheck.newBuilder() to construct.
    private TcpCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TcpCheck() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TcpCheck();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.class,
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder.class);
    }

    private int bitField0_;
    public static final int PORT_FIELD_NUMBER = 1;
    private int port_ = 0;

    /**
     *
     *
     * <pre>
     * The TCP port on the server against which to run the check. Will be
     * combined with host (specified within the `monitored_resource`) to
     * construct the full URL. Required.
     * </pre>
     *
     * <code>int32 port = 1;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int PING_CONFIG_FIELD_NUMBER = 2;
    private com.google.monitoring.v3.UptimeCheckConfig.PingConfig pingConfig_;

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     *
     * @return Whether the pingConfig field is set.
     */
    @java.lang.Override
    public boolean hasPingConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     *
     * @return The pingConfig.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig() {
      return pingConfig_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
          : pingConfig_;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to add pings to a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder getPingConfigOrBuilder() {
      return pingConfig_ == null
          ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
          : pingConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (port_ != 0) {
        output.writeInt32(1, port_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getPingConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, port_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPingConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.TcpCheck)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.TcpCheck other =
          (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) obj;

      if (getPort() != other.getPort()) return false;
      if (hasPingConfig() != other.hasPingConfig()) return false;
      if (hasPingConfig()) {
        if (!getPingConfig().equals(other.getPingConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      if (hasPingConfig()) {
        hash = (37 * hash) + PING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPingConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information required for a TCP Uptime check request.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.TcpCheck}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.class,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPingConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        port_ = 0;
        pingConfig_ = null;
        if (pingConfigBuilder_ != null) {
          pingConfigBuilder_.dispose();
          pingConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_TcpCheck_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck build() {
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck result =
            new com.google.monitoring.v3.UptimeCheckConfig.TcpCheck(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.port_ = port_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pingConfig_ =
              pingConfigBuilder_ == null ? pingConfig_ : pingConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance())
          return this;
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        if (other.hasPingConfig()) {
          mergePingConfig(other.getPingConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  port_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getPingConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int port_;

      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }

      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The TCP port on the server against which to run the check. Will be
       * combined with host (specified within the `monitored_resource`) to
       * construct the full URL. Required.
       * </pre>
       *
       * <code>int32 port = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000001);
        port_ = 0;
        onChanged();
        return this;
      }

      private com.google.monitoring.v3.UptimeCheckConfig.PingConfig pingConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>
          pingConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       *
       * @return Whether the pingConfig field is set.
       */
      public boolean hasPingConfig() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       *
       * @return The pingConfig.
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig getPingConfig() {
        if (pingConfigBuilder_ == null) {
          return pingConfig_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
              : pingConfig_;
        } else {
          return pingConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public Builder setPingConfig(com.google.monitoring.v3.UptimeCheckConfig.PingConfig value) {
        if (pingConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          pingConfig_ = value;
        } else {
          pingConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public Builder setPingConfig(
          com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder builderForValue) {
        if (pingConfigBuilder_ == null) {
          pingConfig_ = builderForValue.build();
        } else {
          pingConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public Builder mergePingConfig(com.google.monitoring.v3.UptimeCheckConfig.PingConfig value) {
        if (pingConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && pingConfig_ != null
              && pingConfig_
                  != com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()) {
            getPingConfigBuilder().mergeFrom(value);
          } else {
            pingConfig_ = value;
          }
        } else {
          pingConfigBuilder_.mergeFrom(value);
        }
        if (pingConfig_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public Builder clearPingConfig() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pingConfig_ = null;
        if (pingConfigBuilder_ != null) {
          pingConfigBuilder_.dispose();
          pingConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder getPingConfigBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPingConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder
          getPingConfigOrBuilder() {
        if (pingConfigBuilder_ != null) {
          return pingConfigBuilder_.getMessageOrBuilder();
        } else {
          return pingConfig_ == null
              ? com.google.monitoring.v3.UptimeCheckConfig.PingConfig.getDefaultInstance()
              : pingConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Contains information needed to add pings to a TCP check.
       * </pre>
       *
       * <code>.google.monitoring.v3.UptimeCheckConfig.PingConfig ping_config = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>
          getPingConfigFieldBuilder() {
        if (pingConfigBuilder_ == null) {
          pingConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfig,
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfig.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.PingConfigOrBuilder>(
                  getPingConfig(), getParentForChildren(), isClean());
          pingConfig_ = null;
        }
        return pingConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.TcpCheck)
    private static final com.google.monitoring.v3.UptimeCheckConfig.TcpCheck DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.TcpCheck();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TcpCheck> PARSER =
        new com.google.protobuf.AbstractParser<TcpCheck>() {
          @java.lang.Override
          public TcpCheck parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TcpCheck> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TcpCheck> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ContentMatcherOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * String, regex or JSON content to match. Maximum 1024 bytes. An empty
     * `content` string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    java.lang.String getContent();

    /**
     *
     *
     * <pre>
     * String, regex or JSON content to match. Maximum 1024 bytes. An empty
     * `content` string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    com.google.protobuf.ByteString getContentBytes();

    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for matcher.
     */
    int getMatcherValue();

    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The matcher.
     */
    com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption getMatcher();

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     *
     * @return Whether the jsonPathMatcher field is set.
     */
    boolean hasJsonPathMatcher();

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     *
     * @return The jsonPathMatcher.
     */
    com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher getJsonPathMatcher();

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     */
    com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder
        getJsonPathMatcherOrBuilder();

    com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.AdditionalMatcherInfoCase
        getAdditionalMatcherInfoCase();
  }

  /**
   *
   *
   * <pre>
   * Optional. Used to perform content matching. This allows matching based on
   * substrings and regular expressions, together with their negations. Only the
   * first 4&amp;nbsp;MB of an HTTP or HTTPS check's response (and the first
   * 1&amp;nbsp;MB of a TCP check's response) are examined for purposes of content
   * matching.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher}
   */
  public static final class ContentMatcher extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
      ContentMatcherOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ContentMatcher.newBuilder() to construct.
    private ContentMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContentMatcher() {
      content_ = "";
      matcher_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContentMatcher();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.class,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Options to perform content matching.
     * </pre>
     *
     * Protobuf enum {@code
     * google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption}
     */
    public enum ContentMatcherOption implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No content matcher type specified (maintained for backward
       * compatibility, but deprecated for future use).
       * Treated as `CONTAINS_STRING`.
       * </pre>
       *
       * <code>CONTENT_MATCHER_OPTION_UNSPECIFIED = 0;</code>
       */
      CONTENT_MATCHER_OPTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Selects substring matching. The match succeeds if the output contains
       * the `content` string.  This is the default value for checks without
       * a `matcher` option, or where the value of `matcher` is
       * `CONTENT_MATCHER_OPTION_UNSPECIFIED`.
       * </pre>
       *
       * <code>CONTAINS_STRING = 1;</code>
       */
      CONTAINS_STRING(1),
      /**
       *
       *
       * <pre>
       * Selects negation of substring matching. The match succeeds if the
       * output does _NOT_ contain the `content` string.
       * </pre>
       *
       * <code>NOT_CONTAINS_STRING = 2;</code>
       */
      NOT_CONTAINS_STRING(2),
      /**
       *
       *
       * <pre>
       * Selects regular-expression matching. The match succeeds if the output
       * matches the regular expression specified in the `content` string.
       * Regex matching is only supported for HTTP/HTTPS checks.
       * </pre>
       *
       * <code>MATCHES_REGEX = 3;</code>
       */
      MATCHES_REGEX(3),
      /**
       *
       *
       * <pre>
       * Selects negation of regular-expression matching. The match succeeds if
       * the output does _NOT_ match the regular expression specified in the
       * `content` string. Regex matching is only supported for HTTP/HTTPS
       * checks.
       * </pre>
       *
       * <code>NOT_MATCHES_REGEX = 4;</code>
       */
      NOT_MATCHES_REGEX(4),
      /**
       *
       *
       * <pre>
       * Selects JSONPath matching. See `JsonPathMatcher` for details on when
       * the match succeeds. JSONPath matching is only supported for HTTP/HTTPS
       * checks.
       * </pre>
       *
       * <code>MATCHES_JSON_PATH = 5;</code>
       */
      MATCHES_JSON_PATH(5),
      /**
       *
       *
       * <pre>
       * Selects JSONPath matching. See `JsonPathMatcher` for details on when
       * the match succeeds. Succeeds when output does _NOT_ match as specified.
       * JSONPath is only supported for HTTP/HTTPS checks.
       * </pre>
       *
       * <code>NOT_MATCHES_JSON_PATH = 6;</code>
       */
      NOT_MATCHES_JSON_PATH(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No content matcher type specified (maintained for backward
       * compatibility, but deprecated for future use).
       * Treated as `CONTAINS_STRING`.
       * </pre>
       *
       * <code>CONTENT_MATCHER_OPTION_UNSPECIFIED = 0;</code>
       */
      public static final int CONTENT_MATCHER_OPTION_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Selects substring matching. The match succeeds if the output contains
       * the `content` string.  This is the default value for checks without
       * a `matcher` option, or where the value of `matcher` is
       * `CONTENT_MATCHER_OPTION_UNSPECIFIED`.
       * </pre>
       *
       * <code>CONTAINS_STRING = 1;</code>
       */
      public static final int CONTAINS_STRING_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Selects negation of substring matching. The match succeeds if the
       * output does _NOT_ contain the `content` string.
       * </pre>
       *
       * <code>NOT_CONTAINS_STRING = 2;</code>
       */
      public static final int NOT_CONTAINS_STRING_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Selects regular-expression matching. The match succeeds if the output
       * matches the regular expression specified in the `content` string.
       * Regex matching is only supported for HTTP/HTTPS checks.
       * </pre>
       *
       * <code>MATCHES_REGEX = 3;</code>
       */
      public static final int MATCHES_REGEX_VALUE = 3;

      /**
       *
       *
       * <pre>
       * Selects negation of regular-expression matching. The match succeeds if
       * the output does _NOT_ match the regular expression specified in the
       * `content` string. Regex matching is only supported for HTTP/HTTPS
       * checks.
       * </pre>
       *
       * <code>NOT_MATCHES_REGEX = 4;</code>
       */
      public static final int NOT_MATCHES_REGEX_VALUE = 4;

      /**
       *
       *
       * <pre>
       * Selects JSONPath matching. See `JsonPathMatcher` for details on when
       * the match succeeds. JSONPath matching is only supported for HTTP/HTTPS
       * checks.
       * </pre>
       *
       * <code>MATCHES_JSON_PATH = 5;</code>
       */
      public static final int MATCHES_JSON_PATH_VALUE = 5;

      /**
       *
       *
       * <pre>
       * Selects JSONPath matching. See `JsonPathMatcher` for details on when
       * the match succeeds. Succeeds when output does _NOT_ match as specified.
       * JSONPath is only supported for HTTP/HTTPS checks.
       * </pre>
       *
       * <code>NOT_MATCHES_JSON_PATH = 6;</code>
       */
      public static final int NOT_MATCHES_JSON_PATH_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentMatcherOption valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ContentMatcherOption forNumber(int value) {
        switch (value) {
          case 0:
            return CONTENT_MATCHER_OPTION_UNSPECIFIED;
          case 1:
            return CONTAINS_STRING;
          case 2:
            return NOT_CONTAINS_STRING;
          case 3:
            return MATCHES_REGEX;
          case 4:
            return NOT_MATCHES_REGEX;
          case 5:
            return MATCHES_JSON_PATH;
          case 6:
            return NOT_MATCHES_JSON_PATH;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ContentMatcherOption>() {
                public ContentMatcherOption findValueByNumber(int number) {
                  return ContentMatcherOption.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ContentMatcherOption[] VALUES = values();

      public static ContentMatcherOption valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ContentMatcherOption(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption)
    }

    public interface JsonPathMatcherOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * JSONPath within the response output pointing to the expected
       * `ContentMatcher::content` to match against.
       * </pre>
       *
       * <code>string json_path = 1;</code>
       *
       * @return The jsonPath.
       */
      java.lang.String getJsonPath();

      /**
       *
       *
       * <pre>
       * JSONPath within the response output pointing to the expected
       * `ContentMatcher::content` to match against.
       * </pre>
       *
       * <code>string json_path = 1;</code>
       *
       * @return The bytes for jsonPath.
       */
      com.google.protobuf.ByteString getJsonPathBytes();

      /**
       *
       *
       * <pre>
       * The type of JSONPath match that will be applied to the JSON output
       * (`ContentMatcher.content`)
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for jsonMatcher.
       */
      int getJsonMatcherValue();

      /**
       *
       *
       * <pre>
       * The type of JSONPath match that will be applied to the JSON output
       * (`ContentMatcher.content`)
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
       * </code>
       *
       * @return The jsonMatcher.
       */
      com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .JsonPathMatcherOption
          getJsonMatcher();
    }

    /**
     *
     *
     * <pre>
     * Information needed to perform a JSONPath content match.
     * Used for `ContentMatcherOption::MATCHES_JSON_PATH` and
     * `ContentMatcherOption::NOT_MATCHES_JSON_PATH`.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher}
     */
    public static final class JsonPathMatcher extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
        JsonPathMatcherOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use JsonPathMatcher.newBuilder() to construct.
      private JsonPathMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private JsonPathMatcher() {
        jsonPath_ = "";
        jsonMatcher_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new JsonPathMatcher();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.class,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder
                    .class);
      }

      /**
       *
       *
       * <pre>
       * Options to perform JSONPath content matching.
       * </pre>
       *
       * Protobuf enum {@code
       * google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption}
       */
      public enum JsonPathMatcherOption implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * No JSONPath matcher type specified (not valid).
         * </pre>
         *
         * <code>JSON_PATH_MATCHER_OPTION_UNSPECIFIED = 0;</code>
         */
        JSON_PATH_MATCHER_OPTION_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * Selects 'exact string' matching. The match succeeds if the content at
         * the `json_path` within the output is exactly the same as the
         * `content` string.
         * </pre>
         *
         * <code>EXACT_MATCH = 1;</code>
         */
        EXACT_MATCH(1),
        /**
         *
         *
         * <pre>
         * Selects regular-expression matching. The match succeeds if the
         * content at the `json_path` within the output matches the regular
         * expression specified in the `content` string.
         * </pre>
         *
         * <code>REGEX_MATCH = 2;</code>
         */
        REGEX_MATCH(2),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * No JSONPath matcher type specified (not valid).
         * </pre>
         *
         * <code>JSON_PATH_MATCHER_OPTION_UNSPECIFIED = 0;</code>
         */
        public static final int JSON_PATH_MATCHER_OPTION_UNSPECIFIED_VALUE = 0;

        /**
         *
         *
         * <pre>
         * Selects 'exact string' matching. The match succeeds if the content at
         * the `json_path` within the output is exactly the same as the
         * `content` string.
         * </pre>
         *
         * <code>EXACT_MATCH = 1;</code>
         */
        public static final int EXACT_MATCH_VALUE = 1;

        /**
         *
         *
         * <pre>
         * Selects regular-expression matching. The match succeeds if the
         * content at the `json_path` within the output matches the regular
         * expression specified in the `content` string.
         * </pre>
         *
         * <code>REGEX_MATCH = 2;</code>
         */
        public static final int REGEX_MATCH_VALUE = 2;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static JsonPathMatcherOption valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static JsonPathMatcherOption forNumber(int value) {
          switch (value) {
            case 0:
              return JSON_PATH_MATCHER_OPTION_UNSPECIFIED;
            case 1:
              return EXACT_MATCH;
            case 2:
              return REGEX_MATCH;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<JsonPathMatcherOption>
            internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<JsonPathMatcherOption>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<JsonPathMatcherOption>() {
                  public JsonPathMatcherOption findValueByNumber(int number) {
                    return JsonPathMatcherOption.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final JsonPathMatcherOption[] VALUES = values();

        public static JsonPathMatcherOption valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private JsonPathMatcherOption(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption)
      }

      public static final int JSON_PATH_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object jsonPath_ = "";

      /**
       *
       *
       * <pre>
       * JSONPath within the response output pointing to the expected
       * `ContentMatcher::content` to match against.
       * </pre>
       *
       * <code>string json_path = 1;</code>
       *
       * @return The jsonPath.
       */
      @java.lang.Override
      public java.lang.String getJsonPath() {
        java.lang.Object ref = jsonPath_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jsonPath_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * JSONPath within the response output pointing to the expected
       * `ContentMatcher::content` to match against.
       * </pre>
       *
       * <code>string json_path = 1;</code>
       *
       * @return The bytes for jsonPath.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getJsonPathBytes() {
        java.lang.Object ref = jsonPath_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jsonPath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int JSON_MATCHER_FIELD_NUMBER = 2;
      private int jsonMatcher_ = 0;

      /**
       *
       *
       * <pre>
       * The type of JSONPath match that will be applied to the JSON output
       * (`ContentMatcher.content`)
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for jsonMatcher.
       */
      @java.lang.Override
      public int getJsonMatcherValue() {
        return jsonMatcher_;
      }

      /**
       *
       *
       * <pre>
       * The type of JSONPath match that will be applied to the JSON output
       * (`ContentMatcher.content`)
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
       * </code>
       *
       * @return The jsonMatcher.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .JsonPathMatcherOption
          getJsonMatcher() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                .JsonPathMatcherOption
            result =
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                    .JsonPathMatcherOption.forNumber(jsonMatcher_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                .JsonPathMatcherOption.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jsonPath_);
        }
        if (jsonMatcher_
            != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                .JsonPathMatcherOption.JSON_PATH_MATCHER_OPTION_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, jsonMatcher_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jsonPath_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jsonPath_);
        }
        if (jsonMatcher_
            != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                .JsonPathMatcherOption.JSON_PATH_MATCHER_OPTION_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, jsonMatcher_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)) {
          return super.equals(obj);
        }
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher other =
            (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher) obj;

        if (!getJsonPath().equals(other.getJsonPath())) return false;
        if (jsonMatcher_ != other.jsonMatcher_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + JSON_PATH_FIELD_NUMBER;
        hash = (53 * hash) + getJsonPath().hashCode();
        hash = (37 * hash) + JSON_MATCHER_FIELD_NUMBER;
        hash = (53 * hash) + jsonMatcher_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Information needed to perform a JSONPath content match.
       * Used for `ContentMatcherOption::MATCHES_JSON_PATH` and
       * `ContentMatcherOption::NOT_MATCHES_JSON_PATH`.
       * </pre>
       *
       * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.class,
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder
                      .class);
        }

        // Construct using
        // com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          jsonPath_ = "";
          jsonMatcher_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.monitoring.v3.UptimeProto
              .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_JsonPathMatcher_descriptor;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
            getDefaultInstanceForType() {
          return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher build() {
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
            buildPartial() {
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher result =
              new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.jsonPath_ = jsonPath_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.jsonMatcher_ = jsonMatcher_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher) {
            return mergeFrom(
                (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher other) {
          if (other
              == com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                  .getDefaultInstance()) return this;
          if (!other.getJsonPath().isEmpty()) {
            jsonPath_ = other.jsonPath_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.jsonMatcher_ != 0) {
            setJsonMatcherValue(other.getJsonMatcherValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    jsonPath_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    jsonMatcher_ = input.readEnum();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object jsonPath_ = "";

        /**
         *
         *
         * <pre>
         * JSONPath within the response output pointing to the expected
         * `ContentMatcher::content` to match against.
         * </pre>
         *
         * <code>string json_path = 1;</code>
         *
         * @return The jsonPath.
         */
        public java.lang.String getJsonPath() {
          java.lang.Object ref = jsonPath_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            jsonPath_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * JSONPath within the response output pointing to the expected
         * `ContentMatcher::content` to match against.
         * </pre>
         *
         * <code>string json_path = 1;</code>
         *
         * @return The bytes for jsonPath.
         */
        public com.google.protobuf.ByteString getJsonPathBytes() {
          java.lang.Object ref = jsonPath_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            jsonPath_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * JSONPath within the response output pointing to the expected
         * `ContentMatcher::content` to match against.
         * </pre>
         *
         * <code>string json_path = 1;</code>
         *
         * @param value The jsonPath to set.
         * @return This builder for chaining.
         */
        public Builder setJsonPath(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          jsonPath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * JSONPath within the response output pointing to the expected
         * `ContentMatcher::content` to match against.
         * </pre>
         *
         * <code>string json_path = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearJsonPath() {
          jsonPath_ = getDefaultInstance().getJsonPath();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * JSONPath within the response output pointing to the expected
         * `ContentMatcher::content` to match against.
         * </pre>
         *
         * <code>string json_path = 1;</code>
         *
         * @param value The bytes for jsonPath to set.
         * @return This builder for chaining.
         */
        public Builder setJsonPathBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          jsonPath_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private int jsonMatcher_ = 0;

        /**
         *
         *
         * <pre>
         * The type of JSONPath match that will be applied to the JSON output
         * (`ContentMatcher.content`)
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
         * </code>
         *
         * @return The enum numeric value on the wire for jsonMatcher.
         */
        @java.lang.Override
        public int getJsonMatcherValue() {
          return jsonMatcher_;
        }

        /**
         *
         *
         * <pre>
         * The type of JSONPath match that will be applied to the JSON output
         * (`ContentMatcher.content`)
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
         * </code>
         *
         * @param value The enum numeric value on the wire for jsonMatcher to set.
         * @return This builder for chaining.
         */
        public Builder setJsonMatcherValue(int value) {
          jsonMatcher_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of JSONPath match that will be applied to the JSON output
         * (`ContentMatcher.content`)
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
         * </code>
         *
         * @return The jsonMatcher.
         */
        @java.lang.Override
        public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                .JsonPathMatcherOption
            getJsonMatcher() {
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                  .JsonPathMatcherOption
              result =
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                      .JsonPathMatcherOption.forNumber(jsonMatcher_);
          return result == null
              ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                  .JsonPathMatcherOption.UNRECOGNIZED
              : result;
        }

        /**
         *
         *
         * <pre>
         * The type of JSONPath match that will be applied to the JSON output
         * (`ContentMatcher.content`)
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
         * </code>
         *
         * @param value The jsonMatcher to set.
         * @return This builder for chaining.
         */
        public Builder setJsonMatcher(
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                    .JsonPathMatcherOption
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000002;
          jsonMatcher_ = value.getNumber();
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The type of JSONPath match that will be applied to the JSON output
         * (`ContentMatcher.content`)
         * </pre>
         *
         * <code>
         * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.JsonPathMatcherOption json_matcher = 2;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearJsonMatcher() {
          bitField0_ = (bitField0_ & ~0x00000002);
          jsonMatcher_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
      }

      // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
      private static final com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher();
      }

      public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<JsonPathMatcher> PARSER =
          new com.google.protobuf.AbstractParser<JsonPathMatcher>() {
            @java.lang.Override
            public JsonPathMatcher parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<JsonPathMatcher> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<JsonPathMatcher> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int additionalMatcherInfoCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object additionalMatcherInfo_;

    public enum AdditionalMatcherInfoCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      JSON_PATH_MATCHER(3),
      ADDITIONALMATCHERINFO_NOT_SET(0);
      private final int value;

      private AdditionalMatcherInfoCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AdditionalMatcherInfoCase valueOf(int value) {
        return forNumber(value);
      }

      public static AdditionalMatcherInfoCase forNumber(int value) {
        switch (value) {
          case 3:
            return JSON_PATH_MATCHER;
          case 0:
            return ADDITIONALMATCHERINFO_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AdditionalMatcherInfoCase getAdditionalMatcherInfoCase() {
      return AdditionalMatcherInfoCase.forNumber(additionalMatcherInfoCase_);
    }

    public static final int CONTENT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object content_ = "";

    /**
     *
     *
     * <pre>
     * String, regex or JSON content to match. Maximum 1024 bytes. An empty
     * `content` string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The content.
     */
    @java.lang.Override
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * String, regex or JSON content to match. Maximum 1024 bytes. An empty
     * `content` string indicates no content matching is to be performed.
     * </pre>
     *
     * <code>string content = 1;</code>
     *
     * @return The bytes for content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MATCHER_FIELD_NUMBER = 2;
    private int matcher_ = 0;

    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for matcher.
     */
    @java.lang.Override
    public int getMatcherValue() {
      return matcher_;
    }

    /**
     *
     *
     * <pre>
     * The type of content matcher that will be applied to the server output,
     * compared to the `content` string when the check is run.
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
     * </code>
     *
     * @return The matcher.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
        getMatcher() {
      com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption result =
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption.forNumber(
              matcher_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .UNRECOGNIZED
          : result;
    }

    public static final int JSON_PATH_MATCHER_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     *
     * @return Whether the jsonPathMatcher field is set.
     */
    @java.lang.Override
    public boolean hasJsonPathMatcher() {
      return additionalMatcherInfoCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     *
     * @return The jsonPathMatcher.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
        getJsonPathMatcher() {
      if (additionalMatcherInfoCase_ == 3) {
        return (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
            additionalMatcherInfo_;
      }
      return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
     * </pre>
     *
     * <code>
     * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder
        getJsonPathMatcherOrBuilder() {
      if (additionalMatcherInfoCase_ == 3) {
        return (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
            additionalMatcherInfo_;
      }
      return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, content_);
      }
      if (matcher_
          != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .CONTENT_MATCHER_OPTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, matcher_);
      }
      if (additionalMatcherInfoCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                additionalMatcherInfo_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(content_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, content_);
      }
      if (matcher_
          != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
              .CONTENT_MATCHER_OPTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, matcher_);
      }
      if (additionalMatcherInfoCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                    additionalMatcherInfo_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher)) {
        return super.equals(obj);
      }
      com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher other =
          (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) obj;

      if (!getContent().equals(other.getContent())) return false;
      if (matcher_ != other.matcher_) return false;
      if (!getAdditionalMatcherInfoCase().equals(other.getAdditionalMatcherInfoCase()))
        return false;
      switch (additionalMatcherInfoCase_) {
        case 3:
          if (!getJsonPathMatcher().equals(other.getJsonPathMatcher())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      hash = (37 * hash) + MATCHER_FIELD_NUMBER;
      hash = (53 * hash) + matcher_;
      switch (additionalMatcherInfoCase_) {
        case 3:
          hash = (37 * hash) + JSON_PATH_MATCHER_FIELD_NUMBER;
          hash = (53 * hash) + getJsonPathMatcher().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Optional. Used to perform content matching. This allows matching based on
     * substrings and regular expressions, together with their negations. Only the
     * first 4&amp;nbsp;MB of an HTTP or HTTPS check's response (and the first
     * 1&amp;nbsp;MB of a TCP check's response) are examined for purposes of content
     * matching.
     * </pre>
     *
     * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig.ContentMatcher}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.class,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder.class);
      }

      // Construct using com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        content_ = "";
        matcher_ = 0;
        if (jsonPathMatcherBuilder_ != null) {
          jsonPathMatcherBuilder_.clear();
        }
        additionalMatcherInfoCase_ = 0;
        additionalMatcherInfo_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.monitoring.v3.UptimeProto
            .internal_static_google_monitoring_v3_UptimeCheckConfig_ContentMatcher_descriptor;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstanceForType() {
        return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher build() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher buildPartial() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result =
            new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.content_ = content_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.matcher_ = matcher_;
        }
      }

      private void buildPartialOneofs(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher result) {
        result.additionalMatcherInfoCase_ = additionalMatcherInfoCase_;
        result.additionalMatcherInfo_ = this.additionalMatcherInfo_;
        if (additionalMatcherInfoCase_ == 3 && jsonPathMatcherBuilder_ != null) {
          result.additionalMatcherInfo_ = jsonPathMatcherBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) {
          return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher other) {
        if (other == com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance())
          return this;
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.matcher_ != 0) {
          setMatcherValue(other.getMatcherValue());
        }
        switch (other.getAdditionalMatcherInfoCase()) {
          case JSON_PATH_MATCHER:
            {
              mergeJsonPathMatcher(other.getJsonPathMatcher());
              break;
            }
          case ADDITIONALMATCHERINFO_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  content_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  matcher_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getJsonPathMatcherFieldBuilder().getBuilder(), extensionRegistry);
                  additionalMatcherInfoCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int additionalMatcherInfoCase_ = 0;
      private java.lang.Object additionalMatcherInfo_;

      public AdditionalMatcherInfoCase getAdditionalMatcherInfoCase() {
        return AdditionalMatcherInfoCase.forNumber(additionalMatcherInfoCase_);
      }

      public Builder clearAdditionalMatcherInfo() {
        additionalMatcherInfoCase_ = 0;
        additionalMatcherInfo_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object content_ = "";

      /**
       *
       *
       * <pre>
       * String, regex or JSON content to match. Maximum 1024 bytes. An empty
       * `content` string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The content.
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * String, regex or JSON content to match. Maximum 1024 bytes. An empty
       * `content` string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return The bytes for content.
       */
      public com.google.protobuf.ByteString getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * String, regex or JSON content to match. Maximum 1024 bytes. An empty
       * `content` string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The content to set.
       * @return This builder for chaining.
       */
      public Builder setContent(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * String, regex or JSON content to match. Maximum 1024 bytes. An empty
       * `content` string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContent() {
        content_ = getDefaultInstance().getContent();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * String, regex or JSON content to match. Maximum 1024 bytes. An empty
       * `content` string indicates no content matching is to be performed.
       * </pre>
       *
       * <code>string content = 1;</code>
       *
       * @param value The bytes for content to set.
       * @return This builder for chaining.
       */
      public Builder setContentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        content_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int matcher_ = 0;

      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for matcher.
       */
      @java.lang.Override
      public int getMatcherValue() {
        return matcher_;
      }

      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for matcher to set.
       * @return This builder for chaining.
       */
      public Builder setMatcherValue(int value) {
        matcher_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return The matcher.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
          getMatcher() {
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption result =
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
                .forNumber(matcher_);
        return result == null
            ? com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @param value The matcher to set.
       * @return This builder for chaining.
       */
      public Builder setMatcher(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        matcher_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The type of content matcher that will be applied to the server output,
       * compared to the `content` string when the check is run.
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.ContentMatcherOption matcher = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatcher() {
        bitField0_ = (bitField0_ & ~0x00000002);
        matcher_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder>
          jsonPathMatcherBuilder_;

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       *
       * @return Whether the jsonPathMatcher field is set.
       */
      @java.lang.Override
      public boolean hasJsonPathMatcher() {
        return additionalMatcherInfoCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       *
       * @return The jsonPathMatcher.
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
          getJsonPathMatcher() {
        if (jsonPathMatcherBuilder_ == null) {
          if (additionalMatcherInfoCase_ == 3) {
            return (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                additionalMatcherInfo_;
          }
          return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .getDefaultInstance();
        } else {
          if (additionalMatcherInfoCase_ == 3) {
            return jsonPathMatcherBuilder_.getMessage();
          }
          return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      public Builder setJsonPathMatcher(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher value) {
        if (jsonPathMatcherBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          additionalMatcherInfo_ = value;
          onChanged();
        } else {
          jsonPathMatcherBuilder_.setMessage(value);
        }
        additionalMatcherInfoCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      public Builder setJsonPathMatcher(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder
              builderForValue) {
        if (jsonPathMatcherBuilder_ == null) {
          additionalMatcherInfo_ = builderForValue.build();
          onChanged();
        } else {
          jsonPathMatcherBuilder_.setMessage(builderForValue.build());
        }
        additionalMatcherInfoCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      public Builder mergeJsonPathMatcher(
          com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher value) {
        if (jsonPathMatcherBuilder_ == null) {
          if (additionalMatcherInfoCase_ == 3
              && additionalMatcherInfo_
                  != com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                      .getDefaultInstance()) {
            additionalMatcherInfo_ =
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                    .newBuilder(
                        (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                            additionalMatcherInfo_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            additionalMatcherInfo_ = value;
          }
          onChanged();
        } else {
          if (additionalMatcherInfoCase_ == 3) {
            jsonPathMatcherBuilder_.mergeFrom(value);
          } else {
            jsonPathMatcherBuilder_.setMessage(value);
          }
        }
        additionalMatcherInfoCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      public Builder clearJsonPathMatcher() {
        if (jsonPathMatcherBuilder_ == null) {
          if (additionalMatcherInfoCase_ == 3) {
            additionalMatcherInfoCase_ = 0;
            additionalMatcherInfo_ = null;
            onChanged();
          }
        } else {
          if (additionalMatcherInfoCase_ == 3) {
            additionalMatcherInfoCase_ = 0;
            additionalMatcherInfo_ = null;
          }
          jsonPathMatcherBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder
          getJsonPathMatcherBuilder() {
        return getJsonPathMatcherFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder
          getJsonPathMatcherOrBuilder() {
        if ((additionalMatcherInfoCase_ == 3) && (jsonPathMatcherBuilder_ != null)) {
          return jsonPathMatcherBuilder_.getMessageOrBuilder();
        } else {
          if (additionalMatcherInfoCase_ == 3) {
            return (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                additionalMatcherInfo_;
          }
          return com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Matcher information for `MATCHES_JSON_PATH` and `NOT_MATCHES_JSON_PATH`
       * </pre>
       *
       * <code>
       * .google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher json_path_matcher = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcherOrBuilder>
          getJsonPathMatcherFieldBuilder() {
        if (jsonPathMatcherBuilder_ == null) {
          if (!(additionalMatcherInfoCase_ == 3)) {
            additionalMatcherInfo_ =
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher
                    .getDefaultInstance();
          }
          jsonPathMatcherBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher,
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher.Builder,
                  com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher
                      .JsonPathMatcherOrBuilder>(
                  (com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.JsonPathMatcher)
                      additionalMatcherInfo_,
                  getParentForChildren(),
                  isClean());
          additionalMatcherInfo_ = null;
        }
        additionalMatcherInfoCase_ = 3;
        onChanged();
        return jsonPathMatcherBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
    }

    // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig.ContentMatcher)
    private static final com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher();
    }

    public static com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContentMatcher> PARSER =
        new com.google.protobuf.AbstractParser<ContentMatcher>() {
          @java.lang.Override
          public ContentMatcher parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ContentMatcher> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContentMatcher> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int resourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object resource_;

  public enum ResourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MONITORED_RESOURCE(3),
    RESOURCE_GROUP(4),
    SYNTHETIC_MONITOR(21),
    RESOURCE_NOT_SET(0);
    private final int value;

    private ResourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResourceCase forNumber(int value) {
      switch (value) {
        case 3:
          return MONITORED_RESOURCE;
        case 4:
          return RESOURCE_GROUP;
        case 21:
          return SYNTHETIC_MONITOR;
        case 0:
          return RESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResourceCase getResourceCase() {
    return ResourceCase.forNumber(resourceCase_);
  }

  private int checkRequestTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object checkRequestType_;

  public enum CheckRequestTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HTTP_CHECK(5),
    TCP_CHECK(6),
    CHECKREQUESTTYPE_NOT_SET(0);
    private final int value;

    private CheckRequestTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CheckRequestTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static CheckRequestTypeCase forNumber(int value) {
      switch (value) {
        case 5:
          return HTTP_CHECK;
        case 6:
          return TCP_CHECK;
        case 0:
          return CHECKREQUESTTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CheckRequestTypeCase getCheckRequestTypeCase() {
    return CheckRequestTypeCase.forNumber(checkRequestTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Identifier. A unique resource name for this Uptime check configuration. The
   * format is:
   *
   *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
   *
   * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
   * Uptime check.
   *
   * This field should be omitted when creating the Uptime check configuration;
   * on create, the resource name is assigned by the server and included in the
   * response.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Identifier. A unique resource name for this Uptime check configuration. The
   * format is:
   *
   *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
   *
   * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
   * Uptime check.
   *
   * This field should be omitted when creating the Uptime check configuration;
   * on create, the resource name is assigned by the server and included in the
   * response.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * A human-friendly name for the Uptime check configuration. The display name
   * should be unique within a Cloud Monitoring Workspace in order to make it
   * easier to identify; however, uniqueness is not enforced. Required.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A human-friendly name for the Uptime check configuration. The display name
   * should be unique within a Cloud Monitoring Workspace in order to make it
   * easier to identify; however, uniqueness is not enforced. Required.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MONITORED_RESOURCE_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are valid for this field:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   *   `k8s_service`
   *   `servicedirectory_service`
   *   `cloud_run_revision`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   *
   * @return Whether the monitoredResource field is set.
   */
  @java.lang.Override
  public boolean hasMonitoredResource() {
    return resourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are valid for this field:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   *   `k8s_service`
   *   `servicedirectory_service`
   *   `cloud_run_revision`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   *
   * @return The monitoredResource.
   */
  @java.lang.Override
  public com.google.api.MonitoredResource getMonitoredResource() {
    if (resourceCase_ == 3) {
      return (com.google.api.MonitoredResource) resource_;
    }
    return com.google.api.MonitoredResource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The [monitored
   * resource](https://cloud.google.com/monitoring/api/resources) associated
   * with the configuration.
   * The following monitored resource types are valid for this field:
   *   `uptime_url`,
   *   `gce_instance`,
   *   `gae_app`,
   *   `aws_ec2_instance`,
   *   `aws_elb_load_balancer`
   *   `k8s_service`
   *   `servicedirectory_service`
   *   `cloud_run_revision`
   * </pre>
   *
   * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
    if (resourceCase_ == 3) {
      return (com.google.api.MonitoredResource) resource_;
    }
    return com.google.api.MonitoredResource.getDefaultInstance();
  }

  public static final int RESOURCE_GROUP_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   *
   * @return Whether the resourceGroup field is set.
   */
  @java.lang.Override
  public boolean hasResourceGroup() {
    return resourceCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   *
   * @return The resourceGroup.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getResourceGroup() {
    if (resourceCase_ == 4) {
      return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The group resource associated with the configuration.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder
      getResourceGroupOrBuilder() {
    if (resourceCase_ == 4) {
      return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
  }

  public static final int SYNTHETIC_MONITOR_FIELD_NUMBER = 21;

  /**
   *
   *
   * <pre>
   * Specifies a Synthetic Monitor to invoke.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
   *
   * @return Whether the syntheticMonitor field is set.
   */
  @java.lang.Override
  public boolean hasSyntheticMonitor() {
    return resourceCase_ == 21;
  }

  /**
   *
   *
   * <pre>
   * Specifies a Synthetic Monitor to invoke.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
   *
   * @return The syntheticMonitor.
   */
  @java.lang.Override
  public com.google.monitoring.v3.SyntheticMonitorTarget getSyntheticMonitor() {
    if (resourceCase_ == 21) {
      return (com.google.monitoring.v3.SyntheticMonitorTarget) resource_;
    }
    return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Specifies a Synthetic Monitor to invoke.
   * </pre>
   *
   * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder getSyntheticMonitorOrBuilder() {
    if (resourceCase_ == 21) {
      return (com.google.monitoring.v3.SyntheticMonitorTarget) resource_;
    }
    return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
  }

  public static final int HTTP_CHECK_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   *
   * @return Whether the httpCheck field is set.
   */
  @java.lang.Override
  public boolean hasHttpCheck() {
    return checkRequestTypeCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   *
   * @return The httpCheck.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getHttpCheck() {
    if (checkRequestTypeCase_ == 5) {
      return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Contains information needed to make an HTTP or HTTPS check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder getHttpCheckOrBuilder() {
    if (checkRequestTypeCase_ == 5) {
      return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
  }

  public static final int TCP_CHECK_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   *
   * @return Whether the tcpCheck field is set.
   */
  @java.lang.Override
  public boolean hasTcpCheck() {
    return checkRequestTypeCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   *
   * @return The tcpCheck.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getTcpCheck() {
    if (checkRequestTypeCase_ == 6) {
      return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Contains information needed to make a TCP check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder getTcpCheckOrBuilder() {
    if (checkRequestTypeCase_ == 6) {
      return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
    }
    return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
  }

  public static final int PERIOD_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration period_;

  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   *
   * @return Whether the period field is set.
   */
  @java.lang.Override
  public boolean hasPeriod() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   *
   * @return The period.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getPeriod() {
    return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
  }

  /**
   *
   *
   * <pre>
   * How often, in seconds, the Uptime check is performed.
   * Currently, the only supported values are `60s` (1 minute), `300s`
   * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
   * defaults to `60s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
    return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
  }

  public static final int TIMEOUT_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration timeout_;

  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  /**
   *
   *
   * <pre>
   * The maximum amount of time to wait for the request to complete (must be
   * between 1 and 60 seconds). Required.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int CONTENT_MATCHERS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
      contentMatchers_;

  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
      getContentMatchersList() {
    return contentMatchers_;
  }

  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
      getContentMatchersOrBuilderList() {
    return contentMatchers_;
  }

  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public int getContentMatchersCount() {
    return contentMatchers_.size();
  }

  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getContentMatchers(int index) {
    return contentMatchers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The content that is expected to appear in the data returned by the target
   * server against which the check is run.  Currently, only the first entry
   * in the `content_matchers` list is supported, and additional entries will
   * be ignored. This field is optional and should only be specified if a
   * content match is required as part of the/ Uptime check.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder
      getContentMatchersOrBuilder(int index) {
    return contentMatchers_.get(index);
  }

  public static final int CHECKER_TYPE_FIELD_NUMBER = 17;
  private int checkerType_ = 0;

  /**
   *
   *
   * <pre>
   * The type of checkers to use to execute the Uptime check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
   *
   * @return The enum numeric value on the wire for checkerType.
   */
  @java.lang.Override
  public int getCheckerTypeValue() {
    return checkerType_;
  }

  /**
   *
   *
   * <pre>
   * The type of checkers to use to execute the Uptime check.
   * </pre>
   *
   * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
   *
   * @return The checkerType.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig.CheckerType getCheckerType() {
    com.google.monitoring.v3.UptimeCheckConfig.CheckerType result =
        com.google.monitoring.v3.UptimeCheckConfig.CheckerType.forNumber(checkerType_);
    return result == null
        ? com.google.monitoring.v3.UptimeCheckConfig.CheckerType.UNRECOGNIZED
        : result;
  }

  public static final int SELECTED_REGIONS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> selectedRegions_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>
      selectedRegions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>() {
            public com.google.monitoring.v3.UptimeCheckRegion convert(java.lang.Integer from) {
              com.google.monitoring.v3.UptimeCheckRegion result =
                  com.google.monitoring.v3.UptimeCheckRegion.forNumber(from);
              return result == null
                  ? com.google.monitoring.v3.UptimeCheckRegion.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return A list containing the selectedRegions.
   */
  @java.lang.Override
  public java.util.List<com.google.monitoring.v3.UptimeCheckRegion> getSelectedRegionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>(
        selectedRegions_, selectedRegions_converter_);
  }

  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return The count of selectedRegions.
   */
  @java.lang.Override
  public int getSelectedRegionsCount() {
    return selectedRegions_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The selectedRegions at the given index.
   */
  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckRegion getSelectedRegions(int index) {
    return selectedRegions_converter_.convert(selectedRegions_.get(index));
  }

  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @return A list containing the enum numeric values on the wire for selectedRegions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getSelectedRegionsValueList() {
    return selectedRegions_;
  }

  /**
   *
   *
   * <pre>
   * The list of regions from which the check will be run.
   * Some regions contain one location, and others contain more than one.
   * If this field is specified, enough regions must be provided to include a
   * minimum of 3 locations.  Not specifying this field will result in Uptime
   * checks running from all available regions.
   * </pre>
   *
   * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of selectedRegions at the given index.
   */
  @java.lang.Override
  public int getSelectedRegionsValue(int index) {
    return selectedRegions_.get(index);
  }

  private int selectedRegionsMemoizedSerializedSize;

  public static final int IS_INTERNAL_FIELD_NUMBER = 15;
  private boolean isInternal_ = false;

  /**
   *
   *
   * <pre>
   * If this is `true`, then checks are made only from the 'internal_checkers'.
   * If it is `false`, then checks are made only from the 'selected_regions'.
   * It is an error to provide 'selected_regions' when is_internal is `true`,
   * or to provide 'internal_checkers' when is_internal is `false`.
   * </pre>
   *
   * <code>bool is_internal = 15 [deprecated = true];</code>
   *
   * @deprecated google.monitoring.v3.UptimeCheckConfig.is_internal is deprecated. See
   *     google/monitoring/v3/uptime.proto;l=547
   * @return The isInternal.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getIsInternal() {
    return isInternal_;
  }

  public static final int INTERNAL_CHECKERS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.monitoring.v3.InternalChecker> internalCheckers_;

  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.monitoring.v3.InternalChecker> getInternalCheckersList() {
    return internalCheckers_;
  }

  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.monitoring.v3.InternalCheckerOrBuilder>
      getInternalCheckersOrBuilderList() {
    return internalCheckers_;
  }

  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getInternalCheckersCount() {
    return internalCheckers_.size();
  }

  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.monitoring.v3.InternalChecker getInternalCheckers(int index) {
    return internalCheckers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The internal checkers that this check will egress from. If `is_internal` is
   * `true` and this list is empty, the check will egress from all the
   * InternalCheckers configured for the project that owns this
   * `UptimeCheckConfig`.
   * </pre>
   *
   * <code>
   * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.monitoring.v3.InternalCheckerOrBuilder getInternalCheckersOrBuilder(int index) {
    return internalCheckers_.get(index);
  }

  public static final int USER_LABELS_FIELD_NUMBER = 20;

  private static final class UserLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.monitoring.v3.UptimeProto
                .internal_static_google_monitoring_v3_UptimeCheckConfig_UserLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetUserLabels() {
    if (userLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(UserLabelsDefaultEntryHolder.defaultEntry);
    }
    return userLabels_;
  }

  public int getUserLabelsCount() {
    return internalGetUserLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `UptimeCheckConfig` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 20;</code>
   */
  @java.lang.Override
  public boolean containsUserLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetUserLabels().getMap().containsKey(key);
  }

  /** Use {@link #getUserLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
    return getUserLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `UptimeCheckConfig` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 20;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
    return internalGetUserLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `UptimeCheckConfig` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 20;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getUserLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * User-supplied key/value data to be used for organizing and
   * identifying the `UptimeCheckConfig` objects.
   *
   * The field can contain up to 64 entries. Each key and value is limited to
   * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
   * values can contain only lowercase letters, numerals, underscores, and
   * dashes. Keys must begin with a letter.
   * </pre>
   *
   * <code>map&lt;string, string&gt; user_labels = 20;</code>
   */
  @java.lang.Override
  public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (resourceCase_ == 3) {
      output.writeMessage(3, (com.google.api.MonitoredResource) resource_);
    }
    if (resourceCase_ == 4) {
      output.writeMessage(4, (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_);
    }
    if (checkRequestTypeCase_ == 5) {
      output.writeMessage(
          5, (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_);
    }
    if (checkRequestTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getPeriod());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getTimeout());
    }
    for (int i = 0; i < contentMatchers_.size(); i++) {
      output.writeMessage(9, contentMatchers_.get(i));
    }
    if (getSelectedRegionsList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(selectedRegionsMemoizedSerializedSize);
    }
    for (int i = 0; i < selectedRegions_.size(); i++) {
      output.writeEnumNoTag(selectedRegions_.get(i));
    }
    for (int i = 0; i < internalCheckers_.size(); i++) {
      output.writeMessage(14, internalCheckers_.get(i));
    }
    if (isInternal_ != false) {
      output.writeBool(15, isInternal_);
    }
    if (checkerType_
        != com.google.monitoring.v3.UptimeCheckConfig.CheckerType.CHECKER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(17, checkerType_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetUserLabels(), UserLabelsDefaultEntryHolder.defaultEntry, 20);
    if (resourceCase_ == 21) {
      output.writeMessage(21, (com.google.monitoring.v3.SyntheticMonitorTarget) resource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (resourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.api.MonitoredResource) resource_);
    }
    if (resourceCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_);
    }
    if (checkRequestTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_);
    }
    if (checkRequestTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPeriod());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTimeout());
    }
    for (int i = 0; i < contentMatchers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, contentMatchers_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < selectedRegions_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(selectedRegions_.get(i));
      }
      size += dataSize;
      if (!getSelectedRegionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      selectedRegionsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < internalCheckers_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, internalCheckers_.get(i));
    }
    if (isInternal_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, isInternal_);
    }
    if (checkerType_
        != com.google.monitoring.v3.UptimeCheckConfig.CheckerType.CHECKER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(17, checkerType_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetUserLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
          UserLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, userLabels__);
    }
    if (resourceCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.monitoring.v3.SyntheticMonitorTarget) resource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.UptimeCheckConfig)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.UptimeCheckConfig other =
        (com.google.monitoring.v3.UptimeCheckConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasPeriod() != other.hasPeriod()) return false;
    if (hasPeriod()) {
      if (!getPeriod().equals(other.getPeriod())) return false;
    }
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (!getContentMatchersList().equals(other.getContentMatchersList())) return false;
    if (checkerType_ != other.checkerType_) return false;
    if (!selectedRegions_.equals(other.selectedRegions_)) return false;
    if (getIsInternal() != other.getIsInternal()) return false;
    if (!getInternalCheckersList().equals(other.getInternalCheckersList())) return false;
    if (!internalGetUserLabels().equals(other.internalGetUserLabels())) return false;
    if (!getResourceCase().equals(other.getResourceCase())) return false;
    switch (resourceCase_) {
      case 3:
        if (!getMonitoredResource().equals(other.getMonitoredResource())) return false;
        break;
      case 4:
        if (!getResourceGroup().equals(other.getResourceGroup())) return false;
        break;
      case 21:
        if (!getSyntheticMonitor().equals(other.getSyntheticMonitor())) return false;
        break;
      case 0:
      default:
    }
    if (!getCheckRequestTypeCase().equals(other.getCheckRequestTypeCase())) return false;
    switch (checkRequestTypeCase_) {
      case 5:
        if (!getHttpCheck().equals(other.getHttpCheck())) return false;
        break;
      case 6:
        if (!getTcpCheck().equals(other.getTcpCheck())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasPeriod()) {
      hash = (37 * hash) + PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getPeriod().hashCode();
    }
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    if (getContentMatchersCount() > 0) {
      hash = (37 * hash) + CONTENT_MATCHERS_FIELD_NUMBER;
      hash = (53 * hash) + getContentMatchersList().hashCode();
    }
    hash = (37 * hash) + CHECKER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + checkerType_;
    if (getSelectedRegionsCount() > 0) {
      hash = (37 * hash) + SELECTED_REGIONS_FIELD_NUMBER;
      hash = (53 * hash) + selectedRegions_.hashCode();
    }
    hash = (37 * hash) + IS_INTERNAL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsInternal());
    if (getInternalCheckersCount() > 0) {
      hash = (37 * hash) + INTERNAL_CHECKERS_FIELD_NUMBER;
      hash = (53 * hash) + getInternalCheckersList().hashCode();
    }
    if (!internalGetUserLabels().getMap().isEmpty()) {
      hash = (37 * hash) + USER_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetUserLabels().hashCode();
    }
    switch (resourceCase_) {
      case 3:
        hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getMonitoredResource().hashCode();
        break;
      case 4:
        hash = (37 * hash) + RESOURCE_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getResourceGroup().hashCode();
        break;
      case 21:
        hash = (37 * hash) + SYNTHETIC_MONITOR_FIELD_NUMBER;
        hash = (53 * hash) + getSyntheticMonitor().hashCode();
        break;
      case 0:
      default:
    }
    switch (checkRequestTypeCase_) {
      case 5:
        hash = (37 * hash) + HTTP_CHECK_FIELD_NUMBER;
        hash = (53 * hash) + getHttpCheck().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TCP_CHECK_FIELD_NUMBER;
        hash = (53 * hash) + getTcpCheck().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UptimeCheckConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.UptimeCheckConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * This message configures which resources and services to monitor for
   * availability.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UptimeCheckConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UptimeCheckConfig)
      com.google.monitoring.v3.UptimeCheckConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 20:
          return internalGetUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 20:
          return internalGetMutableUserLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UptimeCheckConfig.class,
              com.google.monitoring.v3.UptimeCheckConfig.Builder.class);
    }

    // Construct using com.google.monitoring.v3.UptimeCheckConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPeriodFieldBuilder();
        getTimeoutFieldBuilder();
        getContentMatchersFieldBuilder();
        getInternalCheckersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (monitoredResourceBuilder_ != null) {
        monitoredResourceBuilder_.clear();
      }
      if (resourceGroupBuilder_ != null) {
        resourceGroupBuilder_.clear();
      }
      if (syntheticMonitorBuilder_ != null) {
        syntheticMonitorBuilder_.clear();
      }
      if (httpCheckBuilder_ != null) {
        httpCheckBuilder_.clear();
      }
      if (tcpCheckBuilder_ != null) {
        tcpCheckBuilder_.clear();
      }
      period_ = null;
      if (periodBuilder_ != null) {
        periodBuilder_.dispose();
        periodBuilder_ = null;
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      if (contentMatchersBuilder_ == null) {
        contentMatchers_ = java.util.Collections.emptyList();
      } else {
        contentMatchers_ = null;
        contentMatchersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      checkerType_ = 0;
      selectedRegions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      isInternal_ = false;
      if (internalCheckersBuilder_ == null) {
        internalCheckers_ = java.util.Collections.emptyList();
      } else {
        internalCheckers_ = null;
        internalCheckersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      internalGetMutableUserLabels().clear();
      resourceCase_ = 0;
      resource_ = null;
      checkRequestTypeCase_ = 0;
      checkRequestType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.UptimeProto
          .internal_static_google_monitoring_v3_UptimeCheckConfig_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig getDefaultInstanceForType() {
      return com.google.monitoring.v3.UptimeCheckConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig build() {
      com.google.monitoring.v3.UptimeCheckConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig buildPartial() {
      com.google.monitoring.v3.UptimeCheckConfig result =
          new com.google.monitoring.v3.UptimeCheckConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.monitoring.v3.UptimeCheckConfig result) {
      if (contentMatchersBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          contentMatchers_ = java.util.Collections.unmodifiableList(contentMatchers_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.contentMatchers_ = contentMatchers_;
      } else {
        result.contentMatchers_ = contentMatchersBuilder_.build();
      }
      if (((bitField0_ & 0x00000800) != 0)) {
        selectedRegions_ = java.util.Collections.unmodifiableList(selectedRegions_);
        bitField0_ = (bitField0_ & ~0x00000800);
      }
      result.selectedRegions_ = selectedRegions_;
      if (internalCheckersBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          internalCheckers_ = java.util.Collections.unmodifiableList(internalCheckers_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.internalCheckers_ = internalCheckers_;
      } else {
        result.internalCheckers_ = internalCheckersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.monitoring.v3.UptimeCheckConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.period_ = periodBuilder_ == null ? period_ : periodBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.checkerType_ = checkerType_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.isInternal_ = isInternal_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.userLabels_ = internalGetUserLabels();
        result.userLabels_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.monitoring.v3.UptimeCheckConfig result) {
      result.resourceCase_ = resourceCase_;
      result.resource_ = this.resource_;
      if (resourceCase_ == 3 && monitoredResourceBuilder_ != null) {
        result.resource_ = monitoredResourceBuilder_.build();
      }
      if (resourceCase_ == 4 && resourceGroupBuilder_ != null) {
        result.resource_ = resourceGroupBuilder_.build();
      }
      if (resourceCase_ == 21 && syntheticMonitorBuilder_ != null) {
        result.resource_ = syntheticMonitorBuilder_.build();
      }
      result.checkRequestTypeCase_ = checkRequestTypeCase_;
      result.checkRequestType_ = this.checkRequestType_;
      if (checkRequestTypeCase_ == 5 && httpCheckBuilder_ != null) {
        result.checkRequestType_ = httpCheckBuilder_.build();
      }
      if (checkRequestTypeCase_ == 6 && tcpCheckBuilder_ != null) {
        result.checkRequestType_ = tcpCheckBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.UptimeCheckConfig) {
        return mergeFrom((com.google.monitoring.v3.UptimeCheckConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.UptimeCheckConfig other) {
      if (other == com.google.monitoring.v3.UptimeCheckConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPeriod()) {
        mergePeriod(other.getPeriod());
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (contentMatchersBuilder_ == null) {
        if (!other.contentMatchers_.isEmpty()) {
          if (contentMatchers_.isEmpty()) {
            contentMatchers_ = other.contentMatchers_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureContentMatchersIsMutable();
            contentMatchers_.addAll(other.contentMatchers_);
          }
          onChanged();
        }
      } else {
        if (!other.contentMatchers_.isEmpty()) {
          if (contentMatchersBuilder_.isEmpty()) {
            contentMatchersBuilder_.dispose();
            contentMatchersBuilder_ = null;
            contentMatchers_ = other.contentMatchers_;
            bitField0_ = (bitField0_ & ~0x00000200);
            contentMatchersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentMatchersFieldBuilder()
                    : null;
          } else {
            contentMatchersBuilder_.addAllMessages(other.contentMatchers_);
          }
        }
      }
      if (other.checkerType_ != 0) {
        setCheckerTypeValue(other.getCheckerTypeValue());
      }
      if (!other.selectedRegions_.isEmpty()) {
        if (selectedRegions_.isEmpty()) {
          selectedRegions_ = other.selectedRegions_;
          bitField0_ = (bitField0_ & ~0x00000800);
        } else {
          ensureSelectedRegionsIsMutable();
          selectedRegions_.addAll(other.selectedRegions_);
        }
        onChanged();
      }
      if (other.getIsInternal() != false) {
        setIsInternal(other.getIsInternal());
      }
      if (internalCheckersBuilder_ == null) {
        if (!other.internalCheckers_.isEmpty()) {
          if (internalCheckers_.isEmpty()) {
            internalCheckers_ = other.internalCheckers_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureInternalCheckersIsMutable();
            internalCheckers_.addAll(other.internalCheckers_);
          }
          onChanged();
        }
      } else {
        if (!other.internalCheckers_.isEmpty()) {
          if (internalCheckersBuilder_.isEmpty()) {
            internalCheckersBuilder_.dispose();
            internalCheckersBuilder_ = null;
            internalCheckers_ = other.internalCheckers_;
            bitField0_ = (bitField0_ & ~0x00002000);
            internalCheckersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInternalCheckersFieldBuilder()
                    : null;
          } else {
            internalCheckersBuilder_.addAllMessages(other.internalCheckers_);
          }
        }
      }
      internalGetMutableUserLabels().mergeFrom(other.internalGetUserLabels());
      bitField0_ |= 0x00004000;
      switch (other.getResourceCase()) {
        case MONITORED_RESOURCE:
          {
            mergeMonitoredResource(other.getMonitoredResource());
            break;
          }
        case RESOURCE_GROUP:
          {
            mergeResourceGroup(other.getResourceGroup());
            break;
          }
        case SYNTHETIC_MONITOR:
          {
            mergeSyntheticMonitor(other.getSyntheticMonitor());
            break;
          }
        case RESOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getCheckRequestTypeCase()) {
        case HTTP_CHECK:
          {
            mergeHttpCheck(other.getHttpCheck());
            break;
          }
        case TCP_CHECK:
          {
            mergeTcpCheck(other.getTcpCheck());
            break;
          }
        case CHECKREQUESTTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getMonitoredResourceFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getResourceGroupFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getHttpCheckFieldBuilder().getBuilder(), extensionRegistry);
                checkRequestTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTcpCheckFieldBuilder().getBuilder(), extensionRegistry);
                checkRequestTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher m =
                    input.readMessage(
                        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.parser(),
                        extensionRegistry);
                if (contentMatchersBuilder_ == null) {
                  ensureContentMatchersIsMutable();
                  contentMatchers_.add(m);
                } else {
                  contentMatchersBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureSelectedRegionsIsMutable();
                selectedRegions_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureSelectedRegionsIsMutable();
                  selectedRegions_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 114:
              {
                com.google.monitoring.v3.InternalChecker m =
                    input.readMessage(
                        com.google.monitoring.v3.InternalChecker.parser(), extensionRegistry);
                if (internalCheckersBuilder_ == null) {
                  ensureInternalCheckersIsMutable();
                  internalCheckers_.add(m);
                } else {
                  internalCheckersBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 120:
              {
                isInternal_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 120
            case 136:
              {
                checkerType_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 136
            case 162:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> userLabels__ =
                    input.readMessage(
                        UserLabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableUserLabels()
                    .getMutableMap()
                    .put(userLabels__.getKey(), userLabels__.getValue());
                bitField0_ |= 0x00004000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(
                    getSyntheticMonitorFieldBuilder().getBuilder(), extensionRegistry);
                resourceCase_ = 21;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resourceCase_ = 0;
    private java.lang.Object resource_;

    public ResourceCase getResourceCase() {
      return ResourceCase.forNumber(resourceCase_);
    }

    public Builder clearResource() {
      resourceCase_ = 0;
      resource_ = null;
      onChanged();
      return this;
    }

    private int checkRequestTypeCase_ = 0;
    private java.lang.Object checkRequestType_;

    public CheckRequestTypeCase getCheckRequestTypeCase() {
      return CheckRequestTypeCase.forNumber(checkRequestTypeCase_);
    }

    public Builder clearCheckRequestType() {
      checkRequestTypeCase_ = 0;
      checkRequestType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     *
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     *
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     *
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     *
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Identifier. A unique resource name for this Uptime check configuration. The
     * format is:
     *
     *      projects/[PROJECT_ID_OR_NUMBER]/uptimeCheckConfigs/[UPTIME_CHECK_ID]
     *
     * `[PROJECT_ID_OR_NUMBER]` is the Workspace host project associated with the
     * Uptime check.
     *
     * This field should be omitted when creating the Uptime check configuration;
     * on create, the resource name is assigned by the server and included in the
     * response.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A human-friendly name for the Uptime check configuration. The display name
     * should be unique within a Cloud Monitoring Workspace in order to make it
     * easier to identify; however, uniqueness is not enforced. Required.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        monitoredResourceBuilder_;

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     *
     * @return Whether the monitoredResource field is set.
     */
    @java.lang.Override
    public boolean hasMonitoredResource() {
      return resourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     *
     * @return The monitoredResource.
     */
    @java.lang.Override
    public com.google.api.MonitoredResource getMonitoredResource() {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3) {
          return (com.google.api.MonitoredResource) resource_;
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      } else {
        if (resourceCase_ == 3) {
          return monitoredResourceBuilder_.getMessage();
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder setMonitoredResource(com.google.api.MonitoredResource value) {
      if (monitoredResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        monitoredResourceBuilder_.setMessage(value);
      }
      resourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder setMonitoredResource(com.google.api.MonitoredResource.Builder builderForValue) {
      if (monitoredResourceBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        monitoredResourceBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder mergeMonitoredResource(com.google.api.MonitoredResource value) {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3
            && resource_ != com.google.api.MonitoredResource.getDefaultInstance()) {
          resource_ =
              com.google.api.MonitoredResource.newBuilder(
                      (com.google.api.MonitoredResource) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 3) {
          monitoredResourceBuilder_.mergeFrom(value);
        } else {
          monitoredResourceBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public Builder clearMonitoredResource() {
      if (monitoredResourceBuilder_ == null) {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 3) {
          resourceCase_ = 0;
          resource_ = null;
        }
        monitoredResourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    public com.google.api.MonitoredResource.Builder getMonitoredResourceBuilder() {
      return getMonitoredResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    @java.lang.Override
    public com.google.api.MonitoredResourceOrBuilder getMonitoredResourceOrBuilder() {
      if ((resourceCase_ == 3) && (monitoredResourceBuilder_ != null)) {
        return monitoredResourceBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 3) {
          return (com.google.api.MonitoredResource) resource_;
        }
        return com.google.api.MonitoredResource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The [monitored
     * resource](https://cloud.google.com/monitoring/api/resources) associated
     * with the configuration.
     * The following monitored resource types are valid for this field:
     *   `uptime_url`,
     *   `gce_instance`,
     *   `gae_app`,
     *   `aws_ec2_instance`,
     *   `aws_elb_load_balancer`
     *   `k8s_service`
     *   `servicedirectory_service`
     *   `cloud_run_revision`
     * </pre>
     *
     * <code>.google.api.MonitoredResource monitored_resource = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        getMonitoredResourceFieldBuilder() {
      if (monitoredResourceBuilder_ == null) {
        if (!(resourceCase_ == 3)) {
          resource_ = com.google.api.MonitoredResource.getDefaultInstance();
        }
        monitoredResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MonitoredResource,
                com.google.api.MonitoredResource.Builder,
                com.google.api.MonitoredResourceOrBuilder>(
                (com.google.api.MonitoredResource) resource_, getParentForChildren(), isClean());
        resource_ = null;
      }
      resourceCase_ = 3;
      onChanged();
      return monitoredResourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>
        resourceGroupBuilder_;

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     *
     * @return Whether the resourceGroup field is set.
     */
    @java.lang.Override
    public boolean hasResourceGroup() {
      return resourceCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     *
     * @return The resourceGroup.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup getResourceGroup() {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4) {
          return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      } else {
        if (resourceCase_ == 4) {
          return resourceGroupBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder setResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup value) {
      if (resourceGroupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        resourceGroupBuilder_.setMessage(value);
      }
      resourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder setResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder builderForValue) {
      if (resourceGroupBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        resourceGroupBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder mergeResourceGroup(
        com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup value) {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4
            && resource_
                != com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance()) {
          resource_ =
              com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 4) {
          resourceGroupBuilder_.mergeFrom(value);
        } else {
          resourceGroupBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public Builder clearResourceGroup() {
      if (resourceGroupBuilder_ == null) {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 4) {
          resourceCase_ = 0;
          resource_ = null;
        }
        resourceGroupBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder
        getResourceGroupBuilder() {
      return getResourceGroupFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder
        getResourceGroupOrBuilder() {
      if ((resourceCase_ == 4) && (resourceGroupBuilder_ != null)) {
        return resourceGroupBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 4) {
          return (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The group resource associated with the configuration.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.ResourceGroup resource_group = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>
        getResourceGroupFieldBuilder() {
      if (resourceGroupBuilder_ == null) {
        if (!(resourceCase_ == 4)) {
          resource_ = com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.getDefaultInstance();
        }
        resourceGroupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.ResourceGroupOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.ResourceGroup) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 4;
      onChanged();
      return resourceGroupBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.SyntheticMonitorTarget,
            com.google.monitoring.v3.SyntheticMonitorTarget.Builder,
            com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder>
        syntheticMonitorBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     *
     * @return Whether the syntheticMonitor field is set.
     */
    @java.lang.Override
    public boolean hasSyntheticMonitor() {
      return resourceCase_ == 21;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     *
     * @return The syntheticMonitor.
     */
    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTarget getSyntheticMonitor() {
      if (syntheticMonitorBuilder_ == null) {
        if (resourceCase_ == 21) {
          return (com.google.monitoring.v3.SyntheticMonitorTarget) resource_;
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
      } else {
        if (resourceCase_ == 21) {
          return syntheticMonitorBuilder_.getMessage();
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    public Builder setSyntheticMonitor(com.google.monitoring.v3.SyntheticMonitorTarget value) {
      if (syntheticMonitorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        syntheticMonitorBuilder_.setMessage(value);
      }
      resourceCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    public Builder setSyntheticMonitor(
        com.google.monitoring.v3.SyntheticMonitorTarget.Builder builderForValue) {
      if (syntheticMonitorBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        syntheticMonitorBuilder_.setMessage(builderForValue.build());
      }
      resourceCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    public Builder mergeSyntheticMonitor(com.google.monitoring.v3.SyntheticMonitorTarget value) {
      if (syntheticMonitorBuilder_ == null) {
        if (resourceCase_ == 21
            && resource_ != com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance()) {
          resource_ =
              com.google.monitoring.v3.SyntheticMonitorTarget.newBuilder(
                      (com.google.monitoring.v3.SyntheticMonitorTarget) resource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        if (resourceCase_ == 21) {
          syntheticMonitorBuilder_.mergeFrom(value);
        } else {
          syntheticMonitorBuilder_.setMessage(value);
        }
      }
      resourceCase_ = 21;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    public Builder clearSyntheticMonitor() {
      if (syntheticMonitorBuilder_ == null) {
        if (resourceCase_ == 21) {
          resourceCase_ = 0;
          resource_ = null;
          onChanged();
        }
      } else {
        if (resourceCase_ == 21) {
          resourceCase_ = 0;
          resource_ = null;
        }
        syntheticMonitorBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    public com.google.monitoring.v3.SyntheticMonitorTarget.Builder getSyntheticMonitorBuilder() {
      return getSyntheticMonitorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder getSyntheticMonitorOrBuilder() {
      if ((resourceCase_ == 21) && (syntheticMonitorBuilder_ != null)) {
        return syntheticMonitorBuilder_.getMessageOrBuilder();
      } else {
        if (resourceCase_ == 21) {
          return (com.google.monitoring.v3.SyntheticMonitorTarget) resource_;
        }
        return com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies a Synthetic Monitor to invoke.
     * </pre>
     *
     * <code>.google.monitoring.v3.SyntheticMonitorTarget synthetic_monitor = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.SyntheticMonitorTarget,
            com.google.monitoring.v3.SyntheticMonitorTarget.Builder,
            com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder>
        getSyntheticMonitorFieldBuilder() {
      if (syntheticMonitorBuilder_ == null) {
        if (!(resourceCase_ == 21)) {
          resource_ = com.google.monitoring.v3.SyntheticMonitorTarget.getDefaultInstance();
        }
        syntheticMonitorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.SyntheticMonitorTarget,
                com.google.monitoring.v3.SyntheticMonitorTarget.Builder,
                com.google.monitoring.v3.SyntheticMonitorTargetOrBuilder>(
                (com.google.monitoring.v3.SyntheticMonitorTarget) resource_,
                getParentForChildren(),
                isClean());
        resource_ = null;
      }
      resourceCase_ = 21;
      onChanged();
      return syntheticMonitorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>
        httpCheckBuilder_;

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     *
     * @return Whether the httpCheck field is set.
     */
    @java.lang.Override
    public boolean hasHttpCheck() {
      return checkRequestTypeCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     *
     * @return The httpCheck.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck getHttpCheck() {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5) {
          return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      } else {
        if (checkRequestTypeCase_ == 5) {
          return httpCheckBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder setHttpCheck(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck value) {
      if (httpCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkRequestType_ = value;
        onChanged();
      } else {
        httpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder setHttpCheck(
        com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder builderForValue) {
      if (httpCheckBuilder_ == null) {
        checkRequestType_ = builderForValue.build();
        onChanged();
      } else {
        httpCheckBuilder_.setMessage(builderForValue.build());
      }
      checkRequestTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder mergeHttpCheck(com.google.monitoring.v3.UptimeCheckConfig.HttpCheck value) {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5
            && checkRequestType_
                != com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance()) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          checkRequestType_ = value;
        }
        onChanged();
      } else {
        if (checkRequestTypeCase_ == 5) {
          httpCheckBuilder_.mergeFrom(value);
        } else {
          httpCheckBuilder_.setMessage(value);
        }
      }
      checkRequestTypeCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public Builder clearHttpCheck() {
      if (httpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 5) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
          onChanged();
        }
      } else {
        if (checkRequestTypeCase_ == 5) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
        }
        httpCheckBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder getHttpCheckBuilder() {
      return getHttpCheckFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder getHttpCheckOrBuilder() {
      if ((checkRequestTypeCase_ == 5) && (httpCheckBuilder_ != null)) {
        return httpCheckBuilder_.getMessageOrBuilder();
      } else {
        if (checkRequestTypeCase_ == 5) {
          return (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make an HTTP or HTTPS check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.HttpCheck http_check = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>
        getHttpCheckFieldBuilder() {
      if (httpCheckBuilder_ == null) {
        if (!(checkRequestTypeCase_ == 5)) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.getDefaultInstance();
        }
        httpCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheck.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.HttpCheckOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.HttpCheck) checkRequestType_,
                getParentForChildren(),
                isClean());
        checkRequestType_ = null;
      }
      checkRequestTypeCase_ = 5;
      onChanged();
      return httpCheckBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>
        tcpCheckBuilder_;

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     *
     * @return Whether the tcpCheck field is set.
     */
    @java.lang.Override
    public boolean hasTcpCheck() {
      return checkRequestTypeCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     *
     * @return The tcpCheck.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck getTcpCheck() {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6) {
          return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      } else {
        if (checkRequestTypeCase_ == 6) {
          return tcpCheckBuilder_.getMessage();
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder setTcpCheck(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck value) {
      if (tcpCheckBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkRequestType_ = value;
        onChanged();
      } else {
        tcpCheckBuilder_.setMessage(value);
      }
      checkRequestTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder setTcpCheck(
        com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder builderForValue) {
      if (tcpCheckBuilder_ == null) {
        checkRequestType_ = builderForValue.build();
        onChanged();
      } else {
        tcpCheckBuilder_.setMessage(builderForValue.build());
      }
      checkRequestTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder mergeTcpCheck(com.google.monitoring.v3.UptimeCheckConfig.TcpCheck value) {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6
            && checkRequestType_
                != com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance()) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.newBuilder(
                      (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          checkRequestType_ = value;
        }
        onChanged();
      } else {
        if (checkRequestTypeCase_ == 6) {
          tcpCheckBuilder_.mergeFrom(value);
        } else {
          tcpCheckBuilder_.setMessage(value);
        }
      }
      checkRequestTypeCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public Builder clearTcpCheck() {
      if (tcpCheckBuilder_ == null) {
        if (checkRequestTypeCase_ == 6) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
          onChanged();
        }
      } else {
        if (checkRequestTypeCase_ == 6) {
          checkRequestTypeCase_ = 0;
          checkRequestType_ = null;
        }
        tcpCheckBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder getTcpCheckBuilder() {
      return getTcpCheckFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder getTcpCheckOrBuilder() {
      if ((checkRequestTypeCase_ == 6) && (tcpCheckBuilder_ != null)) {
        return tcpCheckBuilder_.getMessageOrBuilder();
      } else {
        if (checkRequestTypeCase_ == 6) {
          return (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_;
        }
        return com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Contains information needed to make a TCP check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.TcpCheck tcp_check = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>
        getTcpCheckFieldBuilder() {
      if (tcpCheckBuilder_ == null) {
        if (!(checkRequestTypeCase_ == 6)) {
          checkRequestType_ =
              com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.getDefaultInstance();
        }
        tcpCheckBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheck.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.TcpCheckOrBuilder>(
                (com.google.monitoring.v3.UptimeCheckConfig.TcpCheck) checkRequestType_,
                getParentForChildren(),
                isClean());
        checkRequestType_ = null;
      }
      checkRequestTypeCase_ = 6;
      onChanged();
      return tcpCheckBuilder_;
    }

    private com.google.protobuf.Duration period_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        periodBuilder_;

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     *
     * @return Whether the period field is set.
     */
    public boolean hasPeriod() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     *
     * @return The period.
     */
    public com.google.protobuf.Duration getPeriod() {
      if (periodBuilder_ == null) {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      } else {
        return periodBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        period_ = value;
      } else {
        periodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (periodBuilder_ == null) {
        period_ = builderForValue.build();
      } else {
        periodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder mergePeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && period_ != null
            && period_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getPeriodBuilder().mergeFrom(value);
        } else {
          period_ = value;
        }
      } else {
        periodBuilder_.mergeFrom(value);
      }
      if (period_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public Builder clearPeriod() {
      bitField0_ = (bitField0_ & ~0x00000080);
      period_ = null;
      if (periodBuilder_ != null) {
        periodBuilder_.dispose();
        periodBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getPeriodBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPeriodFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
      if (periodBuilder_ != null) {
        return periodBuilder_.getMessageOrBuilder();
      } else {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      }
    }

    /**
     *
     *
     * <pre>
     * How often, in seconds, the Uptime check is performed.
     * Currently, the only supported values are `60s` (1 minute), `300s`
     * (5 minutes), `600s` (10 minutes), and `900s` (15 minutes). Optional,
     * defaults to `60s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getPeriodFieldBuilder() {
      if (periodBuilder_ == null) {
        periodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getPeriod(), getParentForChildren(), isClean());
        period_ = null;
      }
      return periodBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      if (timeout_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000100);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }

    /**
     *
     *
     * <pre>
     * The maximum amount of time to wait for the request to complete (must be
     * between 1 and 60 seconds). Required.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
        contentMatchers_ = java.util.Collections.emptyList();

    private void ensureContentMatchersIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        contentMatchers_ =
            new java.util.ArrayList<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>(
                contentMatchers_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        contentMatchersBuilder_;

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
        getContentMatchersList() {
      if (contentMatchersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contentMatchers_);
      } else {
        return contentMatchersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public int getContentMatchersCount() {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.size();
      } else {
        return contentMatchersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher getContentMatchers(int index) {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.get(index);
      } else {
        return contentMatchersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder setContentMatchers(
        int index, com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.set(index, value);
        onChanged();
      } else {
        contentMatchersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder setContentMatchers(
        int index,
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.add(value);
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        int index, com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher value) {
      if (contentMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentMatchersIsMutable();
        contentMatchers_.add(index, value);
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.add(builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addContentMatchers(
        int index,
        com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder builderForValue) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentMatchersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder addAllContentMatchers(
        java.lang.Iterable<? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher>
            values) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contentMatchers_);
        onChanged();
      } else {
        contentMatchersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder clearContentMatchers() {
      if (contentMatchersBuilder_ == null) {
        contentMatchers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        contentMatchersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public Builder removeContentMatchers(int index) {
      if (contentMatchersBuilder_ == null) {
        ensureContentMatchersIsMutable();
        contentMatchers_.remove(index);
        onChanged();
      } else {
        contentMatchersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        getContentMatchersBuilder(int index) {
      return getContentMatchersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder
        getContentMatchersOrBuilder(int index) {
      if (contentMatchersBuilder_ == null) {
        return contentMatchers_.get(index);
      } else {
        return contentMatchersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<
            ? extends com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        getContentMatchersOrBuilderList() {
      if (contentMatchersBuilder_ != null) {
        return contentMatchersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contentMatchers_);
      }
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        addContentMatchersBuilder() {
      return getContentMatchersFieldBuilder()
          .addBuilder(
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder
        addContentMatchersBuilder(int index) {
      return getContentMatchersFieldBuilder()
          .addBuilder(
              index,
              com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The content that is expected to appear in the data returned by the target
     * server against which the check is run.  Currently, only the first entry
     * in the `content_matchers` list is supported, and additional entries will
     * be ignored. This field is optional and should only be specified if a
     * content match is required as part of the/ Uptime check.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckConfig.ContentMatcher content_matchers = 9;
     * </code>
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder>
        getContentMatchersBuilderList() {
      return getContentMatchersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
            com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>
        getContentMatchersFieldBuilder() {
      if (contentMatchersBuilder_ == null) {
        contentMatchersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcher.Builder,
                com.google.monitoring.v3.UptimeCheckConfig.ContentMatcherOrBuilder>(
                contentMatchers_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        contentMatchers_ = null;
      }
      return contentMatchersBuilder_;
    }

    private int checkerType_ = 0;

    /**
     *
     *
     * <pre>
     * The type of checkers to use to execute the Uptime check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     *
     * @return The enum numeric value on the wire for checkerType.
     */
    @java.lang.Override
    public int getCheckerTypeValue() {
      return checkerType_;
    }

    /**
     *
     *
     * <pre>
     * The type of checkers to use to execute the Uptime check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     *
     * @param value The enum numeric value on the wire for checkerType to set.
     * @return This builder for chaining.
     */
    public Builder setCheckerTypeValue(int value) {
      checkerType_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of checkers to use to execute the Uptime check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     *
     * @return The checkerType.
     */
    @java.lang.Override
    public com.google.monitoring.v3.UptimeCheckConfig.CheckerType getCheckerType() {
      com.google.monitoring.v3.UptimeCheckConfig.CheckerType result =
          com.google.monitoring.v3.UptimeCheckConfig.CheckerType.forNumber(checkerType_);
      return result == null
          ? com.google.monitoring.v3.UptimeCheckConfig.CheckerType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The type of checkers to use to execute the Uptime check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     *
     * @param value The checkerType to set.
     * @return This builder for chaining.
     */
    public Builder setCheckerType(com.google.monitoring.v3.UptimeCheckConfig.CheckerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      checkerType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of checkers to use to execute the Uptime check.
     * </pre>
     *
     * <code>.google.monitoring.v3.UptimeCheckConfig.CheckerType checker_type = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCheckerType() {
      bitField0_ = (bitField0_ & ~0x00000400);
      checkerType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> selectedRegions_ = java.util.Collections.emptyList();

    private void ensureSelectedRegionsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        selectedRegions_ = new java.util.ArrayList<java.lang.Integer>(selectedRegions_);
        bitField0_ |= 0x00000800;
      }
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return A list containing the selectedRegions.
     */
    public java.util.List<com.google.monitoring.v3.UptimeCheckRegion> getSelectedRegionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.monitoring.v3.UptimeCheckRegion>(
          selectedRegions_, selectedRegions_converter_);
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return The count of selectedRegions.
     */
    public int getSelectedRegionsCount() {
      return selectedRegions_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedRegions at the given index.
     */
    public com.google.monitoring.v3.UptimeCheckRegion getSelectedRegions(int index) {
      return selectedRegions_converter_.convert(selectedRegions_.get(index));
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The selectedRegions to set.
     * @return This builder for chaining.
     */
    public Builder setSelectedRegions(int index, com.google.monitoring.v3.UptimeCheckRegion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSelectedRegionsIsMutable();
      selectedRegions_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param value The selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSelectedRegions(com.google.monitoring.v3.UptimeCheckRegion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSelectedRegionsIsMutable();
      selectedRegions_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param values The selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSelectedRegions(
        java.lang.Iterable<? extends com.google.monitoring.v3.UptimeCheckRegion> values) {
      ensureSelectedRegionsIsMutable();
      for (com.google.monitoring.v3.UptimeCheckRegion value : values) {
        selectedRegions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelectedRegions() {
      selectedRegions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @return A list containing the enum numeric values on the wire for selectedRegions.
     */
    public java.util.List<java.lang.Integer> getSelectedRegionsValueList() {
      return java.util.Collections.unmodifiableList(selectedRegions_);
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of selectedRegions at the given index.
     */
    public int getSelectedRegionsValue(int index) {
      return selectedRegions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for selectedRegions to set.
     * @return This builder for chaining.
     */
    public Builder setSelectedRegionsValue(int index, int value) {
      ensureSelectedRegionsIsMutable();
      selectedRegions_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param value The enum numeric value on the wire for selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addSelectedRegionsValue(int value) {
      ensureSelectedRegionsIsMutable();
      selectedRegions_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of regions from which the check will be run.
     * Some regions contain one location, and others contain more than one.
     * If this field is specified, enough regions must be provided to include a
     * minimum of 3 locations.  Not specifying this field will result in Uptime
     * checks running from all available regions.
     * </pre>
     *
     * <code>repeated .google.monitoring.v3.UptimeCheckRegion selected_regions = 10;</code>
     *
     * @param values The enum numeric values on the wire for selectedRegions to add.
     * @return This builder for chaining.
     */
    public Builder addAllSelectedRegionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureSelectedRegionsIsMutable();
      for (int value : values) {
        selectedRegions_.add(value);
      }
      onChanged();
      return this;
    }

    private boolean isInternal_;

    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @deprecated google.monitoring.v3.UptimeCheckConfig.is_internal is deprecated. See
     *     google/monitoring/v3/uptime.proto;l=547
     * @return The isInternal.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getIsInternal() {
      return isInternal_;
    }

    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @deprecated google.monitoring.v3.UptimeCheckConfig.is_internal is deprecated. See
     *     google/monitoring/v3/uptime.proto;l=547
     * @param value The isInternal to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setIsInternal(boolean value) {

      isInternal_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If this is `true`, then checks are made only from the 'internal_checkers'.
     * If it is `false`, then checks are made only from the 'selected_regions'.
     * It is an error to provide 'selected_regions' when is_internal is `true`,
     * or to provide 'internal_checkers' when is_internal is `false`.
     * </pre>
     *
     * <code>bool is_internal = 15 [deprecated = true];</code>
     *
     * @deprecated google.monitoring.v3.UptimeCheckConfig.is_internal is deprecated. See
     *     google/monitoring/v3/uptime.proto;l=547
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearIsInternal() {
      bitField0_ = (bitField0_ & ~0x00001000);
      isInternal_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.monitoring.v3.InternalChecker> internalCheckers_ =
        java.util.Collections.emptyList();

    private void ensureInternalCheckersIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        internalCheckers_ =
            new java.util.ArrayList<com.google.monitoring.v3.InternalChecker>(internalCheckers_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.InternalChecker,
            com.google.monitoring.v3.InternalChecker.Builder,
            com.google.monitoring.v3.InternalCheckerOrBuilder>
        internalCheckersBuilder_;

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.monitoring.v3.InternalChecker> getInternalCheckersList() {
      if (internalCheckersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(internalCheckers_);
      } else {
        return internalCheckersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getInternalCheckersCount() {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.size();
      } else {
        return internalCheckersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker getInternalCheckers(int index) {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.get(index);
      } else {
        return internalCheckersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInternalCheckers(int index, com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.set(index, value);
        onChanged();
      } else {
        internalCheckersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setInternalCheckers(
        int index, com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.set(index, builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(value);
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(int index, com.google.monitoring.v3.InternalChecker value) {
      if (internalCheckersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(index, value);
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(
        com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addInternalCheckers(
        int index, com.google.monitoring.v3.InternalChecker.Builder builderForValue) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.add(index, builderForValue.build());
        onChanged();
      } else {
        internalCheckersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllInternalCheckers(
        java.lang.Iterable<? extends com.google.monitoring.v3.InternalChecker> values) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, internalCheckers_);
        onChanged();
      } else {
        internalCheckersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearInternalCheckers() {
      if (internalCheckersBuilder_ == null) {
        internalCheckers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        internalCheckersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeInternalCheckers(int index) {
      if (internalCheckersBuilder_ == null) {
        ensureInternalCheckersIsMutable();
        internalCheckers_.remove(index);
        onChanged();
      } else {
        internalCheckersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder getInternalCheckersBuilder(int index) {
      return getInternalCheckersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalCheckerOrBuilder getInternalCheckersOrBuilder(
        int index) {
      if (internalCheckersBuilder_ == null) {
        return internalCheckers_.get(index);
      } else {
        return internalCheckersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.monitoring.v3.InternalCheckerOrBuilder>
        getInternalCheckersOrBuilderList() {
      if (internalCheckersBuilder_ != null) {
        return internalCheckersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(internalCheckers_);
      }
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder addInternalCheckersBuilder() {
      return getInternalCheckersFieldBuilder()
          .addBuilder(com.google.monitoring.v3.InternalChecker.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.monitoring.v3.InternalChecker.Builder addInternalCheckersBuilder(int index) {
      return getInternalCheckersFieldBuilder()
          .addBuilder(index, com.google.monitoring.v3.InternalChecker.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The internal checkers that this check will egress from. If `is_internal` is
     * `true` and this list is empty, the check will egress from all the
     * InternalCheckers configured for the project that owns this
     * `UptimeCheckConfig`.
     * </pre>
     *
     * <code>
     * repeated .google.monitoring.v3.InternalChecker internal_checkers = 14 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.monitoring.v3.InternalChecker.Builder>
        getInternalCheckersBuilderList() {
      return getInternalCheckersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.monitoring.v3.InternalChecker,
            com.google.monitoring.v3.InternalChecker.Builder,
            com.google.monitoring.v3.InternalCheckerOrBuilder>
        getInternalCheckersFieldBuilder() {
      if (internalCheckersBuilder_ == null) {
        internalCheckersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.monitoring.v3.InternalChecker,
                com.google.monitoring.v3.InternalChecker.Builder,
                com.google.monitoring.v3.InternalCheckerOrBuilder>(
                internalCheckers_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        internalCheckers_ = null;
      }
      return internalCheckersBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> userLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUserLabels() {
      if (userLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UserLabelsDefaultEntryHolder.defaultEntry);
      }
      return userLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableUserLabels() {
      if (userLabels_ == null) {
        userLabels_ =
            com.google.protobuf.MapField.newMapField(UserLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!userLabels_.isMutable()) {
        userLabels_ = userLabels_.copy();
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return userLabels_;
    }

    public int getUserLabelsCount() {
      return internalGetUserLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    @java.lang.Override
    public boolean containsUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetUserLabels().getMap().containsKey(key);
    }

    /** Use {@link #getUserLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUserLabels() {
      return getUserLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getUserLabelsMap() {
      return internalGetUserLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getUserLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    @java.lang.Override
    public java.lang.String getUserLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetUserLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearUserLabels() {
      bitField0_ = (bitField0_ & ~0x00004000);
      internalGetMutableUserLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    public Builder removeUserLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableUserLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableUserLabels() {
      bitField0_ |= 0x00004000;
      return internalGetMutableUserLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    public Builder putUserLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableUserLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00004000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * User-supplied key/value data to be used for organizing and
     * identifying the `UptimeCheckConfig` objects.
     *
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     * </pre>
     *
     * <code>map&lt;string, string&gt; user_labels = 20;</code>
     */
    public Builder putAllUserLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableUserLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00004000;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UptimeCheckConfig)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.UptimeCheckConfig)
  private static final com.google.monitoring.v3.UptimeCheckConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.UptimeCheckConfig();
  }

  public static com.google.monitoring.v3.UptimeCheckConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UptimeCheckConfig> PARSER =
      new com.google.protobuf.AbstractParser<UptimeCheckConfig>() {
        @java.lang.Override
        public UptimeCheckConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UptimeCheckConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UptimeCheckConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.UptimeCheckConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
