/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyBasedRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_POLICY_BASED_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/PolicyBasedRoutes/{policy_based_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String policyBasedRoute;

    @Deprecated
    protected PolicyBasedRouteName() {
        this.project = null;
        this.policyBasedRoute = null;
    }

    private PolicyBasedRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.policyBasedRoute = (String)Preconditions.checkNotNull((Object)builder.getPolicyBasedRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getPolicyBasedRoute() {
        return this.policyBasedRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyBasedRouteName of(String project, String policyBasedRoute) {
        return PolicyBasedRouteName.newBuilder().setProject(project).setPolicyBasedRoute(policyBasedRoute).build();
    }

    public static String format(String project, String policyBasedRoute) {
        return PolicyBasedRouteName.newBuilder().setProject(project).setPolicyBasedRoute(policyBasedRoute).build().toString();
    }

    public static PolicyBasedRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_POLICY_BASED_ROUTE.validatedMatch(formattedString, "PolicyBasedRouteName.parse: formattedString not in valid format");
        return PolicyBasedRouteName.of((String)matchMap.get("project"), (String)matchMap.get("policy_based_route"));
    }

    public static List<PolicyBasedRouteName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyBasedRouteName> list = new ArrayList<PolicyBasedRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyBasedRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyBasedRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyBasedRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_POLICY_BASED_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyBasedRouteName policyBasedRouteName = this;
            synchronized (policyBasedRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.policyBasedRoute != null) {
                        fieldMapBuilder.put((Object)"policy_based_route", (Object)this.policyBasedRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_POLICY_BASED_ROUTE.instantiate(new String[]{"project", this.project, "policy_based_route", this.policyBasedRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PolicyBasedRouteName that = (PolicyBasedRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.policyBasedRoute, that.policyBasedRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.policyBasedRoute);
    }

    public static class Builder {
        private String project;
        private String policyBasedRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getPolicyBasedRoute() {
            return this.policyBasedRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setPolicyBasedRoute(String policyBasedRoute) {
            this.policyBasedRoute = policyBasedRoute;
            return this;
        }

        private Builder(PolicyBasedRouteName policyBasedRouteName) {
            this.project = policyBasedRouteName.project;
            this.policyBasedRoute = policyBasedRouteName.policyBasedRoute;
        }

        public PolicyBasedRouteName build() {
            return new PolicyBasedRouteName(this);
        }
    }
}

