/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * A subscription resource.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.Subscription}
 */
public final class Subscription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.Subscription)
    SubscriptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Subscription.newBuilder() to construct.
  private Subscription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Subscription() {
    name_ = "";
    topic_ = "";
    filter_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Subscription();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_Subscription_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_Subscription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.Subscription.class,
            com.google.pubsub.v1.Subscription.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states for a subscription.
   * </pre>
   *
   * Protobuf enum {@code google.pubsub.v1.Subscription.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The subscription can actively receive messages
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * The subscription cannot receive messages because of an error with the
     * resource to which it pushes messages. See the more detailed error state
     * in the corresponding configuration.
     * </pre>
     *
     * <code>RESOURCE_ERROR = 2;</code>
     */
    RESOURCE_ERROR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The subscription can actively receive messages
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The subscription cannot receive messages because of an error with the
     * resource to which it pushes messages. See the more detailed error state
     * in the corresponding configuration.
     * </pre>
     *
     * <code>RESOURCE_ERROR = 2;</code>
     */
    public static final int RESOURCE_ERROR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return RESOURCE_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.pubsub.v1.Subscription.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.pubsub.v1.Subscription.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required. The name of the subscription. It must have the format
   * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
   * start with a letter, and contain only letters (`[A-Za-z]`), numbers
   * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
   * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
   * in length, and it must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the subscription. It must have the format
   * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
   * start with a letter, and contain only letters (`[A-Za-z]`), numbers
   * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
   * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
   * in length, and it must not start with `"goog"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOPIC_FIELD_NUMBER = 2;
  private volatile java.lang.Object topic_;
  /**
   *
   *
   * <pre>
   * Required. The name of the topic from which this subscription is receiving
   * messages. Format is `projects/{project}/topics/{topic}`. The value of this
   * field will be `_deleted-topic_` if the topic has been deleted.
   * </pre>
   *
   * <code>
   * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the topic from which this subscription is receiving
   * messages. Format is `projects/{project}/topics/{topic}`. The value of this
   * field will be `_deleted-topic_` if the topic has been deleted.
   * </pre>
   *
   * <code>
   * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PUSH_CONFIG_FIELD_NUMBER = 4;
  private com.google.pubsub.v1.PushConfig pushConfig_;
  /**
   *
   *
   * <pre>
   * If push delivery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
   *
   * @return Whether the pushConfig field is set.
   */
  @java.lang.Override
  public boolean hasPushConfig() {
    return pushConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * If push delivery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
   *
   * @return The pushConfig.
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfig getPushConfig() {
    return pushConfig_ == null ? com.google.pubsub.v1.PushConfig.getDefaultInstance() : pushConfig_;
  }
  /**
   *
   *
   * <pre>
   * If push delivery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.PushConfigOrBuilder getPushConfigOrBuilder() {
    return getPushConfig();
  }

  public static final int BIGQUERY_CONFIG_FIELD_NUMBER = 18;
  private com.google.pubsub.v1.BigQueryConfig bigqueryConfig_;
  /**
   *
   *
   * <pre>
   * If delivery to BigQuery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
   *
   * @return Whether the bigqueryConfig field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryConfig() {
    return bigqueryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * If delivery to BigQuery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
   *
   * @return The bigqueryConfig.
   */
  @java.lang.Override
  public com.google.pubsub.v1.BigQueryConfig getBigqueryConfig() {
    return bigqueryConfig_ == null
        ? com.google.pubsub.v1.BigQueryConfig.getDefaultInstance()
        : bigqueryConfig_;
  }
  /**
   *
   *
   * <pre>
   * If delivery to BigQuery is used with this subscription, this field is
   * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
   * but not both. If both are empty, then the subscriber will pull and ack
   * messages using API methods.
   * </pre>
   *
   * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.BigQueryConfigOrBuilder getBigqueryConfigOrBuilder() {
    return getBigqueryConfig();
  }

  public static final int ACK_DEADLINE_SECONDS_FIELD_NUMBER = 5;
  private int ackDeadlineSeconds_;
  /**
   *
   *
   * <pre>
   * The approximate amount of time (on a best-effort basis) Pub/Sub waits for
   * the subscriber to acknowledge receipt before resending the message. In the
   * interval after the message is delivered and before it is acknowledged, it
   * is considered to be &lt;i&gt;outstanding&lt;/i&gt;. During that time period, the
   * message will not be redelivered (on a best-effort basis).
   * For pull subscriptions, this value is used as the initial value for the ack
   * deadline. To override this value for a given message, call
   * `ModifyAckDeadline` with the corresponding `ack_id` if using
   * non-streaming pull or send the `ack_id` in a
   * `StreamingModifyAckDeadlineRequest` if using streaming pull.
   * The minimum custom deadline you can specify is 10 seconds.
   * The maximum custom deadline you can specify is 600 seconds (10 minutes).
   * If this parameter is 0, a default value of 10 seconds is used.
   * For push delivery, this value is also used to set the request timeout for
   * the call to the push endpoint.
   * If the subscriber never acknowledges the message, the Pub/Sub
   * system will eventually redeliver the message.
   * </pre>
   *
   * <code>int32 ack_deadline_seconds = 5;</code>
   *
   * @return The ackDeadlineSeconds.
   */
  @java.lang.Override
  public int getAckDeadlineSeconds() {
    return ackDeadlineSeconds_;
  }

  public static final int RETAIN_ACKED_MESSAGES_FIELD_NUMBER = 7;
  private boolean retainAckedMessages_;
  /**
   *
   *
   * <pre>
   * Indicates whether to retain acknowledged messages. If true, then
   * messages are not expunged from the subscription's backlog, even if they are
   * acknowledged, until they fall out of the `message_retention_duration`
   * window. This must be true if you would like to [`Seek` to a timestamp]
   * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
   * the past to replay previously-acknowledged messages.
   * </pre>
   *
   * <code>bool retain_acked_messages = 7;</code>
   *
   * @return The retainAckedMessages.
   */
  @java.lang.Override
  public boolean getRetainAckedMessages() {
    return retainAckedMessages_;
  }

  public static final int MESSAGE_RETENTION_DURATION_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration messageRetentionDuration_;
  /**
   *
   *
   * <pre>
   * How long to retain unacknowledged messages in the subscription's backlog,
   * from the moment a message is published.
   * If `retain_acked_messages` is true, then this also configures the retention
   * of acknowledged messages, and thus configures how far back in time a `Seek`
   * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
   * minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
   *
   * @return Whether the messageRetentionDuration field is set.
   */
  @java.lang.Override
  public boolean hasMessageRetentionDuration() {
    return messageRetentionDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * How long to retain unacknowledged messages in the subscription's backlog,
   * from the moment a message is published.
   * If `retain_acked_messages` is true, then this also configures the retention
   * of acknowledged messages, and thus configures how far back in time a `Seek`
   * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
   * minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
   *
   * @return The messageRetentionDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMessageRetentionDuration() {
    return messageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : messageRetentionDuration_;
  }
  /**
   *
   *
   * <pre>
   * How long to retain unacknowledged messages in the subscription's backlog,
   * from the moment a message is published.
   * If `retain_acked_messages` is true, then this also configures the retention
   * of acknowledged messages, and thus configures how far back in time a `Seek`
   * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
   * minutes.
   * </pre>
   *
   * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
    return getMessageRetentionDuration();
  }

  public static final int LABELS_FIELD_NUMBER = 9;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.pubsub.v1.PubsubProto
                .internal_static_google_pubsub_v1_Subscription_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
   * managing labels&lt;/a&gt;.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ENABLE_MESSAGE_ORDERING_FIELD_NUMBER = 10;
  private boolean enableMessageOrdering_;
  /**
   *
   *
   * <pre>
   * If true, messages published with the same `ordering_key` in `PubsubMessage`
   * will be delivered to the subscribers in the order in which they
   * are received by the Pub/Sub system. Otherwise, they may be delivered in
   * any order.
   * </pre>
   *
   * <code>bool enable_message_ordering = 10;</code>
   *
   * @return The enableMessageOrdering.
   */
  @java.lang.Override
  public boolean getEnableMessageOrdering() {
    return enableMessageOrdering_;
  }

  public static final int EXPIRATION_POLICY_FIELD_NUMBER = 11;
  private com.google.pubsub.v1.ExpirationPolicy expirationPolicy_;
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for this subscription's expiration.
   * A subscription is considered active as long as any connected subscriber is
   * successfully consuming messages from the subscription or is issuing
   * operations on the subscription. If `expiration_policy` is not set, a
   * *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day.
   * </pre>
   *
   * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
   *
   * @return Whether the expirationPolicy field is set.
   */
  @java.lang.Override
  public boolean hasExpirationPolicy() {
    return expirationPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for this subscription's expiration.
   * A subscription is considered active as long as any connected subscriber is
   * successfully consuming messages from the subscription or is issuing
   * operations on the subscription. If `expiration_policy` is not set, a
   * *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day.
   * </pre>
   *
   * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
   *
   * @return The expirationPolicy.
   */
  @java.lang.Override
  public com.google.pubsub.v1.ExpirationPolicy getExpirationPolicy() {
    return expirationPolicy_ == null
        ? com.google.pubsub.v1.ExpirationPolicy.getDefaultInstance()
        : expirationPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for this subscription's expiration.
   * A subscription is considered active as long as any connected subscriber is
   * successfully consuming messages from the subscription or is issuing
   * operations on the subscription. If `expiration_policy` is not set, a
   * *default policy* with `ttl` of 31 days will be used. The minimum allowed
   * value for `expiration_policy.ttl` is 1 day.
   * </pre>
   *
   * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.ExpirationPolicyOrBuilder getExpirationPolicyOrBuilder() {
    return getExpirationPolicy();
  }

  public static final int FILTER_FIELD_NUMBER = 12;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An expression written in the Pub/Sub [filter
   * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
   * then only `PubsubMessage`s whose `attributes` field matches the filter are
   * delivered on this subscription. If empty, then no messages are filtered
   * out.
   * </pre>
   *
   * <code>string filter = 12;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEAD_LETTER_POLICY_FIELD_NUMBER = 13;
  private com.google.pubsub.v1.DeadLetterPolicy deadLetterPolicy_;
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for dead lettering messages in
   * this subscription. If dead_letter_policy is not set, dead lettering
   * is disabled.
   * The Cloud Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
   *
   * @return Whether the deadLetterPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDeadLetterPolicy() {
    return deadLetterPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for dead lettering messages in
   * this subscription. If dead_letter_policy is not set, dead lettering
   * is disabled.
   * The Cloud Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
   *
   * @return The deadLetterPolicy.
   */
  @java.lang.Override
  public com.google.pubsub.v1.DeadLetterPolicy getDeadLetterPolicy() {
    return deadLetterPolicy_ == null
        ? com.google.pubsub.v1.DeadLetterPolicy.getDefaultInstance()
        : deadLetterPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies the conditions for dead lettering messages in
   * this subscription. If dead_letter_policy is not set, dead lettering
   * is disabled.
   * The Cloud Pub/Sub service account associated with this subscriptions's
   * parent project (i.e.,
   * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
   * permission to Acknowledge() messages on this subscription.
   * </pre>
   *
   * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.DeadLetterPolicyOrBuilder getDeadLetterPolicyOrBuilder() {
    return getDeadLetterPolicy();
  }

  public static final int RETRY_POLICY_FIELD_NUMBER = 14;
  private com.google.pubsub.v1.RetryPolicy retryPolicy_;
  /**
   *
   *
   * <pre>
   * A policy that specifies how Pub/Sub retries message delivery for this
   * subscription.
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
   *
   * @return Whether the retryPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetryPolicy() {
    return retryPolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies how Pub/Sub retries message delivery for this
   * subscription.
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
   *
   * @return The retryPolicy.
   */
  @java.lang.Override
  public com.google.pubsub.v1.RetryPolicy getRetryPolicy() {
    return retryPolicy_ == null
        ? com.google.pubsub.v1.RetryPolicy.getDefaultInstance()
        : retryPolicy_;
  }
  /**
   *
   *
   * <pre>
   * A policy that specifies how Pub/Sub retries message delivery for this
   * subscription.
   * If not set, the default retry policy is applied. This generally implies
   * that messages will be retried as soon as possible for healthy subscribers.
   * RetryPolicy will be triggered on NACKs or acknowledgement deadline
   * exceeded events for a given message.
   * </pre>
   *
   * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
   */
  @java.lang.Override
  public com.google.pubsub.v1.RetryPolicyOrBuilder getRetryPolicyOrBuilder() {
    return getRetryPolicy();
  }

  public static final int DETACHED_FIELD_NUMBER = 15;
  private boolean detached_;
  /**
   *
   *
   * <pre>
   * Indicates whether the subscription is detached from its topic. Detached
   * subscriptions don't receive messages from their topic and don't retain any
   * backlog. `Pull` and `StreamingPull` requests will return
   * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
   * the endpoint will not be made.
   * </pre>
   *
   * <code>bool detached = 15;</code>
   *
   * @return The detached.
   */
  @java.lang.Override
  public boolean getDetached() {
    return detached_;
  }

  public static final int ENABLE_EXACTLY_ONCE_DELIVERY_FIELD_NUMBER = 16;
  private boolean enableExactlyOnceDelivery_;
  /**
   *
   *
   * <pre>
   * If true, Pub/Sub provides the following guarantees for the delivery of
   * a message with a given value of `message_id` on this subscription:
   * * The message sent to a subscriber is guaranteed not to be resent
   * before the message's acknowledgement deadline expires.
   * * An acknowledged message will not be resent to a subscriber.
   * Note that subscribers may still receive multiple copies of a message
   * when `enable_exactly_once_delivery` is true if the message was published
   * multiple times by a publisher client. These copies are  considered distinct
   * by Pub/Sub and have distinct `message_id` values.
   * </pre>
   *
   * <code>bool enable_exactly_once_delivery = 16;</code>
   *
   * @return The enableExactlyOnceDelivery.
   */
  @java.lang.Override
  public boolean getEnableExactlyOnceDelivery() {
    return enableExactlyOnceDelivery_;
  }

  public static final int TOPIC_MESSAGE_RETENTION_DURATION_FIELD_NUMBER = 17;
  private com.google.protobuf.Duration topicMessageRetentionDuration_;
  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the topicMessageRetentionDuration field is set.
   */
  @java.lang.Override
  public boolean hasTopicMessageRetentionDuration() {
    return topicMessageRetentionDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The topicMessageRetentionDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTopicMessageRetentionDuration() {
    return topicMessageRetentionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : topicMessageRetentionDuration_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indicates the minimum duration for which a message is retained
   * after it is published to the subscription's topic. If this field is set,
   * messages published to the subscription's topic in the last
   * `topic_message_retention_duration` are always available to subscribers. See
   * the `message_retention_duration` field in `Topic`. This field is set only
   * in responses from the server; it is ignored if it is set in any requests.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTopicMessageRetentionDurationOrBuilder() {
    return getTopicMessageRetentionDuration();
  }

  public static final int STATE_FIELD_NUMBER = 19;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An output-only field indicating whether or not the
   * subscription can receive messages.
   * </pre>
   *
   * <code>
   * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.pubsub.v1.Subscription.State getState() {
    @SuppressWarnings("deprecation")
    com.google.pubsub.v1.Subscription.State result =
        com.google.pubsub.v1.Subscription.State.valueOf(state_);
    return result == null ? com.google.pubsub.v1.Subscription.State.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, topic_);
    }
    if (pushConfig_ != null) {
      output.writeMessage(4, getPushConfig());
    }
    if (ackDeadlineSeconds_ != 0) {
      output.writeInt32(5, ackDeadlineSeconds_);
    }
    if (retainAckedMessages_ != false) {
      output.writeBool(7, retainAckedMessages_);
    }
    if (messageRetentionDuration_ != null) {
      output.writeMessage(8, getMessageRetentionDuration());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 9);
    if (enableMessageOrdering_ != false) {
      output.writeBool(10, enableMessageOrdering_);
    }
    if (expirationPolicy_ != null) {
      output.writeMessage(11, getExpirationPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, filter_);
    }
    if (deadLetterPolicy_ != null) {
      output.writeMessage(13, getDeadLetterPolicy());
    }
    if (retryPolicy_ != null) {
      output.writeMessage(14, getRetryPolicy());
    }
    if (detached_ != false) {
      output.writeBool(15, detached_);
    }
    if (enableExactlyOnceDelivery_ != false) {
      output.writeBool(16, enableExactlyOnceDelivery_);
    }
    if (topicMessageRetentionDuration_ != null) {
      output.writeMessage(17, getTopicMessageRetentionDuration());
    }
    if (bigqueryConfig_ != null) {
      output.writeMessage(18, getBigqueryConfig());
    }
    if (state_ != com.google.pubsub.v1.Subscription.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(19, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, topic_);
    }
    if (pushConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPushConfig());
    }
    if (ackDeadlineSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, ackDeadlineSeconds_);
    }
    if (retainAckedMessages_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, retainAckedMessages_);
    }
    if (messageRetentionDuration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, getMessageRetentionDuration());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, labels__);
    }
    if (enableMessageOrdering_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(10, enableMessageOrdering_);
    }
    if (expirationPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExpirationPolicy());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, filter_);
    }
    if (deadLetterPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getDeadLetterPolicy());
    }
    if (retryPolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getRetryPolicy());
    }
    if (detached_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, detached_);
    }
    if (enableExactlyOnceDelivery_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, enableExactlyOnceDelivery_);
    }
    if (topicMessageRetentionDuration_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getTopicMessageRetentionDuration());
    }
    if (bigqueryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getBigqueryConfig());
    }
    if (state_ != com.google.pubsub.v1.Subscription.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(19, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.Subscription)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.Subscription other = (com.google.pubsub.v1.Subscription) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTopic().equals(other.getTopic())) return false;
    if (hasPushConfig() != other.hasPushConfig()) return false;
    if (hasPushConfig()) {
      if (!getPushConfig().equals(other.getPushConfig())) return false;
    }
    if (hasBigqueryConfig() != other.hasBigqueryConfig()) return false;
    if (hasBigqueryConfig()) {
      if (!getBigqueryConfig().equals(other.getBigqueryConfig())) return false;
    }
    if (getAckDeadlineSeconds() != other.getAckDeadlineSeconds()) return false;
    if (getRetainAckedMessages() != other.getRetainAckedMessages()) return false;
    if (hasMessageRetentionDuration() != other.hasMessageRetentionDuration()) return false;
    if (hasMessageRetentionDuration()) {
      if (!getMessageRetentionDuration().equals(other.getMessageRetentionDuration())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getEnableMessageOrdering() != other.getEnableMessageOrdering()) return false;
    if (hasExpirationPolicy() != other.hasExpirationPolicy()) return false;
    if (hasExpirationPolicy()) {
      if (!getExpirationPolicy().equals(other.getExpirationPolicy())) return false;
    }
    if (!getFilter().equals(other.getFilter())) return false;
    if (hasDeadLetterPolicy() != other.hasDeadLetterPolicy()) return false;
    if (hasDeadLetterPolicy()) {
      if (!getDeadLetterPolicy().equals(other.getDeadLetterPolicy())) return false;
    }
    if (hasRetryPolicy() != other.hasRetryPolicy()) return false;
    if (hasRetryPolicy()) {
      if (!getRetryPolicy().equals(other.getRetryPolicy())) return false;
    }
    if (getDetached() != other.getDetached()) return false;
    if (getEnableExactlyOnceDelivery() != other.getEnableExactlyOnceDelivery()) return false;
    if (hasTopicMessageRetentionDuration() != other.hasTopicMessageRetentionDuration())
      return false;
    if (hasTopicMessageRetentionDuration()) {
      if (!getTopicMessageRetentionDuration().equals(other.getTopicMessageRetentionDuration()))
        return false;
    }
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTopic().hashCode();
    if (hasPushConfig()) {
      hash = (37 * hash) + PUSH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPushConfig().hashCode();
    }
    if (hasBigqueryConfig()) {
      hash = (37 * hash) + BIGQUERY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryConfig().hashCode();
    }
    hash = (37 * hash) + ACK_DEADLINE_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getAckDeadlineSeconds();
    hash = (37 * hash) + RETAIN_ACKED_MESSAGES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRetainAckedMessages());
    if (hasMessageRetentionDuration()) {
      hash = (37 * hash) + MESSAGE_RETENTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMessageRetentionDuration().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ENABLE_MESSAGE_ORDERING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableMessageOrdering());
    if (hasExpirationPolicy()) {
      hash = (37 * hash) + EXPIRATION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationPolicy().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (hasDeadLetterPolicy()) {
      hash = (37 * hash) + DEAD_LETTER_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDeadLetterPolicy().hashCode();
    }
    if (hasRetryPolicy()) {
      hash = (37 * hash) + RETRY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetryPolicy().hashCode();
    }
    hash = (37 * hash) + DETACHED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDetached());
    hash = (37 * hash) + ENABLE_EXACTLY_ONCE_DELIVERY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableExactlyOnceDelivery());
    if (hasTopicMessageRetentionDuration()) {
      hash = (37 * hash) + TOPIC_MESSAGE_RETENTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTopicMessageRetentionDuration().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.Subscription parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Subscription parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Subscription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.Subscription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A subscription resource.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.Subscription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.Subscription)
      com.google.pubsub.v1.SubscriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_Subscription_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_Subscription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.Subscription.class,
              com.google.pubsub.v1.Subscription.Builder.class);
    }

    // Construct using com.google.pubsub.v1.Subscription.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      topic_ = "";

      if (pushConfigBuilder_ == null) {
        pushConfig_ = null;
      } else {
        pushConfig_ = null;
        pushConfigBuilder_ = null;
      }
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfig_ = null;
      } else {
        bigqueryConfig_ = null;
        bigqueryConfigBuilder_ = null;
      }
      ackDeadlineSeconds_ = 0;

      retainAckedMessages_ = false;

      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDuration_ = null;
      } else {
        messageRetentionDuration_ = null;
        messageRetentionDurationBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      enableMessageOrdering_ = false;

      if (expirationPolicyBuilder_ == null) {
        expirationPolicy_ = null;
      } else {
        expirationPolicy_ = null;
        expirationPolicyBuilder_ = null;
      }
      filter_ = "";

      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicy_ = null;
      } else {
        deadLetterPolicy_ = null;
        deadLetterPolicyBuilder_ = null;
      }
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = null;
      } else {
        retryPolicy_ = null;
        retryPolicyBuilder_ = null;
      }
      detached_ = false;

      enableExactlyOnceDelivery_ = false;

      if (topicMessageRetentionDurationBuilder_ == null) {
        topicMessageRetentionDuration_ = null;
      } else {
        topicMessageRetentionDuration_ = null;
        topicMessageRetentionDurationBuilder_ = null;
      }
      state_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_Subscription_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Subscription getDefaultInstanceForType() {
      return com.google.pubsub.v1.Subscription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.Subscription build() {
      com.google.pubsub.v1.Subscription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.Subscription buildPartial() {
      com.google.pubsub.v1.Subscription result = new com.google.pubsub.v1.Subscription(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.topic_ = topic_;
      if (pushConfigBuilder_ == null) {
        result.pushConfig_ = pushConfig_;
      } else {
        result.pushConfig_ = pushConfigBuilder_.build();
      }
      if (bigqueryConfigBuilder_ == null) {
        result.bigqueryConfig_ = bigqueryConfig_;
      } else {
        result.bigqueryConfig_ = bigqueryConfigBuilder_.build();
      }
      result.ackDeadlineSeconds_ = ackDeadlineSeconds_;
      result.retainAckedMessages_ = retainAckedMessages_;
      if (messageRetentionDurationBuilder_ == null) {
        result.messageRetentionDuration_ = messageRetentionDuration_;
      } else {
        result.messageRetentionDuration_ = messageRetentionDurationBuilder_.build();
      }
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      result.enableMessageOrdering_ = enableMessageOrdering_;
      if (expirationPolicyBuilder_ == null) {
        result.expirationPolicy_ = expirationPolicy_;
      } else {
        result.expirationPolicy_ = expirationPolicyBuilder_.build();
      }
      result.filter_ = filter_;
      if (deadLetterPolicyBuilder_ == null) {
        result.deadLetterPolicy_ = deadLetterPolicy_;
      } else {
        result.deadLetterPolicy_ = deadLetterPolicyBuilder_.build();
      }
      if (retryPolicyBuilder_ == null) {
        result.retryPolicy_ = retryPolicy_;
      } else {
        result.retryPolicy_ = retryPolicyBuilder_.build();
      }
      result.detached_ = detached_;
      result.enableExactlyOnceDelivery_ = enableExactlyOnceDelivery_;
      if (topicMessageRetentionDurationBuilder_ == null) {
        result.topicMessageRetentionDuration_ = topicMessageRetentionDuration_;
      } else {
        result.topicMessageRetentionDuration_ = topicMessageRetentionDurationBuilder_.build();
      }
      result.state_ = state_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.Subscription) {
        return mergeFrom((com.google.pubsub.v1.Subscription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.Subscription other) {
      if (other == com.google.pubsub.v1.Subscription.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getTopic().isEmpty()) {
        topic_ = other.topic_;
        onChanged();
      }
      if (other.hasPushConfig()) {
        mergePushConfig(other.getPushConfig());
      }
      if (other.hasBigqueryConfig()) {
        mergeBigqueryConfig(other.getBigqueryConfig());
      }
      if (other.getAckDeadlineSeconds() != 0) {
        setAckDeadlineSeconds(other.getAckDeadlineSeconds());
      }
      if (other.getRetainAckedMessages() != false) {
        setRetainAckedMessages(other.getRetainAckedMessages());
      }
      if (other.hasMessageRetentionDuration()) {
        mergeMessageRetentionDuration(other.getMessageRetentionDuration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.getEnableMessageOrdering() != false) {
        setEnableMessageOrdering(other.getEnableMessageOrdering());
      }
      if (other.hasExpirationPolicy()) {
        mergeExpirationPolicy(other.getExpirationPolicy());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (other.hasDeadLetterPolicy()) {
        mergeDeadLetterPolicy(other.getDeadLetterPolicy());
      }
      if (other.hasRetryPolicy()) {
        mergeRetryPolicy(other.getRetryPolicy());
      }
      if (other.getDetached() != false) {
        setDetached(other.getDetached());
      }
      if (other.getEnableExactlyOnceDelivery() != false) {
        setEnableExactlyOnceDelivery(other.getEnableExactlyOnceDelivery());
      }
      if (other.hasTopicMessageRetentionDuration()) {
        mergeTopicMessageRetentionDuration(other.getTopicMessageRetentionDuration());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                topic_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 34:
              {
                input.readMessage(getPushConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                ackDeadlineSeconds_ = input.readInt32();

                break;
              } // case 40
            case 56:
              {
                retainAckedMessages_ = input.readBool();

                break;
              } // case 56
            case 66:
              {
                input.readMessage(
                    getMessageRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 74
            case 80:
              {
                enableMessageOrdering_ = input.readBool();

                break;
              } // case 80
            case 90:
              {
                input.readMessage(
                    getExpirationPolicyFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 98:
              {
                filter_ = input.readStringRequireUtf8();

                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getDeadLetterPolicyFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            case 114:
              {
                input.readMessage(getRetryPolicyFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            case 120:
              {
                detached_ = input.readBool();

                break;
              } // case 120
            case 128:
              {
                enableExactlyOnceDelivery_ = input.readBool();

                break;
              } // case 128
            case 138:
              {
                input.readMessage(
                    getTopicMessageRetentionDurationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 138
            case 146:
              {
                input.readMessage(getBigqueryConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 146
            case 152:
              {
                state_ = input.readEnum();

                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the subscription. It must have the format
     * `"projects/{project}/subscriptions/{subscription}"`. `{subscription}` must
     * start with a letter, and contain only letters (`[A-Za-z]`), numbers
     * (`[0-9]`), dashes (`-`), underscores (`_`), periods (`.`), tildes (`~`),
     * plus (`+`) or percent signs (`%`). It must be between 3 and 255 characters
     * in length, and it must not start with `"goog"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     * </pre>
     *
     * <code>
     * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     * </pre>
     *
     * <code>
     * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     * </pre>
     *
     * <code>
     * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      topic_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     * </pre>
     *
     * <code>
     * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopic() {

      topic_ = getDefaultInstance().getTopic();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the topic from which this subscription is receiving
     * messages. Format is `projects/{project}/topics/{topic}`. The value of this
     * field will be `_deleted-topic_` if the topic has been deleted.
     * </pre>
     *
     * <code>
     * string topic = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      topic_ = value;
      onChanged();
      return this;
    }

    private com.google.pubsub.v1.PushConfig pushConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig,
            com.google.pubsub.v1.PushConfig.Builder,
            com.google.pubsub.v1.PushConfigOrBuilder>
        pushConfigBuilder_;
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     *
     * @return Whether the pushConfig field is set.
     */
    public boolean hasPushConfig() {
      return pushConfigBuilder_ != null || pushConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     *
     * @return The pushConfig.
     */
    public com.google.pubsub.v1.PushConfig getPushConfig() {
      if (pushConfigBuilder_ == null) {
        return pushConfig_ == null
            ? com.google.pubsub.v1.PushConfig.getDefaultInstance()
            : pushConfig_;
      } else {
        return pushConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public Builder setPushConfig(com.google.pubsub.v1.PushConfig value) {
      if (pushConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pushConfig_ = value;
        onChanged();
      } else {
        pushConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public Builder setPushConfig(com.google.pubsub.v1.PushConfig.Builder builderForValue) {
      if (pushConfigBuilder_ == null) {
        pushConfig_ = builderForValue.build();
        onChanged();
      } else {
        pushConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public Builder mergePushConfig(com.google.pubsub.v1.PushConfig value) {
      if (pushConfigBuilder_ == null) {
        if (pushConfig_ != null) {
          pushConfig_ =
              com.google.pubsub.v1.PushConfig.newBuilder(pushConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pushConfig_ = value;
        }
        onChanged();
      } else {
        pushConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public Builder clearPushConfig() {
      if (pushConfigBuilder_ == null) {
        pushConfig_ = null;
        onChanged();
      } else {
        pushConfig_ = null;
        pushConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public com.google.pubsub.v1.PushConfig.Builder getPushConfigBuilder() {

      onChanged();
      return getPushConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    public com.google.pubsub.v1.PushConfigOrBuilder getPushConfigOrBuilder() {
      if (pushConfigBuilder_ != null) {
        return pushConfigBuilder_.getMessageOrBuilder();
      } else {
        return pushConfig_ == null
            ? com.google.pubsub.v1.PushConfig.getDefaultInstance()
            : pushConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * If push delivery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.PushConfig push_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.PushConfig,
            com.google.pubsub.v1.PushConfig.Builder,
            com.google.pubsub.v1.PushConfigOrBuilder>
        getPushConfigFieldBuilder() {
      if (pushConfigBuilder_ == null) {
        pushConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.PushConfig,
                com.google.pubsub.v1.PushConfig.Builder,
                com.google.pubsub.v1.PushConfigOrBuilder>(
                getPushConfig(), getParentForChildren(), isClean());
        pushConfig_ = null;
      }
      return pushConfigBuilder_;
    }

    private com.google.pubsub.v1.BigQueryConfig bigqueryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.BigQueryConfig,
            com.google.pubsub.v1.BigQueryConfig.Builder,
            com.google.pubsub.v1.BigQueryConfigOrBuilder>
        bigqueryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     *
     * @return Whether the bigqueryConfig field is set.
     */
    public boolean hasBigqueryConfig() {
      return bigqueryConfigBuilder_ != null || bigqueryConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     *
     * @return The bigqueryConfig.
     */
    public com.google.pubsub.v1.BigQueryConfig getBigqueryConfig() {
      if (bigqueryConfigBuilder_ == null) {
        return bigqueryConfig_ == null
            ? com.google.pubsub.v1.BigQueryConfig.getDefaultInstance()
            : bigqueryConfig_;
      } else {
        return bigqueryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public Builder setBigqueryConfig(com.google.pubsub.v1.BigQueryConfig value) {
      if (bigqueryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigqueryConfig_ = value;
        onChanged();
      } else {
        bigqueryConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public Builder setBigqueryConfig(com.google.pubsub.v1.BigQueryConfig.Builder builderForValue) {
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfig_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public Builder mergeBigqueryConfig(com.google.pubsub.v1.BigQueryConfig value) {
      if (bigqueryConfigBuilder_ == null) {
        if (bigqueryConfig_ != null) {
          bigqueryConfig_ =
              com.google.pubsub.v1.BigQueryConfig.newBuilder(bigqueryConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          bigqueryConfig_ = value;
        }
        onChanged();
      } else {
        bigqueryConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public Builder clearBigqueryConfig() {
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfig_ = null;
        onChanged();
      } else {
        bigqueryConfig_ = null;
        bigqueryConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public com.google.pubsub.v1.BigQueryConfig.Builder getBigqueryConfigBuilder() {

      onChanged();
      return getBigqueryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    public com.google.pubsub.v1.BigQueryConfigOrBuilder getBigqueryConfigOrBuilder() {
      if (bigqueryConfigBuilder_ != null) {
        return bigqueryConfigBuilder_.getMessageOrBuilder();
      } else {
        return bigqueryConfig_ == null
            ? com.google.pubsub.v1.BigQueryConfig.getDefaultInstance()
            : bigqueryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * If delivery to BigQuery is used with this subscription, this field is
     * used to configure it. Either `pushConfig` or `bigQueryConfig` can be set,
     * but not both. If both are empty, then the subscriber will pull and ack
     * messages using API methods.
     * </pre>
     *
     * <code>.google.pubsub.v1.BigQueryConfig bigquery_config = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.BigQueryConfig,
            com.google.pubsub.v1.BigQueryConfig.Builder,
            com.google.pubsub.v1.BigQueryConfigOrBuilder>
        getBigqueryConfigFieldBuilder() {
      if (bigqueryConfigBuilder_ == null) {
        bigqueryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.BigQueryConfig,
                com.google.pubsub.v1.BigQueryConfig.Builder,
                com.google.pubsub.v1.BigQueryConfigOrBuilder>(
                getBigqueryConfig(), getParentForChildren(), isClean());
        bigqueryConfig_ = null;
      }
      return bigqueryConfigBuilder_;
    }

    private int ackDeadlineSeconds_;
    /**
     *
     *
     * <pre>
     * The approximate amount of time (on a best-effort basis) Pub/Sub waits for
     * the subscriber to acknowledge receipt before resending the message. In the
     * interval after the message is delivered and before it is acknowledged, it
     * is considered to be &lt;i&gt;outstanding&lt;/i&gt;. During that time period, the
     * message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5;</code>
     *
     * @return The ackDeadlineSeconds.
     */
    @java.lang.Override
    public int getAckDeadlineSeconds() {
      return ackDeadlineSeconds_;
    }
    /**
     *
     *
     * <pre>
     * The approximate amount of time (on a best-effort basis) Pub/Sub waits for
     * the subscriber to acknowledge receipt before resending the message. In the
     * interval after the message is delivered and before it is acknowledged, it
     * is considered to be &lt;i&gt;outstanding&lt;/i&gt;. During that time period, the
     * message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5;</code>
     *
     * @param value The ackDeadlineSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setAckDeadlineSeconds(int value) {

      ackDeadlineSeconds_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The approximate amount of time (on a best-effort basis) Pub/Sub waits for
     * the subscriber to acknowledge receipt before resending the message. In the
     * interval after the message is delivered and before it is acknowledged, it
     * is considered to be &lt;i&gt;outstanding&lt;/i&gt;. During that time period, the
     * message will not be redelivered (on a best-effort basis).
     * For pull subscriptions, this value is used as the initial value for the ack
     * deadline. To override this value for a given message, call
     * `ModifyAckDeadline` with the corresponding `ack_id` if using
     * non-streaming pull or send the `ack_id` in a
     * `StreamingModifyAckDeadlineRequest` if using streaming pull.
     * The minimum custom deadline you can specify is 10 seconds.
     * The maximum custom deadline you can specify is 600 seconds (10 minutes).
     * If this parameter is 0, a default value of 10 seconds is used.
     * For push delivery, this value is also used to set the request timeout for
     * the call to the push endpoint.
     * If the subscriber never acknowledges the message, the Pub/Sub
     * system will eventually redeliver the message.
     * </pre>
     *
     * <code>int32 ack_deadline_seconds = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAckDeadlineSeconds() {

      ackDeadlineSeconds_ = 0;
      onChanged();
      return this;
    }

    private boolean retainAckedMessages_;
    /**
     *
     *
     * <pre>
     * Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7;</code>
     *
     * @return The retainAckedMessages.
     */
    @java.lang.Override
    public boolean getRetainAckedMessages() {
      return retainAckedMessages_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7;</code>
     *
     * @param value The retainAckedMessages to set.
     * @return This builder for chaining.
     */
    public Builder setRetainAckedMessages(boolean value) {

      retainAckedMessages_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether to retain acknowledged messages. If true, then
     * messages are not expunged from the subscription's backlog, even if they are
     * acknowledged, until they fall out of the `message_retention_duration`
     * window. This must be true if you would like to [`Seek` to a timestamp]
     * (https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time) in
     * the past to replay previously-acknowledged messages.
     * </pre>
     *
     * <code>bool retain_acked_messages = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetainAckedMessages() {

      retainAckedMessages_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration messageRetentionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        messageRetentionDurationBuilder_;
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     *
     * @return Whether the messageRetentionDuration field is set.
     */
    public boolean hasMessageRetentionDuration() {
      return messageRetentionDurationBuilder_ != null || messageRetentionDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     *
     * @return The messageRetentionDuration.
     */
    public com.google.protobuf.Duration getMessageRetentionDuration() {
      if (messageRetentionDurationBuilder_ == null) {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      } else {
        return messageRetentionDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public Builder setMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageRetentionDuration_ = value;
        onChanged();
      } else {
        messageRetentionDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public Builder setMessageRetentionDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDuration_ = builderForValue.build();
        onChanged();
      } else {
        messageRetentionDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public Builder mergeMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (messageRetentionDurationBuilder_ == null) {
        if (messageRetentionDuration_ != null) {
          messageRetentionDuration_ =
              com.google.protobuf.Duration.newBuilder(messageRetentionDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          messageRetentionDuration_ = value;
        }
        onChanged();
      } else {
        messageRetentionDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public Builder clearMessageRetentionDuration() {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDuration_ = null;
        onChanged();
      } else {
        messageRetentionDuration_ = null;
        messageRetentionDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getMessageRetentionDurationBuilder() {

      onChanged();
      return getMessageRetentionDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMessageRetentionDurationOrBuilder() {
      if (messageRetentionDurationBuilder_ != null) {
        return messageRetentionDurationBuilder_.getMessageOrBuilder();
      } else {
        return messageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : messageRetentionDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * How long to retain unacknowledged messages in the subscription's backlog,
     * from the moment a message is published.
     * If `retain_acked_messages` is true, then this also configures the retention
     * of acknowledged messages, and thus configures how far back in time a `Seek`
     * can be done. Defaults to 7 days. Cannot be more than 7 days or less than 10
     * minutes.
     * </pre>
     *
     * <code>.google.protobuf.Duration message_retention_duration = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMessageRetentionDurationFieldBuilder() {
      if (messageRetentionDurationBuilder_ == null) {
        messageRetentionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMessageRetentionDuration(), getParentForChildren(), isClean());
        messageRetentionDuration_ = null;
      }
      return messageRetentionDurationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * See &lt;a href="https://cloud.google.com/pubsub/docs/labels"&gt; Creating and
     * managing labels&lt;/a&gt;.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 9;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private boolean enableMessageOrdering_;
    /**
     *
     *
     * <pre>
     * If true, messages published with the same `ordering_key` in `PubsubMessage`
     * will be delivered to the subscribers in the order in which they
     * are received by the Pub/Sub system. Otherwise, they may be delivered in
     * any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10;</code>
     *
     * @return The enableMessageOrdering.
     */
    @java.lang.Override
    public boolean getEnableMessageOrdering() {
      return enableMessageOrdering_;
    }
    /**
     *
     *
     * <pre>
     * If true, messages published with the same `ordering_key` in `PubsubMessage`
     * will be delivered to the subscribers in the order in which they
     * are received by the Pub/Sub system. Otherwise, they may be delivered in
     * any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10;</code>
     *
     * @param value The enableMessageOrdering to set.
     * @return This builder for chaining.
     */
    public Builder setEnableMessageOrdering(boolean value) {

      enableMessageOrdering_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, messages published with the same `ordering_key` in `PubsubMessage`
     * will be delivered to the subscribers in the order in which they
     * are received by the Pub/Sub system. Otherwise, they may be delivered in
     * any order.
     * </pre>
     *
     * <code>bool enable_message_ordering = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableMessageOrdering() {

      enableMessageOrdering_ = false;
      onChanged();
      return this;
    }

    private com.google.pubsub.v1.ExpirationPolicy expirationPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.ExpirationPolicy,
            com.google.pubsub.v1.ExpirationPolicy.Builder,
            com.google.pubsub.v1.ExpirationPolicyOrBuilder>
        expirationPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     *
     * @return Whether the expirationPolicy field is set.
     */
    public boolean hasExpirationPolicy() {
      return expirationPolicyBuilder_ != null || expirationPolicy_ != null;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     *
     * @return The expirationPolicy.
     */
    public com.google.pubsub.v1.ExpirationPolicy getExpirationPolicy() {
      if (expirationPolicyBuilder_ == null) {
        return expirationPolicy_ == null
            ? com.google.pubsub.v1.ExpirationPolicy.getDefaultInstance()
            : expirationPolicy_;
      } else {
        return expirationPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public Builder setExpirationPolicy(com.google.pubsub.v1.ExpirationPolicy value) {
      if (expirationPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expirationPolicy_ = value;
        onChanged();
      } else {
        expirationPolicyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public Builder setExpirationPolicy(
        com.google.pubsub.v1.ExpirationPolicy.Builder builderForValue) {
      if (expirationPolicyBuilder_ == null) {
        expirationPolicy_ = builderForValue.build();
        onChanged();
      } else {
        expirationPolicyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public Builder mergeExpirationPolicy(com.google.pubsub.v1.ExpirationPolicy value) {
      if (expirationPolicyBuilder_ == null) {
        if (expirationPolicy_ != null) {
          expirationPolicy_ =
              com.google.pubsub.v1.ExpirationPolicy.newBuilder(expirationPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expirationPolicy_ = value;
        }
        onChanged();
      } else {
        expirationPolicyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public Builder clearExpirationPolicy() {
      if (expirationPolicyBuilder_ == null) {
        expirationPolicy_ = null;
        onChanged();
      } else {
        expirationPolicy_ = null;
        expirationPolicyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public com.google.pubsub.v1.ExpirationPolicy.Builder getExpirationPolicyBuilder() {

      onChanged();
      return getExpirationPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    public com.google.pubsub.v1.ExpirationPolicyOrBuilder getExpirationPolicyOrBuilder() {
      if (expirationPolicyBuilder_ != null) {
        return expirationPolicyBuilder_.getMessageOrBuilder();
      } else {
        return expirationPolicy_ == null
            ? com.google.pubsub.v1.ExpirationPolicy.getDefaultInstance()
            : expirationPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for this subscription's expiration.
     * A subscription is considered active as long as any connected subscriber is
     * successfully consuming messages from the subscription or is issuing
     * operations on the subscription. If `expiration_policy` is not set, a
     * *default policy* with `ttl` of 31 days will be used. The minimum allowed
     * value for `expiration_policy.ttl` is 1 day.
     * </pre>
     *
     * <code>.google.pubsub.v1.ExpirationPolicy expiration_policy = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.ExpirationPolicy,
            com.google.pubsub.v1.ExpirationPolicy.Builder,
            com.google.pubsub.v1.ExpirationPolicyOrBuilder>
        getExpirationPolicyFieldBuilder() {
      if (expirationPolicyBuilder_ == null) {
        expirationPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.ExpirationPolicy,
                com.google.pubsub.v1.ExpirationPolicy.Builder,
                com.google.pubsub.v1.ExpirationPolicyOrBuilder>(
                getExpirationPolicy(), getParentForChildren(), isClean());
        expirationPolicy_ = null;
      }
      return expirationPolicyBuilder_;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression written in the Pub/Sub [filter
     * language](https://cloud.google.com/pubsub/docs/filtering). If non-empty,
     * then only `PubsubMessage`s whose `attributes` field matches the filter are
     * delivered on this subscription. If empty, then no messages are filtered
     * out.
     * </pre>
     *
     * <code>string filter = 12;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private com.google.pubsub.v1.DeadLetterPolicy deadLetterPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.DeadLetterPolicy,
            com.google.pubsub.v1.DeadLetterPolicy.Builder,
            com.google.pubsub.v1.DeadLetterPolicyOrBuilder>
        deadLetterPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     *
     * @return Whether the deadLetterPolicy field is set.
     */
    public boolean hasDeadLetterPolicy() {
      return deadLetterPolicyBuilder_ != null || deadLetterPolicy_ != null;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     *
     * @return The deadLetterPolicy.
     */
    public com.google.pubsub.v1.DeadLetterPolicy getDeadLetterPolicy() {
      if (deadLetterPolicyBuilder_ == null) {
        return deadLetterPolicy_ == null
            ? com.google.pubsub.v1.DeadLetterPolicy.getDefaultInstance()
            : deadLetterPolicy_;
      } else {
        return deadLetterPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public Builder setDeadLetterPolicy(com.google.pubsub.v1.DeadLetterPolicy value) {
      if (deadLetterPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deadLetterPolicy_ = value;
        onChanged();
      } else {
        deadLetterPolicyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public Builder setDeadLetterPolicy(
        com.google.pubsub.v1.DeadLetterPolicy.Builder builderForValue) {
      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicy_ = builderForValue.build();
        onChanged();
      } else {
        deadLetterPolicyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public Builder mergeDeadLetterPolicy(com.google.pubsub.v1.DeadLetterPolicy value) {
      if (deadLetterPolicyBuilder_ == null) {
        if (deadLetterPolicy_ != null) {
          deadLetterPolicy_ =
              com.google.pubsub.v1.DeadLetterPolicy.newBuilder(deadLetterPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deadLetterPolicy_ = value;
        }
        onChanged();
      } else {
        deadLetterPolicyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public Builder clearDeadLetterPolicy() {
      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicy_ = null;
        onChanged();
      } else {
        deadLetterPolicy_ = null;
        deadLetterPolicyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public com.google.pubsub.v1.DeadLetterPolicy.Builder getDeadLetterPolicyBuilder() {

      onChanged();
      return getDeadLetterPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    public com.google.pubsub.v1.DeadLetterPolicyOrBuilder getDeadLetterPolicyOrBuilder() {
      if (deadLetterPolicyBuilder_ != null) {
        return deadLetterPolicyBuilder_.getMessageOrBuilder();
      } else {
        return deadLetterPolicy_ == null
            ? com.google.pubsub.v1.DeadLetterPolicy.getDefaultInstance()
            : deadLetterPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies the conditions for dead lettering messages in
     * this subscription. If dead_letter_policy is not set, dead lettering
     * is disabled.
     * The Cloud Pub/Sub service account associated with this subscriptions's
     * parent project (i.e.,
     * service-{project_number}&#64;gcp-sa-pubsub.iam.gserviceaccount.com) must have
     * permission to Acknowledge() messages on this subscription.
     * </pre>
     *
     * <code>.google.pubsub.v1.DeadLetterPolicy dead_letter_policy = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.DeadLetterPolicy,
            com.google.pubsub.v1.DeadLetterPolicy.Builder,
            com.google.pubsub.v1.DeadLetterPolicyOrBuilder>
        getDeadLetterPolicyFieldBuilder() {
      if (deadLetterPolicyBuilder_ == null) {
        deadLetterPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.DeadLetterPolicy,
                com.google.pubsub.v1.DeadLetterPolicy.Builder,
                com.google.pubsub.v1.DeadLetterPolicyOrBuilder>(
                getDeadLetterPolicy(), getParentForChildren(), isClean());
        deadLetterPolicy_ = null;
      }
      return deadLetterPolicyBuilder_;
    }

    private com.google.pubsub.v1.RetryPolicy retryPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.RetryPolicy,
            com.google.pubsub.v1.RetryPolicy.Builder,
            com.google.pubsub.v1.RetryPolicyOrBuilder>
        retryPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     *
     * @return Whether the retryPolicy field is set.
     */
    public boolean hasRetryPolicy() {
      return retryPolicyBuilder_ != null || retryPolicy_ != null;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     *
     * @return The retryPolicy.
     */
    public com.google.pubsub.v1.RetryPolicy getRetryPolicy() {
      if (retryPolicyBuilder_ == null) {
        return retryPolicy_ == null
            ? com.google.pubsub.v1.RetryPolicy.getDefaultInstance()
            : retryPolicy_;
      } else {
        return retryPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public Builder setRetryPolicy(com.google.pubsub.v1.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryPolicy_ = value;
        onChanged();
      } else {
        retryPolicyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public Builder setRetryPolicy(com.google.pubsub.v1.RetryPolicy.Builder builderForValue) {
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = builderForValue.build();
        onChanged();
      } else {
        retryPolicyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public Builder mergeRetryPolicy(com.google.pubsub.v1.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (retryPolicy_ != null) {
          retryPolicy_ =
              com.google.pubsub.v1.RetryPolicy.newBuilder(retryPolicy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          retryPolicy_ = value;
        }
        onChanged();
      } else {
        retryPolicyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public Builder clearRetryPolicy() {
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = null;
        onChanged();
      } else {
        retryPolicy_ = null;
        retryPolicyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public com.google.pubsub.v1.RetryPolicy.Builder getRetryPolicyBuilder() {

      onChanged();
      return getRetryPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    public com.google.pubsub.v1.RetryPolicyOrBuilder getRetryPolicyOrBuilder() {
      if (retryPolicyBuilder_ != null) {
        return retryPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retryPolicy_ == null
            ? com.google.pubsub.v1.RetryPolicy.getDefaultInstance()
            : retryPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * A policy that specifies how Pub/Sub retries message delivery for this
     * subscription.
     * If not set, the default retry policy is applied. This generally implies
     * that messages will be retried as soon as possible for healthy subscribers.
     * RetryPolicy will be triggered on NACKs or acknowledgement deadline
     * exceeded events for a given message.
     * </pre>
     *
     * <code>.google.pubsub.v1.RetryPolicy retry_policy = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.pubsub.v1.RetryPolicy,
            com.google.pubsub.v1.RetryPolicy.Builder,
            com.google.pubsub.v1.RetryPolicyOrBuilder>
        getRetryPolicyFieldBuilder() {
      if (retryPolicyBuilder_ == null) {
        retryPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.pubsub.v1.RetryPolicy,
                com.google.pubsub.v1.RetryPolicy.Builder,
                com.google.pubsub.v1.RetryPolicyOrBuilder>(
                getRetryPolicy(), getParentForChildren(), isClean());
        retryPolicy_ = null;
      }
      return retryPolicyBuilder_;
    }

    private boolean detached_;
    /**
     *
     *
     * <pre>
     * Indicates whether the subscription is detached from its topic. Detached
     * subscriptions don't receive messages from their topic and don't retain any
     * backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15;</code>
     *
     * @return The detached.
     */
    @java.lang.Override
    public boolean getDetached() {
      return detached_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the subscription is detached from its topic. Detached
     * subscriptions don't receive messages from their topic and don't retain any
     * backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15;</code>
     *
     * @param value The detached to set.
     * @return This builder for chaining.
     */
    public Builder setDetached(boolean value) {

      detached_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the subscription is detached from its topic. Detached
     * subscriptions don't receive messages from their topic and don't retain any
     * backlog. `Pull` and `StreamingPull` requests will return
     * FAILED_PRECONDITION. If the subscription is a push subscription, pushes to
     * the endpoint will not be made.
     * </pre>
     *
     * <code>bool detached = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDetached() {

      detached_ = false;
      onChanged();
      return this;
    }

    private boolean enableExactlyOnceDelivery_;
    /**
     *
     *
     * <pre>
     * If true, Pub/Sub provides the following guarantees for the delivery of
     * a message with a given value of `message_id` on this subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16;</code>
     *
     * @return The enableExactlyOnceDelivery.
     */
    @java.lang.Override
    public boolean getEnableExactlyOnceDelivery() {
      return enableExactlyOnceDelivery_;
    }
    /**
     *
     *
     * <pre>
     * If true, Pub/Sub provides the following guarantees for the delivery of
     * a message with a given value of `message_id` on this subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16;</code>
     *
     * @param value The enableExactlyOnceDelivery to set.
     * @return This builder for chaining.
     */
    public Builder setEnableExactlyOnceDelivery(boolean value) {

      enableExactlyOnceDelivery_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, Pub/Sub provides the following guarantees for the delivery of
     * a message with a given value of `message_id` on this subscription:
     * * The message sent to a subscriber is guaranteed not to be resent
     * before the message's acknowledgement deadline expires.
     * * An acknowledged message will not be resent to a subscriber.
     * Note that subscribers may still receive multiple copies of a message
     * when `enable_exactly_once_delivery` is true if the message was published
     * multiple times by a publisher client. These copies are  considered distinct
     * by Pub/Sub and have distinct `message_id` values.
     * </pre>
     *
     * <code>bool enable_exactly_once_delivery = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableExactlyOnceDelivery() {

      enableExactlyOnceDelivery_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration topicMessageRetentionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        topicMessageRetentionDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the topicMessageRetentionDuration field is set.
     */
    public boolean hasTopicMessageRetentionDuration() {
      return topicMessageRetentionDurationBuilder_ != null
          || topicMessageRetentionDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The topicMessageRetentionDuration.
     */
    public com.google.protobuf.Duration getTopicMessageRetentionDuration() {
      if (topicMessageRetentionDurationBuilder_ == null) {
        return topicMessageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : topicMessageRetentionDuration_;
      } else {
        return topicMessageRetentionDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTopicMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (topicMessageRetentionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        topicMessageRetentionDuration_ = value;
        onChanged();
      } else {
        topicMessageRetentionDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTopicMessageRetentionDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (topicMessageRetentionDurationBuilder_ == null) {
        topicMessageRetentionDuration_ = builderForValue.build();
        onChanged();
      } else {
        topicMessageRetentionDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTopicMessageRetentionDuration(com.google.protobuf.Duration value) {
      if (topicMessageRetentionDurationBuilder_ == null) {
        if (topicMessageRetentionDuration_ != null) {
          topicMessageRetentionDuration_ =
              com.google.protobuf.Duration.newBuilder(topicMessageRetentionDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          topicMessageRetentionDuration_ = value;
        }
        onChanged();
      } else {
        topicMessageRetentionDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTopicMessageRetentionDuration() {
      if (topicMessageRetentionDurationBuilder_ == null) {
        topicMessageRetentionDuration_ = null;
        onChanged();
      } else {
        topicMessageRetentionDuration_ = null;
        topicMessageRetentionDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getTopicMessageRetentionDurationBuilder() {

      onChanged();
      return getTopicMessageRetentionDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getTopicMessageRetentionDurationOrBuilder() {
      if (topicMessageRetentionDurationBuilder_ != null) {
        return topicMessageRetentionDurationBuilder_.getMessageOrBuilder();
      } else {
        return topicMessageRetentionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : topicMessageRetentionDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the minimum duration for which a message is retained
     * after it is published to the subscription's topic. If this field is set,
     * messages published to the subscription's topic in the last
     * `topic_message_retention_duration` are always available to subscribers. See
     * the `message_retention_duration` field in `Topic`. This field is set only
     * in responses from the server; it is ignored if it is set in any requests.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration topic_message_retention_duration = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTopicMessageRetentionDurationFieldBuilder() {
      if (topicMessageRetentionDurationBuilder_ == null) {
        topicMessageRetentionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTopicMessageRetentionDuration(), getParentForChildren(), isClean());
        topicMessageRetentionDuration_ = null;
      }
      return topicMessageRetentionDurationBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.pubsub.v1.Subscription.State getState() {
      @SuppressWarnings("deprecation")
      com.google.pubsub.v1.Subscription.State result =
          com.google.pubsub.v1.Subscription.State.valueOf(state_);
      return result == null ? com.google.pubsub.v1.Subscription.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.pubsub.v1.Subscription.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An output-only field indicating whether or not the
     * subscription can receive messages.
     * </pre>
     *
     * <code>
     * .google.pubsub.v1.Subscription.State state = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.Subscription)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.Subscription)
  private static final com.google.pubsub.v1.Subscription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.Subscription();
  }

  public static com.google.pubsub.v1.Subscription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Subscription> PARSER =
      new com.google.protobuf.AbstractParser<Subscription>() {
        @java.lang.Override
        public Subscription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Subscription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Subscription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.Subscription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
