/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/pubsub/v1/pubsub.proto

// Protobuf Java Version: 3.25.8
package com.google.pubsub.v1;

/**
 *
 *
 * <pre>
 * User-defined JavaScript function that can transform or filter a Pub/Sub
 * message.
 * </pre>
 *
 * Protobuf type {@code google.pubsub.v1.JavaScriptUDF}
 */
public final class JavaScriptUDF extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.pubsub.v1.JavaScriptUDF)
    JavaScriptUDFOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use JavaScriptUDF.newBuilder() to construct.
  private JavaScriptUDF(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JavaScriptUDF() {
    functionName_ = "";
    code_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JavaScriptUDF();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_JavaScriptUDF_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.pubsub.v1.PubsubProto
        .internal_static_google_pubsub_v1_JavaScriptUDF_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.pubsub.v1.JavaScriptUDF.class,
            com.google.pubsub.v1.JavaScriptUDF.Builder.class);
  }

  public static final int FUNCTION_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object functionName_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the JavasScript function that should applied to Pub/Sub
   * messages.
   * </pre>
   *
   * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The functionName.
   */
  @java.lang.Override
  public java.lang.String getFunctionName() {
    java.lang.Object ref = functionName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      functionName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the JavasScript function that should applied to Pub/Sub
   * messages.
   * </pre>
   *
   * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for functionName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFunctionNameBytes() {
    java.lang.Object ref = functionName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      functionName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object code_ = "";

  /**
   *
   *
   * <pre>
   * Required. JavaScript code that contains a function `function_name` with the
   * below signature:
   *
   * ```
   *   /&#42;*
   *   * Transforms a Pub/Sub message.
   *
   *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
   *   * filter a message, return `null`. To transform a message return a map
   *   * with the following keys:
   *   *   - (required) 'data' : {string}
   *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
   *   * Returning empty `attributes` will remove all attributes from the
   *   * message.
   *   *
   *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
   *   * message. Keys:
   *   *   - (required) 'data' : {string}
   *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
   *   *
   *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
   *   * Keys:
   *   *   - (optional) 'message_id'  : {string}
   *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
   *   *   - (optional) 'ordering_key': {string}
   *   *&#47;
   *
   *   function &lt;function_name&gt;(message, metadata) {
   *   }
   * ```
   * </pre>
   *
   * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. JavaScript code that contains a function `function_name` with the
   * below signature:
   *
   * ```
   *   /&#42;*
   *   * Transforms a Pub/Sub message.
   *
   *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
   *   * filter a message, return `null`. To transform a message return a map
   *   * with the following keys:
   *   *   - (required) 'data' : {string}
   *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
   *   * Returning empty `attributes` will remove all attributes from the
   *   * message.
   *   *
   *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
   *   * message. Keys:
   *   *   - (required) 'data' : {string}
   *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
   *   *
   *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
   *   * Keys:
   *   *   - (optional) 'message_id'  : {string}
   *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
   *   *   - (optional) 'ordering_key': {string}
   *   *&#47;
   *
   *   function &lt;function_name&gt;(message, metadata) {
   *   }
   * ```
   * </pre>
   *
   * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for code.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(functionName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, functionName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, code_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(functionName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, functionName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, code_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.pubsub.v1.JavaScriptUDF)) {
      return super.equals(obj);
    }
    com.google.pubsub.v1.JavaScriptUDF other = (com.google.pubsub.v1.JavaScriptUDF) obj;

    if (!getFunctionName().equals(other.getFunctionName())) return false;
    if (!getCode().equals(other.getCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FUNCTION_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFunctionName().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.pubsub.v1.JavaScriptUDF parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.pubsub.v1.JavaScriptUDF prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * User-defined JavaScript function that can transform or filter a Pub/Sub
   * message.
   * </pre>
   *
   * Protobuf type {@code google.pubsub.v1.JavaScriptUDF}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.pubsub.v1.JavaScriptUDF)
      com.google.pubsub.v1.JavaScriptUDFOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_JavaScriptUDF_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_JavaScriptUDF_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.pubsub.v1.JavaScriptUDF.class,
              com.google.pubsub.v1.JavaScriptUDF.Builder.class);
    }

    // Construct using com.google.pubsub.v1.JavaScriptUDF.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      functionName_ = "";
      code_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.pubsub.v1.PubsubProto
          .internal_static_google_pubsub_v1_JavaScriptUDF_descriptor;
    }

    @java.lang.Override
    public com.google.pubsub.v1.JavaScriptUDF getDefaultInstanceForType() {
      return com.google.pubsub.v1.JavaScriptUDF.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.pubsub.v1.JavaScriptUDF build() {
      com.google.pubsub.v1.JavaScriptUDF result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.pubsub.v1.JavaScriptUDF buildPartial() {
      com.google.pubsub.v1.JavaScriptUDF result = new com.google.pubsub.v1.JavaScriptUDF(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.pubsub.v1.JavaScriptUDF result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.functionName_ = functionName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.code_ = code_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.pubsub.v1.JavaScriptUDF) {
        return mergeFrom((com.google.pubsub.v1.JavaScriptUDF) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.pubsub.v1.JavaScriptUDF other) {
      if (other == com.google.pubsub.v1.JavaScriptUDF.getDefaultInstance()) return this;
      if (!other.getFunctionName().isEmpty()) {
        functionName_ = other.functionName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCode().isEmpty()) {
        code_ = other.code_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                functionName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                code_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object functionName_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the JavasScript function that should applied to Pub/Sub
     * messages.
     * </pre>
     *
     * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The functionName.
     */
    public java.lang.String getFunctionName() {
      java.lang.Object ref = functionName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        functionName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the JavasScript function that should applied to Pub/Sub
     * messages.
     * </pre>
     *
     * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for functionName.
     */
    public com.google.protobuf.ByteString getFunctionNameBytes() {
      java.lang.Object ref = functionName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        functionName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the JavasScript function that should applied to Pub/Sub
     * messages.
     * </pre>
     *
     * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The functionName to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      functionName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the JavasScript function that should applied to Pub/Sub
     * messages.
     * </pre>
     *
     * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFunctionName() {
      functionName_ = getDefaultInstance().getFunctionName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the JavasScript function that should applied to Pub/Sub
     * messages.
     * </pre>
     *
     * <code>string function_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for functionName to set.
     * @return This builder for chaining.
     */
    public Builder setFunctionNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      functionName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object code_ = "";

    /**
     *
     *
     * <pre>
     * Required. JavaScript code that contains a function `function_name` with the
     * below signature:
     *
     * ```
     *   /&#42;*
     *   * Transforms a Pub/Sub message.
     *
     *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
     *   * filter a message, return `null`. To transform a message return a map
     *   * with the following keys:
     *   *   - (required) 'data' : {string}
     *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
     *   * Returning empty `attributes` will remove all attributes from the
     *   * message.
     *   *
     *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
     *   * message. Keys:
     *   *   - (required) 'data' : {string}
     *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
     *   *
     *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
     *   * Keys:
     *   *   - (optional) 'message_id'  : {string}
     *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
     *   *   - (optional) 'ordering_key': {string}
     *   *&#47;
     *
     *   function &lt;function_name&gt;(message, metadata) {
     *   }
     * ```
     * </pre>
     *
     * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The code.
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. JavaScript code that contains a function `function_name` with the
     * below signature:
     *
     * ```
     *   /&#42;*
     *   * Transforms a Pub/Sub message.
     *
     *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
     *   * filter a message, return `null`. To transform a message return a map
     *   * with the following keys:
     *   *   - (required) 'data' : {string}
     *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
     *   * Returning empty `attributes` will remove all attributes from the
     *   * message.
     *   *
     *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
     *   * message. Keys:
     *   *   - (required) 'data' : {string}
     *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
     *   *
     *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
     *   * Keys:
     *   *   - (optional) 'message_id'  : {string}
     *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
     *   *   - (optional) 'ordering_key': {string}
     *   *&#47;
     *
     *   function &lt;function_name&gt;(message, metadata) {
     *   }
     * ```
     * </pre>
     *
     * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for code.
     */
    public com.google.protobuf.ByteString getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. JavaScript code that contains a function `function_name` with the
     * below signature:
     *
     * ```
     *   /&#42;*
     *   * Transforms a Pub/Sub message.
     *
     *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
     *   * filter a message, return `null`. To transform a message return a map
     *   * with the following keys:
     *   *   - (required) 'data' : {string}
     *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
     *   * Returning empty `attributes` will remove all attributes from the
     *   * message.
     *   *
     *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
     *   * message. Keys:
     *   *   - (required) 'data' : {string}
     *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
     *   *
     *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
     *   * Keys:
     *   *   - (optional) 'message_id'  : {string}
     *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
     *   *   - (optional) 'ordering_key': {string}
     *   *&#47;
     *
     *   function &lt;function_name&gt;(message, metadata) {
     *   }
     * ```
     * </pre>
     *
     * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      code_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. JavaScript code that contains a function `function_name` with the
     * below signature:
     *
     * ```
     *   /&#42;*
     *   * Transforms a Pub/Sub message.
     *
     *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
     *   * filter a message, return `null`. To transform a message return a map
     *   * with the following keys:
     *   *   - (required) 'data' : {string}
     *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
     *   * Returning empty `attributes` will remove all attributes from the
     *   * message.
     *   *
     *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
     *   * message. Keys:
     *   *   - (required) 'data' : {string}
     *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
     *   *
     *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
     *   * Keys:
     *   *   - (optional) 'message_id'  : {string}
     *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
     *   *   - (optional) 'ordering_key': {string}
     *   *&#47;
     *
     *   function &lt;function_name&gt;(message, metadata) {
     *   }
     * ```
     * </pre>
     *
     * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      code_ = getDefaultInstance().getCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. JavaScript code that contains a function `function_name` with the
     * below signature:
     *
     * ```
     *   /&#42;*
     *   * Transforms a Pub/Sub message.
     *
     *   * &#64;return {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;|null)} - To
     *   * filter a message, return `null`. To transform a message return a map
     *   * with the following keys:
     *   *   - (required) 'data' : {string}
     *   *   - (optional) 'attributes' : {Object&lt;string, string&gt;}
     *   * Returning empty `attributes` will remove all attributes from the
     *   * message.
     *   *
     *   * &#64;param  {(Object&lt;string, (string | Object&lt;string, string&gt;)&gt;} Pub/Sub
     *   * message. Keys:
     *   *   - (required) 'data' : {string}
     *   *   - (required) 'attributes' : {Object&lt;string, string&gt;}
     *   *
     *   * &#64;param  {Object&lt;string, any&gt;} metadata - Pub/Sub message metadata.
     *   * Keys:
     *   *   - (optional) 'message_id'  : {string}
     *   *   - (optional) 'publish_time': {string} YYYY-MM-DDTHH:MM:SSZ format
     *   *   - (optional) 'ordering_key': {string}
     *   *&#47;
     *
     *   function &lt;function_name&gt;(message, metadata) {
     *   }
     * ```
     * </pre>
     *
     * <code>string code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      code_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.pubsub.v1.JavaScriptUDF)
  }

  // @@protoc_insertion_point(class_scope:google.pubsub.v1.JavaScriptUDF)
  private static final com.google.pubsub.v1.JavaScriptUDF DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.pubsub.v1.JavaScriptUDF();
  }

  public static com.google.pubsub.v1.JavaScriptUDF getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JavaScriptUDF> PARSER =
      new com.google.protobuf.AbstractParser<JavaScriptUDF>() {
        @java.lang.Override
        public JavaScriptUDF parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JavaScriptUDF> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JavaScriptUDF> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.pubsub.v1.JavaScriptUDF getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
