/*
 * Decompiled with CFR 0.152.
 */
package com.google.recaptchaenterprise.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FirewallPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_FIREWALLPOLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/firewallpolicies/{firewallpolicy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String firewallpolicy;

    @Deprecated
    protected FirewallPolicyName() {
        this.project = null;
        this.firewallpolicy = null;
    }

    private FirewallPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.firewallpolicy = (String)Preconditions.checkNotNull((Object)builder.getFirewallpolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getFirewallpolicy() {
        return this.firewallpolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FirewallPolicyName of(String project, String firewallpolicy) {
        return FirewallPolicyName.newBuilder().setProject(project).setFirewallpolicy(firewallpolicy).build();
    }

    public static String format(String project, String firewallpolicy) {
        return FirewallPolicyName.newBuilder().setProject(project).setFirewallpolicy(firewallpolicy).build().toString();
    }

    public static FirewallPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_FIREWALLPOLICY.validatedMatch(formattedString, "FirewallPolicyName.parse: formattedString not in valid format");
        return FirewallPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("firewallpolicy"));
    }

    public static List<FirewallPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<FirewallPolicyName> list = new ArrayList<FirewallPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FirewallPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FirewallPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FirewallPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_FIREWALLPOLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FirewallPolicyName firewallPolicyName = this;
            synchronized (firewallPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.firewallpolicy != null) {
                        fieldMapBuilder.put((Object)"firewallpolicy", (Object)this.firewallpolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_FIREWALLPOLICY.instantiate(new String[]{"project", this.project, "firewallpolicy", this.firewallpolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FirewallPolicyName that = (FirewallPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.firewallpolicy, that.firewallpolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.firewallpolicy);
    }

    public static class Builder {
        private String project;
        private String firewallpolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getFirewallpolicy() {
            return this.firewallpolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setFirewallpolicy(String firewallpolicy) {
            this.firewallpolicy = firewallpolicy;
            return this;
        }

        private Builder(FirewallPolicyName firewallPolicyName) {
            this.project = firewallPolicyName.project;
            this.firewallpolicy = firewallPolicyName.firewallpolicy;
        }

        public FirewallPolicyName build() {
            return new FirewallPolicyName(this);
        }
    }
}

