/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/job.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Job represents the configuration of a single job, which references a
 * container image that is run to completion.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    name_ = "";
    uid_ = "";
    creator_ = "";
    lastModifier_ = "";
    client_ = "";
    clientVersion_ = "";
    launchStage_ = 0;
    conditions_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.JobProto.internal_static_google_cloud_run_v2_Job_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 5:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.JobProto
        .internal_static_google_cloud_run_v2_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Job.class, com.google.cloud.run.v2.Job.Builder.class);
  }

  private int bitField0_;
  private int createExecutionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object createExecution_;

  public enum CreateExecutionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    START_EXECUTION_TOKEN(26),
    RUN_EXECUTION_TOKEN(27),
    CREATEEXECUTION_NOT_SET(0);
    private final int value;

    private CreateExecutionCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CreateExecutionCase valueOf(int value) {
      return forNumber(value);
    }

    public static CreateExecutionCase forNumber(int value) {
      switch (value) {
        case 26:
          return START_EXECUTION_TOKEN;
        case 27:
          return RUN_EXECUTION_TOKEN;
        case 0:
          return CREATEEXECUTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CreateExecutionCase getCreateExecutionCase() {
    return CreateExecutionCase.forNumber(createExecutionCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The fully qualified name of this Job.
   *
   * Format:
   * projects/{project}/locations/{location}/jobs/{job}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The fully qualified name of this Job.
   *
   * Format:
   * projects/{project}/locations/{location}/jobs/{job}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Execution. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Server assigned unique identifier for the Execution. The value
   * is a UUID4 string and guaranteed to remain unchanged until the resource is
   * deleted.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 3;
  private long generation_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. A number that monotonically increases every time the user
   * modifies the desired state.
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.JobProto
                .internal_static_google_cloud_run_v2_Job_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that can be used to organize and categorize
   * objects.
   * User-provided labels are shared with Google's billing system, so they can
   * be used to filter, or break down billing charges by team, component,
   * environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 Job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.JobProto
                .internal_static_google_cloud_run_v2_Job_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected on new resources. All system
   * annotations in v1 now have a corresponding field in v2 Job.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected on new resources. All system
   * annotations in v1 now have a corresponding field in v2 Job.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected on new resources. All system
   * annotations in v1 now have a corresponding field in v2 Job.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Unstructured key value map that may
   * be set by external tools to store and arbitrary metadata.
   * They are not queryable and should be preserved
   * when modifying objects.
   *
   * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected on new resources. All system
   * annotations in v1 now have a corresponding field in v2 Job.
   *
   * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The last-modified time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The deletion time. It is only populated as a response to a
   * Delete request.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp expireTime_;

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. For a deleted resource, the time after which it will be
   * permamently deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int CREATOR_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Email address of the authenticated creator.
   * </pre>
   *
   * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_MODIFIER_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object lastModifier_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The lastModifier.
   */
  @java.lang.Override
  public java.lang.String getLastModifier() {
    java.lang.Object ref = lastModifier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      lastModifier_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Email address of the last authenticated modifier.
   * </pre>
   *
   * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for lastModifier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastModifierBytes() {
    java.lang.Object ref = lastModifier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      lastModifier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object client_ = "";

  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 12;</code>
   *
   * @return The client.
   */
  @java.lang.Override
  public java.lang.String getClient() {
    java.lang.Object ref = client_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      client_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Arbitrary identifier for the API client.
   * </pre>
   *
   * <code>string client = 12;</code>
   *
   * @return The bytes for client.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientBytes() {
    java.lang.Object ref = client_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      client_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_VERSION_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientVersion_ = "";

  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 13;</code>
   *
   * @return The clientVersion.
   */
  @java.lang.Override
  public java.lang.String getClientVersion() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientVersion_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Arbitrary version identifier for the API client.
   * </pre>
   *
   * <code>string client_version = 13;</code>
   *
   * @return The bytes for clientVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientVersionBytes() {
    java.lang.Object ref = clientVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 14;
  private int launchStage_ = 0;

  /**
   *
   *
   * <pre>
   * The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   *
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 14;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }

  /**
   *
   *
   * <pre>
   * The launch stage as defined by [Google Cloud Platform
   * Launch Stages](https://cloud.google.com/terms/launch-stages).
   * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
   * is assumed.
   * Set the launch stage to a preview stage on input to allow use of preview
   * features in that stage. On read (or output), describes whether the resource
   * uses preview features.
   *
   * For example, if ALPHA is provided as input, but only BETA and GA-level
   * features are used, this field will be BETA on output.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 14;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int BINARY_AUTHORIZATION_FIELD_NUMBER = 15;
  private com.google.cloud.run.v2.BinaryAuthorization binaryAuthorization_;

  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
   *
   * @return Whether the binaryAuthorization field is set.
   */
  @java.lang.Override
  public boolean hasBinaryAuthorization() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
   *
   * @return The binaryAuthorization.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BinaryAuthorization getBinaryAuthorization() {
    return binaryAuthorization_ == null
        ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }

  /**
   *
   *
   * <pre>
   * Settings for the Binary Authorization feature.
   * </pre>
   *
   * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
    return binaryAuthorization_ == null
        ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
        : binaryAuthorization_;
  }

  public static final int TEMPLATE_FIELD_NUMBER = 16;
  private com.google.cloud.run.v2.ExecutionTemplate template_;

  /**
   *
   *
   * <pre>
   * Required. The template used to create executions for this Job.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the template field is set.
   */
  @java.lang.Override
  public boolean hasTemplate() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The template used to create executions for this Job.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The template.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionTemplate getTemplate() {
    return template_ == null
        ? com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()
        : template_;
  }

  /**
   *
   *
   * <pre>
   * Required. The template used to create executions for this Job.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionTemplateOrBuilder getTemplateOrBuilder() {
    return template_ == null
        ? com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()
        : template_;
  }

  public static final int OBSERVED_GENERATION_FIELD_NUMBER = 17;
  private long observedGeneration_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. The generation of this Job. See comments in `reconciling` for
   * additional information on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The observedGeneration.
   */
  @java.lang.Override
  public long getObservedGeneration() {
    return observedGeneration_;
  }

  public static final int TERMINAL_CONDITION_FIELD_NUMBER = 18;
  private com.google.cloud.run.v2.Condition terminalCondition_;

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Job, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the terminalCondition field is set.
   */
  @java.lang.Override
  public boolean hasTerminalCondition() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Job, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The terminalCondition.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getTerminalCondition() {
    return terminalCondition_ == null
        ? com.google.cloud.run.v2.Condition.getDefaultInstance()
        : terminalCondition_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The Condition of this Job, containing its readiness status,
   * and detailed error information in case it did not reach the desired state.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getTerminalConditionOrBuilder() {
    return terminalCondition_ == null
        ? com.google.cloud.run.v2.Condition.getDefaultInstance()
        : terminalCondition_;
  }

  public static final int CONDITIONS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Condition> conditions_;

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Job does not reach
   * its desired state. See comments in `reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Job does not reach
   * its desired state. See comments in `reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
      getConditionsOrBuilderList() {
    return conditions_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Job does not reach
   * its desired state. See comments in `reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getConditionsCount() {
    return conditions_.size();
  }

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Job does not reach
   * its desired state. See comments in `reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Condition getConditions(int index) {
    return conditions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Output only. The Conditions of all other associated sub-resources. They
   * contain additional diagnostics information in case the Job does not reach
   * its desired state. See comments in `reconciling` for additional information
   * on reconciliation process in Cloud Run.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
    return conditions_.get(index);
  }

  public static final int EXECUTION_COUNT_FIELD_NUMBER = 20;
  private int executionCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Number of executions created for this job.
   * </pre>
   *
   * <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The executionCount.
   */
  @java.lang.Override
  public int getExecutionCount() {
    return executionCount_;
  }

  public static final int LATEST_CREATED_EXECUTION_FIELD_NUMBER = 22;
  private com.google.cloud.run.v2.ExecutionReference latestCreatedExecution_;

  /**
   *
   *
   * <pre>
   * Output only. Name of the last created execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the latestCreatedExecution field is set.
   */
  @java.lang.Override
  public boolean hasLatestCreatedExecution() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Name of the last created execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestCreatedExecution.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionReference getLatestCreatedExecution() {
    return latestCreatedExecution_ == null
        ? com.google.cloud.run.v2.ExecutionReference.getDefaultInstance()
        : latestCreatedExecution_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Name of the last created execution.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ExecutionReferenceOrBuilder getLatestCreatedExecutionOrBuilder() {
    return latestCreatedExecution_ == null
        ? com.google.cloud.run.v2.ExecutionReference.getDefaultInstance()
        : latestCreatedExecution_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 23;
  private boolean reconciling_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Returns true if the Job is currently being acted upon by the
   * system to bring it into the desired state.
   *
   * When a new Job is created, or an existing one is updated, Cloud Run
   * will asynchronously perform all necessary steps to bring the Job to the
   * desired state. This process is called reconciliation.
   * While reconciliation is in process, `observed_generation` and
   * `latest_succeeded_execution`, will have transient values that might
   * mismatch the intended state: Once reconciliation is over (and this field is
   * false), there are two possible outcomes: reconciliation succeeded and the
   * state matches the Job, or there was an error,  and reconciliation failed.
   * This state can be found in `terminal_condition.state`.
   *
   * If reconciliation succeeded, the following fields will match:
   * `observed_generation` and `generation`, `latest_succeeded_execution` and
   * `latest_created_execution`.
   *
   * If reconciliation failed, `observed_generation` and
   * `latest_succeeded_execution` will have the state of the last succeeded
   * execution or empty for newly created Job. Additional information on the
   * failure can be found in `terminal_condition` and `conditions`.
   * </pre>
   *
   * <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 25;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int START_EXECUTION_TOKEN_FIELD_NUMBER = 26;

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix creating a new execution. The Job will
   * become ready when the execution is successfully started.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string start_execution_token = 26;</code>
   *
   * @return Whether the startExecutionToken field is set.
   */
  public boolean hasStartExecutionToken() {
    return createExecutionCase_ == 26;
  }

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix creating a new execution. The Job will
   * become ready when the execution is successfully started.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string start_execution_token = 26;</code>
   *
   * @return The startExecutionToken.
   */
  public java.lang.String getStartExecutionToken() {
    java.lang.Object ref = "";
    if (createExecutionCase_ == 26) {
      ref = createExecution_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (createExecutionCase_ == 26) {
        createExecution_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix creating a new execution. The Job will
   * become ready when the execution is successfully started.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string start_execution_token = 26;</code>
   *
   * @return The bytes for startExecutionToken.
   */
  public com.google.protobuf.ByteString getStartExecutionTokenBytes() {
    java.lang.Object ref = "";
    if (createExecutionCase_ == 26) {
      ref = createExecution_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (createExecutionCase_ == 26) {
        createExecution_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RUN_EXECUTION_TOKEN_FIELD_NUMBER = 27;

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix for creating a new execution. The Job
   * will become ready when the execution is successfully completed.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string run_execution_token = 27;</code>
   *
   * @return Whether the runExecutionToken field is set.
   */
  public boolean hasRunExecutionToken() {
    return createExecutionCase_ == 27;
  }

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix for creating a new execution. The Job
   * will become ready when the execution is successfully completed.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string run_execution_token = 27;</code>
   *
   * @return The runExecutionToken.
   */
  public java.lang.String getRunExecutionToken() {
    java.lang.Object ref = "";
    if (createExecutionCase_ == 27) {
      ref = createExecution_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (createExecutionCase_ == 27) {
        createExecution_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A unique string used as a suffix for creating a new execution. The Job
   * will become ready when the execution is successfully completed.
   * The sum of job name and token length must be fewer than 63 characters.
   * </pre>
   *
   * <code>string run_execution_token = 27;</code>
   *
   * @return The bytes for runExecutionToken.
   */
  public com.google.protobuf.ByteString getRunExecutionTokenBytes() {
    java.lang.Object ref = "";
    if (createExecutionCase_ == 27) {
      ref = createExecution_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (createExecutionCase_ == 27) {
        createExecution_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 99;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. A system-generated fingerprint for this version of the
   * resource. May be used to detect modification conflict during updates.
   * </pre>
   *
   * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (generation_ != 0L) {
      output.writeInt64(3, generation_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 5);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getDeleteTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, creator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastModifier_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, lastModifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(client_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, client_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, clientVersion_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(14, launchStage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(16, getTemplate());
    }
    if (observedGeneration_ != 0L) {
      output.writeInt64(17, observedGeneration_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(18, getTerminalCondition());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      output.writeMessage(19, conditions_.get(i));
    }
    if (executionCount_ != 0) {
      output.writeInt32(20, executionCount_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(22, getLatestCreatedExecution());
    }
    if (reconciling_ != false) {
      output.writeBool(23, reconciling_);
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(25, satisfiesPzs_);
    }
    if (createExecutionCase_ == 26) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 26, createExecution_);
    }
    if (createExecutionCase_ == 27) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, createExecution_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 99, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getDeleteTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, creator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(lastModifier_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, lastModifier_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(client_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, client_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(clientVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, clientVersion_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, launchStage_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(15, getBinaryAuthorization());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getTemplate());
    }
    if (observedGeneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(17, observedGeneration_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getTerminalCondition());
    }
    for (int i = 0; i < conditions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, conditions_.get(i));
    }
    if (executionCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(20, executionCount_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(22, getLatestCreatedExecution());
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, reconciling_);
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(25, satisfiesPzs_);
    }
    if (createExecutionCase_ == 26) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(26, createExecution_);
    }
    if (createExecutionCase_ == 27) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, createExecution_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(99, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Job other = (com.google.cloud.run.v2.Job) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getCreator().equals(other.getCreator())) return false;
    if (!getLastModifier().equals(other.getLastModifier())) return false;
    if (!getClient().equals(other.getClient())) return false;
    if (!getClientVersion().equals(other.getClientVersion())) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (hasBinaryAuthorization() != other.hasBinaryAuthorization()) return false;
    if (hasBinaryAuthorization()) {
      if (!getBinaryAuthorization().equals(other.getBinaryAuthorization())) return false;
    }
    if (hasTemplate() != other.hasTemplate()) return false;
    if (hasTemplate()) {
      if (!getTemplate().equals(other.getTemplate())) return false;
    }
    if (getObservedGeneration() != other.getObservedGeneration()) return false;
    if (hasTerminalCondition() != other.hasTerminalCondition()) return false;
    if (hasTerminalCondition()) {
      if (!getTerminalCondition().equals(other.getTerminalCondition())) return false;
    }
    if (!getConditionsList().equals(other.getConditionsList())) return false;
    if (getExecutionCount() != other.getExecutionCount()) return false;
    if (hasLatestCreatedExecution() != other.hasLatestCreatedExecution()) return false;
    if (hasLatestCreatedExecution()) {
      if (!getLatestCreatedExecution().equals(other.getLatestCreatedExecution())) return false;
    }
    if (getReconciling() != other.getReconciling()) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getCreateExecutionCase().equals(other.getCreateExecutionCase())) return false;
    switch (createExecutionCase_) {
      case 26:
        if (!getStartExecutionToken().equals(other.getStartExecutionToken())) return false;
        break;
      case 27:
        if (!getRunExecutionToken().equals(other.getRunExecutionToken())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    hash = (37 * hash) + LAST_MODIFIER_FIELD_NUMBER;
    hash = (53 * hash) + getLastModifier().hashCode();
    hash = (37 * hash) + CLIENT_FIELD_NUMBER;
    hash = (53 * hash) + getClient().hashCode();
    hash = (37 * hash) + CLIENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getClientVersion().hashCode();
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    if (hasBinaryAuthorization()) {
      hash = (37 * hash) + BINARY_AUTHORIZATION_FIELD_NUMBER;
      hash = (53 * hash) + getBinaryAuthorization().hashCode();
    }
    if (hasTemplate()) {
      hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getTemplate().hashCode();
    }
    hash = (37 * hash) + OBSERVED_GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
    if (hasTerminalCondition()) {
      hash = (37 * hash) + TERMINAL_CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getTerminalCondition().hashCode();
    }
    if (getConditionsCount() > 0) {
      hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConditionsList().hashCode();
    }
    hash = (37 * hash) + EXECUTION_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getExecutionCount();
    if (hasLatestCreatedExecution()) {
      hash = (37 * hash) + LATEST_CREATED_EXECUTION_FIELD_NUMBER;
      hash = (53 * hash) + getLatestCreatedExecution().hashCode();
    }
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    switch (createExecutionCase_) {
      case 26:
        hash = (37 * hash) + START_EXECUTION_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getStartExecutionToken().hashCode();
        break;
      case 27:
        hash = (37 * hash) + RUN_EXECUTION_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getRunExecutionToken().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Job parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Job represents the configuration of a single job, which references a
   * container image that is run to completion.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Job)
      com.google.cloud.run.v2.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.JobProto.internal_static_google_cloud_run_v2_Job_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 5:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 5:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.JobProto
          .internal_static_google_cloud_run_v2_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Job.class, com.google.cloud.run.v2.Job.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Job.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getDeleteTimeFieldBuilder();
        getExpireTimeFieldBuilder();
        getBinaryAuthorizationFieldBuilder();
        getTemplateFieldBuilder();
        getTerminalConditionFieldBuilder();
        getConditionsFieldBuilder();
        getLatestCreatedExecutionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      generation_ = 0L;
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      creator_ = "";
      lastModifier_ = "";
      client_ = "";
      clientVersion_ = "";
      launchStage_ = 0;
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      observedGeneration_ = 0L;
      terminalCondition_ = null;
      if (terminalConditionBuilder_ != null) {
        terminalConditionBuilder_.dispose();
        terminalConditionBuilder_ = null;
      }
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
      } else {
        conditions_ = null;
        conditionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00040000);
      executionCount_ = 0;
      latestCreatedExecution_ = null;
      if (latestCreatedExecutionBuilder_ != null) {
        latestCreatedExecutionBuilder_.dispose();
        latestCreatedExecutionBuilder_ = null;
      }
      reconciling_ = false;
      satisfiesPzs_ = false;
      etag_ = "";
      createExecutionCase_ = 0;
      createExecution_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.JobProto.internal_static_google_cloud_run_v2_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Job getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Job build() {
      com.google.cloud.run.v2.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Job buildPartial() {
      com.google.cloud.run.v2.Job result = new com.google.cloud.run.v2.Job(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.Job result) {
      if (conditionsBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
          bitField0_ = (bitField0_ & ~0x00040000);
        }
        result.conditions_ = conditions_;
      } else {
        result.conditions_ = conditionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.Job result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.generation_ = generation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastModifier_ = lastModifier_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.client_ = client_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.clientVersion_ = clientVersion_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.launchStage_ = launchStage_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.binaryAuthorization_ =
            binaryAuthorizationBuilder_ == null
                ? binaryAuthorization_
                : binaryAuthorizationBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.template_ = templateBuilder_ == null ? template_ : templateBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.observedGeneration_ = observedGeneration_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.terminalCondition_ =
            terminalConditionBuilder_ == null
                ? terminalCondition_
                : terminalConditionBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.executionCount_ = executionCount_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.latestCreatedExecution_ =
            latestCreatedExecutionBuilder_ == null
                ? latestCreatedExecution_
                : latestCreatedExecutionBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.reconciling_ = reconciling_;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.etag_ = etag_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.Job result) {
      result.createExecutionCase_ = createExecutionCase_;
      result.createExecution_ = this.createExecution_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Job) {
        return mergeFrom((com.google.cloud.run.v2.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Job other) {
      if (other == com.google.cloud.run.v2.Job.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getLastModifier().isEmpty()) {
        lastModifier_ = other.lastModifier_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getClient().isEmpty()) {
        client_ = other.client_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getClientVersion().isEmpty()) {
        clientVersion_ = other.clientVersion_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (other.hasBinaryAuthorization()) {
        mergeBinaryAuthorization(other.getBinaryAuthorization());
      }
      if (other.hasTemplate()) {
        mergeTemplate(other.getTemplate());
      }
      if (other.getObservedGeneration() != 0L) {
        setObservedGeneration(other.getObservedGeneration());
      }
      if (other.hasTerminalCondition()) {
        mergeTerminalCondition(other.getTerminalCondition());
      }
      if (conditionsBuilder_ == null) {
        if (!other.conditions_.isEmpty()) {
          if (conditions_.isEmpty()) {
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00040000);
          } else {
            ensureConditionsIsMutable();
            conditions_.addAll(other.conditions_);
          }
          onChanged();
        }
      } else {
        if (!other.conditions_.isEmpty()) {
          if (conditionsBuilder_.isEmpty()) {
            conditionsBuilder_.dispose();
            conditionsBuilder_ = null;
            conditions_ = other.conditions_;
            bitField0_ = (bitField0_ & ~0x00040000);
            conditionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConditionsFieldBuilder()
                    : null;
          } else {
            conditionsBuilder_.addAllMessages(other.conditions_);
          }
        }
      }
      if (other.getExecutionCount() != 0) {
        setExecutionCount(other.getExecutionCount());
      }
      if (other.hasLatestCreatedExecution()) {
        mergeLatestCreatedExecution(other.getLatestCreatedExecution());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      switch (other.getCreateExecutionCase()) {
        case START_EXECUTION_TOKEN:
          {
            createExecutionCase_ = 26;
            createExecution_ = other.createExecution_;
            onChanged();
            break;
          }
        case RUN_EXECUTION_TOKEN:
          {
            createExecutionCase_ = 27;
            createExecution_ = other.createExecution_;
            onChanged();
            break;
          }
        case CREATEEXECUTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                lastModifier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                client_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                clientVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                launchStage_ = input.readEnum();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 122:
              {
                input.readMessage(
                    getBinaryAuthorizationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getTemplateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 136:
              {
                observedGeneration_ = input.readInt64();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
            case 146:
              {
                input.readMessage(
                    getTerminalConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.run.v2.Condition m =
                    input.readMessage(
                        com.google.cloud.run.v2.Condition.parser(), extensionRegistry);
                if (conditionsBuilder_ == null) {
                  ensureConditionsIsMutable();
                  conditions_.add(m);
                } else {
                  conditionsBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 160:
              {
                executionCount_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 160
            case 178:
              {
                input.readMessage(
                    getLatestCreatedExecutionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 178
            case 184:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00200000;
                break;
              } // case 184
            case 200:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00400000;
                break;
              } // case 200
            case 210:
              {
                java.lang.String s = input.readStringRequireUtf8();
                createExecutionCase_ = 26;
                createExecution_ = s;
                break;
              } // case 210
            case 218:
              {
                java.lang.String s = input.readStringRequireUtf8();
                createExecutionCase_ = 27;
                createExecution_ = s;
                break;
              } // case 218
            case 794:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case 794
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int createExecutionCase_ = 0;
    private java.lang.Object createExecution_;

    public CreateExecutionCase getCreateExecutionCase() {
      return CreateExecutionCase.forNumber(createExecutionCase_);
    }

    public Builder clearCreateExecution() {
      createExecutionCase_ = 0;
      createExecution_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The fully qualified name of this Job.
     *
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of this Job.
     *
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of this Job.
     *
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of this Job.
     *
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The fully qualified name of this Job.
     *
     * Format:
     * projects/{project}/locations/{location}/jobs/{job}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Server assigned unique identifier for the Execution. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long generation_;

    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }

    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that can be used to organize and categorize
     * objects.
     * User-provided labels are shared with Google's billing system, so they can
     * be used to filter, or break down billing charges by team, component,
     * environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * &lt;p&gt;Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 Job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Unstructured key value map that may
     * be set by external tools to store and arbitrary metadata.
     * They are not queryable and should be preserved
     * when modifying objects.
     *
     * &lt;p&gt;Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected on new resources. All system
     * annotations in v1 now have a corresponding field in v2 Job.
     *
     * &lt;p&gt;This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 5;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The last-modified time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The deletion time. It is only populated as a response to a
     * Delete request.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object creator_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the authenticated creator.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object lastModifier_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The lastModifier.
     */
    public java.lang.String getLastModifier() {
      java.lang.Object ref = lastModifier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        lastModifier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for lastModifier.
     */
    public com.google.protobuf.ByteString getLastModifierBytes() {
      java.lang.Object ref = lastModifier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        lastModifier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The lastModifier to set.
     * @return This builder for chaining.
     */
    public Builder setLastModifier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      lastModifier_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastModifier() {
      lastModifier_ = getDefaultInstance().getLastModifier();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Email address of the last authenticated modifier.
     * </pre>
     *
     * <code>string last_modifier = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for lastModifier to set.
     * @return This builder for chaining.
     */
    public Builder setLastModifierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      lastModifier_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object client_ = "";

    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 12;</code>
     *
     * @return The client.
     */
    public java.lang.String getClient() {
      java.lang.Object ref = client_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        client_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 12;</code>
     *
     * @return The bytes for client.
     */
    public com.google.protobuf.ByteString getClientBytes() {
      java.lang.Object ref = client_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        client_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 12;</code>
     *
     * @param value The client to set.
     * @return This builder for chaining.
     */
    public Builder setClient(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      client_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClient() {
      client_ = getDefaultInstance().getClient();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary identifier for the API client.
     * </pre>
     *
     * <code>string client = 12;</code>
     *
     * @param value The bytes for client to set.
     * @return This builder for chaining.
     */
    public Builder setClientBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      client_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object clientVersion_ = "";

    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 13;</code>
     *
     * @return The clientVersion.
     */
    public java.lang.String getClientVersion() {
      java.lang.Object ref = clientVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 13;</code>
     *
     * @return The bytes for clientVersion.
     */
    public com.google.protobuf.ByteString getClientVersionBytes() {
      java.lang.Object ref = clientVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 13;</code>
     *
     * @param value The clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientVersion_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientVersion() {
      clientVersion_ = getDefaultInstance().getClientVersion();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arbitrary version identifier for the API client.
     * </pre>
     *
     * <code>string client_version = 13;</code>
     *
     * @param value The bytes for clientVersion to set.
     * @return This builder for chaining.
     */
    public Builder setClientVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientVersion_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;

    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     *
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 14;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }

    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     *
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 14;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {
      launchStage_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     *
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 14;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      com.google.api.LaunchStage result = com.google.api.LaunchStage.forNumber(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     *
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 14;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00002000;
      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The launch stage as defined by [Google Cloud Platform
     * Launch Stages](https://cloud.google.com/terms/launch-stages).
     * Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     * is assumed.
     * Set the launch stage to a preview stage on input to allow use of preview
     * features in that stage. On read (or output), describes whether the resource
     * uses preview features.
     *
     * For example, if ALPHA is provided as input, but only BETA and GA-level
     * features are used, this field will be BETA on output.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {
      bitField0_ = (bitField0_ & ~0x00002000);
      launchStage_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.BinaryAuthorization binaryAuthorization_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BinaryAuthorization,
            com.google.cloud.run.v2.BinaryAuthorization.Builder,
            com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>
        binaryAuthorizationBuilder_;

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     *
     * @return Whether the binaryAuthorization field is set.
     */
    public boolean hasBinaryAuthorization() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     *
     * @return The binaryAuthorization.
     */
    public com.google.cloud.run.v2.BinaryAuthorization getBinaryAuthorization() {
      if (binaryAuthorizationBuilder_ == null) {
        return binaryAuthorization_ == null
            ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      } else {
        return binaryAuthorizationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public Builder setBinaryAuthorization(com.google.cloud.run.v2.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        binaryAuthorization_ = value;
      } else {
        binaryAuthorizationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public Builder setBinaryAuthorization(
        com.google.cloud.run.v2.BinaryAuthorization.Builder builderForValue) {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorization_ = builderForValue.build();
      } else {
        binaryAuthorizationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public Builder mergeBinaryAuthorization(com.google.cloud.run.v2.BinaryAuthorization value) {
      if (binaryAuthorizationBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && binaryAuthorization_ != null
            && binaryAuthorization_
                != com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()) {
          getBinaryAuthorizationBuilder().mergeFrom(value);
        } else {
          binaryAuthorization_ = value;
        }
      } else {
        binaryAuthorizationBuilder_.mergeFrom(value);
      }
      if (binaryAuthorization_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public Builder clearBinaryAuthorization() {
      bitField0_ = (bitField0_ & ~0x00004000);
      binaryAuthorization_ = null;
      if (binaryAuthorizationBuilder_ != null) {
        binaryAuthorizationBuilder_.dispose();
        binaryAuthorizationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public com.google.cloud.run.v2.BinaryAuthorization.Builder getBinaryAuthorizationBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getBinaryAuthorizationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    public com.google.cloud.run.v2.BinaryAuthorizationOrBuilder getBinaryAuthorizationOrBuilder() {
      if (binaryAuthorizationBuilder_ != null) {
        return binaryAuthorizationBuilder_.getMessageOrBuilder();
      } else {
        return binaryAuthorization_ == null
            ? com.google.cloud.run.v2.BinaryAuthorization.getDefaultInstance()
            : binaryAuthorization_;
      }
    }

    /**
     *
     *
     * <pre>
     * Settings for the Binary Authorization feature.
     * </pre>
     *
     * <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BinaryAuthorization,
            com.google.cloud.run.v2.BinaryAuthorization.Builder,
            com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>
        getBinaryAuthorizationFieldBuilder() {
      if (binaryAuthorizationBuilder_ == null) {
        binaryAuthorizationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.BinaryAuthorization,
                com.google.cloud.run.v2.BinaryAuthorization.Builder,
                com.google.cloud.run.v2.BinaryAuthorizationOrBuilder>(
                getBinaryAuthorization(), getParentForChildren(), isClean());
        binaryAuthorization_ = null;
      }
      return binaryAuthorizationBuilder_;
    }

    private com.google.cloud.run.v2.ExecutionTemplate template_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ExecutionTemplate,
            com.google.cloud.run.v2.ExecutionTemplate.Builder,
            com.google.cloud.run.v2.ExecutionTemplateOrBuilder>
        templateBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the template field is set.
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00008000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The template.
     */
    public com.google.cloud.run.v2.ExecutionTemplate getTemplate() {
      if (templateBuilder_ == null) {
        return template_ == null
            ? com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()
            : template_;
      } else {
        return templateBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.ExecutionTemplate value) {
      if (templateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        template_ = value;
      } else {
        templateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTemplate(com.google.cloud.run.v2.ExecutionTemplate.Builder builderForValue) {
      if (templateBuilder_ == null) {
        template_ = builderForValue.build();
      } else {
        templateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTemplate(com.google.cloud.run.v2.ExecutionTemplate value) {
      if (templateBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && template_ != null
            && template_ != com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()) {
          getTemplateBuilder().mergeFrom(value);
        } else {
          template_ = value;
        }
      } else {
        templateBuilder_.mergeFrom(value);
      }
      if (template_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTemplate() {
      bitField0_ = (bitField0_ & ~0x00008000);
      template_ = null;
      if (templateBuilder_ != null) {
        templateBuilder_.dispose();
        templateBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.ExecutionTemplate.Builder getTemplateBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getTemplateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.run.v2.ExecutionTemplateOrBuilder getTemplateOrBuilder() {
      if (templateBuilder_ != null) {
        return templateBuilder_.getMessageOrBuilder();
      } else {
        return template_ == null
            ? com.google.cloud.run.v2.ExecutionTemplate.getDefaultInstance()
            : template_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The template used to create executions for this Job.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionTemplate template = 16 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ExecutionTemplate,
            com.google.cloud.run.v2.ExecutionTemplate.Builder,
            com.google.cloud.run.v2.ExecutionTemplateOrBuilder>
        getTemplateFieldBuilder() {
      if (templateBuilder_ == null) {
        templateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.ExecutionTemplate,
                com.google.cloud.run.v2.ExecutionTemplate.Builder,
                com.google.cloud.run.v2.ExecutionTemplateOrBuilder>(
                getTemplate(), getParentForChildren(), isClean());
        template_ = null;
      }
      return templateBuilder_;
    }

    private long observedGeneration_;

    /**
     *
     *
     * <pre>
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The observedGeneration.
     */
    @java.lang.Override
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The observedGeneration to set.
     * @return This builder for chaining.
     */
    public Builder setObservedGeneration(long value) {

      observedGeneration_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The generation of this Job. See comments in `reconciling` for
     * additional information on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>int64 observed_generation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservedGeneration() {
      bitField0_ = (bitField0_ & ~0x00010000);
      observedGeneration_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.Condition terminalCondition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        terminalConditionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the terminalCondition field is set.
     */
    public boolean hasTerminalCondition() {
      return ((bitField0_ & 0x00020000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The terminalCondition.
     */
    public com.google.cloud.run.v2.Condition getTerminalCondition() {
      if (terminalConditionBuilder_ == null) {
        return terminalCondition_ == null
            ? com.google.cloud.run.v2.Condition.getDefaultInstance()
            : terminalCondition_;
      } else {
        return terminalConditionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerminalCondition(com.google.cloud.run.v2.Condition value) {
      if (terminalConditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        terminalCondition_ = value;
      } else {
        terminalConditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTerminalCondition(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (terminalConditionBuilder_ == null) {
        terminalCondition_ = builderForValue.build();
      } else {
        terminalConditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTerminalCondition(com.google.cloud.run.v2.Condition value) {
      if (terminalConditionBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && terminalCondition_ != null
            && terminalCondition_ != com.google.cloud.run.v2.Condition.getDefaultInstance()) {
          getTerminalConditionBuilder().mergeFrom(value);
        } else {
          terminalCondition_ = value;
        }
      } else {
        terminalConditionBuilder_.mergeFrom(value);
      }
      if (terminalCondition_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTerminalCondition() {
      bitField0_ = (bitField0_ & ~0x00020000);
      terminalCondition_ = null;
      if (terminalConditionBuilder_ != null) {
        terminalConditionBuilder_.dispose();
        terminalConditionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getTerminalConditionBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getTerminalConditionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getTerminalConditionOrBuilder() {
      if (terminalConditionBuilder_ != null) {
        return terminalConditionBuilder_.getMessageOrBuilder();
      } else {
        return terminalCondition_ == null
            ? com.google.cloud.run.v2.Condition.getDefaultInstance()
            : terminalCondition_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Condition of this Job, containing its readiness status,
     * and detailed error information in case it did not reach the desired state.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.Condition terminal_condition = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getTerminalConditionFieldBuilder() {
      if (terminalConditionBuilder_ == null) {
        terminalConditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                getTerminalCondition(), getParentForChildren(), isClean());
        terminalCondition_ = null;
      }
      return terminalConditionBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.Condition> conditions_ =
        java.util.Collections.emptyList();

    private void ensureConditionsIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        conditions_ = new java.util.ArrayList<com.google.cloud.run.v2.Condition>(conditions_);
        bitField0_ |= 0x00040000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        conditionsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition> getConditionsList() {
      if (conditionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(conditions_);
      } else {
        return conditionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getConditionsCount() {
      if (conditionsBuilder_ == null) {
        return conditions_.size();
      } else {
        return conditionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition getConditions(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.set(index, value);
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.set(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(int index, com.google.cloud.run.v2.Condition value) {
      if (conditionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConditionsIsMutable();
        conditions_.add(index, value);
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addConditions(
        int index, com.google.cloud.run.v2.Condition.Builder builderForValue) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.add(index, builderForValue.build());
        onChanged();
      } else {
        conditionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllConditions(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Condition> values) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
        onChanged();
      } else {
        conditionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearConditions() {
      if (conditionsBuilder_ == null) {
        conditions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00040000);
        onChanged();
      } else {
        conditionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeConditions(int index) {
      if (conditionsBuilder_ == null) {
        ensureConditionsIsMutable();
        conditions_.remove(index);
        onChanged();
      } else {
        conditionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder getConditionsBuilder(int index) {
      return getConditionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ConditionOrBuilder getConditionsOrBuilder(int index) {
      if (conditionsBuilder_ == null) {
        return conditions_.get(index);
      } else {
        return conditionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsOrBuilderList() {
      if (conditionsBuilder_ != null) {
        return conditionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(conditions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder() {
      return getConditionsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Condition.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.Condition.Builder addConditionsBuilder(int index) {
      return getConditionsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Condition.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Job does not reach
     * its desired state. See comments in `reconciling` for additional information
     * on reconciliation process in Cloud Run.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Condition conditions = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Condition.Builder> getConditionsBuilderList() {
      return getConditionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Condition,
            com.google.cloud.run.v2.Condition.Builder,
            com.google.cloud.run.v2.ConditionOrBuilder>
        getConditionsFieldBuilder() {
      if (conditionsBuilder_ == null) {
        conditionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Condition,
                com.google.cloud.run.v2.Condition.Builder,
                com.google.cloud.run.v2.ConditionOrBuilder>(
                conditions_, ((bitField0_ & 0x00040000) != 0), getParentForChildren(), isClean());
        conditions_ = null;
      }
      return conditionsBuilder_;
    }

    private int executionCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of executions created for this job.
     * </pre>
     *
     * <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The executionCount.
     */
    @java.lang.Override
    public int getExecutionCount() {
      return executionCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of executions created for this job.
     * </pre>
     *
     * <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The executionCount to set.
     * @return This builder for chaining.
     */
    public Builder setExecutionCount(int value) {

      executionCount_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of executions created for this job.
     * </pre>
     *
     * <code>int32 execution_count = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExecutionCount() {
      bitField0_ = (bitField0_ & ~0x00080000);
      executionCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.ExecutionReference latestCreatedExecution_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ExecutionReference,
            com.google.cloud.run.v2.ExecutionReference.Builder,
            com.google.cloud.run.v2.ExecutionReferenceOrBuilder>
        latestCreatedExecutionBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the latestCreatedExecution field is set.
     */
    public boolean hasLatestCreatedExecution() {
      return ((bitField0_ & 0x00100000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestCreatedExecution.
     */
    public com.google.cloud.run.v2.ExecutionReference getLatestCreatedExecution() {
      if (latestCreatedExecutionBuilder_ == null) {
        return latestCreatedExecution_ == null
            ? com.google.cloud.run.v2.ExecutionReference.getDefaultInstance()
            : latestCreatedExecution_;
      } else {
        return latestCreatedExecutionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestCreatedExecution(com.google.cloud.run.v2.ExecutionReference value) {
      if (latestCreatedExecutionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestCreatedExecution_ = value;
      } else {
        latestCreatedExecutionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestCreatedExecution(
        com.google.cloud.run.v2.ExecutionReference.Builder builderForValue) {
      if (latestCreatedExecutionBuilder_ == null) {
        latestCreatedExecution_ = builderForValue.build();
      } else {
        latestCreatedExecutionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLatestCreatedExecution(com.google.cloud.run.v2.ExecutionReference value) {
      if (latestCreatedExecutionBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && latestCreatedExecution_ != null
            && latestCreatedExecution_
                != com.google.cloud.run.v2.ExecutionReference.getDefaultInstance()) {
          getLatestCreatedExecutionBuilder().mergeFrom(value);
        } else {
          latestCreatedExecution_ = value;
        }
      } else {
        latestCreatedExecutionBuilder_.mergeFrom(value);
      }
      if (latestCreatedExecution_ != null) {
        bitField0_ |= 0x00100000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLatestCreatedExecution() {
      bitField0_ = (bitField0_ & ~0x00100000);
      latestCreatedExecution_ = null;
      if (latestCreatedExecutionBuilder_ != null) {
        latestCreatedExecutionBuilder_.dispose();
        latestCreatedExecutionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ExecutionReference.Builder getLatestCreatedExecutionBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getLatestCreatedExecutionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.ExecutionReferenceOrBuilder
        getLatestCreatedExecutionOrBuilder() {
      if (latestCreatedExecutionBuilder_ != null) {
        return latestCreatedExecutionBuilder_.getMessageOrBuilder();
      } else {
        return latestCreatedExecution_ == null
            ? com.google.cloud.run.v2.ExecutionReference.getDefaultInstance()
            : latestCreatedExecution_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Name of the last created execution.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ExecutionReference latest_created_execution = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ExecutionReference,
            com.google.cloud.run.v2.ExecutionReference.Builder,
            com.google.cloud.run.v2.ExecutionReferenceOrBuilder>
        getLatestCreatedExecutionFieldBuilder() {
      if (latestCreatedExecutionBuilder_ == null) {
        latestCreatedExecutionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.ExecutionReference,
                com.google.cloud.run.v2.ExecutionReference.Builder,
                com.google.cloud.run.v2.ExecutionReferenceOrBuilder>(
                getLatestCreatedExecution(), getParentForChildren(), isClean());
        latestCreatedExecution_ = null;
      }
      return latestCreatedExecutionBuilder_;
    }

    private boolean reconciling_;

    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     *
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     *
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     *
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     *
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Returns true if the Job is currently being acted upon by the
     * system to bring it into the desired state.
     *
     * When a new Job is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Job to the
     * desired state. This process is called reconciliation.
     * While reconciliation is in process, `observed_generation` and
     * `latest_succeeded_execution`, will have transient values that might
     * mismatch the intended state: Once reconciliation is over (and this field is
     * false), there are two possible outcomes: reconciliation succeeded and the
     * state matches the Job, or there was an error,  and reconciliation failed.
     * This state can be found in `terminal_condition.state`.
     *
     * If reconciliation succeeded, the following fields will match:
     * `observed_generation` and `generation`, `latest_succeeded_execution` and
     * `latest_created_execution`.
     *
     * If reconciliation failed, `observed_generation` and
     * `latest_succeeded_execution` will have the state of the last succeeded
     * execution or empty for newly created Job. Additional information on the
     * failure can be found in `terminal_condition` and `conditions`.
     * </pre>
     *
     * <code>bool reconciling = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00200000);
      reconciling_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00400000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @return Whether the startExecutionToken field is set.
     */
    @java.lang.Override
    public boolean hasStartExecutionToken() {
      return createExecutionCase_ == 26;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @return The startExecutionToken.
     */
    @java.lang.Override
    public java.lang.String getStartExecutionToken() {
      java.lang.Object ref = "";
      if (createExecutionCase_ == 26) {
        ref = createExecution_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (createExecutionCase_ == 26) {
          createExecution_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @return The bytes for startExecutionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStartExecutionTokenBytes() {
      java.lang.Object ref = "";
      if (createExecutionCase_ == 26) {
        ref = createExecution_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (createExecutionCase_ == 26) {
          createExecution_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @param value The startExecutionToken to set.
     * @return This builder for chaining.
     */
    public Builder setStartExecutionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      createExecutionCase_ = 26;
      createExecution_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartExecutionToken() {
      if (createExecutionCase_ == 26) {
        createExecutionCase_ = 0;
        createExecution_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix creating a new execution. The Job will
     * become ready when the execution is successfully started.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string start_execution_token = 26;</code>
     *
     * @param value The bytes for startExecutionToken to set.
     * @return This builder for chaining.
     */
    public Builder setStartExecutionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      createExecutionCase_ = 26;
      createExecution_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @return Whether the runExecutionToken field is set.
     */
    @java.lang.Override
    public boolean hasRunExecutionToken() {
      return createExecutionCase_ == 27;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @return The runExecutionToken.
     */
    @java.lang.Override
    public java.lang.String getRunExecutionToken() {
      java.lang.Object ref = "";
      if (createExecutionCase_ == 27) {
        ref = createExecution_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (createExecutionCase_ == 27) {
          createExecution_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @return The bytes for runExecutionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRunExecutionTokenBytes() {
      java.lang.Object ref = "";
      if (createExecutionCase_ == 27) {
        ref = createExecution_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (createExecutionCase_ == 27) {
          createExecution_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @param value The runExecutionToken to set.
     * @return This builder for chaining.
     */
    public Builder setRunExecutionToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      createExecutionCase_ = 27;
      createExecution_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunExecutionToken() {
      if (createExecutionCase_ == 27) {
        createExecutionCase_ = 0;
        createExecution_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A unique string used as a suffix for creating a new execution. The Job
     * will become ready when the execution is successfully completed.
     * The sum of job name and token length must be fewer than 63 characters.
     * </pre>
     *
     * <code>string run_execution_token = 27;</code>
     *
     * @param value The bytes for runExecutionToken to set.
     * @return This builder for chaining.
     */
    public Builder setRunExecutionTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      createExecutionCase_ = 27;
      createExecution_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     * </pre>
     *
     * <code>string etag = 99 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Job)
  private static final com.google.cloud.run.v2.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Job();
  }

  public static com.google.cloud.run.v2.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
