/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * A single application container.
 * This specifies both the container to run, the command to run in the container
 * and the arguments to supply to it.
 * Note that additional arguments can be supplied by the system to the container
 * at runtime.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.Container}
 */
public final class Container extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.Container)
    ContainerOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Container.newBuilder() to construct.
  private Container(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Container() {
    name_ = "";
    image_ = "";
    command_ = com.google.protobuf.LazyStringArrayList.emptyList();
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    env_ = java.util.Collections.emptyList();
    ports_ = java.util.Collections.emptyList();
    volumeMounts_ = java.util.Collections.emptyList();
    workingDir_ = "";
    dependsOn_ = com.google.protobuf.LazyStringArrayList.emptyList();
    baseImageUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Container();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_Container_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_Container_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.Container.class,
            com.google.cloud.run.v2.Container.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the container specified as a DNS_LABEL (RFC 1123).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the container specified as a DNS_LABEL (RFC 1123).
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object image_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the container image in Dockerhub, Google Artifact
   * Registry, or Google Container Registry. If the host is not provided,
   * Dockerhub is assumed.
   * </pre>
   *
   * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public java.lang.String getImage() {
    java.lang.Object ref = image_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      image_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the container image in Dockerhub, Google Artifact
   * Registry, or Google Container Registry. If the host is not provided,
   * Dockerhub is assumed.
   * </pre>
   *
   * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for image.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageBytes() {
    java.lang.Object ref = image_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      image_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_CODE_FIELD_NUMBER = 17;
  private com.google.cloud.run.v2.SourceCode sourceCode_;

  /**
   *
   *
   * <pre>
   * Optional. Location of the source.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceCode field is set.
   */
  @java.lang.Override
  public boolean hasSourceCode() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Location of the source.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceCode.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SourceCode getSourceCode() {
    return sourceCode_ == null
        ? com.google.cloud.run.v2.SourceCode.getDefaultInstance()
        : sourceCode_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Location of the source.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SourceCodeOrBuilder getSourceCodeOrBuilder() {
    return sourceCode_ == null
        ? com.google.cloud.run.v2.SourceCode.getDefaultInstance()
        : sourceCode_;
  }

  public static final int COMMAND_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList command_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @return A list containing the command.
   */
  public com.google.protobuf.ProtocolStringList getCommandList() {
    return command_;
  }

  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @return The count of command.
   */
  public int getCommandCount() {
    return command_.size();
  }

  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  public java.lang.String getCommand(int index) {
    return command_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Entrypoint array. Not executed within a shell.
   * The docker image's ENTRYPOINT is used if this is not provided.
   * </pre>
   *
   * <code>repeated string command = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  public com.google.protobuf.ByteString getCommandBytes(int index) {
    return command_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }

  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }

  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Arguments to the entrypoint.
   * The docker image's CMD is used if this is not provided.
   * </pre>
   *
   * <code>repeated string args = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int ENV_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.EnvVar> env_;

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder> getEnvOrBuilderList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  @java.lang.Override
  public int getEnvCount() {
    return env_.size();
  }

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EnvVar getEnv(int index) {
    return env_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of environment variables to set in the container.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index) {
    return env_.get(index);
  }

  public static final int RESOURCES_FIELD_NUMBER = 6;
  private com.google.cloud.run.v2.ResourceRequirements resources_;

  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   *
   * @return Whether the resources field is set.
   */
  @java.lang.Override
  public boolean hasResources() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   *
   * @return The resources.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ResourceRequirements getResources() {
    return resources_ == null
        ? com.google.cloud.run.v2.ResourceRequirements.getDefaultInstance()
        : resources_;
  }

  /**
   *
   *
   * <pre>
   * Compute Resource requirements by this container.
   * </pre>
   *
   * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ResourceRequirementsOrBuilder getResourcesOrBuilder() {
    return resources_ == null
        ? com.google.cloud.run.v2.ResourceRequirements.getDefaultInstance()
        : resources_;
  }

  public static final int PORTS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.ContainerPort> ports_;

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.ContainerPort> getPortsList() {
    return ports_;
  }

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ContainerPortOrBuilder>
      getPortsOrBuilderList() {
    return ports_;
  }

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  @java.lang.Override
  public int getPortsCount() {
    return ports_.size();
  }

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ContainerPort getPorts(int index) {
    return ports_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of ports to expose from the container. Only a single port can be
   * specified. The specified ports must be listening on all interfaces
   * (0.0.0.0) within the container to be accessible.
   *
   * If omitted, a port number will be chosen and passed to the container
   * through the PORT environment variable for the container to listen on.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ContainerPortOrBuilder getPortsOrBuilder(int index) {
    return ports_.get(index);
  }

  public static final int VOLUME_MOUNTS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.VolumeMount> volumeMounts_;

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.VolumeMount> getVolumeMountsList() {
    return volumeMounts_;
  }

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.VolumeMountOrBuilder>
      getVolumeMountsOrBuilderList() {
    return volumeMounts_;
  }

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  @java.lang.Override
  public int getVolumeMountsCount() {
    return volumeMounts_.size();
  }

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VolumeMount getVolumeMounts(int index) {
    return volumeMounts_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Volume to mount into the container's filesystem.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VolumeMountOrBuilder getVolumeMountsOrBuilder(int index) {
    return volumeMounts_.get(index);
  }

  public static final int WORKING_DIR_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object workingDir_ = "";

  /**
   *
   *
   * <pre>
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * </pre>
   *
   * <code>string working_dir = 9;</code>
   *
   * @return The workingDir.
   */
  @java.lang.Override
  public java.lang.String getWorkingDir() {
    java.lang.Object ref = workingDir_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      workingDir_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * </pre>
   *
   * <code>string working_dir = 9;</code>
   *
   * @return The bytes for workingDir.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWorkingDirBytes() {
    java.lang.Object ref = workingDir_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      workingDir_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIVENESS_PROBE_FIELD_NUMBER = 10;
  private com.google.cloud.run.v2.Probe livenessProbe_;

  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   *
   * @return Whether the livenessProbe field is set.
   */
  @java.lang.Override
  public boolean hasLivenessProbe() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   *
   * @return The livenessProbe.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Probe getLivenessProbe() {
    return livenessProbe_ == null
        ? com.google.cloud.run.v2.Probe.getDefaultInstance()
        : livenessProbe_;
  }

  /**
   *
   *
   * <pre>
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ProbeOrBuilder getLivenessProbeOrBuilder() {
    return livenessProbe_ == null
        ? com.google.cloud.run.v2.Probe.getDefaultInstance()
        : livenessProbe_;
  }

  public static final int STARTUP_PROBE_FIELD_NUMBER = 11;
  private com.google.cloud.run.v2.Probe startupProbe_;

  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   *
   * @return Whether the startupProbe field is set.
   */
  @java.lang.Override
  public boolean hasStartupProbe() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   *
   * @return The startupProbe.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Probe getStartupProbe() {
    return startupProbe_ == null
        ? com.google.cloud.run.v2.Probe.getDefaultInstance()
        : startupProbe_;
  }

  /**
   *
   *
   * <pre>
   * Startup probe of application within the container.
   * All other probes are disabled if a startup probe is provided, until it
   * succeeds. Container will not be added to service endpoints if the probe
   * fails.
   * </pre>
   *
   * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ProbeOrBuilder getStartupProbeOrBuilder() {
    return startupProbe_ == null
        ? com.google.cloud.run.v2.Probe.getDefaultInstance()
        : startupProbe_;
  }

  public static final int DEPENDS_ON_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList dependsOn_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Names of the containers that must start before this container.
   * </pre>
   *
   * <code>repeated string depends_on = 12;</code>
   *
   * @return A list containing the dependsOn.
   */
  public com.google.protobuf.ProtocolStringList getDependsOnList() {
    return dependsOn_;
  }

  /**
   *
   *
   * <pre>
   * Names of the containers that must start before this container.
   * </pre>
   *
   * <code>repeated string depends_on = 12;</code>
   *
   * @return The count of dependsOn.
   */
  public int getDependsOnCount() {
    return dependsOn_.size();
  }

  /**
   *
   *
   * <pre>
   * Names of the containers that must start before this container.
   * </pre>
   *
   * <code>repeated string depends_on = 12;</code>
   *
   * @param index The index of the element to return.
   * @return The dependsOn at the given index.
   */
  public java.lang.String getDependsOn(int index) {
    return dependsOn_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Names of the containers that must start before this container.
   * </pre>
   *
   * <code>repeated string depends_on = 12;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dependsOn at the given index.
   */
  public com.google.protobuf.ByteString getDependsOnBytes(int index) {
    return dependsOn_.getByteString(index);
  }

  public static final int BASE_IMAGE_URI_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseImageUri_ = "";

  /**
   *
   *
   * <pre>
   * Base image for this container. Only supported for services. If set, it
   * indicates that the service is enrolled into automatic base image update.
   * </pre>
   *
   * <code>string base_image_uri = 13;</code>
   *
   * @return The baseImageUri.
   */
  @java.lang.Override
  public java.lang.String getBaseImageUri() {
    java.lang.Object ref = baseImageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseImageUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Base image for this container. Only supported for services. If set, it
   * indicates that the service is enrolled into automatic base image update.
   * </pre>
   *
   * <code>string base_image_uri = 13;</code>
   *
   * @return The bytes for baseImageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseImageUriBytes() {
    java.lang.Object ref = baseImageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseImageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_INFO_FIELD_NUMBER = 15;
  private com.google.cloud.run.v2.BuildInfo buildInfo_;

  /**
   *
   *
   * <pre>
   * Output only. The build info of the container image.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the buildInfo field is set.
   */
  @java.lang.Override
  public boolean hasBuildInfo() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The build info of the container image.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The buildInfo.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BuildInfo getBuildInfo() {
    return buildInfo_ == null ? com.google.cloud.run.v2.BuildInfo.getDefaultInstance() : buildInfo_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The build info of the container image.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.BuildInfoOrBuilder getBuildInfoOrBuilder() {
    return buildInfo_ == null ? com.google.cloud.run.v2.BuildInfo.getDefaultInstance() : buildInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, image_);
    }
    for (int i = 0; i < command_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, command_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, args_.getRaw(i));
    }
    for (int i = 0; i < env_.size(); i++) {
      output.writeMessage(5, env_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getResources());
    }
    for (int i = 0; i < ports_.size(); i++) {
      output.writeMessage(7, ports_.get(i));
    }
    for (int i = 0; i < volumeMounts_.size(); i++) {
      output.writeMessage(8, volumeMounts_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workingDir_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, workingDir_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getLivenessProbe());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getStartupProbe());
    }
    for (int i = 0; i < dependsOn_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, dependsOn_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseImageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, baseImageUri_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getBuildInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(17, getSourceCode());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(image_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, image_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < command_.size(); i++) {
        dataSize += computeStringSizeNoTag(command_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCommandList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    for (int i = 0; i < env_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, env_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getResources());
    }
    for (int i = 0; i < ports_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, ports_.get(i));
    }
    for (int i = 0; i < volumeMounts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, volumeMounts_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(workingDir_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, workingDir_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getLivenessProbe());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getStartupProbe());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dependsOn_.size(); i++) {
        dataSize += computeStringSizeNoTag(dependsOn_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDependsOnList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baseImageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, baseImageUri_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getBuildInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getSourceCode());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.Container)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.Container other = (com.google.cloud.run.v2.Container) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getImage().equals(other.getImage())) return false;
    if (hasSourceCode() != other.hasSourceCode()) return false;
    if (hasSourceCode()) {
      if (!getSourceCode().equals(other.getSourceCode())) return false;
    }
    if (!getCommandList().equals(other.getCommandList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (hasResources() != other.hasResources()) return false;
    if (hasResources()) {
      if (!getResources().equals(other.getResources())) return false;
    }
    if (!getPortsList().equals(other.getPortsList())) return false;
    if (!getVolumeMountsList().equals(other.getVolumeMountsList())) return false;
    if (!getWorkingDir().equals(other.getWorkingDir())) return false;
    if (hasLivenessProbe() != other.hasLivenessProbe()) return false;
    if (hasLivenessProbe()) {
      if (!getLivenessProbe().equals(other.getLivenessProbe())) return false;
    }
    if (hasStartupProbe() != other.hasStartupProbe()) return false;
    if (hasStartupProbe()) {
      if (!getStartupProbe().equals(other.getStartupProbe())) return false;
    }
    if (!getDependsOnList().equals(other.getDependsOnList())) return false;
    if (!getBaseImageUri().equals(other.getBaseImageUri())) return false;
    if (hasBuildInfo() != other.hasBuildInfo()) return false;
    if (hasBuildInfo()) {
      if (!getBuildInfo().equals(other.getBuildInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getImage().hashCode();
    if (hasSourceCode()) {
      hash = (37 * hash) + SOURCE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceCode().hashCode();
    }
    if (getCommandCount() > 0) {
      hash = (37 * hash) + COMMAND_FIELD_NUMBER;
      hash = (53 * hash) + getCommandList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    if (hasResources()) {
      hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getResources().hashCode();
    }
    if (getPortsCount() > 0) {
      hash = (37 * hash) + PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getPortsList().hashCode();
    }
    if (getVolumeMountsCount() > 0) {
      hash = (37 * hash) + VOLUME_MOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getVolumeMountsList().hashCode();
    }
    hash = (37 * hash) + WORKING_DIR_FIELD_NUMBER;
    hash = (53 * hash) + getWorkingDir().hashCode();
    if (hasLivenessProbe()) {
      hash = (37 * hash) + LIVENESS_PROBE_FIELD_NUMBER;
      hash = (53 * hash) + getLivenessProbe().hashCode();
    }
    if (hasStartupProbe()) {
      hash = (37 * hash) + STARTUP_PROBE_FIELD_NUMBER;
      hash = (53 * hash) + getStartupProbe().hashCode();
    }
    if (getDependsOnCount() > 0) {
      hash = (37 * hash) + DEPENDS_ON_FIELD_NUMBER;
      hash = (53 * hash) + getDependsOnList().hashCode();
    }
    hash = (37 * hash) + BASE_IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getBaseImageUri().hashCode();
    if (hasBuildInfo()) {
      hash = (37 * hash) + BUILD_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getBuildInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.Container parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Container parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Container parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Container parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Container parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Container parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.Container parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.Container prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A single application container.
   * This specifies both the container to run, the command to run in the container
   * and the arguments to supply to it.
   * Note that additional arguments can be supplied by the system to the container
   * at runtime.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.Container}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.Container)
      com.google.cloud.run.v2.ContainerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Container_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Container_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.Container.class,
              com.google.cloud.run.v2.Container.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.Container.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSourceCodeFieldBuilder();
        getEnvFieldBuilder();
        getResourcesFieldBuilder();
        getPortsFieldBuilder();
        getVolumeMountsFieldBuilder();
        getLivenessProbeFieldBuilder();
        getStartupProbeFieldBuilder();
        getBuildInfoFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      image_ = "";
      sourceCode_ = null;
      if (sourceCodeBuilder_ != null) {
        sourceCodeBuilder_.dispose();
        sourceCodeBuilder_ = null;
      }
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
      } else {
        env_ = null;
        envBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      resources_ = null;
      if (resourcesBuilder_ != null) {
        resourcesBuilder_.dispose();
        resourcesBuilder_ = null;
      }
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
      } else {
        ports_ = null;
        portsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (volumeMountsBuilder_ == null) {
        volumeMounts_ = java.util.Collections.emptyList();
      } else {
        volumeMounts_ = null;
        volumeMountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      workingDir_ = "";
      livenessProbe_ = null;
      if (livenessProbeBuilder_ != null) {
        livenessProbeBuilder_.dispose();
        livenessProbeBuilder_ = null;
      }
      startupProbe_ = null;
      if (startupProbeBuilder_ != null) {
        startupProbeBuilder_.dispose();
        startupProbeBuilder_ = null;
      }
      dependsOn_ = com.google.protobuf.LazyStringArrayList.emptyList();
      baseImageUri_ = "";
      buildInfo_ = null;
      if (buildInfoBuilder_ != null) {
        buildInfoBuilder_.dispose();
        buildInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_Container_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Container getDefaultInstanceForType() {
      return com.google.cloud.run.v2.Container.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Container build() {
      com.google.cloud.run.v2.Container result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.Container buildPartial() {
      com.google.cloud.run.v2.Container result = new com.google.cloud.run.v2.Container(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.run.v2.Container result) {
      if (envBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          env_ = java.util.Collections.unmodifiableList(env_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.env_ = env_;
      } else {
        result.env_ = envBuilder_.build();
      }
      if (portsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          ports_ = java.util.Collections.unmodifiableList(ports_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.ports_ = ports_;
      } else {
        result.ports_ = portsBuilder_.build();
      }
      if (volumeMountsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          volumeMounts_ = java.util.Collections.unmodifiableList(volumeMounts_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.volumeMounts_ = volumeMounts_;
      } else {
        result.volumeMounts_ = volumeMountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.Container result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.image_ = image_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sourceCode_ = sourceCodeBuilder_ == null ? sourceCode_ : sourceCodeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        command_.makeImmutable();
        result.command_ = command_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.resources_ = resourcesBuilder_ == null ? resources_ : resourcesBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.workingDir_ = workingDir_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.livenessProbe_ =
            livenessProbeBuilder_ == null ? livenessProbe_ : livenessProbeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.startupProbe_ =
            startupProbeBuilder_ == null ? startupProbe_ : startupProbeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        dependsOn_.makeImmutable();
        result.dependsOn_ = dependsOn_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.baseImageUri_ = baseImageUri_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.buildInfo_ = buildInfoBuilder_ == null ? buildInfo_ : buildInfoBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.Container) {
        return mergeFrom((com.google.cloud.run.v2.Container) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.Container other) {
      if (other == com.google.cloud.run.v2.Container.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getImage().isEmpty()) {
        image_ = other.image_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasSourceCode()) {
        mergeSourceCode(other.getSourceCode());
      }
      if (!other.command_.isEmpty()) {
        if (command_.isEmpty()) {
          command_ = other.command_;
          bitField0_ |= 0x00000008;
        } else {
          ensureCommandIsMutable();
          command_.addAll(other.command_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000010;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (envBuilder_ == null) {
        if (!other.env_.isEmpty()) {
          if (env_.isEmpty()) {
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureEnvIsMutable();
            env_.addAll(other.env_);
          }
          onChanged();
        }
      } else {
        if (!other.env_.isEmpty()) {
          if (envBuilder_.isEmpty()) {
            envBuilder_.dispose();
            envBuilder_ = null;
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000020);
            envBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnvFieldBuilder()
                    : null;
          } else {
            envBuilder_.addAllMessages(other.env_);
          }
        }
      }
      if (other.hasResources()) {
        mergeResources(other.getResources());
      }
      if (portsBuilder_ == null) {
        if (!other.ports_.isEmpty()) {
          if (ports_.isEmpty()) {
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensurePortsIsMutable();
            ports_.addAll(other.ports_);
          }
          onChanged();
        }
      } else {
        if (!other.ports_.isEmpty()) {
          if (portsBuilder_.isEmpty()) {
            portsBuilder_.dispose();
            portsBuilder_ = null;
            ports_ = other.ports_;
            bitField0_ = (bitField0_ & ~0x00000080);
            portsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPortsFieldBuilder()
                    : null;
          } else {
            portsBuilder_.addAllMessages(other.ports_);
          }
        }
      }
      if (volumeMountsBuilder_ == null) {
        if (!other.volumeMounts_.isEmpty()) {
          if (volumeMounts_.isEmpty()) {
            volumeMounts_ = other.volumeMounts_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureVolumeMountsIsMutable();
            volumeMounts_.addAll(other.volumeMounts_);
          }
          onChanged();
        }
      } else {
        if (!other.volumeMounts_.isEmpty()) {
          if (volumeMountsBuilder_.isEmpty()) {
            volumeMountsBuilder_.dispose();
            volumeMountsBuilder_ = null;
            volumeMounts_ = other.volumeMounts_;
            bitField0_ = (bitField0_ & ~0x00000100);
            volumeMountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumeMountsFieldBuilder()
                    : null;
          } else {
            volumeMountsBuilder_.addAllMessages(other.volumeMounts_);
          }
        }
      }
      if (!other.getWorkingDir().isEmpty()) {
        workingDir_ = other.workingDir_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasLivenessProbe()) {
        mergeLivenessProbe(other.getLivenessProbe());
      }
      if (other.hasStartupProbe()) {
        mergeStartupProbe(other.getStartupProbe());
      }
      if (!other.dependsOn_.isEmpty()) {
        if (dependsOn_.isEmpty()) {
          dependsOn_ = other.dependsOn_;
          bitField0_ |= 0x00001000;
        } else {
          ensureDependsOnIsMutable();
          dependsOn_.addAll(other.dependsOn_);
        }
        onChanged();
      }
      if (!other.getBaseImageUri().isEmpty()) {
        baseImageUri_ = other.baseImageUri_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasBuildInfo()) {
        mergeBuildInfo(other.getBuildInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                image_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCommandIsMutable();
                command_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.run.v2.EnvVar m =
                    input.readMessage(com.google.cloud.run.v2.EnvVar.parser(), extensionRegistry);
                if (envBuilder_ == null) {
                  ensureEnvIsMutable();
                  env_.add(m);
                } else {
                  envBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getResourcesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.run.v2.ContainerPort m =
                    input.readMessage(
                        com.google.cloud.run.v2.ContainerPort.parser(), extensionRegistry);
                if (portsBuilder_ == null) {
                  ensurePortsIsMutable();
                  ports_.add(m);
                } else {
                  portsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.run.v2.VolumeMount m =
                    input.readMessage(
                        com.google.cloud.run.v2.VolumeMount.parser(), extensionRegistry);
                if (volumeMountsBuilder_ == null) {
                  ensureVolumeMountsIsMutable();
                  volumeMounts_.add(m);
                } else {
                  volumeMountsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                workingDir_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getLivenessProbeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getStartupProbeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 90
            case 98:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDependsOnIsMutable();
                dependsOn_.add(s);
                break;
              } // case 98
            case 106:
              {
                baseImageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(getBuildInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(getSourceCodeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the container specified as a DNS_LABEL (RFC 1123).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the container specified as a DNS_LABEL (RFC 1123).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the container specified as a DNS_LABEL (RFC 1123).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the container specified as a DNS_LABEL (RFC 1123).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the container specified as a DNS_LABEL (RFC 1123).
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object image_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the container image in Dockerhub, Google Artifact
     * Registry, or Google Container Registry. If the host is not provided,
     * Dockerhub is assumed.
     * </pre>
     *
     * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The image.
     */
    public java.lang.String getImage() {
      java.lang.Object ref = image_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        image_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the container image in Dockerhub, Google Artifact
     * Registry, or Google Container Registry. If the host is not provided,
     * Dockerhub is assumed.
     * </pre>
     *
     * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for image.
     */
    public com.google.protobuf.ByteString getImageBytes() {
      java.lang.Object ref = image_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        image_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the container image in Dockerhub, Google Artifact
     * Registry, or Google Container Registry. If the host is not provided,
     * Dockerhub is assumed.
     * </pre>
     *
     * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The image to set.
     * @return This builder for chaining.
     */
    public Builder setImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      image_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the container image in Dockerhub, Google Artifact
     * Registry, or Google Container Registry. If the host is not provided,
     * Dockerhub is assumed.
     * </pre>
     *
     * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImage() {
      image_ = getDefaultInstance().getImage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the container image in Dockerhub, Google Artifact
     * Registry, or Google Container Registry. If the host is not provided,
     * Dockerhub is assumed.
     * </pre>
     *
     * <code>string image = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for image to set.
     * @return This builder for chaining.
     */
    public Builder setImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      image_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.SourceCode sourceCode_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SourceCode,
            com.google.cloud.run.v2.SourceCode.Builder,
            com.google.cloud.run.v2.SourceCodeOrBuilder>
        sourceCodeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceCode field is set.
     */
    public boolean hasSourceCode() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceCode.
     */
    public com.google.cloud.run.v2.SourceCode getSourceCode() {
      if (sourceCodeBuilder_ == null) {
        return sourceCode_ == null
            ? com.google.cloud.run.v2.SourceCode.getDefaultInstance()
            : sourceCode_;
      } else {
        return sourceCodeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceCode(com.google.cloud.run.v2.SourceCode value) {
      if (sourceCodeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceCode_ = value;
      } else {
        sourceCodeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceCode(com.google.cloud.run.v2.SourceCode.Builder builderForValue) {
      if (sourceCodeBuilder_ == null) {
        sourceCode_ = builderForValue.build();
      } else {
        sourceCodeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceCode(com.google.cloud.run.v2.SourceCode value) {
      if (sourceCodeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && sourceCode_ != null
            && sourceCode_ != com.google.cloud.run.v2.SourceCode.getDefaultInstance()) {
          getSourceCodeBuilder().mergeFrom(value);
        } else {
          sourceCode_ = value;
        }
      } else {
        sourceCodeBuilder_.mergeFrom(value);
      }
      if (sourceCode_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceCode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sourceCode_ = null;
      if (sourceCodeBuilder_ != null) {
        sourceCodeBuilder_.dispose();
        sourceCodeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.SourceCode.Builder getSourceCodeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getSourceCodeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.SourceCodeOrBuilder getSourceCodeOrBuilder() {
      if (sourceCodeBuilder_ != null) {
        return sourceCodeBuilder_.getMessageOrBuilder();
      } else {
        return sourceCode_ == null
            ? com.google.cloud.run.v2.SourceCode.getDefaultInstance()
            : sourceCode_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Location of the source.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.SourceCode source_code = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SourceCode,
            com.google.cloud.run.v2.SourceCode.Builder,
            com.google.cloud.run.v2.SourceCodeOrBuilder>
        getSourceCodeFieldBuilder() {
      if (sourceCodeBuilder_ == null) {
        sourceCodeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.SourceCode,
                com.google.cloud.run.v2.SourceCode.Builder,
                com.google.cloud.run.v2.SourceCodeOrBuilder>(
                getSourceCode(), getParentForChildren(), isClean());
        sourceCode_ = null;
      }
      return sourceCodeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList command_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCommandIsMutable() {
      if (!command_.isModifiable()) {
        command_ = new com.google.protobuf.LazyStringArrayList(command_);
      }
      bitField0_ |= 0x00000008;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      command_.makeImmutable();
      return command_;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The command to set.
     * @return This builder for chaining.
     */
    public Builder setCommand(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param value The command to add.
     * @return This builder for chaining.
     */
    public Builder addCommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param values The command to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
      ensureCommandIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommand() {
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entrypoint array. Not executed within a shell.
     * The docker image's ENTRYPOINT is used if this is not provided.
     * </pre>
     *
     * <code>repeated string command = 3;</code>
     *
     * @param value The bytes of the command to add.
     * @return This builder for chaining.
     */
    public Builder addCommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000010;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Arguments to the entrypoint.
     * The docker image's CMD is used if this is not provided.
     * </pre>
     *
     * <code>repeated string args = 4;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.EnvVar> env_ = java.util.Collections.emptyList();

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        env_ = new java.util.ArrayList<com.google.cloud.run.v2.EnvVar>(env_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.EnvVar,
            com.google.cloud.run.v2.EnvVar.Builder,
            com.google.cloud.run.v2.EnvVarOrBuilder>
        envBuilder_;

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public java.util.List<com.google.cloud.run.v2.EnvVar> getEnvList() {
      if (envBuilder_ == null) {
        return java.util.Collections.unmodifiableList(env_);
      } else {
        return envBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public int getEnvCount() {
      if (envBuilder_ == null) {
        return env_.size();
      } else {
        return envBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public com.google.cloud.run.v2.EnvVar getEnv(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder setEnv(int index, com.google.cloud.run.v2.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.set(index, value);
        onChanged();
      } else {
        envBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder setEnv(int index, com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.set(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder addEnv(com.google.cloud.run.v2.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(value);
        onChanged();
      } else {
        envBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder addEnv(int index, com.google.cloud.run.v2.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(index, value);
        onChanged();
      } else {
        envBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder addEnv(com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder addEnv(int index, com.google.cloud.run.v2.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder addAllEnv(java.lang.Iterable<? extends com.google.cloud.run.v2.EnvVar> values) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
        onChanged();
      } else {
        envBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder clearEnv() {
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        envBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public Builder removeEnv(int index) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.remove(index);
        onChanged();
      } else {
        envBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public com.google.cloud.run.v2.EnvVar.Builder getEnvBuilder(int index) {
      return getEnvFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public com.google.cloud.run.v2.EnvVarOrBuilder getEnvOrBuilder(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.EnvVarOrBuilder> getEnvOrBuilderList() {
      if (envBuilder_ != null) {
        return envBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(env_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public com.google.cloud.run.v2.EnvVar.Builder addEnvBuilder() {
      return getEnvFieldBuilder().addBuilder(com.google.cloud.run.v2.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public com.google.cloud.run.v2.EnvVar.Builder addEnvBuilder(int index) {
      return getEnvFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of environment variables to set in the container.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.EnvVar env = 5;</code>
     */
    public java.util.List<com.google.cloud.run.v2.EnvVar.Builder> getEnvBuilderList() {
      return getEnvFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.EnvVar,
            com.google.cloud.run.v2.EnvVar.Builder,
            com.google.cloud.run.v2.EnvVarOrBuilder>
        getEnvFieldBuilder() {
      if (envBuilder_ == null) {
        envBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.EnvVar,
                com.google.cloud.run.v2.EnvVar.Builder,
                com.google.cloud.run.v2.EnvVarOrBuilder>(
                env_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        env_ = null;
      }
      return envBuilder_;
    }

    private com.google.cloud.run.v2.ResourceRequirements resources_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ResourceRequirements,
            com.google.cloud.run.v2.ResourceRequirements.Builder,
            com.google.cloud.run.v2.ResourceRequirementsOrBuilder>
        resourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     *
     * @return Whether the resources field is set.
     */
    public boolean hasResources() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     *
     * @return The resources.
     */
    public com.google.cloud.run.v2.ResourceRequirements getResources() {
      if (resourcesBuilder_ == null) {
        return resources_ == null
            ? com.google.cloud.run.v2.ResourceRequirements.getDefaultInstance()
            : resources_;
      } else {
        return resourcesBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public Builder setResources(com.google.cloud.run.v2.ResourceRequirements value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resources_ = value;
      } else {
        resourcesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public Builder setResources(
        com.google.cloud.run.v2.ResourceRequirements.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        resources_ = builderForValue.build();
      } else {
        resourcesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public Builder mergeResources(com.google.cloud.run.v2.ResourceRequirements value) {
      if (resourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && resources_ != null
            && resources_ != com.google.cloud.run.v2.ResourceRequirements.getDefaultInstance()) {
          getResourcesBuilder().mergeFrom(value);
        } else {
          resources_ = value;
        }
      } else {
        resourcesBuilder_.mergeFrom(value);
      }
      if (resources_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public Builder clearResources() {
      bitField0_ = (bitField0_ & ~0x00000040);
      resources_ = null;
      if (resourcesBuilder_ != null) {
        resourcesBuilder_.dispose();
        resourcesBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public com.google.cloud.run.v2.ResourceRequirements.Builder getResourcesBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getResourcesFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    public com.google.cloud.run.v2.ResourceRequirementsOrBuilder getResourcesOrBuilder() {
      if (resourcesBuilder_ != null) {
        return resourcesBuilder_.getMessageOrBuilder();
      } else {
        return resources_ == null
            ? com.google.cloud.run.v2.ResourceRequirements.getDefaultInstance()
            : resources_;
      }
    }

    /**
     *
     *
     * <pre>
     * Compute Resource requirements by this container.
     * </pre>
     *
     * <code>.google.cloud.run.v2.ResourceRequirements resources = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ResourceRequirements,
            com.google.cloud.run.v2.ResourceRequirements.Builder,
            com.google.cloud.run.v2.ResourceRequirementsOrBuilder>
        getResourcesFieldBuilder() {
      if (resourcesBuilder_ == null) {
        resourcesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.ResourceRequirements,
                com.google.cloud.run.v2.ResourceRequirements.Builder,
                com.google.cloud.run.v2.ResourceRequirementsOrBuilder>(
                getResources(), getParentForChildren(), isClean());
        resources_ = null;
      }
      return resourcesBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.ContainerPort> ports_ =
        java.util.Collections.emptyList();

    private void ensurePortsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        ports_ = new java.util.ArrayList<com.google.cloud.run.v2.ContainerPort>(ports_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.ContainerPort,
            com.google.cloud.run.v2.ContainerPort.Builder,
            com.google.cloud.run.v2.ContainerPortOrBuilder>
        portsBuilder_;

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public java.util.List<com.google.cloud.run.v2.ContainerPort> getPortsList() {
      if (portsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ports_);
      } else {
        return portsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public int getPortsCount() {
      if (portsBuilder_ == null) {
        return ports_.size();
      } else {
        return portsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public com.google.cloud.run.v2.ContainerPort getPorts(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder setPorts(int index, com.google.cloud.run.v2.ContainerPort value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.set(index, value);
        onChanged();
      } else {
        portsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder setPorts(
        int index, com.google.cloud.run.v2.ContainerPort.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.set(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder addPorts(com.google.cloud.run.v2.ContainerPort value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(value);
        onChanged();
      } else {
        portsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder addPorts(int index, com.google.cloud.run.v2.ContainerPort value) {
      if (portsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePortsIsMutable();
        ports_.add(index, value);
        onChanged();
      } else {
        portsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder addPorts(com.google.cloud.run.v2.ContainerPort.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder addPorts(
        int index, com.google.cloud.run.v2.ContainerPort.Builder builderForValue) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.add(index, builderForValue.build());
        onChanged();
      } else {
        portsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder addAllPorts(
        java.lang.Iterable<? extends com.google.cloud.run.v2.ContainerPort> values) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
        onChanged();
      } else {
        portsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder clearPorts() {
      if (portsBuilder_ == null) {
        ports_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        portsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public Builder removePorts(int index) {
      if (portsBuilder_ == null) {
        ensurePortsIsMutable();
        ports_.remove(index);
        onChanged();
      } else {
        portsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public com.google.cloud.run.v2.ContainerPort.Builder getPortsBuilder(int index) {
      return getPortsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public com.google.cloud.run.v2.ContainerPortOrBuilder getPortsOrBuilder(int index) {
      if (portsBuilder_ == null) {
        return ports_.get(index);
      } else {
        return portsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ContainerPortOrBuilder>
        getPortsOrBuilderList() {
      if (portsBuilder_ != null) {
        return portsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ports_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public com.google.cloud.run.v2.ContainerPort.Builder addPortsBuilder() {
      return getPortsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.ContainerPort.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public com.google.cloud.run.v2.ContainerPort.Builder addPortsBuilder(int index) {
      return getPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.ContainerPort.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of ports to expose from the container. Only a single port can be
     * specified. The specified ports must be listening on all interfaces
     * (0.0.0.0) within the container to be accessible.
     *
     * If omitted, a port number will be chosen and passed to the container
     * through the PORT environment variable for the container to listen on.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.ContainerPort ports = 7;</code>
     */
    public java.util.List<com.google.cloud.run.v2.ContainerPort.Builder> getPortsBuilderList() {
      return getPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.ContainerPort,
            com.google.cloud.run.v2.ContainerPort.Builder,
            com.google.cloud.run.v2.ContainerPortOrBuilder>
        getPortsFieldBuilder() {
      if (portsBuilder_ == null) {
        portsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.ContainerPort,
                com.google.cloud.run.v2.ContainerPort.Builder,
                com.google.cloud.run.v2.ContainerPortOrBuilder>(
                ports_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        ports_ = null;
      }
      return portsBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.VolumeMount> volumeMounts_ =
        java.util.Collections.emptyList();

    private void ensureVolumeMountsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        volumeMounts_ = new java.util.ArrayList<com.google.cloud.run.v2.VolumeMount>(volumeMounts_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.VolumeMount,
            com.google.cloud.run.v2.VolumeMount.Builder,
            com.google.cloud.run.v2.VolumeMountOrBuilder>
        volumeMountsBuilder_;

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public java.util.List<com.google.cloud.run.v2.VolumeMount> getVolumeMountsList() {
      if (volumeMountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumeMounts_);
      } else {
        return volumeMountsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public int getVolumeMountsCount() {
      if (volumeMountsBuilder_ == null) {
        return volumeMounts_.size();
      } else {
        return volumeMountsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public com.google.cloud.run.v2.VolumeMount getVolumeMounts(int index) {
      if (volumeMountsBuilder_ == null) {
        return volumeMounts_.get(index);
      } else {
        return volumeMountsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder setVolumeMounts(int index, com.google.cloud.run.v2.VolumeMount value) {
      if (volumeMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumeMountsIsMutable();
        volumeMounts_.set(index, value);
        onChanged();
      } else {
        volumeMountsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder setVolumeMounts(
        int index, com.google.cloud.run.v2.VolumeMount.Builder builderForValue) {
      if (volumeMountsBuilder_ == null) {
        ensureVolumeMountsIsMutable();
        volumeMounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumeMountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder addVolumeMounts(com.google.cloud.run.v2.VolumeMount value) {
      if (volumeMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumeMountsIsMutable();
        volumeMounts_.add(value);
        onChanged();
      } else {
        volumeMountsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder addVolumeMounts(int index, com.google.cloud.run.v2.VolumeMount value) {
      if (volumeMountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumeMountsIsMutable();
        volumeMounts_.add(index, value);
        onChanged();
      } else {
        volumeMountsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder addVolumeMounts(com.google.cloud.run.v2.VolumeMount.Builder builderForValue) {
      if (volumeMountsBuilder_ == null) {
        ensureVolumeMountsIsMutable();
        volumeMounts_.add(builderForValue.build());
        onChanged();
      } else {
        volumeMountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder addVolumeMounts(
        int index, com.google.cloud.run.v2.VolumeMount.Builder builderForValue) {
      if (volumeMountsBuilder_ == null) {
        ensureVolumeMountsIsMutable();
        volumeMounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumeMountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder addAllVolumeMounts(
        java.lang.Iterable<? extends com.google.cloud.run.v2.VolumeMount> values) {
      if (volumeMountsBuilder_ == null) {
        ensureVolumeMountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumeMounts_);
        onChanged();
      } else {
        volumeMountsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder clearVolumeMounts() {
      if (volumeMountsBuilder_ == null) {
        volumeMounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        volumeMountsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public Builder removeVolumeMounts(int index) {
      if (volumeMountsBuilder_ == null) {
        ensureVolumeMountsIsMutable();
        volumeMounts_.remove(index);
        onChanged();
      } else {
        volumeMountsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public com.google.cloud.run.v2.VolumeMount.Builder getVolumeMountsBuilder(int index) {
      return getVolumeMountsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public com.google.cloud.run.v2.VolumeMountOrBuilder getVolumeMountsOrBuilder(int index) {
      if (volumeMountsBuilder_ == null) {
        return volumeMounts_.get(index);
      } else {
        return volumeMountsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.VolumeMountOrBuilder>
        getVolumeMountsOrBuilderList() {
      if (volumeMountsBuilder_ != null) {
        return volumeMountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumeMounts_);
      }
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public com.google.cloud.run.v2.VolumeMount.Builder addVolumeMountsBuilder() {
      return getVolumeMountsFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.VolumeMount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public com.google.cloud.run.v2.VolumeMount.Builder addVolumeMountsBuilder(int index) {
      return getVolumeMountsFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.VolumeMount.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Volume to mount into the container's filesystem.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.VolumeMount volume_mounts = 8;</code>
     */
    public java.util.List<com.google.cloud.run.v2.VolumeMount.Builder>
        getVolumeMountsBuilderList() {
      return getVolumeMountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.VolumeMount,
            com.google.cloud.run.v2.VolumeMount.Builder,
            com.google.cloud.run.v2.VolumeMountOrBuilder>
        getVolumeMountsFieldBuilder() {
      if (volumeMountsBuilder_ == null) {
        volumeMountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.VolumeMount,
                com.google.cloud.run.v2.VolumeMount.Builder,
                com.google.cloud.run.v2.VolumeMountOrBuilder>(
                volumeMounts_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        volumeMounts_ = null;
      }
      return volumeMountsBuilder_;
    }

    private java.lang.Object workingDir_ = "";

    /**
     *
     *
     * <pre>
     * Container's working directory.
     * If not specified, the container runtime's default will be used, which
     * might be configured in the container image.
     * </pre>
     *
     * <code>string working_dir = 9;</code>
     *
     * @return The workingDir.
     */
    public java.lang.String getWorkingDir() {
      java.lang.Object ref = workingDir_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        workingDir_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Container's working directory.
     * If not specified, the container runtime's default will be used, which
     * might be configured in the container image.
     * </pre>
     *
     * <code>string working_dir = 9;</code>
     *
     * @return The bytes for workingDir.
     */
    public com.google.protobuf.ByteString getWorkingDirBytes() {
      java.lang.Object ref = workingDir_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        workingDir_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Container's working directory.
     * If not specified, the container runtime's default will be used, which
     * might be configured in the container image.
     * </pre>
     *
     * <code>string working_dir = 9;</code>
     *
     * @param value The workingDir to set.
     * @return This builder for chaining.
     */
    public Builder setWorkingDir(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      workingDir_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container's working directory.
     * If not specified, the container runtime's default will be used, which
     * might be configured in the container image.
     * </pre>
     *
     * <code>string working_dir = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWorkingDir() {
      workingDir_ = getDefaultInstance().getWorkingDir();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Container's working directory.
     * If not specified, the container runtime's default will be used, which
     * might be configured in the container image.
     * </pre>
     *
     * <code>string working_dir = 9;</code>
     *
     * @param value The bytes for workingDir to set.
     * @return This builder for chaining.
     */
    public Builder setWorkingDirBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      workingDir_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.Probe livenessProbe_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Probe,
            com.google.cloud.run.v2.Probe.Builder,
            com.google.cloud.run.v2.ProbeOrBuilder>
        livenessProbeBuilder_;

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     *
     * @return Whether the livenessProbe field is set.
     */
    public boolean hasLivenessProbe() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     *
     * @return The livenessProbe.
     */
    public com.google.cloud.run.v2.Probe getLivenessProbe() {
      if (livenessProbeBuilder_ == null) {
        return livenessProbe_ == null
            ? com.google.cloud.run.v2.Probe.getDefaultInstance()
            : livenessProbe_;
      } else {
        return livenessProbeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public Builder setLivenessProbe(com.google.cloud.run.v2.Probe value) {
      if (livenessProbeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        livenessProbe_ = value;
      } else {
        livenessProbeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public Builder setLivenessProbe(com.google.cloud.run.v2.Probe.Builder builderForValue) {
      if (livenessProbeBuilder_ == null) {
        livenessProbe_ = builderForValue.build();
      } else {
        livenessProbeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public Builder mergeLivenessProbe(com.google.cloud.run.v2.Probe value) {
      if (livenessProbeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && livenessProbe_ != null
            && livenessProbe_ != com.google.cloud.run.v2.Probe.getDefaultInstance()) {
          getLivenessProbeBuilder().mergeFrom(value);
        } else {
          livenessProbe_ = value;
        }
      } else {
        livenessProbeBuilder_.mergeFrom(value);
      }
      if (livenessProbe_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public Builder clearLivenessProbe() {
      bitField0_ = (bitField0_ & ~0x00000400);
      livenessProbe_ = null;
      if (livenessProbeBuilder_ != null) {
        livenessProbeBuilder_.dispose();
        livenessProbeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public com.google.cloud.run.v2.Probe.Builder getLivenessProbeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLivenessProbeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    public com.google.cloud.run.v2.ProbeOrBuilder getLivenessProbeOrBuilder() {
      if (livenessProbeBuilder_ != null) {
        return livenessProbeBuilder_.getMessageOrBuilder();
      } else {
        return livenessProbe_ == null
            ? com.google.cloud.run.v2.Probe.getDefaultInstance()
            : livenessProbe_;
      }
    }

    /**
     *
     *
     * <pre>
     * Periodic probe of container liveness.
     * Container will be restarted if the probe fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe liveness_probe = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Probe,
            com.google.cloud.run.v2.Probe.Builder,
            com.google.cloud.run.v2.ProbeOrBuilder>
        getLivenessProbeFieldBuilder() {
      if (livenessProbeBuilder_ == null) {
        livenessProbeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.Probe,
                com.google.cloud.run.v2.Probe.Builder,
                com.google.cloud.run.v2.ProbeOrBuilder>(
                getLivenessProbe(), getParentForChildren(), isClean());
        livenessProbe_ = null;
      }
      return livenessProbeBuilder_;
    }

    private com.google.cloud.run.v2.Probe startupProbe_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Probe,
            com.google.cloud.run.v2.Probe.Builder,
            com.google.cloud.run.v2.ProbeOrBuilder>
        startupProbeBuilder_;

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     *
     * @return Whether the startupProbe field is set.
     */
    public boolean hasStartupProbe() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     *
     * @return The startupProbe.
     */
    public com.google.cloud.run.v2.Probe getStartupProbe() {
      if (startupProbeBuilder_ == null) {
        return startupProbe_ == null
            ? com.google.cloud.run.v2.Probe.getDefaultInstance()
            : startupProbe_;
      } else {
        return startupProbeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public Builder setStartupProbe(com.google.cloud.run.v2.Probe value) {
      if (startupProbeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startupProbe_ = value;
      } else {
        startupProbeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public Builder setStartupProbe(com.google.cloud.run.v2.Probe.Builder builderForValue) {
      if (startupProbeBuilder_ == null) {
        startupProbe_ = builderForValue.build();
      } else {
        startupProbeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public Builder mergeStartupProbe(com.google.cloud.run.v2.Probe value) {
      if (startupProbeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && startupProbe_ != null
            && startupProbe_ != com.google.cloud.run.v2.Probe.getDefaultInstance()) {
          getStartupProbeBuilder().mergeFrom(value);
        } else {
          startupProbe_ = value;
        }
      } else {
        startupProbeBuilder_.mergeFrom(value);
      }
      if (startupProbe_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public Builder clearStartupProbe() {
      bitField0_ = (bitField0_ & ~0x00000800);
      startupProbe_ = null;
      if (startupProbeBuilder_ != null) {
        startupProbeBuilder_.dispose();
        startupProbeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public com.google.cloud.run.v2.Probe.Builder getStartupProbeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getStartupProbeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    public com.google.cloud.run.v2.ProbeOrBuilder getStartupProbeOrBuilder() {
      if (startupProbeBuilder_ != null) {
        return startupProbeBuilder_.getMessageOrBuilder();
      } else {
        return startupProbe_ == null
            ? com.google.cloud.run.v2.Probe.getDefaultInstance()
            : startupProbe_;
      }
    }

    /**
     *
     *
     * <pre>
     * Startup probe of application within the container.
     * All other probes are disabled if a startup probe is provided, until it
     * succeeds. Container will not be added to service endpoints if the probe
     * fails.
     * </pre>
     *
     * <code>.google.cloud.run.v2.Probe startup_probe = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.Probe,
            com.google.cloud.run.v2.Probe.Builder,
            com.google.cloud.run.v2.ProbeOrBuilder>
        getStartupProbeFieldBuilder() {
      if (startupProbeBuilder_ == null) {
        startupProbeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.Probe,
                com.google.cloud.run.v2.Probe.Builder,
                com.google.cloud.run.v2.ProbeOrBuilder>(
                getStartupProbe(), getParentForChildren(), isClean());
        startupProbe_ = null;
      }
      return startupProbeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList dependsOn_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDependsOnIsMutable() {
      if (!dependsOn_.isModifiable()) {
        dependsOn_ = new com.google.protobuf.LazyStringArrayList(dependsOn_);
      }
      bitField0_ |= 0x00001000;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @return A list containing the dependsOn.
     */
    public com.google.protobuf.ProtocolStringList getDependsOnList() {
      dependsOn_.makeImmutable();
      return dependsOn_;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @return The count of dependsOn.
     */
    public int getDependsOnCount() {
      return dependsOn_.size();
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param index The index of the element to return.
     * @return The dependsOn at the given index.
     */
    public java.lang.String getDependsOn(int index) {
      return dependsOn_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dependsOn at the given index.
     */
    public com.google.protobuf.ByteString getDependsOnBytes(int index) {
      return dependsOn_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param index The index to set the value at.
     * @param value The dependsOn to set.
     * @return This builder for chaining.
     */
    public Builder setDependsOn(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDependsOnIsMutable();
      dependsOn_.set(index, value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param value The dependsOn to add.
     * @return This builder for chaining.
     */
    public Builder addDependsOn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDependsOnIsMutable();
      dependsOn_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param values The dependsOn to add.
     * @return This builder for chaining.
     */
    public Builder addAllDependsOn(java.lang.Iterable<java.lang.String> values) {
      ensureDependsOnIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dependsOn_);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDependsOn() {
      dependsOn_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Names of the containers that must start before this container.
     * </pre>
     *
     * <code>repeated string depends_on = 12;</code>
     *
     * @param value The bytes of the dependsOn to add.
     * @return This builder for chaining.
     */
    public Builder addDependsOnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDependsOnIsMutable();
      dependsOn_.add(value);
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object baseImageUri_ = "";

    /**
     *
     *
     * <pre>
     * Base image for this container. Only supported for services. If set, it
     * indicates that the service is enrolled into automatic base image update.
     * </pre>
     *
     * <code>string base_image_uri = 13;</code>
     *
     * @return The baseImageUri.
     */
    public java.lang.String getBaseImageUri() {
      java.lang.Object ref = baseImageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseImageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Base image for this container. Only supported for services. If set, it
     * indicates that the service is enrolled into automatic base image update.
     * </pre>
     *
     * <code>string base_image_uri = 13;</code>
     *
     * @return The bytes for baseImageUri.
     */
    public com.google.protobuf.ByteString getBaseImageUriBytes() {
      java.lang.Object ref = baseImageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseImageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Base image for this container. Only supported for services. If set, it
     * indicates that the service is enrolled into automatic base image update.
     * </pre>
     *
     * <code>string base_image_uri = 13;</code>
     *
     * @param value The baseImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setBaseImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseImageUri_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Base image for this container. Only supported for services. If set, it
     * indicates that the service is enrolled into automatic base image update.
     * </pre>
     *
     * <code>string base_image_uri = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseImageUri() {
      baseImageUri_ = getDefaultInstance().getBaseImageUri();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Base image for this container. Only supported for services. If set, it
     * indicates that the service is enrolled into automatic base image update.
     * </pre>
     *
     * <code>string base_image_uri = 13;</code>
     *
     * @param value The bytes for baseImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setBaseImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseImageUri_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.BuildInfo buildInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BuildInfo,
            com.google.cloud.run.v2.BuildInfo.Builder,
            com.google.cloud.run.v2.BuildInfoOrBuilder>
        buildInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the buildInfo field is set.
     */
    public boolean hasBuildInfo() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The buildInfo.
     */
    public com.google.cloud.run.v2.BuildInfo getBuildInfo() {
      if (buildInfoBuilder_ == null) {
        return buildInfo_ == null
            ? com.google.cloud.run.v2.BuildInfo.getDefaultInstance()
            : buildInfo_;
      } else {
        return buildInfoBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBuildInfo(com.google.cloud.run.v2.BuildInfo value) {
      if (buildInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildInfo_ = value;
      } else {
        buildInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setBuildInfo(com.google.cloud.run.v2.BuildInfo.Builder builderForValue) {
      if (buildInfoBuilder_ == null) {
        buildInfo_ = builderForValue.build();
      } else {
        buildInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeBuildInfo(com.google.cloud.run.v2.BuildInfo value) {
      if (buildInfoBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && buildInfo_ != null
            && buildInfo_ != com.google.cloud.run.v2.BuildInfo.getDefaultInstance()) {
          getBuildInfoBuilder().mergeFrom(value);
        } else {
          buildInfo_ = value;
        }
      } else {
        buildInfoBuilder_.mergeFrom(value);
      }
      if (buildInfo_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearBuildInfo() {
      bitField0_ = (bitField0_ & ~0x00004000);
      buildInfo_ = null;
      if (buildInfoBuilder_ != null) {
        buildInfoBuilder_.dispose();
        buildInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.BuildInfo.Builder getBuildInfoBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getBuildInfoFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.run.v2.BuildInfoOrBuilder getBuildInfoOrBuilder() {
      if (buildInfoBuilder_ != null) {
        return buildInfoBuilder_.getMessageOrBuilder();
      } else {
        return buildInfo_ == null
            ? com.google.cloud.run.v2.BuildInfo.getDefaultInstance()
            : buildInfo_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The build info of the container image.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.BuildInfo build_info = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.BuildInfo,
            com.google.cloud.run.v2.BuildInfo.Builder,
            com.google.cloud.run.v2.BuildInfoOrBuilder>
        getBuildInfoFieldBuilder() {
      if (buildInfoBuilder_ == null) {
        buildInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.BuildInfo,
                com.google.cloud.run.v2.BuildInfo.Builder,
                com.google.cloud.run.v2.BuildInfoOrBuilder>(
                getBuildInfo(), getParentForChildren(), isClean());
        buildInfo_ = null;
      }
      return buildInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.Container)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.Container)
  private static final com.google.cloud.run.v2.Container DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.Container();
  }

  public static com.google.cloud.run.v2.Container getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Container> PARSER =
      new com.google.protobuf.AbstractParser<Container>() {
        @java.lang.Override
        public Container parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Container> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Container> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.Container getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
