/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/vendor_settings.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Scaling settings applied at the service level rather than
 * at the revision level.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.ServiceScaling}
 */
public final class ServiceScaling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.ServiceScaling)
    ServiceScalingOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ServiceScaling.newBuilder() to construct.
  private ServiceScaling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceScaling() {
    scalingMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceScaling();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_ServiceScaling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.VendorSettingsProto
        .internal_static_google_cloud_run_v2_ServiceScaling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.ServiceScaling.class,
            com.google.cloud.run.v2.ServiceScaling.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The scaling mode for the service. If not provided, it defaults to
   * AUTOMATIC.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.run.v2.ServiceScaling.ScalingMode}
   */
  public enum ScalingMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SCALING_MODE_UNSPECIFIED = 0;</code>
     */
    SCALING_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Scale based on traffic between min and max instances.
     * </pre>
     *
     * <code>AUTOMATIC = 1;</code>
     */
    AUTOMATIC(1),
    /**
     *
     *
     * <pre>
     * Scale to exactly min instances and ignore max instances.
     * </pre>
     *
     * <code>MANUAL = 2;</code>
     */
    MANUAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SCALING_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SCALING_MODE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Scale based on traffic between min and max instances.
     * </pre>
     *
     * <code>AUTOMATIC = 1;</code>
     */
    public static final int AUTOMATIC_VALUE = 1;

    /**
     *
     *
     * <pre>
     * Scale to exactly min instances and ignore max instances.
     * </pre>
     *
     * <code>MANUAL = 2;</code>
     */
    public static final int MANUAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ScalingMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ScalingMode forNumber(int value) {
      switch (value) {
        case 0:
          return SCALING_MODE_UNSPECIFIED;
        case 1:
          return AUTOMATIC;
        case 2:
          return MANUAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ScalingMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ScalingMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ScalingMode>() {
          public ScalingMode findValueByNumber(int number) {
            return ScalingMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.run.v2.ServiceScaling.getDescriptor().getEnumTypes().get(0);
    }

    private static final ScalingMode[] VALUES = values();

    public static ScalingMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ScalingMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.run.v2.ServiceScaling.ScalingMode)
  }

  private int bitField0_;
  public static final int MIN_INSTANCE_COUNT_FIELD_NUMBER = 1;
  private int minInstanceCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. total min instances for the service. This number of instances is
   * divided among all revisions with specified traffic based on the percent
   * of traffic they are receiving.
   * </pre>
   *
   * <code>int32 min_instance_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The minInstanceCount.
   */
  @java.lang.Override
  public int getMinInstanceCount() {
    return minInstanceCount_;
  }

  public static final int SCALING_MODE_FIELD_NUMBER = 3;
  private int scalingMode_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The scaling mode for the service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for scalingMode.
   */
  @java.lang.Override
  public int getScalingModeValue() {
    return scalingMode_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The scaling mode for the service.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The scalingMode.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ServiceScaling.ScalingMode getScalingMode() {
    com.google.cloud.run.v2.ServiceScaling.ScalingMode result =
        com.google.cloud.run.v2.ServiceScaling.ScalingMode.forNumber(scalingMode_);
    return result == null
        ? com.google.cloud.run.v2.ServiceScaling.ScalingMode.UNRECOGNIZED
        : result;
  }

  public static final int MAX_INSTANCE_COUNT_FIELD_NUMBER = 4;
  private int maxInstanceCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. total max instances for the service. This number of instances is
   * divided among all revisions with specified traffic based on the percent
   * of traffic they are receiving.
   * </pre>
   *
   * <code>int32 max_instance_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxInstanceCount.
   */
  @java.lang.Override
  public int getMaxInstanceCount() {
    return maxInstanceCount_;
  }

  public static final int MANUAL_INSTANCE_COUNT_FIELD_NUMBER = 6;
  private int manualInstanceCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. total instance count for the service in manual scaling mode. This
   * number of instances is divided among all revisions with specified traffic
   * based on the percent of traffic they are receiving.
   * </pre>
   *
   * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the manualInstanceCount field is set.
   */
  @java.lang.Override
  public boolean hasManualInstanceCount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. total instance count for the service in manual scaling mode. This
   * number of instances is divided among all revisions with specified traffic
   * based on the percent of traffic they are receiving.
   * </pre>
   *
   * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The manualInstanceCount.
   */
  @java.lang.Override
  public int getManualInstanceCount() {
    return manualInstanceCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (minInstanceCount_ != 0) {
      output.writeInt32(1, minInstanceCount_);
    }
    if (scalingMode_
        != com.google.cloud.run.v2.ServiceScaling.ScalingMode.SCALING_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, scalingMode_);
    }
    if (maxInstanceCount_ != 0) {
      output.writeInt32(4, maxInstanceCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt32(6, manualInstanceCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (minInstanceCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, minInstanceCount_);
    }
    if (scalingMode_
        != com.google.cloud.run.v2.ServiceScaling.ScalingMode.SCALING_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, scalingMode_);
    }
    if (maxInstanceCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxInstanceCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, manualInstanceCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.ServiceScaling)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.ServiceScaling other = (com.google.cloud.run.v2.ServiceScaling) obj;

    if (getMinInstanceCount() != other.getMinInstanceCount()) return false;
    if (scalingMode_ != other.scalingMode_) return false;
    if (getMaxInstanceCount() != other.getMaxInstanceCount()) return false;
    if (hasManualInstanceCount() != other.hasManualInstanceCount()) return false;
    if (hasManualInstanceCount()) {
      if (getManualInstanceCount() != other.getManualInstanceCount()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MIN_INSTANCE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMinInstanceCount();
    hash = (37 * hash) + SCALING_MODE_FIELD_NUMBER;
    hash = (53 * hash) + scalingMode_;
    hash = (37 * hash) + MAX_INSTANCE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstanceCount();
    if (hasManualInstanceCount()) {
      hash = (37 * hash) + MANUAL_INSTANCE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getManualInstanceCount();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.ServiceScaling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.ServiceScaling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Scaling settings applied at the service level rather than
   * at the revision level.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.ServiceScaling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.ServiceScaling)
      com.google.cloud.run.v2.ServiceScalingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_ServiceScaling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_ServiceScaling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.ServiceScaling.class,
              com.google.cloud.run.v2.ServiceScaling.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.ServiceScaling.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      minInstanceCount_ = 0;
      scalingMode_ = 0;
      maxInstanceCount_ = 0;
      manualInstanceCount_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.VendorSettingsProto
          .internal_static_google_cloud_run_v2_ServiceScaling_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ServiceScaling getDefaultInstanceForType() {
      return com.google.cloud.run.v2.ServiceScaling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ServiceScaling build() {
      com.google.cloud.run.v2.ServiceScaling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.ServiceScaling buildPartial() {
      com.google.cloud.run.v2.ServiceScaling result =
          new com.google.cloud.run.v2.ServiceScaling(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.ServiceScaling result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.minInstanceCount_ = minInstanceCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.scalingMode_ = scalingMode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxInstanceCount_ = maxInstanceCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.manualInstanceCount_ = manualInstanceCount_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.ServiceScaling) {
        return mergeFrom((com.google.cloud.run.v2.ServiceScaling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.ServiceScaling other) {
      if (other == com.google.cloud.run.v2.ServiceScaling.getDefaultInstance()) return this;
      if (other.getMinInstanceCount() != 0) {
        setMinInstanceCount(other.getMinInstanceCount());
      }
      if (other.scalingMode_ != 0) {
        setScalingModeValue(other.getScalingModeValue());
      }
      if (other.getMaxInstanceCount() != 0) {
        setMaxInstanceCount(other.getMaxInstanceCount());
      }
      if (other.hasManualInstanceCount()) {
        setManualInstanceCount(other.getManualInstanceCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                minInstanceCount_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 24:
              {
                scalingMode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 24
            case 32:
              {
                maxInstanceCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 48:
              {
                manualInstanceCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int minInstanceCount_;

    /**
     *
     *
     * <pre>
     * Optional. total min instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 min_instance_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minInstanceCount.
     */
    @java.lang.Override
    public int getMinInstanceCount() {
      return minInstanceCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. total min instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 min_instance_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The minInstanceCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinInstanceCount(int value) {

      minInstanceCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. total min instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 min_instance_count = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinInstanceCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      minInstanceCount_ = 0;
      onChanged();
      return this;
    }

    private int scalingMode_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The scaling mode for the service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for scalingMode.
     */
    @java.lang.Override
    public int getScalingModeValue() {
      return scalingMode_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scaling mode for the service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for scalingMode to set.
     * @return This builder for chaining.
     */
    public Builder setScalingModeValue(int value) {
      scalingMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scaling mode for the service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The scalingMode.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.ServiceScaling.ScalingMode getScalingMode() {
      com.google.cloud.run.v2.ServiceScaling.ScalingMode result =
          com.google.cloud.run.v2.ServiceScaling.ScalingMode.forNumber(scalingMode_);
      return result == null
          ? com.google.cloud.run.v2.ServiceScaling.ScalingMode.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scaling mode for the service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The scalingMode to set.
     * @return This builder for chaining.
     */
    public Builder setScalingMode(com.google.cloud.run.v2.ServiceScaling.ScalingMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      scalingMode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The scaling mode for the service.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceScaling.ScalingMode scaling_mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScalingMode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      scalingMode_ = 0;
      onChanged();
      return this;
    }

    private int maxInstanceCount_;

    /**
     *
     *
     * <pre>
     * Optional. total max instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 max_instance_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxInstanceCount.
     */
    @java.lang.Override
    public int getMaxInstanceCount() {
      return maxInstanceCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. total max instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 max_instance_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxInstanceCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstanceCount(int value) {

      maxInstanceCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. total max instances for the service. This number of instances is
     * divided among all revisions with specified traffic based on the percent
     * of traffic they are receiving.
     * </pre>
     *
     * <code>int32 max_instance_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstanceCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxInstanceCount_ = 0;
      onChanged();
      return this;
    }

    private int manualInstanceCount_;

    /**
     *
     *
     * <pre>
     * Optional. total instance count for the service in manual scaling mode. This
     * number of instances is divided among all revisions with specified traffic
     * based on the percent of traffic they are receiving.
     * </pre>
     *
     * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the manualInstanceCount field is set.
     */
    @java.lang.Override
    public boolean hasManualInstanceCount() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. total instance count for the service in manual scaling mode. This
     * number of instances is divided among all revisions with specified traffic
     * based on the percent of traffic they are receiving.
     * </pre>
     *
     * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The manualInstanceCount.
     */
    @java.lang.Override
    public int getManualInstanceCount() {
      return manualInstanceCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. total instance count for the service in manual scaling mode. This
     * number of instances is divided among all revisions with specified traffic
     * based on the percent of traffic they are receiving.
     * </pre>
     *
     * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The manualInstanceCount to set.
     * @return This builder for chaining.
     */
    public Builder setManualInstanceCount(int value) {

      manualInstanceCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. total instance count for the service in manual scaling mode. This
     * number of instances is divided among all revisions with specified traffic
     * based on the percent of traffic they are receiving.
     * </pre>
     *
     * <code>optional int32 manual_instance_count = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearManualInstanceCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      manualInstanceCount_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.ServiceScaling)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.ServiceScaling)
  private static final com.google.cloud.run.v2.ServiceScaling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.ServiceScaling();
  }

  public static com.google.cloud.run.v2.ServiceScaling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceScaling> PARSER =
      new com.google.protobuf.AbstractParser<ServiceScaling>() {
        @java.lang.Override
        public ServiceScaling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceScaling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceScaling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.ServiceScaling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
