/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/k8s.min.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * Source type for the container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.SourceCode}
 */
public final class SourceCode extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.SourceCode)
    SourceCodeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SourceCode.newBuilder() to construct.
  private SourceCode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceCode() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceCode();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_SourceCode_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.K8sMinProto
        .internal_static_google_cloud_run_v2_SourceCode_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.SourceCode.class,
            com.google.cloud.run.v2.SourceCode.Builder.class);
  }

  public interface CloudStorageSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.run.v2.SourceCode.CloudStorageSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket name.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    java.lang.String getBucket();

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket name.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucket.
     */
    com.google.protobuf.ByteString getBucketBytes();

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage object name.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    java.lang.String getObject();

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage object name.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for object.
     */
    com.google.protobuf.ByteString getObjectBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage object generation.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The generation.
     */
    long getGeneration();
  }

  /**
   *
   *
   * <pre>
   * Cloud Storage source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.SourceCode.CloudStorageSource}
   */
  public static final class CloudStorageSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.run.v2.SourceCode.CloudStorageSource)
      CloudStorageSourceOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CloudStorageSource.newBuilder() to construct.
    private CloudStorageSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CloudStorageSource() {
      bucket_ = "";
      object_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CloudStorageSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SourceCode_CloudStorageSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SourceCode_CloudStorageSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.SourceCode.CloudStorageSource.class,
              com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder.class);
    }

    public static final int BUCKET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucket_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket name.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucket.
     */
    @java.lang.Override
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket name.
     * </pre>
     *
     * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucket.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OBJECT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object object_ = "";

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage object name.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The object.
     */
    @java.lang.Override
    public java.lang.String getObject() {
      java.lang.Object ref = object_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        object_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage object name.
     * </pre>
     *
     * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for object.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectBytes() {
      java.lang.Object ref = object_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        object_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERATION_FIELD_NUMBER = 3;
    private long generation_ = 0L;

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage object generation.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, object_);
      }
      if (generation_ != 0L) {
        output.writeInt64(3, generation_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(object_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, object_);
      }
      if (generation_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.run.v2.SourceCode.CloudStorageSource)) {
        return super.equals(obj);
      }
      com.google.cloud.run.v2.SourceCode.CloudStorageSource other =
          (com.google.cloud.run.v2.SourceCode.CloudStorageSource) obj;

      if (!getBucket().equals(other.getBucket())) return false;
      if (!getObject().equals(other.getObject())) return false;
      if (getGeneration() != other.getGeneration()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_FIELD_NUMBER;
      hash = (53 * hash) + getBucket().hashCode();
      hash = (37 * hash) + OBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getObject().hashCode();
      hash = (37 * hash) + GENERATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.run.v2.SourceCode.CloudStorageSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Cloud Storage source.
     * </pre>
     *
     * Protobuf type {@code google.cloud.run.v2.SourceCode.CloudStorageSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.SourceCode.CloudStorageSource)
        com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.run.v2.K8sMinProto
            .internal_static_google_cloud_run_v2_SourceCode_CloudStorageSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.run.v2.K8sMinProto
            .internal_static_google_cloud_run_v2_SourceCode_CloudStorageSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.run.v2.SourceCode.CloudStorageSource.class,
                com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder.class);
      }

      // Construct using com.google.cloud.run.v2.SourceCode.CloudStorageSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        bucket_ = "";
        object_ = "";
        generation_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.run.v2.K8sMinProto
            .internal_static_google_cloud_run_v2_SourceCode_CloudStorageSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.run.v2.SourceCode.CloudStorageSource getDefaultInstanceForType() {
        return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.run.v2.SourceCode.CloudStorageSource build() {
        com.google.cloud.run.v2.SourceCode.CloudStorageSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.run.v2.SourceCode.CloudStorageSource buildPartial() {
        com.google.cloud.run.v2.SourceCode.CloudStorageSource result =
            new com.google.cloud.run.v2.SourceCode.CloudStorageSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.run.v2.SourceCode.CloudStorageSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.bucket_ = bucket_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.object_ = object_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.generation_ = generation_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.run.v2.SourceCode.CloudStorageSource) {
          return mergeFrom((com.google.cloud.run.v2.SourceCode.CloudStorageSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.run.v2.SourceCode.CloudStorageSource other) {
        if (other == com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance())
          return this;
        if (!other.getBucket().isEmpty()) {
          bucket_ = other.bucket_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getObject().isEmpty()) {
          object_ = other.object_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getGeneration() != 0L) {
          setGeneration(other.getGeneration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucket_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  object_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  generation_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object bucket_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket name.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bucket.
       */
      public java.lang.String getBucket() {
        java.lang.Object ref = bucket_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucket_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket name.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bucket.
       */
      public com.google.protobuf.ByteString getBucketBytes() {
        java.lang.Object ref = bucket_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucket_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket name.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucket(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket name.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucket() {
        bucket_ = getDefaultInstance().getBucket();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket name.
       * </pre>
       *
       * <code>string bucket = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bucket to set.
       * @return This builder for chaining.
       */
      public Builder setBucketBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bucket_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object object_ = "";

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage object name.
       * </pre>
       *
       * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The object.
       */
      public java.lang.String getObject() {
        java.lang.Object ref = object_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          object_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage object name.
       * </pre>
       *
       * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for object.
       */
      public com.google.protobuf.ByteString getObjectBytes() {
        java.lang.Object ref = object_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          object_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage object name.
       * </pre>
       *
       * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The object to set.
       * @return This builder for chaining.
       */
      public Builder setObject(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        object_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage object name.
       * </pre>
       *
       * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObject() {
        object_ = getDefaultInstance().getObject();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage object name.
       * </pre>
       *
       * <code>string object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for object to set.
       * @return This builder for chaining.
       */
      public Builder setObjectBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        object_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private long generation_;

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage object generation.
       * </pre>
       *
       * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The generation.
       */
      @java.lang.Override
      public long getGeneration() {
        return generation_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage object generation.
       * </pre>
       *
       * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The generation to set.
       * @return This builder for chaining.
       */
      public Builder setGeneration(long value) {

        generation_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage object generation.
       * </pre>
       *
       * <code>int64 generation = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGeneration() {
        bitField0_ = (bitField0_ & ~0x00000004);
        generation_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.SourceCode.CloudStorageSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.run.v2.SourceCode.CloudStorageSource)
    private static final com.google.cloud.run.v2.SourceCode.CloudStorageSource DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.run.v2.SourceCode.CloudStorageSource();
    }

    public static com.google.cloud.run.v2.SourceCode.CloudStorageSource getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloudStorageSource> PARSER =
        new com.google.protobuf.AbstractParser<CloudStorageSource>() {
          @java.lang.Override
          public CloudStorageSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CloudStorageSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloudStorageSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode.CloudStorageSource getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceType_;

  public enum SourceTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_STORAGE_SOURCE(1),
    SOURCETYPE_NOT_SET(0);
    private final int value;

    private SourceTypeCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return CLOUD_STORAGE_SOURCE;
        case 0:
          return SOURCETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceTypeCase getSourceTypeCase() {
    return SourceTypeCase.forNumber(sourceTypeCase_);
  }

  public static final int CLOUD_STORAGE_SOURCE_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The source is a Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
   *
   * @return Whether the cloudStorageSource field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorageSource() {
    return sourceTypeCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The source is a Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
   *
   * @return The cloudStorageSource.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SourceCode.CloudStorageSource getCloudStorageSource() {
    if (sourceTypeCase_ == 1) {
      return (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_;
    }
    return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The source is a Cloud Storage bucket.
   * </pre>
   *
   * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder
      getCloudStorageSourceOrBuilder() {
    if (sourceTypeCase_ == 1) {
      return (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_;
    }
    return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (sourceTypeCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (sourceTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.SourceCode)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.SourceCode other = (com.google.cloud.run.v2.SourceCode) obj;

    if (!getSourceTypeCase().equals(other.getSourceTypeCase())) return false;
    switch (sourceTypeCase_) {
      case 1:
        if (!getCloudStorageSource().equals(other.getCloudStorageSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (sourceTypeCase_) {
      case 1:
        hash = (37 * hash) + CLOUD_STORAGE_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorageSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SourceCode parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SourceCode parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.SourceCode parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.SourceCode prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Source type for the container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.SourceCode}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.SourceCode)
      com.google.cloud.run.v2.SourceCodeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SourceCode_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SourceCode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.SourceCode.class,
              com.google.cloud.run.v2.SourceCode.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.SourceCode.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cloudStorageSourceBuilder_ != null) {
        cloudStorageSourceBuilder_.clear();
      }
      sourceTypeCase_ = 0;
      sourceType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.K8sMinProto
          .internal_static_google_cloud_run_v2_SourceCode_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode getDefaultInstanceForType() {
      return com.google.cloud.run.v2.SourceCode.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode build() {
      com.google.cloud.run.v2.SourceCode result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode buildPartial() {
      com.google.cloud.run.v2.SourceCode result = new com.google.cloud.run.v2.SourceCode(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.run.v2.SourceCode result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.run.v2.SourceCode result) {
      result.sourceTypeCase_ = sourceTypeCase_;
      result.sourceType_ = this.sourceType_;
      if (sourceTypeCase_ == 1 && cloudStorageSourceBuilder_ != null) {
        result.sourceType_ = cloudStorageSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.SourceCode) {
        return mergeFrom((com.google.cloud.run.v2.SourceCode) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.SourceCode other) {
      if (other == com.google.cloud.run.v2.SourceCode.getDefaultInstance()) return this;
      switch (other.getSourceTypeCase()) {
        case CLOUD_STORAGE_SOURCE:
          {
            mergeCloudStorageSource(other.getCloudStorageSource());
            break;
          }
        case SOURCETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getCloudStorageSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceTypeCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceTypeCase_ = 0;
    private java.lang.Object sourceType_;

    public SourceTypeCase getSourceTypeCase() {
      return SourceTypeCase.forNumber(sourceTypeCase_);
    }

    public Builder clearSourceType() {
      sourceTypeCase_ = 0;
      sourceType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SourceCode.CloudStorageSource,
            com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder,
            com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder>
        cloudStorageSourceBuilder_;

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     *
     * @return Whether the cloudStorageSource field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorageSource() {
      return sourceTypeCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     *
     * @return The cloudStorageSource.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode.CloudStorageSource getCloudStorageSource() {
      if (cloudStorageSourceBuilder_ == null) {
        if (sourceTypeCase_ == 1) {
          return (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_;
        }
        return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
      } else {
        if (sourceTypeCase_ == 1) {
          return cloudStorageSourceBuilder_.getMessage();
        }
        return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    public Builder setCloudStorageSource(
        com.google.cloud.run.v2.SourceCode.CloudStorageSource value) {
      if (cloudStorageSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceType_ = value;
        onChanged();
      } else {
        cloudStorageSourceBuilder_.setMessage(value);
      }
      sourceTypeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    public Builder setCloudStorageSource(
        com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder builderForValue) {
      if (cloudStorageSourceBuilder_ == null) {
        sourceType_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceTypeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    public Builder mergeCloudStorageSource(
        com.google.cloud.run.v2.SourceCode.CloudStorageSource value) {
      if (cloudStorageSourceBuilder_ == null) {
        if (sourceTypeCase_ == 1
            && sourceType_
                != com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance()) {
          sourceType_ =
              com.google.cloud.run.v2.SourceCode.CloudStorageSource.newBuilder(
                      (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceType_ = value;
        }
        onChanged();
      } else {
        if (sourceTypeCase_ == 1) {
          cloudStorageSourceBuilder_.mergeFrom(value);
        } else {
          cloudStorageSourceBuilder_.setMessage(value);
        }
      }
      sourceTypeCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    public Builder clearCloudStorageSource() {
      if (cloudStorageSourceBuilder_ == null) {
        if (sourceTypeCase_ == 1) {
          sourceTypeCase_ = 0;
          sourceType_ = null;
          onChanged();
        }
      } else {
        if (sourceTypeCase_ == 1) {
          sourceTypeCase_ = 0;
          sourceType_ = null;
        }
        cloudStorageSourceBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    public com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder
        getCloudStorageSourceBuilder() {
      return getCloudStorageSourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder
        getCloudStorageSourceOrBuilder() {
      if ((sourceTypeCase_ == 1) && (cloudStorageSourceBuilder_ != null)) {
        return cloudStorageSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceTypeCase_ == 1) {
          return (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_;
        }
        return com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The source is a Cloud Storage bucket.
     * </pre>
     *
     * <code>.google.cloud.run.v2.SourceCode.CloudStorageSource cloud_storage_source = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.SourceCode.CloudStorageSource,
            com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder,
            com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder>
        getCloudStorageSourceFieldBuilder() {
      if (cloudStorageSourceBuilder_ == null) {
        if (!(sourceTypeCase_ == 1)) {
          sourceType_ = com.google.cloud.run.v2.SourceCode.CloudStorageSource.getDefaultInstance();
        }
        cloudStorageSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.SourceCode.CloudStorageSource,
                com.google.cloud.run.v2.SourceCode.CloudStorageSource.Builder,
                com.google.cloud.run.v2.SourceCode.CloudStorageSourceOrBuilder>(
                (com.google.cloud.run.v2.SourceCode.CloudStorageSource) sourceType_,
                getParentForChildren(),
                isClean());
        sourceType_ = null;
      }
      sourceTypeCase_ = 1;
      onChanged();
      return cloudStorageSourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.SourceCode)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.SourceCode)
  private static final com.google.cloud.run.v2.SourceCode DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.SourceCode();
  }

  public static com.google.cloud.run.v2.SourceCode getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceCode> PARSER =
      new com.google.protobuf.AbstractParser<SourceCode>() {
        @java.lang.Override
        public SourceCode parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceCode> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceCode> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.SourceCode getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
