/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/run/v2/worker_pool_revision_template.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.run.v2;

/**
 *
 *
 * <pre>
 * WorkerPoolRevisionTemplate describes the data a worker pool revision should
 * have when created from a template.
 * </pre>
 *
 * Protobuf type {@code google.cloud.run.v2.WorkerPoolRevisionTemplate}
 */
public final class WorkerPoolRevisionTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.run.v2.WorkerPoolRevisionTemplate)
    WorkerPoolRevisionTemplateOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WorkerPoolRevisionTemplate.newBuilder() to construct.
  private WorkerPoolRevisionTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WorkerPoolRevisionTemplate() {
    revision_ = "";
    serviceAccount_ = "";
    containers_ = java.util.Collections.emptyList();
    volumes_ = java.util.Collections.emptyList();
    encryptionKey_ = "";
    encryptionKeyRevocationAction_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WorkerPoolRevisionTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
        .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      case 3:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
        .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.run.v2.WorkerPoolRevisionTemplate.class,
            com.google.cloud.run.v2.WorkerPoolRevisionTemplate.Builder.class);
  }

  private int bitField0_;
  public static final int REVISION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revision_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The unique name for the revision. If this field is omitted, it
   * will be automatically generated based on the WorkerPool name.
   * </pre>
   *
   * <code>
   * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The revision.
   */
  @java.lang.Override
  public java.lang.String getRevision() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revision_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The unique name for the revision. If this field is omitted, it
   * will be automatically generated based on the WorkerPool name.
   * </pre>
   *
   * <code>
   * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for revision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionBytes() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
                .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 WorkerPoolRevisionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 WorkerPoolRevisionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 WorkerPoolRevisionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that can be used to organize and
   * categorize objects. User-provided labels are shared with Google's billing
   * system, so they can be used to filter, or break down billing charges by
   * team, component, environment, state, etc. For more information, visit
   * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
   * https://cloud.google.com/run/docs/configuring/labels.
   *
   * Cloud Run API v2 does not support labels with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system labels in v1 now have a
   * corresponding field in v2 WorkerPoolRevisionTemplate.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 3;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
                .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 WorkerPoolRevisionTemplate.
   *
   * This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }

  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 WorkerPoolRevisionTemplate.
   *
   * This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 WorkerPoolRevisionTemplate.
   *
   * This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Unstructured key value map that may be set by external tools to
   * store and arbitrary metadata. They are not queryable and should be
   * preserved when modifying objects.
   *
   * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
   * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
   * namespaces, and they will be rejected. All system annotations in v1 now
   * have a corresponding field in v2 WorkerPoolRevisionTemplate.
   *
   * This field follows Kubernetes annotations' namespacing, limits, and
   * rules.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int VPC_ACCESS_FIELD_NUMBER = 4;
  private com.google.cloud.run.v2.VpcAccess vpcAccess_;

  /**
   *
   *
   * <pre>
   * Optional. VPC Access configuration to use for this Revision. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the vpcAccess field is set.
   */
  @java.lang.Override
  public boolean hasVpcAccess() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. VPC Access configuration to use for this Revision. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The vpcAccess.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }

  /**
   *
   *
   * <pre>
   * Optional. VPC Access configuration to use for this Revision. For more
   * information, visit
   * https://cloud.google.com/run/docs/configuring/connecting-vpc.
   * </pre>
   *
   * <code>.google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
    return vpcAccess_ == null ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance() : vpcAccess_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Email address of the IAM service account associated with the
   * revision of the service. The service account represents the identity of the
   * running revision, and determines what permissions the revision has. If not
   * provided, the revision will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Email address of the IAM service account associated with the
   * revision of the service. The service account represents the identity of the
   * running revision, and determines what permissions the revision has. If not
   * provided, the revision will use the project's default service account.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINERS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Container> containers_;

  /**
   *
   *
   * <pre>
   * Holds list of the containers that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
    return containers_;
  }

  /**
   *
   *
   * <pre>
   * Holds list of the containers that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
      getContainersOrBuilderList() {
    return containers_;
  }

  /**
   *
   *
   * <pre>
   * Holds list of the containers that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
   */
  @java.lang.Override
  public int getContainersCount() {
    return containers_.size();
  }

  /**
   *
   *
   * <pre>
   * Holds list of the containers that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Container getContainers(int index) {
    return containers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Holds list of the containers that defines the unit of execution for this
   * Revision.
   * </pre>
   *
   * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
    return containers_.get(index);
  }

  public static final int VOLUMES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.run.v2.Volume> volumes_;

  /**
   *
   *
   * <pre>
   * Optional. A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
    return volumes_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
      getVolumesOrBuilderList() {
    return volumes_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getVolumesCount() {
    return volumes_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.Volume getVolumes(int index) {
    return volumes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of Volumes to make available to containers.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
    return volumes_.get(index);
  }

  public static final int ENCRYPTION_KEY_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object encryptionKey_ = "";

  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The encryptionKey.
   */
  @java.lang.Override
  public java.lang.String getEncryptionKey() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      encryptionKey_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A reference to a customer managed encryption key (CMEK) to use to encrypt
   * this container image. For more information, go to
   * https://cloud.google.com/run/docs/securing/using-cmek
   * </pre>
   *
   * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for encryptionKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEncryptionKeyBytes() {
    java.lang.Object ref = encryptionKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      encryptionKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_MESH_FIELD_NUMBER = 9;
  private com.google.cloud.run.v2.ServiceMesh serviceMesh_;

  /**
   *
   *
   * <pre>
   * Optional. Enables service mesh connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the serviceMesh field is set.
   */
  @java.lang.Override
  public boolean hasServiceMesh() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Enables service mesh connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The serviceMesh.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ServiceMesh getServiceMesh() {
    return serviceMesh_ == null
        ? com.google.cloud.run.v2.ServiceMesh.getDefaultInstance()
        : serviceMesh_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Enables service mesh connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.ServiceMeshOrBuilder getServiceMeshOrBuilder() {
    return serviceMesh_ == null
        ? com.google.cloud.run.v2.ServiceMesh.getDefaultInstance()
        : serviceMesh_;
  }

  public static final int ENCRYPTION_KEY_REVOCATION_ACTION_FIELD_NUMBER = 10;
  private int encryptionKeyRevocationAction_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The action to take if the encryption key is revoked.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for encryptionKeyRevocationAction.
   */
  @java.lang.Override
  public int getEncryptionKeyRevocationActionValue() {
    return encryptionKeyRevocationAction_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The action to take if the encryption key is revoked.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionKeyRevocationAction.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.EncryptionKeyRevocationAction getEncryptionKeyRevocationAction() {
    com.google.cloud.run.v2.EncryptionKeyRevocationAction result =
        com.google.cloud.run.v2.EncryptionKeyRevocationAction.forNumber(
            encryptionKeyRevocationAction_);
    return result == null
        ? com.google.cloud.run.v2.EncryptionKeyRevocationAction.UNRECOGNIZED
        : result;
  }

  public static final int ENCRYPTION_KEY_SHUTDOWN_DURATION_FIELD_NUMBER = 11;
  private com.google.protobuf.Duration encryptionKeyShutdownDuration_;

  /**
   *
   *
   * <pre>
   * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
   * before shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionKeyShutdownDuration field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionKeyShutdownDuration() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
   * before shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionKeyShutdownDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getEncryptionKeyShutdownDuration() {
    return encryptionKeyShutdownDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : encryptionKeyShutdownDuration_;
  }

  /**
   *
   *
   * <pre>
   * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
   * before shutting down all instances. The minimum increment is 1 hour.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getEncryptionKeyShutdownDurationOrBuilder() {
    return encryptionKeyShutdownDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : encryptionKeyShutdownDuration_;
  }

  public static final int NODE_SELECTOR_FIELD_NUMBER = 13;
  private com.google.cloud.run.v2.NodeSelector nodeSelector_;

  /**
   *
   *
   * <pre>
   * Optional. The node selector for the revision template.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nodeSelector field is set.
   */
  @java.lang.Override
  public boolean hasNodeSelector() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The node selector for the revision template.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nodeSelector.
   */
  @java.lang.Override
  public com.google.cloud.run.v2.NodeSelector getNodeSelector() {
    return nodeSelector_ == null
        ? com.google.cloud.run.v2.NodeSelector.getDefaultInstance()
        : nodeSelector_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The node selector for the revision template.
   * </pre>
   *
   * <code>
   * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.run.v2.NodeSelectorOrBuilder getNodeSelectorOrBuilder() {
    return nodeSelector_ == null
        ? com.google.cloud.run.v2.NodeSelector.getDefaultInstance()
        : nodeSelector_;
  }

  public static final int GPU_ZONAL_REDUNDANCY_DISABLED_FIELD_NUMBER = 16;
  private boolean gpuZonalRedundancyDisabled_ = false;

  /**
   *
   *
   * <pre>
   * Optional. True if GPU zonal redundancy is disabled on this worker pool.
   * </pre>
   *
   * <code>
   * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gpuZonalRedundancyDisabled field is set.
   */
  @java.lang.Override
  public boolean hasGpuZonalRedundancyDisabled() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. True if GPU zonal redundancy is disabled on this worker pool.
   * </pre>
   *
   * <code>
   * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gpuZonalRedundancyDisabled.
   */
  @java.lang.Override
  public boolean getGpuZonalRedundancyDisabled() {
    return gpuZonalRedundancyDisabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, revision_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 3);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getVpcAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccount_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      output.writeMessage(6, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      output.writeMessage(7, volumes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, encryptionKey_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getServiceMesh());
    }
    if (encryptionKeyRevocationAction_
        != com.google.cloud.run.v2.EncryptionKeyRevocationAction
            .ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, encryptionKeyRevocationAction_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getEncryptionKeyShutdownDuration());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getNodeSelector());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(16, gpuZonalRedundancyDisabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, revision_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, annotations__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getVpcAccess());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccount_);
    }
    for (int i = 0; i < containers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, containers_.get(i));
    }
    for (int i = 0; i < volumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, volumes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(encryptionKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, encryptionKey_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getServiceMesh());
    }
    if (encryptionKeyRevocationAction_
        != com.google.cloud.run.v2.EncryptionKeyRevocationAction
            .ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(10, encryptionKeyRevocationAction_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getEncryptionKeyShutdownDuration());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getNodeSelector());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(16, gpuZonalRedundancyDisabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.run.v2.WorkerPoolRevisionTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.run.v2.WorkerPoolRevisionTemplate other =
        (com.google.cloud.run.v2.WorkerPoolRevisionTemplate) obj;

    if (!getRevision().equals(other.getRevision())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (hasVpcAccess() != other.hasVpcAccess()) return false;
    if (hasVpcAccess()) {
      if (!getVpcAccess().equals(other.getVpcAccess())) return false;
    }
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (!getContainersList().equals(other.getContainersList())) return false;
    if (!getVolumesList().equals(other.getVolumesList())) return false;
    if (!getEncryptionKey().equals(other.getEncryptionKey())) return false;
    if (hasServiceMesh() != other.hasServiceMesh()) return false;
    if (hasServiceMesh()) {
      if (!getServiceMesh().equals(other.getServiceMesh())) return false;
    }
    if (encryptionKeyRevocationAction_ != other.encryptionKeyRevocationAction_) return false;
    if (hasEncryptionKeyShutdownDuration() != other.hasEncryptionKeyShutdownDuration())
      return false;
    if (hasEncryptionKeyShutdownDuration()) {
      if (!getEncryptionKeyShutdownDuration().equals(other.getEncryptionKeyShutdownDuration()))
        return false;
    }
    if (hasNodeSelector() != other.hasNodeSelector()) return false;
    if (hasNodeSelector()) {
      if (!getNodeSelector().equals(other.getNodeSelector())) return false;
    }
    if (hasGpuZonalRedundancyDisabled() != other.hasGpuZonalRedundancyDisabled()) return false;
    if (hasGpuZonalRedundancyDisabled()) {
      if (getGpuZonalRedundancyDisabled() != other.getGpuZonalRedundancyDisabled()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (hasVpcAccess()) {
      hash = (37 * hash) + VPC_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getVpcAccess().hashCode();
    }
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (getContainersCount() > 0) {
      hash = (37 * hash) + CONTAINERS_FIELD_NUMBER;
      hash = (53 * hash) + getContainersList().hashCode();
    }
    if (getVolumesCount() > 0) {
      hash = (37 * hash) + VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getVolumesList().hashCode();
    }
    hash = (37 * hash) + ENCRYPTION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getEncryptionKey().hashCode();
    if (hasServiceMesh()) {
      hash = (37 * hash) + SERVICE_MESH_FIELD_NUMBER;
      hash = (53 * hash) + getServiceMesh().hashCode();
    }
    hash = (37 * hash) + ENCRYPTION_KEY_REVOCATION_ACTION_FIELD_NUMBER;
    hash = (53 * hash) + encryptionKeyRevocationAction_;
    if (hasEncryptionKeyShutdownDuration()) {
      hash = (37 * hash) + ENCRYPTION_KEY_SHUTDOWN_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionKeyShutdownDuration().hashCode();
    }
    if (hasNodeSelector()) {
      hash = (37 * hash) + NODE_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getNodeSelector().hashCode();
    }
    if (hasGpuZonalRedundancyDisabled()) {
      hash = (37 * hash) + GPU_ZONAL_REDUNDANCY_DISABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGpuZonalRedundancyDisabled());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.run.v2.WorkerPoolRevisionTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * WorkerPoolRevisionTemplate describes the data a worker pool revision should
   * have when created from a template.
   * </pre>
   *
   * Protobuf type {@code google.cloud.run.v2.WorkerPoolRevisionTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.run.v2.WorkerPoolRevisionTemplate)
      com.google.cloud.run.v2.WorkerPoolRevisionTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
          .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        case 3:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        case 3:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
          .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.run.v2.WorkerPoolRevisionTemplate.class,
              com.google.cloud.run.v2.WorkerPoolRevisionTemplate.Builder.class);
    }

    // Construct using com.google.cloud.run.v2.WorkerPoolRevisionTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVpcAccessFieldBuilder();
        getContainersFieldBuilder();
        getVolumesFieldBuilder();
        getServiceMeshFieldBuilder();
        getEncryptionKeyShutdownDurationFieldBuilder();
        getNodeSelectorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      revision_ = "";
      internalGetMutableLabels().clear();
      internalGetMutableAnnotations().clear();
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      serviceAccount_ = "";
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
      } else {
        containers_ = null;
        containersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
      } else {
        volumes_ = null;
        volumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      encryptionKey_ = "";
      serviceMesh_ = null;
      if (serviceMeshBuilder_ != null) {
        serviceMeshBuilder_.dispose();
        serviceMeshBuilder_ = null;
      }
      encryptionKeyRevocationAction_ = 0;
      encryptionKeyShutdownDuration_ = null;
      if (encryptionKeyShutdownDurationBuilder_ != null) {
        encryptionKeyShutdownDurationBuilder_.dispose();
        encryptionKeyShutdownDurationBuilder_ = null;
      }
      nodeSelector_ = null;
      if (nodeSelectorBuilder_ != null) {
        nodeSelectorBuilder_.dispose();
        nodeSelectorBuilder_ = null;
      }
      gpuZonalRedundancyDisabled_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.run.v2.WorkerPoolRevisionTemplateProto
          .internal_static_google_cloud_run_v2_WorkerPoolRevisionTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.WorkerPoolRevisionTemplate getDefaultInstanceForType() {
      return com.google.cloud.run.v2.WorkerPoolRevisionTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.run.v2.WorkerPoolRevisionTemplate build() {
      com.google.cloud.run.v2.WorkerPoolRevisionTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.run.v2.WorkerPoolRevisionTemplate buildPartial() {
      com.google.cloud.run.v2.WorkerPoolRevisionTemplate result =
          new com.google.cloud.run.v2.WorkerPoolRevisionTemplate(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.run.v2.WorkerPoolRevisionTemplate result) {
      if (containersBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          containers_ = java.util.Collections.unmodifiableList(containers_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.containers_ = containers_;
      } else {
        result.containers_ = containersBuilder_.build();
      }
      if (volumesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          volumes_ = java.util.Collections.unmodifiableList(volumes_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.volumes_ = volumes_;
      } else {
        result.volumes_ = volumesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.run.v2.WorkerPoolRevisionTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.revision_ = revision_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.vpcAccess_ = vpcAccessBuilder_ == null ? vpcAccess_ : vpcAccessBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.encryptionKey_ = encryptionKey_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.serviceMesh_ =
            serviceMeshBuilder_ == null ? serviceMesh_ : serviceMeshBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.encryptionKeyRevocationAction_ = encryptionKeyRevocationAction_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.encryptionKeyShutdownDuration_ =
            encryptionKeyShutdownDurationBuilder_ == null
                ? encryptionKeyShutdownDuration_
                : encryptionKeyShutdownDurationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.nodeSelector_ =
            nodeSelectorBuilder_ == null ? nodeSelector_ : nodeSelectorBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.gpuZonalRedundancyDisabled_ = gpuZonalRedundancyDisabled_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.run.v2.WorkerPoolRevisionTemplate) {
        return mergeFrom((com.google.cloud.run.v2.WorkerPoolRevisionTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.run.v2.WorkerPoolRevisionTemplate other) {
      if (other == com.google.cloud.run.v2.WorkerPoolRevisionTemplate.getDefaultInstance())
        return this;
      if (!other.getRevision().isEmpty()) {
        revision_ = other.revision_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000004;
      if (other.hasVpcAccess()) {
        mergeVpcAccess(other.getVpcAccess());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (containersBuilder_ == null) {
        if (!other.containers_.isEmpty()) {
          if (containers_.isEmpty()) {
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureContainersIsMutable();
            containers_.addAll(other.containers_);
          }
          onChanged();
        }
      } else {
        if (!other.containers_.isEmpty()) {
          if (containersBuilder_.isEmpty()) {
            containersBuilder_.dispose();
            containersBuilder_ = null;
            containers_ = other.containers_;
            bitField0_ = (bitField0_ & ~0x00000020);
            containersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContainersFieldBuilder()
                    : null;
          } else {
            containersBuilder_.addAllMessages(other.containers_);
          }
        }
      }
      if (volumesBuilder_ == null) {
        if (!other.volumes_.isEmpty()) {
          if (volumes_.isEmpty()) {
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureVolumesIsMutable();
            volumes_.addAll(other.volumes_);
          }
          onChanged();
        }
      } else {
        if (!other.volumes_.isEmpty()) {
          if (volumesBuilder_.isEmpty()) {
            volumesBuilder_.dispose();
            volumesBuilder_ = null;
            volumes_ = other.volumes_;
            bitField0_ = (bitField0_ & ~0x00000040);
            volumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVolumesFieldBuilder()
                    : null;
          } else {
            volumesBuilder_.addAllMessages(other.volumes_);
          }
        }
      }
      if (!other.getEncryptionKey().isEmpty()) {
        encryptionKey_ = other.encryptionKey_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasServiceMesh()) {
        mergeServiceMesh(other.getServiceMesh());
      }
      if (other.encryptionKeyRevocationAction_ != 0) {
        setEncryptionKeyRevocationActionValue(other.getEncryptionKeyRevocationActionValue());
      }
      if (other.hasEncryptionKeyShutdownDuration()) {
        mergeEncryptionKeyShutdownDuration(other.getEncryptionKeyShutdownDuration());
      }
      if (other.hasNodeSelector()) {
        mergeNodeSelector(other.getNodeSelector());
      }
      if (other.hasGpuZonalRedundancyDisabled()) {
        setGpuZonalRedundancyDisabled(other.getGpuZonalRedundancyDisabled());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                revision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getVpcAccessFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.run.v2.Container m =
                    input.readMessage(
                        com.google.cloud.run.v2.Container.parser(), extensionRegistry);
                if (containersBuilder_ == null) {
                  ensureContainersIsMutable();
                  containers_.add(m);
                } else {
                  containersBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.run.v2.Volume m =
                    input.readMessage(com.google.cloud.run.v2.Volume.parser(), extensionRegistry);
                if (volumesBuilder_ == null) {
                  ensureVolumesIsMutable();
                  volumes_.add(m);
                } else {
                  volumesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                encryptionKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getServiceMeshFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                encryptionKeyRevocationAction_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(
                    getEncryptionKeyShutdownDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 106:
              {
                input.readMessage(getNodeSelectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 128:
              {
                gpuZonalRedundancyDisabled_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 128
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object revision_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The unique name for the revision. If this field is omitted, it
     * will be automatically generated based on the WorkerPool name.
     * </pre>
     *
     * <code>
     * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The revision.
     */
    public java.lang.String getRevision() {
      java.lang.Object ref = revision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name for the revision. If this field is omitted, it
     * will be automatically generated based on the WorkerPool name.
     * </pre>
     *
     * <code>
     * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for revision.
     */
    public com.google.protobuf.ByteString getRevisionBytes() {
      java.lang.Object ref = revision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name for the revision. If this field is omitted, it
     * will be automatically generated based on the WorkerPool name.
     * </pre>
     *
     * <code>
     * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revision_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name for the revision. If this field is omitted, it
     * will be automatically generated based on the WorkerPool name.
     * </pre>
     *
     * <code>
     * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevision() {
      revision_ = getDefaultInstance().getRevision();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The unique name for the revision. If this field is omitted, it
     * will be automatically generated based on the WorkerPool name.
     * </pre>
     *
     * <code>
     * string revision = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revision_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that can be used to organize and
     * categorize objects. User-provided labels are shared with Google's billing
     * system, so they can be used to filter, or break down billing charges by
     * team, component, environment, state, etc. For more information, visit
     * https://cloud.google.com/resource-manager/docs/creating-managing-labels or
     * https://cloud.google.com/run/docs/configuring/labels.
     *
     * Cloud Run API v2 does not support labels with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system labels in v1 now have a
     * corresponding field in v2 WorkerPoolRevisionTemplate.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }

    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000004;
      return internalGetMutableAnnotations().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Unstructured key value map that may be set by external tools to
     * store and arbitrary metadata. They are not queryable and should be
     * preserved when modifying objects.
     *
     * Cloud Run API v2 does not support annotations with `run.googleapis.com`,
     * `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
     * namespaces, and they will be rejected. All system annotations in v1 now
     * have a corresponding field in v2 WorkerPoolRevisionTemplate.
     *
     * This field follows Kubernetes annotations' namespacing, limits, and
     * rules.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.cloud.run.v2.VpcAccess vpcAccess_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        vpcAccessBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the vpcAccess field is set.
     */
    public boolean hasVpcAccess() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The vpcAccess.
     */
    public com.google.cloud.run.v2.VpcAccess getVpcAccess() {
      if (vpcAccessBuilder_ == null) {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      } else {
        return vpcAccessBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vpcAccess_ = value;
      } else {
        vpcAccessBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVpcAccess(com.google.cloud.run.v2.VpcAccess.Builder builderForValue) {
      if (vpcAccessBuilder_ == null) {
        vpcAccess_ = builderForValue.build();
      } else {
        vpcAccessBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeVpcAccess(com.google.cloud.run.v2.VpcAccess value) {
      if (vpcAccessBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && vpcAccess_ != null
            && vpcAccess_ != com.google.cloud.run.v2.VpcAccess.getDefaultInstance()) {
          getVpcAccessBuilder().mergeFrom(value);
        } else {
          vpcAccess_ = value;
        }
      } else {
        vpcAccessBuilder_.mergeFrom(value);
      }
      if (vpcAccess_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVpcAccess() {
      bitField0_ = (bitField0_ & ~0x00000008);
      vpcAccess_ = null;
      if (vpcAccessBuilder_ != null) {
        vpcAccessBuilder_.dispose();
        vpcAccessBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.VpcAccess.Builder getVpcAccessBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getVpcAccessFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.VpcAccessOrBuilder getVpcAccessOrBuilder() {
      if (vpcAccessBuilder_ != null) {
        return vpcAccessBuilder_.getMessageOrBuilder();
      } else {
        return vpcAccess_ == null
            ? com.google.cloud.run.v2.VpcAccess.getDefaultInstance()
            : vpcAccess_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.VpcAccess vpc_access = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.VpcAccess,
            com.google.cloud.run.v2.VpcAccess.Builder,
            com.google.cloud.run.v2.VpcAccessOrBuilder>
        getVpcAccessFieldBuilder() {
      if (vpcAccessBuilder_ == null) {
        vpcAccessBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.VpcAccess,
                com.google.cloud.run.v2.VpcAccess.Builder,
                com.google.cloud.run.v2.VpcAccessOrBuilder>(
                getVpcAccess(), getParentForChildren(), isClean());
        vpcAccess_ = null;
      }
      return vpcAccessBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Email address of the IAM service account associated with the
     * revision of the service. The service account represents the identity of the
     * running revision, and determines what permissions the revision has. If not
     * provided, the revision will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email address of the IAM service account associated with the
     * revision of the service. The service account represents the identity of the
     * running revision, and determines what permissions the revision has. If not
     * provided, the revision will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Email address of the IAM service account associated with the
     * revision of the service. The service account represents the identity of the
     * running revision, and determines what permissions the revision has. If not
     * provided, the revision will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email address of the IAM service account associated with the
     * revision of the service. The service account represents the identity of the
     * running revision, and determines what permissions the revision has. If not
     * provided, the revision will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Email address of the IAM service account associated with the
     * revision of the service. The service account represents the identity of the
     * running revision, and determines what permissions the revision has. If not
     * provided, the revision will use the project's default service account.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.run.v2.Container> containers_ =
        java.util.Collections.emptyList();

    private void ensureContainersIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        containers_ = new java.util.ArrayList<com.google.cloud.run.v2.Container>(containers_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        containersBuilder_;

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container> getContainersList() {
      if (containersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(containers_);
      } else {
        return containersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public int getContainersCount() {
      if (containersBuilder_ == null) {
        return containers_.size();
      } else {
        return containersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public com.google.cloud.run.v2.Container getContainers(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder setContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.set(index, value);
        onChanged();
      } else {
        containersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder setContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.set(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(value);
        onChanged();
      } else {
        containersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder addContainers(int index, com.google.cloud.run.v2.Container value) {
      if (containersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContainersIsMutable();
        containers_.add(index, value);
        onChanged();
      } else {
        containersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder addContainers(com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder addContainers(
        int index, com.google.cloud.run.v2.Container.Builder builderForValue) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.add(index, builderForValue.build());
        onChanged();
      } else {
        containersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder addAllContainers(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Container> values) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, containers_);
        onChanged();
      } else {
        containersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder clearContainers() {
      if (containersBuilder_ == null) {
        containers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        containersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public Builder removeContainers(int index) {
      if (containersBuilder_ == null) {
        ensureContainersIsMutable();
        containers_.remove(index);
        onChanged();
      } else {
        containersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public com.google.cloud.run.v2.Container.Builder getContainersBuilder(int index) {
      return getContainersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public com.google.cloud.run.v2.ContainerOrBuilder getContainersOrBuilder(int index) {
      if (containersBuilder_ == null) {
        return containers_.get(index);
      } else {
        return containersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersOrBuilderList() {
      if (containersBuilder_ != null) {
        return containersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(containers_);
      }
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder() {
      return getContainersFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Container.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public com.google.cloud.run.v2.Container.Builder addContainersBuilder(int index) {
      return getContainersFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Container.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Holds list of the containers that defines the unit of execution for this
     * Revision.
     * </pre>
     *
     * <code>repeated .google.cloud.run.v2.Container containers = 6;</code>
     */
    public java.util.List<com.google.cloud.run.v2.Container.Builder> getContainersBuilderList() {
      return getContainersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Container,
            com.google.cloud.run.v2.Container.Builder,
            com.google.cloud.run.v2.ContainerOrBuilder>
        getContainersFieldBuilder() {
      if (containersBuilder_ == null) {
        containersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Container,
                com.google.cloud.run.v2.Container.Builder,
                com.google.cloud.run.v2.ContainerOrBuilder>(
                containers_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        containers_ = null;
      }
      return containersBuilder_;
    }

    private java.util.List<com.google.cloud.run.v2.Volume> volumes_ =
        java.util.Collections.emptyList();

    private void ensureVolumesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        volumes_ = new java.util.ArrayList<com.google.cloud.run.v2.Volume>(volumes_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        volumesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume> getVolumesList() {
      if (volumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(volumes_);
      } else {
        return volumesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getVolumesCount() {
      if (volumesBuilder_ == null) {
        return volumes_.size();
      } else {
        return volumesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.Volume getVolumes(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.set(index, value);
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume value) {
      if (volumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVolumesIsMutable();
        volumes_.add(index, value);
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addVolumes(com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addVolumes(int index, com.google.cloud.run.v2.Volume.Builder builderForValue) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        volumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllVolumes(
        java.lang.Iterable<? extends com.google.cloud.run.v2.Volume> values) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumes_);
        onChanged();
      } else {
        volumesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearVolumes() {
      if (volumesBuilder_ == null) {
        volumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        volumesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeVolumes(int index) {
      if (volumesBuilder_ == null) {
        ensureVolumesIsMutable();
        volumes_.remove(index);
        onChanged();
      } else {
        volumesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.Volume.Builder getVolumesBuilder(int index) {
      return getVolumesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.VolumeOrBuilder getVolumesOrBuilder(int index) {
      if (volumesBuilder_ == null) {
        return volumes_.get(index);
      } else {
        return volumesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesOrBuilderList() {
      if (volumesBuilder_ != null) {
        return volumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(volumes_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder() {
      return getVolumesFieldBuilder()
          .addBuilder(com.google.cloud.run.v2.Volume.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.Volume.Builder addVolumesBuilder(int index) {
      return getVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.run.v2.Volume.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of Volumes to make available to containers.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.run.v2.Volume volumes = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.run.v2.Volume.Builder> getVolumesBuilderList() {
      return getVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.run.v2.Volume,
            com.google.cloud.run.v2.Volume.Builder,
            com.google.cloud.run.v2.VolumeOrBuilder>
        getVolumesFieldBuilder() {
      if (volumesBuilder_ == null) {
        volumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.run.v2.Volume,
                com.google.cloud.run.v2.Volume.Builder,
                com.google.cloud.run.v2.VolumeOrBuilder>(
                volumes_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        volumes_ = null;
      }
      return volumesBuilder_;
    }

    private java.lang.Object encryptionKey_ = "";

    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The encryptionKey.
     */
    public java.lang.String getEncryptionKey() {
      java.lang.Object ref = encryptionKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        encryptionKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for encryptionKey.
     */
    public com.google.protobuf.ByteString getEncryptionKeyBytes() {
      java.lang.Object ref = encryptionKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        encryptionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      encryptionKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionKey() {
      encryptionKey_ = getDefaultInstance().getEncryptionKey();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     * </pre>
     *
     * <code>string encryption_key = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for encryptionKey to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      encryptionKey_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.run.v2.ServiceMesh serviceMesh_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ServiceMesh,
            com.google.cloud.run.v2.ServiceMesh.Builder,
            com.google.cloud.run.v2.ServiceMeshOrBuilder>
        serviceMeshBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the serviceMesh field is set.
     */
    public boolean hasServiceMesh() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The serviceMesh.
     */
    public com.google.cloud.run.v2.ServiceMesh getServiceMesh() {
      if (serviceMeshBuilder_ == null) {
        return serviceMesh_ == null
            ? com.google.cloud.run.v2.ServiceMesh.getDefaultInstance()
            : serviceMesh_;
      } else {
        return serviceMeshBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServiceMesh(com.google.cloud.run.v2.ServiceMesh value) {
      if (serviceMeshBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceMesh_ = value;
      } else {
        serviceMeshBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setServiceMesh(com.google.cloud.run.v2.ServiceMesh.Builder builderForValue) {
      if (serviceMeshBuilder_ == null) {
        serviceMesh_ = builderForValue.build();
      } else {
        serviceMeshBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeServiceMesh(com.google.cloud.run.v2.ServiceMesh value) {
      if (serviceMeshBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && serviceMesh_ != null
            && serviceMesh_ != com.google.cloud.run.v2.ServiceMesh.getDefaultInstance()) {
          getServiceMeshBuilder().mergeFrom(value);
        } else {
          serviceMesh_ = value;
        }
      } else {
        serviceMeshBuilder_.mergeFrom(value);
      }
      if (serviceMesh_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearServiceMesh() {
      bitField0_ = (bitField0_ & ~0x00000100);
      serviceMesh_ = null;
      if (serviceMeshBuilder_ != null) {
        serviceMeshBuilder_.dispose();
        serviceMeshBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.ServiceMesh.Builder getServiceMeshBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getServiceMeshFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.ServiceMeshOrBuilder getServiceMeshOrBuilder() {
      if (serviceMeshBuilder_ != null) {
        return serviceMeshBuilder_.getMessageOrBuilder();
      } else {
        return serviceMesh_ == null
            ? com.google.cloud.run.v2.ServiceMesh.getDefaultInstance()
            : serviceMesh_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Enables service mesh connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.ServiceMesh service_mesh = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.ServiceMesh,
            com.google.cloud.run.v2.ServiceMesh.Builder,
            com.google.cloud.run.v2.ServiceMeshOrBuilder>
        getServiceMeshFieldBuilder() {
      if (serviceMeshBuilder_ == null) {
        serviceMeshBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.ServiceMesh,
                com.google.cloud.run.v2.ServiceMesh.Builder,
                com.google.cloud.run.v2.ServiceMeshOrBuilder>(
                getServiceMesh(), getParentForChildren(), isClean());
        serviceMesh_ = null;
      }
      return serviceMeshBuilder_;
    }

    private int encryptionKeyRevocationAction_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The action to take if the encryption key is revoked.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for encryptionKeyRevocationAction.
     */
    @java.lang.Override
    public int getEncryptionKeyRevocationActionValue() {
      return encryptionKeyRevocationAction_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The action to take if the encryption key is revoked.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for encryptionKeyRevocationAction to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKeyRevocationActionValue(int value) {
      encryptionKeyRevocationAction_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The action to take if the encryption key is revoked.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionKeyRevocationAction.
     */
    @java.lang.Override
    public com.google.cloud.run.v2.EncryptionKeyRevocationAction
        getEncryptionKeyRevocationAction() {
      com.google.cloud.run.v2.EncryptionKeyRevocationAction result =
          com.google.cloud.run.v2.EncryptionKeyRevocationAction.forNumber(
              encryptionKeyRevocationAction_);
      return result == null
          ? com.google.cloud.run.v2.EncryptionKeyRevocationAction.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The action to take if the encryption key is revoked.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The encryptionKeyRevocationAction to set.
     * @return This builder for chaining.
     */
    public Builder setEncryptionKeyRevocationAction(
        com.google.cloud.run.v2.EncryptionKeyRevocationAction value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      encryptionKeyRevocationAction_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The action to take if the encryption key is revoked.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEncryptionKeyRevocationAction() {
      bitField0_ = (bitField0_ & ~0x00000200);
      encryptionKeyRevocationAction_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration encryptionKeyShutdownDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        encryptionKeyShutdownDurationBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionKeyShutdownDuration field is set.
     */
    public boolean hasEncryptionKeyShutdownDuration() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionKeyShutdownDuration.
     */
    public com.google.protobuf.Duration getEncryptionKeyShutdownDuration() {
      if (encryptionKeyShutdownDurationBuilder_ == null) {
        return encryptionKeyShutdownDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : encryptionKeyShutdownDuration_;
      } else {
        return encryptionKeyShutdownDurationBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionKeyShutdownDuration(com.google.protobuf.Duration value) {
      if (encryptionKeyShutdownDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionKeyShutdownDuration_ = value;
      } else {
        encryptionKeyShutdownDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionKeyShutdownDuration(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (encryptionKeyShutdownDurationBuilder_ == null) {
        encryptionKeyShutdownDuration_ = builderForValue.build();
      } else {
        encryptionKeyShutdownDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionKeyShutdownDuration(com.google.protobuf.Duration value) {
      if (encryptionKeyShutdownDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && encryptionKeyShutdownDuration_ != null
            && encryptionKeyShutdownDuration_
                != com.google.protobuf.Duration.getDefaultInstance()) {
          getEncryptionKeyShutdownDurationBuilder().mergeFrom(value);
        } else {
          encryptionKeyShutdownDuration_ = value;
        }
      } else {
        encryptionKeyShutdownDurationBuilder_.mergeFrom(value);
      }
      if (encryptionKeyShutdownDuration_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionKeyShutdownDuration() {
      bitField0_ = (bitField0_ & ~0x00000400);
      encryptionKeyShutdownDuration_ = null;
      if (encryptionKeyShutdownDurationBuilder_ != null) {
        encryptionKeyShutdownDurationBuilder_.dispose();
        encryptionKeyShutdownDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getEncryptionKeyShutdownDurationBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getEncryptionKeyShutdownDurationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getEncryptionKeyShutdownDurationOrBuilder() {
      if (encryptionKeyShutdownDurationBuilder_ != null) {
        return encryptionKeyShutdownDurationBuilder_.getMessageOrBuilder();
      } else {
        return encryptionKeyShutdownDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : encryptionKeyShutdownDuration_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
     * before shutting down all instances. The minimum increment is 1 hour.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration encryption_key_shutdown_duration = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getEncryptionKeyShutdownDurationFieldBuilder() {
      if (encryptionKeyShutdownDurationBuilder_ == null) {
        encryptionKeyShutdownDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getEncryptionKeyShutdownDuration(), getParentForChildren(), isClean());
        encryptionKeyShutdownDuration_ = null;
      }
      return encryptionKeyShutdownDurationBuilder_;
    }

    private com.google.cloud.run.v2.NodeSelector nodeSelector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.NodeSelector,
            com.google.cloud.run.v2.NodeSelector.Builder,
            com.google.cloud.run.v2.NodeSelectorOrBuilder>
        nodeSelectorBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nodeSelector field is set.
     */
    public boolean hasNodeSelector() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nodeSelector.
     */
    public com.google.cloud.run.v2.NodeSelector getNodeSelector() {
      if (nodeSelectorBuilder_ == null) {
        return nodeSelector_ == null
            ? com.google.cloud.run.v2.NodeSelector.getDefaultInstance()
            : nodeSelector_;
      } else {
        return nodeSelectorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeSelector(com.google.cloud.run.v2.NodeSelector value) {
      if (nodeSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeSelector_ = value;
      } else {
        nodeSelectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodeSelector(com.google.cloud.run.v2.NodeSelector.Builder builderForValue) {
      if (nodeSelectorBuilder_ == null) {
        nodeSelector_ = builderForValue.build();
      } else {
        nodeSelectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNodeSelector(com.google.cloud.run.v2.NodeSelector value) {
      if (nodeSelectorBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && nodeSelector_ != null
            && nodeSelector_ != com.google.cloud.run.v2.NodeSelector.getDefaultInstance()) {
          getNodeSelectorBuilder().mergeFrom(value);
        } else {
          nodeSelector_ = value;
        }
      } else {
        nodeSelectorBuilder_.mergeFrom(value);
      }
      if (nodeSelector_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNodeSelector() {
      bitField0_ = (bitField0_ & ~0x00000800);
      nodeSelector_ = null;
      if (nodeSelectorBuilder_ != null) {
        nodeSelectorBuilder_.dispose();
        nodeSelectorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.NodeSelector.Builder getNodeSelectorBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getNodeSelectorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.run.v2.NodeSelectorOrBuilder getNodeSelectorOrBuilder() {
      if (nodeSelectorBuilder_ != null) {
        return nodeSelectorBuilder_.getMessageOrBuilder();
      } else {
        return nodeSelector_ == null
            ? com.google.cloud.run.v2.NodeSelector.getDefaultInstance()
            : nodeSelector_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The node selector for the revision template.
     * </pre>
     *
     * <code>
     * .google.cloud.run.v2.NodeSelector node_selector = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.run.v2.NodeSelector,
            com.google.cloud.run.v2.NodeSelector.Builder,
            com.google.cloud.run.v2.NodeSelectorOrBuilder>
        getNodeSelectorFieldBuilder() {
      if (nodeSelectorBuilder_ == null) {
        nodeSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.run.v2.NodeSelector,
                com.google.cloud.run.v2.NodeSelector.Builder,
                com.google.cloud.run.v2.NodeSelectorOrBuilder>(
                getNodeSelector(), getParentForChildren(), isClean());
        nodeSelector_ = null;
      }
      return nodeSelectorBuilder_;
    }

    private boolean gpuZonalRedundancyDisabled_;

    /**
     *
     *
     * <pre>
     * Optional. True if GPU zonal redundancy is disabled on this worker pool.
     * </pre>
     *
     * <code>
     * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gpuZonalRedundancyDisabled field is set.
     */
    @java.lang.Override
    public boolean hasGpuZonalRedundancyDisabled() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. True if GPU zonal redundancy is disabled on this worker pool.
     * </pre>
     *
     * <code>
     * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gpuZonalRedundancyDisabled.
     */
    @java.lang.Override
    public boolean getGpuZonalRedundancyDisabled() {
      return gpuZonalRedundancyDisabled_;
    }

    /**
     *
     *
     * <pre>
     * Optional. True if GPU zonal redundancy is disabled on this worker pool.
     * </pre>
     *
     * <code>
     * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The gpuZonalRedundancyDisabled to set.
     * @return This builder for chaining.
     */
    public Builder setGpuZonalRedundancyDisabled(boolean value) {

      gpuZonalRedundancyDisabled_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. True if GPU zonal redundancy is disabled on this worker pool.
     * </pre>
     *
     * <code>
     * optional bool gpu_zonal_redundancy_disabled = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGpuZonalRedundancyDisabled() {
      bitField0_ = (bitField0_ & ~0x00001000);
      gpuZonalRedundancyDisabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.run.v2.WorkerPoolRevisionTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.run.v2.WorkerPoolRevisionTemplate)
  private static final com.google.cloud.run.v2.WorkerPoolRevisionTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.run.v2.WorkerPoolRevisionTemplate();
  }

  public static com.google.cloud.run.v2.WorkerPoolRevisionTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WorkerPoolRevisionTemplate> PARSER =
      new com.google.protobuf.AbstractParser<WorkerPoolRevisionTemplate>() {
        @java.lang.Override
        public WorkerPoolRevisionTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WorkerPoolRevisionTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WorkerPoolRevisionTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.run.v2.WorkerPoolRevisionTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
