/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

package com.google.cloud.secretmanager.v1;

/**
 *
 *
 * <pre>
 * A policy that defines the replication and encryption configuration of data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1.Replication}
 */
public final class Replication extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Replication)
    ReplicationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Replication.newBuilder() to construct.
  private Replication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Replication() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Replication();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Replication_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Replication_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1.Replication.class,
            com.google.cloud.secretmanager.v1.Replication.Builder.class);
  }

  public interface AutomaticOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.Replication.Automatic)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    boolean hasCustomerManagedEncryption();
    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    com.google.cloud.secretmanager.v1.CustomerManagedEncryption getCustomerManagedEncryption();
    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
        getCustomerManagedEncryptionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A replication policy that replicates the
   * [Secret][google.cloud.secretmanager.v1.Secret] payload without any
   * restrictions.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.Replication.Automatic}
   */
  public static final class Automatic extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Replication.Automatic)
      AutomaticOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Automatic.newBuilder() to construct.
    private Automatic(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Automatic() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Automatic();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_Automatic_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_Automatic_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.Replication.Automatic.class,
              com.google.cloud.secretmanager.v1.Replication.Automatic.Builder.class);
    }

    public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 1;
    private com.google.cloud.secretmanager.v1.CustomerManagedEncryption customerManagedEncryption_;
    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerManagedEncryption field is set.
     */
    @java.lang.Override
    public boolean hasCustomerManagedEncryption() {
      return customerManagedEncryption_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerManagedEncryption.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.CustomerManagedEncryption
        getCustomerManagedEncryption() {
      return customerManagedEncryption_ == null
          ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
          : customerManagedEncryption_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The customer-managed encryption configuration of the
     * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
     * provided, Google-managed default encryption is used.
     * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
     * configuration only apply to
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
     * afterwards. They do not apply retroactively to existing
     * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
        getCustomerManagedEncryptionOrBuilder() {
      return customerManagedEncryption_ == null
          ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
          : customerManagedEncryption_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (customerManagedEncryption_ != null) {
        output.writeMessage(1, getCustomerManagedEncryption());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (customerManagedEncryption_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getCustomerManagedEncryption());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.secretmanager.v1.Replication.Automatic)) {
        return super.equals(obj);
      }
      com.google.cloud.secretmanager.v1.Replication.Automatic other =
          (com.google.cloud.secretmanager.v1.Replication.Automatic) obj;

      if (hasCustomerManagedEncryption() != other.hasCustomerManagedEncryption()) return false;
      if (hasCustomerManagedEncryption()) {
        if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCustomerManagedEncryption()) {
        hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
        hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.secretmanager.v1.Replication.Automatic prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A replication policy that replicates the
     * [Secret][google.cloud.secretmanager.v1.Secret] payload without any
     * restrictions.
     * </pre>
     *
     * Protobuf type {@code google.cloud.secretmanager.v1.Replication.Automatic}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Replication.Automatic)
        com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_Automatic_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_Automatic_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.Replication.Automatic.class,
                com.google.cloud.secretmanager.v1.Replication.Automatic.Builder.class);
      }

      // Construct using com.google.cloud.secretmanager.v1.Replication.Automatic.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        customerManagedEncryption_ = null;
        if (customerManagedEncryptionBuilder_ != null) {
          customerManagedEncryptionBuilder_.dispose();
          customerManagedEncryptionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_Automatic_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.Automatic getDefaultInstanceForType() {
        return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.Automatic build() {
        com.google.cloud.secretmanager.v1.Replication.Automatic result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.Automatic buildPartial() {
        com.google.cloud.secretmanager.v1.Replication.Automatic result =
            new com.google.cloud.secretmanager.v1.Replication.Automatic(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.secretmanager.v1.Replication.Automatic result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.customerManagedEncryption_ =
              customerManagedEncryptionBuilder_ == null
                  ? customerManagedEncryption_
                  : customerManagedEncryptionBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.secretmanager.v1.Replication.Automatic) {
          return mergeFrom((com.google.cloud.secretmanager.v1.Replication.Automatic) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.secretmanager.v1.Replication.Automatic other) {
        if (other == com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance())
          return this;
        if (other.hasCustomerManagedEncryption()) {
          mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCustomerManagedEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.secretmanager.v1.CustomerManagedEncryption
          customerManagedEncryption_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>
          customerManagedEncryptionBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      public boolean hasCustomerManagedEncryption() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryption
          getCustomerManagedEncryption() {
        if (customerManagedEncryptionBuilder_ == null) {
          return customerManagedEncryption_ == null
              ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
              : customerManagedEncryption_;
        } else {
          return customerManagedEncryptionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryption value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customerManagedEncryption_ = value;
        } else {
          customerManagedEncryptionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder builderForValue) {
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryption_ = builderForValue.build();
        } else {
          customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeCustomerManagedEncryption(
          com.google.cloud.secretmanager.v1.CustomerManagedEncryption value) {
        if (customerManagedEncryptionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && customerManagedEncryption_ != null
              && customerManagedEncryption_
                  != com.google.cloud.secretmanager.v1.CustomerManagedEncryption
                      .getDefaultInstance()) {
            getCustomerManagedEncryptionBuilder().mergeFrom(value);
          } else {
            customerManagedEncryption_ = value;
          }
        } else {
          customerManagedEncryptionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearCustomerManagedEncryption() {
        bitField0_ = (bitField0_ & ~0x00000001);
        customerManagedEncryption_ = null;
        if (customerManagedEncryptionBuilder_ != null) {
          customerManagedEncryptionBuilder_.dispose();
          customerManagedEncryptionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder
          getCustomerManagedEncryptionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCustomerManagedEncryptionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
          getCustomerManagedEncryptionOrBuilder() {
        if (customerManagedEncryptionBuilder_ != null) {
          return customerManagedEncryptionBuilder_.getMessageOrBuilder();
        } else {
          return customerManagedEncryption_ == null
              ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
              : customerManagedEncryption_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [Secret][google.cloud.secretmanager.v1.Secret]. If no configuration is
       * provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret] encryption
       * configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
              com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>
          getCustomerManagedEncryptionFieldBuilder() {
        if (customerManagedEncryptionBuilder_ == null) {
          customerManagedEncryptionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
                  com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>(
                  getCustomerManagedEncryption(), getParentForChildren(), isClean());
          customerManagedEncryption_ = null;
        }
        return customerManagedEncryptionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Replication.Automatic)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Replication.Automatic)
    private static final com.google.cloud.secretmanager.v1.Replication.Automatic DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Replication.Automatic();
    }

    public static com.google.cloud.secretmanager.v1.Replication.Automatic getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Automatic> PARSER =
        new com.google.protobuf.AbstractParser<Automatic>() {
          @java.lang.Override
          public Automatic parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Automatic> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Automatic> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.Automatic getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UserManagedOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.Replication.UserManaged)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
        getReplicasList();
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica getReplicas(int index);
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getReplicasCount();
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>
        getReplicasOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder getReplicasOrBuilder(
        int index);
  }
  /**
   *
   *
   * <pre>
   * A replication policy that replicates the
   * [Secret][google.cloud.secretmanager.v1.Secret] payload into the locations
   * specified in [Secret.replication.user_managed.replicas][]
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.Replication.UserManaged}
   */
  public static final class UserManaged extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Replication.UserManaged)
      UserManagedOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserManaged.newBuilder() to construct.
    private UserManaged(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserManaged() {
      replicas_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserManaged();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.Replication.UserManaged.class,
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder.class);
    }

    public interface ReplicaOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The canonical IDs of the location to replicate data.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      java.lang.String getLocation();
      /**
       *
       *
       * <pre>
       * The canonical IDs of the location to replicate data.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      com.google.protobuf.ByteString getLocationBytes();

      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      boolean hasCustomerManagedEncryption();
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      com.google.cloud.secretmanager.v1.CustomerManagedEncryption getCustomerManagedEncryption();
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
          getCustomerManagedEncryptionOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Represents a Replica for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * Protobuf type {@code google.cloud.secretmanager.v1.Replication.UserManaged.Replica}
     */
    public static final class Replica extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
        ReplicaOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Replica.newBuilder() to construct.
      private Replica(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Replica() {
        location_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Replica();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_Replica_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_Replica_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.class,
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder.class);
      }

      public static final int LOCATION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * The canonical IDs of the location to replicate data.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      @java.lang.Override
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The canonical IDs of the location to replicate data.
       * For example: `"us-east1"`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER = 2;
      private com.google.cloud.secretmanager.v1.CustomerManagedEncryption
          customerManagedEncryption_;
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the customerManagedEncryption field is set.
       */
      @java.lang.Override
      public boolean hasCustomerManagedEncryption() {
        return customerManagedEncryption_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The customerManagedEncryption.
       */
      @java.lang.Override
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryption
          getCustomerManagedEncryption() {
        return customerManagedEncryption_ == null
            ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
            : customerManagedEncryption_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customer-managed encryption configuration of the
       * [User-Managed Replica][Replication.UserManaged.Replica]. If no
       * configuration is provided, Google-managed default encryption is used.
       * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
       * encryption configuration only apply to
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
       * afterwards. They do not apply retroactively to existing
       * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
       * </pre>
       *
       * <code>
       * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
          getCustomerManagedEncryptionOrBuilder() {
        return customerManagedEncryption_ == null
            ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
            : customerManagedEncryption_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
        }
        if (customerManagedEncryption_ != null) {
          output.writeMessage(2, getCustomerManagedEncryption());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
        }
        if (customerManagedEncryption_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2, getCustomerManagedEncryption());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica)) {
          return super.equals(obj);
        }
        com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica other =
            (com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica) obj;

        if (!getLocation().equals(other.getLocation())) return false;
        if (hasCustomerManagedEncryption() != other.hasCustomerManagedEncryption()) return false;
        if (hasCustomerManagedEncryption()) {
          if (!getCustomerManagedEncryption().equals(other.getCustomerManagedEncryption()))
            return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        if (hasCustomerManagedEncryption()) {
          hash = (37 * hash) + CUSTOMER_MANAGED_ENCRYPTION_FIELD_NUMBER;
          hash = (53 * hash) + getCustomerManagedEncryption().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a Replica for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * </pre>
       *
       * Protobuf type {@code google.cloud.secretmanager.v1.Replication.UserManaged.Replica}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
          com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_Replica_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_Replica_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.class,
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder.class);
        }

        // Construct using
        // com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          location_ = "";
          customerManagedEncryption_ = null;
          if (customerManagedEncryptionBuilder_ != null) {
            customerManagedEncryptionBuilder_.dispose();
            customerManagedEncryptionBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.secretmanager.v1.ResourcesProto
              .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_Replica_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
            getDefaultInstanceForType() {
          return com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica build() {
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica buildPartial() {
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica result =
              new com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.location_ = location_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.customerManagedEncryption_ =
                customerManagedEncryptionBuilder_ == null
                    ? customerManagedEncryption_
                    : customerManagedEncryptionBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica) {
            return mergeFrom(
                (com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica other) {
          if (other
              == com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                  .getDefaultInstance()) return this;
          if (!other.getLocation().isEmpty()) {
            location_ = other.location_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasCustomerManagedEncryption()) {
            mergeCustomerManagedEncryption(other.getCustomerManagedEncryption());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    location_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getCustomerManagedEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object location_ = "";
        /**
         *
         *
         * <pre>
         * The canonical IDs of the location to replicate data.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1;</code>
         *
         * @return The location.
         */
        public java.lang.String getLocation() {
          java.lang.Object ref = location_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            location_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The canonical IDs of the location to replicate data.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1;</code>
         *
         * @return The bytes for location.
         */
        public com.google.protobuf.ByteString getLocationBytes() {
          java.lang.Object ref = location_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            location_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The canonical IDs of the location to replicate data.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1;</code>
         *
         * @param value The location to set.
         * @return This builder for chaining.
         */
        public Builder setLocation(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The canonical IDs of the location to replicate data.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLocation() {
          location_ = getDefaultInstance().getLocation();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The canonical IDs of the location to replicate data.
         * For example: `"us-east1"`.
         * </pre>
         *
         * <code>string location = 1;</code>
         *
         * @param value The bytes for location to set.
         * @return This builder for chaining.
         */
        public Builder setLocationBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          location_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.secretmanager.v1.CustomerManagedEncryption
            customerManagedEncryption_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>
            customerManagedEncryptionBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the customerManagedEncryption field is set.
         */
        public boolean hasCustomerManagedEncryption() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The customerManagedEncryption.
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryption
            getCustomerManagedEncryption() {
          if (customerManagedEncryptionBuilder_ == null) {
            return customerManagedEncryption_ == null
                ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
                : customerManagedEncryption_;
          } else {
            return customerManagedEncryptionBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryption value) {
          if (customerManagedEncryptionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            customerManagedEncryption_ = value;
          } else {
            customerManagedEncryptionBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder builderForValue) {
          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryption_ = builderForValue.build();
          } else {
            customerManagedEncryptionBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeCustomerManagedEncryption(
            com.google.cloud.secretmanager.v1.CustomerManagedEncryption value) {
          if (customerManagedEncryptionBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && customerManagedEncryption_ != null
                && customerManagedEncryption_
                    != com.google.cloud.secretmanager.v1.CustomerManagedEncryption
                        .getDefaultInstance()) {
              getCustomerManagedEncryptionBuilder().mergeFrom(value);
            } else {
              customerManagedEncryption_ = value;
            }
          } else {
            customerManagedEncryptionBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearCustomerManagedEncryption() {
          bitField0_ = (bitField0_ & ~0x00000002);
          customerManagedEncryption_ = null;
          if (customerManagedEncryptionBuilder_ != null) {
            customerManagedEncryptionBuilder_.dispose();
            customerManagedEncryptionBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder
            getCustomerManagedEncryptionBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getCustomerManagedEncryptionFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder
            getCustomerManagedEncryptionOrBuilder() {
          if (customerManagedEncryptionBuilder_ != null) {
            return customerManagedEncryptionBuilder_.getMessageOrBuilder();
          } else {
            return customerManagedEncryption_ == null
                ? com.google.cloud.secretmanager.v1.CustomerManagedEncryption.getDefaultInstance()
                : customerManagedEncryption_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The customer-managed encryption configuration of the
         * [User-Managed Replica][Replication.UserManaged.Replica]. If no
         * configuration is provided, Google-managed default encryption is used.
         * Updates to the [Secret][google.cloud.secretmanager.v1.Secret]
         * encryption configuration only apply to
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] added
         * afterwards. They do not apply retroactively to existing
         * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion].
         * </pre>
         *
         * <code>
         * .google.cloud.secretmanager.v1.CustomerManagedEncryption customer_managed_encryption = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
                com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>
            getCustomerManagedEncryptionFieldBuilder() {
          if (customerManagedEncryptionBuilder_ == null) {
            customerManagedEncryptionBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryption,
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryption.Builder,
                    com.google.cloud.secretmanager.v1.CustomerManagedEncryptionOrBuilder>(
                    getCustomerManagedEncryption(), getParentForChildren(), isClean());
            customerManagedEncryption_ = null;
          }
          return customerManagedEncryptionBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Replication.UserManaged.Replica)
      private static final com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica();
      }

      public static com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Replica> PARSER =
          new com.google.protobuf.AbstractParser<Replica>() {
            @java.lang.Override
            public Replica parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Replica> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Replica> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int REPLICAS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
        replicas_;
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
        getReplicasList() {
      return replicas_;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>
        getReplicasOrBuilderList() {
      return replicas_;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getReplicasCount() {
      return replicas_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica getReplicas(
        int index) {
      return replicas_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The list of Replicas for this
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * Cannot be empty.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder
        getReplicasOrBuilder(int index) {
      return replicas_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < replicas_.size(); i++) {
        output.writeMessage(1, replicas_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < replicas_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, replicas_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.secretmanager.v1.Replication.UserManaged)) {
        return super.equals(obj);
      }
      com.google.cloud.secretmanager.v1.Replication.UserManaged other =
          (com.google.cloud.secretmanager.v1.Replication.UserManaged) obj;

      if (!getReplicasList().equals(other.getReplicasList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReplicasCount() > 0) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicasList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.secretmanager.v1.Replication.UserManaged prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A replication policy that replicates the
     * [Secret][google.cloud.secretmanager.v1.Secret] payload into the locations
     * specified in [Secret.replication.user_managed.replicas][]
     * </pre>
     *
     * Protobuf type {@code google.cloud.secretmanager.v1.Replication.UserManaged}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Replication.UserManaged)
        com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.secretmanager.v1.Replication.UserManaged.class,
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder.class);
      }

      // Construct using com.google.cloud.secretmanager.v1.Replication.UserManaged.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (replicasBuilder_ == null) {
          replicas_ = java.util.Collections.emptyList();
        } else {
          replicas_ = null;
          replicasBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.secretmanager.v1.ResourcesProto
            .internal_static_google_cloud_secretmanager_v1_Replication_UserManaged_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.UserManaged getDefaultInstanceForType() {
        return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.UserManaged build() {
        com.google.cloud.secretmanager.v1.Replication.UserManaged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.secretmanager.v1.Replication.UserManaged buildPartial() {
        com.google.cloud.secretmanager.v1.Replication.UserManaged result =
            new com.google.cloud.secretmanager.v1.Replication.UserManaged(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.secretmanager.v1.Replication.UserManaged result) {
        if (replicasBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            replicas_ = java.util.Collections.unmodifiableList(replicas_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.replicas_ = replicas_;
        } else {
          result.replicas_ = replicasBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.secretmanager.v1.Replication.UserManaged result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.secretmanager.v1.Replication.UserManaged) {
          return mergeFrom((com.google.cloud.secretmanager.v1.Replication.UserManaged) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.secretmanager.v1.Replication.UserManaged other) {
        if (other == com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance())
          return this;
        if (replicasBuilder_ == null) {
          if (!other.replicas_.isEmpty()) {
            if (replicas_.isEmpty()) {
              replicas_ = other.replicas_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReplicasIsMutable();
              replicas_.addAll(other.replicas_);
            }
            onChanged();
          }
        } else {
          if (!other.replicas_.isEmpty()) {
            if (replicasBuilder_.isEmpty()) {
              replicasBuilder_.dispose();
              replicasBuilder_ = null;
              replicas_ = other.replicas_;
              bitField0_ = (bitField0_ & ~0x00000001);
              replicasBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReplicasFieldBuilder()
                      : null;
            } else {
              replicasBuilder_.addAllMessages(other.replicas_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica m =
                      input.readMessage(
                          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                              .parser(),
                          extensionRegistry);
                  if (replicasBuilder_ == null) {
                    ensureReplicasIsMutable();
                    replicas_.add(m);
                  } else {
                    replicasBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
          replicas_ = java.util.Collections.emptyList();

      private void ensureReplicasIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          replicas_ =
              new java.util.ArrayList<
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>(replicas_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica,
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder,
              com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>
          replicasBuilder_;

      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
          getReplicasList() {
        if (replicasBuilder_ == null) {
          return java.util.Collections.unmodifiableList(replicas_);
        } else {
          return replicasBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getReplicasCount() {
        if (replicasBuilder_ == null) {
          return replicas_.size();
        } else {
          return replicasBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica getReplicas(
          int index) {
        if (replicasBuilder_ == null) {
          return replicas_.get(index);
        } else {
          return replicasBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplicas(
          int index, com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.set(index, value);
          onChanged();
        } else {
          replicasBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplicas(
          int index,
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.set(index, builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addReplicas(
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.add(value);
          onChanged();
        } else {
          replicasBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addReplicas(
          int index, com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica value) {
        if (replicasBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReplicasIsMutable();
          replicas_.add(index, value);
          onChanged();
        } else {
          replicasBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addReplicas(
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.add(builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addReplicas(
          int index,
          com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
              builderForValue) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.add(index, builderForValue.build());
          onChanged();
        } else {
          replicasBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllReplicas(
          java.lang.Iterable<
                  ? extends com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica>
              values) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, replicas_);
          onChanged();
        } else {
          replicasBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearReplicas() {
        if (replicasBuilder_ == null) {
          replicas_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          replicasBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeReplicas(int index) {
        if (replicasBuilder_ == null) {
          ensureReplicasIsMutable();
          replicas_.remove(index);
          onChanged();
        } else {
          replicasBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
          getReplicasBuilder(int index) {
        return getReplicasFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder
          getReplicasOrBuilder(int index) {
        if (replicasBuilder_ == null) {
          return replicas_.get(index);
        } else {
          return replicasBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>
          getReplicasOrBuilderList() {
        if (replicasBuilder_ != null) {
          return replicasBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(replicas_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
          addReplicasBuilder() {
        return getReplicasFieldBuilder()
            .addBuilder(
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder
          addReplicasBuilder(int index) {
        return getReplicasFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. The list of Replicas for this
       * [Secret][google.cloud.secretmanager.v1.Secret].
       * Cannot be empty.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.secretmanager.v1.Replication.UserManaged.Replica replicas = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder>
          getReplicasBuilderList() {
        return getReplicasFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica,
              com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder,
              com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>
          getReplicasFieldBuilder() {
        if (replicasBuilder_ == null) {
          replicasBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica,
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.Replica.Builder,
                  com.google.cloud.secretmanager.v1.Replication.UserManaged.ReplicaOrBuilder>(
                  replicas_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          replicas_ = null;
        }
        return replicasBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Replication.UserManaged)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Replication.UserManaged)
    private static final com.google.cloud.secretmanager.v1.Replication.UserManaged DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Replication.UserManaged();
    }

    public static com.google.cloud.secretmanager.v1.Replication.UserManaged getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserManaged> PARSER =
        new com.google.protobuf.AbstractParser<UserManaged>() {
          @java.lang.Override
          public UserManaged parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserManaged> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserManaged> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.UserManaged getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int replicationCase_ = 0;
  private java.lang.Object replication_;

  public enum ReplicationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTOMATIC(1),
    USER_MANAGED(2),
    REPLICATION_NOT_SET(0);
    private final int value;

    private ReplicationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ReplicationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ReplicationCase forNumber(int value) {
      switch (value) {
        case 1:
          return AUTOMATIC;
        case 2:
          return USER_MANAGED;
        case 0:
          return REPLICATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ReplicationCase getReplicationCase() {
    return ReplicationCase.forNumber(replicationCase_);
  }

  public static final int AUTOMATIC_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
   * replicated without any restrictions.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
   *
   * @return Whether the automatic field is set.
   */
  @java.lang.Override
  public boolean hasAutomatic() {
    return replicationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
   * replicated without any restrictions.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
   *
   * @return The automatic.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication.Automatic getAutomatic() {
    if (replicationCase_ == 1) {
      return (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_;
    }
    return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
   * replicated without any restrictions.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder getAutomaticOrBuilder() {
    if (replicationCase_ == 1) {
      return (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_;
    }
    return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
  }

  public static final int USER_MANAGED_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
   * replicated into the locations specified.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
   *
   * @return Whether the userManaged field is set.
   */
  @java.lang.Override
  public boolean hasUserManaged() {
    return replicationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
   * replicated into the locations specified.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
   *
   * @return The userManaged.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication.UserManaged getUserManaged() {
    if (replicationCase_ == 2) {
      return (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_;
    }
    return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
   * replicated into the locations specified.
   * </pre>
   *
   * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder
      getUserManagedOrBuilder() {
    if (replicationCase_ == 2) {
      return (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_;
    }
    return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (replicationCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_);
    }
    if (replicationCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (replicationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_);
    }
    if (replicationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1.Replication)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1.Replication other =
        (com.google.cloud.secretmanager.v1.Replication) obj;

    if (!getReplicationCase().equals(other.getReplicationCase())) return false;
    switch (replicationCase_) {
      case 1:
        if (!getAutomatic().equals(other.getAutomatic())) return false;
        break;
      case 2:
        if (!getUserManaged().equals(other.getUserManaged())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (replicationCase_) {
      case 1:
        hash = (37 * hash) + AUTOMATIC_FIELD_NUMBER;
        hash = (53 * hash) + getAutomatic().hashCode();
        break;
      case 2:
        hash = (37 * hash) + USER_MANAGED_FIELD_NUMBER;
        hash = (53 * hash) + getUserManaged().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Replication parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1.Replication prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A policy that defines the replication and encryption configuration of data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.Replication}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Replication)
      com.google.cloud.secretmanager.v1.ReplicationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.Replication.class,
              com.google.cloud.secretmanager.v1.Replication.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1.Replication.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (automaticBuilder_ != null) {
        automaticBuilder_.clear();
      }
      if (userManagedBuilder_ != null) {
        userManagedBuilder_.clear();
      }
      replicationCase_ = 0;
      replication_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Replication_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1.Replication.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication build() {
      com.google.cloud.secretmanager.v1.Replication result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication buildPartial() {
      com.google.cloud.secretmanager.v1.Replication result =
          new com.google.cloud.secretmanager.v1.Replication(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.secretmanager.v1.Replication result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.secretmanager.v1.Replication result) {
      result.replicationCase_ = replicationCase_;
      result.replication_ = this.replication_;
      if (replicationCase_ == 1 && automaticBuilder_ != null) {
        result.replication_ = automaticBuilder_.build();
      }
      if (replicationCase_ == 2 && userManagedBuilder_ != null) {
        result.replication_ = userManagedBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1.Replication) {
        return mergeFrom((com.google.cloud.secretmanager.v1.Replication) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1.Replication other) {
      if (other == com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()) return this;
      switch (other.getReplicationCase()) {
        case AUTOMATIC:
          {
            mergeAutomatic(other.getAutomatic());
            break;
          }
        case USER_MANAGED:
          {
            mergeUserManaged(other.getUserManaged());
            break;
          }
        case REPLICATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAutomaticFieldBuilder().getBuilder(), extensionRegistry);
                replicationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUserManagedFieldBuilder().getBuilder(), extensionRegistry);
                replicationCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int replicationCase_ = 0;
    private java.lang.Object replication_;

    public ReplicationCase getReplicationCase() {
      return ReplicationCase.forNumber(replicationCase_);
    }

    public Builder clearReplication() {
      replicationCase_ = 0;
      replication_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication.Automatic,
            com.google.cloud.secretmanager.v1.Replication.Automatic.Builder,
            com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder>
        automaticBuilder_;
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     *
     * @return Whether the automatic field is set.
     */
    @java.lang.Override
    public boolean hasAutomatic() {
      return replicationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     *
     * @return The automatic.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.Automatic getAutomatic() {
      if (automaticBuilder_ == null) {
        if (replicationCase_ == 1) {
          return (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_;
        }
        return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
      } else {
        if (replicationCase_ == 1) {
          return automaticBuilder_.getMessage();
        }
        return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    public Builder setAutomatic(com.google.cloud.secretmanager.v1.Replication.Automatic value) {
      if (automaticBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replication_ = value;
        onChanged();
      } else {
        automaticBuilder_.setMessage(value);
      }
      replicationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    public Builder setAutomatic(
        com.google.cloud.secretmanager.v1.Replication.Automatic.Builder builderForValue) {
      if (automaticBuilder_ == null) {
        replication_ = builderForValue.build();
        onChanged();
      } else {
        automaticBuilder_.setMessage(builderForValue.build());
      }
      replicationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    public Builder mergeAutomatic(com.google.cloud.secretmanager.v1.Replication.Automatic value) {
      if (automaticBuilder_ == null) {
        if (replicationCase_ == 1
            && replication_
                != com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance()) {
          replication_ =
              com.google.cloud.secretmanager.v1.Replication.Automatic.newBuilder(
                      (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replication_ = value;
        }
        onChanged();
      } else {
        if (replicationCase_ == 1) {
          automaticBuilder_.mergeFrom(value);
        } else {
          automaticBuilder_.setMessage(value);
        }
      }
      replicationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    public Builder clearAutomatic() {
      if (automaticBuilder_ == null) {
        if (replicationCase_ == 1) {
          replicationCase_ = 0;
          replication_ = null;
          onChanged();
        }
      } else {
        if (replicationCase_ == 1) {
          replicationCase_ = 0;
          replication_ = null;
        }
        automaticBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    public com.google.cloud.secretmanager.v1.Replication.Automatic.Builder getAutomaticBuilder() {
      return getAutomaticFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder
        getAutomaticOrBuilder() {
      if ((replicationCase_ == 1) && (automaticBuilder_ != null)) {
        return automaticBuilder_.getMessageOrBuilder();
      } else {
        if (replicationCase_ == 1) {
          return (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_;
        }
        return com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will automatically be
     * replicated without any restrictions.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.Automatic automatic = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication.Automatic,
            com.google.cloud.secretmanager.v1.Replication.Automatic.Builder,
            com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder>
        getAutomaticFieldBuilder() {
      if (automaticBuilder_ == null) {
        if (!(replicationCase_ == 1)) {
          replication_ =
              com.google.cloud.secretmanager.v1.Replication.Automatic.getDefaultInstance();
        }
        automaticBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.Replication.Automatic,
                com.google.cloud.secretmanager.v1.Replication.Automatic.Builder,
                com.google.cloud.secretmanager.v1.Replication.AutomaticOrBuilder>(
                (com.google.cloud.secretmanager.v1.Replication.Automatic) replication_,
                getParentForChildren(),
                isClean());
        replication_ = null;
      }
      replicationCase_ = 1;
      onChanged();
      return automaticBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication.UserManaged,
            com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder,
            com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder>
        userManagedBuilder_;
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     *
     * @return Whether the userManaged field is set.
     */
    @java.lang.Override
    public boolean hasUserManaged() {
      return replicationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     *
     * @return The userManaged.
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.UserManaged getUserManaged() {
      if (userManagedBuilder_ == null) {
        if (replicationCase_ == 2) {
          return (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_;
        }
        return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
      } else {
        if (replicationCase_ == 2) {
          return userManagedBuilder_.getMessage();
        }
        return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    public Builder setUserManaged(com.google.cloud.secretmanager.v1.Replication.UserManaged value) {
      if (userManagedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replication_ = value;
        onChanged();
      } else {
        userManagedBuilder_.setMessage(value);
      }
      replicationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    public Builder setUserManaged(
        com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder builderForValue) {
      if (userManagedBuilder_ == null) {
        replication_ = builderForValue.build();
        onChanged();
      } else {
        userManagedBuilder_.setMessage(builderForValue.build());
      }
      replicationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    public Builder mergeUserManaged(
        com.google.cloud.secretmanager.v1.Replication.UserManaged value) {
      if (userManagedBuilder_ == null) {
        if (replicationCase_ == 2
            && replication_
                != com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance()) {
          replication_ =
              com.google.cloud.secretmanager.v1.Replication.UserManaged.newBuilder(
                      (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          replication_ = value;
        }
        onChanged();
      } else {
        if (replicationCase_ == 2) {
          userManagedBuilder_.mergeFrom(value);
        } else {
          userManagedBuilder_.setMessage(value);
        }
      }
      replicationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    public Builder clearUserManaged() {
      if (userManagedBuilder_ == null) {
        if (replicationCase_ == 2) {
          replicationCase_ = 0;
          replication_ = null;
          onChanged();
        }
      } else {
        if (replicationCase_ == 2) {
          replicationCase_ = 0;
          replication_ = null;
        }
        userManagedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    public com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder
        getUserManagedBuilder() {
      return getUserManagedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder
        getUserManagedOrBuilder() {
      if ((replicationCase_ == 2) && (userManagedBuilder_ != null)) {
        return userManagedBuilder_.getMessageOrBuilder();
      } else {
        if (replicationCase_ == 2) {
          return (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_;
        }
        return com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The [Secret][google.cloud.secretmanager.v1.Secret] will only be
     * replicated into the locations specified.
     * </pre>
     *
     * <code>.google.cloud.secretmanager.v1.Replication.UserManaged user_managed = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication.UserManaged,
            com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder,
            com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder>
        getUserManagedFieldBuilder() {
      if (userManagedBuilder_ == null) {
        if (!(replicationCase_ == 2)) {
          replication_ =
              com.google.cloud.secretmanager.v1.Replication.UserManaged.getDefaultInstance();
        }
        userManagedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.Replication.UserManaged,
                com.google.cloud.secretmanager.v1.Replication.UserManaged.Builder,
                com.google.cloud.secretmanager.v1.Replication.UserManagedOrBuilder>(
                (com.google.cloud.secretmanager.v1.Replication.UserManaged) replication_,
                getParentForChildren(),
                isClean());
        replication_ = null;
      }
      replicationCase_ = 2;
      onChanged();
      return userManagedBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Replication)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Replication)
  private static final com.google.cloud.secretmanager.v1.Replication DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Replication();
  }

  public static com.google.cloud.secretmanager.v1.Replication getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Replication> PARSER =
      new com.google.protobuf.AbstractParser<Replication>() {
        @java.lang.Override
        public Replication parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Replication> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Replication> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
