/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

package com.google.cloud.secretmanager.v1;

/**
 *
 *
 * <pre>
 * The rotation time and period for a
 * [Secret][google.cloud.secretmanager.v1.Secret]. At next_rotation_time, Secret
 * Manager will send a Pub/Sub notification to the topics configured on the
 * Secret. [Secret.topics][google.cloud.secretmanager.v1.Secret.topics] must be
 * set to configure rotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1.Rotation}
 */
public final class Rotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Rotation)
    RotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Rotation.newBuilder() to construct.
  private Rotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Rotation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Rotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Rotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Rotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1.Rotation.class,
            com.google.cloud.secretmanager.v1.Rotation.Builder.class);
  }

  public static final int NEXT_ROTATION_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp nextRotationTime_;
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
   * Cannot be set to less than 300s (5 min) in the future and at most
   * 3153600000s (100 years).
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * MUST  be set if
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the nextRotationTime field is set.
   */
  @java.lang.Override
  public boolean hasNextRotationTime() {
    return nextRotationTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
   * Cannot be set to less than 300s (5 min) in the future and at most
   * 3153600000s (100 years).
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * MUST  be set if
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The nextRotationTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getNextRotationTime() {
    return nextRotationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextRotationTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
   * Cannot be set to less than 300s (5 min) in the future and at most
   * 3153600000s (100 years).
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * MUST  be set if
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
    return nextRotationTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : nextRotationTime_;
  }

  public static final int ROTATION_PERIOD_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration rotationPeriod_;
  /**
   *
   *
   * <pre>
   * Input only. The Duration between rotation notifications. Must be in seconds
   * and at least 3600s (1h) and at most 3153600000s (100 years).
   * If
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set,
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * must be set.
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * will be advanced by this period when the service automatically sends
   * rotation notifications.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the rotationPeriod field is set.
   */
  @java.lang.Override
  public boolean hasRotationPeriod() {
    return rotationPeriod_ != null;
  }
  /**
   *
   *
   * <pre>
   * Input only. The Duration between rotation notifications. Must be in seconds
   * and at least 3600s (1h) and at most 3153600000s (100 years).
   * If
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set,
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * must be set.
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * will be advanced by this period when the service automatically sends
   * rotation notifications.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The rotationPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getRotationPeriod() {
    return rotationPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : rotationPeriod_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The Duration between rotation notifications. Must be in seconds
   * and at least 3600s (1h) and at most 3153600000s (100 years).
   * If
   * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
   * is set,
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * must be set.
   * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
   * will be advanced by this period when the service automatically sends
   * rotation notifications.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
    return rotationPeriod_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : rotationPeriod_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (nextRotationTime_ != null) {
      output.writeMessage(1, getNextRotationTime());
    }
    if (rotationPeriod_ != null) {
      output.writeMessage(2, getRotationPeriod());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (nextRotationTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNextRotationTime());
    }
    if (rotationPeriod_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRotationPeriod());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1.Rotation)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1.Rotation other =
        (com.google.cloud.secretmanager.v1.Rotation) obj;

    if (hasNextRotationTime() != other.hasNextRotationTime()) return false;
    if (hasNextRotationTime()) {
      if (!getNextRotationTime().equals(other.getNextRotationTime())) return false;
    }
    if (hasRotationPeriod() != other.hasRotationPeriod()) return false;
    if (hasRotationPeriod()) {
      if (!getRotationPeriod().equals(other.getRotationPeriod())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNextRotationTime()) {
      hash = (37 * hash) + NEXT_ROTATION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getNextRotationTime().hashCode();
    }
    if (hasRotationPeriod()) {
      hash = (37 * hash) + ROTATION_PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getRotationPeriod().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Rotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1.Rotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The rotation time and period for a
   * [Secret][google.cloud.secretmanager.v1.Secret]. At next_rotation_time, Secret
   * Manager will send a Pub/Sub notification to the topics configured on the
   * Secret. [Secret.topics][google.cloud.secretmanager.v1.Secret.topics] must be
   * set to configure rotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.Rotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Rotation)
      com.google.cloud.secretmanager.v1.RotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Rotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Rotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.Rotation.class,
              com.google.cloud.secretmanager.v1.Rotation.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1.Rotation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      nextRotationTime_ = null;
      if (nextRotationTimeBuilder_ != null) {
        nextRotationTimeBuilder_.dispose();
        nextRotationTimeBuilder_ = null;
      }
      rotationPeriod_ = null;
      if (rotationPeriodBuilder_ != null) {
        rotationPeriodBuilder_.dispose();
        rotationPeriodBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Rotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Rotation getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Rotation build() {
      com.google.cloud.secretmanager.v1.Rotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Rotation buildPartial() {
      com.google.cloud.secretmanager.v1.Rotation result =
          new com.google.cloud.secretmanager.v1.Rotation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.secretmanager.v1.Rotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.nextRotationTime_ =
            nextRotationTimeBuilder_ == null ? nextRotationTime_ : nextRotationTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rotationPeriod_ =
            rotationPeriodBuilder_ == null ? rotationPeriod_ : rotationPeriodBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1.Rotation) {
        return mergeFrom((com.google.cloud.secretmanager.v1.Rotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1.Rotation other) {
      if (other == com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()) return this;
      if (other.hasNextRotationTime()) {
        mergeNextRotationTime(other.getNextRotationTime());
      }
      if (other.hasRotationPeriod()) {
        mergeRotationPeriod(other.getRotationPeriod());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getNextRotationTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRotationPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp nextRotationTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        nextRotationTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the nextRotationTime field is set.
     */
    public boolean hasNextRotationTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The nextRotationTime.
     */
    public com.google.protobuf.Timestamp getNextRotationTime() {
      if (nextRotationTimeBuilder_ == null) {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      } else {
        return nextRotationTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nextRotationTime_ = value;
      } else {
        nextRotationTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNextRotationTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTime_ = builderForValue.build();
      } else {
        nextRotationTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeNextRotationTime(com.google.protobuf.Timestamp value) {
      if (nextRotationTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && nextRotationTime_ != null
            && nextRotationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getNextRotationTimeBuilder().mergeFrom(value);
        } else {
          nextRotationTime_ = value;
        }
      } else {
        nextRotationTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNextRotationTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      nextRotationTime_ = null;
      if (nextRotationTimeBuilder_ != null) {
        nextRotationTimeBuilder_.dispose();
        nextRotationTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getNextRotationTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getNextRotationTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getNextRotationTimeOrBuilder() {
      if (nextRotationTimeBuilder_ != null) {
        return nextRotationTimeBuilder_.getMessageOrBuilder();
      } else {
        return nextRotationTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : nextRotationTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to rotate.
     * Cannot be set to less than 300s (5 min) in the future and at most
     * 3153600000s (100 years).
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * MUST  be set if
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp next_rotation_time = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getNextRotationTimeFieldBuilder() {
      if (nextRotationTimeBuilder_ == null) {
        nextRotationTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getNextRotationTime(), getParentForChildren(), isClean());
        nextRotationTime_ = null;
      }
      return nextRotationTimeBuilder_;
    }

    private com.google.protobuf.Duration rotationPeriod_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        rotationPeriodBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the rotationPeriod field is set.
     */
    public boolean hasRotationPeriod() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The rotationPeriod.
     */
    public com.google.protobuf.Duration getRotationPeriod() {
      if (rotationPeriodBuilder_ == null) {
        return rotationPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : rotationPeriod_;
      } else {
        return rotationPeriodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rotationPeriod_ = value;
      } else {
        rotationPeriodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setRotationPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (rotationPeriodBuilder_ == null) {
        rotationPeriod_ = builderForValue.build();
      } else {
        rotationPeriodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeRotationPeriod(com.google.protobuf.Duration value) {
      if (rotationPeriodBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && rotationPeriod_ != null
            && rotationPeriod_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getRotationPeriodBuilder().mergeFrom(value);
        } else {
          rotationPeriod_ = value;
        }
      } else {
        rotationPeriodBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearRotationPeriod() {
      bitField0_ = (bitField0_ & ~0x00000002);
      rotationPeriod_ = null;
      if (rotationPeriodBuilder_ != null) {
        rotationPeriodBuilder_.dispose();
        rotationPeriodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getRotationPeriodBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRotationPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getRotationPeriodOrBuilder() {
      if (rotationPeriodBuilder_ != null) {
        return rotationPeriodBuilder_.getMessageOrBuilder();
      } else {
        return rotationPeriod_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : rotationPeriod_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The Duration between rotation notifications. Must be in seconds
     * and at least 3600s (1h) and at most 3153600000s (100 years).
     * If
     * [rotation_period][google.cloud.secretmanager.v1.Rotation.rotation_period]
     * is set,
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * must be set.
     * [next_rotation_time][google.cloud.secretmanager.v1.Rotation.next_rotation_time]
     * will be advanced by this period when the service automatically sends
     * rotation notifications.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration rotation_period = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getRotationPeriodFieldBuilder() {
      if (rotationPeriodBuilder_ == null) {
        rotationPeriodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getRotationPeriod(), getParentForChildren(), isClean());
        rotationPeriod_ = null;
      }
      return rotationPeriodBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Rotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Rotation)
  private static final com.google.cloud.secretmanager.v1.Rotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Rotation();
  }

  public static com.google.cloud.secretmanager.v1.Rotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Rotation> PARSER =
      new com.google.protobuf.AbstractParser<Rotation>() {
        @java.lang.Override
        public Rotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Rotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Rotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Rotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
