/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/secretmanager/v1/resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.secretmanager.v1;

/**
 *
 *
 * <pre>
 * A [Secret][google.cloud.secretmanager.v1.Secret] is a logical secret whose
 * value and versions can be accessed.
 *
 * A [Secret][google.cloud.secretmanager.v1.Secret] is made up of zero or more
 * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] that represent
 * the secret data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.secretmanager.v1.Secret}
 */
public final class Secret extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.secretmanager.v1.Secret)
    SecretOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Secret.newBuilder() to construct.
  private Secret(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Secret() {
    name_ = "";
    topics_ = java.util.Collections.emptyList();
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Secret();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Secret_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 11:
        return internalGetVersionAliases();
      case 13:
        return internalGetAnnotations();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.secretmanager.v1.ResourcesProto
        .internal_static_google_cloud_secretmanager_v1_Secret_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.secretmanager.v1.Secret.class,
            com.google.cloud.secretmanager.v1.Secret.Builder.class);
  }

  private int bitField0_;
  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(6),
    TTL(7),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 6:
          return EXPIRE_TIME;
        case 7:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secretmanager.v1.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the
   * [Secret][google.cloud.secretmanager.v1.Secret] in the format
   * `projects/&#42;&#47;secrets/&#42;`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLICATION_FIELD_NUMBER = 2;
  private com.google.cloud.secretmanager.v1.Replication replication_;
  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the replication field is set.
   */
  @java.lang.Override
  public boolean hasReplication() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The replication.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Replication getReplication() {
    return replication_ == null
        ? com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()
        : replication_;
  }
  /**
   *
   *
   * <pre>
   * Required. Immutable. The replication policy of the secret data attached to
   * the [Secret][google.cloud.secretmanager.v1.Secret].
   *
   * The replication policy cannot be changed after the Secret has been created.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.ReplicationOrBuilder getReplicationOrBuilder() {
    return replication_ == null
        ? com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()
        : replication_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the
   * [Secret][google.cloud.secretmanager.v1.Secret] was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.secretmanager.v1.ResourcesProto
                .internal_static_google_cloud_secretmanager_v1_Secret_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels assigned to this Secret.
   *
   * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
   * of maximum 128 bytes, and must conform to the following PCRE regular
   * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
   *
   * Label values must be between 0 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, and must conform to the following PCRE
   * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
   *
   * No more than 64 labels can be assigned to a given resource.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TOPICS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.secretmanager.v1.Topic> topics_;
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.secretmanager.v1.Topic> getTopicsList() {
    return topics_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.secretmanager.v1.TopicOrBuilder>
      getTopicsOrBuilderList() {
    return topics_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getTopicsCount() {
    return topics_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Topic getTopics(int index) {
    return topics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of up to 10 Pub/Sub topics to which messages are published
   * when control plane operations are called on the secret or its versions.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.TopicOrBuilder getTopicsOrBuilder(int index) {
    return topics_.get(index);
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
   * This is always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
   * This is always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 6) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Timestamp in UTC when the
   * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
   * This is always provided on output, regardless of what was sent on input.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 6) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 7) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for the
   * [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 7) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Etag of the currently stored
   * [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Etag of the currently stored
   * [Secret][google.cloud.secretmanager.v1.Secret].
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROTATION_FIELD_NUMBER = 9;
  private com.google.cloud.secretmanager.v1.Rotation rotation_;
  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
   * no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rotation field is set.
   */
  @java.lang.Override
  public boolean hasRotation() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
   * no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rotation.
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Rotation getRotation() {
    return rotation_ == null
        ? com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()
        : rotation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Rotation policy attached to the
   * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
   * no rotation policy.
   * </pre>
   *
   * <code>
   * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.secretmanager.v1.RotationOrBuilder getRotationOrBuilder() {
    return rotation_ == null
        ? com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()
        : rotation_;
  }

  public static final int VERSION_ALIASES_FIELD_NUMBER = 11;

  private static final class VersionAliasesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
            com.google.cloud.secretmanager.v1.ResourcesProto
                .internal_static_google_cloud_secretmanager_v1_Secret_VersionAliasesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT64,
            0L);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Long> versionAliases_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
      internalGetVersionAliases() {
    if (versionAliases_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          VersionAliasesDefaultEntryHolder.defaultEntry);
    }
    return versionAliases_;
  }

  public int getVersionAliasesCount() {
    return internalGetVersionAliases().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. At launch access by alias will only be supported on
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsVersionAliases(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetVersionAliases().getMap().containsKey(key);
  }
  /** Use {@link #getVersionAliasesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Long> getVersionAliases() {
    return getVersionAliasesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. At launch access by alias will only be supported on
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Long> getVersionAliasesMap() {
    return internalGetVersionAliases().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. At launch access by alias will only be supported on
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public long getVersionAliasesOrDefault(java.lang.String key, long defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetVersionAliases().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Mapping from version alias to version name.
   *
   * A version alias is a string with a maximum length of 63 characters and can
   * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
   * and underscore ('_') characters. An alias string must start with a
   * letter and cannot be the string 'latest' or 'NEW'.
   * No more than 50 aliases can be assigned to a given secret.
   *
   * Version-Alias pairs will be viewable via GetSecret and modifiable via
   * UpdateSecret. At launch access by alias will only be supported on
   * GetSecretVersion and AccessSecretVersion.
   * </pre>
   *
   * <code>map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public long getVersionAliasesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Long> map = internalGetVersionAliases().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 13;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.secretmanager.v1.ResourcesProto
                .internal_static_google_cloud_secretmanager_v1_Secret_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Custom metadata about the secret.
   *
   * Annotations are distinct from various forms of labels.
   * Annotations exist to allow client tools to store their own state
   * information without requiring a database.
   *
   * Annotation keys must be between 1 and 63 characters long, have a UTF-8
   * encoding of maximum 128 bytes, begin and end with an alphanumeric character
   * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
   * alphanumerics in between these symbols.
   *
   * The total size of annotation keys and values must be less than 16KiB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getReplication());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    for (int i = 0; i < topics_.size(); i++) {
      output.writeMessage(5, topics_.get(i));
    }
    if (expirationCase_ == 6) {
      output.writeMessage(6, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 7) {
      output.writeMessage(7, (com.google.protobuf.Duration) expiration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getRotation());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetVersionAliases(), VersionAliasesDefaultEntryHolder.defaultEntry, 11);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 13);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getReplication());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (int i = 0; i < topics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, topics_.get(i));
    }
    if (expirationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.protobuf.Duration) expiration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getRotation());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
        internalGetVersionAliases().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> versionAliases__ =
          VersionAliasesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, versionAliases__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, annotations__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.secretmanager.v1.Secret)) {
      return super.equals(obj);
    }
    com.google.cloud.secretmanager.v1.Secret other = (com.google.cloud.secretmanager.v1.Secret) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasReplication() != other.hasReplication()) return false;
    if (hasReplication()) {
      if (!getReplication().equals(other.getReplication())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getTopicsList().equals(other.getTopicsList())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (hasRotation() != other.hasRotation()) return false;
    if (hasRotation()) {
      if (!getRotation().equals(other.getRotation())) return false;
    }
    if (!internalGetVersionAliases().equals(other.internalGetVersionAliases())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 6:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 7:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasReplication()) {
      hash = (37 * hash) + REPLICATION_FIELD_NUMBER;
      hash = (53 * hash) + getReplication().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getTopicsCount() > 0) {
      hash = (37 * hash) + TOPICS_FIELD_NUMBER;
      hash = (53 * hash) + getTopicsList().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (hasRotation()) {
      hash = (37 * hash) + ROTATION_FIELD_NUMBER;
      hash = (53 * hash) + getRotation().hashCode();
    }
    if (!internalGetVersionAliases().getMap().isEmpty()) {
      hash = (37 * hash) + VERSION_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetVersionAliases().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    switch (expirationCase_) {
      case 6:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 7:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.secretmanager.v1.Secret parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.secretmanager.v1.Secret prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [Secret][google.cloud.secretmanager.v1.Secret] is a logical secret whose
   * value and versions can be accessed.
   *
   * A [Secret][google.cloud.secretmanager.v1.Secret] is made up of zero or more
   * [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] that represent
   * the secret data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.secretmanager.v1.Secret}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.secretmanager.v1.Secret)
      com.google.cloud.secretmanager.v1.SecretOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Secret_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 11:
          return internalGetVersionAliases();
        case 13:
          return internalGetAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 11:
          return internalGetMutableVersionAliases();
        case 13:
          return internalGetMutableAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Secret_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.secretmanager.v1.Secret.class,
              com.google.cloud.secretmanager.v1.Secret.Builder.class);
    }

    // Construct using com.google.cloud.secretmanager.v1.Secret.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReplicationFieldBuilder();
        getCreateTimeFieldBuilder();
        getTopicsFieldBuilder();
        getRotationFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      replication_ = null;
      if (replicationBuilder_ != null) {
        replicationBuilder_.dispose();
        replicationBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (topicsBuilder_ == null) {
        topics_ = java.util.Collections.emptyList();
      } else {
        topics_ = null;
        topicsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      etag_ = "";
      rotation_ = null;
      if (rotationBuilder_ != null) {
        rotationBuilder_.dispose();
        rotationBuilder_ = null;
      }
      internalGetMutableVersionAliases().clear();
      internalGetMutableAnnotations().clear();
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.secretmanager.v1.ResourcesProto
          .internal_static_google_cloud_secretmanager_v1_Secret_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Secret getDefaultInstanceForType() {
      return com.google.cloud.secretmanager.v1.Secret.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Secret build() {
      com.google.cloud.secretmanager.v1.Secret result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.secretmanager.v1.Secret buildPartial() {
      com.google.cloud.secretmanager.v1.Secret result =
          new com.google.cloud.secretmanager.v1.Secret(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.secretmanager.v1.Secret result) {
      if (topicsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          topics_ = java.util.Collections.unmodifiableList(topics_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.topics_ = topics_;
      } else {
        result.topics_ = topicsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.secretmanager.v1.Secret result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.replication_ =
            replicationBuilder_ == null ? replication_ : replicationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.rotation_ = rotationBuilder_ == null ? rotation_ : rotationBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.versionAliases_ = internalGetVersionAliases();
        result.versionAliases_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.secretmanager.v1.Secret result) {
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 6 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 7 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.secretmanager.v1.Secret) {
        return mergeFrom((com.google.cloud.secretmanager.v1.Secret) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.secretmanager.v1.Secret other) {
      if (other == com.google.cloud.secretmanager.v1.Secret.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReplication()) {
        mergeReplication(other.getReplication());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (topicsBuilder_ == null) {
        if (!other.topics_.isEmpty()) {
          if (topics_.isEmpty()) {
            topics_ = other.topics_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureTopicsIsMutable();
            topics_.addAll(other.topics_);
          }
          onChanged();
        }
      } else {
        if (!other.topics_.isEmpty()) {
          if (topicsBuilder_.isEmpty()) {
            topicsBuilder_.dispose();
            topicsBuilder_ = null;
            topics_ = other.topics_;
            bitField0_ = (bitField0_ & ~0x00000010);
            topicsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTopicsFieldBuilder()
                    : null;
          } else {
            topicsBuilder_.addAllMessages(other.topics_);
          }
        }
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasRotation()) {
        mergeRotation(other.getRotation());
      }
      internalGetMutableVersionAliases().mergeFrom(other.internalGetVersionAliases());
      bitField0_ |= 0x00000200;
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000400;
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getReplicationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.secretmanager.v1.Topic m =
                    input.readMessage(
                        com.google.cloud.secretmanager.v1.Topic.parser(), extensionRegistry);
                if (topicsBuilder_ == null) {
                  ensureTopicsIsMutable();
                  topics_.add(m);
                } else {
                  topicsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getRotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> versionAliases__ =
                    input.readMessage(
                        VersionAliasesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableVersionAliases()
                    .getMutableMap()
                    .put(versionAliases__.getKey(), versionAliases__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 106:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secretmanager.v1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secretmanager.v1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secretmanager.v1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secretmanager.v1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the
     * [Secret][google.cloud.secretmanager.v1.Secret] in the format
     * `projects/&#42;&#47;secrets/&#42;`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.secretmanager.v1.Replication replication_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication,
            com.google.cloud.secretmanager.v1.Replication.Builder,
            com.google.cloud.secretmanager.v1.ReplicationOrBuilder>
        replicationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replication field is set.
     */
    public boolean hasReplication() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replication.
     */
    public com.google.cloud.secretmanager.v1.Replication getReplication() {
      if (replicationBuilder_ == null) {
        return replication_ == null
            ? com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()
            : replication_;
      } else {
        return replicationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReplication(com.google.cloud.secretmanager.v1.Replication value) {
      if (replicationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replication_ = value;
      } else {
        replicationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setReplication(
        com.google.cloud.secretmanager.v1.Replication.Builder builderForValue) {
      if (replicationBuilder_ == null) {
        replication_ = builderForValue.build();
      } else {
        replicationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeReplication(com.google.cloud.secretmanager.v1.Replication value) {
      if (replicationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && replication_ != null
            && replication_ != com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()) {
          getReplicationBuilder().mergeFrom(value);
        } else {
          replication_ = value;
        }
      } else {
        replicationBuilder_.mergeFrom(value);
      }
      if (replication_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearReplication() {
      bitField0_ = (bitField0_ & ~0x00000002);
      replication_ = null;
      if (replicationBuilder_ != null) {
        replicationBuilder_.dispose();
        replicationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Replication.Builder getReplicationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getReplicationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.ReplicationOrBuilder getReplicationOrBuilder() {
      if (replicationBuilder_ != null) {
        return replicationBuilder_.getMessageOrBuilder();
      } else {
        return replication_ == null
            ? com.google.cloud.secretmanager.v1.Replication.getDefaultInstance()
            : replication_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Immutable. The replication policy of the secret data attached to
     * the [Secret][google.cloud.secretmanager.v1.Secret].
     *
     * The replication policy cannot be changed after the Secret has been created.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Replication replication = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Replication,
            com.google.cloud.secretmanager.v1.Replication.Builder,
            com.google.cloud.secretmanager.v1.ReplicationOrBuilder>
        getReplicationFieldBuilder() {
      if (replicationBuilder_ == null) {
        replicationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.Replication,
                com.google.cloud.secretmanager.v1.Replication.Builder,
                com.google.cloud.secretmanager.v1.ReplicationOrBuilder>(
                getReplication(), getParentForChildren(), isClean());
        replication_ = null;
      }
      return replicationBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the
     * [Secret][google.cloud.secretmanager.v1.Secret] was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels assigned to this Secret.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
     * of maximum 128 bytes, and must conform to the following PCRE regular
     * expression: `[&#92;p{Ll}&#92;p{Lo}][&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,62}`
     *
     * Label values must be between 0 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, and must conform to the following PCRE
     * regular expression: `[&#92;p{Ll}&#92;p{Lo}&#92;p{N}_-]{0,63}`
     *
     * No more than 64 labels can be assigned to a given resource.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.util.List<com.google.cloud.secretmanager.v1.Topic> topics_ =
        java.util.Collections.emptyList();

    private void ensureTopicsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        topics_ = new java.util.ArrayList<com.google.cloud.secretmanager.v1.Topic>(topics_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Topic,
            com.google.cloud.secretmanager.v1.Topic.Builder,
            com.google.cloud.secretmanager.v1.TopicOrBuilder>
        topicsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.secretmanager.v1.Topic> getTopicsList() {
      if (topicsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(topics_);
      } else {
        return topicsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getTopicsCount() {
      if (topicsBuilder_ == null) {
        return topics_.size();
      } else {
        return topicsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Topic getTopics(int index) {
      if (topicsBuilder_ == null) {
        return topics_.get(index);
      } else {
        return topicsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTopics(int index, com.google.cloud.secretmanager.v1.Topic value) {
      if (topicsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopicsIsMutable();
        topics_.set(index, value);
        onChanged();
      } else {
        topicsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTopics(
        int index, com.google.cloud.secretmanager.v1.Topic.Builder builderForValue) {
      if (topicsBuilder_ == null) {
        ensureTopicsIsMutable();
        topics_.set(index, builderForValue.build());
        onChanged();
      } else {
        topicsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTopics(com.google.cloud.secretmanager.v1.Topic value) {
      if (topicsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopicsIsMutable();
        topics_.add(value);
        onChanged();
      } else {
        topicsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTopics(int index, com.google.cloud.secretmanager.v1.Topic value) {
      if (topicsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTopicsIsMutable();
        topics_.add(index, value);
        onChanged();
      } else {
        topicsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTopics(com.google.cloud.secretmanager.v1.Topic.Builder builderForValue) {
      if (topicsBuilder_ == null) {
        ensureTopicsIsMutable();
        topics_.add(builderForValue.build());
        onChanged();
      } else {
        topicsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addTopics(
        int index, com.google.cloud.secretmanager.v1.Topic.Builder builderForValue) {
      if (topicsBuilder_ == null) {
        ensureTopicsIsMutable();
        topics_.add(index, builderForValue.build());
        onChanged();
      } else {
        topicsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllTopics(
        java.lang.Iterable<? extends com.google.cloud.secretmanager.v1.Topic> values) {
      if (topicsBuilder_ == null) {
        ensureTopicsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, topics_);
        onChanged();
      } else {
        topicsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTopics() {
      if (topicsBuilder_ == null) {
        topics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        topicsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeTopics(int index) {
      if (topicsBuilder_ == null) {
        ensureTopicsIsMutable();
        topics_.remove(index);
        onChanged();
      } else {
        topicsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Topic.Builder getTopicsBuilder(int index) {
      return getTopicsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.TopicOrBuilder getTopicsOrBuilder(int index) {
      if (topicsBuilder_ == null) {
        return topics_.get(index);
      } else {
        return topicsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.secretmanager.v1.TopicOrBuilder>
        getTopicsOrBuilderList() {
      if (topicsBuilder_ != null) {
        return topicsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(topics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Topic.Builder addTopicsBuilder() {
      return getTopicsFieldBuilder()
          .addBuilder(com.google.cloud.secretmanager.v1.Topic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Topic.Builder addTopicsBuilder(int index) {
      return getTopicsFieldBuilder()
          .addBuilder(index, com.google.cloud.secretmanager.v1.Topic.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of up to 10 Pub/Sub topics to which messages are published
     * when control plane operations are called on the secret or its versions.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.secretmanager.v1.Topic topics = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.secretmanager.v1.Topic.Builder> getTopicsBuilderList() {
      return getTopicsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Topic,
            com.google.cloud.secretmanager.v1.Topic.Builder,
            com.google.cloud.secretmanager.v1.TopicOrBuilder>
        getTopicsFieldBuilder() {
      if (topicsBuilder_ == null) {
        topicsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.secretmanager.v1.Topic,
                com.google.cloud.secretmanager.v1.Topic.Builder,
                com.google.cloud.secretmanager.v1.TopicOrBuilder>(
                topics_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        topics_ = null;
      }
      return topicsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 6) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 6) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 6
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 6) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 6) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 6) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 6) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 6) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timestamp in UTC when the
     * [Secret][google.cloud.secretmanager.v1.Secret] is scheduled to expire.
     * This is always provided on output, regardless of what was sent on input.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 6)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 6;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 7) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 7) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 7
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 7) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 7) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 7) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 7) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 7) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for the
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 7 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 7)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 7;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Etag of the currently stored
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag of the currently stored
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag of the currently stored
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag of the currently stored
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Etag of the currently stored
     * [Secret][google.cloud.secretmanager.v1.Secret].
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.cloud.secretmanager.v1.Rotation rotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Rotation,
            com.google.cloud.secretmanager.v1.Rotation.Builder,
            com.google.cloud.secretmanager.v1.RotationOrBuilder>
        rotationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rotation field is set.
     */
    public boolean hasRotation() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rotation.
     */
    public com.google.cloud.secretmanager.v1.Rotation getRotation() {
      if (rotationBuilder_ == null) {
        return rotation_ == null
            ? com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()
            : rotation_;
      } else {
        return rotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRotation(com.google.cloud.secretmanager.v1.Rotation value) {
      if (rotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rotation_ = value;
      } else {
        rotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRotation(com.google.cloud.secretmanager.v1.Rotation.Builder builderForValue) {
      if (rotationBuilder_ == null) {
        rotation_ = builderForValue.build();
      } else {
        rotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRotation(com.google.cloud.secretmanager.v1.Rotation value) {
      if (rotationBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && rotation_ != null
            && rotation_ != com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()) {
          getRotationBuilder().mergeFrom(value);
        } else {
          rotation_ = value;
        }
      } else {
        rotationBuilder_.mergeFrom(value);
      }
      if (rotation_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRotation() {
      bitField0_ = (bitField0_ & ~0x00000100);
      rotation_ = null;
      if (rotationBuilder_ != null) {
        rotationBuilder_.dispose();
        rotationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.Rotation.Builder getRotationBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getRotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.secretmanager.v1.RotationOrBuilder getRotationOrBuilder() {
      if (rotationBuilder_ != null) {
        return rotationBuilder_.getMessageOrBuilder();
      } else {
        return rotation_ == null
            ? com.google.cloud.secretmanager.v1.Rotation.getDefaultInstance()
            : rotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Rotation policy attached to the
     * [Secret][google.cloud.secretmanager.v1.Secret]. May be excluded if there is
     * no rotation policy.
     * </pre>
     *
     * <code>
     * .google.cloud.secretmanager.v1.Rotation rotation = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.secretmanager.v1.Rotation,
            com.google.cloud.secretmanager.v1.Rotation.Builder,
            com.google.cloud.secretmanager.v1.RotationOrBuilder>
        getRotationFieldBuilder() {
      if (rotationBuilder_ == null) {
        rotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.secretmanager.v1.Rotation,
                com.google.cloud.secretmanager.v1.Rotation.Builder,
                com.google.cloud.secretmanager.v1.RotationOrBuilder>(
                getRotation(), getParentForChildren(), isClean());
        rotation_ = null;
      }
      return rotationBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> versionAliases_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetVersionAliases() {
      if (versionAliases_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            VersionAliasesDefaultEntryHolder.defaultEntry);
      }
      return versionAliases_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
        internalGetMutableVersionAliases() {
      if (versionAliases_ == null) {
        versionAliases_ =
            com.google.protobuf.MapField.newMapField(VersionAliasesDefaultEntryHolder.defaultEntry);
      }
      if (!versionAliases_.isMutable()) {
        versionAliases_ = versionAliases_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return versionAliases_;
    }

    public int getVersionAliasesCount() {
      return internalGetVersionAliases().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsVersionAliases(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetVersionAliases().getMap().containsKey(key);
    }
    /** Use {@link #getVersionAliasesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getVersionAliases() {
      return getVersionAliasesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getVersionAliasesMap() {
      return internalGetVersionAliases().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public long getVersionAliasesOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetVersionAliases().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public long getVersionAliasesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetVersionAliases().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearVersionAliases() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableVersionAliases().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeVersionAliases(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableVersionAliases().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getMutableVersionAliases() {
      bitField0_ |= 0x00000200;
      return internalGetMutableVersionAliases().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putVersionAliases(java.lang.String key, long value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableVersionAliases().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Mapping from version alias to version name.
     *
     * A version alias is a string with a maximum length of 63 characters and can
     * contain uppercase and lowercase letters, numerals, and the hyphen (`-`)
     * and underscore ('_') characters. An alias string must start with a
     * letter and cannot be the string 'latest' or 'NEW'.
     * No more than 50 aliases can be assigned to a given secret.
     *
     * Version-Alias pairs will be viewable via GetSecret and modifiable via
     * UpdateSecret. At launch access by alias will only be supported on
     * GetSecretVersion and AccessSecretVersion.
     * </pre>
     *
     * <code>
     * map&lt;string, int64&gt; version_aliases = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllVersionAliases(java.util.Map<java.lang.String, java.lang.Long> values) {
      internalGetMutableVersionAliases().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000400;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom metadata about the secret.
     *
     * Annotations are distinct from various forms of labels.
     * Annotations exist to allow client tools to store their own state
     * information without requiring a database.
     *
     * Annotation keys must be between 1 and 63 characters long, have a UTF-8
     * encoding of maximum 128 bytes, begin and end with an alphanumeric character
     * ([a-z0-9A-Z]), and may have dashes (-), underscores (_), dots (.), and
     * alphanumerics in between these symbols.
     *
     * The total size of annotation keys and values must be less than 16KiB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.secretmanager.v1.Secret)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.secretmanager.v1.Secret)
  private static final com.google.cloud.secretmanager.v1.Secret DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.secretmanager.v1.Secret();
  }

  public static com.google.cloud.secretmanager.v1.Secret getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Secret> PARSER =
      new com.google.protobuf.AbstractParser<Secret>() {
        @java.lang.Override
        public Secret parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Secret> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Secret> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.secretmanager.v1.Secret getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
