/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

// Protobuf Java Version: 3.25.5
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * A backup of a Cloud Spanner database.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.Backup}
 */
public final class Backup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.Backup)
    BackupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Backup.newBuilder() to construct.
  private Backup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Backup() {
    database_ = "";
    name_ = "";
    state_ = 0;
    referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    encryptionInformation_ = java.util.Collections.emptyList();
    databaseDialect_ = 0;
    referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
    backupSchedules_ = com.google.protobuf.LazyStringArrayList.emptyList();
    incrementalBackupChainId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Backup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_Backup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_Backup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.Backup.class,
            com.google.spanner.admin.database.v1.Backup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the backup.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.database.v1.Backup.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The pending backup is still being created. Operations on the
     * backup may fail with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The backup is complete and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The pending backup is still being created. Operations on the
     * backup may fail with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The backup is complete and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.Backup.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.database.v1.Backup.State)
  }

  private int bitField0_;
  public static final int DATABASE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Name of the database from which this backup was created. This
   * needs to be in the same instance as the backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Name of the database from which this backup was created. This
   * needs to be in the same instance as the backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp versionTime_;
  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   *
   * @return Whether the versionTime field is set.
   */
  @java.lang.Override
  public boolean hasVersionTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   *
   * @return The versionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getVersionTime() {
    return versionTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : versionTime_;
  }
  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getVersionTimeOrBuilder() {
    return versionTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : versionTime_;
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Required for the
   * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
   * operation.
   *
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters
   * in length.
   *
   * The backup is stored in the location(s) specified in the instance
   * configuration of the instance containing the backup, identified
   * by the prefix of the backup name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Required for the
   * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
   * operation.
   *
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters
   * in length.
   *
   * The backup is stored in the location(s) specified in the instance
   * configuration of the instance containing the backup, identified
   * by the prefix of the backup name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SIZE_BYTES_FIELD_NUMBER = 5;
  private long sizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Size of the backup in bytes.
   * </pre>
   *
   * <code>int64 size_bytes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sizeBytes.
   */
  @java.lang.Override
  public long getSizeBytes() {
    return sizeBytes_;
  }

  public static final int FREEABLE_SIZE_BYTES_FIELD_NUMBER = 15;
  private long freeableSizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of bytes that will be freed by deleting this
   * backup. This value will be zero if, for example, this backup is part of an
   * incremental backup chain and younger backups in the chain require that we
   * keep its data. For backups not in an incremental backup chain, this is
   * always the size of the backup. This value may change if backups on the same
   * chain get created, deleted or expired.
   * </pre>
   *
   * <code>int64 freeable_size_bytes = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The freeableSizeBytes.
   */
  @java.lang.Override
  public long getFreeableSizeBytes() {
    return freeableSizeBytes_;
  }

  public static final int EXCLUSIVE_SIZE_BYTES_FIELD_NUMBER = 16;
  private long exclusiveSizeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. For a backup in an incremental backup chain, this is the
   * storage space needed to keep the data that has changed since the previous
   * backup. For all other backups, this is always the size of the backup. This
   * value may change if backups on the same chain get deleted or expired.
   *
   * This field can be used to calculate the total storage space used by a set
   * of backups. For example, the total space used by all backups of a database
   * can be computed by summing up this field.
   * </pre>
   *
   * <code>int64 exclusive_size_bytes = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The exclusiveSizeBytes.
   */
  @java.lang.Override
  public long getExclusiveSizeBytes() {
    return exclusiveSizeBytes_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Backup.State getState() {
    com.google.spanner.admin.database.v1.Backup.State result =
        com.google.spanner.admin.database.v1.Backup.State.forNumber(state_);
    return result == null ? com.google.spanner.admin.database.v1.Backup.State.UNRECOGNIZED : result;
  }

  public static final int REFERENCING_DATABASES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencingDatabases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencingDatabases.
   */
  public com.google.protobuf.ProtocolStringList getReferencingDatabasesList() {
    return referencingDatabases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencingDatabases.
   */
  public int getReferencingDatabasesCount() {
    return referencingDatabases_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingDatabases at the given index.
   */
  public java.lang.String getReferencingDatabases(int index) {
    return referencingDatabases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingDatabases at the given index.
   */
  public com.google.protobuf.ByteString getReferencingDatabasesBytes(int index) {
    return referencingDatabases_.getByteString(index);
  }

  public static final int ENCRYPTION_INFO_FIELD_NUMBER = 8;
  private com.google.spanner.admin.database.v1.EncryptionInfo encryptionInfo_;
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionInfo field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionInfo() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionInfo.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo() {
    return encryptionInfo_ == null
        ? com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()
        : encryptionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder() {
    return encryptionInfo_ == null
        ? com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()
        : encryptionInfo_;
  }

  public static final int ENCRYPTION_INFORMATION_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
      encryptionInformation_;
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
      getEncryptionInformationList() {
    return encryptionInformation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
      getEncryptionInformationOrBuilderList() {
    return encryptionInformation_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getEncryptionInformationCount() {
    return encryptionInformation_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInformation(int index) {
    return encryptionInformation_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder
      getEncryptionInformationOrBuilder(int index) {
    return encryptionInformation_.get(index);
  }

  public static final int DATABASE_DIALECT_FIELD_NUMBER = 10;
  private int databaseDialect_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The database dialect information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  @java.lang.Override
  public int getDatabaseDialectValue() {
    return databaseDialect_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The database dialect information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The databaseDialect.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
    com.google.spanner.admin.database.v1.DatabaseDialect result =
        com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
    return result == null
        ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
        : result;
  }

  public static final int REFERENCING_BACKUPS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList referencingBackups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencingBackups.
   */
  public com.google.protobuf.ProtocolStringList getReferencingBackupsList() {
    return referencingBackups_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencingBackups.
   */
  public int getReferencingBackupsCount() {
    return referencingBackups_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingBackups at the given index.
   */
  public java.lang.String getReferencingBackups(int index) {
    return referencingBackups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingBackups at the given index.
   */
  public com.google.protobuf.ByteString getReferencingBackupsBytes(int index) {
    return referencingBackups_.getByteString(index);
  }

  public static final int MAX_EXPIRE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp maxExpireTime_;
  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the maxExpireTime field is set.
   */
  @java.lang.Override
  public boolean hasMaxExpireTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The maxExpireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getMaxExpireTime() {
    return maxExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : maxExpireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getMaxExpireTimeOrBuilder() {
    return maxExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : maxExpireTime_;
  }

  public static final int BACKUP_SCHEDULES_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList backupSchedules_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the backupSchedules.
   */
  public com.google.protobuf.ProtocolStringList getBackupSchedulesList() {
    return backupSchedules_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of backupSchedules.
   */
  public int getBackupSchedulesCount() {
    return backupSchedules_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The backupSchedules at the given index.
   */
  public java.lang.String getBackupSchedules(int index) {
    return backupSchedules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the backupSchedules at the given index.
   */
  public com.google.protobuf.ByteString getBackupSchedulesBytes(int index) {
    return backupSchedules_.getByteString(index);
  }

  public static final int INCREMENTAL_BACKUP_CHAIN_ID_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object incrementalBackupChainId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Populated only for backups in an incremental backup chain.
   * Backups share the same chain id if and only if they belong to the same
   * incremental backup chain. Use this field to determine which backups are
   * part of the same incremental backup chain. The ordering of backups in the
   * chain can be determined by ordering the backup `version_time`.
   * </pre>
   *
   * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The incrementalBackupChainId.
   */
  @java.lang.Override
  public java.lang.String getIncrementalBackupChainId() {
    java.lang.Object ref = incrementalBackupChainId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      incrementalBackupChainId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Populated only for backups in an incremental backup chain.
   * Backups share the same chain id if and only if they belong to the same
   * incremental backup chain. Use this field to determine which backups are
   * part of the same incremental backup chain. The ordering of backups in the
   * chain can be determined by ordering the backup `version_time`.
   * </pre>
   *
   * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for incrementalBackupChainId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIncrementalBackupChainIdBytes() {
    java.lang.Object ref = incrementalBackupChainId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      incrementalBackupChainId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OLDEST_VERSION_TIME_FIELD_NUMBER = 18;
  private com.google.protobuf.Timestamp oldestVersionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the oldestVersionTime field is set.
   */
  @java.lang.Override
  public boolean hasOldestVersionTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The oldestVersionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getOldestVersionTime() {
    return oldestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : oldestVersionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getOldestVersionTimeOrBuilder() {
    return oldestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : oldestVersionTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, database_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getExpireTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (sizeBytes_ != 0L) {
      output.writeInt64(5, sizeBytes_);
    }
    if (state_ != com.google.spanner.admin.database.v1.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    for (int i = 0; i < referencingDatabases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 7, referencingDatabases_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(8, getEncryptionInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getVersionTime());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, databaseDialect_);
    }
    for (int i = 0; i < referencingBackups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, referencingBackups_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(12, getMaxExpireTime());
    }
    for (int i = 0; i < encryptionInformation_.size(); i++) {
      output.writeMessage(13, encryptionInformation_.get(i));
    }
    for (int i = 0; i < backupSchedules_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, backupSchedules_.getRaw(i));
    }
    if (freeableSizeBytes_ != 0L) {
      output.writeInt64(15, freeableSizeBytes_);
    }
    if (exclusiveSizeBytes_ != 0L) {
      output.writeInt64(16, exclusiveSizeBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incrementalBackupChainId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, incrementalBackupChainId_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(18, getOldestVersionTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, database_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getExpireTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (sizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, sizeBytes_);
    }
    if (state_ != com.google.spanner.admin.database.v1.Backup.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencingDatabases_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencingDatabases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencingDatabasesList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEncryptionInfo());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getVersionTime());
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, databaseDialect_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < referencingBackups_.size(); i++) {
        dataSize += computeStringSizeNoTag(referencingBackups_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReferencingBackupsList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getMaxExpireTime());
    }
    for (int i = 0; i < encryptionInformation_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, encryptionInformation_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < backupSchedules_.size(); i++) {
        dataSize += computeStringSizeNoTag(backupSchedules_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBackupSchedulesList().size();
    }
    if (freeableSizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(15, freeableSizeBytes_);
    }
    if (exclusiveSizeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(16, exclusiveSizeBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incrementalBackupChainId_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(17, incrementalBackupChainId_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getOldestVersionTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.Backup)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.Backup other =
        (com.google.spanner.admin.database.v1.Backup) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (hasVersionTime() != other.hasVersionTime()) return false;
    if (hasVersionTime()) {
      if (!getVersionTime().equals(other.getVersionTime())) return false;
    }
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getSizeBytes() != other.getSizeBytes()) return false;
    if (getFreeableSizeBytes() != other.getFreeableSizeBytes()) return false;
    if (getExclusiveSizeBytes() != other.getExclusiveSizeBytes()) return false;
    if (state_ != other.state_) return false;
    if (!getReferencingDatabasesList().equals(other.getReferencingDatabasesList())) return false;
    if (hasEncryptionInfo() != other.hasEncryptionInfo()) return false;
    if (hasEncryptionInfo()) {
      if (!getEncryptionInfo().equals(other.getEncryptionInfo())) return false;
    }
    if (!getEncryptionInformationList().equals(other.getEncryptionInformationList())) return false;
    if (databaseDialect_ != other.databaseDialect_) return false;
    if (!getReferencingBackupsList().equals(other.getReferencingBackupsList())) return false;
    if (hasMaxExpireTime() != other.hasMaxExpireTime()) return false;
    if (hasMaxExpireTime()) {
      if (!getMaxExpireTime().equals(other.getMaxExpireTime())) return false;
    }
    if (!getBackupSchedulesList().equals(other.getBackupSchedulesList())) return false;
    if (!getIncrementalBackupChainId().equals(other.getIncrementalBackupChainId())) return false;
    if (hasOldestVersionTime() != other.hasOldestVersionTime()) return false;
    if (hasOldestVersionTime()) {
      if (!getOldestVersionTime().equals(other.getOldestVersionTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (hasVersionTime()) {
      hash = (37 * hash) + VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getVersionTime().hashCode();
    }
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSizeBytes());
    hash = (37 * hash) + FREEABLE_SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFreeableSizeBytes());
    hash = (37 * hash) + EXCLUSIVE_SIZE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getExclusiveSizeBytes());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getReferencingDatabasesCount() > 0) {
      hash = (37 * hash) + REFERENCING_DATABASES_FIELD_NUMBER;
      hash = (53 * hash) + getReferencingDatabasesList().hashCode();
    }
    if (hasEncryptionInfo()) {
      hash = (37 * hash) + ENCRYPTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionInfo().hashCode();
    }
    if (getEncryptionInformationCount() > 0) {
      hash = (37 * hash) + ENCRYPTION_INFORMATION_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionInformationList().hashCode();
    }
    hash = (37 * hash) + DATABASE_DIALECT_FIELD_NUMBER;
    hash = (53 * hash) + databaseDialect_;
    if (getReferencingBackupsCount() > 0) {
      hash = (37 * hash) + REFERENCING_BACKUPS_FIELD_NUMBER;
      hash = (53 * hash) + getReferencingBackupsList().hashCode();
    }
    if (hasMaxExpireTime()) {
      hash = (37 * hash) + MAX_EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getMaxExpireTime().hashCode();
    }
    if (getBackupSchedulesCount() > 0) {
      hash = (37 * hash) + BACKUP_SCHEDULES_FIELD_NUMBER;
      hash = (53 * hash) + getBackupSchedulesList().hashCode();
    }
    hash = (37 * hash) + INCREMENTAL_BACKUP_CHAIN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getIncrementalBackupChainId().hashCode();
    if (hasOldestVersionTime()) {
      hash = (37 * hash) + OLDEST_VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getOldestVersionTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Backup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Backup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Backup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.Backup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A backup of a Cloud Spanner database.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.Backup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.Backup)
      com.google.spanner.admin.database.v1.BackupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_Backup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_Backup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.Backup.class,
              com.google.spanner.admin.database.v1.Backup.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.Backup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getVersionTimeFieldBuilder();
        getExpireTimeFieldBuilder();
        getCreateTimeFieldBuilder();
        getEncryptionInfoFieldBuilder();
        getEncryptionInformationFieldBuilder();
        getMaxExpireTimeFieldBuilder();
        getOldestVersionTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      versionTime_ = null;
      if (versionTimeBuilder_ != null) {
        versionTimeBuilder_.dispose();
        versionTimeBuilder_ = null;
      }
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      sizeBytes_ = 0L;
      freeableSizeBytes_ = 0L;
      exclusiveSizeBytes_ = 0L;
      state_ = 0;
      referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      encryptionInfo_ = null;
      if (encryptionInfoBuilder_ != null) {
        encryptionInfoBuilder_.dispose();
        encryptionInfoBuilder_ = null;
      }
      if (encryptionInformationBuilder_ == null) {
        encryptionInformation_ = java.util.Collections.emptyList();
      } else {
        encryptionInformation_ = null;
        encryptionInformationBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      databaseDialect_ = 0;
      referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      maxExpireTime_ = null;
      if (maxExpireTimeBuilder_ != null) {
        maxExpireTimeBuilder_.dispose();
        maxExpireTimeBuilder_ = null;
      }
      backupSchedules_ = com.google.protobuf.LazyStringArrayList.emptyList();
      incrementalBackupChainId_ = "";
      oldestVersionTime_ = null;
      if (oldestVersionTimeBuilder_ != null) {
        oldestVersionTimeBuilder_.dispose();
        oldestVersionTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_Backup_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Backup getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.Backup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Backup build() {
      com.google.spanner.admin.database.v1.Backup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Backup buildPartial() {
      com.google.spanner.admin.database.v1.Backup result =
          new com.google.spanner.admin.database.v1.Backup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.admin.database.v1.Backup result) {
      if (encryptionInformationBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          encryptionInformation_ = java.util.Collections.unmodifiableList(encryptionInformation_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.encryptionInformation_ = encryptionInformation_;
      } else {
        result.encryptionInformation_ = encryptionInformationBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.Backup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.versionTime_ =
            versionTimeBuilder_ == null ? versionTime_ : versionTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sizeBytes_ = sizeBytes_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.freeableSizeBytes_ = freeableSizeBytes_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.exclusiveSizeBytes_ = exclusiveSizeBytes_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        referencingDatabases_.makeImmutable();
        result.referencingDatabases_ = referencingDatabases_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.encryptionInfo_ =
            encryptionInfoBuilder_ == null ? encryptionInfo_ : encryptionInfoBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.databaseDialect_ = databaseDialect_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        referencingBackups_.makeImmutable();
        result.referencingBackups_ = referencingBackups_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.maxExpireTime_ =
            maxExpireTimeBuilder_ == null ? maxExpireTime_ : maxExpireTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        backupSchedules_.makeImmutable();
        result.backupSchedules_ = backupSchedules_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.incrementalBackupChainId_ = incrementalBackupChainId_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.oldestVersionTime_ =
            oldestVersionTimeBuilder_ == null
                ? oldestVersionTime_
                : oldestVersionTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.Backup) {
        return mergeFrom((com.google.spanner.admin.database.v1.Backup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.Backup other) {
      if (other == com.google.spanner.admin.database.v1.Backup.getDefaultInstance()) return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasVersionTime()) {
        mergeVersionTime(other.getVersionTime());
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getSizeBytes() != 0L) {
        setSizeBytes(other.getSizeBytes());
      }
      if (other.getFreeableSizeBytes() != 0L) {
        setFreeableSizeBytes(other.getFreeableSizeBytes());
      }
      if (other.getExclusiveSizeBytes() != 0L) {
        setExclusiveSizeBytes(other.getExclusiveSizeBytes());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.referencingDatabases_.isEmpty()) {
        if (referencingDatabases_.isEmpty()) {
          referencingDatabases_ = other.referencingDatabases_;
          bitField0_ |= 0x00000200;
        } else {
          ensureReferencingDatabasesIsMutable();
          referencingDatabases_.addAll(other.referencingDatabases_);
        }
        onChanged();
      }
      if (other.hasEncryptionInfo()) {
        mergeEncryptionInfo(other.getEncryptionInfo());
      }
      if (encryptionInformationBuilder_ == null) {
        if (!other.encryptionInformation_.isEmpty()) {
          if (encryptionInformation_.isEmpty()) {
            encryptionInformation_ = other.encryptionInformation_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureEncryptionInformationIsMutable();
            encryptionInformation_.addAll(other.encryptionInformation_);
          }
          onChanged();
        }
      } else {
        if (!other.encryptionInformation_.isEmpty()) {
          if (encryptionInformationBuilder_.isEmpty()) {
            encryptionInformationBuilder_.dispose();
            encryptionInformationBuilder_ = null;
            encryptionInformation_ = other.encryptionInformation_;
            bitField0_ = (bitField0_ & ~0x00000800);
            encryptionInformationBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEncryptionInformationFieldBuilder()
                    : null;
          } else {
            encryptionInformationBuilder_.addAllMessages(other.encryptionInformation_);
          }
        }
      }
      if (other.databaseDialect_ != 0) {
        setDatabaseDialectValue(other.getDatabaseDialectValue());
      }
      if (!other.referencingBackups_.isEmpty()) {
        if (referencingBackups_.isEmpty()) {
          referencingBackups_ = other.referencingBackups_;
          bitField0_ |= 0x00002000;
        } else {
          ensureReferencingBackupsIsMutable();
          referencingBackups_.addAll(other.referencingBackups_);
        }
        onChanged();
      }
      if (other.hasMaxExpireTime()) {
        mergeMaxExpireTime(other.getMaxExpireTime());
      }
      if (!other.backupSchedules_.isEmpty()) {
        if (backupSchedules_.isEmpty()) {
          backupSchedules_ = other.backupSchedules_;
          bitField0_ |= 0x00008000;
        } else {
          ensureBackupSchedulesIsMutable();
          backupSchedules_.addAll(other.backupSchedules_);
        }
        onChanged();
      }
      if (!other.getIncrementalBackupChainId().isEmpty()) {
        incrementalBackupChainId_ = other.incrementalBackupChainId_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasOldestVersionTime()) {
        mergeOldestVersionTime(other.getOldestVersionTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                sizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 48
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencingDatabasesIsMutable();
                referencingDatabases_.add(s);
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEncryptionInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 74
            case 80:
              {
                databaseDialect_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 80
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReferencingBackupsIsMutable();
                referencingBackups_.add(s);
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getMaxExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 98
            case 106:
              {
                com.google.spanner.admin.database.v1.EncryptionInfo m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.EncryptionInfo.parser(),
                        extensionRegistry);
                if (encryptionInformationBuilder_ == null) {
                  ensureEncryptionInformationIsMutable();
                  encryptionInformation_.add(m);
                } else {
                  encryptionInformationBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBackupSchedulesIsMutable();
                backupSchedules_.add(s);
                break;
              } // case 114
            case 120:
              {
                freeableSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 120
            case 128:
              {
                exclusiveSizeBytes_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 128
            case 138:
              {
                incrementalBackupChainId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getOldestVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Name of the database from which this backup was created. This
     * needs to be in the same instance as the backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Name of the database from which this backup was created. This
     * needs to be in the same instance as the backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Name of the database from which this backup was created. This
     * needs to be in the same instance as the backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Name of the database from which this backup was created. This
     * needs to be in the same instance as the backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Name of the database from which this backup was created. This
     * needs to be in the same instance as the backup. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * </pre>
     *
     * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp versionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        versionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     *
     * @return Whether the versionTime field is set.
     */
    public boolean hasVersionTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     *
     * @return The versionTime.
     */
    public com.google.protobuf.Timestamp getVersionTime() {
      if (versionTimeBuilder_ == null) {
        return versionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionTime_;
      } else {
        return versionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public Builder setVersionTime(com.google.protobuf.Timestamp value) {
      if (versionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        versionTime_ = value;
      } else {
        versionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public Builder setVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (versionTimeBuilder_ == null) {
        versionTime_ = builderForValue.build();
      } else {
        versionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public Builder mergeVersionTime(com.google.protobuf.Timestamp value) {
      if (versionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && versionTime_ != null
            && versionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getVersionTimeBuilder().mergeFrom(value);
        } else {
          versionTime_ = value;
        }
      } else {
        versionTimeBuilder_.mergeFrom(value);
      }
      if (versionTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public Builder clearVersionTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      versionTime_ = null;
      if (versionTimeBuilder_ != null) {
        versionTimeBuilder_.dispose();
        versionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public com.google.protobuf.Timestamp.Builder getVersionTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getVersionTimeOrBuilder() {
      if (versionTimeBuilder_ != null) {
        return versionTimeBuilder_.getMessageOrBuilder();
      } else {
        return versionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : versionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The backup will contain an externally consistent copy of the database at
     * the timestamp specified by `version_time`. If `version_time` is not
     * specified, the system will set `version_time` to the `create_time` of the
     * backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp version_time = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getVersionTimeFieldBuilder() {
      if (versionTimeBuilder_ == null) {
        versionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getVersionTime(), getParentForChildren(), isClean());
        versionTime_ = null;
      }
      return versionTimeBuilder_;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. The expiration time of the backup, with microseconds
     * granularity that must be at least 6 hours and at most 366 days
     * from the time the CreateBackup request is processed. Once the `expire_time`
     * has passed, the backup is eligible to be automatically deleted by Cloud
     * Spanner to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Required for the
     * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
     * operation.
     *
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters
     * in length.
     *
     * The backup is stored in the location(s) specified in the instance
     * configuration of the instance containing the backup, identified
     * by the prefix of the backup name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Required for the
     * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
     * operation.
     *
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters
     * in length.
     *
     * The backup is stored in the location(s) specified in the instance
     * configuration of the instance containing the backup, identified
     * by the prefix of the backup name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Required for the
     * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
     * operation.
     *
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters
     * in length.
     *
     * The backup is stored in the location(s) specified in the instance
     * configuration of the instance containing the backup, identified
     * by the prefix of the backup name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Required for the
     * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
     * operation.
     *
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters
     * in length.
     *
     * The backup is stored in the location(s) specified in the instance
     * configuration of the instance containing the backup, identified
     * by the prefix of the backup name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only for the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * operation. Required for the
     * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
     * operation.
     *
     * A globally unique identifier for the backup which cannot be
     * changed. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
     * The final segment of the name must be between 2 and 60 characters
     * in length.
     *
     * The backup is stored in the location(s) specified in the instance
     * configuration of the instance containing the backup, identified
     * by the prefix of the backup name of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the
     * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
     * request is received. If the request does not specify `version_time`, the
     * `version_time` of the backup will be equivalent to the `create_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private long sizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The sizeBytes.
     */
    @java.lang.Override
    public long getSizeBytes() {
      return sizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The sizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setSizeBytes(long value) {

      sizeBytes_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Size of the backup in bytes.
     * </pre>
     *
     * <code>int64 size_bytes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000020);
      sizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private long freeableSizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. The number of bytes that will be freed by deleting this
     * backup. This value will be zero if, for example, this backup is part of an
     * incremental backup chain and younger backups in the chain require that we
     * keep its data. For backups not in an incremental backup chain, this is
     * always the size of the backup. This value may change if backups on the same
     * chain get created, deleted or expired.
     * </pre>
     *
     * <code>int64 freeable_size_bytes = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The freeableSizeBytes.
     */
    @java.lang.Override
    public long getFreeableSizeBytes() {
      return freeableSizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of bytes that will be freed by deleting this
     * backup. This value will be zero if, for example, this backup is part of an
     * incremental backup chain and younger backups in the chain require that we
     * keep its data. For backups not in an incremental backup chain, this is
     * always the size of the backup. This value may change if backups on the same
     * chain get created, deleted or expired.
     * </pre>
     *
     * <code>int64 freeable_size_bytes = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The freeableSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setFreeableSizeBytes(long value) {

      freeableSizeBytes_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of bytes that will be freed by deleting this
     * backup. This value will be zero if, for example, this backup is part of an
     * incremental backup chain and younger backups in the chain require that we
     * keep its data. For backups not in an incremental backup chain, this is
     * always the size of the backup. This value may change if backups on the same
     * chain get created, deleted or expired.
     * </pre>
     *
     * <code>int64 freeable_size_bytes = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFreeableSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000040);
      freeableSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private long exclusiveSizeBytes_;
    /**
     *
     *
     * <pre>
     * Output only. For a backup in an incremental backup chain, this is the
     * storage space needed to keep the data that has changed since the previous
     * backup. For all other backups, this is always the size of the backup. This
     * value may change if backups on the same chain get deleted or expired.
     *
     * This field can be used to calculate the total storage space used by a set
     * of backups. For example, the total space used by all backups of a database
     * can be computed by summing up this field.
     * </pre>
     *
     * <code>int64 exclusive_size_bytes = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The exclusiveSizeBytes.
     */
    @java.lang.Override
    public long getExclusiveSizeBytes() {
      return exclusiveSizeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a backup in an incremental backup chain, this is the
     * storage space needed to keep the data that has changed since the previous
     * backup. For all other backups, this is always the size of the backup. This
     * value may change if backups on the same chain get deleted or expired.
     *
     * This field can be used to calculate the total storage space used by a set
     * of backups. For example, the total space used by all backups of a database
     * can be computed by summing up this field.
     * </pre>
     *
     * <code>int64 exclusive_size_bytes = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The exclusiveSizeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setExclusiveSizeBytes(long value) {

      exclusiveSizeBytes_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For a backup in an incremental backup chain, this is the
     * storage space needed to keep the data that has changed since the previous
     * backup. For all other backups, this is always the size of the backup. This
     * value may change if backups on the same chain get deleted or expired.
     *
     * This field can be used to calculate the total storage space used by a set
     * of backups. For example, the total space used by all backups of a database
     * can be computed by summing up this field.
     * </pre>
     *
     * <code>int64 exclusive_size_bytes = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExclusiveSizeBytes() {
      bitField0_ = (bitField0_ & ~0x00000080);
      exclusiveSizeBytes_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.Backup.State getState() {
      com.google.spanner.admin.database.v1.Backup.State result =
          com.google.spanner.admin.database.v1.Backup.State.forNumber(state_);
      return result == null
          ? com.google.spanner.admin.database.v1.Backup.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.spanner.admin.database.v1.Backup.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList referencingDatabases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencingDatabasesIsMutable() {
      if (!referencingDatabases_.isModifiable()) {
        referencingDatabases_ = new com.google.protobuf.LazyStringArrayList(referencingDatabases_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the referencingDatabases.
     */
    public com.google.protobuf.ProtocolStringList getReferencingDatabasesList() {
      referencingDatabases_.makeImmutable();
      return referencingDatabases_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of referencingDatabases.
     */
    public int getReferencingDatabasesCount() {
      return referencingDatabases_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencingDatabases at the given index.
     */
    public java.lang.String getReferencingDatabases(int index) {
      return referencingDatabases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencingDatabases at the given index.
     */
    public com.google.protobuf.ByteString getReferencingDatabasesBytes(int index) {
      return referencingDatabases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencingDatabases to set.
     * @return This builder for chaining.
     */
    public Builder setReferencingDatabases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingDatabases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencingDatabases(java.lang.Iterable<java.lang.String> values) {
      ensureReferencingDatabasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencingDatabases_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencingDatabases() {
      referencingDatabases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the restored databases that reference the backup.
     * The database names are of
     * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
     * Referencing databases may exist in different instances. The existence of
     * any referencing database prevents the backup from being deleted. When a
     * restored database from the backup enters the `READY` state, the reference
     * to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the referencingDatabases to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingDatabasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencingDatabasesIsMutable();
      referencingDatabases_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.spanner.admin.database.v1.EncryptionInfo encryptionInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        encryptionInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the encryptionInfo field is set.
     */
    public boolean hasEncryptionInfo() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionInfo.
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo() {
      if (encryptionInfoBuilder_ == null) {
        return encryptionInfo_ == null
            ? com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()
            : encryptionInfo_;
      } else {
        return encryptionInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionInfo_ = value;
      } else {
        encryptionInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(
        com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = builderForValue.build();
      } else {
        encryptionInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEncryptionInfo(com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && encryptionInfo_ != null
            && encryptionInfo_
                != com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()) {
          getEncryptionInfoBuilder().mergeFrom(value);
        } else {
          encryptionInfo_ = value;
        }
      } else {
        encryptionInfoBuilder_.mergeFrom(value);
      }
      if (encryptionInfo_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionInfo() {
      bitField0_ = (bitField0_ & ~0x00000400);
      encryptionInfo_ = null;
      if (encryptionInfoBuilder_ != null) {
        encryptionInfoBuilder_.dispose();
        encryptionInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder getEncryptionInfoBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getEncryptionInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder
        getEncryptionInfoOrBuilder() {
      if (encryptionInfoBuilder_ != null) {
        return encryptionInfoBuilder_.getMessageOrBuilder();
      } else {
        return encryptionInfo_ == null
            ? com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance()
            : encryptionInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        getEncryptionInfoFieldBuilder() {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionInfo,
                com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
                com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>(
                getEncryptionInfo(), getParentForChildren(), isClean());
        encryptionInfo_ = null;
      }
      return encryptionInfoBuilder_;
    }

    private java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
        encryptionInformation_ = java.util.Collections.emptyList();

    private void ensureEncryptionInformationIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        encryptionInformation_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.EncryptionInfo>(
                encryptionInformation_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        encryptionInformationBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
        getEncryptionInformationList() {
      if (encryptionInformationBuilder_ == null) {
        return java.util.Collections.unmodifiableList(encryptionInformation_);
      } else {
        return encryptionInformationBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getEncryptionInformationCount() {
      if (encryptionInformationBuilder_ == null) {
        return encryptionInformation_.size();
      } else {
        return encryptionInformationBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInformation(int index) {
      if (encryptionInformationBuilder_ == null) {
        return encryptionInformation_.get(index);
      } else {
        return encryptionInformationBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInformation(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.set(index, value);
        onChanged();
      } else {
        encryptionInformationBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInformation(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInformationBuilder_ == null) {
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.set(index, builderForValue.build());
        onChanged();
      } else {
        encryptionInformationBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInformation(
        com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.add(value);
        onChanged();
      } else {
        encryptionInformationBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInformation(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.add(index, value);
        onChanged();
      } else {
        encryptionInformationBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInformation(
        com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInformationBuilder_ == null) {
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.add(builderForValue.build());
        onChanged();
      } else {
        encryptionInformationBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInformation(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInformationBuilder_ == null) {
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.add(index, builderForValue.build());
        onChanged();
      } else {
        encryptionInformationBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllEncryptionInformation(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.EncryptionInfo> values) {
      if (encryptionInformationBuilder_ == null) {
        ensureEncryptionInformationIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, encryptionInformation_);
        onChanged();
      } else {
        encryptionInformationBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionInformation() {
      if (encryptionInformationBuilder_ == null) {
        encryptionInformation_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        encryptionInformationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeEncryptionInformation(int index) {
      if (encryptionInformationBuilder_ == null) {
        ensureEncryptionInformationIsMutable();
        encryptionInformation_.remove(index);
        onChanged();
      } else {
        encryptionInformationBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder
        getEncryptionInformationBuilder(int index) {
      return getEncryptionInformationFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder
        getEncryptionInformationOrBuilder(int index) {
      if (encryptionInformationBuilder_ == null) {
        return encryptionInformation_.get(index);
      } else {
        return encryptionInformationBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        getEncryptionInformationOrBuilderList() {
      if (encryptionInformationBuilder_ != null) {
        return encryptionInformationBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(encryptionInformation_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder
        addEncryptionInformationBuilder() {
      return getEncryptionInformationFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder
        addEncryptionInformationBuilder(int index) {
      return getEncryptionInformationFieldBuilder()
          .addBuilder(
              index, com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The encryption information for the backup, whether it is
     * protected by one or more KMS keys. The information includes all Cloud
     * KMS key versions used to encrypt the backup. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated. At least one of the key
     * versions must be available for the backup to be restored. If a key version
     * is revoked in the middle of a restore, the restore behavior is undefined.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo.Builder>
        getEncryptionInformationBuilderList() {
      return getEncryptionInformationFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        getEncryptionInformationFieldBuilder() {
      if (encryptionInformationBuilder_ == null) {
        encryptionInformationBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionInfo,
                com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
                com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>(
                encryptionInformation_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        encryptionInformation_ = null;
      }
      return encryptionInformationBuilder_;
    }

    private int databaseDialect_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The database dialect information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseDialect.
     */
    @java.lang.Override
    public int getDatabaseDialectValue() {
      return databaseDialect_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The database dialect information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialectValue(int value) {
      databaseDialect_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The database dialect information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The databaseDialect.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
      com.google.spanner.admin.database.v1.DatabaseDialect result =
          com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
      return result == null
          ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The database dialect information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialect(com.google.spanner.admin.database.v1.DatabaseDialect value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      databaseDialect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The database dialect information for the backup.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseDialect() {
      bitField0_ = (bitField0_ & ~0x00001000);
      databaseDialect_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList referencingBackups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReferencingBackupsIsMutable() {
      if (!referencingBackups_.isModifiable()) {
        referencingBackups_ = new com.google.protobuf.LazyStringArrayList(referencingBackups_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the referencingBackups.
     */
    public com.google.protobuf.ProtocolStringList getReferencingBackupsList() {
      referencingBackups_.makeImmutable();
      return referencingBackups_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of referencingBackups.
     */
    public int getReferencingBackupsCount() {
      return referencingBackups_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The referencingBackups at the given index.
     */
    public java.lang.String getReferencingBackups(int index) {
      return referencingBackups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the referencingBackups at the given index.
     */
    public com.google.protobuf.ByteString getReferencingBackupsBytes(int index) {
      return referencingBackups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The referencingBackups to set.
     * @return This builder for chaining.
     */
    public Builder setReferencingBackups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingBackupsIsMutable();
      referencingBackups_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingBackups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReferencingBackupsIsMutable();
      referencingBackups_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addAllReferencingBackups(java.lang.Iterable<java.lang.String> values) {
      ensureReferencingBackupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referencingBackups_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReferencingBackups() {
      referencingBackups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of the destination backups being created by copying
     * this source backup. The backup names are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * Referencing backups may exist in different instances. The existence of
     * any referencing backup prevents the backup from being deleted. When the
     * copy operation is done (either successfully completed or cancelled or the
     * destination backup is deleted), the reference to the backup is removed.
     * </pre>
     *
     * <code>
     * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the referencingBackups to add.
     * @return This builder for chaining.
     */
    public Builder addReferencingBackupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReferencingBackupsIsMutable();
      referencingBackups_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp maxExpireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        maxExpireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the maxExpireTime field is set.
     */
    public boolean hasMaxExpireTime() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The maxExpireTime.
     */
    public com.google.protobuf.Timestamp getMaxExpireTime() {
      if (maxExpireTimeBuilder_ == null) {
        return maxExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : maxExpireTime_;
      } else {
        return maxExpireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaxExpireTime(com.google.protobuf.Timestamp value) {
      if (maxExpireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxExpireTime_ = value;
      } else {
        maxExpireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaxExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (maxExpireTimeBuilder_ == null) {
        maxExpireTime_ = builderForValue.build();
      } else {
        maxExpireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMaxExpireTime(com.google.protobuf.Timestamp value) {
      if (maxExpireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && maxExpireTime_ != null
            && maxExpireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getMaxExpireTimeBuilder().mergeFrom(value);
        } else {
          maxExpireTime_ = value;
        }
      } else {
        maxExpireTimeBuilder_.mergeFrom(value);
      }
      if (maxExpireTime_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMaxExpireTime() {
      bitField0_ = (bitField0_ & ~0x00004000);
      maxExpireTime_ = null;
      if (maxExpireTimeBuilder_ != null) {
        maxExpireTimeBuilder_.dispose();
        maxExpireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getMaxExpireTimeBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getMaxExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getMaxExpireTimeOrBuilder() {
      if (maxExpireTimeBuilder_ != null) {
        return maxExpireTimeBuilder_.getMessageOrBuilder();
      } else {
        return maxExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : maxExpireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The max allowed expiration time of the backup, with
     * microseconds granularity. A backup's expiration time can be configured in
     * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
     * copying an existing backup, the expiration time specified must be
     * less than `Backup.max_expire_time`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getMaxExpireTimeFieldBuilder() {
      if (maxExpireTimeBuilder_ == null) {
        maxExpireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getMaxExpireTime(), getParentForChildren(), isClean());
        maxExpireTime_ = null;
      }
      return maxExpireTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList backupSchedules_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBackupSchedulesIsMutable() {
      if (!backupSchedules_.isModifiable()) {
        backupSchedules_ = new com.google.protobuf.LazyStringArrayList(backupSchedules_);
      }
      bitField0_ |= 0x00008000;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the backupSchedules.
     */
    public com.google.protobuf.ProtocolStringList getBackupSchedulesList() {
      backupSchedules_.makeImmutable();
      return backupSchedules_;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of backupSchedules.
     */
    public int getBackupSchedulesCount() {
      return backupSchedules_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The backupSchedules at the given index.
     */
    public java.lang.String getBackupSchedules(int index) {
      return backupSchedules_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the backupSchedules at the given index.
     */
    public com.google.protobuf.ByteString getBackupSchedulesBytes(int index) {
      return backupSchedules_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The backupSchedules to set.
     * @return This builder for chaining.
     */
    public Builder setBackupSchedules(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBackupSchedulesIsMutable();
      backupSchedules_.set(index, value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The backupSchedules to add.
     * @return This builder for chaining.
     */
    public Builder addBackupSchedules(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBackupSchedulesIsMutable();
      backupSchedules_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The backupSchedules to add.
     * @return This builder for chaining.
     */
    public Builder addAllBackupSchedules(java.lang.Iterable<java.lang.String> values) {
      ensureBackupSchedulesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, backupSchedules_);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupSchedules() {
      backupSchedules_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00008000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of backup schedule URIs that are associated with
     * creating this backup. This is only applicable for scheduled backups, and
     * is empty for on-demand backups.
     *
     * To optimize for storage, whenever possible, multiple schedules are
     * collapsed together to create one backup. In such cases, this field captures
     * the list of all backup schedule URIs that are associated with creating
     * this backup. If collapsing is not done, then this field captures the
     * single backup schedule URI associated with creating this backup.
     * </pre>
     *
     * <code>
     * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the backupSchedules to add.
     * @return This builder for chaining.
     */
    public Builder addBackupSchedulesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBackupSchedulesIsMutable();
      backupSchedules_.add(value);
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object incrementalBackupChainId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Populated only for backups in an incremental backup chain.
     * Backups share the same chain id if and only if they belong to the same
     * incremental backup chain. Use this field to determine which backups are
     * part of the same incremental backup chain. The ordering of backups in the
     * chain can be determined by ordering the backup `version_time`.
     * </pre>
     *
     * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The incrementalBackupChainId.
     */
    public java.lang.String getIncrementalBackupChainId() {
      java.lang.Object ref = incrementalBackupChainId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        incrementalBackupChainId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated only for backups in an incremental backup chain.
     * Backups share the same chain id if and only if they belong to the same
     * incremental backup chain. Use this field to determine which backups are
     * part of the same incremental backup chain. The ordering of backups in the
     * chain can be determined by ordering the backup `version_time`.
     * </pre>
     *
     * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for incrementalBackupChainId.
     */
    public com.google.protobuf.ByteString getIncrementalBackupChainIdBytes() {
      java.lang.Object ref = incrementalBackupChainId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        incrementalBackupChainId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated only for backups in an incremental backup chain.
     * Backups share the same chain id if and only if they belong to the same
     * incremental backup chain. Use this field to determine which backups are
     * part of the same incremental backup chain. The ordering of backups in the
     * chain can be determined by ordering the backup `version_time`.
     * </pre>
     *
     * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The incrementalBackupChainId to set.
     * @return This builder for chaining.
     */
    public Builder setIncrementalBackupChainId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      incrementalBackupChainId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated only for backups in an incremental backup chain.
     * Backups share the same chain id if and only if they belong to the same
     * incremental backup chain. Use this field to determine which backups are
     * part of the same incremental backup chain. The ordering of backups in the
     * chain can be determined by ordering the backup `version_time`.
     * </pre>
     *
     * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncrementalBackupChainId() {
      incrementalBackupChainId_ = getDefaultInstance().getIncrementalBackupChainId();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Populated only for backups in an incremental backup chain.
     * Backups share the same chain id if and only if they belong to the same
     * incremental backup chain. Use this field to determine which backups are
     * part of the same incremental backup chain. The ordering of backups in the
     * chain can be determined by ordering the backup `version_time`.
     * </pre>
     *
     * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for incrementalBackupChainId to set.
     * @return This builder for chaining.
     */
    public Builder setIncrementalBackupChainIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      incrementalBackupChainId_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp oldestVersionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        oldestVersionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the oldestVersionTime field is set.
     */
    public boolean hasOldestVersionTime() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The oldestVersionTime.
     */
    public com.google.protobuf.Timestamp getOldestVersionTime() {
      if (oldestVersionTimeBuilder_ == null) {
        return oldestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : oldestVersionTime_;
      } else {
        return oldestVersionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOldestVersionTime(com.google.protobuf.Timestamp value) {
      if (oldestVersionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        oldestVersionTime_ = value;
      } else {
        oldestVersionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOldestVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (oldestVersionTimeBuilder_ == null) {
        oldestVersionTime_ = builderForValue.build();
      } else {
        oldestVersionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOldestVersionTime(com.google.protobuf.Timestamp value) {
      if (oldestVersionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && oldestVersionTime_ != null
            && oldestVersionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getOldestVersionTimeBuilder().mergeFrom(value);
        } else {
          oldestVersionTime_ = value;
        }
      } else {
        oldestVersionTimeBuilder_.mergeFrom(value);
      }
      if (oldestVersionTime_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOldestVersionTime() {
      bitField0_ = (bitField0_ & ~0x00020000);
      oldestVersionTime_ = null;
      if (oldestVersionTimeBuilder_ != null) {
        oldestVersionTimeBuilder_.dispose();
        oldestVersionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getOldestVersionTimeBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getOldestVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getOldestVersionTimeOrBuilder() {
      if (oldestVersionTimeBuilder_ != null) {
        return oldestVersionTimeBuilder_.getMessageOrBuilder();
      } else {
        return oldestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : oldestVersionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Data deleted at a time older than this is guaranteed not to be
     * retained in order to support this backup. For a backup in an incremental
     * backup chain, this is the version time of the oldest backup that exists or
     * ever existed in the chain. For all other backups, this is the version time
     * of the backup. This field can be used to understand what data is being
     * retained by the backup system.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getOldestVersionTimeFieldBuilder() {
      if (oldestVersionTimeBuilder_ == null) {
        oldestVersionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getOldestVersionTime(), getParentForChildren(), isClean());
        oldestVersionTime_ = null;
      }
      return oldestVersionTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.Backup)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.Backup)
  private static final com.google.spanner.admin.database.v1.Backup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.Backup();
  }

  public static com.google.spanner.admin.database.v1.Backup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Backup> PARSER =
      new com.google.protobuf.AbstractParser<Backup>() {
        @java.lang.Override
        public Backup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Backup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Backup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.Backup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
