/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

// Protobuf Java Version: 3.25.5
package com.google.spanner.admin.database.v1;

public interface BackupOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.spanner.admin.database.v1.Backup)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Name of the database from which this backup was created. This
   * needs to be in the same instance as the backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  java.lang.String getDatabase();
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Name of the database from which this backup was created. This
   * needs to be in the same instance as the backup. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * </pre>
   *
   * <code>string database = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  com.google.protobuf.ByteString getDatabaseBytes();

  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   *
   * @return Whether the versionTime field is set.
   */
  boolean hasVersionTime();
  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   *
   * @return The versionTime.
   */
  com.google.protobuf.Timestamp getVersionTime();
  /**
   *
   *
   * <pre>
   * The backup will contain an externally consistent copy of the database at
   * the timestamp specified by `version_time`. If `version_time` is not
   * specified, the system will set `version_time` to the `create_time` of the
   * backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp version_time = 9;</code>
   */
  com.google.protobuf.TimestampOrBuilder getVersionTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   *
   * @return Whether the expireTime field is set.
   */
  boolean hasExpireTime();
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   *
   * @return The expireTime.
   */
  com.google.protobuf.Timestamp getExpireTime();
  /**
   *
   *
   * <pre>
   * Required for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. The expiration time of the backup, with microseconds
   * granularity that must be at least 6 hours and at most 366 days
   * from the time the CreateBackup request is processed. Once the `expire_time`
   * has passed, the backup is eligible to be automatically deleted by Cloud
   * Spanner to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 3;</code>
   */
  com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Required for the
   * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
   * operation.
   *
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters
   * in length.
   *
   * The backup is stored in the location(s) specified in the instance
   * configuration of the instance containing the backup, identified
   * by the prefix of the backup name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only for the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * operation. Required for the
   * [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
   * operation.
   *
   * A globally unique identifier for the backup which cannot be
   * changed. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/[a-z][a-z0-9_&#92;-]*[a-z0-9]`
   * The final segment of the name must be between 2 and 60 characters
   * in length.
   *
   * The backup is stored in the location(s) specified in the instance
   * configuration of the instance containing the backup, identified
   * by the prefix of the backup name of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the
   * [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
   * request is received. If the request does not specify `version_time`, the
   * `version_time` of the backup will be equivalent to the `create_time`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Size of the backup in bytes.
   * </pre>
   *
   * <code>int64 size_bytes = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The sizeBytes.
   */
  long getSizeBytes();

  /**
   *
   *
   * <pre>
   * Output only. The number of bytes that will be freed by deleting this
   * backup. This value will be zero if, for example, this backup is part of an
   * incremental backup chain and younger backups in the chain require that we
   * keep its data. For backups not in an incremental backup chain, this is
   * always the size of the backup. This value may change if backups on the same
   * chain get created, deleted or expired.
   * </pre>
   *
   * <code>int64 freeable_size_bytes = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The freeableSizeBytes.
   */
  long getFreeableSizeBytes();

  /**
   *
   *
   * <pre>
   * Output only. For a backup in an incremental backup chain, this is the
   * storage space needed to keep the data that has changed since the previous
   * backup. For all other backups, this is always the size of the backup. This
   * value may change if backups on the same chain get deleted or expired.
   *
   * This field can be used to calculate the total storage space used by a set
   * of backups. For example, the total space used by all backups of a database
   * can be computed by summing up this field.
   * </pre>
   *
   * <code>int64 exclusive_size_bytes = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The exclusiveSizeBytes.
   */
  long getExclusiveSizeBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state of the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Backup.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.spanner.admin.database.v1.Backup.State getState();

  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencingDatabases.
   */
  java.util.List<java.lang.String> getReferencingDatabasesList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencingDatabases.
   */
  int getReferencingDatabasesCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingDatabases at the given index.
   */
  java.lang.String getReferencingDatabases(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of the restored databases that reference the backup.
   * The database names are of
   * the form `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`.
   * Referencing databases may exist in different instances. The existence of
   * any referencing database prevents the backup from being deleted. When a
   * restored database from the backup enters the `READY` state, the reference
   * to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_databases = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingDatabases at the given index.
   */
  com.google.protobuf.ByteString getReferencingDatabasesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionInfo field is set.
   */
  boolean hasEncryptionInfo();
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionInfo.
   */
  com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo();
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
      getEncryptionInformationList();
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInformation(int index);
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getEncryptionInformationCount();
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
      getEncryptionInformationOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. The encryption information for the backup, whether it is
   * protected by one or more KMS keys. The information includes all Cloud
   * KMS key versions used to encrypt the backup. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated. At least one of the key
   * versions must be available for the backup to be restored. If a key version
   * is revoked in the middle of a restore, the restore behavior is undefined.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_information = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInformationOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. The database dialect information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  int getDatabaseDialectValue();
  /**
   *
   *
   * <pre>
   * Output only. The database dialect information for the backup.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The databaseDialect.
   */
  com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect();

  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the referencingBackups.
   */
  java.util.List<java.lang.String> getReferencingBackupsList();
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of referencingBackups.
   */
  int getReferencingBackupsCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The referencingBackups at the given index.
   */
  java.lang.String getReferencingBackups(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of the destination backups being created by copying
   * this source backup. The backup names are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * Referencing backups may exist in different instances. The existence of
   * any referencing backup prevents the backup from being deleted. When the
   * copy operation is done (either successfully completed or cancelled or the
   * destination backup is deleted), the reference to the backup is removed.
   * </pre>
   *
   * <code>
   * repeated string referencing_backups = 11 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the referencingBackups at the given index.
   */
  com.google.protobuf.ByteString getReferencingBackupsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the maxExpireTime field is set.
   */
  boolean hasMaxExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The maxExpireTime.
   */
  com.google.protobuf.Timestamp getMaxExpireTime();
  /**
   *
   *
   * <pre>
   * Output only. The max allowed expiration time of the backup, with
   * microseconds granularity. A backup's expiration time can be configured in
   * multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
   * copying an existing backup, the expiration time specified must be
   * less than `Backup.max_expire_time`.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp max_expire_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getMaxExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the backupSchedules.
   */
  java.util.List<java.lang.String> getBackupSchedulesList();
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of backupSchedules.
   */
  int getBackupSchedulesCount();
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The backupSchedules at the given index.
   */
  java.lang.String getBackupSchedules(int index);
  /**
   *
   *
   * <pre>
   * Output only. List of backup schedule URIs that are associated with
   * creating this backup. This is only applicable for scheduled backups, and
   * is empty for on-demand backups.
   *
   * To optimize for storage, whenever possible, multiple schedules are
   * collapsed together to create one backup. In such cases, this field captures
   * the list of all backup schedule URIs that are associated with creating
   * this backup. If collapsing is not done, then this field captures the
   * single backup schedule URI associated with creating this backup.
   * </pre>
   *
   * <code>
   * repeated string backup_schedules = 14 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the backupSchedules at the given index.
   */
  com.google.protobuf.ByteString getBackupSchedulesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Populated only for backups in an incremental backup chain.
   * Backups share the same chain id if and only if they belong to the same
   * incremental backup chain. Use this field to determine which backups are
   * part of the same incremental backup chain. The ordering of backups in the
   * chain can be determined by ordering the backup `version_time`.
   * </pre>
   *
   * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The incrementalBackupChainId.
   */
  java.lang.String getIncrementalBackupChainId();
  /**
   *
   *
   * <pre>
   * Output only. Populated only for backups in an incremental backup chain.
   * Backups share the same chain id if and only if they belong to the same
   * incremental backup chain. Use this field to determine which backups are
   * part of the same incremental backup chain. The ordering of backups in the
   * chain can be determined by ordering the backup `version_time`.
   * </pre>
   *
   * <code>string incremental_backup_chain_id = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for incrementalBackupChainId.
   */
  com.google.protobuf.ByteString getIncrementalBackupChainIdBytes();

  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the oldestVersionTime field is set.
   */
  boolean hasOldestVersionTime();
  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The oldestVersionTime.
   */
  com.google.protobuf.Timestamp getOldestVersionTime();
  /**
   *
   *
   * <pre>
   * Output only. Data deleted at a time older than this is guaranteed not to be
   * retained in order to support this backup. For a backup in an incremental
   * backup chain, this is the version time of the oldest backup that exists or
   * ever existed in the chain. For all other backups, this is the version time
   * of the backup. This field can be used to understand what data is being
   * retained by the backup system.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp oldest_version_time = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getOldestVersionTimeOrBuilder();
}
