/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.5
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * A Cloud Spanner database.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.Database}
 */
public final class Database extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.Database)
    DatabaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Database.newBuilder() to construct.
  private Database(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Database() {
    name_ = "";
    state_ = 0;
    encryptionInfo_ = java.util.Collections.emptyList();
    versionRetentionPeriod_ = "";
    defaultLeader_ = "";
    databaseDialect_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Database();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_Database_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.Database.class,
            com.google.spanner.admin.database.v1.Database.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the current state of the database.
   * </pre>
   *
   * Protobuf enum {@code google.spanner.admin.database.v1.Database.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The database is still being created. Operations on the database may fail
     * with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use, but is still
     * being optimized for performance and cannot handle full load.
     *
     * In this state, the database still references the backup
     * it was restore from, preventing the backup
     * from being deleted. When optimizations are complete, the full performance
     * of the database will be restored, and the database will transition to
     * `READY` state.
     * </pre>
     *
     * <code>READY_OPTIMIZING = 3;</code>
     */
    READY_OPTIMIZING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The database is still being created. Operations on the database may fail
     * with `FAILED_PRECONDITION` in this state.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The database is fully created and ready for use, but is still
     * being optimized for performance and cannot handle full load.
     *
     * In this state, the database still references the backup
     * it was restore from, preventing the backup
     * from being deleted. When optimizations are complete, the full performance
     * of the database will be restored, and the database will transition to
     * `READY` state.
     * </pre>
     *
     * <code>READY_OPTIMIZING = 3;</code>
     */
    public static final int READY_OPTIMIZING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return READY_OPTIMIZING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.Database.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.spanner.admin.database.v1.Database.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the database. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
   * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
   * statement. This name can be passed to other API methods to
   * identify the database.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current database state.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database.State getState() {
    com.google.spanner.admin.database.v1.Database.State result =
        com.google.spanner.admin.database.v1.Database.State.forNumber(state_);
    return result == null
        ? com.google.spanner.admin.database.v1.Database.State.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If exists, the time at which the database creation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int RESTORE_INFO_FIELD_NUMBER = 4;
  private com.google.spanner.admin.database.v1.RestoreInfo restoreInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the restoreInfo field is set.
   */
  @java.lang.Override
  public boolean hasRestoreInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The restoreInfo.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreInfo getRestoreInfo() {
    return restoreInfo_ == null
        ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
        : restoreInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Applicable only for restored databases. Contains information
   * about the restore source.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
    return restoreInfo_ == null
        ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
        : restoreInfo_;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 5;
  private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption configuration for the database.
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  public static final int ENCRYPTION_INFO_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo> encryptionInfo_;
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
      getEncryptionInfoList() {
    return encryptionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
      getEncryptionInfoOrBuilderList() {
    return encryptionInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getEncryptionInfoCount() {
    return encryptionInfo_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo(int index) {
    return encryptionInfo_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. For databases that are using customer managed encryption, this
   * field contains the encryption information for the database, such as
   * all Cloud KMS key versions that are in use. The `encryption_status' field
   * inside of each `EncryptionInfo` is not populated.
   *
   * For databases that are using Google default or other types of encryption,
   * this field is empty.
   *
   * This field is propagated lazily from the backend. There might be a delay
   * from when a key version is being used and when it appears in this field.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(
      int index) {
    return encryptionInfo_.get(index);
  }

  public static final int VERSION_RETENTION_PERIOD_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionRetentionPeriod_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * Defaults to 1 hour, if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The versionRetentionPeriod.
   */
  @java.lang.Override
  public java.lang.String getVersionRetentionPeriod() {
    java.lang.Object ref = versionRetentionPeriod_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionRetentionPeriod_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The period in which Cloud Spanner retains all versions of data
   * for the database. This is the same as the value of version_retention_period
   * database option set using
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * Defaults to 1 hour, if not set.
   * </pre>
   *
   * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for versionRetentionPeriod.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionRetentionPeriodBytes() {
    java.lang.Object ref = versionRetentionPeriod_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionRetentionPeriod_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EARLIEST_VERSION_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp earliestVersionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestVersionTime field is set.
   */
  @java.lang.Override
  public boolean hasEarliestVersionTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestVersionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEarliestVersionTime() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest timestamp at which older versions of the data can be
   * read. This value is continuously updated by Cloud Spanner and becomes stale
   * the moment it is queried. If you are using this value to recover data, make
   * sure to account for the time from the moment when the value is queried to
   * the moment when you initiate the recovery.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
    return earliestVersionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestVersionTime_;
  }

  public static final int DEFAULT_LEADER_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultLeader_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The read-write region which contains the database's leader
   * replicas.
   *
   * This is the same as the value of default_leader
   * database option set using DatabaseAdmin.CreateDatabase or
   * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
   * </pre>
   *
   * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The defaultLeader.
   */
  @java.lang.Override
  public java.lang.String getDefaultLeader() {
    java.lang.Object ref = defaultLeader_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLeader_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The read-write region which contains the database's leader
   * replicas.
   *
   * This is the same as the value of default_leader
   * database option set using DatabaseAdmin.CreateDatabase or
   * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
   * </pre>
   *
   * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for defaultLeader.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultLeaderBytes() {
    java.lang.Object ref = defaultLeader_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLeader_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_DIALECT_FIELD_NUMBER = 10;
  private int databaseDialect_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for databaseDialect.
   */
  @java.lang.Override
  public int getDatabaseDialectValue() {
    return databaseDialect_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The dialect of the Cloud Spanner Database.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The databaseDialect.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
    com.google.spanner.admin.database.v1.DatabaseDialect result =
        com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
    return result == null
        ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
        : result;
  }

  public static final int ENABLE_DROP_PROTECTION_FIELD_NUMBER = 11;
  private boolean enableDropProtection_ = false;
  /**
   *
   *
   * <pre>
   * Whether drop protection is enabled for this database. Defaults to false,
   * if not set. For more details, please see how to [prevent accidental
   * database
   * deletion](https://cloud.google.com/spanner/docs/prevent-database-deletion).
   * </pre>
   *
   * <code>bool enable_drop_protection = 11;</code>
   *
   * @return The enableDropProtection.
   */
  @java.lang.Override
  public boolean getEnableDropProtection() {
    return enableDropProtection_;
  }

  public static final int RECONCILING_FIELD_NUMBER = 12;
  private boolean reconciling_ = false;
  /**
   *
   *
   * <pre>
   * Output only. If true, the database is being updated. If false, there are no
   * ongoing update operations for the database.
   * </pre>
   *
   * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The reconciling.
   */
  @java.lang.Override
  public boolean getReconciling() {
    return reconciling_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (state_
        != com.google.spanner.admin.database.v1.Database.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getRestoreInfo());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEncryptionConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionRetentionPeriod_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, versionRetentionPeriod_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getEarliestVersionTime());
    }
    for (int i = 0; i < encryptionInfo_.size(); i++) {
      output.writeMessage(8, encryptionInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLeader_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, defaultLeader_);
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, databaseDialect_);
    }
    if (enableDropProtection_ != false) {
      output.writeBool(11, enableDropProtection_);
    }
    if (reconciling_ != false) {
      output.writeBool(12, reconciling_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (state_
        != com.google.spanner.admin.database.v1.Database.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRestoreInfo());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEncryptionConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionRetentionPeriod_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, versionRetentionPeriod_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEarliestVersionTime());
    }
    for (int i = 0; i < encryptionInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, encryptionInfo_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLeader_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, defaultLeader_);
    }
    if (databaseDialect_
        != com.google.spanner.admin.database.v1.DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, databaseDialect_);
    }
    if (enableDropProtection_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableDropProtection_);
    }
    if (reconciling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, reconciling_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.Database)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.Database other =
        (com.google.spanner.admin.database.v1.Database) obj;

    if (!getName().equals(other.getName())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRestoreInfo() != other.hasRestoreInfo()) return false;
    if (hasRestoreInfo()) {
      if (!getRestoreInfo().equals(other.getRestoreInfo())) return false;
    }
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getEncryptionInfoList().equals(other.getEncryptionInfoList())) return false;
    if (!getVersionRetentionPeriod().equals(other.getVersionRetentionPeriod())) return false;
    if (hasEarliestVersionTime() != other.hasEarliestVersionTime()) return false;
    if (hasEarliestVersionTime()) {
      if (!getEarliestVersionTime().equals(other.getEarliestVersionTime())) return false;
    }
    if (!getDefaultLeader().equals(other.getDefaultLeader())) return false;
    if (databaseDialect_ != other.databaseDialect_) return false;
    if (getEnableDropProtection() != other.getEnableDropProtection()) return false;
    if (getReconciling() != other.getReconciling()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRestoreInfo()) {
      hash = (37 * hash) + RESTORE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getRestoreInfo().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    if (getEncryptionInfoCount() > 0) {
      hash = (37 * hash) + ENCRYPTION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionInfoList().hashCode();
    }
    hash = (37 * hash) + VERSION_RETENTION_PERIOD_FIELD_NUMBER;
    hash = (53 * hash) + getVersionRetentionPeriod().hashCode();
    if (hasEarliestVersionTime()) {
      hash = (37 * hash) + EARLIEST_VERSION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEarliestVersionTime().hashCode();
    }
    hash = (37 * hash) + DEFAULT_LEADER_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLeader().hashCode();
    hash = (37 * hash) + DATABASE_DIALECT_FIELD_NUMBER;
    hash = (53 * hash) + databaseDialect_;
    hash = (37 * hash) + ENABLE_DROP_PROTECTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDropProtection());
    hash = (37 * hash) + RECONCILING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReconciling());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.Database parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.admin.database.v1.Database prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Cloud Spanner database.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.Database}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.Database)
      com.google.spanner.admin.database.v1.DatabaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.Database.class,
              com.google.spanner.admin.database.v1.Database.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.Database.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getRestoreInfoFieldBuilder();
        getEncryptionConfigFieldBuilder();
        getEncryptionInfoFieldBuilder();
        getEarliestVersionTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      state_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      restoreInfo_ = null;
      if (restoreInfoBuilder_ != null) {
        restoreInfoBuilder_.dispose();
        restoreInfoBuilder_ = null;
      }
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = java.util.Collections.emptyList();
      } else {
        encryptionInfo_ = null;
        encryptionInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      versionRetentionPeriod_ = "";
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      defaultLeader_ = "";
      databaseDialect_ = 0;
      enableDropProtection_ = false;
      reconciling_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_Database_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.Database.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database build() {
      com.google.spanner.admin.database.v1.Database result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database buildPartial() {
      com.google.spanner.admin.database.v1.Database result =
          new com.google.spanner.admin.database.v1.Database(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.admin.database.v1.Database result) {
      if (encryptionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          encryptionInfo_ = java.util.Collections.unmodifiableList(encryptionInfo_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.encryptionInfo_ = encryptionInfo_;
      } else {
        result.encryptionInfo_ = encryptionInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.Database result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.restoreInfo_ =
            restoreInfoBuilder_ == null ? restoreInfo_ : restoreInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.versionRetentionPeriod_ = versionRetentionPeriod_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.earliestVersionTime_ =
            earliestVersionTimeBuilder_ == null
                ? earliestVersionTime_
                : earliestVersionTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.defaultLeader_ = defaultLeader_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.databaseDialect_ = databaseDialect_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.enableDropProtection_ = enableDropProtection_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.reconciling_ = reconciling_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.Database) {
        return mergeFrom((com.google.spanner.admin.database.v1.Database) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.Database other) {
      if (other == com.google.spanner.admin.database.v1.Database.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRestoreInfo()) {
        mergeRestoreInfo(other.getRestoreInfo());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      if (encryptionInfoBuilder_ == null) {
        if (!other.encryptionInfo_.isEmpty()) {
          if (encryptionInfo_.isEmpty()) {
            encryptionInfo_ = other.encryptionInfo_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureEncryptionInfoIsMutable();
            encryptionInfo_.addAll(other.encryptionInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.encryptionInfo_.isEmpty()) {
          if (encryptionInfoBuilder_.isEmpty()) {
            encryptionInfoBuilder_.dispose();
            encryptionInfoBuilder_ = null;
            encryptionInfo_ = other.encryptionInfo_;
            bitField0_ = (bitField0_ & ~0x00000020);
            encryptionInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEncryptionInfoFieldBuilder()
                    : null;
          } else {
            encryptionInfoBuilder_.addAllMessages(other.encryptionInfo_);
          }
        }
      }
      if (!other.getVersionRetentionPeriod().isEmpty()) {
        versionRetentionPeriod_ = other.versionRetentionPeriod_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasEarliestVersionTime()) {
        mergeEarliestVersionTime(other.getEarliestVersionTime());
      }
      if (!other.getDefaultLeader().isEmpty()) {
        defaultLeader_ = other.defaultLeader_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.databaseDialect_ != 0) {
        setDatabaseDialectValue(other.getDatabaseDialectValue());
      }
      if (other.getEnableDropProtection() != false) {
        setEnableDropProtection(other.getEnableDropProtection());
      }
      if (other.getReconciling() != false) {
        setReconciling(other.getReconciling());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRestoreInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                versionRetentionPeriod_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getEarliestVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                com.google.spanner.admin.database.v1.EncryptionInfo m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.EncryptionInfo.parser(),
                        extensionRegistry);
                if (encryptionInfoBuilder_ == null) {
                  ensureEncryptionInfoIsMutable();
                  encryptionInfo_.add(m);
                } else {
                  encryptionInfoBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                defaultLeader_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                databaseDialect_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                enableDropProtection_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            case 96:
              {
                reconciling_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the database. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/databases/&lt;database&gt;`,
     * where `&lt;database&gt;` is as specified in the `CREATE DATABASE`
     * statement. This name can be passed to other API methods to
     * identify the database.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.Database.State getState() {
      com.google.spanner.admin.database.v1.Database.State result =
          com.google.spanner.admin.database.v1.Database.State.forNumber(state_);
      return result == null
          ? com.google.spanner.admin.database.v1.Database.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.spanner.admin.database.v1.Database.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current database state.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.Database.State state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If exists, the time at which the database creation started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.spanner.admin.database.v1.RestoreInfo restoreInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreInfo,
            com.google.spanner.admin.database.v1.RestoreInfo.Builder,
            com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>
        restoreInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the restoreInfo field is set.
     */
    public boolean hasRestoreInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The restoreInfo.
     */
    public com.google.spanner.admin.database.v1.RestoreInfo getRestoreInfo() {
      if (restoreInfoBuilder_ == null) {
        return restoreInfo_ == null
            ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      } else {
        return restoreInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(com.google.spanner.admin.database.v1.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        restoreInfo_ = value;
      } else {
        restoreInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRestoreInfo(
        com.google.spanner.admin.database.v1.RestoreInfo.Builder builderForValue) {
      if (restoreInfoBuilder_ == null) {
        restoreInfo_ = builderForValue.build();
      } else {
        restoreInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRestoreInfo(com.google.spanner.admin.database.v1.RestoreInfo value) {
      if (restoreInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && restoreInfo_ != null
            && restoreInfo_
                != com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()) {
          getRestoreInfoBuilder().mergeFrom(value);
        } else {
          restoreInfo_ = value;
        }
      } else {
        restoreInfoBuilder_.mergeFrom(value);
      }
      if (restoreInfo_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRestoreInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      restoreInfo_ = null;
      if (restoreInfoBuilder_ != null) {
        restoreInfoBuilder_.dispose();
        restoreInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreInfo.Builder getRestoreInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRestoreInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
      if (restoreInfoBuilder_ != null) {
        return restoreInfoBuilder_.getMessageOrBuilder();
      } else {
        return restoreInfo_ == null
            ? com.google.spanner.admin.database.v1.RestoreInfo.getDefaultInstance()
            : restoreInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Applicable only for restored databases. Contains information
     * about the restore source.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.RestoreInfo restore_info = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.RestoreInfo,
            com.google.spanner.admin.database.v1.RestoreInfo.Builder,
            com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>
        getRestoreInfoFieldBuilder() {
      if (restoreInfoBuilder_ == null) {
        restoreInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.RestoreInfo,
                com.google.spanner.admin.database.v1.RestoreInfo.Builder,
                com.google.spanner.admin.database.v1.RestoreInfoOrBuilder>(
                getRestoreInfo(), getParentForChildren(), isClean());
        restoreInfo_ = null;
      }
      return restoreInfoBuilder_;
    }

    private com.google.spanner.admin.database.v1.EncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.EncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.EncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption configuration for the database.
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionConfig,
            com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionConfig,
                com.google.spanner.admin.database.v1.EncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    private java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo> encryptionInfo_ =
        java.util.Collections.emptyList();

    private void ensureEncryptionInfoIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        encryptionInfo_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.EncryptionInfo>(
                encryptionInfo_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        encryptionInfoBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo>
        getEncryptionInfoList() {
      if (encryptionInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(encryptionInfo_);
      } else {
        return encryptionInfoBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getEncryptionInfoCount() {
      if (encryptionInfoBuilder_ == null) {
        return encryptionInfo_.size();
      } else {
        return encryptionInfoBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo getEncryptionInfo(int index) {
      if (encryptionInfoBuilder_ == null) {
        return encryptionInfo_.get(index);
      } else {
        return encryptionInfoBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.set(index, value);
        onChanged();
      } else {
        encryptionInfoBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEncryptionInfo(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInfoBuilder_ == null) {
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        encryptionInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInfo(com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.add(value);
        onChanged();
      } else {
        encryptionInfoBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInfo(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo value) {
      if (encryptionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.add(index, value);
        onChanged();
      } else {
        encryptionInfoBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInfo(
        com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInfoBuilder_ == null) {
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.add(builderForValue.build());
        onChanged();
      } else {
        encryptionInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addEncryptionInfo(
        int index, com.google.spanner.admin.database.v1.EncryptionInfo.Builder builderForValue) {
      if (encryptionInfoBuilder_ == null) {
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        encryptionInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllEncryptionInfo(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.EncryptionInfo> values) {
      if (encryptionInfoBuilder_ == null) {
        ensureEncryptionInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, encryptionInfo_);
        onChanged();
      } else {
        encryptionInfoBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEncryptionInfo() {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        encryptionInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeEncryptionInfo(int index) {
      if (encryptionInfoBuilder_ == null) {
        ensureEncryptionInfoIsMutable();
        encryptionInfo_.remove(index);
        onChanged();
      } else {
        encryptionInfoBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder getEncryptionInfoBuilder(
        int index) {
      return getEncryptionInfoFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(
        int index) {
      if (encryptionInfoBuilder_ == null) {
        return encryptionInfo_.get(index);
      } else {
        return encryptionInfoBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        getEncryptionInfoOrBuilderList() {
      if (encryptionInfoBuilder_ != null) {
        return encryptionInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(encryptionInfo_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder addEncryptionInfoBuilder() {
      return getEncryptionInfoFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.spanner.admin.database.v1.EncryptionInfo.Builder addEncryptionInfoBuilder(
        int index) {
      return getEncryptionInfoFieldBuilder()
          .addBuilder(
              index, com.google.spanner.admin.database.v1.EncryptionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. For databases that are using customer managed encryption, this
     * field contains the encryption information for the database, such as
     * all Cloud KMS key versions that are in use. The `encryption_status' field
     * inside of each `EncryptionInfo` is not populated.
     *
     * For databases that are using Google default or other types of encryption,
     * this field is empty.
     *
     * This field is propagated lazily from the backend. There might be a delay
     * from when a key version is being used and when it appears in this field.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.database.v1.EncryptionInfo encryption_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.EncryptionInfo.Builder>
        getEncryptionInfoBuilderList() {
      return getEncryptionInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.EncryptionInfo,
            com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
            com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>
        getEncryptionInfoFieldBuilder() {
      if (encryptionInfoBuilder_ == null) {
        encryptionInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.EncryptionInfo,
                com.google.spanner.admin.database.v1.EncryptionInfo.Builder,
                com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder>(
                encryptionInfo_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        encryptionInfo_ = null;
      }
      return encryptionInfoBuilder_;
    }

    private java.lang.Object versionRetentionPeriod_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
     * Defaults to 1 hour, if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The versionRetentionPeriod.
     */
    public java.lang.String getVersionRetentionPeriod() {
      java.lang.Object ref = versionRetentionPeriod_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionRetentionPeriod_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
     * Defaults to 1 hour, if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for versionRetentionPeriod.
     */
    public com.google.protobuf.ByteString getVersionRetentionPeriodBytes() {
      java.lang.Object ref = versionRetentionPeriod_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionRetentionPeriod_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
     * Defaults to 1 hour, if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The versionRetentionPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setVersionRetentionPeriod(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionRetentionPeriod_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
     * Defaults to 1 hour, if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionRetentionPeriod() {
      versionRetentionPeriod_ = getDefaultInstance().getVersionRetentionPeriod();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The period in which Cloud Spanner retains all versions of data
     * for the database. This is the same as the value of version_retention_period
     * database option set using
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
     * Defaults to 1 hour, if not set.
     * </pre>
     *
     * <code>string version_retention_period = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for versionRetentionPeriod to set.
     * @return This builder for chaining.
     */
    public Builder setVersionRetentionPeriodBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionRetentionPeriod_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp earliestVersionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        earliestVersionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the earliestVersionTime field is set.
     */
    public boolean hasEarliestVersionTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The earliestVersionTime.
     */
    public com.google.protobuf.Timestamp getEarliestVersionTime() {
      if (earliestVersionTimeBuilder_ == null) {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      } else {
        return earliestVersionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        earliestVersionTime_ = value;
      } else {
        earliestVersionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestVersionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTime_ = builderForValue.build();
      } else {
        earliestVersionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEarliestVersionTime(com.google.protobuf.Timestamp value) {
      if (earliestVersionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && earliestVersionTime_ != null
            && earliestVersionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEarliestVersionTimeBuilder().mergeFrom(value);
        } else {
          earliestVersionTime_ = value;
        }
      } else {
        earliestVersionTimeBuilder_.mergeFrom(value);
      }
      if (earliestVersionTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEarliestVersionTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      earliestVersionTime_ = null;
      if (earliestVersionTimeBuilder_ != null) {
        earliestVersionTimeBuilder_.dispose();
        earliestVersionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEarliestVersionTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEarliestVersionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
      if (earliestVersionTimeBuilder_ != null) {
        return earliestVersionTimeBuilder_.getMessageOrBuilder();
      } else {
        return earliestVersionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestVersionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest timestamp at which older versions of the data can be
     * read. This value is continuously updated by Cloud Spanner and becomes stale
     * the moment it is queried. If you are using this value to recover data, make
     * sure to account for the time from the moment when the value is queried to
     * the moment when you initiate the recovery.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_version_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEarliestVersionTimeFieldBuilder() {
      if (earliestVersionTimeBuilder_ == null) {
        earliestVersionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEarliestVersionTime(), getParentForChildren(), isClean());
        earliestVersionTime_ = null;
      }
      return earliestVersionTimeBuilder_;
    }

    private java.lang.Object defaultLeader_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The read-write region which contains the database's leader
     * replicas.
     *
     * This is the same as the value of default_leader
     * database option set using DatabaseAdmin.CreateDatabase or
     * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
     * </pre>
     *
     * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The defaultLeader.
     */
    public java.lang.String getDefaultLeader() {
      java.lang.Object ref = defaultLeader_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLeader_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The read-write region which contains the database's leader
     * replicas.
     *
     * This is the same as the value of default_leader
     * database option set using DatabaseAdmin.CreateDatabase or
     * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
     * </pre>
     *
     * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for defaultLeader.
     */
    public com.google.protobuf.ByteString getDefaultLeaderBytes() {
      java.lang.Object ref = defaultLeader_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLeader_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The read-write region which contains the database's leader
     * replicas.
     *
     * This is the same as the value of default_leader
     * database option set using DatabaseAdmin.CreateDatabase or
     * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
     * </pre>
     *
     * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The defaultLeader to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLeader(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultLeader_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The read-write region which contains the database's leader
     * replicas.
     *
     * This is the same as the value of default_leader
     * database option set using DatabaseAdmin.CreateDatabase or
     * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
     * </pre>
     *
     * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLeader() {
      defaultLeader_ = getDefaultInstance().getDefaultLeader();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The read-write region which contains the database's leader
     * replicas.
     *
     * This is the same as the value of default_leader
     * database option set using DatabaseAdmin.CreateDatabase or
     * DatabaseAdmin.UpdateDatabaseDdl. If not explicitly set, this is empty.
     * </pre>
     *
     * <code>string default_leader = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for defaultLeader to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLeaderBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultLeader_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private int databaseDialect_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for databaseDialect.
     */
    @java.lang.Override
    public int getDatabaseDialectValue() {
      return databaseDialect_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialectValue(int value) {
      databaseDialect_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The databaseDialect.
     */
    @java.lang.Override
    public com.google.spanner.admin.database.v1.DatabaseDialect getDatabaseDialect() {
      com.google.spanner.admin.database.v1.DatabaseDialect result =
          com.google.spanner.admin.database.v1.DatabaseDialect.forNumber(databaseDialect_);
      return result == null
          ? com.google.spanner.admin.database.v1.DatabaseDialect.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The databaseDialect to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseDialect(com.google.spanner.admin.database.v1.DatabaseDialect value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      databaseDialect_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The dialect of the Cloud Spanner Database.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.DatabaseDialect database_dialect = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseDialect() {
      bitField0_ = (bitField0_ & ~0x00000200);
      databaseDialect_ = 0;
      onChanged();
      return this;
    }

    private boolean enableDropProtection_;
    /**
     *
     *
     * <pre>
     * Whether drop protection is enabled for this database. Defaults to false,
     * if not set. For more details, please see how to [prevent accidental
     * database
     * deletion](https://cloud.google.com/spanner/docs/prevent-database-deletion).
     * </pre>
     *
     * <code>bool enable_drop_protection = 11;</code>
     *
     * @return The enableDropProtection.
     */
    @java.lang.Override
    public boolean getEnableDropProtection() {
      return enableDropProtection_;
    }
    /**
     *
     *
     * <pre>
     * Whether drop protection is enabled for this database. Defaults to false,
     * if not set. For more details, please see how to [prevent accidental
     * database
     * deletion](https://cloud.google.com/spanner/docs/prevent-database-deletion).
     * </pre>
     *
     * <code>bool enable_drop_protection = 11;</code>
     *
     * @param value The enableDropProtection to set.
     * @return This builder for chaining.
     */
    public Builder setEnableDropProtection(boolean value) {

      enableDropProtection_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether drop protection is enabled for this database. Defaults to false,
     * if not set. For more details, please see how to [prevent accidental
     * database
     * deletion](https://cloud.google.com/spanner/docs/prevent-database-deletion).
     * </pre>
     *
     * <code>bool enable_drop_protection = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableDropProtection() {
      bitField0_ = (bitField0_ & ~0x00000400);
      enableDropProtection_ = false;
      onChanged();
      return this;
    }

    private boolean reconciling_;
    /**
     *
     *
     * <pre>
     * Output only. If true, the database is being updated. If false, there are no
     * ongoing update operations for the database.
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The reconciling.
     */
    @java.lang.Override
    public boolean getReconciling() {
      return reconciling_;
    }
    /**
     *
     *
     * <pre>
     * Output only. If true, the database is being updated. If false, there are no
     * ongoing update operations for the database.
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The reconciling to set.
     * @return This builder for chaining.
     */
    public Builder setReconciling(boolean value) {

      reconciling_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If true, the database is being updated. If false, there are no
     * ongoing update operations for the database.
     * </pre>
     *
     * <code>bool reconciling = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReconciling() {
      bitField0_ = (bitField0_ & ~0x00000800);
      reconciling_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.Database)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.Database)
  private static final com.google.spanner.admin.database.v1.Database DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.Database();
  }

  public static com.google.spanner.admin.database.v1.Database getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Database> PARSER =
      new com.google.protobuf.AbstractParser<Database>() {
        @java.lang.Override
        public Database parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Database> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Database> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.Database getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
