/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/spanner_database_admin.proto

// Protobuf Java Version: 3.25.5
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * Metadata type for the operation returned by
 * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata}
 */
public final class UpdateDatabaseDdlMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
    UpdateDatabaseDdlMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateDatabaseDdlMetadata.newBuilder() to construct.
  private UpdateDatabaseDdlMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateDatabaseDdlMetadata() {
    database_ = "";
    statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
    commitTimestamps_ = java.util.Collections.emptyList();
    progress_ = java.util.Collections.emptyList();
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateDatabaseDdlMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
        .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.class,
            com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.Builder.class);
  }

  public static final int DATABASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object database_ = "";
  /**
   *
   *
   * <pre>
   * The database being modified.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The database.
   */
  @java.lang.Override
  public java.lang.String getDatabase() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      database_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The database being modified.
   * </pre>
   *
   * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for database.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseBytes() {
    java.lang.Object ref = database_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      database_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATEMENTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList statements_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @return A list containing the statements.
   */
  public com.google.protobuf.ProtocolStringList getStatementsList() {
    return statements_;
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @return The count of statements.
   */
  public int getStatementsCount() {
    return statements_.size();
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The statements at the given index.
   */
  public java.lang.String getStatements(int index) {
    return statements_.get(index);
  }
  /**
   *
   *
   * <pre>
   * For an update this list contains all the statements. For an
   * individual statement, this list contains only that statement.
   * </pre>
   *
   * <code>repeated string statements = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the statements at the given index.
   */
  public com.google.protobuf.ByteString getStatementsBytes(int index) {
    return statements_.getByteString(index);
  }

  public static final int COMMIT_TIMESTAMPS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Timestamp> commitTimestamps_;
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Timestamp> getCommitTimestampsList() {
    return commitTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.TimestampOrBuilder>
      getCommitTimestampsOrBuilderList() {
    return commitTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public int getCommitTimestampsCount() {
    return commitTimestamps_.size();
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCommitTimestamps(int index) {
    return commitTimestamps_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Reports the commit timestamps of all statements that have
   * succeeded so far, where `commit_timestamps[i]` is the commit
   * timestamp for the statement `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCommitTimestampsOrBuilder(int index) {
    return commitTimestamps_.get(index);
  }

  public static final int THROTTLED_FIELD_NUMBER = 4;
  private boolean throttled_ = false;
  /**
   *
   *
   * <pre>
   * Output only. When true, indicates that the operation is throttled e.g.
   * due to resource constraints. When resources become available the operation
   * will resume and this field will be false again.
   * </pre>
   *
   * <code>bool throttled = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The throttled.
   */
  @java.lang.Override
  public boolean getThrottled() {
    return throttled_;
  }

  public static final int PROGRESS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.OperationProgress> progress_;
  /**
   *
   *
   * <pre>
   * The progress of the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
   * operations. All DDL statements will have continuously updating progress,
   * and `progress[i]` is the operation progress for `statements[i]`. Also,
   * `progress[i]` will have start time and end time populated with commit
   * timestamp of operation, as well as a progress of 100% once the operation
   * has completed.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.OperationProgress> getProgressList() {
    return progress_;
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
   * operations. All DDL statements will have continuously updating progress,
   * and `progress[i]` is the operation progress for `statements[i]`. Also,
   * `progress[i]` will have start time and end time populated with commit
   * timestamp of operation, as well as a progress of 100% once the operation
   * has completed.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
      getProgressOrBuilderList() {
    return progress_;
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
   * operations. All DDL statements will have continuously updating progress,
   * and `progress[i]` is the operation progress for `statements[i]`. Also,
   * `progress[i]` will have start time and end time populated with commit
   * timestamp of operation, as well as a progress of 100% once the operation
   * has completed.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public int getProgressCount() {
    return progress_.size();
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
   * operations. All DDL statements will have continuously updating progress,
   * and `progress[i]` is the operation progress for `statements[i]`. Also,
   * `progress[i]` will have start time and end time populated with commit
   * timestamp of operation, as well as a progress of 100% once the operation
   * has completed.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgress getProgress(int index) {
    return progress_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The progress of the
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
   * operations. All DDL statements will have continuously updating progress,
   * and `progress[i]` is the operation progress for `statements[i]`. Also,
   * `progress[i]` will have start time and end time populated with commit
   * timestamp of operation, as well as a progress of 100% once the operation
   * has completed.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder(
      int index) {
    return progress_.get(index);
  }

  public static final int ACTIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.spanner.admin.database.v1.DdlStatementActionInfo> actions_;
  /**
   *
   *
   * <pre>
   * The brief action info for the DDL statements.
   * `actions[i]` is the brief info for `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.spanner.admin.database.v1.DdlStatementActionInfo>
      getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * The brief action info for the DDL statements.
   * `actions[i]` is the brief info for `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * The brief action info for the DDL statements.
   * `actions[i]` is the brief info for `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * The brief action info for the DDL statements.
   * `actions[i]` is the brief info for `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DdlStatementActionInfo getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The brief action info for the DDL statements.
   * `actions[i]` is the brief info for `statements[i]`.
   * </pre>
   *
   * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder getActionsOrBuilder(
      int index) {
    return actions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, database_);
    }
    for (int i = 0; i < statements_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, statements_.getRaw(i));
    }
    for (int i = 0; i < commitTimestamps_.size(); i++) {
      output.writeMessage(3, commitTimestamps_.get(i));
    }
    if (throttled_ != false) {
      output.writeBool(4, throttled_);
    }
    for (int i = 0; i < progress_.size(); i++) {
      output.writeMessage(5, progress_.get(i));
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(6, actions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(database_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, database_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < statements_.size(); i++) {
        dataSize += computeStringSizeNoTag(statements_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStatementsList().size();
    }
    for (int i = 0; i < commitTimestamps_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, commitTimestamps_.get(i));
    }
    if (throttled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, throttled_);
    }
    for (int i = 0; i < progress_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, progress_.get(i));
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, actions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata other =
        (com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) obj;

    if (!getDatabase().equals(other.getDatabase())) return false;
    if (!getStatementsList().equals(other.getStatementsList())) return false;
    if (!getCommitTimestampsList().equals(other.getCommitTimestampsList())) return false;
    if (getThrottled() != other.getThrottled()) return false;
    if (!getProgressList().equals(other.getProgressList())) return false;
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATABASE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabase().hashCode();
    if (getStatementsCount() > 0) {
      hash = (37 * hash) + STATEMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getStatementsList().hashCode();
    }
    if (getCommitTimestampsCount() > 0) {
      hash = (37 * hash) + COMMIT_TIMESTAMPS_FIELD_NUMBER;
      hash = (53 * hash) + getCommitTimestampsList().hashCode();
    }
    hash = (37 * hash) + THROTTLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getThrottled());
    if (getProgressCount() > 0) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgressList().hashCode();
    }
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata type for the operation returned by
   * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.class,
              com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      database_ = "";
      statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (commitTimestampsBuilder_ == null) {
        commitTimestamps_ = java.util.Collections.emptyList();
      } else {
        commitTimestamps_ = null;
        commitTimestampsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      throttled_ = false;
      if (progressBuilder_ == null) {
        progress_ = java.util.Collections.emptyList();
      } else {
        progress_ = null;
        progressBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto
          .internal_static_google_spanner_admin_database_v1_UpdateDatabaseDdlMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
        getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata build() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata buildPartial() {
      com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result =
          new com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result) {
      if (commitTimestampsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          commitTimestamps_ = java.util.Collections.unmodifiableList(commitTimestamps_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.commitTimestamps_ = commitTimestamps_;
      } else {
        result.commitTimestamps_ = commitTimestampsBuilder_.build();
      }
      if (progressBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          progress_ = java.util.Collections.unmodifiableList(progress_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.progress_ = progress_;
      } else {
        result.progress_ = progressBuilder_.build();
      }
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.database_ = database_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        statements_.makeImmutable();
        result.statements_ = statements_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.throttled_ = throttled_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) {
        return mergeFrom((com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata other) {
      if (other
          == com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata.getDefaultInstance())
        return this;
      if (!other.getDatabase().isEmpty()) {
        database_ = other.database_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.statements_.isEmpty()) {
        if (statements_.isEmpty()) {
          statements_ = other.statements_;
          bitField0_ |= 0x00000002;
        } else {
          ensureStatementsIsMutable();
          statements_.addAll(other.statements_);
        }
        onChanged();
      }
      if (commitTimestampsBuilder_ == null) {
        if (!other.commitTimestamps_.isEmpty()) {
          if (commitTimestamps_.isEmpty()) {
            commitTimestamps_ = other.commitTimestamps_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureCommitTimestampsIsMutable();
            commitTimestamps_.addAll(other.commitTimestamps_);
          }
          onChanged();
        }
      } else {
        if (!other.commitTimestamps_.isEmpty()) {
          if (commitTimestampsBuilder_.isEmpty()) {
            commitTimestampsBuilder_.dispose();
            commitTimestampsBuilder_ = null;
            commitTimestamps_ = other.commitTimestamps_;
            bitField0_ = (bitField0_ & ~0x00000004);
            commitTimestampsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCommitTimestampsFieldBuilder()
                    : null;
          } else {
            commitTimestampsBuilder_.addAllMessages(other.commitTimestamps_);
          }
        }
      }
      if (other.getThrottled() != false) {
        setThrottled(other.getThrottled());
      }
      if (progressBuilder_ == null) {
        if (!other.progress_.isEmpty()) {
          if (progress_.isEmpty()) {
            progress_ = other.progress_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureProgressIsMutable();
            progress_.addAll(other.progress_);
          }
          onChanged();
        }
      } else {
        if (!other.progress_.isEmpty()) {
          if (progressBuilder_.isEmpty()) {
            progressBuilder_.dispose();
            progressBuilder_ = null;
            progress_ = other.progress_;
            bitField0_ = (bitField0_ & ~0x00000010);
            progressBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProgressFieldBuilder()
                    : null;
          } else {
            progressBuilder_.addAllMessages(other.progress_);
          }
        }
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000020);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                database_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStatementsIsMutable();
                statements_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Timestamp m =
                    input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (commitTimestampsBuilder_ == null) {
                  ensureCommitTimestampsIsMutable();
                  commitTimestamps_.add(m);
                } else {
                  commitTimestampsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                throttled_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.spanner.admin.database.v1.OperationProgress m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.OperationProgress.parser(),
                        extensionRegistry);
                if (progressBuilder_ == null) {
                  ensureProgressIsMutable();
                  progress_.add(m);
                } else {
                  progressBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.spanner.admin.database.v1.DdlStatementActionInfo m =
                    input.readMessage(
                        com.google.spanner.admin.database.v1.DdlStatementActionInfo.parser(),
                        extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object database_ = "";
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The database.
     */
    public java.lang.String getDatabase() {
      java.lang.Object ref = database_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        database_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for database.
     */
    public com.google.protobuf.ByteString getDatabaseBytes() {
      java.lang.Object ref = database_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        database_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabase() {
      database_ = getDefaultInstance().getDatabase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The database being modified.
     * </pre>
     *
     * <code>string database = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for database to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      database_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList statements_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStatementsIsMutable() {
      if (!statements_.isModifiable()) {
        statements_ = new com.google.protobuf.LazyStringArrayList(statements_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return A list containing the statements.
     */
    public com.google.protobuf.ProtocolStringList getStatementsList() {
      statements_.makeImmutable();
      return statements_;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return The count of statements.
     */
    public int getStatementsCount() {
      return statements_.size();
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The statements at the given index.
     */
    public java.lang.String getStatements(int index) {
      return statements_.get(index);
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the statements at the given index.
     */
    public com.google.protobuf.ByteString getStatementsBytes(int index) {
      return statements_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The statements to set.
     * @return This builder for chaining.
     */
    public Builder setStatements(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param value The statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatements(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStatementsIsMutable();
      statements_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param values The statements to add.
     * @return This builder for chaining.
     */
    public Builder addAllStatements(java.lang.Iterable<java.lang.String> values) {
      ensureStatementsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statements_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatements() {
      statements_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For an update this list contains all the statements. For an
     * individual statement, this list contains only that statement.
     * </pre>
     *
     * <code>repeated string statements = 2;</code>
     *
     * @param value The bytes of the statements to add.
     * @return This builder for chaining.
     */
    public Builder addStatementsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStatementsIsMutable();
      statements_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Timestamp> commitTimestamps_ =
        java.util.Collections.emptyList();

    private void ensureCommitTimestampsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        commitTimestamps_ =
            new java.util.ArrayList<com.google.protobuf.Timestamp>(commitTimestamps_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        commitTimestampsBuilder_;

    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<com.google.protobuf.Timestamp> getCommitTimestampsList() {
      if (commitTimestampsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(commitTimestamps_);
      } else {
        return commitTimestampsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public int getCommitTimestampsCount() {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.size();
      } else {
        return commitTimestampsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp getCommitTimestamps(int index) {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.get(index);
      } else {
        return commitTimestampsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder setCommitTimestamps(int index, com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.set(index, value);
        onChanged();
      } else {
        commitTimestampsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder setCommitTimestamps(
        int index, com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.set(index, builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(value);
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(int index, com.google.protobuf.Timestamp value) {
      if (commitTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(index, value);
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addCommitTimestamps(
        int index, com.google.protobuf.Timestamp.Builder builderForValue) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.add(index, builderForValue.build());
        onChanged();
      } else {
        commitTimestampsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder addAllCommitTimestamps(
        java.lang.Iterable<? extends com.google.protobuf.Timestamp> values) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, commitTimestamps_);
        onChanged();
      } else {
        commitTimestampsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder clearCommitTimestamps() {
      if (commitTimestampsBuilder_ == null) {
        commitTimestamps_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        commitTimestampsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public Builder removeCommitTimestamps(int index) {
      if (commitTimestampsBuilder_ == null) {
        ensureCommitTimestampsIsMutable();
        commitTimestamps_.remove(index);
        onChanged();
      } else {
        commitTimestampsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCommitTimestampsBuilder(int index) {
      return getCommitTimestampsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampsOrBuilder(int index) {
      if (commitTimestampsBuilder_ == null) {
        return commitTimestamps_.get(index);
      } else {
        return commitTimestampsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.TimestampOrBuilder>
        getCommitTimestampsOrBuilderList() {
      if (commitTimestampsBuilder_ != null) {
        return commitTimestampsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(commitTimestamps_);
      }
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder addCommitTimestampsBuilder() {
      return getCommitTimestampsFieldBuilder()
          .addBuilder(com.google.protobuf.Timestamp.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder addCommitTimestampsBuilder(int index) {
      return getCommitTimestampsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Timestamp.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Reports the commit timestamps of all statements that have
     * succeeded so far, where `commit_timestamps[i]` is the commit
     * timestamp for the statement `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.protobuf.Timestamp commit_timestamps = 3;</code>
     */
    public java.util.List<com.google.protobuf.Timestamp.Builder> getCommitTimestampsBuilderList() {
      return getCommitTimestampsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCommitTimestampsFieldBuilder() {
      if (commitTimestampsBuilder_ == null) {
        commitTimestampsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                commitTimestamps_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        commitTimestamps_ = null;
      }
      return commitTimestampsBuilder_;
    }

    private boolean throttled_;
    /**
     *
     *
     * <pre>
     * Output only. When true, indicates that the operation is throttled e.g.
     * due to resource constraints. When resources become available the operation
     * will resume and this field will be false again.
     * </pre>
     *
     * <code>bool throttled = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The throttled.
     */
    @java.lang.Override
    public boolean getThrottled() {
      return throttled_;
    }
    /**
     *
     *
     * <pre>
     * Output only. When true, indicates that the operation is throttled e.g.
     * due to resource constraints. When resources become available the operation
     * will resume and this field will be false again.
     * </pre>
     *
     * <code>bool throttled = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The throttled to set.
     * @return This builder for chaining.
     */
    public Builder setThrottled(boolean value) {

      throttled_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. When true, indicates that the operation is throttled e.g.
     * due to resource constraints. When resources become available the operation
     * will resume and this field will be false again.
     * </pre>
     *
     * <code>bool throttled = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearThrottled() {
      bitField0_ = (bitField0_ & ~0x00000008);
      throttled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.spanner.admin.database.v1.OperationProgress> progress_ =
        java.util.Collections.emptyList();

    private void ensureProgressIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        progress_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.OperationProgress>(
                progress_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        progressBuilder_;

    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.OperationProgress>
        getProgressList() {
      if (progressBuilder_ == null) {
        return java.util.Collections.unmodifiableList(progress_);
      } else {
        return progressBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public int getProgressCount() {
      if (progressBuilder_ == null) {
        return progress_.size();
      } else {
        return progressBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress getProgress(int index) {
      if (progressBuilder_ == null) {
        return progress_.get(index);
      } else {
        return progressBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder setProgress(
        int index, com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProgressIsMutable();
        progress_.set(index, value);
        onChanged();
      } else {
        progressBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder setProgress(
        int index, com.google.spanner.admin.database.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        ensureProgressIsMutable();
        progress_.set(index, builderForValue.build());
        onChanged();
      } else {
        progressBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder addProgress(com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProgressIsMutable();
        progress_.add(value);
        onChanged();
      } else {
        progressBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder addProgress(
        int index, com.google.spanner.admin.database.v1.OperationProgress value) {
      if (progressBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProgressIsMutable();
        progress_.add(index, value);
        onChanged();
      } else {
        progressBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder addProgress(
        com.google.spanner.admin.database.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        ensureProgressIsMutable();
        progress_.add(builderForValue.build());
        onChanged();
      } else {
        progressBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder addProgress(
        int index, com.google.spanner.admin.database.v1.OperationProgress.Builder builderForValue) {
      if (progressBuilder_ == null) {
        ensureProgressIsMutable();
        progress_.add(index, builderForValue.build());
        onChanged();
      } else {
        progressBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder addAllProgress(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.OperationProgress>
            values) {
      if (progressBuilder_ == null) {
        ensureProgressIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, progress_);
        onChanged();
      } else {
        progressBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder clearProgress() {
      if (progressBuilder_ == null) {
        progress_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        progressBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public Builder removeProgress(int index) {
      if (progressBuilder_ == null) {
        ensureProgressIsMutable();
        progress_.remove(index);
        onChanged();
      } else {
        progressBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress.Builder getProgressBuilder(
        int index) {
      return getProgressFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgressOrBuilder getProgressOrBuilder(
        int index) {
      if (progressBuilder_ == null) {
        return progress_.get(index);
      } else {
        return progressBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public java.util.List<? extends com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        getProgressOrBuilderList() {
      if (progressBuilder_ != null) {
        return progressBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(progress_);
      }
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress.Builder addProgressBuilder() {
      return getProgressFieldBuilder()
          .addBuilder(com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public com.google.spanner.admin.database.v1.OperationProgress.Builder addProgressBuilder(
        int index) {
      return getProgressFieldBuilder()
          .addBuilder(
              index, com.google.spanner.admin.database.v1.OperationProgress.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The progress of the
     * [UpdateDatabaseDdl][google.spanner.admin.database.v1.DatabaseAdmin.UpdateDatabaseDdl]
     * operations. All DDL statements will have continuously updating progress,
     * and `progress[i]` is the operation progress for `statements[i]`. Also,
     * `progress[i]` will have start time and end time populated with commit
     * timestamp of operation, as well as a progress of 100% once the operation
     * has completed.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.OperationProgress progress = 5;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.OperationProgress.Builder>
        getProgressBuilderList() {
      return getProgressFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.OperationProgress,
            com.google.spanner.admin.database.v1.OperationProgress.Builder,
            com.google.spanner.admin.database.v1.OperationProgressOrBuilder>
        getProgressFieldBuilder() {
      if (progressBuilder_ == null) {
        progressBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.OperationProgress,
                com.google.spanner.admin.database.v1.OperationProgress.Builder,
                com.google.spanner.admin.database.v1.OperationProgressOrBuilder>(
                progress_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        progress_ = null;
      }
      return progressBuilder_;
    }

    private java.util.List<com.google.spanner.admin.database.v1.DdlStatementActionInfo> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        actions_ =
            new java.util.ArrayList<com.google.spanner.admin.database.v1.DdlStatementActionInfo>(
                actions_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.DdlStatementActionInfo,
            com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder,
            com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.DdlStatementActionInfo>
        getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public com.google.spanner.admin.database.v1.DdlStatementActionInfo getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder setActions(
        int index, com.google.spanner.admin.database.v1.DdlStatementActionInfo value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder setActions(
        int index,
        com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder addActions(com.google.spanner.admin.database.v1.DdlStatementActionInfo value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder addActions(
        int index, com.google.spanner.admin.database.v1.DdlStatementActionInfo value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder addActions(
        com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder addActions(
        int index,
        com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.spanner.admin.database.v1.DdlStatementActionInfo>
            values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder getActionsBuilder(
        int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder getActionsOrBuilder(
        int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public java.util.List<
            ? extends com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(
              com.google.spanner.admin.database.v1.DdlStatementActionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder addActionsBuilder(
        int index) {
      return getActionsFieldBuilder()
          .addBuilder(
              index,
              com.google.spanner.admin.database.v1.DdlStatementActionInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The brief action info for the DDL statements.
     * `actions[i]` is the brief info for `statements[i]`.
     * </pre>
     *
     * <code>repeated .google.spanner.admin.database.v1.DdlStatementActionInfo actions = 6;</code>
     */
    public java.util.List<com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder>
        getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.database.v1.DdlStatementActionInfo,
            com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder,
            com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.database.v1.DdlStatementActionInfo,
                com.google.spanner.admin.database.v1.DdlStatementActionInfo.Builder,
                com.google.spanner.admin.database.v1.DdlStatementActionInfoOrBuilder>(
                actions_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata)
  private static final com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata();
  }

  public static com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> PARSER =
      new com.google.protobuf.AbstractParser<UpdateDatabaseDdlMetadata>() {
        @java.lang.Override
        public UpdateDatabaseDdlMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateDatabaseDdlMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
