/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1/cloud_speech.proto

package com.google.cloud.speech.v1;

/**
 *
 *
 * <pre>
 * `StreamingRecognizeResponse` is the only message returned to the client by
 * `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
 * messages are streamed back to the client. If there is no recognizable
 * audio, and `single_utterance` is set to false, then no messages are streamed
 * back to the client.
 * Here's an example of a series of `StreamingRecognizeResponse`s that might be
 * returned while processing audio:
 * 1. results { alternatives { transcript: "tube" } stability: 0.01 }
 * 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
 * 3. results { alternatives { transcript: "to be" } stability: 0.9 }
 *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
 * 4. results { alternatives { transcript: "to be or not to be"
 *                             confidence: 0.92 }
 *              alternatives { transcript: "to bee or not to bee" }
 *              is_final: true }
 * 5. results { alternatives { transcript: " that's" } stability: 0.01 }
 * 6. results { alternatives { transcript: " that is" } stability: 0.9 }
 *    results { alternatives { transcript: " the question" } stability: 0.01 }
 * 7. results { alternatives { transcript: " that is the question"
 *                             confidence: 0.98 }
 *              alternatives { transcript: " that was the question" }
 *              is_final: true }
 * Notes:
 * - Only two of the above responses #4 and #7 contain final results; they are
 *   indicated by `is_final: true`. Concatenating these together generates the
 *   full transcript: "to be or not to be that is the question".
 * - The others contain interim `results`. #3 and #6 contain two interim
 *   `results`: the first portion has a high stability and is less likely to
 *   change; the second portion has a low stability and is very likely to
 *   change. A UI designer might choose to show only high stability `results`.
 * - The specific `stability` and `confidence` values shown above are only for
 *   illustrative purposes. Actual values may vary.
 * - In each response, only one of these fields will be set:
 *     `error`,
 *     `speech_event_type`, or
 *     one or more (repeated) `results`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1.StreamingRecognizeResponse}
 */
public final class StreamingRecognizeResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1.StreamingRecognizeResponse)
    StreamingRecognizeResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingRecognizeResponse.newBuilder() to construct.
  private StreamingRecognizeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingRecognizeResponse() {
    results_ = java.util.Collections.emptyList();
    speechEventType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingRecognizeResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StreamingRecognizeResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                results_ =
                    new java.util.ArrayList<
                        com.google.cloud.speech.v1.StreamingRecognitionResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              results_.add(
                  input.readMessage(
                      com.google.cloud.speech.v1.StreamingRecognitionResult.parser(),
                      extensionRegistry));
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              speechEventType_ = rawValue;
              break;
            }
          case 42:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (totalBilledTime_ != null) {
                subBuilder = totalBilledTime_.toBuilder();
              }
              totalBilledTime_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(totalBilledTime_);
                totalBilledTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        results_ = java.util.Collections.unmodifiableList(results_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_StreamingRecognizeResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1.SpeechProto
        .internal_static_google_cloud_speech_v1_StreamingRecognizeResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1.StreamingRecognizeResponse.class,
            com.google.cloud.speech.v1.StreamingRecognizeResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of speech event.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType}
   */
  public enum SpeechEventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No speech event specified.
     * </pre>
     *
     * <code>SPEECH_EVENT_UNSPECIFIED = 0;</code>
     */
    SPEECH_EVENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This event indicates that the server has detected the end of the user's
     * speech utterance and expects no additional speech. Therefore, the server
     * will not process additional audio (although it may subsequently return
     * additional results). The client should stop sending additional audio
     * data, half-close the gRPC connection, and wait for any additional results
     * until the server closes the gRPC connection. This event is only sent if
     * `single_utterance` was set to `true`, and is not used otherwise.
     * </pre>
     *
     * <code>END_OF_SINGLE_UTTERANCE = 1;</code>
     */
    END_OF_SINGLE_UTTERANCE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No speech event specified.
     * </pre>
     *
     * <code>SPEECH_EVENT_UNSPECIFIED = 0;</code>
     */
    public static final int SPEECH_EVENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This event indicates that the server has detected the end of the user's
     * speech utterance and expects no additional speech. Therefore, the server
     * will not process additional audio (although it may subsequently return
     * additional results). The client should stop sending additional audio
     * data, half-close the gRPC connection, and wait for any additional results
     * until the server closes the gRPC connection. This event is only sent if
     * `single_utterance` was set to `true`, and is not used otherwise.
     * </pre>
     *
     * <code>END_OF_SINGLE_UTTERANCE = 1;</code>
     */
    public static final int END_OF_SINGLE_UTTERANCE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpeechEventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpeechEventType forNumber(int value) {
      switch (value) {
        case 0:
          return SPEECH_EVENT_UNSPECIFIED;
        case 1:
          return END_OF_SINGLE_UTTERANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpeechEventType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpeechEventType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SpeechEventType>() {
              public SpeechEventType findValueByNumber(int number) {
                return SpeechEventType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.speech.v1.StreamingRecognizeResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SpeechEventType[] VALUES = values();

    public static SpeechEventType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpeechEventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType)
  }

  public static final int ERROR_FIELD_NUMBER = 1;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int RESULTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.speech.v1.StreamingRecognitionResult> results_;
  /**
   *
   *
   * <pre>
   * This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results (the interim results).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.speech.v1.StreamingRecognitionResult> getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results (the interim results).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results (the interim results).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results (the interim results).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.StreamingRecognitionResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results (the interim results).
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int SPEECH_EVENT_TYPE_FIELD_NUMBER = 4;
  private int speechEventType_;
  /**
   *
   *
   * <pre>
   * Indicates the type of speech event.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
   * </code>
   *
   * @return The enum numeric value on the wire for speechEventType.
   */
  @java.lang.Override
  public int getSpeechEventTypeValue() {
    return speechEventType_;
  }
  /**
   *
   *
   * <pre>
   * Indicates the type of speech event.
   * </pre>
   *
   * <code>.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
   * </code>
   *
   * @return The speechEventType.
   */
  @java.lang.Override
  public com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType
      getSpeechEventType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType result =
        com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType.valueOf(
            speechEventType_);
    return result == null
        ? com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType.UNRECOGNIZED
        : result;
  }

  public static final int TOTAL_BILLED_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration totalBilledTime_;
  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the stream.
   * Set only if this is the last response in the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 5;</code>
   *
   * @return Whether the totalBilledTime field is set.
   */
  @java.lang.Override
  public boolean hasTotalBilledTime() {
    return totalBilledTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the stream.
   * Set only if this is the last response in the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 5;</code>
   *
   * @return The totalBilledTime.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTotalBilledTime() {
    return totalBilledTime_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalBilledTime_;
  }
  /**
   *
   *
   * <pre>
   * When available, billed audio seconds for the stream.
   * Set only if this is the last response in the stream.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_billed_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTotalBilledTimeOrBuilder() {
    return getTotalBilledTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (error_ != null) {
      output.writeMessage(1, getError());
    }
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(2, results_.get(i));
    }
    if (speechEventType_
        != com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType
            .SPEECH_EVENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, speechEventType_);
    }
    if (totalBilledTime_ != null) {
      output.writeMessage(5, getTotalBilledTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getError());
    }
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
    }
    if (speechEventType_
        != com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType
            .SPEECH_EVENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, speechEventType_);
    }
    if (totalBilledTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getTotalBilledTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1.StreamingRecognizeResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1.StreamingRecognizeResponse other =
        (com.google.cloud.speech.v1.StreamingRecognizeResponse) obj;

    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getResultsList().equals(other.getResultsList())) return false;
    if (speechEventType_ != other.speechEventType_) return false;
    if (hasTotalBilledTime() != other.hasTotalBilledTime()) return false;
    if (hasTotalBilledTime()) {
      if (!getTotalBilledTime().equals(other.getTotalBilledTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    hash = (37 * hash) + SPEECH_EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + speechEventType_;
    if (hasTotalBilledTime()) {
      hash = (37 * hash) + TOTAL_BILLED_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getTotalBilledTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v1.StreamingRecognizeResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `StreamingRecognizeResponse` is the only message returned to the client by
   * `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
   * messages are streamed back to the client. If there is no recognizable
   * audio, and `single_utterance` is set to false, then no messages are streamed
   * back to the client.
   * Here's an example of a series of `StreamingRecognizeResponse`s that might be
   * returned while processing audio:
   * 1. results { alternatives { transcript: "tube" } stability: 0.01 }
   * 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
   * 3. results { alternatives { transcript: "to be" } stability: 0.9 }
   *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
   * 4. results { alternatives { transcript: "to be or not to be"
   *                             confidence: 0.92 }
   *              alternatives { transcript: "to bee or not to bee" }
   *              is_final: true }
   * 5. results { alternatives { transcript: " that's" } stability: 0.01 }
   * 6. results { alternatives { transcript: " that is" } stability: 0.9 }
   *    results { alternatives { transcript: " the question" } stability: 0.01 }
   * 7. results { alternatives { transcript: " that is the question"
   *                             confidence: 0.98 }
   *              alternatives { transcript: " that was the question" }
   *              is_final: true }
   * Notes:
   * - Only two of the above responses #4 and #7 contain final results; they are
   *   indicated by `is_final: true`. Concatenating these together generates the
   *   full transcript: "to be or not to be that is the question".
   * - The others contain interim `results`. #3 and #6 contain two interim
   *   `results`: the first portion has a high stability and is less likely to
   *   change; the second portion has a low stability and is very likely to
   *   change. A UI designer might choose to show only high stability `results`.
   * - The specific `stability` and `confidence` values shown above are only for
   *   illustrative purposes. Actual values may vary.
   * - In each response, only one of these fields will be set:
   *     `error`,
   *     `speech_event_type`, or
   *     one or more (repeated) `results`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1.StreamingRecognizeResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1.StreamingRecognizeResponse)
      com.google.cloud.speech.v1.StreamingRecognizeResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_StreamingRecognizeResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_StreamingRecognizeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1.StreamingRecognizeResponse.class,
              com.google.cloud.speech.v1.StreamingRecognizeResponse.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1.StreamingRecognizeResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        resultsBuilder_.clear();
      }
      speechEventType_ = 0;

      if (totalBilledTimeBuilder_ == null) {
        totalBilledTime_ = null;
      } else {
        totalBilledTime_ = null;
        totalBilledTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1.SpeechProto
          .internal_static_google_cloud_speech_v1_StreamingRecognizeResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.StreamingRecognizeResponse getDefaultInstanceForType() {
      return com.google.cloud.speech.v1.StreamingRecognizeResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.StreamingRecognizeResponse build() {
      com.google.cloud.speech.v1.StreamingRecognizeResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.speech.v1.StreamingRecognizeResponse buildPartial() {
      com.google.cloud.speech.v1.StreamingRecognizeResponse result =
          new com.google.cloud.speech.v1.StreamingRecognizeResponse(this);
      int from_bitField0_ = bitField0_;
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      result.speechEventType_ = speechEventType_;
      if (totalBilledTimeBuilder_ == null) {
        result.totalBilledTime_ = totalBilledTime_;
      } else {
        result.totalBilledTime_ = totalBilledTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1.StreamingRecognizeResponse) {
        return mergeFrom((com.google.cloud.speech.v1.StreamingRecognizeResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1.StreamingRecognizeResponse other) {
      if (other == com.google.cloud.speech.v1.StreamingRecognizeResponse.getDefaultInstance())
        return this;
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000001);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.speechEventType_ != 0) {
        setSpeechEventTypeValue(other.getSpeechEventTypeValue());
      }
      if (other.hasTotalBilledTime()) {
        mergeTotalBilledTime(other.getTotalBilledTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.speech.v1.StreamingRecognizeResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.speech.v1.StreamingRecognizeResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<com.google.cloud.speech.v1.StreamingRecognitionResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.speech.v1.StreamingRecognitionResult>(
                results_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.StreamingRecognitionResult,
            com.google.cloud.speech.v1.StreamingRecognitionResult.Builder,
            com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.StreamingRecognitionResult> getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.StreamingRecognitionResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(com.google.cloud.speech.v1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        com.google.cloud.speech.v1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.speech.v1.StreamingRecognitionResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.StreamingRecognitionResult.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.StreamingRecognitionResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(com.google.cloud.speech.v1.StreamingRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1.StreamingRecognitionResult.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.speech.v1.StreamingRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results (the interim results).
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1.StreamingRecognitionResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1.StreamingRecognitionResult,
            com.google.cloud.speech.v1.StreamingRecognitionResult.Builder,
            com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1.StreamingRecognitionResult,
                com.google.cloud.speech.v1.StreamingRecognitionResult.Builder,
                com.google.cloud.speech.v1.StreamingRecognitionResultOrBuilder>(
                results_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private int speechEventType_ = 0;
    /**
     *
     *
     * <pre>
     * Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for speechEventType.
     */
    @java.lang.Override
    public int getSpeechEventTypeValue() {
      return speechEventType_;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for speechEventType to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechEventTypeValue(int value) {

      speechEventType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
     * </code>
     *
     * @return The speechEventType.
     */
    @java.lang.Override
    public com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType
        getSpeechEventType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType result =
          com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType.valueOf(
              speechEventType_);
      return result == null
          ? com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
     * </code>
     *
     * @param value The speechEventType to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechEventType(
        com.google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      speechEventType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1.StreamingRecognizeResponse.SpeechEventType speech_event_type = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeechEventType() {

      speechEventType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration totalBilledTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        totalBilledTimeBuilder_;
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     *
     * @return Whether the totalBilledTime field is set.
     */
    public boolean hasTotalBilledTime() {
      return totalBilledTimeBuilder_ != null || totalBilledTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     *
     * @return The totalBilledTime.
     */
    public com.google.protobuf.Duration getTotalBilledTime() {
      if (totalBilledTimeBuilder_ == null) {
        return totalBilledTime_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalBilledTime_;
      } else {
        return totalBilledTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public Builder setTotalBilledTime(com.google.protobuf.Duration value) {
      if (totalBilledTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        totalBilledTime_ = value;
        onChanged();
      } else {
        totalBilledTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public Builder setTotalBilledTime(com.google.protobuf.Duration.Builder builderForValue) {
      if (totalBilledTimeBuilder_ == null) {
        totalBilledTime_ = builderForValue.build();
        onChanged();
      } else {
        totalBilledTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public Builder mergeTotalBilledTime(com.google.protobuf.Duration value) {
      if (totalBilledTimeBuilder_ == null) {
        if (totalBilledTime_ != null) {
          totalBilledTime_ =
              com.google.protobuf.Duration.newBuilder(totalBilledTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          totalBilledTime_ = value;
        }
        onChanged();
      } else {
        totalBilledTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public Builder clearTotalBilledTime() {
      if (totalBilledTimeBuilder_ == null) {
        totalBilledTime_ = null;
        onChanged();
      } else {
        totalBilledTime_ = null;
        totalBilledTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getTotalBilledTimeBuilder() {

      onChanged();
      return getTotalBilledTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTotalBilledTimeOrBuilder() {
      if (totalBilledTimeBuilder_ != null) {
        return totalBilledTimeBuilder_.getMessageOrBuilder();
      } else {
        return totalBilledTime_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalBilledTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * When available, billed audio seconds for the stream.
     * Set only if this is the last response in the stream.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_billed_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTotalBilledTimeFieldBuilder() {
      if (totalBilledTimeBuilder_ == null) {
        totalBilledTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTotalBilledTime(), getParentForChildren(), isClean());
        totalBilledTime_ = null;
      }
      return totalBilledTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1.StreamingRecognizeResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1.StreamingRecognizeResponse)
  private static final com.google.cloud.speech.v1.StreamingRecognizeResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1.StreamingRecognizeResponse();
  }

  public static com.google.cloud.speech.v1.StreamingRecognizeResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingRecognizeResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingRecognizeResponse>() {
        @java.lang.Override
        public StreamingRecognizeResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StreamingRecognizeResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StreamingRecognizeResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingRecognizeResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.speech.v1.StreamingRecognizeResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
